# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:33:23+00:00

from __future__ import annotations

import uuid
from enum import Enum
from typing import Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class MethodEnum(Enum):
    retrieve = 'retrieve'
    update = 'update'
    add = 'add'
    delete = 'delete'


class Conjunction(Enum):
    and_ = 'and'
    or_ = 'or'


class WrongObject(Enum):
    expanded = 'expanded'
    compact = 'compact'
    hidden = 'hidden'


class Schema(Enum):
    create = 'create'
    update = 'update'
    output = 'output'
    query = 'query'


class AclAttribute(Enum):
    parent_name = 'parent_name'


class Notification(BaseModel):
    class Config:
        extra = Extra.forbid

    id: list[uuid.UUID] | None = None
    offset: conint(ge=0, multiple_of=1) | None = None
    limit: conint(ge=0, multiple_of=1) | None = None
    manufacturer: bool | None = None
    owned: bool | None = None
    accepted: bool | None = None
    shared_with: list[uuid.UUID] | None = None
    not_shared_with: list[uuid.UUID] | None = None
    has_parent: bool | None = None
    version: list[constr(regex=r'\d+(\.\d+)*')] | None = None
    method: list[MethodEnum] | None = None
    deep: conint(ge=1, multiple_of=1) | None = None
    global_: bool | None = Field(None, alias='global')
    full_search: bool | None = None
    from_last: bool | None = None
    order_by: str | None = None
    permission_group: list[Literal['all'] | uuid.UUID] | None = None
    clean: bool | None = None
    conjunction:  Conjunction | None = None
    count: bool | None = None
    asynchronous: bool | uuid.UUID | None = None
    propagate: bool | None = None
    acl_code: uuid.UUID | None = None
    expand: conint(ge=0, multiple_of=1) | None = None
    quantity: int | Literal['all'] | None = None
    message: str | None = None
    opt_attr: list[str] | None = None
    opt_value: list[str] | None = None
    verbose: bool | list[str] | None = None
    compact: list[str] | None = None
    fetch: bool | None = None
    go_internal: bool | None = None
    expand_from_bottom: bool | None = None
    wrong_object:  WrongObject | None = None
    cache: conint(ge=1, le=86400) | None = None
    cache_refresh: bool | None = None
    csv_name: str | None = None
    csv_separator: str | None = None
    prev_notification: uuid.UUID | None = None
    schema_: Schema | None = Field(None, alias='schema')
    test_mode: bool | None = None
    acl_attributes: list[AclAttribute] | None = None
