# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:38:00+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class MethodEnum(Enum):
    retrieve = 'retrieve'
    update = 'update'
    add = 'add'
    delete = 'delete'


class Conjunction(Enum):
    and_ = 'and'
    or_ = 'or'


class WrongObject(Enum):
    expanded = 'expanded'
    compact = 'compact'
    hidden = 'hidden'


class Schema(Enum):
    create = 'create'
    update = 'update'
    output = 'output'
    query = 'query'


class AclAttribute(Enum):
    parent_name = 'parent_name'


class ProviderItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    picture: str | None = None
    type: str


class PublicEnum(Enum):
    nickname = 'nickname'
    first_name = 'first_name'
    last_name = 'last_name'
    email = 'email'
    phone = 'phone'
    role = 'role'


class Status(Enum):
    pending = 'pending'
    refused = 'refused'
    accepted = 'accepted'
    send = 'send'
    not_sent = 'not_sent'
    archive = 'archive'


class OtherEmailItem(BaseModel):
    contact: constr(regex=r'^\S+@\S+\.\S+$') | None = None
    status: Status | None = None
    last_update: datetime.datetime | None = None


class OtherSm(BaseModel):
    contact: str | None = None
    status: Status | None = None
    last_update: datetime.datetime | None = None


class Type(Enum):
    soft = 'soft'
    strong = 'strong'


class Ban(BaseModel):
    type: Type
    begin_ban: datetime.datetime | None = None
    end_ban: datetime.datetime
    motivation: str


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Virtualuser(BaseModel):
    class Config:
        extra = Extra.forbid

    id: list[uuid.UUID] | None = None
    offset: conint(ge=0, multiple_of=1) | None = None
    limit: conint(ge=0, multiple_of=1) | None = None
    manufacturer: bool | None = None
    owned: bool | None = None
    accepted: bool | None = None
    shared_with: list[uuid.UUID] | None = None
    not_shared_with: list[uuid.UUID] | None = None
    has_parent: bool | None = None
    version: list[constr(regex=r'\d+(\.\d+)*')] | None = None
    method: list[MethodEnum] | None = None
    deep: conint(ge=1, multiple_of=1) | None = None
    global_: bool | None = Field(None, alias='global')
    full_search: bool | None = None
    from_last: bool | None = None
    order_by: str | None = None
    permission_group: list[Literal['all'] | uuid.UUID] | None = None
    clean: bool | None = None
    conjunction:  Conjunction | None = None
    count: bool | None = None
    asynchronous: bool | uuid.UUID | None = None
    propagate: bool | None = None
    acl_code: uuid.UUID | None = None
    expand: conint(ge=0, multiple_of=1) | None = None
    quantity: int | Literal['all'] | None = None
    message: str | None = None
    opt_attr: list[str] | None = None
    opt_value: list[str] | None = None
    verbose: bool | list[str] | None = None
    compact: list[str] | None = None
    fetch: bool | None = None
    go_internal: bool | None = None
    expand_from_bottom: bool | None = None
    wrong_object:  WrongObject | None = None
    cache: conint(ge=1, le=86400) | None = None
    cache_refresh: bool | None = None
    csv_name: str | None = None
    csv_separator: str | None = None
    prev_notification: uuid.UUID | None = None
    schema_: Schema | None = Field(None, alias='schema')
    test_mode: bool | None = None
    acl_attributes: list[AclAttribute] | None = None
    first_name: str | None = None
    last_name: str | None = None
    email: constr(regex=r'^\S+@\S+\.\S+$') | None = None
    phone: str | None = None
    name: str | None = None
    role: str | None = None
    nickname: str | None = None
    language: str | None = None
    friend: bool | None = None
    blocked: bool | None = None
    provider: list[ProviderItem] | None = None
    public: list[PublicEnum] | None = None
    verified_email: bool | None = None
    verified_sms: bool | None = None
    other_email: list[OtherEmailItem] | None = None
    other_sms: list[OtherSm] | None = None
    admin: bool | None = None
    founder: bool | None = None
    ban: Ban | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
