# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:26:55+00:00

from __future__ import annotations

import uuid
from enum import Enum

from pydantic import BaseModel, Extra, constr


class LevelEnum(Enum):
    founder = 'founder'
    admin = 'admin'
    sales = 'sales'
    empty = 'empty'
    custom = 'custom'


class Acces(BaseModel):
    pages: list[str] | None = None
    tabs: list[str] | None = None


class AclItem(BaseModel):
    change_manufacturer: bool | None = None
    change_owner: bool | None = None
    share_object: bool | None = None


class AdminItem(BaseModel):
    handle_admin: bool | None = None


class ApplicationItem(BaseModel):
    create_admin_application: bool | None = None
    delete_published: bool | None = None
    disable_and_reenable: bool | None = None
    handle_application_product: bool | None = None
    handle_publishing: bool | None = None
    retrieve_oauth_secrets: bool | None = None


class BillingItem(BaseModel):
    change_user_subscription: bool | None = None
    handle_subscription: bool | None = None
    handle_tax: bool | None = None
    show_stripe: bool | None = None


class CommunicationItem(BaseModel):
    create_translation: bool | None = None
    delete_translation: bool | None = None
    publish_translation: bool | None = None
    send_email: bool | None = None
    send_notification: bool | None = None
    send_sms: bool | None = None
    update_email: bool | None = None
    update_sms: bool | None = None
    update_translation: bool | None = None


class CustomerItem(BaseModel):
    handle_customer: bool | None = None
    handle_seller: bool | None = None
    list_customer: bool | None = None
    list_seller: bool | None = None


class CouchbaseItem(BaseModel):
    access_user_bucket: bool | None = None
    delete: bool | None = None
    retrieve: bool | None = None
    save: bool | None = None
    retrieve_meta: bool | None = None


class Documentation(BaseModel):
    access_admin_documentation: bool | None = None


class InstallationItem(BaseModel):
    restart_with_new_process: bool | None = None
    restart_with_new_user: bool | None = None
    retrieve_oauth_secret_token: bool | None = None
    stop_background: bool | None = None
    log_background: bool | None = None


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class MicroItem(BaseModel):
    read_environment: bool | None = None
    retrieve_micro: bool | None = None
    show_environment: bool | None = None
    show_grafana: bool | None = None
    update_environment: bool | None = None


class NetworkItem(BaseModel):
    contact_directly: bool | None = None
    update_creator: bool | None = None
    handle_firmware: bool | None = None


class RecoveryItem(BaseModel):
    recover_background: bool | None = None
    recover_cleanup: bool | None = None
    recover_repeat: bool | None = None


class Service(BaseModel):
    cockroach: bool | None = None
    full_search: bool | None = None
    n1ql: bool | None = None
    nats: bool | None = None


class SessionItem(BaseModel):
    write_permission: bool | None = None


class SupportItem(BaseModel):
    delete_historical: bool | None = None
    handle_cleanup_historical: bool | None = None
    handle_delayed_state: bool | None = None
    handle_pending: bool | None = None


class TransferItem(BaseModel):
    promote_application: bool | None = None
    promote_email_and_sms: bool | None = None
    promote_subscription: bool | None = None
    promote_translation: bool | None = None
    transfer_user: bool | None = None


class UiadminItem(BaseModel):
    show_create_object_button: bool | None = None
    show_delete_object_button: bool | None = None
    show_update_object_button: bool | None = None


class UserItem(BaseModel):
    ban_user: bool | None = None
    change_password: bool | None = None
    change_username: bool | None = None
    create_new_user: bool | None = None
    delete_user: bool | None = None
    reset_captcha: bool | None = None
    verify_communication: bool | None = None


class WalletItem(BaseModel):
    change_points: bool | None = None
    correct_points: bool | None = None
    reset_points: bool | None = None


class AdminFeature(BaseModel):
    class Config:
        extra = Extra.allow

    level:  LevelEnum | None = None
    access:  Acces | None = None
    acl:  AclItem | None = None
    admin:  AdminItem | None = None
    application:  ApplicationItem | None = None
    billing:  BillingItem | None = None
    communication:  CommunicationItem | None = None
    customer:  CustomerItem | None = None
    couchbase:  CouchbaseItem | None = None
    documentation:  Documentation | None = None
    installation:  InstallationItem | None = None
    meta:  MetaItem | None = None
    micro:  MicroItem | None = None
    network:  NetworkItem | None = None
    recovery:  RecoveryItem | None = None
    services:  Service | None = None
    session:  SessionItem | None = None
    support:  SupportItem | None = None
    transfer:  TransferItem | None = None
    uiadmin:  UiadminItem | None = None
    user:  UserItem | None = None
    wallet:  WalletItem | None = None
