# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:27:00+00:00

from __future__ import annotations

import uuid
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, constr


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class ObjectEnum(Enum):
    old = 'old'
    new = 'new'


class TypeEnum(Enum):
    array = 'array'
    hash = 'hash'
    number = 'number'
    string = 'string'
    boolean = 'boolean'
    generic = 'generic'


class ComponentItem(BaseModel):
    path: list[str | int] | None = None
    object:  ObjectEnum | None = None
    type:  TypeEnum | None = None


class ExampleItem(BaseModel):
    class Config:
        extra = Extra.allow

    old_data: Any | None = None
    new_data: Any | None = None


class TriggerOnEnum(Enum):
    always = 'always'
    only_when_becomes_true = 'only_when_becomes_true'
    on_toggle = 'on_toggle'


class SendA(Enum):
    email = 'email'
    notification = 'notification'


class Alert(BaseModel):
    class Config:
        extra = Extra.allow

    meta:  MetaItem | None = None
    name: str | None = None
    enabled: bool | None = None
    component: list[ComponentItem] | None = None
    if_operation: list[str] | None = None
    then_operation: list[str] | None = None
    example:  ExampleItem | None = None
    trigger_again_after: int | None = None
    trigger_on:  TriggerOnEnum | None = None
    parser_id: uuid.UUID | None = None
    send_as:  SendA | None = None
    subject: str | None = None
    subject_on_false: str | None = None
