# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:29:01+00:00

from __future__ import annotations

import uuid
from typing import Any
from pydantic import BaseModel, Extra, conint, constr


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class HomepageItem(BaseModel):
    class Config:
        extra = Extra.forbid

    index: conint(ge=0) | None = None
    name: str | None = None


class GridProperty1(BaseModel):
    class Config:
        extra = Extra.forbid

    height: float | None = None
    width: float | None = None
    x: float | None = None
    y: float | None = None
    moved: bool | None = None
    static: bool | None = None


class Item(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str | None = None
    name: str | None = None
    id: uuid.UUID | None = None
    children: Any | None = None


class Grid(BaseModel):
    class Config:
        extra = Extra.forbid

    large: Any | None = None
    medium: Any | None = None
    small: Any | None = None


class WidgetItem(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    grid:  Grid | None = None


class Dashboard(BaseModel):
    class Config:
        extra = Extra.forbid

    meta:  MetaItem | None = None
    name: str | None = None
    type: str | None = None
    configuration: dict[str, Any] | None = None
    items: list[Item] | None = None
    widget: list[WidgetItem] | None = None
    homepage:  HomepageItem | None = None
