# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:31:06+00:00

from __future__ import annotations

import datetime
import uuid
from pydantic import BaseModel, Extra, conint, constr


class ConcernItem(BaseModel):
    class Config:
        extra = Extra.forbid

    concern: str | None = None
    line: conint(ge=0, multiple_of=1) | None = None


class ConcernFileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: datetime.datetime | None = None
    concern: list[ConcernItem] | None = None


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class File(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    type: str | None = None
    size: conint(ge=0, multiple_of=1) | None = None
    concernFile: list[ConcernFileItem] | None = None
    meta:  MetaItem | None = None
