# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:31:15+00:00

from __future__ import annotations

import datetime
import uuid
from pydantic import BaseModel, Extra, constr


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class LogItem(BaseModel):
    type: str | None = None
    timestamp: datetime.datetime | None = None
    message: str | None = None


class Path(BaseModel):
    name: str | None = None
    path: str | None = None
    firmware: uuid.UUID | None = None
    unpack: bool | None = None


class Firmware(BaseModel):
    class Config:
        extra = Extra.forbid

    meta:  MetaItem | None = None
    log: list[LogItem] | None = None
    version_id: str | None = None
    paths: list[Path] | None = None
