# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:31:19+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, constr


class Assigned(Enum):
    unassigned = 'unassigned'


class DeletionEnum(Enum):
    pending = 'pending'
    failed = 'failed'


class DebugItem(BaseModel):
    debug: str | None = None
    backtrace: list[str] | None = None


class ErrorItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None
    service: str | None = None
    internal_code: str | None = None
    debug:  DebugItem | None = None


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class MetaItem(BaseModel):
    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | None = None
    updated: datetime.datetime | None = None
    changed: datetime.datetime | None = None
    application: uuid.UUID | None = None
    deletion:  DeletionEnum | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error:  ErrorItem | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    alert: list[uuid.UUID] | None = None
    set: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Fite(BaseModel):
    class Config:
        extra = Extra.forbid

    name: dict[str, Any] | None = None
    meta:  MetaItem | None = None
    data: dict[str, Any] | None = None
    secure: dict[str, Any] | None = None
