# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:32:35+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, constr


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Operation(Enum):
    count_online_iot = 'count_online_iot'
    count_online_at_least_once = 'count_online_at_least_once'


class TypeEnum(Enum):
    network = 'network'
    device = 'device'
    value = 'value'
    state = 'state'


class Limitation(BaseModel):
    class Config:
        extra = Extra.forbid

    type:  TypeEnum | None = None
    attribute: str | None = None
    value: list[Any] | None = None


class ResolutionEnum(Enum):
    second = 'second'
    minute = 'minute'
    hour = 'hour'
    day = 'day'
    week = 'week'
    month = 'month'


class QueryItem(BaseModel):
    class Config:
        extra = Extra.forbid

    begin: datetime.datetime | None = None
    end: datetime.datetime | None = None
    ids: list[uuid.UUID] | None = None
    limitations: list[Limitation] | None = None
    resolution:  ResolutionEnum | None = None


class Metrics(BaseModel):
    class Config:
        extra = Extra.allow

    meta:  MetaItem | None = None
    operation:  Operation | None = None
    query:  QueryItem | None = None
