# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:33:30+00:00

from __future__ import annotations

import uuid

from pydantic import BaseModel, Extra, conint, constr


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class ExternalItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    api_key: str | None = None
    api_secret_key: str | None = None
    api_site: str | None = None


class OauthClient(BaseModel):
    class Config:
        extra = Extra.allow

    name: str | None = None
    company: str | None = None
    description: str | None = None
    homepage_url: str | None = None
    expires: conint(ge=0) | None = None
    client_id: uuid.UUID | None = None
    client_secret: str | None = None
    redirect_uri: list[str] | None = None
    path_access_token: list[str] | None = None
    meta:  MetaItem | None = None
    external: list[ExternalItem] | None = None
