# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:33:48+00:00

from __future__ import annotations

import uuid
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, constr


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Operation(Enum):
    table = 'table'
    message = 'message'


class MessageItem(BaseModel):
    false_message: str | None = None
    true_message: str | None = None


class VersionEnum(Enum):
    field_2_1 = '2.1'
    field_2_1_1 = '2.1'


class ConditionEnum(Enum):
    lessThan = 'lessThan'
    field_ = '<'
    lessOrEqualThan = 'lessOrEqualThan'
    field__ = '<='
    moreThan = 'moreThan'
    field__1 = '>'
    moreOrEqualThan = 'moreOrEqualThan'
    field___1 = '>='
    equal = 'equal'
    field___2 = '=='
    different = 'different'
    field___3 = '!='
    contains = 'contains'
    field__2 = '='
    always = 'always'
    default = 'default'


class Color(BaseModel):
    condition:  ConditionEnum | None = None
    value: str | None = None
    conditionValue: str | None = None


class Column(BaseModel):
    data: str | None = None
    title: str | None = None
    colors: list[Color] | None = None


class TableItem(BaseModel):
    class Config:
        extra = Extra.forbid

    service: str | None = None
    version:  VersionEnum | None = None
    parser: str | None = None
    columns: list[Column] | None = None


class ExampleItem(BaseModel):
    class Config:
        extra = Extra.allow

    input: Any | None = None


class Parser(BaseModel):
    class Config:
        extra = Extra.allow

    meta:  MetaItem | None = None
    name: str | None = None
    operation:  Operation | None = None
    message:  MessageItem | None = None
    table:  TableItem | None = None
    example:  ExampleItem | None = None
    to_parse: Any | None = None
