# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:36:33+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum

from pydantic import BaseModel, Extra, constr


class Type(Enum):
    Report = 'Report'
    Control = 'Control'


class StatusEnum(Enum):
    Send = 'Send'
    Pending = 'Pending'
    Failed = 'Failed'
    Queued = 'Queued'


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    historical: bool | None = None


class State(BaseModel):
    class Config:
        extra = Extra.allow

    timestamp: datetime.datetime | None = None
    data: str | None = None
    type:  Type | None = None
    status:  StatusEnum | None = None
    meta:  MetaItem | None = None
