# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:37:49+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, conint, constr


class PermissionEnum(Enum):
    r = 'r'
    w = 'w'
    rw = 'rw'
    wr = 'wr'
    none = 'none'


class StatusEnum(Enum):
    ok = 'ok'
    update = 'update'
    pending = 'pending'


class NumberItem(BaseModel):
    class Config:
        extra = Extra.forbid

    min: float | constr(regex=r'^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$') | None = None
    max: float | constr(regex=r'^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$') | None = None
    step: float | constr(regex=r'^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$') | None = None
    unit: str | None = None
    si_conversion: str | None = None
    mapping: dict[str, Any] | None = None
    ordered_mapping: bool | None = None
    meaningful_zero: bool | None = None


class StringItem(BaseModel):
    class Config:
        extra = Extra.forbid

    max: conint(ge=1, multiple_of=1) | None = None
    encoding: str | None = None


class BlobItem(BaseModel):
    class Config:
        extra = Extra.forbid

    max: conint(ge=1, multiple_of=1) | None = None
    encoding: str | None = None


class XmlItem(BaseModel):
    class Config:
        extra = Extra.forbid

    xsd: str | None = None
    namespace: str | None = None


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    historical: bool | None = None


class Type(Enum):
    Report = 'Report'
    Control = 'Control'


class StatusEnum1(Enum):
    Send = 'Send'
    Pending = 'Pending'
    Failed = 'Failed'
    Queued = 'Queued'


class StateItem(BaseModel):
    class Config:
        extra = Extra.allow

    timestamp: datetime.datetime | None = None
    data: str | None = None
    type:  Type | None = None
    status:  StatusEnum1 | None = None
    meta:  MetaItem | None = None


class Level(Enum):
    important = 'important'
    error = 'error'
    success = 'success'
    warning = 'warning'
    info = 'info'
    debug = 'debug'


class MetaItem2(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class EventlogItem(BaseModel):
    class Config:
        extra = Extra.allow

    message: str | None = None
    timestamp: datetime.datetime | None = None
    info: dict[str, Any] | None = None
    level:  Level | None = None
    type: str | None = None
    meta:  MetaItem2 | None = None


class InfoItem(BaseModel):
    class Config:
        extra = Extra.forbid

    enabled: bool | None = None


class Value(BaseModel):
    class Config:
        extra = Extra.allow

    name: str | None = None
    description: str | None = None
    type: str | None = None
    period: str | None = None
    delta: str | None = None
    permission:  PermissionEnum | None = None
    status:  StatusEnum | None = None
    number:  NumberItem | None = None
    string:  StringItem | None = None
    blob:  BlobItem | None = None
    xml:  XmlItem | None = None
    meta:  MetaItem | None = None
    state: list[StateItem | uuid.UUID] | None = None
    eventlog: list[EventlogItem | uuid.UUID] | None = None
    info:  InfoItem | None = None
