# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:37:54+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, conint, constr


class EngineEnum(Enum):
    node = 'node'
    python = 'python'


class ExecutableItem(BaseModel):
    class Config:
        extra = Extra.forbid

    engine:  EngineEnum | None = None
    version: str | None = None


class SupportedFeature(Enum):
    foreground = 'foreground'
    background = 'background'
    widget = 'widget'


class DescriptionItem(BaseModel):
    class Config:
        extra = Extra.forbid

    general: str | None = None
    foreground: str | None = None
    background: str | None = None
    widget: str | None = None
    version: str | None = None


class StatusEnum(Enum):
    idle = 'idle'
    commit = 'commit'
    revision = 'revision'
    publish = 'publish'
    uncommit = 'uncommit'
    unpublish = 'unpublish'
    republish = 'republish'
    disable = 'disable'
    reenable = 'reenable'
    duplicate = 'duplicate'
    pending = 'pending'
    uncommitted = 'uncommitted'
    published = 'published'
    not_updated = 'not updated'
    unpublished = 'unpublished'
    disabled = 'disabled'


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class PermissionItem(BaseModel):
    create: list[str] | None = None
    permit_to_send_email: bool | None = None
    permit_to_send_sms: bool | None = None


class ConcernItem(BaseModel):
    class Config:
        extra = Extra.forbid

    concern: str | None = None
    line: conint(ge=0, multiple_of=1) | None = None


class ConcernFileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: datetime.datetime | None = None
    concern: list[ConcernItem] | None = None


class FileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    type: str | None = None
    size: conint(ge=0, multiple_of=1) | None = None
    concernFile: list[ConcernFileItem] | None = None
    meta:  MetaItem | None = None


class Version(BaseModel):
    class Config:
        extra = Extra.allow

    name: str | None = None
    name_identifier: constr(regex=r'[0-9a-z_]') | None = None
    author: str | None = None
    version_app: constr(regex=r'^(\d+\.\d+\.\d+)$') | None = None
    commit: str | None = None
    date: datetime.datetime | None = None
    title: str | None = None
    session_user: bool | None = None
    concern: str | None = None
    native: bool | None = None
    name_folder: str | None = None
    icon: uuid.UUID | None = None
    version_to_clone: uuid.UUID | None = None
    uninstallable: bool | None = None
    executable:  ExecutableItem | None = None
    max_number_installation: conint(ge=1) | None = None
    object_requested: dict[str, Any] | None = None
    supported_features: list[SupportedFeature] | None = None
    description:  DescriptionItem | None = None
    status:  StatusEnum | None = None
    used_files: dict[str, Any] | None = None
    meta:  MetaItem | None = None
    permission:  PermissionItem | None = None
    file: list[FileItem | uuid.UUID] | None = None
