# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:38:08+00:00

from __future__ import annotations

import uuid
from typing import Any
from pydantic import BaseModel, Extra, constr


class MetaItem(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class GridProperty1(BaseModel):
    class Config:
        extra = Extra.forbid

    height: float | None = None
    width: float | None = None
    x: float | None = None
    y: float | None = None
    moved: bool | None = None
    static: bool | None = None


class Item(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str | None = None
    name: str | None = None
    id: uuid.UUID | None = None
    children: Any | None = None


class Grid(BaseModel):
    class Config:
        extra = Extra.forbid

    large: Any | None = None
    medium: Any | None = None
    small: Any | None = None


class DashboardItem(BaseModel):
    class Config:
        extra = Extra.forbid

    grid:  Grid | None = None


class Widget(BaseModel):
    class Config:
        extra = Extra.forbid

    meta:  MetaItem | None = None
    name: str | None = None
    type: str | None = None
    configuration: dict[str, Any] | None = None
    items: list[Item] | None = None
    dashboard:  DashboardItem | None = None
