"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUser = exports.toJson_CfnUserProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("@aws-cdk/core");
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnUserProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'CannotChangePassword': obj.cannotChangePassword,
        'City': obj.city,
        'Company': obj.company,
        'Container': obj.container,
        'Country': obj.country,
        'CustomAttributes': obj.customAttributes,
        'Department': obj.department,
        'Description': obj.description,
        'DisplayName': obj.displayName,
        'Division': obj.division,
        'EmailAddress': obj.emailAddress,
        'EmployeeId': obj.employeeId,
        'EmployeeNumber': obj.employeeNumber,
        'Enabled': obj.enabled,
        'Fax': obj.fax,
        'GivenName': obj.givenName,
        'HomeDirectory': obj.homeDirectory,
        'HomeDrive': obj.homeDrive,
        'HomePage': obj.homePage,
        'HomePhone': obj.homePhone,
        'InitialPassword': obj.initialPassword,
        'Initials': obj.initials,
        'MobilePhone': obj.mobilePhone,
        'Office': obj.office,
        'OfficePhone': obj.officePhone,
        'Organization': obj.organization,
        'OtherName': obj.otherName,
        'PasswordNeverExpires': obj.passwordNeverExpires,
        'PoBox': obj.poBox,
        'PostalCode': obj.postalCode,
        'PrincipalName': obj.principalName,
        'SamAccountName': obj.samAccountName,
        'SmartCardLogonRequired': obj.smartCardLogonRequired,
        'State': obj.state,
        'StreetAddress': obj.streetAddress,
        'Surname': obj.surname,
        'Title': obj.title,
        'TrustedForDelegation': obj.trustedForDelegation,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnUserProps = toJson_CfnUserProps;
/**
 * A CloudFormation `TF::AD::User`.
 *
 * @external
 * @cloudformationResource TF::AD::User
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnUser extends cdk.CfnResource {
    /**
     * Create a new `TF::AD::User`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUser.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnUserProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrSid = cdk.Token.asString(this.getAtt('Sid'));
    }
}
exports.CfnUser = CfnUser;
_a = JSII_RTTI_SYMBOL_1;
CfnUser[_a] = { fqn: "@cdk-cloudformation/tf-ad-user.CfnUser", version: "1.0.0-alpha.1" };
/**
 * The CloudFormation resource type name for this resource class.
 *
 * @external
 */
CfnUser.CFN_RESOURCE_TYPE_NAME = "TF::AD::User";
//# sourceMappingURL=data:application/json;base64,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