# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class BulkLoadRequestModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'profile_id': 'str',
        'load_tag': 'str',
        'max_failed_file_loads': 'int',
        'load_control_file': 'str'
    }

    attribute_map = {
        'profile_id': 'profileId',
        'load_tag': 'loadTag',
        'max_failed_file_loads': 'maxFailedFileLoads',
        'load_control_file': 'loadControlFile'
    }

    def __init__(self, profile_id=None, load_tag=None, max_failed_file_loads=0, load_control_file=None, local_vars_configuration=None):  # noqa: E501
        """BulkLoadRequestModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._profile_id = None
        self._load_tag = None
        self._max_failed_file_loads = None
        self._load_control_file = None
        self.discriminator = None

        self.profile_id = profile_id
        self.load_tag = load_tag
        if max_failed_file_loads is not None:
            self.max_failed_file_loads = max_failed_file_loads
        self.load_control_file = load_control_file

    @property
    def profile_id(self):
        """Gets the profile_id of this BulkLoadRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The profile_id of this BulkLoadRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._profile_id

    @profile_id.setter
    def profile_id(self, profile_id):
        """Sets the profile_id of this BulkLoadRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param profile_id: The profile_id of this BulkLoadRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and profile_id is None:  # noqa: E501
            raise ValueError("Invalid value for `profile_id`, must not be `None`")  # noqa: E501

        self._profile_id = profile_id

    @property
    def load_tag(self):
        """Gets the load_tag of this BulkLoadRequestModel.  # noqa: E501

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :return: The load_tag of this BulkLoadRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._load_tag

    @load_tag.setter
    def load_tag(self, load_tag):
        """Sets the load_tag of this BulkLoadRequestModel.

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :param load_tag: The load_tag of this BulkLoadRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and load_tag is None:  # noqa: E501
            raise ValueError("Invalid value for `load_tag`, must not be `None`")  # noqa: E501

        self._load_tag = load_tag

    @property
    def max_failed_file_loads(self):
        """Gets the max_failed_file_loads of this BulkLoadRequestModel.  # noqa: E501

        max number of failed file loads before stopping; if -1, allow any number of errors  # noqa: E501

        :return: The max_failed_file_loads of this BulkLoadRequestModel.  # noqa: E501
        :rtype: int
        """
        return self._max_failed_file_loads

    @max_failed_file_loads.setter
    def max_failed_file_loads(self, max_failed_file_loads):
        """Sets the max_failed_file_loads of this BulkLoadRequestModel.

        max number of failed file loads before stopping; if -1, allow any number of errors  # noqa: E501

        :param max_failed_file_loads: The max_failed_file_loads of this BulkLoadRequestModel.  # noqa: E501
        :type: int
        """

        self._max_failed_file_loads = max_failed_file_loads

    @property
    def load_control_file(self):
        """Gets the load_control_file of this BulkLoadRequestModel.  # noqa: E501

        gs:// path to a text file in a bucket. The file must be accessible to the DR Manager. Each line of the file is interpreted as the JSON form of one BulkLoadFileModel. For example, one line might look like   '{ \"sourcePath\":\"gs:/bucket/path/file\", \"targetPath\":\"/target/path/file\" }'  # noqa: E501

        :return: The load_control_file of this BulkLoadRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._load_control_file

    @load_control_file.setter
    def load_control_file(self, load_control_file):
        """Sets the load_control_file of this BulkLoadRequestModel.

        gs:// path to a text file in a bucket. The file must be accessible to the DR Manager. Each line of the file is interpreted as the JSON form of one BulkLoadFileModel. For example, one line might look like   '{ \"sourcePath\":\"gs:/bucket/path/file\", \"targetPath\":\"/target/path/file\" }'  # noqa: E501

        :param load_control_file: The load_control_file of this BulkLoadRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and load_control_file is None:  # noqa: E501
            raise ValueError("Invalid value for `load_control_file`, must not be `None`")  # noqa: E501

        self._load_control_file = load_control_file

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BulkLoadRequestModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BulkLoadRequestModel):
            return True

        return self.to_dict() != other.to_dict()
