# AI-Zap

Простая библиотека для отправки запросов к ИИ через функцию `zap()`.

## Установка

```bash
pip install ai-zap
```

## Использование

```python
from ai_zap import zap

# Отправка запроса к ИИ
response = zap("Как работает Python?")
print(response)

# Использование своего API ключа
response = zap("Как работает Python?", api_key="ваш_ключ")
print(response)
```

## Параметры

Функция `zap()` принимает следующие параметры:

- `text` (str): Текст запроса к ИИ
- `api_key` (str, опционально): API ключ для доступа к сервису. По умолчанию используется встроенный ключ.

## Требования

- Python 3.6 или выше
- OpenAI Python client

## Лицензия

MIT

## Поддержка

Если у вас возникли проблемы или есть предложения по улучшению библиотеки, создайте issue в репозитории проекта. 