try:  # pragma: nocover
    from importlib.metadata import version  # type: ignore
except ImportError:
    from importlib_metadata import version

from alchemista.field import fields_from
from alchemista.main import sqlalchemy_to_pydantic
from alchemista.model import model_from

__version__ = version(__package__)
__all__ = ["fields_from", "model_from", "sqlalchemy_to_pydantic"]
