from __future__ import annotations

from amltk.metalearning.dataset_distances import dataset_distance
from amltk.metalearning.metafeatures import (
    ClassCounts,
    ClassImbalance,
    ClassImbalanceRatios,
    DatasetStatistic,
    ImbalancePerCategory,
    KurtosisMax,
    KurtosisMean,
    KurtosisMin,
    KurtosisPerNumericalColumn,
    KurtosisStd,
    LogInstanceCount,
    LogNumberOfFeatures,
    MajorityClassImbalance,
    MeanCategoricalImbalance,
    MetaFeature,
    MinorityClassImbalance,
    NumberOfCategoricalFeatures,
    NumberOfClasses,
    NumberOfFeatures,
    NumberOfNumericFeatures,
    PercentageMissingValues,
    PercentageOfCategoricalColumnsWithMissingValues,
    PercentageOfCategoricalValuesWithMissingValues,
    PercentageOfFeaturesWithMissingValues,
    PercentageOfInstancesWithMissingValues,
    PercentageOfNumericColumnsWithMissingValues,
    PercentageOfNumericValuesWithMissingValues,
    RatioCategoricalFeatures,
    RatioFeaturesToInstances,
    RatioNumericalFeatures,
    SkewnessMax,
    SkewnessMean,
    SkewnessMin,
    SkewnessPerNumericalColumn,
    SkewnessStd,
    StdCategoricalImbalance,
    compute_metafeatures,
    metafeature_descriptions,
)
from amltk.metalearning.portfolio import portfolio_selection


def get_metafeatures() -> list[type[DatasetStatistic]]:
    """Returns a list of all available metafeatures."""
    return [
        ClassCounts,
        ClassImbalance,
        ClassImbalanceRatios,
        ImbalancePerCategory,
        KurtosisMax,
        KurtosisMean,
        KurtosisMin,
        KurtosisPerNumericalColumn,
        KurtosisStd,
        LogInstanceCount,
        LogNumberOfFeatures,
        MajorityClassImbalance,
        MeanCategoricalImbalance,
        MinorityClassImbalance,
        NumberOfCategoricalFeatures,
        NumberOfClasses,
        NumberOfFeatures,
        NumberOfNumericFeatures,
        PercentageMissingValues,
        PercentageOfCategoricalColumnsWithMissingValues,
        PercentageOfCategoricalValuesWithMissingValues,
        PercentageOfFeaturesWithMissingValues,
        PercentageOfInstancesWithMissingValues,
        PercentageOfNumericColumnsWithMissingValues,
        PercentageOfNumericValuesWithMissingValues,
        RatioFeaturesToInstances,
        RatioNumericalFeatures,
        RatioCategoricalFeatures,
        SkewnessMax,
        SkewnessMean,
        SkewnessMin,
        SkewnessPerNumericalColumn,
        SkewnessStd,
        StdCategoricalImbalance,
    ]


__all__ = [
    "ClassCounts",
    "ClassImbalance",
    "DatasetStatistic",
    "ImbalancePerCategory",
    "KurtosisMax",
    "KurtosisMean",
    "KurtosisMin",
    "KurtosisPerNumericalColumn",
    "KurtosisStd",
    "LogInstanceCount",
    "LogNumberOfFeatures",
    "MajorityClassImbalance",
    "MeanCategoricalImbalance",
    "MetaFeature",
    "MinorityClassImbalance",
    "NumberOfCategoricalFeatures",
    "NumberOfClasses",
    "NumberOfFeatures",
    "NumberOfNumericFeatures",
    "PercentageMissingValues",
    "PercentageOfCategoricalColumnsWithMissingValues",
    "PercentageOfCategoricalValuesWithMissingValues",
    "PercentageOfFeaturesWithMissingValues",
    "PercentageOfInstancesWithMissingValues",
    "PercentageOfNumericColumnsWithMissingValues",
    "PercentageOfNumericValuesWithMissingValues",
    "RatioCategoricalFeatures",
    "RatioFeaturesToInstances",
    "RatioNumericalFeatures",
    "SkewnessMax",
    "SkewnessMean",
    "SkewnessMin",
    "SkewnessPerNumericalColumn",
    "SkewnessStd",
    "StdCategoricalImbalance",
    "compute_metafeatures",
    "dataset_distance",
    "get_metafeatures",
    "metafeature_descriptions",
    "portfolio_selection",
]
