# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
import pulumi_aws

__all__ = [
    'ListenerArgs',
    'TargetGroupArgs',
]

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 alpn_policy: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ssl_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Provides a Load Balancer Listener resource.

        > **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.

        {{% examples %}}
        ## Example Usage
        {{% example %}}
        ### Forward Action

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEndLoadBalancer = new aws.lb.LoadBalancer("frontEndLoadBalancer", {});
        // ...
        const frontEndTargetGroup = new aws.lb.TargetGroup("frontEndTargetGroup", {});
        // ...
        const frontEndListener = new aws.lb.Listener("frontEndListener", {
            loadBalancerArn: frontEndLoadBalancer.arn,
            port: 443,
            protocol: "HTTPS",
            sslPolicy: "ELBSecurityPolicy-2016-08",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            defaultActions: [{
                type: "forward",
                targetGroupArn: frontEndTargetGroup.arn,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end_load_balancer = aws.lb.LoadBalancer("frontEndLoadBalancer")
        # ...
        front_end_target_group = aws.lb.TargetGroup("frontEndTargetGroup")
        # ...
        front_end_listener = aws.lb.Listener("frontEndListener",
            load_balancer_arn=front_end_load_balancer.arn,
            port=443,
            protocol="HTTPS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            default_actions=[aws.lb.ListenerDefaultActionArgs(
                type="forward",
                target_group_arn=front_end_target_group.arn,
            )])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var frontEndLoadBalancer = new Aws.LB.LoadBalancer("frontEndLoadBalancer", new Aws.LB.LoadBalancerArgs
                {
                });
                // ...
                var frontEndTargetGroup = new Aws.LB.TargetGroup("frontEndTargetGroup", new Aws.LB.TargetGroupArgs
                {
                });
                // ...
                var frontEndListener = new Aws.LB.Listener("frontEndListener", new Aws.LB.ListenerArgs
                {
                    LoadBalancerArn = frontEndLoadBalancer.Arn,
                    Port = 443,
                    Protocol = "HTTPS",
                    SslPolicy = "ELBSecurityPolicy-2016-08",
                    CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                    DefaultActions = 
                    {
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "forward",
                            TargetGroupArn = frontEndTargetGroup.Arn,
                        },
                    },
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEndLoadBalancer, err := lb.NewLoadBalancer(ctx, "frontEndLoadBalancer", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "frontEndTargetGroup", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "frontEndListener", &lb.ListenerArgs{
        			LoadBalancerArn: frontEndLoadBalancer.Arn,
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("HTTPS"),
        			SslPolicy:       pulumi.String("ELBSecurityPolicy-2016-08"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()        
                    .loadBalancerArn(frontEndLoadBalancer.getArn())
                    .port("443")
                    .protocol("HTTPS")
                    .sslPolicy("ELBSecurityPolicy-2016-08")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .defaultActions(ListenerDefaultAction.builder()
                        .type("forward")
                        .targetGroupArn(frontEndTargetGroup.getArn())
                        .build())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          frontEndLoadBalancer:
            type: aws:lb:LoadBalancer
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
          frontEndListener:
            type: aws:lb:Listener
            properties:
              loadBalancerArn: ${frontEndLoadBalancer.arn}
              port: 443
              protocol: HTTPS
              sslPolicy: ELBSecurityPolicy-2016-08
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              defaultActions:
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```

        To a NLB:

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.Listener("frontEnd", {
            loadBalancerArn: aws_lb.front_end.arn,
            port: 443,
            protocol: "TLS",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpnPolicy: "HTTP2Preferred",
            defaultActions: [{
                type: "forward",
                targetGroupArn: aws_lb_target_group.front_end.arn,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.Listener("frontEnd",
            load_balancer_arn=aws_lb["front_end"]["arn"],
            port=443,
            protocol="TLS",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpn_policy="HTTP2Preferred",
            default_actions=[aws.lb.ListenerDefaultActionArgs(
                type="forward",
                target_group_arn=aws_lb_target_group["front_end"]["arn"],
            )])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var frontEnd = new Aws.LB.Listener("frontEnd", new Aws.LB.ListenerArgs
                {
                    LoadBalancerArn = aws_lb.Front_end.Arn,
                    Port = 443,
                    Protocol = "TLS",
                    CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                    AlpnPolicy = "HTTP2Preferred",
                    DefaultActions = 
                    {
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "forward",
                            TargetGroupArn = aws_lb_target_group.Front_end.Arn,
                        },
                    },
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewListener(ctx, "frontEnd", &lb.ListenerArgs{
        			LoadBalancerArn: pulumi.Any(aws_lb.Front_end.Arn),
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("TLS"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			AlpnPolicy:      pulumi.String("HTTP2Preferred"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: pulumi.Any(aws_lb_target_group.Front_end.Arn),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new Listener("frontEnd", ListenerArgs.builder()        
                    .loadBalancerArn(aws_lb.getFront_end().getArn())
                    .port("443")
                    .protocol("TLS")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .alpnPolicy("HTTP2Preferred")
                    .defaultActions(ListenerDefaultAction.builder()
                        .type("forward")
                        .targetGroupArn(aws_lb_target_group.getFront_end().getArn())
                        .build())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:Listener
            properties:
              loadBalancerArn: ${aws_lb.front_end.arn}
              port: 443
              protocol: TLS
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              alpnPolicy: HTTP2Preferred
              defaultActions:
                - type: forward
                  targetGroupArn: ${aws_lb_target_group.front_end.arn}
        ```
        {{% /example %}}
        {{% example %}}
        ### Redirect Action

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEndLoadBalancer = new aws.lb.LoadBalancer("frontEndLoadBalancer", {});
        // ...
        const frontEndListener = new aws.lb.Listener("frontEndListener", {
            loadBalancerArn: frontEndLoadBalancer.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [{
                type: "redirect",
                redirect: {
                    port: "443",
                    protocol: "HTTPS",
                    statusCode: "HTTP_301",
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end_load_balancer = aws.lb.LoadBalancer("frontEndLoadBalancer")
        # ...
        front_end_listener = aws.lb.Listener("frontEndListener",
            load_balancer_arn=front_end_load_balancer.arn,
            port=80,
            protocol="HTTP",
            default_actions=[aws.lb.ListenerDefaultActionArgs(
                type="redirect",
                redirect=aws.lb.ListenerDefaultActionRedirectArgs(
                    port="443",
                    protocol="HTTPS",
                    status_code="HTTP_301",
                ),
            )])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var frontEndLoadBalancer = new Aws.LB.LoadBalancer("frontEndLoadBalancer", new Aws.LB.LoadBalancerArgs
                {
                });
                // ...
                var frontEndListener = new Aws.LB.Listener("frontEndListener", new Aws.LB.ListenerArgs
                {
                    LoadBalancerArn = frontEndLoadBalancer.Arn,
                    Port = 80,
                    Protocol = "HTTP",
                    DefaultActions = 
                    {
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "redirect",
                            Redirect = new Aws.LB.Inputs.ListenerDefaultActionRedirectArgs
                            {
                                Port = "443",
                                Protocol = "HTTPS",
                                StatusCode = "HTTP_301",
                            },
                        },
                    },
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEndLoadBalancer, err := lb.NewLoadBalancer(ctx, "frontEndLoadBalancer", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "frontEndListener", &lb.ListenerArgs{
        			LoadBalancerArn: frontEndLoadBalancer.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("redirect"),
        					Redirect: &lb.ListenerDefaultActionRedirectArgs{
        						Port:       pulumi.String("443"),
        						Protocol:   pulumi.String("HTTPS"),
        						StatusCode: pulumi.String("HTTP_301"),
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()        
                    .loadBalancerArn(frontEndLoadBalancer.getArn())
                    .port("80")
                    .protocol("HTTP")
                    .defaultActions(ListenerDefaultAction.builder()
                        .type("redirect")
                        .redirect(ListenerDefaultActionRedirect.builder()
                            .port("443")
                            .protocol("HTTPS")
                            .statusCode("HTTP_301")
                            .build())
                        .build())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          frontEndLoadBalancer:
            type: aws:lb:LoadBalancer
          frontEndListener:
            type: aws:lb:Listener
            properties:
              loadBalancerArn: ${frontEndLoadBalancer.arn}
              port: 80
              protocol: HTTP
              defaultActions:
                - type: redirect
                  redirect:
                    port: 443
                    protocol: HTTPS
                    statusCode: HTTP_301
        ```
        {{% /example %}}
        {{% example %}}
        ### Fixed-response Action

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEndLoadBalancer = new aws.lb.LoadBalancer("frontEndLoadBalancer", {});
        // ...
        const frontEndListener = new aws.lb.Listener("frontEndListener", {
            loadBalancerArn: frontEndLoadBalancer.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [{
                type: "fixed-response",
                fixedResponse: {
                    contentType: "text/plain",
                    messageBody: "Fixed response content",
                    statusCode: "200",
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end_load_balancer = aws.lb.LoadBalancer("frontEndLoadBalancer")
        # ...
        front_end_listener = aws.lb.Listener("frontEndListener",
            load_balancer_arn=front_end_load_balancer.arn,
            port=80,
            protocol="HTTP",
            default_actions=[aws.lb.ListenerDefaultActionArgs(
                type="fixed-response",
                fixed_response=aws.lb.ListenerDefaultActionFixedResponseArgs(
                    content_type="text/plain",
                    message_body="Fixed response content",
                    status_code="200",
                ),
            )])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var frontEndLoadBalancer = new Aws.LB.LoadBalancer("frontEndLoadBalancer", new Aws.LB.LoadBalancerArgs
                {
                });
                // ...
                var frontEndListener = new Aws.LB.Listener("frontEndListener", new Aws.LB.ListenerArgs
                {
                    LoadBalancerArn = frontEndLoadBalancer.Arn,
                    Port = 80,
                    Protocol = "HTTP",
                    DefaultActions = 
                    {
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "fixed-response",
                            FixedResponse = new Aws.LB.Inputs.ListenerDefaultActionFixedResponseArgs
                            {
                                ContentType = "text/plain",
                                MessageBody = "Fixed response content",
                                StatusCode = "200",
                            },
                        },
                    },
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEndLoadBalancer, err := lb.NewLoadBalancer(ctx, "frontEndLoadBalancer", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "frontEndListener", &lb.ListenerArgs{
        			LoadBalancerArn: frontEndLoadBalancer.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("fixed-response"),
        					FixedResponse: &lb.ListenerDefaultActionFixedResponseArgs{
        						ContentType: pulumi.String("text/plain"),
        						MessageBody: pulumi.String("Fixed response content"),
        						StatusCode:  pulumi.String("200"),
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()        
                    .loadBalancerArn(frontEndLoadBalancer.getArn())
                    .port("80")
                    .protocol("HTTP")
                    .defaultActions(ListenerDefaultAction.builder()
                        .type("fixed-response")
                        .fixedResponse(ListenerDefaultActionFixedResponse.builder()
                            .contentType("text/plain")
                            .messageBody("Fixed response content")
                            .statusCode("200")
                            .build())
                        .build())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          frontEndLoadBalancer:
            type: aws:lb:LoadBalancer
          frontEndListener:
            type: aws:lb:Listener
            properties:
              loadBalancerArn: ${frontEndLoadBalancer.arn}
              port: 80
              protocol: HTTP
              defaultActions:
                - type: fixed-response
                  fixedResponse:
                    contentType: text/plain
                    messageBody: Fixed response content
                    statusCode: 200
        ```
        {{% /example %}}
        {{% example %}}
        ### Authenticate-cognito Action

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEndLoadBalancer = new aws.lb.LoadBalancer("frontEndLoadBalancer", {});
        // ...
        const frontEndTargetGroup = new aws.lb.TargetGroup("frontEndTargetGroup", {});
        // ...
        const pool = new aws.cognito.UserPool("pool", {});
        // ...
        const client = new aws.cognito.UserPoolClient("client", {});
        // ...
        const domain = new aws.cognito.UserPoolDomain("domain", {});
        // ...
        const frontEndListener = new aws.lb.Listener("frontEndListener", {
            loadBalancerArn: frontEndLoadBalancer.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [
                {
                    type: "authenticate-cognito",
                    authenticateCognito: {
                        userPoolArn: pool.arn,
                        userPoolClientId: client.id,
                        userPoolDomain: domain.domain,
                    },
                },
                {
                    type: "forward",
                    targetGroupArn: frontEndTargetGroup.arn,
                },
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end_load_balancer = aws.lb.LoadBalancer("frontEndLoadBalancer")
        # ...
        front_end_target_group = aws.lb.TargetGroup("frontEndTargetGroup")
        # ...
        pool = aws.cognito.UserPool("pool")
        # ...
        client = aws.cognito.UserPoolClient("client")
        # ...
        domain = aws.cognito.UserPoolDomain("domain")
        # ...
        front_end_listener = aws.lb.Listener("frontEndListener",
            load_balancer_arn=front_end_load_balancer.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                aws.lb.ListenerDefaultActionArgs(
                    type="authenticate-cognito",
                    authenticate_cognito=aws.lb.ListenerDefaultActionAuthenticateCognitoArgs(
                        user_pool_arn=pool.arn,
                        user_pool_client_id=client.id,
                        user_pool_domain=domain.domain,
                    ),
                ),
                aws.lb.ListenerDefaultActionArgs(
                    type="forward",
                    target_group_arn=front_end_target_group.arn,
                ),
            ])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var frontEndLoadBalancer = new Aws.LB.LoadBalancer("frontEndLoadBalancer", new Aws.LB.LoadBalancerArgs
                {
                });
                // ...
                var frontEndTargetGroup = new Aws.LB.TargetGroup("frontEndTargetGroup", new Aws.LB.TargetGroupArgs
                {
                });
                // ...
                var pool = new Aws.Cognito.UserPool("pool", new Aws.Cognito.UserPoolArgs
                {
                });
                // ...
                var client = new Aws.Cognito.UserPoolClient("client", new Aws.Cognito.UserPoolClientArgs
                {
                });
                // ...
                var domain = new Aws.Cognito.UserPoolDomain("domain", new Aws.Cognito.UserPoolDomainArgs
                {
                });
                // ...
                var frontEndListener = new Aws.LB.Listener("frontEndListener", new Aws.LB.ListenerArgs
                {
                    LoadBalancerArn = frontEndLoadBalancer.Arn,
                    Port = 80,
                    Protocol = "HTTP",
                    DefaultActions = 
                    {
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "authenticate-cognito",
                            AuthenticateCognito = new Aws.LB.Inputs.ListenerDefaultActionAuthenticateCognitoArgs
                            {
                                UserPoolArn = pool.Arn,
                                UserPoolClientId = client.Id,
                                UserPoolDomain = domain.Domain,
                            },
                        },
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "forward",
                            TargetGroupArn = frontEndTargetGroup.Arn,
                        },
                    },
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/cognito"
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEndLoadBalancer, err := lb.NewLoadBalancer(ctx, "frontEndLoadBalancer", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "frontEndTargetGroup", nil)
        		if err != nil {
        			return err
        		}
        		pool, err := cognito.NewUserPool(ctx, "pool", nil)
        		if err != nil {
        			return err
        		}
        		client, err := cognito.NewUserPoolClient(ctx, "client", nil)
        		if err != nil {
        			return err
        		}
        		domain, err := cognito.NewUserPoolDomain(ctx, "domain", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "frontEndListener", &lb.ListenerArgs{
        			LoadBalancerArn: frontEndLoadBalancer.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("authenticate-cognito"),
        					AuthenticateCognito: &lb.ListenerDefaultActionAuthenticateCognitoArgs{
        						UserPoolArn:      pool.Arn,
        						UserPoolClientId: client.ID(),
        						UserPoolDomain:   domain.Domain,
        					},
        				},
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var pool = new UserPool("pool");

                var client = new UserPoolClient("client");

                var domain = new UserPoolDomain("domain");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()        
                    .loadBalancerArn(frontEndLoadBalancer.getArn())
                    .port("80")
                    .protocol("HTTP")
                    .defaultActions(            
                        ListenerDefaultAction.builder()
                            .type("authenticate-cognito")
                            .authenticateCognito(ListenerDefaultActionAuthenticateCognito.builder()
                                .userPoolArn(pool.getArn())
                                .userPoolClientId(client.getId())
                                .userPoolDomain(domain.getDomain())
                                .build())
                            .build(),
                        ListenerDefaultAction.builder()
                            .type("forward")
                            .targetGroupArn(frontEndTargetGroup.getArn())
                            .build())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          frontEndLoadBalancer:
            type: aws:lb:LoadBalancer
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
          pool:
            type: aws:cognito:UserPool
          client:
            type: aws:cognito:UserPoolClient
          domain:
            type: aws:cognito:UserPoolDomain
          frontEndListener:
            type: aws:lb:Listener
            properties:
              loadBalancerArn: ${frontEndLoadBalancer.arn}
              port: 80
              protocol: HTTP
              defaultActions:
                - type: authenticate-cognito
                  authenticateCognito:
                    userPoolArn: ${pool.arn}
                    userPoolClientId: ${client.id}
                    userPoolDomain: ${domain.domain}
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        {{% /example %}}
        {{% example %}}
        ### Authenticate-OIDC Action

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEndLoadBalancer = new aws.lb.LoadBalancer("frontEndLoadBalancer", {});
        // ...
        const frontEndTargetGroup = new aws.lb.TargetGroup("frontEndTargetGroup", {});
        // ...
        const frontEndListener = new aws.lb.Listener("frontEndListener", {
            loadBalancerArn: frontEndLoadBalancer.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [
                {
                    type: "authenticate-oidc",
                    authenticateOidc: {
                        authorizationEndpoint: "https://example.com/authorization_endpoint",
                        clientId: "client_id",
                        clientSecret: "client_secret",
                        issuer: "https://example.com",
                        tokenEndpoint: "https://example.com/token_endpoint",
                        userInfoEndpoint: "https://example.com/user_info_endpoint",
                    },
                },
                {
                    type: "forward",
                    targetGroupArn: frontEndTargetGroup.arn,
                },
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end_load_balancer = aws.lb.LoadBalancer("frontEndLoadBalancer")
        # ...
        front_end_target_group = aws.lb.TargetGroup("frontEndTargetGroup")
        # ...
        front_end_listener = aws.lb.Listener("frontEndListener",
            load_balancer_arn=front_end_load_balancer.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                aws.lb.ListenerDefaultActionArgs(
                    type="authenticate-oidc",
                    authenticate_oidc=aws.lb.ListenerDefaultActionAuthenticateOidcArgs(
                        authorization_endpoint="https://example.com/authorization_endpoint",
                        client_id="client_id",
                        client_secret="client_secret",
                        issuer="https://example.com",
                        token_endpoint="https://example.com/token_endpoint",
                        user_info_endpoint="https://example.com/user_info_endpoint",
                    ),
                ),
                aws.lb.ListenerDefaultActionArgs(
                    type="forward",
                    target_group_arn=front_end_target_group.arn,
                ),
            ])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var frontEndLoadBalancer = new Aws.LB.LoadBalancer("frontEndLoadBalancer", new Aws.LB.LoadBalancerArgs
                {
                });
                // ...
                var frontEndTargetGroup = new Aws.LB.TargetGroup("frontEndTargetGroup", new Aws.LB.TargetGroupArgs
                {
                });
                // ...
                var frontEndListener = new Aws.LB.Listener("frontEndListener", new Aws.LB.ListenerArgs
                {
                    LoadBalancerArn = frontEndLoadBalancer.Arn,
                    Port = 80,
                    Protocol = "HTTP",
                    DefaultActions = 
                    {
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "authenticate-oidc",
                            AuthenticateOidc = new Aws.LB.Inputs.ListenerDefaultActionAuthenticateOidcArgs
                            {
                                AuthorizationEndpoint = "https://example.com/authorization_endpoint",
                                ClientId = "client_id",
                                ClientSecret = "client_secret",
                                Issuer = "https://example.com",
                                TokenEndpoint = "https://example.com/token_endpoint",
                                UserInfoEndpoint = "https://example.com/user_info_endpoint",
                            },
                        },
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            Type = "forward",
                            TargetGroupArn = frontEndTargetGroup.Arn,
                        },
                    },
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEndLoadBalancer, err := lb.NewLoadBalancer(ctx, "frontEndLoadBalancer", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "frontEndTargetGroup", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "frontEndListener", &lb.ListenerArgs{
        			LoadBalancerArn: frontEndLoadBalancer.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("authenticate-oidc"),
        					AuthenticateOidc: &lb.ListenerDefaultActionAuthenticateOidcArgs{
        						AuthorizationEndpoint: pulumi.String("https://example.com/authorization_endpoint"),
        						ClientId:              pulumi.String("client_id"),
        						ClientSecret:          pulumi.String("client_secret"),
        						Issuer:                pulumi.String("https://example.com"),
        						TokenEndpoint:         pulumi.String("https://example.com/token_endpoint"),
        						UserInfoEndpoint:      pulumi.String("https://example.com/user_info_endpoint"),
        					},
        				},
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()        
                    .loadBalancerArn(frontEndLoadBalancer.getArn())
                    .port("80")
                    .protocol("HTTP")
                    .defaultActions(            
                        ListenerDefaultAction.builder()
                            .type("authenticate-oidc")
                            .authenticateOidc(ListenerDefaultActionAuthenticateOidc.builder()
                                .authorizationEndpoint("https://example.com/authorization_endpoint")
                                .clientId("client_id")
                                .clientSecret("client_secret")
                                .issuer("https://example.com")
                                .tokenEndpoint("https://example.com/token_endpoint")
                                .userInfoEndpoint("https://example.com/user_info_endpoint")
                                .build())
                            .build(),
                        ListenerDefaultAction.builder()
                            .type("forward")
                            .targetGroupArn(frontEndTargetGroup.getArn())
                            .build())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          frontEndLoadBalancer:
            type: aws:lb:LoadBalancer
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
          frontEndListener:
            type: aws:lb:Listener
            properties:
              loadBalancerArn: ${frontEndLoadBalancer.arn}
              port: 80
              protocol: HTTP
              defaultActions:
                - type: authenticate-oidc
                  authenticateOidc:
                    authorizationEndpoint: https://example.com/authorization_endpoint
                    clientId: client_id
                    clientSecret: client_secret
                    issuer: https://example.com
                    tokenEndpoint: https://example.com/token_endpoint
                    userInfoEndpoint: https://example.com/user_info_endpoint
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        {{% /example %}}
        {{% example %}}
        ### Gateway Load Balancer Listener

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const exampleLoadBalancer = new aws.lb.LoadBalancer("exampleLoadBalancer", {
            loadBalancerType: "gateway",
            subnetMappings: [{
                subnetId: aws_subnet.example.id,
            }],
        });
        const exampleTargetGroup = new aws.lb.TargetGroup("exampleTargetGroup", {
            port: 6081,
            protocol: "GENEVE",
            vpcId: aws_vpc.example.id,
            healthCheck: {
                port: "80",
                protocol: "HTTP",
            },
        });
        const exampleListener = new aws.lb.Listener("exampleListener", {
            loadBalancerArn: exampleLoadBalancer.id,
            defaultActions: [{
                targetGroupArn: exampleTargetGroup.id,
                type: "forward",
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example_load_balancer = aws.lb.LoadBalancer("exampleLoadBalancer",
            load_balancer_type="gateway",
            subnet_mappings=[aws.lb.LoadBalancerSubnetMappingArgs(
                subnet_id=aws_subnet["example"]["id"],
            )])
        example_target_group = aws.lb.TargetGroup("exampleTargetGroup",
            port=6081,
            protocol="GENEVE",
            vpc_id=aws_vpc["example"]["id"],
            health_check=aws.lb.TargetGroupHealthCheckArgs(
                port="80",
                protocol="HTTP",
            ))
        example_listener = aws.lb.Listener("exampleListener",
            load_balancer_arn=example_load_balancer.id,
            default_actions=[aws.lb.ListenerDefaultActionArgs(
                target_group_arn=example_target_group.id,
                type="forward",
            )])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var exampleLoadBalancer = new Aws.LB.LoadBalancer("exampleLoadBalancer", new Aws.LB.LoadBalancerArgs
                {
                    LoadBalancerType = "gateway",
                    SubnetMappings = 
                    {
                        new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
                        {
                            SubnetId = aws_subnet.Example.Id,
                        },
                    },
                });
                var exampleTargetGroup = new Aws.LB.TargetGroup("exampleTargetGroup", new Aws.LB.TargetGroupArgs
                {
                    Port = 6081,
                    Protocol = "GENEVE",
                    VpcId = aws_vpc.Example.Id,
                    HealthCheck = new Aws.LB.Inputs.TargetGroupHealthCheckArgs
                    {
                        Port = "80",
                        Protocol = "HTTP",
                    },
                });
                var exampleListener = new Aws.LB.Listener("exampleListener", new Aws.LB.ListenerArgs
                {
                    LoadBalancerArn = exampleLoadBalancer.Id,
                    DefaultActions = 
                    {
                        new Aws.LB.Inputs.ListenerDefaultActionArgs
                        {
                            TargetGroupArn = exampleTargetGroup.Id,
                            Type = "forward",
                        },
                    },
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		exampleLoadBalancer, err := lb.NewLoadBalancer(ctx, "exampleLoadBalancer", &lb.LoadBalancerArgs{
        			LoadBalancerType: pulumi.String("gateway"),
        			SubnetMappings: lb.LoadBalancerSubnetMappingArray{
        				&lb.LoadBalancerSubnetMappingArgs{
        					SubnetId: pulumi.Any(aws_subnet.Example.Id),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		exampleTargetGroup, err := lb.NewTargetGroup(ctx, "exampleTargetGroup", &lb.TargetGroupArgs{
        			Port:     pulumi.Int(6081),
        			Protocol: pulumi.String("GENEVE"),
        			VpcId:    pulumi.Any(aws_vpc.Example.Id),
        			HealthCheck: &lb.TargetGroupHealthCheckArgs{
        				Port:     pulumi.String("80"),
        				Protocol: pulumi.String("HTTP"),
        			},
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "exampleListener", &lb.ListenerArgs{
        			LoadBalancerArn: exampleLoadBalancer.ID(),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					TargetGroupArn: exampleTargetGroup.ID(),
        					Type:           pulumi.String("forward"),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var exampleLoadBalancer = new LoadBalancer("exampleLoadBalancer", LoadBalancerArgs.builder()        
                    .loadBalancerType("gateway")
                    .subnetMappings(LoadBalancerSubnetMapping.builder()
                        .subnetId(aws_subnet.getExample().getId())
                        .build())
                    .build());

                var exampleTargetGroup = new TargetGroup("exampleTargetGroup", TargetGroupArgs.builder()        
                    .port(6081)
                    .protocol("GENEVE")
                    .vpcId(aws_vpc.getExample().getId())
                    .healthCheck(TargetGroupHealthCheck.builder()
                        .port(80)
                        .protocol("HTTP")
                        .build())
                    .build());

                var exampleListener = new Listener("exampleListener", ListenerArgs.builder()        
                    .loadBalancerArn(exampleLoadBalancer.getId())
                    .defaultActions(ListenerDefaultAction.builder()
                        .targetGroupArn(exampleTargetGroup.getId())
                        .type("forward")
                        .build())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          exampleLoadBalancer:
            type: aws:lb:LoadBalancer
            properties:
              loadBalancerType: gateway
              subnetMappings:
                - subnetId: ${aws_subnet.example.id}
          exampleTargetGroup:
            type: aws:lb:TargetGroup
            properties:
              port: 6081
              protocol: GENEVE
              vpcId: ${aws_vpc.example.id}
              healthCheck:
                port: 80
                protocol: HTTP
          exampleListener:
            type: aws:lb:Listener
            properties:
              loadBalancerArn: ${exampleLoadBalancer.id}
              defaultActions:
                - targetGroupArn: ${exampleTargetGroup.id}
                  type: forward
        ```
        {{% /example %}}
        {{% /examples %}}

        ## Import

        Listeners can be imported using their ARN, e.g.,

        ```sh
         $ pulumi import aws:lb/listener:Listener front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener/app/front-end-alb/8e4497da625e2d8a/9ab28ade35828f96
        ```

         
        :param pulumi.Input[str] alpn_policy: Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        :param pulumi.Input[str] certificate_arn: ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `aws.lb.ListenerCertificate` resource.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]] default_actions: Configuration block for default actions. Detailed below.
        :param pulumi.Input[int] port: Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param pulumi.Input[str] protocol: Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param pulumi.Input[str] ssl_policy: Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if default_actions is not None:
            pulumi.set(__self__, "default_actions", default_actions)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alpn_policy", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `aws.lb.ListenerCertificate` resource.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]]]:
        """
        Configuration block for default actions. Detailed below.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]]]):
        pulumi.set(self, "default_actions", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class TargetGroupArgs:
    def __init__(__self__, *,
                 connection_termination: Optional[pulumi.Input[bool]] = None,
                 deregistration_delay: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs']] = None,
                 lambda_multi_value_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 load_balancing_algorithm_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preserve_client_ip: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_v2: Optional[pulumi.Input[bool]] = None,
                 slow_start: Optional[pulumi.Input[int]] = None,
                 stickiness: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Provides a Target Group resource for use with Load Balancer resources.

        > **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.

        {{% examples %}}
        ## Example Usage
        {{% example %}}
        ### Instance Target Group

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
        const test = new aws.lb.TargetGroup("test", {
            port: 80,
            protocol: "HTTP",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        test = aws.lb.TargetGroup("test",
            port=80,
            protocol="HTTP",
            vpc_id=main.id)
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var main = new Aws.Ec2.Vpc("main", new Aws.Ec2.VpcArgs
                {
                    CidrBlock = "10.0.0.0/16",
                });
                var test = new Aws.LB.TargetGroup("test", new Aws.LB.TargetGroupArgs
                {
                    Port = 80,
                    Protocol = "HTTP",
                    VpcId = main.Id,
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/ec2"
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
        			CidrBlock: pulumi.String("10.0.0.0/16"),
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewTargetGroup(ctx, "test", &lb.TargetGroupArgs{
        			Port:     pulumi.Int(80),
        			Protocol: pulumi.String("HTTP"),
        			VpcId:    main.ID(),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var main = new Vpc("main", VpcArgs.builder()        
                    .cidrBlock("10.0.0.0/16")
                    .build());

                var test = new TargetGroup("test", TargetGroupArgs.builder()        
                    .port(80)
                    .protocol("HTTP")
                    .vpcId(main.getId())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          test:
            type: aws:lb:TargetGroup
            properties:
              port: 80
              protocol: HTTP
              vpcId: ${main.id}
          main:
            type: aws:ec2:Vpc
            properties:
              cidrBlock: 10.0.0.0/16
        ```
        {{% /example %}}
        {{% example %}}
        ### IP Target Group

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
        const ip_example = new aws.lb.TargetGroup("ip-example", {
            port: 80,
            protocol: "HTTP",
            targetType: "ip",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        ip_example = aws.lb.TargetGroup("ip-example",
            port=80,
            protocol="HTTP",
            target_type="ip",
            vpc_id=main.id)
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var main = new Aws.Ec2.Vpc("main", new Aws.Ec2.VpcArgs
                {
                    CidrBlock = "10.0.0.0/16",
                });
                var ip_example = new Aws.LB.TargetGroup("ip-example", new Aws.LB.TargetGroupArgs
                {
                    Port = 80,
                    Protocol = "HTTP",
                    TargetType = "ip",
                    VpcId = main.Id,
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/ec2"
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
        			CidrBlock: pulumi.String("10.0.0.0/16"),
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewTargetGroup(ctx, "ip-example", &lb.TargetGroupArgs{
        			Port:       pulumi.Int(80),
        			Protocol:   pulumi.String("HTTP"),
        			TargetType: pulumi.String("ip"),
        			VpcId:      main.ID(),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var main = new Vpc("main", VpcArgs.builder()        
                    .cidrBlock("10.0.0.0/16")
                    .build());

                var ip_example = new TargetGroup("ip-example", TargetGroupArgs.builder()        
                    .port(80)
                    .protocol("HTTP")
                    .targetType("ip")
                    .vpcId(main.getId())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          ip-example:
            type: aws:lb:TargetGroup
            properties:
              port: 80
              protocol: HTTP
              targetType: ip
              vpcId: ${main.id}
          main:
            type: aws:ec2:Vpc
            properties:
              cidrBlock: 10.0.0.0/16
        ```
        {{% /example %}}
        {{% example %}}
        ### Lambda Target Group

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const lambda_example = new aws.lb.TargetGroup("lambda-example", {
            targetType: "lambda",
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        lambda_example = aws.lb.TargetGroup("lambda-example", target_type="lambda")
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var lambda_example = new Aws.LB.TargetGroup("lambda-example", new Aws.LB.TargetGroupArgs
                {
                    TargetType = "lambda",
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "lambda-example", &lb.TargetGroupArgs{
        			TargetType: pulumi.String("lambda"),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var lambda_example = new TargetGroup("lambda-example", TargetGroupArgs.builder()        
                    .targetType("lambda")
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          lambda-example:
            type: aws:lb:TargetGroup
            properties:
              targetType: lambda
        ```
        {{% /example %}}
        {{% example %}}
        ### ALB Target Group

        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const lambda_example = new aws.lb.TargetGroup("lambda-example", {
            targetType: "alb",
            port: 80,
            protocol: "TCP",
            vpcId: aws_vpc.main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        lambda_example = aws.lb.TargetGroup("lambda-example",
            target_type="alb",
            port=80,
            protocol="TCP",
            vpc_id=aws_vpc["main"]["id"])
        ```
        ```csharp
        using Pulumi;
        using Aws = Pulumi.Aws;

        class MyStack : Stack
        {
            public MyStack()
            {
                var lambda_example = new Aws.LB.TargetGroup("lambda-example", new Aws.LB.TargetGroupArgs
                {
                    TargetType = "alb",
                    Port = 80,
                    Protocol = "TCP",
                    VpcId = aws_vpc.Main.Id,
                });
            }

        }
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v5/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "lambda-example", &lb.TargetGroupArgs{
        			TargetType: pulumi.String("alb"),
        			Port:       pulumi.Int(80),
        			Protocol:   pulumi.String("TCP"),
        			VpcId:      pulumi.Any(aws_vpc.Main.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import java.util.*;
        import java.io.*;
        import java.nio.*;
        import com.pulumi.*;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var lambda_example = new TargetGroup("lambda-example", TargetGroupArgs.builder()        
                    .targetType("alb")
                    .port(80)
                    .protocol("TCP")
                    .vpcId(aws_vpc.getMain().getId())
                    .build());

                }
        }
        ```
        ```yaml
        resources:
          lambda-example:
            type: aws:lb:TargetGroup
            properties:
              targetType: alb
              port: 80
              protocol: TCP
              vpcId: ${aws_vpc.main.id}
        ```
        {{% /example %}}
        {{% /examples %}}

        ## Import

        Target Groups can be imported using their ARN, e.g.,

        ```sh
         $ pulumi import aws:lb/targetGroup:TargetGroup app_front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:targetgroup/app-front-end/20cfe21448b66314
        ```

         
        :param pulumi.Input[bool] connection_termination: Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        :param pulumi.Input[int] deregistration_delay: Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        :param pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs'] health_check: Health Check configuration block. Detailed below.
        :param pulumi.Input[bool] lambda_multi_value_headers_enabled: Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        :param pulumi.Input[str] load_balancing_algorithm_type: Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin` or `least_outstanding_requests`. The default is `round_robin`.
        :param pulumi.Input[str] name: Name of the target group. If omitted, this provider will assign a random, unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        :param pulumi.Input[int] port: Port to use to connect with the target. Valid values are either ports 1-65535, or `traffic-port`. Defaults to `traffic-port`.
        :param pulumi.Input[str] preserve_client_ip: Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        :param pulumi.Input[str] protocol: Protocol to use to connect with the target. Defaults to `HTTP`. Not applicable when `target_type` is `lambda`.
        :param pulumi.Input[str] protocol_version: Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[bool] proxy_protocol_v2: Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        :param pulumi.Input[int] slow_start: Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        :param pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs'] stickiness: Stickiness configuration block. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values. The default is `instance`.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        if connection_termination is not None:
            pulumi.set(__self__, "connection_termination", connection_termination)
        if deregistration_delay is not None:
            pulumi.set(__self__, "deregistration_delay", deregistration_delay)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if lambda_multi_value_headers_enabled is not None:
            pulumi.set(__self__, "lambda_multi_value_headers_enabled", lambda_multi_value_headers_enabled)
        if load_balancing_algorithm_type is not None:
            pulumi.set(__self__, "load_balancing_algorithm_type", load_balancing_algorithm_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preserve_client_ip is not None:
            pulumi.set(__self__, "preserve_client_ip", preserve_client_ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if proxy_protocol_v2 is not None:
            pulumi.set(__self__, "proxy_protocol_v2", proxy_protocol_v2)
        if slow_start is not None:
            pulumi.set(__self__, "slow_start", slow_start)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="connectionTermination")
    def connection_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        """
        return pulumi.get(self, "connection_termination")

    @connection_termination.setter
    def connection_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connection_termination", value)

    @property
    @pulumi.getter(name="deregistrationDelay")
    def deregistration_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        """
        return pulumi.get(self, "deregistration_delay")

    @deregistration_delay.setter
    def deregistration_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deregistration_delay", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs']]:
        """
        Health Check configuration block. Detailed below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="lambdaMultiValueHeadersEnabled")
    def lambda_multi_value_headers_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        """
        return pulumi.get(self, "lambda_multi_value_headers_enabled")

    @lambda_multi_value_headers_enabled.setter
    def lambda_multi_value_headers_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lambda_multi_value_headers_enabled", value)

    @property
    @pulumi.getter(name="loadBalancingAlgorithmType")
    def load_balancing_algorithm_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin` or `least_outstanding_requests`. The default is `round_robin`.
        """
        return pulumi.get(self, "load_balancing_algorithm_type")

    @load_balancing_algorithm_type.setter
    def load_balancing_algorithm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_algorithm_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target group. If omitted, this provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port to use to connect with the target. Valid values are either ports 1-65535, or `traffic-port`. Defaults to `traffic-port`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preserveClientIp")
    def preserve_client_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        """
        return pulumi.get(self, "preserve_client_ip")

    @preserve_client_ip.setter
    def preserve_client_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preserve_client_ip", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol to use to connect with the target. Defaults to `HTTP`. Not applicable when `target_type` is `lambda`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input[str]]:
        """
        Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="proxyProtocolV2")
    def proxy_protocol_v2(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        """
        return pulumi.get(self, "proxy_protocol_v2")

    @proxy_protocol_v2.setter
    def proxy_protocol_v2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol_v2", value)

    @property
    @pulumi.getter(name="slowStart")
    def slow_start(self) -> Optional[pulumi.Input[int]]:
        """
        Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        """
        return pulumi.get(self, "slow_start")

    @slow_start.setter
    def slow_start(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slow_start", value)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs']]:
        """
        Stickiness configuration block. Detailed below.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs']]):
        pulumi.set(self, "stickiness", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of target that you must specify when registering targets with this target group. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values. The default is `instance`.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


