"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunGlueJobTask = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
/**
 * Invoke a Glue job as a Task
 *
 * OUTPUT: the output of this task is a JobRun structure, for details consult
 * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-JobRun
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-glue.html
 *
 * @deprecated use `GlueStartJobRun`
 */
class RunGlueJobTask {
    constructor(glueJobName, props = {}) {
        this.glueJobName = glueJobName;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTask", "use `GlueStartJobRun`");
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_RunGlueJobTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RunGlueJobTask);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern || sfn.ServiceIntegrationPattern.FIRE_AND_FORGET;
        const supportedPatterns = [
            sfn.ServiceIntegrationPattern.FIRE_AND_FORGET,
            sfn.ServiceIntegrationPattern.SYNC,
        ];
        if (!supportedPatterns.includes(this.integrationPattern)) {
            throw new Error(`Invalid Service Integration Pattern: ${this.integrationPattern} is not supported to call Glue.`);
        }
    }
    bind(task) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTask#bind", "use `GlueStartJobRun`");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const notificationProperty = this.props.notifyDelayAfter ? { NotifyDelayAfter: this.props.notifyDelayAfter.toMinutes() } : null;
        let iamActions;
        if (this.integrationPattern === sfn.ServiceIntegrationPattern.FIRE_AND_FORGET) {
            iamActions = ['glue:StartJobRun'];
        }
        else if (this.integrationPattern === sfn.ServiceIntegrationPattern.SYNC) {
            iamActions = [
                'glue:StartJobRun',
                'glue:GetJobRun',
                'glue:GetJobRuns',
                'glue:BatchStopJobRun',
            ];
        }
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('glue', 'startJobRun', this.integrationPattern),
            policyStatements: [new iam.PolicyStatement({
                    resources: [
                        core_1.Stack.of(task).formatArn({
                            service: 'glue',
                            resource: 'job',
                            resourceName: this.glueJobName,
                        }),
                    ],
                    actions: iamActions,
                })],
            metricPrefixSingular: 'GlueJob',
            metricPrefixPlural: 'GlueJobs',
            metricDimensions: { GlueJobName: this.glueJobName },
            parameters: {
                JobName: this.glueJobName,
                Arguments: this.props.arguments,
                Timeout: this.props.timeout?.toMinutes(),
                SecurityConfiguration: this.props.securityConfiguration,
                NotificationProperty: notificationProperty,
            },
        };
    }
}
exports.RunGlueJobTask = RunGlueJobTask;
_a = JSII_RTTI_SYMBOL_1;
RunGlueJobTask[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTask", version: "1.181.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVuLWdsdWUtam9iLXRhc2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJydW4tZ2x1ZS1qb2ItdGFzay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx3Q0FBd0M7QUFDeEMsa0RBQWtEO0FBQ2xELHdDQUFnRDtBQUNoRCxnRUFBd0Q7QUF5RHhEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEsY0FBYztJQUd6QixZQUE2QixXQUFtQixFQUFtQixRQUE2QixFQUFFO1FBQXJFLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQTBCOzs7Ozs7OytDQUh2RixjQUFjOzs7O1FBSXZCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLElBQUksR0FBRyxDQUFDLHlCQUF5QixDQUFDLGVBQWUsQ0FBQztRQUVwRyxNQUFNLGlCQUFpQixHQUFHO1lBQ3hCLEdBQUcsQ0FBQyx5QkFBeUIsQ0FBQyxlQUFlO1lBQzdDLEdBQUcsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJO1NBQ25DLENBQUM7UUFFRixJQUFJLENBQUMsaUJBQWlCLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxFQUFFO1lBQ3hELE1BQU0sSUFBSSxLQUFLLENBQUMsd0NBQXdDLElBQUksQ0FBQyxrQkFBa0IsaUNBQWlDLENBQUMsQ0FBQztTQUNuSDtLQUNGO0lBRU0sSUFBSSxDQUFDLElBQWM7Ozs7Ozs7Ozs7UUFDeEIsTUFBTSxvQkFBb0IsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxFQUFFLGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2hJLElBQUksVUFBZ0MsQ0FBQztRQUNyQyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxHQUFHLENBQUMseUJBQXlCLENBQUMsZUFBZSxFQUFFO1lBQzdFLFVBQVUsR0FBRyxDQUFDLGtCQUFrQixDQUFDLENBQUM7U0FDbkM7YUFBTSxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxHQUFHLENBQUMseUJBQXlCLENBQUMsSUFBSSxFQUFFO1lBQ3pFLFVBQVUsR0FBRztnQkFDWCxrQkFBa0I7Z0JBQ2xCLGdCQUFnQjtnQkFDaEIsaUJBQWlCO2dCQUNqQixzQkFBc0I7YUFDdkIsQ0FBQztTQUNIO1FBQ0QsT0FBTztZQUNMLFdBQVcsRUFBRSxvQ0FBYyxDQUFDLE1BQU0sRUFBRSxhQUFhLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1lBQzNFLGdCQUFnQixFQUFFLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO29CQUN6QyxTQUFTLEVBQUU7d0JBQ1QsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7NEJBQ3ZCLE9BQU8sRUFBRSxNQUFNOzRCQUNmLFFBQVEsRUFBRSxLQUFLOzRCQUNmLFlBQVksRUFBRSxJQUFJLENBQUMsV0FBVzt5QkFDL0IsQ0FBQztxQkFDSDtvQkFDRCxPQUFPLEVBQUUsVUFBVTtpQkFDcEIsQ0FBQyxDQUFDO1lBQ0gsb0JBQW9CLEVBQUUsU0FBUztZQUMvQixrQkFBa0IsRUFBRSxVQUFVO1lBQzlCLGdCQUFnQixFQUFFLEVBQUUsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDbkQsVUFBVSxFQUFFO2dCQUNWLE9BQU8sRUFBRSxJQUFJLENBQUMsV0FBVztnQkFDekIsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUztnQkFDL0IsT0FBTyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLFNBQVMsRUFBRTtnQkFDeEMscUJBQXFCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUI7Z0JBQ3ZELG9CQUFvQixFQUFFLG9CQUFvQjthQUMzQztTQUNGLENBQUM7S0FDSDs7QUFwREgsd0NBcURDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgc2ZuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCB7IER1cmF0aW9uLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgZ2V0UmVzb3VyY2VBcm4gfSBmcm9tICcuLi9yZXNvdXJjZS1hcm4tc3VmZml4JztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBSdW5HbHVlSm9iVGFza1xuICpcbiAqIEBkZXByZWNhdGVkIHVzZSBgR2x1ZVN0YXJ0Sm9iUnVuYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJ1bkdsdWVKb2JUYXNrUHJvcHMge1xuXG4gIC8qKlxuICAgKiBUaGUgc2VydmljZSBpbnRlZ3JhdGlvbiBwYXR0ZXJuIGluZGljYXRlcyBkaWZmZXJlbnQgd2F5cyB0byBzdGFydCB0aGUgR2x1ZSBqb2IuXG4gICAqXG4gICAqIFRoZSB2YWxpZCB2YWx1ZSBmb3IgR2x1ZSBpcyBlaXRoZXIgRklSRV9BTkRfRk9SR0VUIG9yIFNZTkMuXG4gICAqXG4gICAqIEBkZWZhdWx0IEZJUkVfQU5EX0ZPUkdFVFxuICAgKi9cbiAgcmVhZG9ubHkgaW50ZWdyYXRpb25QYXR0ZXJuPzogc2ZuLlNlcnZpY2VJbnRlZ3JhdGlvblBhdHRlcm47XG5cbiAgLyoqXG4gICAqIFRoZSBqb2IgYXJndW1lbnRzIHNwZWNpZmljYWxseSBmb3IgdGhpcyBydW4uXG4gICAqXG4gICAqIEZvciB0aGlzIGpvYiBydW4sIHRoZXkgcmVwbGFjZSB0aGUgZGVmYXVsdCBhcmd1bWVudHMgc2V0IGluIHRoZSBqb2IgZGVmaW5pdGlvbiBpdHNlbGYuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBhcmd1bWVudHMgc2V0IGluIHRoZSBqb2IgZGVmaW5pdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgYXJndW1lbnRzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICAvKipcbiAgICogVGhlIGpvYiBydW4gdGltZW91dC5cbiAgICpcbiAgICogVGhpcyBpcyB0aGUgbWF4aW11bSB0aW1lIHRoYXQgYSBqb2IgcnVuIGNhbiBjb25zdW1lIHJlc291cmNlcyBiZWZvcmUgaXQgaXMgdGVybWluYXRlZCBhbmQgZW50ZXJzIFRJTUVPVVQgc3RhdHVzLlxuICAgKiBNdXN0IGJlIGF0IGxlYXN0IDEgbWludXRlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgdGltZW91dCBzZXQgaW4gdGhlIGpvYiBkZWZpbml0aW9uXG4gICAqL1xuICByZWFkb25seSB0aW1lb3V0PzogRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBTZWN1cml0eUNvbmZpZ3VyYXRpb24gc3RydWN0dXJlIHRvIGJlIHVzZWQgd2l0aCB0aGlzIGpvYiBydW4uXG4gICAqXG4gICAqIFRoaXMgbXVzdCBtYXRjaCB0aGUgR2x1ZSBBUElcbiAgICogW3NpbmdsZS1saW5lIHN0cmluZyBwYXR0ZXJuXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2x1ZS9sYXRlc3QvZGcvYXdzLWdsdWUtYXBpLWNvbW1vbi5odG1sI2F3cy1nbHVlLWFwaS1yZWdleC1vbmVMaW5lKS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBEZWZhdWx0IGNvbmZpZ3VyYXRpb24gc2V0IGluIHRoZSBqb2IgZGVmaW5pdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgc2VjdXJpdHlDb25maWd1cmF0aW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBZnRlciBhIGpvYiBydW4gc3RhcnRzLCB0aGUgbnVtYmVyIG9mIG1pbnV0ZXMgdG8gd2FpdCBiZWZvcmUgc2VuZGluZyBhIGpvYiBydW4gZGVsYXkgbm90aWZpY2F0aW9uLlxuICAgKlxuICAgKiBNdXN0IGJlIGF0IGxlYXN0IDEgbWludXRlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgZGVsYXkgc2V0IGluIHRoZSBqb2IgZGVmaW5pdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgbm90aWZ5RGVsYXlBZnRlcj86IER1cmF0aW9uO1xufVxuXG4vKipcbiAqIEludm9rZSBhIEdsdWUgam9iIGFzIGEgVGFza1xuICpcbiAqIE9VVFBVVDogdGhlIG91dHB1dCBvZiB0aGlzIHRhc2sgaXMgYSBKb2JSdW4gc3RydWN0dXJlLCBmb3IgZGV0YWlscyBjb25zdWx0XG4gKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2x1ZS9sYXRlc3QvZGcvYXdzLWdsdWUtYXBpLWpvYnMtcnVucy5odG1sI2F3cy1nbHVlLWFwaS1qb2JzLXJ1bnMtSm9iUnVuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3RlcC1mdW5jdGlvbnMvbGF0ZXN0L2RnL2Nvbm5lY3QtZ2x1ZS5odG1sXG4gKlxuICogQGRlcHJlY2F0ZWQgdXNlIGBHbHVlU3RhcnRKb2JSdW5gXG4gKi9cbmV4cG9ydCBjbGFzcyBSdW5HbHVlSm9iVGFzayBpbXBsZW1lbnRzIHNmbi5JU3RlcEZ1bmN0aW9uc1Rhc2sge1xuICBwcml2YXRlIHJlYWRvbmx5IGludGVncmF0aW9uUGF0dGVybjogc2ZuLlNlcnZpY2VJbnRlZ3JhdGlvblBhdHRlcm47XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBnbHVlSm9iTmFtZTogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBSdW5HbHVlSm9iVGFza1Byb3BzID0ge30pIHtcbiAgICB0aGlzLmludGVncmF0aW9uUGF0dGVybiA9IHByb3BzLmludGVncmF0aW9uUGF0dGVybiB8fCBzZm4uU2VydmljZUludGVncmF0aW9uUGF0dGVybi5GSVJFX0FORF9GT1JHRVQ7XG5cbiAgICBjb25zdCBzdXBwb3J0ZWRQYXR0ZXJucyA9IFtcbiAgICAgIHNmbi5TZXJ2aWNlSW50ZWdyYXRpb25QYXR0ZXJuLkZJUkVfQU5EX0ZPUkdFVCxcbiAgICAgIHNmbi5TZXJ2aWNlSW50ZWdyYXRpb25QYXR0ZXJuLlNZTkMsXG4gICAgXTtcblxuICAgIGlmICghc3VwcG9ydGVkUGF0dGVybnMuaW5jbHVkZXModGhpcy5pbnRlZ3JhdGlvblBhdHRlcm4pKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYEludmFsaWQgU2VydmljZSBJbnRlZ3JhdGlvbiBQYXR0ZXJuOiAke3RoaXMuaW50ZWdyYXRpb25QYXR0ZXJufSBpcyBub3Qgc3VwcG9ydGVkIHRvIGNhbGwgR2x1ZS5gKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgYmluZCh0YXNrOiBzZm4uVGFzayk6IHNmbi5TdGVwRnVuY3Rpb25zVGFza0NvbmZpZyB7XG4gICAgY29uc3Qgbm90aWZpY2F0aW9uUHJvcGVydHkgPSB0aGlzLnByb3BzLm5vdGlmeURlbGF5QWZ0ZXIgPyB7IE5vdGlmeURlbGF5QWZ0ZXI6IHRoaXMucHJvcHMubm90aWZ5RGVsYXlBZnRlci50b01pbnV0ZXMoKSB9IDogbnVsbDtcbiAgICBsZXQgaWFtQWN0aW9uczogc3RyaW5nW10gfCB1bmRlZmluZWQ7XG4gICAgaWYgKHRoaXMuaW50ZWdyYXRpb25QYXR0ZXJuID09PSBzZm4uU2VydmljZUludGVncmF0aW9uUGF0dGVybi5GSVJFX0FORF9GT1JHRVQpIHtcbiAgICAgIGlhbUFjdGlvbnMgPSBbJ2dsdWU6U3RhcnRKb2JSdW4nXTtcbiAgICB9IGVsc2UgaWYgKHRoaXMuaW50ZWdyYXRpb25QYXR0ZXJuID09PSBzZm4uU2VydmljZUludGVncmF0aW9uUGF0dGVybi5TWU5DKSB7XG4gICAgICBpYW1BY3Rpb25zID0gW1xuICAgICAgICAnZ2x1ZTpTdGFydEpvYlJ1bicsXG4gICAgICAgICdnbHVlOkdldEpvYlJ1bicsXG4gICAgICAgICdnbHVlOkdldEpvYlJ1bnMnLFxuICAgICAgICAnZ2x1ZTpCYXRjaFN0b3BKb2JSdW4nLFxuICAgICAgXTtcbiAgICB9XG4gICAgcmV0dXJuIHtcbiAgICAgIHJlc291cmNlQXJuOiBnZXRSZXNvdXJjZUFybignZ2x1ZScsICdzdGFydEpvYlJ1bicsIHRoaXMuaW50ZWdyYXRpb25QYXR0ZXJuKSxcbiAgICAgIHBvbGljeVN0YXRlbWVudHM6IFtuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIHJlc291cmNlczogW1xuICAgICAgICAgIFN0YWNrLm9mKHRhc2spLmZvcm1hdEFybih7XG4gICAgICAgICAgICBzZXJ2aWNlOiAnZ2x1ZScsXG4gICAgICAgICAgICByZXNvdXJjZTogJ2pvYicsXG4gICAgICAgICAgICByZXNvdXJjZU5hbWU6IHRoaXMuZ2x1ZUpvYk5hbWUsXG4gICAgICAgICAgfSksXG4gICAgICAgIF0sXG4gICAgICAgIGFjdGlvbnM6IGlhbUFjdGlvbnMsXG4gICAgICB9KV0sXG4gICAgICBtZXRyaWNQcmVmaXhTaW5ndWxhcjogJ0dsdWVKb2InLFxuICAgICAgbWV0cmljUHJlZml4UGx1cmFsOiAnR2x1ZUpvYnMnLFxuICAgICAgbWV0cmljRGltZW5zaW9uczogeyBHbHVlSm9iTmFtZTogdGhpcy5nbHVlSm9iTmFtZSB9LFxuICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICBKb2JOYW1lOiB0aGlzLmdsdWVKb2JOYW1lLFxuICAgICAgICBBcmd1bWVudHM6IHRoaXMucHJvcHMuYXJndW1lbnRzLFxuICAgICAgICBUaW1lb3V0OiB0aGlzLnByb3BzLnRpbWVvdXQ/LnRvTWludXRlcygpLFxuICAgICAgICBTZWN1cml0eUNvbmZpZ3VyYXRpb246IHRoaXMucHJvcHMuc2VjdXJpdHlDb25maWd1cmF0aW9uLFxuICAgICAgICBOb3RpZmljYXRpb25Qcm9wZXJ0eTogbm90aWZpY2F0aW9uUHJvcGVydHksXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==