"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChannelFlow = exports.FallbackAction = exports.InvocationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const channelFlowValidator_1 = require("./channelFlowValidator");
const messagingCustomResources_1 = require("./messagingCustomResources");
var InvocationType;
(function (InvocationType) {
    InvocationType["ASYNC"] = "ASYNC";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
var FallbackAction;
(function (FallbackAction) {
    FallbackAction["CONTINUE"] = "CONTINUE";
    FallbackAction["ABORT"] = "ABORT";
})(FallbackAction = exports.FallbackAction || (exports.FallbackAction = {}));
class ChannelFlow extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, clientRequestToken, appInstanceArn, processors, tags } = props;
        channelFlowValidator_1.channelFlowValidator(props);
        const channelFlowRequest = new messagingCustomResources_1.MessagingResources(this, 'channelFlowRequest', {
            resourceType: 'ChannelFlow',
            uid: uid,
            properties: {
                name: name || uid,
                appInstanceArn: appInstanceArn,
                processors: processors,
                tags: tags,
                clientRequestToken: clientRequestToken,
            },
        });
        this.channelFlowArn =
            channelFlowRequest.messagingCustomResource.getAttString('channelFlowArn');
    }
}
exports.ChannelFlow = ChannelFlow;
_a = JSII_RTTI_SYMBOL_1;
ChannelFlow[_a] = { fqn: "cdk-amazon-chime-resources.ChannelFlow", version: "0.1.173" };
//# sourceMappingURL=data:application/json;base64,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