# import numpy as np
# from secml.array import CArray
# from secml_malware.attack.whitebox.tests.malware_test_base import End2EndBaseTests
# from secml_malware.visualization.exe import plot_code_segment, plot_header_contribution_histogram,plot_range_histogram, plot_bins
#
#
# class ExeVisualizationTests(End2EndBaseTests):
#
# 	def setUp(self):
# 		super(ExeVisualizationTests, self).setUp()
# 		self.weights = CArray(np.random.randn(2, self.max_length))
# 		self.classifier.load_pretrained_model(self.ember_path)
#
# 	def test_ember_model_histogram(self):
# 		malware = CArray(self.malware)
# 		itgs = CMalConvIntegratedGradients(self.classifier)
# 		attr = itgs.explain(malware, m=250, reference=CArray(self.baseline))
# 		plot_range_histogram(attr, how_many=256, force_plot=False)
#
# 	def test_plot_bins(self):
# 		malware = CArray(self.malware)
# 		cut_index = malware.tolist()[0].index(256)
# 		itgs = CMalConvIntegratedGradients(self.classifier)
# 		attr = itgs.explain(malware, m=40, reference=CArray(self.baseline))
# 		plot_bins(attr, n_bins=2056, cut_index=cut_index, force_plot=False)
#
# 	def test_integrated_gradients_plot(self):
# 		malware = CArray(self.malware)
# 		itgs = CMalConvIntegratedGradients(self.classifier)
# 		attr = itgs.explain(malware, m=50, reference=CArray(self.baseline))
# 		_, conf = self.classifier.predict(malware, return_decision_function=True)
# 		title = 'Confidence: {0:.4f}%\nDOS + COFF + OPT + SECT Headers\nBaseline : empty file'.format(conf[1].item()*100)
# 		plot_code_segment(self.byte_malware, 0, 512, attr, title, force_plot=False, show_positives=True, show_negatives=True)
# 		plot_header_contribution_histogram(self.byte_malware, attr, force_plot=False)
#
# 	def test_code_segment_plot(self):
# 		plot_code_segment(self.byte_malware, 0, 120, self.weights, 'test', show_positives=True, show_negatives=True, force_plot=False)
#
# 	def test_visualize_histogram(self):
# 		plot_header_contribution_histogram(self.byte_malware, self.weights, force_plot=False)
