# How to Contribute

We welcome contributions to improve this project. Below are guidelines to help you get started:

## Getting Started

1. **Fork the Repository**
   - Navigate to the [project repository](<https://github.com/hermmanhender/eprllib>) and click the "Fork" button.

2. **Clone Your Fork**
   ```bash
   git clone https://github.com/your-username/eprllib.git
   cd repository-name
   ```

3. **Create a Branch**
   ```bash
   git checkout -b feature-branch-name
   ```

## Making Changes

1. **Implement Your Changes**
   - Make your changes to the codebase, ensuring you follow the project's coding style and guidelines.

2. **Test Your Changes**
   - Run existing tests and write new tests if necessary to cover your changes.
   - Ensure all tests pass before submitting your contribution.

3. **Commit Your Changes**
   ```bash
   git add .
   git commit -m "Description of your changes"
   ```

4. **Push to Your Fork**
   ```bash
   git push origin feature-branch-name
   ```

## Submitting a Pull Request

1. **Create a Pull Request**
   - Navigate to the [original repository](<https://github.com/hermmanhender/eprllib>) and click the "New Pull Request" button.
   - Ensure your pull request includes a clear description of the changes and any related issues.

2. **Review Process**
   - Your pull request will be reviewed by project maintainers.
   - Be responsive to feedback and be prepared to make necessary changes.

## Code of Conduct

By contributing, you agree to abide by our [Code of Conduct](<https://github.com/hermmanhender/eprllib/blob/main/CODE_OF_CONDUCT.md>).

## Additional Resources

- [Documentation](<eprllib.readthedocs.io>)
- [Issue Tracker](<https://github.com/hermmanhender/eprllib/issues>)

Thank you for your contributions!
