"use strict";
// Copyright 2012-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const queue_base_1 = require("./queue-base");
queue_base_1.QueueBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/SQS',
        metricName,
        dimensions: { QueueName: this.queueName },
        ...props
    });
};
queue_base_1.QueueBase.prototype.metricApproximateAgeOfOldestMessage = function (props) {
    return this.metric('ApproximateAgeOfOldestMessage', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesDelayed = function (props) {
    return this.metric('ApproximateNumberOfMessagesDelayed', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesNotVisible = function (props) {
    return this.metric('ApproximateNumberOfMessagesNotVisible', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesVisible = function (props) {
    return this.metric('ApproximateNumberOfMessagesVisible', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfEmptyReceives = function (props) {
    return this.metric('NumberOfEmptyReceives', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesDeleted = function (props) {
    return this.metric('NumberOfMessagesDeleted', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesReceived = function (props) {
    return this.metric('NumberOfMessagesReceived', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesSent = function (props) {
    return this.metric('NumberOfMessagesSent', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricSentMessageSize = function (props) {
    return this.metric('SentMessageSize', { statistic: 'Average', ...props });
};
//# sourceMappingURL=data:application/json;base64,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