"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function validateProps(props) {
    validateRange('delivery delay', props.deliveryDelay && props.deliveryDelay.toSeconds(), 0, 900, 'seconds');
    validateRange('maximum message size', props.maxMessageSizeBytes, 1024, 262144, 'bytes');
    validateRange('message retention period', props.retentionPeriod && props.retentionPeriod.toSeconds(), 60, 1209600, 'seconds');
    validateRange('receive wait time', props.receiveMessageWaitTime && props.receiveMessageWaitTime.toSeconds(), 0, 20, 'seconds');
    validateRange('visibility timeout', props.visibilityTimeout && props.visibilityTimeout.toSeconds(), 0, 43200, 'seconds');
    validateRange('dead letter target maximum receive count', props.deadLetterQueue && props.deadLetterQueue.maxReceiveCount, 1, +Infinity);
}
exports.validateProps = validateProps;
function validateRange(label, value, minValue, maxValue, unit) {
    if (value === undefined) {
        return;
    }
    const unitSuffix = unit ? ` ${unit}` : '';
    if (value < minValue) {
        throw new Error(`${label} must be ${minValue}${unitSuffix} or more, but ${value} was provided`);
    }
    if (value > maxValue) {
        throw new Error(`${label} must be ${maxValue}${unitSuffix} of less, but ${value} was provided`);
    }
}
//# sourceMappingURL=data:application/json;base64,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