# Generated by Django 4.1.5 on 2023-01-30 22:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import medux.preferences.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("common", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="BasePreference",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "namespace",
                    models.CharField(
                        max_length=25,
                        validators=[medux.preferences.models.validate_lower],
                    ),
                ),
                (
                    "key",
                    models.CharField(
                        max_length=255,
                        validators=[medux.preferences.models.validate_lower],
                    ),
                ),
            ],
            options={
                "verbose_name": "Settings",
                "verbose_name_plural": "Settings",
                "ordering": ["namespace", "key"],
            },
        ),
        migrations.CreateModel(
            name="ScopedPreference",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "scope",
                    models.IntegerField(
                        choices=[
                            (1, "Vendor"),
                            (2, "Tenant"),
                            (3, "Group"),
                            (4, "Device"),
                            (5, "User"),
                        ]
                    ),
                ),
                ("value", models.CharField(max_length=255, null=True)),
                (
                    "base",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="scopedpreferences",
                        to="preferences.basepreference",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="auth.group",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="common.tenant",
                        verbose_name="Tenant",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Scoped preferences",
                "verbose_name_plural": "Scoped preferences",
                "ordering": ["base__namespace", "base__key", "scope"],
                "permissions": [
                    (
                        "change_own_user_scopedpreference",
                        "Can change own user's preferences",
                    ),
                    (
                        "change_own_tenant_scopedpreference",
                        "Can change own tenant's preferences",
                    ),
                    (
                        "change_own_group_scopedpreference",
                        "Can change own groups' preferences",
                    ),
                    (
                        "change_device_scopedpreference",
                        "Can change a device's preferences",
                    ),
                ],
                "unique_together": {
                    ("base", "scope", "group"),
                    ("base", "scope", "tenant"),
                    ("base", "scope", "user"),
                },
            },
        ),
    ]
