"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrepayInstance = exports.PrepayInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "PrepayInstanceProperty", { enumerable: true, get: function () { return redis_generated_1.RosPrepayInstance; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::PrepayInstance`
 */
class PrepayInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::PrepayInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPrepayInstance = new redis_generated_1.RosPrepayInstance(this, id, {
            connections: props.connections,
            engineVersion: props.engineVersion,
            resourceGroupId: props.resourceGroupId,
            zoneId: props.zoneId,
            evictionPolicy: props.evictionPolicy,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            productType: props.productType,
            instanceMaintainTime: props.instanceMaintainTime,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            instanceClass: props.instanceClass,
            vpcPasswordFree: props.vpcPasswordFree,
            autoPay: props.autoPay === undefined || props.autoPay === null ? true : props.autoPay,
            secondaryZoneId: props.secondaryZoneId,
            autoRenewDuration: props.autoRenewDuration,
            instanceName: props.instanceName,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            vpcId: props.vpcId,
            sslEnabled: props.sslEnabled,
            tags: props.tags,
            backupPolicy: props.backupPolicy,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPrepayInstance;
        this.attrArchitectureType = rosPrepayInstance.attrArchitectureType;
        this.attrBandwidth = rosPrepayInstance.attrBandwidth;
        this.attrCapacity = rosPrepayInstance.attrCapacity;
        this.attrChargeType = rosPrepayInstance.attrChargeType;
        this.attrClassicInnerConnectionPort = rosPrepayInstance.attrClassicInnerConnectionPort;
        this.attrClassicInnerConnectionString = rosPrepayInstance.attrClassicInnerConnectionString;
        this.attrConnectionDomain = rosPrepayInstance.attrConnectionDomain;
        this.attrConnections = rosPrepayInstance.attrConnections;
        this.attrDirectConnectionPort = rosPrepayInstance.attrDirectConnectionPort;
        this.attrDirectConnectionString = rosPrepayInstance.attrDirectConnectionString;
        this.attrEngineVersion = rosPrepayInstance.attrEngineVersion;
        this.attrHasRenewChangeOrder = rosPrepayInstance.attrHasRenewChangeOrder;
        this.attrInstanceClass = rosPrepayInstance.attrInstanceClass;
        this.attrInstanceId = rosPrepayInstance.attrInstanceId;
        this.attrInstanceName = rosPrepayInstance.attrInstanceName;
        this.attrInstanceType = rosPrepayInstance.attrInstanceType;
        this.attrNetworkType = rosPrepayInstance.attrNetworkType;
        this.attrNodeType = rosPrepayInstance.attrNodeType;
        this.attrOrderId = rosPrepayInstance.attrOrderId;
        this.attrPackageType = rosPrepayInstance.attrPackageType;
        this.attrPort = rosPrepayInstance.attrPort;
        this.attrPrivateIp = rosPrepayInstance.attrPrivateIp;
        this.attrPublicConnectionPort = rosPrepayInstance.attrPublicConnectionPort;
        this.attrPublicConnectionString = rosPrepayInstance.attrPublicConnectionString;
        this.attrQps = rosPrepayInstance.attrQps;
        this.attrResourceGroupId = rosPrepayInstance.attrResourceGroupId;
        this.attrVSwitchId = rosPrepayInstance.attrVSwitchId;
        this.attrVpcId = rosPrepayInstance.attrVpcId;
        this.attrVpcPrivateConnectionPort = rosPrepayInstance.attrVpcPrivateConnectionPort;
        this.attrVpcPrivateConnectionString = rosPrepayInstance.attrVpcPrivateConnectionString;
        this.attrZoneId = rosPrepayInstance.attrZoneId;
    }
}
exports.PrepayInstance = PrepayInstance;
//# sourceMappingURL=data:application/json;base64,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