# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from .gradient_style import GradientStyle as GradientStyle_b02b0b93
from ..util.color import Color as Color_68e908c5


class Gradient(object):
    """
    Struct Class

    Describes a gradient between two colors.
    
    Many aspects of the gradient are undefined, like the algorithm and color space to use to interpolate between the colors and what \"intensity\" means.

    See Also:
        `API Gradient <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1Gradient.html>`_
    """
    typeName: Literal['com.sun.star.awt.Gradient']

    def __init__(self, Style: typing.Optional[GradientStyle_b02b0b93] = ..., StartColor: typing.Optional[Color_68e908c5] = ..., EndColor: typing.Optional[Color_68e908c5] = ..., Angle: typing.Optional[int] = ..., Border: typing.Optional[int] = ..., XOffset: typing.Optional[int] = ..., YOffset: typing.Optional[int] = ..., StartIntensity: typing.Optional[int] = ..., EndIntensity: typing.Optional[int] = ..., StepCount: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Style (GradientStyle, optional): Style value.
            StartColor (Color, optional): StartColor value.
            EndColor (Color, optional): EndColor value.
            Angle (int, optional): Angle value.
            Border (int, optional): Border value.
            XOffset (int, optional): XOffset value.
            YOffset (int, optional): YOffset value.
            StartIntensity (int, optional): StartIntensity value.
            EndIntensity (int, optional): EndIntensity value.
            StepCount (int, optional): StepCount value.
        """


    @property
    def Style(self) -> GradientStyle_b02b0b93:
        """
        specifies the style of the gradient.
        """


    @property
    def StartColor(self) -> Color_68e908c5:
        """
        specifies the color at the start point of the gradient.
        """


    @property
    def EndColor(self) -> Color_68e908c5:
        """
        specifies the color at the end point of the gradient.
        """


    @property
    def Angle(self) -> int:
        """
        angle of the gradient in 1/10 degree.
        """


    @property
    def Border(self) -> int:
        """
        per cent of the total width where just the start color is used.
        """


    @property
    def XOffset(self) -> int:
        """
        Specifies the X-coordinate, where the gradient begins.
        
        This is effectively the center of the RADIAL, ELLIPTICAL, SQUARE and RECT style gradients.
        """


    @property
    def YOffset(self) -> int:
        """
        Specifies the Y-coordinate, where the gradient begins.
        
        See previous field.
        """


    @property
    def StartIntensity(self) -> int:
        """
        Specifies the intensity at the start point of the gradient.
        
        What that means is undefined.
        """


    @property
    def EndIntensity(self) -> int:
        """
        specifies the intensity at the end point of the gradient.
        """


    @property
    def StepCount(self) -> int:
        """
        Specifies the number of steps of change color.
        
        What that means is undefined.
        """


