# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.beans
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class Property(object):
    """
    Struct Class

    This structure describes a property.
    
    There are three types of properties:

    See Also:
        `API Property <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1beans_1_1Property.html>`_
    """
    typeName: Literal['com.sun.star.beans.Property']

    def __init__(self, Name: typing.Optional[str] = ..., Handle: typing.Optional[int] = ..., Type: typing.Optional[object] = ..., Attributes: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Name (str, optional): Name value.
            Handle (int, optional): Handle value.
            Type (object, optional): Type value.
            Attributes (int, optional): Attributes value.
        """


    @property
    def Name(self) -> str:
        """
        specifies the name of the property.
        
        The name is unique within an XPropertySet. Upper and lower case are distinguished.
        """


    @property
    def Handle(self) -> int:
        """
        contains an implementation-specific handle for the property.
        
        It may be -1 if the implementation has no handle. You can use this handle to get values from the XFastPropertySet.
        """


    @property
    def Type(self) -> object:
        """
        contains an object that identifies the declared type for the property.
        
        If the property has multiple types or the type is not known, but not an any, then void must be returned.
        """


    @property
    def Attributes(self) -> int:
        """
        This field may contain zero or more constants of the PropertyAttribute constants group.
        """


