# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.chart2
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XTransformation(XInterface_8f010a43):
    """
    allows the transformation of numeric values from one coordinate-system into another.
    
    Values may be transformed using any mapping.

    See Also:
        `API XTransformation <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1chart2_1_1XTransformation.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.chart2.XTransformation']

    def getSourceDimension(self) -> int:
        """
        the dimension of the input coordinate sequence that is to be transformed by the transform() method.
        """
    def getTargetDimension(self) -> int:
        """
        the dimension of the output coordinate sequence that is the result of the transform() method.
        """
    def transform(self, aValues: 'typing.Tuple[float, ...]') -> 'typing.Tuple[float, ...]':
        """
        transforms the given input data tuple, given in the source coordinate system, according to the internal transformation rules, into a tuple of transformed coordinates in the destination coordinate system.
        
        Note that both coordinate systems may have different dimensions, e.g., if a transformation does simply a projection into a lower-dimensional space.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """

