# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.frame
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_storable import XStorable as XStorable_998f0aa7
    from ..ucb.x_content import XContent as XContent_79db0975

class XDocumentTemplates(XInterface_8f010a43):
    """
    provides a high level API to organize document templates
    
    Template information is saved as links to the original content and organized in groups. This data should be persistent and can be updated by calling special method XDocumentTemplates.update(). A real implementation of this interface can do that on top of a ucb content provider. Method XDocumentTemplates.getContent() force that.

    See Also:
        `API XDocumentTemplates <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1frame_1_1XDocumentTemplates.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.frame.XDocumentTemplates']

    def addGroup(self, GroupName: str) -> bool:
        """
        creates a new group
        """
    def addTemplate(self, GroupName: str, TemplateName: str, SourceURL: str) -> bool:
        """
        creates the template with the given name in the given group using the given URL
        """
    def getContent(self) -> 'XContent_79db0975':
        """
        provides access to the root of internal used hierarchy
        
        This content can be used for accessing the groups directly.
        """
    def removeGroup(self, GroupName: str) -> bool:
        """
        remove an existing group
        """
    def removeTemplate(self, GroupName: str, TemplateName: str) -> bool:
        """
        remove a template from specified group
        """
    def renameGroup(self, OldGroupName: str, NewGroupName: str) -> bool:
        """
        rename an existing group
        """
    def renameTemplate(self, GroupName: str, OldTemplateName: str, NewTemplateName: str) -> bool:
        """
        rename a template inside specified group
        """
    def storeTemplate(self, GroupName: str, TemplateName: str, Storable: 'XStorable_998f0aa7') -> bool:
        """
        creates the template with the given name in the given group using the data from the storable
        """
    def update(self) -> None:
        """
        force an update for internal structures
        
        Because the templates are well known by links and not as direct content they can be outdated. An update force actualization of that to find wrong links.
        """

