# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class FetchResult(object):
    """
    Struct Class

    contains data of several rows of a ContentResultSet.
    
    This struct is returned from XFetchProvider.fetch(), for example.

    See Also:
        `API FetchResult <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1FetchResult.html>`_
    """
    typeName: Literal['com.sun.star.ucb.FetchResult']

    def __init__(self, Rows: typing.Optional[typing.Tuple[object, ...]] = ..., StartIndex: typing.Optional[int] = ..., Orientation: typing.Optional[bool] = ..., FetchError: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Rows (typing.Tuple[object, ...], optional): Rows value.
            StartIndex (int, optional): StartIndex value.
            Orientation (bool, optional): Orientation value.
            FetchError (int, optional): FetchError value.
        """


    @property
    def Rows(self) -> typing.Tuple[object, ...]:
        """
        contains the demanded data.
        
        One any contains the data of one whole row. Those methods which use this struct have to specify, what the any has to contain.
        """


    @property
    def StartIndex(self) -> int:
        """
        indicates the index of the first row contained in FetchResult.Rows in the original result set.
        
        So if FetchResult.StartIndex equals 3, the first element in the sequence FetchResult.Rows contains the data of the index 3 in the original result set.
        
        The following rows are one after the other, but the direction depends on the value of FetchResult.Direction
        """


    @property
    def Orientation(self) -> bool:
        """
        indicates the orientation in which the rows are fetched and set into the sequence FetchResult.Rows.
        
        When FetchResult.Orientation equals TRUE, the rows in FetchResult.Rows are ordered in the same way as in the original result set.
        """


    @property
    def FetchError(self) -> int:
        """
        indicates whether and which error has occurred, while fetching.
        
        The value may contain zero or more constants of the FetchError constants group.
        """


