# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class SendInfo(object):
    """
    Struct Class

    contains information related to a send protocol.
    
    It can contain any string values (server names, user names, passwords, ...).

    See Also:
        `API SendInfo <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1SendInfo.html>`_
    """
    typeName: Literal['com.sun.star.ucb.SendInfo']

    def __init__(self, ProtocolType: typing.Optional[str] = ..., Value: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            ProtocolType (str, optional): ProtocolType value.
            Value (str, optional): Value value.
        """


    @property
    def ProtocolType(self) -> str:
        """
        the protocol to which the info is related (i.e.
        
        \"NNTP\", \"SMTP\", \"VIM\").
        """


    @property
    def Value(self) -> str:
        """
        the value.
        """


