# putao: Poor man's UTAU 🍇

![レロレロ](https://github.com/ongyx/putao/blob/main/logo.png?raw=true)

putao is a Python module that allows programmatic creation, editing, and saving of UTAU-style songs.

No more having to wrestle with encoding issues: all filenames and text files use UTF-8, re-encoded from Shift-JIS if necessary.

Originally, it was a joke inspired by [Composite]'s [Bad Apple] script but is now an experimental attempt at creating a voice synthesizer in Python.

## Why name it putao?

Because python + utau = putao. Conincidentally, it means 'grape' (葡萄) in Chinese.

## How it works

putao uses UTAU-format voicebanks (with `oto.ini` files).

(VERY IMPORTANT: Voicebank wavfiles must be mono (one channel) and must be in 16-bit integer format.)

The key difference is that putao does not shell out to `resampler.exe`, or any other `.exe` compiled resampler.
putao's resampler is written entierly in Python, thanks to [pyworld].

(Which means it is cross-platform, as long as you have a C compiler (for pyworld).)

The resampler's core logic is in [`model.py`](./putao/model.py), which models UTAU elements as python classes.
To create a new resampler, inherit from the `Resampler` class and override the abstract methods.

To save time, putao generates frequency files from pyworld for all the wavfiles in `oto.ini`,
similar to `.frq` files generated by UTAU's `resampler.exe`.
These analysis files are just numpy arrays saved in numpy's native format (hence the `.npy` extension).

Later on when rendering songs, the frequency files can be loaded back into the resampler.

## Making a song

Currently, songs can be created like so:

```
putao project import song.mml -f mml
```

and then rendered:

```
putao project render song.json
```

`.mml` song files are written with an extended form of [Music Macro Language], described below.

putao is CLI-only for now; creating a GUI to make songs is currently high priority,
and it will be worked on once putao's API is stabilised.

Check out some [examples](./examples): to render them, run `render.sh`.
This script will create a new project if needed and render the mml file.

You need to supply your own UTAU voicebank, though (make sure to extract with `putao extract` for utf8!).

## MML Syntax

(Anything enclosed in '[]' is optional.)

lengths below may be one of '1', '2', '4', '8', '16', '32', '64'
(1 -> whole note, 2 -> half note, 4 -> quarter note, 8 -> eighth note, etc.)

Core syntax:

    (key)[accidental][length]
        Play a note.

        key must be one of the letters 'abcdefg',
        and accidental may be '+', '#' (sharp) or '-' (flat).
        i.e 'c2'

    p[length] / r[length]
        Pause/rest playing notes.

    o(octave)
        Change the octave of the notes.

        octave must be a integer.

    > / <
        Shift current octave up or down.

    l(length)
        Change the length of the notes.

    t(tempo)
        Change the tempo of the notes.

        tempo must be an integer, in beats per minute.

Extended syntax:

    #[comment]
        A comment.
        Comments can appear anywhere in a line (i.e after commands).
        All text between the '#' until the next newline is ignored.

    @(trackname)
        Add any notes after this to trackname.
        Any notes without a specified track are implictly added to the 'global' track.

    |(lyrics)
        Add lyrics to the current track, split by whitespace.
        Each split is a phoneme.

## Todo

- Add midi support (WIP, 50%)
- GUI

## Install

```
pip install putao
```

On Linux, you may have to install your distro's equivelent of the following packages:

- `libsnffile1`
- `rubberband-cli`

i.e Debian:

```
sudo apt install libsndfile1 rubberband-cli
```

## License

MIT.


[Composite]: https://www.youtube.com/c/Composite1618
[Bad Apple]: https://github.com/Composite1618/CompositeMemes/
[pyworld]: https://github.com/JeremyCCHsu/Python-Wrapper-for-World-Vocoder
[Music Macro Language]: https://en.wikipedia.org/wiki/Music_Macro_Language
