# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class TableModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'columns': 'list[ColumnModel]',
        'primary_key': 'list[str]',
        'partition_mode': 'str',
        'date_partition_options': 'DatePartitionOptionsModel',
        'int_partition_options': 'IntPartitionOptionsModel',
        'row_count': 'int'
    }

    attribute_map = {
        'name': 'name',
        'columns': 'columns',
        'primary_key': 'primaryKey',
        'partition_mode': 'partitionMode',
        'date_partition_options': 'datePartitionOptions',
        'int_partition_options': 'intPartitionOptions',
        'row_count': 'rowCount'
    }

    def __init__(self, name=None, columns=None, primary_key=None, partition_mode='none', date_partition_options=None, int_partition_options=None, row_count=None, local_vars_configuration=None):  # noqa: E501
        """TableModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._columns = None
        self._primary_key = None
        self._partition_mode = None
        self._date_partition_options = None
        self._int_partition_options = None
        self._row_count = None
        self.discriminator = None

        self.name = name
        self.columns = columns
        if primary_key is not None:
            self.primary_key = primary_key
        if partition_mode is not None:
            self.partition_mode = partition_mode
        if date_partition_options is not None:
            self.date_partition_options = date_partition_options
        if int_partition_options is not None:
            self.int_partition_options = int_partition_options
        if row_count is not None:
            self.row_count = row_count

    @property
    def name(self):
        """Gets the name of this TableModel.  # noqa: E501

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :return: The name of this TableModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TableModel.

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :param name: The name of this TableModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 63):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._name = name

    @property
    def columns(self):
        """Gets the columns of this TableModel.  # noqa: E501


        :return: The columns of this TableModel.  # noqa: E501
        :rtype: list[ColumnModel]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this TableModel.


        :param columns: The columns of this TableModel.  # noqa: E501
        :type: list[ColumnModel]
        """
        if self.local_vars_configuration.client_side_validation and columns is None:  # noqa: E501
            raise ValueError("Invalid value for `columns`, must not be `None`")  # noqa: E501

        self._columns = columns

    @property
    def primary_key(self):
        """Gets the primary_key of this TableModel.  # noqa: E501

        Primary key columns names. Any columns listed as a primary key will be marked as required by default.   # noqa: E501

        :return: The primary_key of this TableModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._primary_key

    @primary_key.setter
    def primary_key(self, primary_key):
        """Sets the primary_key of this TableModel.

        Primary key columns names. Any columns listed as a primary key will be marked as required by default.   # noqa: E501

        :param primary_key: The primary_key of this TableModel.  # noqa: E501
        :type: list[str]
        """

        self._primary_key = primary_key

    @property
    def partition_mode(self):
        """Gets the partition_mode of this TableModel.  # noqa: E501


        :return: The partition_mode of this TableModel.  # noqa: E501
        :rtype: str
        """
        return self._partition_mode

    @partition_mode.setter
    def partition_mode(self, partition_mode):
        """Sets the partition_mode of this TableModel.


        :param partition_mode: The partition_mode of this TableModel.  # noqa: E501
        :type: str
        """
        allowed_values = ["none", "date", "int"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and partition_mode not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `partition_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(partition_mode, allowed_values)
            )

        self._partition_mode = partition_mode

    @property
    def date_partition_options(self):
        """Gets the date_partition_options of this TableModel.  # noqa: E501


        :return: The date_partition_options of this TableModel.  # noqa: E501
        :rtype: DatePartitionOptionsModel
        """
        return self._date_partition_options

    @date_partition_options.setter
    def date_partition_options(self, date_partition_options):
        """Sets the date_partition_options of this TableModel.


        :param date_partition_options: The date_partition_options of this TableModel.  # noqa: E501
        :type: DatePartitionOptionsModel
        """

        self._date_partition_options = date_partition_options

    @property
    def int_partition_options(self):
        """Gets the int_partition_options of this TableModel.  # noqa: E501


        :return: The int_partition_options of this TableModel.  # noqa: E501
        :rtype: IntPartitionOptionsModel
        """
        return self._int_partition_options

    @int_partition_options.setter
    def int_partition_options(self, int_partition_options):
        """Sets the int_partition_options of this TableModel.


        :param int_partition_options: The int_partition_options of this TableModel.  # noqa: E501
        :type: IntPartitionOptionsModel
        """

        self._int_partition_options = int_partition_options

    @property
    def row_count(self):
        """Gets the row_count of this TableModel.  # noqa: E501


        :return: The row_count of this TableModel.  # noqa: E501
        :rtype: int
        """
        return self._row_count

    @row_count.setter
    def row_count(self, row_count):
        """Sets the row_count of this TableModel.


        :param row_count: The row_count of this TableModel.  # noqa: E501
        :type: int
        """

        self._row_count = row_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TableModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TableModel):
            return True

        return self.to_dict() != other.to_dict()
