# coding: utf-8

"""
    printnanny-api-client

    Official API client library for print-nanny.com  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Contact: leigh@print-nanny.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from printnanny_api_client.configuration import Configuration


class MobileAuthRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'mobile': 'str'
    }

    attribute_map = {
        'mobile': 'mobile'
    }

    def __init__(self, mobile=None, local_vars_configuration=None):  # noqa: E501
        """MobileAuthRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._mobile = None
        self.discriminator = None

        self.mobile = mobile

    @property
    def mobile(self):
        """Gets the mobile of this MobileAuthRequest.  # noqa: E501


        :return: The mobile of this MobileAuthRequest.  # noqa: E501
        :rtype: str
        """
        return self._mobile

    @mobile.setter
    def mobile(self, mobile):
        """Sets the mobile of this MobileAuthRequest.


        :param mobile: The mobile of this MobileAuthRequest.  # noqa: E501
        :type mobile: str
        """
        if self.local_vars_configuration.client_side_validation and mobile is None:  # noqa: E501
            raise ValueError("Invalid value for `mobile`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                mobile is not None and len(mobile) > 17):
            raise ValueError("Invalid value for `mobile`, length must be less than or equal to `17`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                mobile is not None and len(mobile) < 1):
            raise ValueError("Invalid value for `mobile`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                mobile is not None and not re.search(r'^\+[1-9]\d{1,14}$', mobile)):  # noqa: E501
            raise ValueError(r"Invalid value for `mobile`, must be a follow pattern or equal to `/^\+[1-9]\d{1,14}$/`")  # noqa: E501

        self._mobile = mobile

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MobileAuthRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MobileAuthRequest):
            return True

        return self.to_dict() != other.to_dict()
