校異情報ライブラリ
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

日本語のマニュアルは以下です。

<https://zenn.dev/nakamura196/articles/442da1c74afae1>

## Install

``` sh
pip install koui
```

## How to use

[See the documentation](api.html) for full details of the Omeka API
Client.

``` python
from koui.api import KouiAPIClient
```

## 比較するテキストの名前とテキストを入力してください。

``` python
name_1 = "中村式五十音"
text_1 = '''あいうえお
かきくけこ
さしすせそ
たちぬてと'''
```

``` python
name_2 = "中村式五十音又様"
text_2 = '''あいうえお
こけきくか
さしすせそ
たじづてと'''
```

------------------------------------------------------------------------

### KouiAPIClient.convert

>      KouiAPIClient.convert (name_1, text_1, name_2, text_2, output='html')

2つのテキストを比較して、xmlまたはhtmlを出力する

|             | **Type**              | **Default** | **Details**                                |
|-------------|-----------------------|-------------|--------------------------------------------|
| name_1      | str                   |             | テキスト1の名前                            |
| text_1      | str                   |             | テキスト1                                  |
| name_2      | str                   |             | テキスト2の名前                            |
| text_2      | str                   |             | テキスト2                                  |
| output      | str                   | html        | 出力形式(xmlまたはhtml), by default “html” |
| **Returns** | **bs4.BeautifulSoup** |             | **xmlまたはhtml**                          |

------------------------------------------------------------------------

### KouiAPIClient.save

>      KouiAPIClient.save (soup, path)

xmlまたはhtmlを保存する

|      | **Type**          | **Details**   |
|------|-------------------|---------------|
| soup | bs4.BeautifulSoup | xmlまたはhtml |
| path | str               | 保存先        |

``` python
soup = KouiAPIClient.convert(name_1, text_1, name_2, text_2, "html")
KouiAPIClient.save(soup, 'examples/out.html')
```

``` python
soup = KouiAPIClient.convert(name_1, text_1, name_2, text_2, "xml")
KouiAPIClient.save(soup, 'examples/out.xml')
```

``` python
res = KouiAPIClient.compare('examples/out.xml')
KouiAPIClient.saveAsExcel(res, 'examples/out.xlsx')
```

``` python
df = KouiAPIClient.convertJson2Df(res)
df
```
