from math import pi

INT16_MAX = 0x7FFF

INIT_WAIT_TIME = 1000000

MAX_DRIVE_CURRENT = 64
DEFAULT_DRIVE_VEL = 0.2618

BROADCAST_ADDR = 0

POSITION_CONV = 2.0 * pi
VELOCITY_CONV = 8.0
EFFORT_CONV = 256.0
CURRENT_CONV = 64.0
VOLTAGE_CONV = 64.0
TEMPERATURE_CONV = 128.0
INERTIA_CONV = 32.0
DAMPING_CONV = 128.0
STIFFNESS_CONV = 1024.0

NO_STATE = -1
INIT_STATE = 0
PROGRAM_STATE = 1
STARTUP_STATE = 2
RUN_STATE = 3
HOLD_STATE = 4
SLEEP_STATE = 5
FAULT_STATE = 6
NUM_STATES = 7

STATE_CHANGE_CMD = 0
ERROR_TELEM = 1
HIGH_SPEED_TELEM = 3
CONTROL_CMD = 4
MEDIUM_SPEED_TELEM = 5
IMPEDANCE_CMD = 6
LOW_SPEED_TELEM = 7
DEBUG_TELEM = 9
CURRENT_CMD = 10
PARAMETER_TELEM = 11
PARAMETER_CMD = 12
STATUS_CMD = 14
STATUS_TELEM = 15
