# mypy-boto3-docdb

[![PyPI - mypy-boto3-docdb](https://img.shields.io/pypi/v/mypy-boto3-docdb.svg?color=blue)](https://pypi.org/project/mypy-boto3-docdb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-docdb.svg?color=blue)](https://pypi.org/project/mypy-boto3-docdb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-docdb?color=blue)](https://pypistats.org/packages/mypy-boto3-docdb)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DocDB 1.17.63](https://boto3.amazonaws.com/v1/documentation/api/1.17.63/reference/services/docdb.html#DocDB) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.8.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[auto-generated docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_docdb/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-docdb](#mypy-boto3-docdb)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `DocDB` service.

```bash
python -m pip install boto3-stubs[docdb]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[docdb]` in your environment: `python -m pip install 'boto3-stubs[docdb]'`

Both type checking and auto-complete should work for `DocDB` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[docdb]` in your environment: `python -m pip install 'boto3-stubs[docdb]'`

Both type checking and auto-complete should work for `DocDB` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[docdb]` in your environment: `python -m pip install 'boto3-stubs[docdb]'`
- Run `mypy` as usual

Type checking should work for `DocDB` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[docdb]` in your environment: `python -m pip install 'boto3-stubs[docdb]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DocDB` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DocDBClient` provides annotations for `boto3.client("docdb")`.

```python
import boto3

from mypy_boto3_docdb import DocDBClient

client: DocDBClient = boto3.client("docdb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DocDBClient = session.client("docdb")
```

### Paginators annotations

`mypy_boto3_docdb.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_docdb import DocDBClient
from mypy_boto3_docdb.paginator import (
    DescribeCertificatesPaginator,
    DescribeDBClusterParameterGroupsPaginator,
    DescribeDBClusterParametersPaginator,
    DescribeDBClusterSnapshotsPaginator,
    DescribeDBClustersPaginator,
    DescribeDBEngineVersionsPaginator,
    DescribeDBInstancesPaginator,
    DescribeDBSubnetGroupsPaginator,
    DescribeEventSubscriptionsPaginator,
    DescribeEventsPaginator,
    DescribeOrderableDBInstanceOptionsPaginator,
    DescribePendingMaintenanceActionsPaginator,
)

client: DocDBClient = boto3.client("docdb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_certificates_paginator: DescribeCertificatesPaginator = client.get_paginator("describe_certificates")
describe_db_cluster_parameter_groups_paginator: DescribeDBClusterParameterGroupsPaginator = client.get_paginator("describe_db_cluster_parameter_groups")
describe_db_cluster_parameters_paginator: DescribeDBClusterParametersPaginator = client.get_paginator("describe_db_cluster_parameters")
describe_db_cluster_snapshots_paginator: DescribeDBClusterSnapshotsPaginator = client.get_paginator("describe_db_cluster_snapshots")
describe_db_clusters_paginator: DescribeDBClustersPaginator = client.get_paginator("describe_db_clusters")
describe_db_engine_versions_paginator: DescribeDBEngineVersionsPaginator = client.get_paginator("describe_db_engine_versions")
describe_db_instances_paginator: DescribeDBInstancesPaginator = client.get_paginator("describe_db_instances")
describe_db_subnet_groups_paginator: DescribeDBSubnetGroupsPaginator = client.get_paginator("describe_db_subnet_groups")
describe_event_subscriptions_paginator: DescribeEventSubscriptionsPaginator = client.get_paginator("describe_event_subscriptions")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
describe_orderable_db_instance_options_paginator: DescribeOrderableDBInstanceOptionsPaginator = client.get_paginator("describe_orderable_db_instance_options")
describe_pending_maintenance_actions_paginator: DescribePendingMaintenanceActionsPaginator = client.get_paginator("describe_pending_maintenance_actions")
```


### Waiters annotations

`mypy_boto3_docdb.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_docdb import DocDBClient
from mypy_boto3_docdb.waiter import (
    DBInstanceAvailableWaiter,
    DBInstanceDeletedWaiter,
)

client: DocDBClient = boto3.client("docdb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
db_instance_available_waiter: DBInstanceAvailableWaiter = client.get_waiter("db_instance_available")
db_instance_deleted_waiter: DBInstanceDeletedWaiter = client.get_waiter("db_instance_deleted")
```





### Literals

`mypy_boto3_docdb.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_docdb.literals import (
    ApplyMethod,
    DBInstanceAvailableWaiterName,
    DBInstanceDeletedWaiterName,
    DescribeCertificatesPaginatorName,
    DescribeDBClusterParameterGroupsPaginatorName,
    DescribeDBClusterParametersPaginatorName,
    DescribeDBClusterSnapshotsPaginatorName,
    DescribeDBClustersPaginatorName,
    DescribeDBEngineVersionsPaginatorName,
    DescribeDBInstancesPaginatorName,
    DescribeDBSubnetGroupsPaginatorName,
    DescribeEventSubscriptionsPaginatorName,
    DescribeEventsPaginatorName,
    DescribeOrderableDBInstanceOptionsPaginatorName,
    DescribePendingMaintenanceActionsPaginatorName,
    SourceType,
)

def check_value(value: ApplyMethod) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_docdb.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_docdb.type_defs import (
    AddSourceIdentifierToSubscriptionResultTypeDef,
    ApplyPendingMaintenanceActionResultTypeDef,
    AvailabilityZoneTypeDef,
    CertificateMessageTypeDef,
    CertificateTypeDef,
    CloudwatchLogsExportConfigurationTypeDef,
    CopyDBClusterParameterGroupResultTypeDef,
    CopyDBClusterSnapshotResultTypeDef,
    CreateDBClusterParameterGroupResultTypeDef,
    CreateDBClusterResultTypeDef,
    CreateDBClusterSnapshotResultTypeDef,
    CreateDBInstanceResultTypeDef,
    CreateDBSubnetGroupResultTypeDef,
    CreateEventSubscriptionResultTypeDef,
    DBClusterMemberTypeDef,
    DBClusterMessageTypeDef,
    DBClusterParameterGroupDetailsTypeDef,
    DBClusterParameterGroupNameMessageTypeDef,
    DBClusterParameterGroupTypeDef,
    DBClusterParameterGroupsMessageTypeDef,
    DBClusterRoleTypeDef,
    DBClusterSnapshotAttributeTypeDef,
    DBClusterSnapshotAttributesResultTypeDef,
    DBClusterSnapshotMessageTypeDef,
    DBClusterSnapshotTypeDef,
    DBClusterTypeDef,
    DBEngineVersionMessageTypeDef,
    DBEngineVersionTypeDef,
    DBInstanceMessageTypeDef,
    DBInstanceStatusInfoTypeDef,
    DBInstanceTypeDef,
    DBSubnetGroupMessageTypeDef,
    DBSubnetGroupTypeDef,
    DeleteDBClusterResultTypeDef,
    DeleteDBClusterSnapshotResultTypeDef,
    DeleteDBInstanceResultTypeDef,
    DeleteEventSubscriptionResultTypeDef,
    DescribeDBClusterSnapshotAttributesResultTypeDef,
    DescribeEngineDefaultClusterParametersResultTypeDef,
    EndpointTypeDef,
    EngineDefaultsTypeDef,
    EventCategoriesMapTypeDef,
    EventCategoriesMessageTypeDef,
    EventSubscriptionTypeDef,
    EventSubscriptionsMessageTypeDef,
    EventTypeDef,
    EventsMessageTypeDef,
    FailoverDBClusterResultTypeDef,
    FilterTypeDef,
    ModifyDBClusterResultTypeDef,
    ModifyDBClusterSnapshotAttributeResultTypeDef,
    ModifyDBInstanceResultTypeDef,
    ModifyDBSubnetGroupResultTypeDef,
    ModifyEventSubscriptionResultTypeDef,
    OrderableDBInstanceOptionTypeDef,
    OrderableDBInstanceOptionsMessageTypeDef,
    PaginatorConfigTypeDef,
    ParameterTypeDef,
    PendingCloudwatchLogsExportsTypeDef,
    PendingMaintenanceActionTypeDef,
    PendingMaintenanceActionsMessageTypeDef,
    PendingModifiedValuesTypeDef,
    RebootDBInstanceResultTypeDef,
    RemoveSourceIdentifierFromSubscriptionResultTypeDef,
    ResourcePendingMaintenanceActionsTypeDef,
    RestoreDBClusterFromSnapshotResultTypeDef,
    RestoreDBClusterToPointInTimeResultTypeDef,
    StartDBClusterResultTypeDef,
    StopDBClusterResultTypeDef,
    SubnetTypeDef,
    TagListMessageTypeDef,
    TagTypeDef,
    UpgradeTargetTypeDef,
    VpcSecurityGroupMembershipTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddSourceIdentifierToSubscriptionResultTypeDef:
    return {
      ...
    }
```
