### IDM LP
![PyPI](https://img.shields.io/pypi/v/idm-lp)
![GitHub](https://img.shields.io/github/license/IDM-Team/idm_lp)
![GitHub repo size](https://img.shields.io/github/repo-size/IDM-Team/idm_lp)
[![Downloads](https://pepy.tech/badge/idm-lp)](https://pepy.tech/project/idm-lp)

LP модуль позволяет работать приемнику сигналов «IDM» работать в любых чатах.
Так же он добавляет игнор, глоигнор, мут и алиасы.

<!--
4: 252535322122234232
  1  2  3  4  5
1 a  b  c  d  e
2 f  g  h  ij k
3 l  m  n  o  p
4 q  r  s  y  u
5 v  w  x  y  z
-->

## Оглавление
1. [Установка](#установка)
2. [Аргументы запуска](#аргументы-запуска)
3. [Структура конфигурационного файла config.json](#структура-кофигурационного-файла-configjson)
4. [Команды модуля ЛП](#команды-модуля-лп)

## Установка

Существует 2 вида установки:
1. [Деплой на Heroku](https://github.com/IDM-Team/idm_lp/blob/heroku-deploy/README.md)
2. [Установка на свое устройство](https://github.com/IDM-Team/idm_lp/blob/self-system-install/README.md)


## Аргументы запуска 
- `--logger_level [DEBUG | INFO | WARNING | ERROR | CRITICAL]` — уровень логирования
- `--config_path CONFIG_PATH` — путь до файла с конфигурацией
- `--use_app_data` — использовать папку AppData/IDM (Windows). При использовании этой настройки AppData/IDM и config_path складываются
- `--log_to_path` — логи в файл
- `--base_domain BASE_DOMAIN` — базовый домен
- `--use_local_db` — не использовать конфигурационный файл с сервера IDM

## Структура конфигурационного файла config.json
- `tokens`            - Токены вк в количестве 3х штук. Получить можно [здесь](https://oauth.vk.com/authorize?client_id=2685278&scope=1073737727&redirect_uri=https://oauth.vk.com/blank.html&display=page&response_type=token&revoke=1)
- `service_prefixes`  - Префиксы для выполнения команд модуля ЛП (добавление в мутлист, создание алиасов и тд.)

## Команды модуля ЛП
- `{сервисный префикс}` пинг/кинг/пиу — пинг
- `{сервисный префикс}` инфо — информация о модуле ЛП
***
- `{сервисный префикс}` префиксы свои — просмотр своих префиксов
- `{сервисный префикс}` префиксы дежурный — просмотр префиксов для дежурного
- `{сервисный префикс}` +префикс `[свой/дежурный]` — создание префикса
- `{сервисный префикс}` -префикс `[свой/дежурный]` — удаление префикса
***
- `{сервисный префикс}` алиасы - просмотр алиасов
- `{сервисный префикс}` +алиас `{имя}` {enter} `{команда которую получает модуль ЛП}` {enter} `{команда которую отсылает модуль ЛП}`  — создание алиаса
- `{сервисный префикс}` -алиас `{имя}` — удаление алиаса
- `{сервисный префикс}` алиасы паки — просмотр паков алиасов
- `{сервисный префикс}` алиасы пак `{имя пака}` — просмотр пака алиасов
- `{сервисный префикс}` алиасы импорт `{имя пака}` — импорт пака алиасов
***
- `{сервисный префикс}` игнорлист — просмотр игнорлиста
- `{сервисный префикс}` игнорлист все — просмотр игнорлиста по всем чатам
- `{сервисный префикс}` +игнор `[{ссылка}/{упоминание}/{реплай}]` — добавить в игнорлист
- `{сервисный префикс}` -игнор `[{ссылка}/{упоминание}/{реплай}]` — удалить из игнорлиста
***
- `{сервисный префикс}` глоигнорлист — просмотр глоигнорлиста
- `{сервисный префикс}` +глоигнор `[{ссылка}/{упоминание}/{реплай}]` — добавить в глоигнорлист
- `{сервисный префикс}` -глоигнор `[{ссылка}/{упоминание}/{реплай}]` — удалить из глоигнорлиста
***
- `{сервисный префикс}` мутлист — просмотр мутлиста
- `{сервисный префикс}` мутлист все — просмотр мутлиста по всем чатам
- `{сервисный префикс}` +мут `[{ссылка}/{упоминание}/{реплай}]` `{задержка}` — добавить в мутлист
- `{сервисный префикс}` -мут `[{ссылка}/{упоминание}/{реплай}]` — удалить из мутлиста
***
- `{сервисный префикс}` довы — просмотр доверенных пользователей
- `{сервисный префикс}` +дов `[{ссылка}/{упоминание}/{реплай}]` — добавить в дов-лист
- `{сервисный префикс}` -дов `[{ссылка}/{упоминание}/{реплай}]` — удалить из дов-листа
***
- `{сервисный префикс}` regex — Просмотр шаблонов для удаления
- `{сервисный префикс}` +regex `{имя}` `{regex}` `{для всех:да|нет}` — Добавить шаблон
- `{сервисный префикс}` -regex `{имя}` — Удалить шаблон
***
- `{сервисный префикс}` +потворялка — включить повторялку
- `{сервисный префикс}` -потворялка — выключить повторялку
- `{триггер повторялки}``{сообщение}` — повторить сообщение
***
- `{сервисный префикс}` eval/exec `{script}` — выполнение скрипта
***
- `{сервисный префикс}` -уведы — модуль будет удалять упоминания типа `@all`, `@online`...
- `{сервисный префикс}` +уведы — не будет удалять упоминания типа `@all`, `@online`...
***
- `{сервисный префикс}` рп — просмотр РП команд
- `{сервисный префикс}` +мрп `{имя}` `{падеж}`\n`{форматер для мужчин}`\n`{форматер для женщин}`\n`{окончание для всех}` — просмотр РП команд
- `{сервисный префикс}` -мрп `{имя}` — просмотр РП команд
***
- `{сервисный префикс}` секретный код `{код}` — установка секретного кода
- `{сервисный префикс}` токен каптчи `{токен}` — установка токена рукаптчи
***
- `{сервисный префикс}` +автовыход — включить автовыход из бесед в которые вас пригласили
- `{сервисный префикс}` -автовыход — выключить автовыход из бесед в которые вас пригласили
- `{сервисный префикс}` автовыход +удаление — удалять диалог при выходе
- `{сервисный префикс}` автовыход -удаление — неудалять диалог при выходе
- `{сервисный префикс}` автовыход +чс — включить добавление в ЧС пригласившего 
- `{сервисный префикс}` автовыход -чс — выключить добавление в ЧС пригласившего 
***
- `{сервисный префикс}` +слоумо `{время}`\n`{текст}` — установка слоумо режима
- `{сервисный префикс}` -слоумо — удаление слоумо режима
- `{сервисный префикс}` слоумо — просмотр настроек слоумо режима
- `{сервисный префикс}` слоумо +белый список `{пользователь}` — добавление пользователя в белый список
- `{сервисный префикс}` слоумо -белый список `{пользователь}` — удаление пользователя из белого списка
- `{сервисный префикс}` слоумо время `{время}` — изменение времени задержки
- `{сервисный префикс}` слоумо текст `{текст}` — изменение текста предупреждения
***
- `{сервисный префикс}` +добавление `{текст}` — включить отправку запросов в друзья, пользователям, которые заходят в чат. При этом будет отправляться приветственный `{текст}`.
- `{сервисный префикс}` -добавление — отключить отправку запросов в друзья, пользователям, которые заходят в чат.
***
- `{сервисный префикс}` выключать уведы — включить выключение уведомлений при входе в беседу 
- `{сервисный префикс}` не выключать уведы — выключить выключение уведомлений при входе в беседу 
***
- `{сервисный префикс}` +заражение — включить ответное заражение.
- `{сервисный префикс}` -заражение — отключить ответное заражение.
***
- `{сервисный префикс}` +автозаражение — включить автоматическое.
- `{сервисный префикс}` -автозаражение — отключить автоматическое.
- `{сервисный префикс}` автозаражение интервал `{интервал}` — установить интервал автоматического заражения.
- `{сервисный префикс}` автозаражение аргумент `{аргумент}` — установить аргумент автоматического заражения.
- `{сервисный префикс}` автозаражение установить чат — установить чат автоматического заражения.
- `{сервисный префикс}` автозаражение — информация об автоматическом заражении.
***
- `{сервисный префикс}` +nometa — включить nometa.
- `{сервисный префикс}` -nometa — отключить nometa.
- `{сервисный префикс}` nometa сообщение `{текст}` — изменить текст сообщения.
- `{сервисный префикс}` nometa задержка `{задержка}` — изменить задержку.
***
- `{сервисный префикс}` получить бд — получить бд с сервера IDM
***
- `{сервисный префикс}` таймеры — показать текущие таймеры
- `{сервисный префикс}` !таймеры — показать текущие таймеры загруженные в планировщике задач
- `{сервисный префикс}` +таймер `{имя таймера}` смс `{время}`\n`текст сообщения` — создание таймера, который сработает в определенное время
- `{сервисный префикс}` +цтаймер `{имя таймера}` смс `{интервал}`\n`текст сообщения` — создание циклического таймера
- `{сервисный префикс}` +ктаймер `{имя таймера}` смс `{CRON}`\n`текст сообщения` — создание таймера, который сработает по CRON выражению
- `{сервисный префикс}` -таймер `{имя таймера}` — удаление таймера