# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['idm_lp',
 'idm_lp.commands',
 'idm_lp.commands.members_manager',
 'idm_lp.database',
 'idm_lp.error_handlers']

package_data = \
{'': ['*']}

install_requires = \
['APScheduler>=3.9.1,<4.0',
 'pydantic>=1.7.3,<2.0',
 'python-rucaptcha>=3.0,<4.0',
 'vkbottle>=2.7.12,<3.0.0']

setup_kwargs = {
    'name': 'idm-lp',
    'version': '1.15.0',
    'description': 'LP модуль позволяет работать приемнику сигналов «IDM multi» работать в любых чатах. Так же он добавляет игнор, глоигнор, мут и алиасы.',
    'long_description': '### IDM LP\n![PyPI](https://img.shields.io/pypi/v/idm-lp)\n![GitHub](https://img.shields.io/github/license/IDM-Team/idm_lp)\n![GitHub repo size](https://img.shields.io/github/repo-size/IDM-Team/idm_lp)\n[![Downloads](https://pepy.tech/badge/idm-lp)](https://pepy.tech/project/idm-lp)\n\nLP модуль позволяет работать приемнику сигналов «IDM» работать в любых чатах.\nТак же он добавляет игнор, глоигнор, мут и алиасы.\n\n<!--\n4: 252535322122234232\n  1  2  3  4  5\n1 a  b  c  d  e\n2 f  g  h  ij k\n3 l  m  n  o  p\n4 q  r  s  y  u\n5 v  w  x  y  z\n-->\n\n## Оглавление\n1. [Установка](#установка)\n2. [Аргументы запуска](#аргументы-запуска)\n3. [Структура конфигурационного файла config.json](#структура-кофигурационного-файла-configjson)\n4. [Команды модуля ЛП](#команды-модуля-лп)\n\n## Установка\n\nСуществует 2 вида установки:\n1. [Деплой на Heroku](https://github.com/IDM-Team/idm_lp/blob/heroku-deploy/README.md)\n2. [Установка на свое устройство](https://github.com/IDM-Team/idm_lp/blob/self-system-install/README.md)\n\n\n## Аргументы запуска \n- `--logger_level [DEBUG | INFO | WARNING | ERROR | CRITICAL]` — уровень логирования\n- `--config_path CONFIG_PATH` — путь до файла с конфигурацией\n- `--use_app_data` — использовать папку AppData/IDM (Windows). При использовании этой настройки AppData/IDM и config_path складываются\n- `--log_to_path` — логи в файл\n- `--base_domain BASE_DOMAIN` — базовый домен\n- `--use_local_db` — не использовать конфигурационный файл с сервера IDM\n\n## Структура конфигурационного файла config.json\n- `tokens`            - Токены вк в количестве 3х штук. Получить можно [здесь](https://oauth.vk.com/authorize?client_id=2685278&scope=1073737727&redirect_uri=https://oauth.vk.com/blank.html&display=page&response_type=token&revoke=1)\n- `service_prefixes`  - Префиксы для выполнения команд модуля ЛП (добавление в мутлист, создание алиасов и тд.)\n\n## Команды модуля ЛП\n- `{сервисный префикс}` пинг/кинг/пиу — пинг\n- `{сервисный префикс}` инфо — информация о модуле ЛП\n***\n- `{сервисный префикс}` префиксы свои — просмотр своих префиксов\n- `{сервисный префикс}` префиксы дежурный — просмотр префиксов для дежурного\n- `{сервисный префикс}` +префикс `[свой/дежурный]` — создание префикса\n- `{сервисный префикс}` -префикс `[свой/дежурный]` — удаление префикса\n***\n- `{сервисный префикс}` алиасы - просмотр алиасов\n- `{сервисный префикс}` +алиас `{имя}` {enter} `{команда которую получает модуль ЛП}` {enter} `{команда которую отсылает модуль ЛП}`  — создание алиаса\n- `{сервисный префикс}` -алиас `{имя}` — удаление алиаса\n- `{сервисный префикс}` алиасы паки — просмотр паков алиасов\n- `{сервисный префикс}` алиасы пак `{имя пака}` — просмотр пака алиасов\n- `{сервисный префикс}` алиасы импорт `{имя пака}` — импорт пака алиасов\n***\n- `{сервисный префикс}` игнорлист — просмотр игнорлиста\n- `{сервисный префикс}` игнорлист все — просмотр игнорлиста по всем чатам\n- `{сервисный префикс}` +игнор `[{ссылка}/{упоминание}/{реплай}]` — добавить в игнорлист\n- `{сервисный префикс}` -игнор `[{ссылка}/{упоминание}/{реплай}]` — удалить из игнорлиста\n***\n- `{сервисный префикс}` глоигнорлист — просмотр глоигнорлиста\n- `{сервисный префикс}` +глоигнор `[{ссылка}/{упоминание}/{реплай}]` — добавить в глоигнорлист\n- `{сервисный префикс}` -глоигнор `[{ссылка}/{упоминание}/{реплай}]` — удалить из глоигнорлиста\n***\n- `{сервисный префикс}` мутлист — просмотр мутлиста\n- `{сервисный префикс}` мутлист все — просмотр мутлиста по всем чатам\n- `{сервисный префикс}` +мут `[{ссылка}/{упоминание}/{реплай}]` `{задержка}` — добавить в мутлист\n- `{сервисный префикс}` -мут `[{ссылка}/{упоминание}/{реплай}]` — удалить из мутлиста\n***\n- `{сервисный префикс}` довы — просмотр доверенных пользователей\n- `{сервисный префикс}` +дов `[{ссылка}/{упоминание}/{реплай}]` — добавить в дов-лист\n- `{сервисный префикс}` -дов `[{ссылка}/{упоминание}/{реплай}]` — удалить из дов-листа\n***\n- `{сервисный префикс}` regex — Просмотр шаблонов для удаления\n- `{сервисный префикс}` +regex `{имя}` `{regex}` `{для всех:да|нет}` — Добавить шаблон\n- `{сервисный префикс}` -regex `{имя}` — Удалить шаблон\n***\n- `{сервисный префикс}` +потворялка — включить повторялку\n- `{сервисный префикс}` -потворялка — выключить повторялку\n- `{триггер повторялки}``{сообщение}` — повторить сообщение\n***\n- `{сервисный префикс}` eval/exec `{script}` — выполнение скрипта\n***\n- `{сервисный префикс}` -уведы — модуль будет удалять упоминания типа `@all`, `@online`...\n- `{сервисный префикс}` +уведы — не будет удалять упоминания типа `@all`, `@online`...\n***\n- `{сервисный префикс}` рп — просмотр РП команд\n- `{сервисный префикс}` +мрп `{имя}` `{падеж}`\\n`{форматер для мужчин}`\\n`{форматер для женщин}`\\n`{окончание для всех}` — просмотр РП команд\n- `{сервисный префикс}` -мрп `{имя}` — просмотр РП команд\n***\n- `{сервисный префикс}` секретный код `{код}` — установка секретного кода\n- `{сервисный префикс}` токен каптчи `{токен}` — установка токена рукаптчи\n***\n- `{сервисный префикс}` +автовыход — включить автовыход из бесед в которые вас пригласили\n- `{сервисный префикс}` -автовыход — выключить автовыход из бесед в которые вас пригласили\n- `{сервисный префикс}` автовыход +удаление — удалять диалог при выходе\n- `{сервисный префикс}` автовыход -удаление — неудалять диалог при выходе\n- `{сервисный префикс}` автовыход +чс — включить добавление в ЧС пригласившего \n- `{сервисный префикс}` автовыход -чс — выключить добавление в ЧС пригласившего \n***\n- `{сервисный префикс}` +слоумо `{время}`\\n`{текст}` — установка слоумо режима\n- `{сервисный префикс}` -слоумо — удаление слоумо режима\n- `{сервисный префикс}` слоумо — просмотр настроек слоумо режима\n- `{сервисный префикс}` слоумо +белый список `{пользователь}` — добавление пользователя в белый список\n- `{сервисный префикс}` слоумо -белый список `{пользователь}` — удаление пользователя из белого списка\n- `{сервисный префикс}` слоумо время `{время}` — изменение времени задержки\n- `{сервисный префикс}` слоумо текст `{текст}` — изменение текста предупреждения\n***\n- `{сервисный префикс}` +добавление `{текст}` — включить отправку запросов в друзья, пользователям, которые заходят в чат. При этом будет отправляться приветственный `{текст}`.\n- `{сервисный префикс}` -добавление — отключить отправку запросов в друзья, пользователям, которые заходят в чат.\n***\n- `{сервисный префикс}` выключать уведы — включить выключение уведомлений при входе в беседу \n- `{сервисный префикс}` не выключать уведы — выключить выключение уведомлений при входе в беседу \n***\n- `{сервисный префикс}` +заражение — включить ответное заражение.\n- `{сервисный префикс}` -заражение — отключить ответное заражение.\n***\n- `{сервисный префикс}` +автозаражение — включить автоматическое.\n- `{сервисный префикс}` -автозаражение — отключить автоматическое.\n- `{сервисный префикс}` автозаражение интервал `{интервал}` — установить интервал автоматического заражения.\n- `{сервисный префикс}` автозаражение аргумент `{аргумент}` — установить аргумент автоматического заражения.\n- `{сервисный префикс}` автозаражение установить чат — установить чат автоматического заражения.\n- `{сервисный префикс}` автозаражение — информация об автоматическом заражении.\n***\n- `{сервисный префикс}` +nometa — включить nometa.\n- `{сервисный префикс}` -nometa — отключить nometa.\n- `{сервисный префикс}` nometa сообщение `{текст}` — изменить текст сообщения.\n- `{сервисный префикс}` nometa задержка `{задержка}` — изменить задержку.\n***\n- `{сервисный префикс}` получить бд — получить бд с сервера IDM\n***\n- `{сервисный префикс}` таймеры — показать текущие таймеры\n- `{сервисный префикс}` !таймеры — показать текущие таймеры загруженные в планировщике задач\n- `{сервисный префикс}` +таймер `{имя таймера}` смс `{время}`\\n`текст сообщения` — создание таймера, который сработает в определенное время\n- `{сервисный префикс}` +цтаймер `{имя таймера}` смс `{интервал}`\\n`текст сообщения` — создание циклического таймера\n- `{сервисный префикс}` +ктаймер `{имя таймера}` смс `{CRON}`\\n`текст сообщения` — создание таймера, который сработает по CRON выражению\n- `{сервисный префикс}` -таймер `{имя таймера}` — удаление таймера',
    'author': 'lordralinc',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://idmduty.ru',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
