# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['oka']

package_data = \
{'': ['*']}

install_requires = \
['idict>=1.211129.0,<2.0.0',
 'python-dotenv>=0.19.2,<0.20.0',
 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'oka',
    'version': '0.211129.1',
    'description': 'Python client for oka repository',
    'long_description': '![test](https://github.com/rabizao/oka/workflows/test/badge.svg)\n[![codecov](https://codecov.io/gh/rabizao/oka/branch/main/graph/badge.svg)](https://codecov.io/gh/rabizao/oka)\n<a href="https://pypi.org/project/oka">\n<img src="https://img.shields.io/pypi/v/oka.svg?label=release&color=blue&style=flat-square" alt="pypi">\n</a>\n![Python version](https://img.shields.io/badge/python-3.8%20%7C%203.9-blue.svg)\n[![license: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)\n\n[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5501845.svg)](https://doi.org/10.5281/zenodo.5501845)\n[![arXiv](https://img.shields.io/badge/arXiv-2109.06028-b31b1b.svg?style=flat-square)](https://arxiv.org/abs/2109.06028)\n[![User Manual](https://img.shields.io/badge/doc-user%20manual-a0a0a0.svg)](https://rabizao.github.io/oka)\n[![API Documentation](https://img.shields.io/badge/doc-API%20%28auto%29-a0a0a0.svg)](https://rabizao.github.io/oka/api)\n\n# oka - Client for OKA repository\n[Latest version as a package](https://pypi.org/project/oka)\n\n[Current code](https://github.com/rabizao/oka)\n\n[User manual](https://rabizao.github.io/oka)\n\n[API documentation](https://rabizao.github.io/oka/api)\n\n## Overview\n`oka` is a client for Oka repository.\nIt also provides utilities to process data.\n\n## Installation\n### ...as a standalone lib\n```bash\n# Set up a virtualenv. \npython3 -m venv venv\nsource venv/bin/activate\n\n# Install from PyPI...\npip install --upgrade pip\npip install -U oka\npip install -U oka[full]  # use the flag \'full\' for extra functionality (recommended)\n\n# ...or, install from updated source code.\npip install git+https://github.com/rabizao/oka\n```\n    \n### ...from source\n```bash\nsudo apt install python3.8-venv python3.8-dev python3.8-distutils # For Debian-like systems.\ngit clone https://github.com/rabizao/oka\ncd oka\npython3.8 -m venv venv\nsource venv/bin/activate\npip install -e .\n```\n\n## Usage\n\n\n\n\n\n\n**Hello world**\n<details>\n<p>\n\n```python3\nfrom oka import Oka, generate_token, toy_df\n\n# Create a pandas dataframe.\ndf = toy_df()\nprint(df.head())\n"""\n   attr1  attr2  class\n0    5.1    6.4      0\n1    1.1    2.5      1\n2    6.1    3.6      0\n3    1.1    3.5      1\n4    3.1    2.5      0\n"""\n```\n\n```python3\n\n# Login.\ntoken = generate_token("http://localhost:5000")\nclient = Oka(token, "http://localhost:5000")\n\n# Store.\nid = client.send(df)\n\n# Store again.\nid = client.send(df)\n"""\nContent already stored for id iJ_e4463c51904e9efb800533d25082af2a7bf77\n"""\n\n# Fetch.\ndf = client.get(id)\n\nprint(df.head())\n"""\n   attr1  attr2  class\n0    5.1    6.4      0\n1    1.1    2.5      1\n2    6.1    3.6      0\n3    1.1    3.5      1\n4    3.1    2.5      0\n"""\n```\n\n</p>\n</details>\n\n\n\n\n\n\n\n\n\n**DataFrame by hand**\n<details>\n<p>\n\n```python3\nimport pandas as pd\nfrom oka import Oka, generate_token\n\n# Create a pandas dataframe.\ndf = pd.DataFrame(\n    [[1, 2, "+"],\n     [3, 4, "-"]],\n    index=["row 1", "row 2"],\n    columns=["col 1", "col 2", "class"],\n)\nprint(df.head())\n"""\n       col 1  col 2 class\nrow 1      1      2     +\nrow 2      3      4     -\n"""\n```\n\n```python3\n\n# Login.\ntoken = generate_token("http://localhost:5000")\nclient = Oka(token, "http://localhost:5000")\n\n# Store.\nid = client.send(df)\n\n# Store again.\nid = client.send(df)\n"""\nContent already stored for id f7_6b9deafec2562edde56bfdc573b336b55cb16\n"""\n\n# Fetch.\ndf = client.get(id)\n\nprint(df.head())\n"""\n       col 1  col 2 class\nrow 1      1      2     +\nrow 2      3      4     -\n"""\n```\n\n\n\n\n\n\n**Machine Learning workflow**\n<details>\n<p>\n\n```python3\nfrom pprint import pprint\n\nfrom idict import let, idict\nfrom idict.function.classification import fit, predict\nfrom idict.function.evaluation import split\nfrom sklearn.ensemble import RandomForestClassifier as RF\n\nd = (\n        idict.fromtoy()\n        >> split\n        >> let(fit, algorithm=RF, config={"n_estimators": 55}, Xin="Xtr", yin="ytr")\n        >> let(predict, Xin="Xts")\n)\n\nprint(d.z)\n"""\n[1 0 1 0 1 1 1]\n"""\n```\n\n```python3\n\npprint(d.history)\n"""\n{\'fit--------------------------------idict\': {\'code\': \'def f(algorithm=None, \'\n                                                      "config={}, Xin=\'X\', "\n                                                      "yin=\'y\', "\n                                                      "output=\'model\', "\n                                                      \'version=0, **kwargs):\\n\'\n                                                      \'obj = \'\n                                                      \'algorithm(**config)\\n\'\n                                                      \'obj.fit(kwargs[Xin], \'\n                                                      \'kwargs[yin])\\n\'\n                                                      \'return {output: obj, \'\n                                                      "\'_history\': ...}",\n                                              \'description\': \'Induce a model.\',\n                                              \'name\': \'fit\',\n                                              \'parameters\': {\'Xin\': \'Xtr\',\n                                                             \'algorithm\': <class \'sklearn.ensemble._forest.RandomForestClassifier\'>,\n                                                             \'config\': {\'n_estimators\': 55},\n                                                             \'output\': \'model\',\n                                                             \'version\': 0,\n                                                             \'yin\': \'ytr\'}},\n \'predict----------------------------idict\': {\'code\': "def f(input=\'model\', "\n                                                      "Xin=\'X\', yout=\'z\', "\n                                                      \'version=0, **kwargs):\\n\'\n                                                      \'return {yout: \'\n                                                      \'kwargs[input].predict(kwargs[Xin]), \'\n                                                      "\'_history\': ...}",\n                                              \'description\': \'Predict values \'\n                                                             \'according to a \'\n                                                             \'model.\',\n                                              \'name\': \'predict\',\n                                              \'parameters\': {\'Xin\': \'Xts\',\n                                                             \'input\': \'model\',\n                                                             \'version\': 0,\n                                                             \'yout\': \'z\'}},\n \'split----------------------sklearn-1.0.1\': {\'code\': "def f(input=[\'X\', \'y\'], "\n                                                      "config={\'test_size\': "\n                                                      "0.33, \'shuffle\': True, "\n                                                      "\'stratify\': \'y\', "\n                                                      "\'random_state\': 0}, "\n                                                      \'**kwargs):\\n\'\n                                                      "if input != [\'X\', "\n                                                      "\'y\']:\\n"\n                                                      \'    raise \'\n                                                      \'Exception(f"Not \'\n                                                      \'implemented for \'\n                                                      \'input/output different \'\n                                                      \'from default values: \'\n                                                      \'{input}")\\n\'\n                                                      \'from \'\n                                                      \'sklearn.model_selection \'\n                                                      \'import \'\n                                                      \'train_test_split\\n\'\n                                                      \'args = {}\\n\'\n                                                      \'for i, _ in \'\n                                                      \'enumerate(input):\\n\'\n                                                      \'    args[input[i]] = \'\n                                                      \'kwargs[input[i]]\\n\'\n                                                      \'else:\\n\'\n                                                      "    if \'stratify\' in "\n                                                      \'config:\\n\'\n                                                      \'        if \'\n                                                      "isinstance(config[\'stratify\'], "\n                                                      \'str):\\n\'\n                                                      \'            if \'\n                                                      "config[\'stratify\'] not "\n                                                      \'in input:\\n\'\n                                                      \'                raise \'\n                                                      \'Exception(f"Missing \'\n                                                      \'field \'\n                                                      "{config[\'stratify\']} "\n                                                      \'for stratification.")\\n\'\n                                                      \'            \'\n                                                      "config[\'stratify\'] = "\n                                                      "args[config[\'stratify\']]\\n"\n                                                      \'    Xtr, Xts, ytr, yts \'\n                                                      \'= \'\n                                                      \'train_test_split(*(args.values)(), \'\n                                                      \'**config)\\n\'\n                                                      "    return {\'Xtr\':Xtr,  "\n                                                      "\'ytr\':ytr,  \'Xts\':Xts,  "\n                                                      "\'yts\':yts,  "\n                                                      "\'_history\':...}",\n                                              \'description\': \'Split data in \'\n                                                             \'two sets.\',\n                                              \'name\': \'split\',\n                                              \'parameters\': {\'config\': {\'random_state\': 0,\n                                                                        \'shuffle\': True,\n                                                                        \'stratify\': array([0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1]),\n                                                                        \'test_size\': 0.33},\n                                                             \'input\': [\'X\',\n                                                                       \'y\']}}}\n"""\n```\n\n\n</p>\n</details>\n\n\n\n\n\n\n\n## More info\nAside from the papers on [identification](https://arxiv.org/abs/2109.06028)\nand on [similarity (not ready yet)](https://), the [PyPI package](https://pypi.org/project/oka) \nand [GitHub repository](https://github.com/davips/rabizao/oka), \n<!-- one can find more information, at a higher level application perspective,  -->\nA lower level perspective is provided in the [API documentation](https://rabizao.github.io/oka).\n\n\n\n## Grants\nThis work was supported by Fapesp under supervision of\nProf. André C. P. L. F. de Carvalho at CEPID-CeMEAI (Grants 2013/07375-0 – 2019/01735-0).\n\n.>>>>>>>>> outros <<<<<<<<<<<.\n',
    'author': 'Rafael Bizao',
    'author_email': 'rabizao@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
