# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from typing import Union, Tuple

from .chromium_base import ChromiumBase
from .tab import Tab
from .chromium_element import ChromiumElement
from .chromium_page import ChromiumPage


class ActionChains:
    """用于实现动作链的类"""

    def __init__(self, page:ChromiumBase):
        self.page: ChromiumPage = ...
        self._dr: Tab = ...
        self.curr_x: int = ...
        self.curr_y: int = ...
        self.modifier: int = ...

    def move_to(self, ele_or_loc: Union[ChromiumElement, Tuple[int, int]],
                offset_x: int = ..., offset_y: int = ...) -> ActionChains: ...

    def move(self, offset_x: int = ..., offset_y: int = ...) -> ActionChains: ...

    def hold(self, on_ele:ChromiumElement=...) -> ActionChains: ...

    def click(self, on_ele:ChromiumElement=...) -> ActionChains: ...

    def r_click(self, on_ele:ChromiumElement=...) -> ActionChains: ...

    def release(self, on_ele:ChromiumElement=...) -> ActionChains: ...

    def scroll(self, delta_x: int = ..., delta_y: int = ..., on_ele:ChromiumElement=...) -> ActionChains: ...

    def up(self, pixel: int) -> ActionChains: ...

    def down(self, pixel: int) -> ActionChains: ...

    def left(self, pixel: int) -> ActionChains: ...

    def right(self, pixel: int) -> ActionChains: ...

    def key_down(self, key:str) -> ActionChains: ...

    def key_up(self, key:str) -> ActionChains: ...

    def wait(self, second: float) -> ActionChains: ...

    def _get_key_data(self, key:str, action: str) -> dict: ...


def location_to_client(page, lx: int, ly: int) -> tuple: ...
