# -*- coding: utf-8 -*-
from distutils.core import setup

packages = \
['akimous',
 'akimous.modeling',
 'akimous.modeling.feature',
 'akimous.modeling.temp.keras.docs',
 'akimous.modeling.temp.keras.keras',
 'akimous.modeling.temp.keras.keras.applications',
 'akimous.modeling.temp.keras.keras.backend',
 'akimous.modeling.temp.keras.keras.callbacks',
 'akimous.modeling.temp.keras.keras.datasets',
 'akimous.modeling.temp.keras.keras.engine',
 'akimous.modeling.temp.keras.keras.layers',
 'akimous.modeling.temp.keras.keras.legacy',
 'akimous.modeling.temp.keras.keras.preprocessing',
 'akimous.modeling.temp.keras.keras.utils',
 'akimous.modeling.temp.keras.keras.wrappers',
 'akimous.resources',
 'akimous_ui',
 'akimous_ui.fonts',
 'akimous_ui.icons',
 'akimous_ui.webfonts']

package_data = \
{'': ['*'],
 'akimous.modeling': ['temp/keras/*',
                      'temp/keras/.git/*',
                      'temp/keras/.git/hooks/*',
                      'temp/keras/.git/info/*',
                      'temp/keras/.git/logs/*',
                      'temp/keras/.git/logs/refs/heads/*',
                      'temp/keras/.git/logs/refs/remotes/origin/*',
                      'temp/keras/.git/objects/pack/*',
                      'temp/keras/.git/refs/heads/*',
                      'temp/keras/.git/refs/remotes/origin/*',
                      'temp/keras/.github/*',
                      'temp/keras/.github/ISSUE_TEMPLATE/*',
                      'temp/keras/.github/PULL_REQUEST_TEMPLATE/*',
                      'temp/keras/.travis/*',
                      'temp/keras/docker/*',
                      'temp/keras/examples/*',
                      'temp/keras/tests/*',
                      'temp/keras/tests/docs/*',
                      'temp/keras/tests/integration_tests/*',
                      'temp/keras/tests/integration_tests/preprocessing/*',
                      'temp/keras/tests/keras/*',
                      'temp/keras/tests/keras/backend/*',
                      'temp/keras/tests/keras/callbacks/*',
                      'temp/keras/tests/keras/datasets/*',
                      'temp/keras/tests/keras/engine/*',
                      'temp/keras/tests/keras/layers/*',
                      'temp/keras/tests/keras/legacy/*',
                      'temp/keras/tests/keras/utils/*',
                      'temp/keras/tests/keras/wrappers/*'],
 'akimous.modeling.temp.keras.docs': ['templates/*',
                                      'templates/getting-started/*',
                                      'templates/layers/*',
                                      'templates/models/*',
                                      'templates/preprocessing/*',
                                      'theme/*',
                                      'theme/css/*',
                                      'theme/js/*'],
 'akimous.resources': ['doc_template/*']}

install_requires = \
['Send2Trash>=1.5,<2.0',
 'appdirs>=1.4,<2.0',
 'boltons>=19.0,<20.0',
 'cachetools>=3.0,<4.0',
 'fuzzywuzzy>=0.17.0,<0.18.0',
 'gitpython>=3.0,<4.0',
 'ipykernel>=5.1,<6.0',
 'jedi>=0.15.0,<0.16.0',
 'jupyter_client>=5.2,<6.0',
 'logzero>=1.5,<2.0',
 'msgpack>=0.6,<0.7',
 'numpy>=1.15,<2.0',
 'numpydoc>=0.9.1,<0.10.0',
 'pathspec>=0.6.0,<0.7.0',
 'ptyprocess>=0.6.0,<0.7.0',
 'pyflakes>=2.0,<3.0',
 'pylint>=2.1,<3.0',
 'python-levenshtein>=0.12.0,<0.13.0',
 'sphinx>=2.0,<3.0',
 'toml>=0.10.0,<0.11.0',
 'watchdog>=0.9.0,<0.10.0',
 'websockets>=8.0,<9.0',
 'wordsegment>=1.3,<2.0',
 'xgboost>=0.90,<0.91',
 'yapf>=0.28.0,<0.29.0']

entry_points = \
{'console_scripts': ['akimous = akimous.__main__:start']}

setup_kwargs = {
    'name': 'akimous',
    'version': '0.1.0',
    'description': 'An intelligent Python IDE',
    'long_description': "# Akimous\n\nAkimous is a Python IDE with unique features boosting developers' productivity.\n\n### Features\n\n* Machine-learning-assisted/NLP-assisted context-aware auto completion\n* Beautifully rendered function documentation\n* Layered keyboard control (a more intuitive key binding than vim and Emacs)\n* Real-time code formatter\n* Interactive console (integration with IPython kernel)\n\n![Screenshot](images/screenshot.png)\n\nFor more information and documentation, visit the official website.\n\n## Installation\n\n### Supported Environments\n\n* Akimous requires Python 3.7 or newer to run. The latest two major version of Python 3 will be supported.\n* Latest versions of Firefox, Chrome and Safari are supported.\n\n### Dependencies\n\nAkimous has some dependencies (e.g. XGBoost) requiring a C/C++ compiler to build. It is recommended to have one of the following before installation:\n\n* gcc and g++\n* clang\n\n### Install From PyPI\n\nThe recommended way for installing Akimous is through PyPI.\n\n```sh\npip install -U akimous\n```\n\n### Using  Docker Image\n\nIf you have difficulty installing, or you are running in a cloud environment, try the prebuilt docker image.\n\n```sh\n# COMING SOON\n```\n\n## Commands\n\nStart the app by typing in the terminal (the browser will automatically open if available): \n\n```sh\nakimous\n```\n\n#### Options\n\n* `--help`: show help message and exit.\n* `--host HOST`: specify the host for Akimous server to listen on. (default to 0.0.0.0 if inside docker, otherwise 127.0.0.1)\n* `--port PORT`: The port number for Akimous server to listen on. (default=3179)\n* `--no-browser`: Do not open the IDE in a browser after startup.\n* `--verbose`: Print extra debug messages.\n\n## Development\n\nMake sure you have recent version of the following build dependencies installed.\n\n* Node (12+)\n* Python (3.7+)\n* [Poetry](https://poetry.eustace.io)\n* [Yarn](https://yarnpkg.com/)\n* Make\n* [Zopfli](https://github.com/google/zopfli)\n* [Parallel](https://www.gnu.org/software/parallel/)\n\nRun the following commands according to your need.\n\n```sh\nmake # build everything\nmake test # run tests\nmake lint # run linters\nmake install # (re)install the package\n```\n\nRunning `make` will install all Python and Javascript dependencies listed in `pyproject.toml` and `ui/package.json` automatically.\n\n## Contributing\n\nThis program is at pre-alpha stage. Please do report issues if you run into some problems. Contributions of any kind are welcome, including feature requests or pull requests (can be as small as correcting spelling errors) . \n\n## License\n\n[BSD-3-Clause](LICENSE)",
    'author': 'Yu-Ann Chen',
    'author_email': 'red8012@gmail.com',
    'url': 'https://github.com/akimous/akimous',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
