"""
This is a module containing exceptions used within prefect-hex.
"""

from prefect_hex.models.project import ProjectRunStatus


class HexProjectRunError(RuntimeError):
    """
    A generic Hex project exception.
    """


class HexProjectRunTimedOut(HexProjectRunError):
    """
    Raised when Hex project run does not complete in the configured max
    wait seconds.
    """


class HexProjectRunUnableToAllocateKernel(HexProjectRunError):
    """
    Raised when Hex project run is unable to allocate a kernel.
    """


class HexProjectRunErrored(HexProjectRunError):
    """
    Raised when Hex project run has errored out.
    """


class HexProjectRunKilled(HexProjectRunError):
    """
    Raised when Hex project run is killed.
    """


TERMINAL_STATUS_EXCEPTIONS = {
    ProjectRunStatus.unabletoallocatekernel: HexProjectRunUnableToAllocateKernel,
    ProjectRunStatus.errored: HexProjectRunErrored,
    ProjectRunStatus.killed: HexProjectRunKilled,
    ProjectRunStatus.completed: None,
}
