"""GOATOOLS GOEA: Transient Increase 624 Study Genes, 220 significant GO terms
  
  220 SIGNIFICANT GO TERMS FOUND
  
  ALL GENE ONTOLOGY ENRICHMENT ANALYSIS RESULTS:
  2,962 GO terms are associated with 578 of 624 study items
  15,706 GO terms are associated with 12,314 of 13,836 population items
  
  SIGNIFICANT GENE ONTOLOGY ENRICHMENT ANALYSIS RESULTS:
  220 GO terms are associated with 507 of 624 study items
  220 GO terms are associated with 7,955 of 13,836 population items
  

# go-basic.obo: fmt(1.2) rel(2017-11-22) 47,038 GO Terms

"""

# Created: 2017-11-24
import collections as cx

nt_fields = [
    "GO",
    "NS",
    "enrichment",
    "name",
    "ratio_in_study",
    "ratio_in_pop",
    "p_uncorrected",
    "depth",
    "study_count",
    "p_sm_bonferroni",
    "p_fdr_bh",
    "study_items",
    "pop_n",
    "pop_count",
    "pop_items",
    "study_n",
    "level",
    "is_obsolete",
    "namespace",
    "alt_ids",
]

NtGoeaResults = cx.namedtuple("NtGoeaResults", " ".join(nt_fields))

# 2,962 items
goea_results = [
    NtGoeaResults(GO='GO:0000012', NS='BP', enrichment='e', name='single strand break repair', ratio_in_study=(3, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.004312087798880901, depth=8, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.19024059261017817, study_items=set([u'ENSMUSG00000051768', u'ENSMUSG00000034349', u'ENSMUSG00000028312']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000051768', u'ENSMUSG00000049717', u'ENSMUSG00000028312', u'ENSMUSG00000030051', u'ENSMUSG00000034349', u'ENSMUSG00000020063', u'ENSMUSG00000028411', u'ENSMUSG00000021177']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000014', NS='MF', enrichment='e', name='single-stranded DNA endodeoxyribonuclease activity', ratio_in_study=(2, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.03667181122637655, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000020380', u'ENSMUSG00000041238']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000026648', u'ENSMUSG00000031928', u'ENSMUSG00000022545', u'ENSMUSG00000003549', u'ENSMUSG00000041238', u'ENSMUSG00000020380', u'ENSMUSG00000006498']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000019', NS='BP', enrichment='e', name='regulation of mitotic recombination', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000020380']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000020380']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000045', NS='BP', enrichment='p', name='autophagosome assembly', ratio_in_study=(2, 624), ratio_in_pop=(47, 13836), p_uncorrected=1.0, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028211', u'ENSMUSG00000046879']), pop_n=13836, pop_count=47, pop_items=set([u'ENSMUSG00000035086', u'ENSMUSG00000020634', u'ENSMUSG00000030314', u'ENSMUSG00000047260', u'ENSMUSG00000038375', u'ENSMUSG00000033628', u'ENSMUSG00000028243', u'ENSMUSG00000079418', u'ENSMUSG00000022663', u'ENSMUSG00000028550', u'ENSMUSG00000018567', u'ENSMUSG00000037204', u'ENSMUSG00000029578', u'ENSMUSG00000026280', u'ENSMUSG00000038295', u'ENSMUSG00000033124', u'ENSMUSG00000037526', u'ENSMUSG00000026289', u'ENSMUSG00000040412', u'ENSMUSG00000029512', u'ENSMUSG00000050315', u'ENSMUSG00000021143', u'ENSMUSG00000027602', u'ENSMUSG00000019969', u'ENSMUSG00000040506', u'ENSMUSG00000028211', u'ENSMUSG00000047767', u'ENSMUSG00000030161', u'ENSMUSG00000032905', u'ENSMUSG00000069874', u'ENSMUSG00000005312', u'ENSMUSG00000046879', u'ENSMUSG00000079477', u'ENSMUSG00000002820', u'ENSMUSG00000028879', u'ENSMUSG00000007891', u'ENSMUSG00000041341', u'ENSMUSG00000031812', u'ENSMUSG00000020149', u'ENSMUSG00000024773', u'ENSMUSG00000004768', u'ENSMUSG00000031950', u'ENSMUSG00000038160', u'ENSMUSG00000027244', u'ENSMUSG00000025907', u'ENSMUSG00000027739', u'ENSMUSG00000027455']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000054', NS='BP', enrichment='e', name='ribosomal subunit export from nucleus', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=12, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020290']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000029430', u'ENSMUSG00000027613', u'ENSMUSG00000058355']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000055', NS='BP', enrichment='e', name='ribosomal large subunit export from nucleus', ratio_in_study=(1, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.33996234399139486, depth=13, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020290']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000029430', u'ENSMUSG00000061024', u'ENSMUSG00000029415', u'ENSMUSG00000041560', u'ENSMUSG00000057113', u'ENSMUSG00000028840', u'ENSMUSG00000040667', u'ENSMUSG00000027787']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0000057'])),
    NtGoeaResults(GO='GO:0000056', NS='BP', enrichment='e', name='ribosomal small subunit export from nucleus', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=13, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020290']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000029430', u'ENSMUSG00000057113', u'ENSMUSG00000063457', u'ENSMUSG00000040667', u'ENSMUSG00000019814']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0000058'])),
    NtGoeaResults(GO='GO:0000060', NS='BP', enrichment='e', name='protein import into nucleus, translocation', ratio_in_study=(2, 624), ratio_in_pop=(22, 13836), p_uncorrected=0.26122083018435993, depth=9, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000024833']), pop_n=13836, pop_count=22, pop_items=set([u'ENSMUSG00000053317', u'ENSMUSG00000029430', u'ENSMUSG00000050511', u'ENSMUSG00000059552', u'ENSMUSG00000024833', u'ENSMUSG00000022508', u'ENSMUSG00000055116', u'ENSMUSG00000001440', u'ENSMUSG00000053175', u'ENSMUSG00000074909', u'ENSMUSG00000004264', u'ENSMUSG00000031922', u'ENSMUSG00000024604', u'ENSMUSG00000021025', u'ENSMUSG00000001729', u'ENSMUSG00000009470', u'ENSMUSG00000008450', u'ENSMUSG00000002319', u'ENSMUSG00000030662', u'ENSMUSG00000023353', u'ENSMUSG00000031691', u'ENSMUSG00000002603']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000070', NS='BP', enrichment='e', name='mitotic sister chromatid segregation', ratio_in_study=(13, 624), ratio_in_pop=(22, 13836), p_uncorrected=2.7262250045263463e-11, depth=6, study_count=13, p_sm_bonferroni=4.2818089921090797e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000062510', u'ENSMUSG00000028873', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000027635', u'ENSMUSG00000027306', u'ENSMUSG00000029910', u'ENSMUSG00000058290', u'ENSMUSG00000030867', u'ENSMUSG00000027331', u'ENSMUSG00000051378', u'ENSMUSG00000026622', u'ENSMUSG00000040599']), pop_n=13836, pop_count=22, pop_items=set([u'ENSMUSG00000029516', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000031922', u'ENSMUSG00000030867', u'ENSMUSG00000027331', u'ENSMUSG00000032264', u'ENSMUSG00000022750', u'ENSMUSG00000019923', u'ENSMUSG00000062510', u'ENSMUSG00000034154', u'ENSMUSG00000066979', u'ENSMUSG00000058290', u'ENSMUSG00000017421', u'ENSMUSG00000051378', u'ENSMUSG00000040599', u'ENSMUSG00000028873', u'ENSMUSG00000027635', u'ENSMUSG00000027306', u'ENSMUSG00000029910', u'ENSMUSG00000019813', u'ENSMUSG00000026622']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0016359'])),
    NtGoeaResults(GO='GO:0000076', NS='BP', enrichment='e', name='DNA replication checkpoint', ratio_in_study=(4, 624), ratio_in_pop=(6, 13836), p_uncorrected=5.716066791862708e-05, depth=8, study_count=4, p_sm_bonferroni=0.89776545032995692, p_fdr_bh=0.0054741795751826637, study_items=set([u'ENSMUSG00000032397', u'ENSMUSG00000006585', u'ENSMUSG00000042489', u'ENSMUSG00000036875']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000032397', u'ENSMUSG00000042489', u'ENSMUSG00000024824', u'ENSMUSG00000036875', u'ENSMUSG00000006585', u'ENSMUSG00000038569']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000077', NS='BP', enrichment='e', name='DNA damage checkpoint', ratio_in_study=(9, 624), ratio_in_pop=(27, 13836), p_uncorrected=1.6446267503594242e-06, depth=8, study_count=9, p_sm_bonferroni=0.025830507741145117, p_fdr_bh=0.00024837026674177996, study_items=set([u'ENSMUSG00000032397', u'ENSMUSG00000028224', u'ENSMUSG00000029521', u'ENSMUSG00000032113', u'ENSMUSG00000027490', u'ENSMUSG00000022960', u'ENSMUSG00000042489', u'ENSMUSG00000034218', u'ENSMUSG00000032409']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000020413', u'ENSMUSG00000004085', u'ENSMUSG00000038569', u'ENSMUSG00000032119', u'ENSMUSG00000021635', u'ENSMUSG00000029238', u'ENSMUSG00000032113', u'ENSMUSG00000037461', u'ENSMUSG00000032267', u'ENSMUSG00000022248', u'ENSMUSG00000032409', u'ENSMUSG00000053436', u'ENSMUSG00000032397', u'ENSMUSG00000029521', u'ENSMUSG00000024824', u'ENSMUSG00000040843', u'ENSMUSG00000043733', u'ENSMUSG00000013698', u'ENSMUSG00000005102', u'ENSMUSG00000061589', u'ENSMUSG00000027490', u'ENSMUSG00000022960', u'ENSMUSG00000042489', u'ENSMUSG00000043909', u'ENSMUSG00000034218', u'ENSMUSG00000048668']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000079', NS='BP', enrichment='e', name='regulation of cyclin-dependent protein serine/threonine kinase activity', ratio_in_study=(3, 624), ratio_in_pop=(11, 13836), p_uncorrected=0.011481279444533183, depth=11, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000030528', u'ENSMUSG00000028551', u'ENSMUSG00000023067']), pop_n=13836, pop_count=11, pop_items=set([u'ENSMUSG00000024286', u'ENSMUSG00000030983', u'ENSMUSG00000027487', u'ENSMUSG00000033159', u'ENSMUSG00000023067', u'ENSMUSG00000027829', u'ENSMUSG00000028551', u'ENSMUSG00000030528', u'ENSMUSG00000018669', u'ENSMUSG00000021149', u'ENSMUSG00000021103']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000082', NS='BP', enrichment='e', name='G1/S transition of mitotic cell cycle', ratio_in_study=(12, 624), ratio_in_pop=(54, 13836), p_uncorrected=3.832464011738951e-06, depth=5, study_count=12, p_sm_bonferroni=0.060192679768371962, p_fdr_bh=0.00052341460668149534, study_items=set([u'ENSMUSG00000028896', u'ENSMUSG00000028551', u'ENSMUSG00000032477', u'ENSMUSG00000041238', u'ENSMUSG00000054115', u'ENSMUSG00000028068', u'ENSMUSG00000023067', u'ENSMUSG00000002068', u'ENSMUSG00000025358', u'ENSMUSG00000050410', u'ENSMUSG00000033364', u'ENSMUSG00000007080']), pop_n=13836, pop_count=54, pop_items=set([u'ENSMUSG00000079259', u'ENSMUSG00000028333', u'ENSMUSG00000053819', u'ENSMUSG00000028068', u'ENSMUSG00000028680', u'ENSMUSG00000048424', u'ENSMUSG00000020516', u'ENSMUSG00000025358', u'ENSMUSG00000050410', u'ENSMUSG00000028161', u'ENSMUSG00000057897', u'ENSMUSG00000005732', u'ENSMUSG00000040957', u'ENSMUSG00000033016', u'ENSMUSG00000007080', u'ENSMUSG00000002372', u'ENSMUSG00000032119', u'ENSMUSG00000041238', u'ENSMUSG00000017561', u'ENSMUSG00000000532', u'ENSMUSG00000070348', u'ENSMUSG00000033364', u'ENSMUSG00000040021', u'ENSMUSG00000032405', u'ENSMUSG00000021820', u'ENSMUSG00000039960', u'ENSMUSG00000022018', u'ENSMUSG00000003226', u'ENSMUSG00000028156', u'ENSMUSG00000054115', u'ENSMUSG00000021701', u'ENSMUSG00000025809', u'ENSMUSG00000026836', u'ENSMUSG00000002068', u'ENSMUSG00000027552', u'ENSMUSG00000033417', u'ENSMUSG00000031155', u'ENSMUSG00000041229', u'ENSMUSG00000021379', u'ENSMUSG00000000184', u'ENSMUSG00000021959', u'ENSMUSG00000028896', u'ENSMUSG00000040274', u'ENSMUSG00000028551', u'ENSMUSG00000032477', u'ENSMUSG00000023067', u'ENSMUSG00000024617', u'ENSMUSG00000021103', u'ENSMUSG00000031490', u'ENSMUSG00000003031', u'ENSMUSG00000006728', u'ENSMUSG00000028495', u'ENSMUSG00000043866', u'ENSMUSG00000022105']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000085', NS='BP', enrichment='e', name='mitotic G2 phase', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000029521']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000029521']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000086', NS='BP', enrichment='e', name='G2/M transition of mitotic cell cycle', ratio_in_study=(10, 624), ratio_in_pop=(27, 13836), p_uncorrected=1.3624160646516914e-07, depth=5, study_count=10, p_sm_bonferroni=0.0021398106711419465, p_fdr_bh=2.7789748975869434e-05, study_items=set([u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000027715', u'ENSMUSG00000023067', u'ENSMUSG00000032113', u'ENSMUSG00000054115', u'ENSMUSG00000017716', u'ENSMUSG00000030867', u'ENSMUSG00000026779', u'ENSMUSG00000020525']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000029516', u'ENSMUSG00000023067', u'ENSMUSG00000019370', u'ENSMUSG00000036438', u'ENSMUSG00000030752', u'ENSMUSG00000040584', u'ENSMUSG00000032113', u'ENSMUSG00000001175', u'ENSMUSG00000035390', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000025226', u'ENSMUSG00000027425', u'ENSMUSG00000026779', u'ENSMUSG00000024286', u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000054115', u'ENSMUSG00000053046', u'ENSMUSG00000020525', u'ENSMUSG00000000296', u'ENSMUSG00000037343', u'ENSMUSG00000027715', u'ENSMUSG00000017716', u'ENSMUSG00000028926', u'ENSMUSG00000007656', u'ENSMUSG00000051177']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000089', NS='BP', enrichment='e', name='mitotic metaphase', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000006398']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000006398']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000109', NS='CC', enrichment='e', name='nucleotide-excision repair complex', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000038644']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000022545', u'ENSMUSG00000003549', u'ENSMUSG00000021694', u'ENSMUSG00000038644']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000118', NS='CC', enrichment='p', name='histone deacetylase complex', ratio_in_study=(1, 624), ratio_in_pop=(33, 13836), p_uncorrected=1.0, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000071646']), pop_n=13836, pop_count=33, pop_items=set([u'ENSMUSG00000038331', u'ENSMUSG00000029478', u'ENSMUSG00000017299', u'ENSMUSG00000027684', u'ENSMUSG00000031161', u'ENSMUSG00000020267', u'ENSMUSG00000020519', u'ENSMUSG00000024513', u'ENSMUSG00000022475', u'ENSMUSG00000058318', u'ENSMUSG00000034245', u'ENSMUSG00000021963', u'ENSMUSG00000025246', u'ENSMUSG00000004698', u'ENSMUSG00000028800', u'ENSMUSG00000019777', u'ENSMUSG00000018501', u'ENSMUSG00000062906', u'ENSMUSG00000026313', u'ENSMUSG00000009575', u'ENSMUSG00000064043', u'ENSMUSG00000022096', u'ENSMUSG00000031609', u'ENSMUSG00000039852', u'ENSMUSG00000008855', u'ENSMUSG00000071646', u'ENSMUSG00000067567', u'ENSMUSG00000042507', u'ENSMUSG00000027630', u'ENSMUSG00000024454', u'ENSMUSG00000041777', u'ENSMUSG00000048490', u'ENSMUSG00000052056']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000122', NS='BP', enrichment='e', name='negative regulation of transcription from RNA polymerase II promoter', ratio_in_study=(33, 624), ratio_in_pop=(581, 13836), p_uncorrected=0.18284237823493119, depth=11, study_count=33, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025358', u'ENSMUSG00000021485', u'ENSMUSG00000059552', u'ENSMUSG00000052565', u'ENSMUSG00000052684', u'ENSMUSG00000042557', u'ENSMUSG00000039994', u'ENSMUSG00000027641', u'ENSMUSG00000017548', u'ENSMUSG00000030867', u'ENSMUSG00000020897', u'ENSMUSG00000022906', u'ENSMUSG00000001517', u'ENSMUSG00000020290', u'ENSMUSG00000027968', u'ENSMUSG00000020185', u'ENSMUSG00000020184', u'ENSMUSG00000002068', u'ENSMUSG00000026873', u'ENSMUSG00000037214', u'ENSMUSG00000046179', u'ENSMUSG00000031353', u'ENSMUSG00000040734', u'ENSMUSG00000001228', u'ENSMUSG00000071646', u'ENSMUSG00000027490', u'ENSMUSG00000036202', u'ENSMUSG00000002307', u'ENSMUSG00000020889', u'ENSMUSG00000027342', u'ENSMUSG00000005566', u'ENSMUSG00000008976', u'ENSMUSG00000004099']), pop_n=13836, pop_count=581, pop_items=set([u'ENSMUSG00000048109', u'ENSMUSG00000002393', u'ENSMUSG00000059325', u'ENSMUSG00000006005', u'ENSMUSG00000004897', u'ENSMUSG00000027387', u'ENSMUSG00000028341', u'ENSMUSG00000037243', u'ENSMUSG00000034957', u'ENSMUSG00000027660', u'ENSMUSG00000038393', u'ENSMUSG00000018678', u'ENSMUSG00000030180', u'ENSMUSG00000046058', u'ENSMUSG00000031907', u'ENSMUSG00000049295', u'ENSMUSG00000004698', u'ENSMUSG00000019777', u'ENSMUSG00000015120', u'ENSMUSG00000079363', u'ENSMUSG00000029191', u'ENSMUSG00000024042', u'ENSMUSG00000014303', u'ENSMUSG00000068154', u'ENSMUSG00000022091', u'ENSMUSG00000048481', u'ENSMUSG00000080268', u'ENSMUSG00000002307', u'ENSMUSG00000033249', u'ENSMUSG00000026380', u'ENSMUSG00000001472', u'ENSMUSG00000020364', u'ENSMUSG00000022906', u'ENSMUSG00000021326', u'ENSMUSG00000021327', u'ENSMUSG00000020538', u'ENSMUSG00000063889', u'ENSMUSG00000039842', u'ENSMUSG00000049577', u'ENSMUSG00000022306', u'ENSMUSG00000049672', u'ENSMUSG00000028800', u'ENSMUSG00000017801', u'ENSMUSG00000026313', u'ENSMUSG00000035268', u'ENSMUSG00000057604', u'ENSMUSG00000029705', u'ENSMUSG00000030849', u'ENSMUSG00000054452', u'ENSMUSG00000037664', u'ENSMUSG00000015937', u'ENSMUSG00000025231', u'ENSMUSG00000005373', u'ENSMUSG00000025626', u'ENSMUSG00000021039', u'ENSMUSG00000004099', u'ENSMUSG00000053754', u'ENSMUSG00000025782', u'ENSMUSG00000002111', u'ENSMUSG00000020719', u'ENSMUSG00000061393', u'ENSMUSG00000024831', u'ENSMUSG00000025019', u'ENSMUSG00000047407', u'ENSMUSG00000010175', u'ENSMUSG00000028150', u'ENSMUSG00000030067', u'ENSMUSG00000024539', u'ENSMUSG00000037373', u'ENSMUSG00000012076', u'ENSMUSG00000037447', u'ENSMUSG00000020052', u'ENSMUSG00000046709', u'ENSMUSG00000055435', u'ENSMUSG00000056749', u'ENSMUSG00000027905', u'ENSMUSG00000046668', u'ENSMUSG00000031429', u'ENSMUSG00000007872', u'ENSMUSG00000031930', u'ENSMUSG00000003437', u'ENSMUSG00000003435', u'ENSMUSG00000020661', u'ENSMUSG00000022122', u'ENSMUSG00000030232', u'ENSMUSG00000033740', u'ENSMUSG00000021244', u'ENSMUSG00000044786', u'ENSMUSG00000021366', u'ENSMUSG00000057469', u'ENSMUSG00000032119', u'ENSMUSG00000018143', u'ENSMUSG00000020485', u'ENSMUSG00000023110', u'ENSMUSG00000029003', u'ENSMUSG00000019947', u'ENSMUSG00000049532', u'ENSMUSG00000001134', u'ENSMUSG00000061175', u'ENSMUSG00000002983', u'ENSMUSG00000025408', u'ENSMUSG00000003382', u'ENSMUSG00000055866', u'ENSMUSG00000021974', u'ENSMUSG00000009640', u'ENSMUSG00000026873', u'ENSMUSG00000026872', u'ENSMUSG00000036686', u'ENSMUSG00000058444', u'ENSMUSG00000039087', u'ENSMUSG00000001228', u'ENSMUSG00000054387', u'ENSMUSG00000017491', u'ENSMUSG00000029178', u'ENSMUSG00000029913', u'ENSMUSG00000024498', u'ENSMUSG00000048616', u'ENSMUSG00000025577', u'ENSMUSG00000025902', u'ENSMUSG00000037622', u'ENSMUSG00000007655', u'ENSMUSG00000030905', u'ENSMUSG00000040363', u'ENSMUSG00000054604', u'ENSMUSG00000044030', u'ENSMUSG00000035277', u'ENSMUSG00000025358', u'ENSMUSG00000001911', u'ENSMUSG00000059552', u'ENSMUSG00000033016', u'ENSMUSG00000001988', u'ENSMUSG00000022475', u'ENSMUSG00000001761', u'ENSMUSG00000025997', u'ENSMUSG00000041560', u'ENSMUSG00000025612', u'ENSMUSG00000027177', u'ENSMUSG00000020954', u'ENSMUSG00000020950', u'ENSMUSG00000028582', u'ENSMUSG00000020897', u'ENSMUSG00000037486', u'ENSMUSG00000005583', u'ENSMUSG00000020893', u'ENSMUSG00000020593', u'ENSMUSG00000020185', u'ENSMUSG00000020184', u'ENSMUSG00000002068', u'ENSMUSG00000005609', u'ENSMUSG00000005566', u'ENSMUSG00000039661', u'ENSMUSG00000008855', u'ENSMUSG00000022521', u'ENSMUSG00000005698', u'ENSMUSG00000004069', u'ENSMUSG00000000567', u'ENSMUSG00000041309', u'ENSMUSG00000035125', u'ENSMUSG00000027304', u'ENSMUSG00000026628', u'ENSMUSG00000050919', u'ENSMUSG00000019768', u'ENSMUSG00000060601', u'ENSMUSG00000002147', u'ENSMUSG00000022383', u'ENSMUSG00000048001', u'ENSMUSG00000027954', u'ENSMUSG00000022529', u'ENSMUSG00000018446', u'ENSMUSG00000045515', u'ENSMUSG00000036036', u'ENSMUSG00000041415', u'ENSMUSG00000032010', u'ENSMUSG00000004364', u'ENSMUSG00000021779', u'ENSMUSG00000026436', u'ENSMUSG00000032405', u'ENSMUSG00000032402', u'ENSMUSG00000004934', u'ENSMUSG00000021775', u'ENSMUSG00000020358', u'ENSMUSG00000031393', u'ENSMUSG00000034292', u'ENSMUSG00000031622', u'ENSMUSG00000002968', u'ENSMUSG00000022639', u'ENSMUSG00000056537', u'ENSMUSG00000032419', u'ENSMUSG00000040734', u'ENSMUSG00000022708', u'ENSMUSG00000021972', u'ENSMUSG00000063972', u'ENSMUSG00000060257', u'ENSMUSG00000024454', u'ENSMUSG00000074637', u'ENSMUSG00000053768', u'ENSMUSG00000061911', u'ENSMUSG00000026923', u'ENSMUSG00000050295', u'ENSMUSG00000040325', u'ENSMUSG00000018849', u'ENSMUSG00000066687', u'ENSMUSG00000003032', u'ENSMUSG00000029249', u'ENSMUSG00000022528', u'ENSMUSG00000003038', u'ENSMUSG00000030652', u'ENSMUSG00000029629', u'ENSMUSG00000024985', u'ENSMUSG00000037235', u'ENSMUSG00000025225', u'ENSMUSG00000038214', u'ENSMUSG00000052397', u'ENSMUSG00000041649', u'ENSMUSG00000026586', u'ENSMUSG00000002108', u'ENSMUSG00000033454', u'ENSMUSG00000029563', u'ENSMUSG00000038793', u'ENSMUSG00000025369', u'ENSMUSG00000046179', u'ENSMUSG00000028565', u'ENSMUSG00000004980', u'ENSMUSG00000024240', u'ENSMUSG00000034271', u'ENSMUSG00000034278', u'ENSMUSG00000059518', u'ENSMUSG00000027342', u'ENSMUSG00000067071', u'ENSMUSG00000021156', u'ENSMUSG00000042097', u'ENSMUSG00000038495', u'ENSMUSG00000051627', u'ENSMUSG00000054939', u'ENSMUSG00000039630', u'ENSMUSG00000028367', u'ENSMUSG00000033933', u'ENSMUSG00000008305', u'ENSMUSG00000008730', u'ENSMUSG00000041911', u'ENSMUSG00000036202', u'ENSMUSG00000040857', u'ENSMUSG00000035873', u'ENSMUSG00000035877', u'ENSMUSG00000052713', u'ENSMUSG00000035011', u'ENSMUSG00000027985', u'ENSMUSG00000018654', u'ENSMUSG00000022895', u'ENSMUSG00000032355', u'ENSMUSG00000003814', u'ENSMUSG00000008136', u'ENSMUSG00000039004', u'ENSMUSG00000021546', u'ENSMUSG00000001517', u'ENSMUSG00000030224', u'ENSMUSG00000021540', u'ENSMUSG00000027968', u'ENSMUSG00000051316', u'ENSMUSG00000068742', u'ENSMUSG00000031665', u'ENSMUSG00000021379', u'ENSMUSG00000038146', u'ENSMUSG00000025578', u'ENSMUSG00000036052', u'ENSMUSG00000021835', u'ENSMUSG00000036111', u'ENSMUSG00000026361', u'ENSMUSG00000037395', u'ENSMUSG00000074221', u'ENSMUSG00000024140', u'ENSMUSG00000032194', u'ENSMUSG00000048583', u'ENSMUSG00000022831', u'ENSMUSG00000068739', u'ENSMUSG00000027544', u'ENSMUSG00000031060', u'ENSMUSG00000001288', u'ENSMUSG00000009739', u'ENSMUSG00000026883', u'ENSMUSG00000020519', u'ENSMUSG00000002250', u'ENSMUSG00000030189', u'ENSMUSG00000058230', u'ENSMUSG00000022361', u'ENSMUSG00000006932', u'ENSMUSG00000017548', u'ENSMUSG00000051910', u'ENSMUSG00000028820', u'ENSMUSG00000020063', u'ENSMUSG00000062012', u'ENSMUSG00000063632', u'ENSMUSG00000039231', u'ENSMUSG00000026814', u'ENSMUSG00000029687', u'ENSMUSG00000029726', u'ENSMUSG00000020423', u'ENSMUSG00000042589', u'ENSMUSG00000024968', u'ENSMUSG00000057156', u'ENSMUSG00000038518', u'ENSMUSG00000030619', u'ENSMUSG00000027499', u'ENSMUSG00000027490', u'ENSMUSG00000025602', u'ENSMUSG00000041777', u'ENSMUSG00000005897', u'ENSMUSG00000039474', u'ENSMUSG00000052056', u'ENSMUSG00000039910', u'ENSMUSG00000037992', u'ENSMUSG00000025138', u'ENSMUSG00000031563', u'ENSMUSG00000031565', u'ENSMUSG00000052684', u'ENSMUSG00000048402', u'ENSMUSG00000024513', u'ENSMUSG00000048756', u'ENSMUSG00000043456', u'ENSMUSG00000024515', u'ENSMUSG00000028957', u'ENSMUSG00000027641', u'ENSMUSG00000069255', u'ENSMUSG00000027314', u'ENSMUSG00000030867', u'ENSMUSG00000015149', u'ENSMUSG00000052752', u'ENSMUSG00000066613', u'ENSMUSG00000027439', u'ENSMUSG00000018750', u'ENSMUSG00000091337', u'ENSMUSG00000021466', u'ENSMUSG00000035478', u'ENSMUSG00000072872', u'ENSMUSG00000055024', u'ENSMUSG00000030380', u'ENSMUSG00000073427', u'ENSMUSG00000063568', u'ENSMUSG00000036442', u'ENSMUSG00000071646', u'ENSMUSG00000005774', u'ENSMUSG00000055053', u'ENSMUSG00000028613', u'ENSMUSG00000022141', u'ENSMUSG00000020644', u'ENSMUSG00000053477', u'ENSMUSG00000023991', u'ENSMUSG00000038679', u'ENSMUSG00000075327', u'ENSMUSG00000021743', u'ENSMUSG00000034165', u'ENSMUSG00000020349', u'ENSMUSG00000031386', u'ENSMUSG00000034168', u'ENSMUSG00000023170', u'ENSMUSG00000032187', u'ENSMUSG00000018548', u'ENSMUSG00000018537', u'ENSMUSG00000029026', u'ENSMUSG00000071415', u'ENSMUSG00000061013', u'ENSMUSG00000039994', u'ENSMUSG00000002603', u'ENSMUSG00000019803', u'ENSMUSG00000001156', u'ENSMUSG00000049657', u'ENSMUSG00000001520', u'ENSMUSG00000039410', u'ENSMUSG00000048878', u'ENSMUSG00000021109', u'ENSMUSG00000063870', u'ENSMUSG00000015697', u'ENSMUSG00000038415', u'ENSMUSG00000089715', u'ENSMUSG00000044080', u'ENSMUSG00000027878', u'ENSMUSG00000038418', u'ENSMUSG00000039191', u'ENSMUSG00000029655', u'ENSMUSG00000032216', u'ENSMUSG00000025880', u'ENSMUSG00000049728', u'ENSMUSG00000047242', u'ENSMUSG00000057691', u'ENSMUSG00000027104', u'ENSMUSG00000069171', u'ENSMUSG00000020335', u'ENSMUSG00000029478', u'ENSMUSG00000029475', u'ENSMUSG00000028680', u'ENSMUSG00000024955', u'ENSMUSG00000059436', u'ENSMUSG00000024927', u'ENSMUSG00000024926', u'ENSMUSG00000000282', u'ENSMUSG00000024924', u'ENSMUSG00000079056', u'ENSMUSG00000035397', u'ENSMUSG00000013787', u'ENSMUSG00000042662', u'ENSMUSG00000038845', u'ENSMUSG00000036940', u'ENSMUSG00000041215', u'ENSMUSG00000027358', u'ENSMUSG00000020167', u'ENSMUSG00000020166', u'ENSMUSG00000026484', u'ENSMUSG00000051495', u'ENSMUSG00000028423', u'ENSMUSG00000030103', u'ENSMUSG00000048490', u'ENSMUSG00000028291', u'ENSMUSG00000008682', u'ENSMUSG00000030421', u'ENSMUSG00000022105', u'ENSMUSG00000032329', u'ENSMUSG00000015053', u'ENSMUSG00000030213', u'ENSMUSG00000035158', u'ENSMUSG00000064215', u'ENSMUSG00000000861', u'ENSMUSG00000040481', u'ENSMUSG00000031431', u'ENSMUSG00000021264', u'ENSMUSG00000029050', u'ENSMUSG00000018501', u'ENSMUSG00000023074', u'ENSMUSG00000041515', u'ENSMUSG00000022178', u'ENSMUSG00000039830', u'ENSMUSG00000031353', u'ENSMUSG00000040167', u'ENSMUSG00000052837', u'ENSMUSG00000018160', u'ENSMUSG00000044548', u'ENSMUSG00000004263', u'ENSMUSG00000078202', u'ENSMUSG00000040761', u'ENSMUSG00000022770', u'ENSMUSG00000019969', u'ENSMUSG00000016409', u'ENSMUSG00000070348', u'ENSMUSG00000062906', u'ENSMUSG00000030057', u'ENSMUSG00000020275', u'ENSMUSG00000069114', u'ENSMUSG00000048385', u'ENSMUSG00000022658', u'ENSMUSG00000031221', u'ENSMUSG00000057406', u'ENSMUSG00000002265', u'ENSMUSG00000021488', u'ENSMUSG00000026305', u'ENSMUSG00000030199', u'ENSMUSG00000029832', u'ENSMUSG00000021485', u'ENSMUSG00000037896', u'ENSMUSG00000022255', u'ENSMUSG00000006920', u'ENSMUSG00000061436', u'ENSMUSG00000026739', u'ENSMUSG00000026826', u'ENSMUSG00000020889', u'ENSMUSG00000071076', u'ENSMUSG00000038564', u'ENSMUSG00000066900', u'ENSMUSG00000023826', u'ENSMUSG00000015837', u'ENSMUSG00000036550', u'ENSMUSG00000046532', u'ENSMUSG00000025332', u'ENSMUSG00000037791', u'ENSMUSG00000024608', u'ENSMUSG00000022556', u'ENSMUSG00000034227', u'ENSMUSG00000058318', u'ENSMUSG00000003184', u'ENSMUSG00000039652', u'ENSMUSG00000042745', u'ENSMUSG00000005442', u'ENSMUSG00000014158', u'ENSMUSG00000036904', u'ENSMUSG00000005886', u'ENSMUSG00000049300', u'ENSMUSG00000009575', u'ENSMUSG00000072294', u'ENSMUSG00000008575', u'ENSMUSG00000035992', u'ENSMUSG00000025025', u'ENSMUSG00000069895', u'ENSMUSG00000027803', u'ENSMUSG00000027804', u'ENSMUSG00000060397', u'ENSMUSG00000008976', u'ENSMUSG00000020290', u'ENSMUSG00000027582', u'ENSMUSG00000027630', u'ENSMUSG00000052565', u'ENSMUSG00000020484', u'ENSMUSG00000018604', u'ENSMUSG00000005148', u'ENSMUSG00000041483', u'ENSMUSG00000026603', u'ENSMUSG00000009376', u'ENSMUSG00000006362', u'ENSMUSG00000021451', u'ENSMUSG00000023927', u'ENSMUSG00000038331', u'ENSMUSG00000024137', u'ENSMUSG00000030256', u'ENSMUSG00000030557', u'ENSMUSG00000036893', u'ENSMUSG00000042557', u'ENSMUSG00000030551', u'ENSMUSG00000007880', u'ENSMUSG00000040289', u'ENSMUSG00000032376', u'ENSMUSG00000023031', u'ENSMUSG00000020653', u'ENSMUSG00000024423', u'ENSMUSG00000055639', u'ENSMUSG00000046876', u'ENSMUSG00000020038', u'ENSMUSG00000031601', u'ENSMUSG00000025050', u'ENSMUSG00000021318', u'ENSMUSG00000031609', u'ENSMUSG00000036181', u'ENSMUSG00000052942', u'ENSMUSG00000057522', u'ENSMUSG00000053411', u'ENSMUSG00000002996', u'ENSMUSG00000024431', u'ENSMUSG00000001120', u'ENSMUSG00000039989', u'ENSMUSG00000020246', u'ENSMUSG00000054252', u'ENSMUSG00000019256', u'ENSMUSG00000022508', u'ENSMUSG00000020473', u'ENSMUSG00000020472', u'ENSMUSG00000029267', u'ENSMUSG00000024914', u'ENSMUSG00000010609', u'ENSMUSG00000022346', u'ENSMUSG00000043099', u'ENSMUSG00000078427', u'ENSMUSG00000058886', u'ENSMUSG00000034674', u'ENSMUSG00000025246', u'ENSMUSG00000024642', u'ENSMUSG00000020086', u'ENSMUSG00000022811', u'ENSMUSG00000063659', u'ENSMUSG00000040274', u'ENSMUSG00000040270', u'ENSMUSG00000048249', u'ENSMUSG00000038533', u'ENSMUSG00000032633', u'ENSMUSG00000026646', u'ENSMUSG00000015846', u'ENSMUSG00000024947', u'ENSMUSG00000074220', u'ENSMUSG00000019789', u'ENSMUSG00000023951', u'ENSMUSG00000037032', u'ENSMUSG00000049327', u'ENSMUSG00000022463', u'ENSMUSG00000024260', u'ENSMUSG00000028639', u'ENSMUSG00000012640', u'ENSMUSG00000028163', u'ENSMUSG00000048450', u'ENSMUSG00000027164', u'ENSMUSG00000043372', u'ENSMUSG00000028988', u'ENSMUSG00000027201', u'ENSMUSG00000027206', u'ENSMUSG00000040374', u'ENSMUSG00000038872', u'ENSMUSG00000037214']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0045816', 'GO:0010553'])),
    NtGoeaResults(GO='GO:0000132', NS='BP', enrichment='e', name='establishment of mitotic spindle orientation', ratio_in_study=(5, 624), ratio_in_pop=(22, 13836), p_uncorrected=0.0025503546651748543, depth=8, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=0.12879701083998799, study_items=set([u'ENSMUSG00000024056', u'ENSMUSG00000027883', u'ENSMUSG00000029177', u'ENSMUSG00000026955', u'ENSMUSG00000069910']), pop_n=13836, pop_count=22, pop_items=set([u'ENSMUSG00000025932', u'ENSMUSG00000021732', u'ENSMUSG00000024056', u'ENSMUSG00000028059', u'ENSMUSG00000039842', u'ENSMUSG00000029104', u'ENSMUSG00000048782', u'ENSMUSG00000018736', u'ENSMUSG00000032264', u'ENSMUSG00000022114', u'ENSMUSG00000031865', u'ENSMUSG00000069910', u'ENSMUSG00000027883', u'ENSMUSG00000037211', u'ENSMUSG00000026955', u'ENSMUSG00000022678', u'ENSMUSG00000027168', u'ENSMUSG00000030983', u'ENSMUSG00000029177', u'ENSMUSG00000066306', u'ENSMUSG00000020745', u'ENSMUSG00000039298']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0030609', 'GO:0030607'])),
    NtGoeaResults(GO='GO:0000139', NS='CC', enrichment='p', name='Golgi membrane', ratio_in_study=(2, 624), ratio_in_pop=(134, 13836), p_uncorrected=0.09511871814378817, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020282', u'ENSMUSG00000024308']), pop_n=13836, pop_count=134, pop_items=set([u'ENSMUSG00000028847', u'ENSMUSG00000070426', u'ENSMUSG00000002015', u'ENSMUSG00000038886', u'ENSMUSG00000026499', u'ENSMUSG00000021712', u'ENSMUSG00000024870', u'ENSMUSG00000032038', u'ENSMUSG00000033335', u'ENSMUSG00000030990', u'ENSMUSG00000039357', u'ENSMUSG00000079508', u'ENSMUSG00000024172', u'ENSMUSG00000026811', u'ENSMUSG00000039037', u'ENSMUSG00000029684', u'ENSMUSG00000013846', u'ENSMUSG00000042589', u'ENSMUSG00000015341', u'ENSMUSG00000045038', u'ENSMUSG00000024687', u'ENSMUSG00000021192', u'ENSMUSG00000055373', u'ENSMUSG00000027879', u'ENSMUSG00000028538', u'ENSMUSG00000052712', u'ENSMUSG00000030058', u'ENSMUSG00000052544', u'ENSMUSG00000020946', u'ENSMUSG00000003746', u'ENSMUSG00000026156', u'ENSMUSG00000027575', u'ENSMUSG00000056091', u'ENSMUSG00000026341', u'ENSMUSG00000032485', u'ENSMUSG00000027957', u'ENSMUSG00000022789', u'ENSMUSG00000023826', u'ENSMUSG00000067851', u'ENSMUSG00000006699', u'ENSMUSG00000037306', u'ENSMUSG00000020282', u'ENSMUSG00000001847', u'ENSMUSG00000022159', u'ENSMUSG00000035521', u'ENSMUSG00000000001', u'ENSMUSG00000028480', u'ENSMUSG00000045503', u'ENSMUSG00000040782', u'ENSMUSG00000010392', u'ENSMUSG00000026930', u'ENSMUSG00000008763', u'ENSMUSG00000029544', u'ENSMUSG00000046152', u'ENSMUSG00000039917', u'ENSMUSG00000029705', u'ENSMUSG00000028468', u'ENSMUSG00000028466', u'ENSMUSG00000057337', u'ENSMUSG00000054455', u'ENSMUSG00000045994', u'ENSMUSG00000032570', u'ENSMUSG00000071649', u'ENSMUSG00000079657', u'ENSMUSG00000020077', u'ENSMUSG00000031950', u'ENSMUSG00000026925', u'ENSMUSG00000031156', u'ENSMUSG00000020986', u'ENSMUSG00000030657', u'ENSMUSG00000033272', u'ENSMUSG00000030704', u'ENSMUSG00000030701', u'ENSMUSG00000040722', u'ENSMUSG00000028970', u'ENSMUSG00000038822', u'ENSMUSG00000036646', u'ENSMUSG00000014077', u'ENSMUSG00000005982', u'ENSMUSG00000074582', u'ENSMUSG00000032757', u'ENSMUSG00000068284', u'ENSMUSG00000029407', u'ENSMUSG00000074513', u'ENSMUSG00000010110', u'ENSMUSG00000022885', u'ENSMUSG00000033350', u'ENSMUSG00000024085', u'ENSMUSG00000049721', u'ENSMUSG00000027221', u'ENSMUSG00000062995', u'ENSMUSG00000032458', u'ENSMUSG00000026111', u'ENSMUSG00000020149', u'ENSMUSG00000038861', u'ENSMUSG00000038658', u'ENSMUSG00000024163', u'ENSMUSG00000063410', u'ENSMUSG00000035311', u'ENSMUSG00000028049', u'ENSMUSG00000034780', u'ENSMUSG00000038400', u'ENSMUSG00000022664', u'ENSMUSG00000045414', u'ENSMUSG00000048076', u'ENSMUSG00000025484', u'ENSMUSG00000026577', u'ENSMUSG00000030720', u'ENSMUSG00000024091', u'ENSMUSG00000028173', u'ENSMUSG00000027198', u'ENSMUSG00000035798', u'ENSMUSG00000079442', u'ENSMUSG00000024308', u'ENSMUSG00000015747', u'ENSMUSG00000069874', u'ENSMUSG00000029502', u'ENSMUSG00000067889', u'ENSMUSG00000031112', u'ENSMUSG00000045795', u'ENSMUSG00000030341', u'ENSMUSG00000030104', u'ENSMUSG00000047187', u'ENSMUSG00000031749', u'ENSMUSG00000028293', u'ENSMUSG00000010047', u'ENSMUSG00000003316', u'ENSMUSG00000066306', u'ENSMUSG00000030530', u'ENSMUSG00000042476', u'ENSMUSG00000026277', u'ENSMUSG00000022747', u'ENSMUSG00000007655', u'ENSMUSG00000030471']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000150', NS='MF', enrichment='e', name='recombinase activity', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027323']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000028933', u'ENSMUSG00000021287', u'ENSMUSG00000007646', u'ENSMUSG00000018841', u'ENSMUSG00000027323']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000151', NS='CC', enrichment='p', name='ubiquitin ligase complex', ratio_in_study=(2, 624), ratio_in_pop=(84, 13836), p_uncorrected=0.5919651713976959, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000001403', u'ENSMUSG00000036822']), pop_n=13836, pop_count=84, pop_items=set([u'ENSMUSG00000001786', u'ENSMUSG00000026739', u'ENSMUSG00000028309', u'ENSMUSG00000060450', u'ENSMUSG00000001403', u'ENSMUSG00000064145', u'ENSMUSG00000038506', u'ENSMUSG00000040351', u'ENSMUSG00000066042', u'ENSMUSG00000038068', u'ENSMUSG00000059890', u'ENSMUSG00000031201', u'ENSMUSG00000022400', u'ENSMUSG00000090083', u'ENSMUSG00000021200', u'ENSMUSG00000039615', u'ENSMUSG00000019984', u'ENSMUSG00000029458', u'ENSMUSG00000023826', u'ENSMUSG00000028410', u'ENSMUSG00000028793', u'ENSMUSG00000038206', u'ENSMUSG00000028557', u'ENSMUSG00000023286', u'ENSMUSG00000066892', u'ENSMUSG00000004221', u'ENSMUSG00000020305', u'ENSMUSG00000027708', u'ENSMUSG00000026799', u'ENSMUSG00000018160', u'ENSMUSG00000021598', u'ENSMUSG00000017210', u'ENSMUSG00000030291', u'ENSMUSG00000028630', u'ENSMUSG00000091971', u'ENSMUSG00000001157', u'ENSMUSG00000014074', u'ENSMUSG00000018923', u'ENSMUSG00000019927', u'ENSMUSG00000027272', u'ENSMUSG00000027598', u'ENSMUSG00000022280', u'ENSMUSG00000021774', u'ENSMUSG00000036822', u'ENSMUSG00000026311', u'ENSMUSG00000026484', u'ENSMUSG00000079184', u'ENSMUSG00000020114', u'ENSMUSG00000029060', u'ENSMUSG00000052752', u'ENSMUSG00000028960', u'ENSMUSG00000091896', u'ENSMUSG00000028252', u'ENSMUSG00000039904', u'ENSMUSG00000044308', u'ENSMUSG00000023977', u'ENSMUSG00000022184', u'ENSMUSG00000079487', u'ENSMUSG00000074781', u'ENSMUSG00000018363', u'ENSMUSG00000029635', u'ENSMUSG00000092558', u'ENSMUSG00000051674', u'ENSMUSG00000020801', u'ENSMUSG00000020397', u'ENSMUSG00000030816', u'ENSMUSG00000048787', u'ENSMUSG00000078923', u'ENSMUSG00000024325', u'ENSMUSG00000032216', u'ENSMUSG00000032002', u'ENSMUSG00000031935', u'ENSMUSG00000020642', u'ENSMUSG00000025234', u'ENSMUSG00000005371', u'ENSMUSG00000024807', u'ENSMUSG00000063760', u'ENSMUSG00000032415', u'ENSMUSG00000002679', u'ENSMUSG00000015656', u'ENSMUSG00000025578', u'ENSMUSG00000038622', u'ENSMUSG00000029397', u'ENSMUSG00000026942']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000165', NS='BP', enrichment='p', name='MAPK cascade', ratio_in_study=(1, 624), ratio_in_pop=(55, 13836), p_uncorrected=0.5190423824152548, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000035352']), pop_n=13836, pop_count=55, pop_items=set([u'ENSMUSG00000027784', u'ENSMUSG00000032959', u'ENSMUSG00000020716', u'ENSMUSG00000021127', u'ENSMUSG00000054252', u'ENSMUSG00000029454', u'ENSMUSG00000030110', u'ENSMUSG00000029458', u'ENSMUSG00000022623', u'ENSMUSG00000028284', u'ENSMUSG00000030557', u'ENSMUSG00000034845', u'ENSMUSG00000023050', u'ENSMUSG00000022194', u'ENSMUSG00000027560', u'ENSMUSG00000022556', u'ENSMUSG00000022346', u'ENSMUSG00000002603', u'ENSMUSG00000031681', u'ENSMUSG00000022619', u'ENSMUSG00000020849', u'ENSMUSG00000071369', u'ENSMUSG00000044786', u'ENSMUSG00000040631', u'ENSMUSG00000043535', u'ENSMUSG00000004936', u'ENSMUSG00000041607', u'ENSMUSG00000005583', u'ENSMUSG00000042626', u'ENSMUSG00000034175', u'ENSMUSG00000063065', u'ENSMUSG00000020623', u'ENSMUSG00000031137', u'ENSMUSG00000039217', u'ENSMUSG00000063358', u'ENSMUSG00000035352', u'ENSMUSG00000068335', u'ENSMUSG00000024947', u'ENSMUSG00000061288', u'ENSMUSG00000058444', u'ENSMUSG00000033352', u'ENSMUSG00000045817', u'ENSMUSG00000000441', u'ENSMUSG00000050711', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000036273', u'ENSMUSG00000032577', u'ENSMUSG00000062991', u'ENSMUSG00000026177', u'ENSMUSG00000038855', u'ENSMUSG00000035027', u'ENSMUSG00000018932', u'ENSMUSG00000030890', u'ENSMUSG00000002413']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000166', NS='MF', enrichment='e', name='nucleotide binding', ratio_in_study=(112, 624), ratio_in_pop=(1434, 13836), p_uncorrected=5.084608445075661e-09, depth=4, study_count=112, p_sm_bonferroni=7.9858860238358337e-05, p_fdr_bh=1.5357473122761218e-06, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000034349', u'ENSMUSG00000045328', u'ENSMUSG00000074151', u'ENSMUSG00000037321', u'ENSMUSG00000025358', u'ENSMUSG00000042699', u'ENSMUSG00000007080', u'ENSMUSG00000003779', u'ENSMUSG00000020380', u'ENSMUSG00000028587', u'ENSMUSG00000027379', u'ENSMUSG00000042167', u'ENSMUSG00000034329', u'ENSMUSG00000019845', u'ENSMUSG00000025758', u'ENSMUSG00000021569', u'ENSMUSG00000029521', u'ENSMUSG00000024079', u'ENSMUSG00000045136', u'ENSMUSG00000051378', u'ENSMUSG00000006445', u'ENSMUSG00000033257', u'ENSMUSG00000026896', u'ENSMUSG00000030677', u'ENSMUSG00000024974', u'ENSMUSG00000027496', u'ENSMUSG00000032254', u'ENSMUSG00000029283', u'ENSMUSG00000036875', u'ENSMUSG00000021115', u'ENSMUSG00000023908', u'ENSMUSG00000031004', u'ENSMUSG00000029730', u'ENSMUSG00000040296', u'ENSMUSG00000019214', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000002870', u'ENSMUSG00000030978', u'ENSMUSG00000035683', u'ENSMUSG00000031478', u'ENSMUSG00000028633', u'ENSMUSG00000030867', u'ENSMUSG00000041498', u'ENSMUSG00000054072', u'ENSMUSG00000032409', u'ENSMUSG00000035266', u'ENSMUSG00000027883', u'ENSMUSG00000028312', u'ENSMUSG00000026281', u'ENSMUSG00000026622', u'ENSMUSG00000036768', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000005370', u'ENSMUSG00000034218', u'ENSMUSG00000012443', u'ENSMUSG00000038774', u'ENSMUSG00000032661', u'ENSMUSG00000022360', u'ENSMUSG00000001403', u'ENSMUSG00000033762', u'ENSMUSG00000051220', u'ENSMUSG00000030528', u'ENSMUSG00000029363', u'ENSMUSG00000036086', u'ENSMUSG00000027580', u'ENSMUSG00000026355', u'ENSMUSG00000020914', u'ENSMUSG00000034206', u'ENSMUSG00000041133', u'ENSMUSG00000022033', u'ENSMUSG00000017550', u'ENSMUSG00000017830', u'ENSMUSG00000046879', u'ENSMUSG00000005481', u'ENSMUSG00000020897', u'ENSMUSG00000022881', u'ENSMUSG00000025001', u'ENSMUSG00000032344', u'ENSMUSG00000005410', u'ENSMUSG00000028702', u'ENSMUSG00000002227', u'ENSMUSG00000028678', u'ENSMUSG00000038379', u'ENSMUSG00000024795', u'ENSMUSG00000041859', u'ENSMUSG00000000386', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000056394', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000002748', u'ENSMUSG00000027115', u'ENSMUSG00000024404', u'ENSMUSG00000038644', u'ENSMUSG00000025747', u'ENSMUSG00000022673', u'ENSMUSG00000029580', u'ENSMUSG00000017499', u'ENSMUSG00000019979', u'ENSMUSG00000029561', u'ENSMUSG00000033222', u'ENSMUSG00000034311', u'ENSMUSG00000026274', u'ENSMUSG00000005237', u'ENSMUSG00000020608', u'ENSMUSG00000025574', u'ENSMUSG00000027078', u'ENSMUSG00000060519']), pop_n=13836, pop_count=1434, pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000002010', u'ENSMUSG00000020190', u'ENSMUSG00000004897', u'ENSMUSG00000028438', u'ENSMUSG00000045007', u'ENSMUSG00000049866', u'ENSMUSG00000020752', u'ENSMUSG00000021569', u'ENSMUSG00000033862', u'ENSMUSG00000024042', u'ENSMUSG00000045136', u'ENSMUSG00000074364', u'ENSMUSG00000059981', u'ENSMUSG00000053693', u'ENSMUSG00000052459', u'ENSMUSG00000052456', u'ENSMUSG00000052981', u'ENSMUSG00000019917', u'ENSMUSG00000001473', u'ENSMUSG00000022911', u'ENSMUSG00000020366', u'ENSMUSG00000020361', u'ENSMUSG00000001783', u'ENSMUSG00000064120', u'ENSMUSG00000018209', u'ENSMUSG00000002870', u'ENSMUSG00000070284', u'ENSMUSG00000054072', u'ENSMUSG00000001270', u'ENSMUSG00000050002', u'ENSMUSG00000032802', u'ENSMUSG00000015599', u'ENSMUSG00000018995', u'ENSMUSG00000000605', u'ENSMUSG00000030660', u'ENSMUSG00000036768', u'ENSMUSG00000000787', u'ENSMUSG00000021589', u'ENSMUSG00000041658', u'ENSMUSG00000005370', u'ENSMUSG00000022861', u'ENSMUSG00000041650', u'ENSMUSG00000037149', u'ENSMUSG00000076441', u'ENSMUSG00000019143', u'ENSMUSG00000026596', u'ENSMUSG00000030409', u'ENSMUSG00000054855', u'ENSMUSG00000030400', u'ENSMUSG00000041235', u'ENSMUSG00000041720', u'ENSMUSG00000030061', u'ENSMUSG00000019794', u'ENSMUSG00000026201', u'ENSMUSG00000026202', u'ENSMUSG00000026207', u'ENSMUSG00000038094', u'ENSMUSG00000030243', u'ENSMUSG00000030249', u'ENSMUSG00000031333', u'ENSMUSG00000026117', u'ENSMUSG00000040296', u'ENSMUSG00000062312', u'ENSMUSG00000003534', u'ENSMUSG00000025877', u'ENSMUSG00000055723', u'ENSMUSG00000025870', u'ENSMUSG00000062070', u'ENSMUSG00000031202', u'ENSMUSG00000031751', u'ENSMUSG00000023050', u'ENSMUSG00000026575', u'ENSMUSG00000007029', u'ENSMUSG00000003228', u'ENSMUSG00000035305', u'ENSMUSG00000038260', u'ENSMUSG00000031112', u'ENSMUSG00000013736', u'ENSMUSG00000022673', u'ENSMUSG00000022672', u'ENSMUSG00000028758', u'ENSMUSG00000047187', u'ENSMUSG00000056367', u'ENSMUSG00000028756', u'ENSMUSG00000003644', u'ENSMUSG00000057342', u'ENSMUSG00000029916', u'ENSMUSG00000022272', u'ENSMUSG00000020935', u'ENSMUSG00000026806', u'ENSMUSG00000029752', u'ENSMUSG00000029599', u'ENSMUSG00000020694', u'ENSMUSG00000020697', u'ENSMUSG00000047986', u'ENSMUSG00000043463', u'ENSMUSG00000022471', u'ENSMUSG00000038352', u'ENSMUSG00000025613', u'ENSMUSG00000021108', u'ENSMUSG00000034329', u'ENSMUSG00000035232', u'ENSMUSG00000052539', u'ENSMUSG00000038861', u'ENSMUSG00000026779', u'ENSMUSG00000032498', u'ENSMUSG00000006019', u'ENSMUSG00000045038', u'ENSMUSG00000042354', u'ENSMUSG00000028530', u'ENSMUSG00000025059', u'ENSMUSG00000035948', u'ENSMUSG00000032308', u'ENSMUSG00000061288', u'ENSMUSG00000061207', u'ENSMUSG00000032307', u'ENSMUSG00000017291', u'ENSMUSG00000068798', u'ENSMUSG00000035051', u'ENSMUSG00000020794', u'ENSMUSG00000029363', u'ENSMUSG00000052997', u'ENSMUSG00000078671', u'ENSMUSG00000021771', u'ENSMUSG00000021772', u'ENSMUSG00000021774', u'ENSMUSG00000020357', u'ENSMUSG00000039913', u'ENSMUSG00000078816', u'ENSMUSG00000002688', u'ENSMUSG00000032470', u'ENSMUSG00000033308', u'ENSMUSG00000032478', u'ENSMUSG00000019832', u'ENSMUSG00000020900', u'ENSMUSG00000079657', u'ENSMUSG00000063077', u'ENSMUSG00000073016', u'ENSMUSG00000030655', u'ENSMUSG00000037685', u'ENSMUSG00000033276', u'ENSMUSG00000034206', u'ENSMUSG00000001313', u'ENSMUSG00000024235', u'ENSMUSG00000024234', u'ENSMUSG00000024981', u'ENSMUSG00000041133', u'ENSMUSG00000041135', u'ENSMUSG00000041642', u'ENSMUSG00000076435', u'ENSMUSG00000066952', u'ENSMUSG00000027296', u'ENSMUSG00000027297', u'ENSMUSG00000027293', u'ENSMUSG00000027298', u'ENSMUSG00000055884', u'ENSMUSG00000027185', u'ENSMUSG00000005410', u'ENSMUSG00000024527', u'ENSMUSG00000024524', u'ENSMUSG00000027610', u'ENSMUSG00000018830', u'ENSMUSG00000051747', u'ENSMUSG00000040354', u'ENSMUSG00000028126', u'ENSMUSG00000038085', u'ENSMUSG00000038084', u'ENSMUSG00000026274', u'ENSMUSG00000029408', u'ENSMUSG00000027774', u'ENSMUSG00000037351', u'ENSMUSG00000031432', u'ENSMUSG00000056999', u'ENSMUSG00000041828', u'ENSMUSG00000019659', u'ENSMUSG00000058594', u'ENSMUSG00000022110', u'ENSMUSG00000031851', u'ENSMUSG00000003810', u'ENSMUSG00000038644', u'ENSMUSG00000034154', u'ENSMUSG00000021375', u'ENSMUSG00000074576', u'ENSMUSG00000003411', u'ENSMUSG00000031748', u'ENSMUSG00000004451', u'ENSMUSG00000060860', u'ENSMUSG00000031104', u'ENSMUSG00000020516', u'ENSMUSG00000047193', u'ENSMUSG00000020513', u'ENSMUSG00000034974', u'ENSMUSG00000029613', u'ENSMUSG00000029920', u'ENSMUSG00000022241', u'ENSMUSG00000043670', u'ENSMUSG00000025266', u'ENSMUSG00000039354', u'ENSMUSG00000025915', u'ENSMUSG00000026817', u'ENSMUSG00000021115', u'ENSMUSG00000052504', u'ENSMUSG00000035202', u'ENSMUSG00000021266', u'ENSMUSG00000029430', u'ENSMUSG00000032489', u'ENSMUSG00000009566', u'ENSMUSG00000009563', u'ENSMUSG00000009293', u'ENSMUSG00000064037', u'ENSMUSG00000035842', u'ENSMUSG00000028527', u'ENSMUSG00000025730', u'ENSMUSG00000025733', u'ENSMUSG00000035683', u'ENSMUSG00000025041', u'ENSMUSG00000032648', u'ENSMUSG00000035112', u'ENSMUSG00000035441', u'ENSMUSG00000020736', u'ENSMUSG00000032316', u'ENSMUSG00000032312', u'ENSMUSG00000001416', u'ENSMUSG00000016757', u'ENSMUSG00000035064', u'ENSMUSG00000052273', u'ENSMUSG00000053907', u'ENSMUSG00000017376', u'ENSMUSG00000053870', u'ENSMUSG00000001525', u'ENSMUSG00000063065', u'ENSMUSG00000022075', u'ENSMUSG00000058298', u'ENSMUSG00000027519', u'ENSMUSG00000078942', u'ENSMUSG00000014668', u'ENSMUSG00000036745', u'ENSMUSG00000017405', u'ENSMUSG00000074923', u'ENSMUSG00000070390', u'ENSMUSG00000001630', u'ENSMUSG00000001323', u'ENSMUSG00000010755', u'ENSMUSG00000033191', u'ENSMUSG00000062421', u'ENSMUSG00000019066', u'ENSMUSG00000019791', u'ENSMUSG00000024952', u'ENSMUSG00000041696', u'ENSMUSG00000005534', u'ENSMUSG00000005533', u'ENSMUSG00000030643', u'ENSMUSG00000024558', u'ENSMUSG00000000127', u'ENSMUSG00000027605', u'ENSMUSG00000070644', u'ENSMUSG00000026778', u'ENSMUSG00000018012', u'ENSMUSG00000027353', u'ENSMUSG00000040618', u'ENSMUSG00000026775', u'ENSMUSG00000027359', u'ENSMUSG00000061838', u'ENSMUSG00000003808', u'ENSMUSG00000026489', u'ENSMUSG00000017999', u'ENSMUSG00000030515', u'ENSMUSG00000027770', u'ENSMUSG00000031913', u'ENSMUSG00000021196', u'ENSMUSG00000026172', u'ENSMUSG00000015133', u'ENSMUSG00000025854', u'ENSMUSG00000025855', u'ENSMUSG00000026558', u'ENSMUSG00000004591', u'ENSMUSG00000042426', u'ENSMUSG00000057963', u'ENSMUSG00000063870', u'ENSMUSG00000026393', u'ENSMUSG00000003068', u'ENSMUSG00000005958', u'ENSMUSG00000005951', u'ENSMUSG00000024830', u'ENSMUSG00000003660', u'ENSMUSG00000022253', u'ENSMUSG00000029283', u'ENSMUSG00000021294', u'ENSMUSG00000026825', u'ENSMUSG00000013662', u'ENSMUSG00000031004', u'ENSMUSG00000020431', u'ENSMUSG00000029730', u'ENSMUSG00000020437', u'ENSMUSG00000057147', u'ENSMUSG00000003119', u'ENSMUSG00000028646', u'ENSMUSG00000034187', u'ENSMUSG00000025630', u'ENSMUSG00000037989', u'ENSMUSG00000059883', u'ENSMUSG00000072214', u'ENSMUSG00000028469', u'ENSMUSG00000049907', u'ENSMUSG00000043535', u'ENSMUSG00000028089', u'ENSMUSG00000016349', u'ENSMUSG00000028085', u'ENSMUSG00000035455', u'ENSMUSG00000021635', u'ENSMUSG00000075528', u'ENSMUSG00000020721', u'ENSMUSG00000007815', u'ENSMUSG00000035198', u'ENSMUSG00000074151', u'ENSMUSG00000001403', u'ENSMUSG00000021754', u'ENSMUSG00000000530', u'ENSMUSG00000028268', u'ENSMUSG00000066442', u'ENSMUSG00000020654', u'ENSMUSG00000020657', u'ENSMUSG00000019927', u'ENSMUSG00000032109', u'ENSMUSG00000033985', u'ENSMUSG00000032101', u'ENSMUSG00000057897', u'ENSMUSG00000002997', u'ENSMUSG00000002227', u'ENSMUSG00000021918', u'ENSMUSG00000032294', u'ENSMUSG00000032127', u'ENSMUSG00000033610', u'ENSMUSG00000036752', u'ENSMUSG00000033216', u'ENSMUSG00000058355', u'ENSMUSG00000020080', u'ENSMUSG00000020088', u'ENSMUSG00000075289', u'ENSMUSG00000022812', u'ENSMUSG00000071723', u'ENSMUSG00000026761', u'ENSMUSG00000033434', u'ENSMUSG00000024943', u'ENSMUSG00000024944', u'ENSMUSG00000021936', u'ENSMUSG00000024948', u'ENSMUSG00000020390', u'ENSMUSG00000030986', u'ENSMUSG00000024892', u'ENSMUSG00000024899', u'ENSMUSG00000027365', u'ENSMUSG00000050382', u'ENSMUSG00000026494', u'ENSMUSG00000040084', u'ENSMUSG00000026490', u'ENSMUSG00000031583', u'ENSMUSG00000020865', u'ENSMUSG00000059248', u'ENSMUSG00000023286', u'ENSMUSG00000027709', u'ENSMUSG00000004054', u'ENSMUSG00000004056', u'ENSMUSG00000019478', u'ENSMUSG00000015120', u'ENSMUSG00000015023', u'ENSMUSG00000055775', u'ENSMUSG00000006567', u'ENSMUSG00000004677', u'ENSMUSG00000027011', u'ENSMUSG00000025939', u'ENSMUSG00000026944', u'ENSMUSG00000022629', u'ENSMUSG00000029635', u'ENSMUSG00000020532', u'ENSMUSG00000006699', u'ENSMUSG00000056394', u'ENSMUSG00000020537', u'ENSMUSG00000029128', u'ENSMUSG00000021287', u'ENSMUSG00000021282', u'ENSMUSG00000035266', u'ENSMUSG00000031012', u'ENSMUSG00000031016', u'ENSMUSG00000026836', u'ENSMUSG00000020402', u'ENSMUSG00000026834', u'ENSMUSG00000022533', u'ENSMUSG00000031967', u'ENSMUSG00000022538', u'ENSMUSG00000073838', u'ENSMUSG00000011254', u'ENSMUSG00000007613', u'ENSMUSG00000007610', u'ENSMUSG00000006740', u'ENSMUSG00000032661', u'ENSMUSG00000020715', u'ENSMUSG00000002059', u'ENSMUSG00000020719', u'ENSMUSG00000028479', u'ENSMUSG00000028470', u'ENSMUSG00000034449', u'ENSMUSG00000005981', u'ENSMUSG00000034994', u'ENSMUSG00000032594', u'ENSMUSG00000028078', u'ENSMUSG00000032599', u'ENSMUSG00000028277', u'ENSMUSG00000028274', u'ENSMUSG00000035486', u'ENSMUSG00000038967', u'ENSMUSG00000028270', u'ENSMUSG00000028127', u'ENSMUSG00000018796', u'ENSMUSG00000028278', u'ENSMUSG00000016179', u'ENSMUSG00000042010', u'ENSMUSG00000017176', u'ENSMUSG00000017774', u'ENSMUSG00000052920', u'ENSMUSG00000039960', u'ENSMUSG00000032113', u'ENSMUSG00000032440', u'ENSMUSG00000032115', u'ENSMUSG00000025178', u'ENSMUSG00000002233', u'ENSMUSG00000019863', u'ENSMUSG00000032281', u'ENSMUSG00000024151', u'ENSMUSG00000024404', u'ENSMUSG00000022822', u'ENSMUSG00000022827', u'ENSMUSG00000020258', u'ENSMUSG00000041168', u'ENSMUSG00000032842', u'ENSMUSG00000017550', u'ENSMUSG00000033220', u'ENSMUSG00000033222', u'ENSMUSG00000024712', u'ENSMUSG00000037742', u'ENSMUSG00000060519', u'ENSMUSG00000009376', u'ENSMUSG00000032932', u'ENSMUSG00000060671', u'ENSMUSG00000010021', u'ENSMUSG00000020389', u'ENSMUSG00000053093', u'ENSMUSG00000020380', u'ENSMUSG00000020386', u'ENSMUSG00000020385', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000004113', u'ENSMUSG00000060477', u'ENSMUSG00000020890', u'ENSMUSG00000003868', u'ENSMUSG00000027394', u'ENSMUSG00000039585', u'ENSMUSG00000037251', u'ENSMUSG00000005045', u'ENSMUSG00000055540', u'ENSMUSG00000056947', u'ENSMUSG00000031974', u'ENSMUSG00000031972', u'ENSMUSG00000026622', u'ENSMUSG00000026620', u'ENSMUSG00000062234', u'ENSMUSG00000022386', u'ENSMUSG00000027952', u'ENSMUSG00000006517', u'ENSMUSG00000031715', u'ENSMUSG00000031378', u'ENSMUSG00000031808', u'ENSMUSG00000041415', u'ENSMUSG00000026027', u'ENSMUSG00000014850', u'ENSMUSG00000031805', u'ENSMUSG00000038762', u'ENSMUSG00000031392', u'ENSMUSG00000034290', u'ENSMUSG00000025949', u'ENSMUSG00000003283', u'ENSMUSG00000031155', u'ENSMUSG00000020527', u'ENSMUSG00000070934', u'ENSMUSG00000012443', u'ENSMUSG00000026848', u'ENSMUSG00000026849', u'ENSMUSG00000026842', u'ENSMUSG00000009772', u'ENSMUSG00000029245', u'ENSMUSG00000029247', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000028661', u'ENSMUSG00000057614', u'ENSMUSG00000028719', u'ENSMUSG00000028869', u'ENSMUSG00000028862', u'ENSMUSG00000021385', u'ENSMUSG00000020705', u'ENSMUSG00000032615', u'ENSMUSG00000002763', u'ENSMUSG00000020700', u'ENSMUSG00000029403', u'ENSMUSG00000020708', u'ENSMUSG00000009555', u'ENSMUSG00000025092', u'ENSMUSG00000034472', u'ENSMUSG00000021730', u'ENSMUSG00000029674', u'ENSMUSG00000008730', u'ENSMUSG00000038970', u'ENSMUSG00000028289', u'ENSMUSG00000063410', u'ENSMUSG00000028284', u'ENSMUSG00000025162', u'ENSMUSG00000028443', u'ENSMUSG00000042572', u'ENSMUSG00000005672', u'ENSMUSG00000020671', u'ENSMUSG00000020677', u'ENSMUSG00000002428', u'ENSMUSG00000036285', u'ENSMUSG00000045095', u'ENSMUSG00000024383', u'ENSMUSG00000024382', u'ENSMUSG00000024511', u'ENSMUSG00000038145', u'ENSMUSG00000032435', u'ENSMUSG00000053289', u'ENSMUSG00000021428', u'ENSMUSG00000021420', u'ENSMUSG00000024143', u'ENSMUSG00000022836', u'ENSMUSG00000068739', u'ENSMUSG00000045328', u'ENSMUSG00000027546', u'ENSMUSG00000020267', u'ENSMUSG00000019173', u'ENSMUSG00000036737', u'ENSMUSG00000039954', u'ENSMUSG00000032547', u'ENSMUSG00000053754', u'ENSMUSG00000032549', u'ENSMUSG00000048899', u'ENSMUSG00000018900', u'ENSMUSG00000002550', u'ENSMUSG00000054404', u'ENSMUSG00000037885', u'ENSMUSG00000047867', u'ENSMUSG00000037738', u'ENSMUSG00000026709', u'ENSMUSG00000024969', u'ENSMUSG00000030761', u'ENSMUSG00000033526', u'ENSMUSG00000001999', u'ENSMUSG00000027496', u'ENSMUSG00000037643', u'ENSMUSG00000024566', u'ENSMUSG00000070699', u'ENSMUSG00000019699', u'ENSMUSG00000033703', u'ENSMUSG00000033705', u'ENSMUSG00000041797', u'ENSMUSG00000031565', u'ENSMUSG00000050271', u'ENSMUSG00000004865', u'ENSMUSG00000025357', u'ENSMUSG00000000001', u'ENSMUSG00000027722', u'ENSMUSG00000031960', u'ENSMUSG00000023460', u'ENSMUSG00000062209', u'ENSMUSG00000042978', u'ENSMUSG00000062203', u'ENSMUSG00000059602', u'ENSMUSG00000027030', u'ENSMUSG00000030815', u'ENSMUSG00000023004', u'ENSMUSG00000031360', u'ENSMUSG00000026034', u'ENSMUSG00000038774', u'ENSMUSG00000042817', u'ENSMUSG00000073639', u'ENSMUSG00000021062', u'ENSMUSG00000025420', u'ENSMUSG00000025422', u'ENSMUSG00000025428', u'ENSMUSG00000056228', u'ENSMUSG00000021069', u'ENSMUSG00000050890', u'ENSMUSG00000042608', u'ENSMUSG00000029657', u'ENSMUSG00000028708', u'ENSMUSG00000028874', u'ENSMUSG00000025885', u'ENSMUSG00000028876', u'ENSMUSG00000006728', u'ENSMUSG00000060904', u'ENSMUSG00000025393', u'ENSMUSG00000032604', u'ENSMUSG00000039166', u'ENSMUSG00000032601', u'ENSMUSG00000029471', u'ENSMUSG00000025375', u'ENSMUSG00000017418', u'ENSMUSG00000023868', u'ENSMUSG00000028678', u'ENSMUSG00000035390', u'ENSMUSG00000021646', u'ENSMUSG00000029504', u'ENSMUSG00000029505', u'ENSMUSG00000021700', u'ENSMUSG00000021701', u'ENSMUSG00000028051', u'ENSMUSG00000028057', u'ENSMUSG00000028292', u'ENSMUSG00000028452', u'ENSMUSG00000025170', u'ENSMUSG00000042567', u'ENSMUSG00000028458', u'ENSMUSG00000039018', u'ENSMUSG00000020608', u'ENSMUSG00000035027', u'ENSMUSG00000032042', u'ENSMUSG00000045538', u'ENSMUSG00000053291', u'ENSMUSG00000032420', u'ENSMUSG00000019848', u'ENSMUSG00000071369', u'ENSMUSG00000020115', u'ENSMUSG00000004815', u'ENSMUSG00000019841', u'ENSMUSG00000019843', u'ENSMUSG00000019845', u'ENSMUSG00000021413', u'ENSMUSG00000025199', u'ENSMUSG00000048939', u'ENSMUSG00000020277', u'ENSMUSG00000020273', u'ENSMUSG00000020272', u'ENSMUSG00000002949', u'ENSMUSG00000062591', u'ENSMUSG00000032553', u'ENSMUSG00000032557', u'ENSMUSG00000036636', u'ENSMUSG00000054364', u'ENSMUSG00000020079', u'ENSMUSG00000024772', u'ENSMUSG00000020075', u'ENSMUSG00000020076', u'ENSMUSG00000032959', u'ENSMUSG00000035824', u'ENSMUSG00000026737', u'ENSMUSG00000001380', u'ENSMUSG00000038563', u'ENSMUSG00000030978', u'ENSMUSG00000024576', u'ENSMUSG00000030603', u'ENSMUSG00000024359', u'ENSMUSG00000014158', u'ENSMUSG00000004393', u'ENSMUSG00000051590', u'ENSMUSG00000058672', u'ENSMUSG00000020857', u'ENSMUSG00000061878', u'ENSMUSG00000030774', u'ENSMUSG00000041323', u'ENSMUSG00000043962', u'ENSMUSG00000027739', u'ENSMUSG00000000386', u'ENSMUSG00000015016', u'ENSMUSG00000048148', u'ENSMUSG00000027931', u'ENSMUSG00000027932', u'ENSMUSG00000026198', u'ENSMUSG00000030397', u'ENSMUSG00000026281', u'ENSMUSG00000030802', u'ENSMUSG00000023033', u'ENSMUSG00000026516', u'ENSMUSG00000022033', u'ENSMUSG00000046879', u'ENSMUSG00000001755', u'ENSMUSG00000056458', u'ENSMUSG00000057455', u'ENSMUSG00000023104', u'ENSMUSG00000026463', u'ENSMUSG00000022722', u'ENSMUSG00000046947', u'ENSMUSG00000025417', u'ENSMUSG00000038379', u'ENSMUSG00000026864', u'ENSMUSG00000022503', u'ENSMUSG00000057672', u'ENSMUSG00000022617', u'ENSMUSG00000029647', u'ENSMUSG00000029641', u'ENSMUSG00000029869', u'ENSMUSG00000029648', u'ENSMUSG00000039159', u'ENSMUSG00000029464', u'ENSMUSG00000029467', u'ENSMUSG00000009828', u'ENSMUSG00000042688', u'ENSMUSG00000062960', u'ENSMUSG00000025980', u'ENSMUSG00000025742', u'ENSMUSG00000025747', u'ENSMUSG00000061462', u'ENSMUSG00000016308', u'ENSMUSG00000029512', u'ENSMUSG00000029516', u'ENSMUSG00000029518', u'ENSMUSG00000049892', u'ENSMUSG00000021712', u'ENSMUSG00000016528', u'ENSMUSG00000016526', u'ENSMUSG00000089872', u'ENSMUSG00000054958', u'ENSMUSG00000043572', u'ENSMUSG00000028932', u'ENSMUSG00000002409', u'ENSMUSG00000035032', u'ENSMUSG00000017144', u'ENSMUSG00000052738', u'ENSMUSG00000020611', u'ENSMUSG00000020612', u'ENSMUSG00000021400', u'ENSMUSG00000021408', u'ENSMUSG00000004936', u'ENSMUSG00000032097', u'ENSMUSG00000016637', u'ENSMUSG00000049091', u'ENSMUSG00000042228', u'ENSMUSG00000032384', u'ENSMUSG00000035722', u'ENSMUSG00000022607', u'ENSMUSG00000035725', u'ENSMUSG00000004933', u'ENSMUSG00000018583', u'ENSMUSG00000024290', u'ENSMUSG00000000711', u'ENSMUSG00000067995', u'ENSMUSG00000028702', u'ENSMUSG00000019214', u'ENSMUSG00000044749', u'ENSMUSG00000032565', u'ENSMUSG00000032562', u'ENSMUSG00000006386', u'ENSMUSG00000036622', u'ENSMUSG00000020048', u'ENSMUSG00000024769', u'ENSMUSG00000051853', u'ENSMUSG00000030849', u'ENSMUSG00000033161', u'ENSMUSG00000036241', u'ENSMUSG00000024349', u'ENSMUSG00000078945', u'ENSMUSG00000056608', u'ENSMUSG00000024617', u'ENSMUSG00000000628', u'ENSMUSG00000027668', u'ENSMUSG00000024587', u'ENSMUSG00000026615', u'ENSMUSG00000026618', u'ENSMUSG00000066800', u'ENSMUSG00000033762', u'ENSMUSG00000024831', u'ENSMUSG00000005493', u'ENSMUSG00000050697', u'ENSMUSG00000020827', u'ENSMUSG00000020821', u'ENSMUSG00000030704', u'ENSMUSG00000027580', u'ENSMUSG00000000532', u'ENSMUSG00000020917', u'ENSMUSG00000020914', u'ENSMUSG00000051615', u'ENSMUSG00000031948', u'ENSMUSG00000060733', u'ENSMUSG00000019432', u'ENSMUSG00000014554', u'ENSMUSG00000033618', u'ENSMUSG00000063358', u'ENSMUSG00000036093', u'ENSMUSG00000027905', u'ENSMUSG00000026187', u'ENSMUSG00000040936', u'ENSMUSG00000000441', u'ENSMUSG00000031833', u'ENSMUSG00000017264', u'ENSMUSG00000002205', u'ENSMUSG00000021240', u'ENSMUSG00000023755', u'ENSMUSG00000026473', u'ENSMUSG00000029186', u'ENSMUSG00000020440', u'ENSMUSG00000029217', u'ENSMUSG00000020444', u'ENSMUSG00000026878', u'ENSMUSG00000022376', u'ENSMUSG00000046994', u'ENSMUSG00000003762', u'ENSMUSG00000034663', u'ENSMUSG00000025574', u'ENSMUSG00000015971', u'ENSMUSG00000021666', u'ENSMUSG00000039145', u'ENSMUSG00000047866', u'ENSMUSG00000007739', u'ENSMUSG00000025358', u'ENSMUSG00000042699', u'ENSMUSG00000023809', u'ENSMUSG00000028107', u'ENSMUSG00000036943', u'ENSMUSG00000025757', u'ENSMUSG00000028587', u'ENSMUSG00000006678', u'ENSMUSG00000021066', u'ENSMUSG00000042167', u'ENSMUSG00000021068', u'ENSMUSG00000025758', u'ENSMUSG00000020620', u'ENSMUSG00000023938', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000028032', u'ENSMUSG00000034931', u'ENSMUSG00000034930', u'ENSMUSG00000034936', u'ENSMUSG00000035828', u'ENSMUSG00000008859', u'ENSMUSG00000028926', u'ENSMUSG00000002413', u'ENSMUSG00000079316', u'ENSMUSG00000021470', u'ENSMUSG00000022994', u'ENSMUSG00000046768', u'ENSMUSG00000078578', u'ENSMUSG00000035759', u'ENSMUSG00000042349', u'ENSMUSG00000042348', u'ENSMUSG00000020132', u'ENSMUSG00000017686', u'ENSMUSG00000038058', u'ENSMUSG00000002963', u'ENSMUSG00000021983', u'ENSMUSG00000021879', u'ENSMUSG00000036095', u'ENSMUSG00000032571', u'ENSMUSG00000024339', u'ENSMUSG00000032577', u'ENSMUSG00000021877', u'ENSMUSG00000024759', u'ENSMUSG00000021500', u'ENSMUSG00000074305', u'ENSMUSG00000018846', u'ENSMUSG00000018841', u'ENSMUSG00000040327', u'ENSMUSG00000040325', u'ENSMUSG00000018848', u'ENSMUSG00000019087', u'ENSMUSG00000032883', u'ENSMUSG00000006281', u'ENSMUSG00000036273', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000033577', u'ENSMUSG00000005469', u'ENSMUSG00000000631', u'ENSMUSG00000020228', u'ENSMUSG00000026667', u'ENSMUSG00000026662', u'ENSMUSG00000000149', u'ENSMUSG00000001924', u'ENSMUSG00000005481', u'ENSMUSG00000001729', u'ENSMUSG00000041645', u'ENSMUSG00000030007', u'ENSMUSG00000020832', u'ENSMUSG00000001034', u'ENSMUSG00000020908', u'ENSMUSG00000041187', u'ENSMUSG00000030711', u'ENSMUSG00000024247', u'ENSMUSG00000059456', u'ENSMUSG00000018932', u'ENSMUSG00000051627', u'ENSMUSG00000048120', u'ENSMUSG00000039630', u'ENSMUSG00000030137', u'ENSMUSG00000033628', u'ENSMUSG00000055013', u'ENSMUSG00000031441', u'ENSMUSG00000040584', u'ENSMUSG00000027823', u'ENSMUSG00000031537', u'ENSMUSG00000031840', u'ENSMUSG00000022621', u'ENSMUSG00000030222', u'ENSMUSG00000021279', u'ENSMUSG00000046854', u'ENSMUSG00000021270', u'ENSMUSG00000026083', u'ENSMUSG00000031668', u'ENSMUSG00000029063', u'ENSMUSG00000029062', u'ENSMUSG00000036894', u'ENSMUSG00000026404', u'ENSMUSG00000031284', u'ENSMUSG00000039529', u'ENSMUSG00000073775', u'ENSMUSG00000029191', u'ENSMUSG00000029190', u'ENSMUSG00000031065', u'ENSMUSG00000020459', u'ENSMUSG00000074781', u'ENSMUSG00000020457', u'ENSMUSG00000029204', u'ENSMUSG00000029203', u'ENSMUSG00000022562', u'ENSMUSG00000047454', u'ENSMUSG00000003779', u'ENSMUSG00000022360', u'ENSMUSG00000007646', u'ENSMUSG00000015961', u'ENSMUSG00000024242', u'ENSMUSG00000021693', u'ENSMUSG00000029447', u'ENSMUSG00000022412', u'ENSMUSG00000029334', u'ENSMUSG00000025324', u'ENSMUSG00000029449', u'ENSMUSG00000058997', u'ENSMUSG00000042751', u'ENSMUSG00000074652', u'ENSMUSG00000036875', u'ENSMUSG00000020580', u'ENSMUSG00000023908', u'ENSMUSG00000029536', u'ENSMUSG00000020638', u'ENSMUSG00000052688', u'ENSMUSG00000028005', u'ENSMUSG00000034902', u'ENSMUSG00000025035', u'ENSMUSG00000052681', u'ENSMUSG00000026749', u'ENSMUSG00000067713', u'ENSMUSG00000028959', u'ENSMUSG00000034349', u'ENSMUSG00000028953', u'ENSMUSG00000062949', u'ENSMUSG00000042535', u'ENSMUSG00000007411', u'ENSMUSG00000033966', u'ENSMUSG00000028312', u'ENSMUSG00000014361', u'ENSMUSG00000039197', u'ENSMUSG00000069089', u'ENSMUSG00000020122', u'ENSMUSG00000060090', u'ENSMUSG00000075324', u'ENSMUSG00000000738', u'ENSMUSG00000018547', u'ENSMUSG00000019235', u'ENSMUSG00000028653', u'ENSMUSG00000036086', u'ENSMUSG00000002602', u'ENSMUSG00000020451', u'ENSMUSG00000053158', u'ENSMUSG00000032500', u'ENSMUSG00000071203', u'ENSMUSG00000024030', u'ENSMUSG00000037847', u'ENSMUSG00000037593', u'ENSMUSG00000027692', u'ENSMUSG00000074886', u'ENSMUSG00000029389', u'ENSMUSG00000027108', u'ENSMUSG00000022962', u'ENSMUSG00000037601', u'ENSMUSG00000027452', u'ENSMUSG00000020333', u'ENSMUSG00000024639', u'ENSMUSG00000020331', u'ENSMUSG00000020334', u'ENSMUSG00000026674', u'ENSMUSG00000040264', u'ENSMUSG00000040265', u'ENSMUSG00000062380', u'ENSMUSG00000037022', u'ENSMUSG00000041859', u'ENSMUSG00000024921', u'ENSMUSG00000037112', u'ENSMUSG00000024258', u'ENSMUSG00000072235', u'ENSMUSG00000005034', u'ENSMUSG00000038481', u'ENSMUSG00000030105', u'ENSMUSG00000031450', u'ENSMUSG00000055065', u'ENSMUSG00000007097', u'ENSMUSG00000020802', u'ENSMUSG00000027852', u'ENSMUSG00000005102', u'ENSMUSG00000023353', u'ENSMUSG00000040661', u'ENSMUSG00000041440', u'ENSMUSG00000026277', u'ENSMUSG00000063179', u'ENSMUSG00000041997', u'ENSMUSG00000031853', u'ENSMUSG00000027078', u'ENSMUSG00000027079', u'ENSMUSG00000026074', u'ENSMUSG00000040464', u'ENSMUSG00000039515', u'ENSMUSG00000015357', u'ENSMUSG00000040482', u'ENSMUSG00000026094', u'ENSMUSG00000062825', u'ENSMUSG00000002948', u'ENSMUSG00000029056', u'ENSMUSG00000029053', u'ENSMUSG00000040009', u'ENSMUSG00000022176', u'ENSMUSG00000031292', u'ENSMUSG00000031278', u'ENSMUSG00000091896', u'ENSMUSG00000038128', u'ENSMUSG00000022792', u'ENSMUSG00000003345', u'ENSMUSG00000074797', u'ENSMUSG00000022791', u'ENSMUSG00000074793', u'ENSMUSG00000026896', u'ENSMUSG00000047446', u'ENSMUSG00000009907', u'ENSMUSG00000034135', u'ENSMUSG00000061436', u'ENSMUSG00000056310', u'ENSMUSG00000047842', u'ENSMUSG00000025209', u'ENSMUSG00000029231', u'ENSMUSG00000022220', u'ENSMUSG00000034226', u'ENSMUSG00000028633', u'ENSMUSG00000028630', u'ENSMUSG00000021048', u'ENSMUSG00000021044', u'ENSMUSG00000089917', u'ENSMUSG00000057133', u'ENSMUSG00000039057', u'ENSMUSG00000090112', u'ENSMUSG00000039058', u'ENSMUSG00000032409', u'ENSMUSG00000038838', u'ENSMUSG00000028948', u'ENSMUSG00000028125', u'ENSMUSG00000028945', u'ENSMUSG00000028944', u'ENSMUSG00000042642', u'ENSMUSG00000020486', u'ENSMUSG00000008892', u'ENSMUSG00000033910', u'ENSMUSG00000064090', u'ENSMUSG00000024130', u'ENSMUSG00000021457', u'ENSMUSG00000052783', u'ENSMUSG00000018425', u'ENSMUSG00000053965', u'ENSMUSG00000039183', u'ENSMUSG00000035770', u'ENSMUSG00000059811', u'ENSMUSG00000032175', u'ENSMUSG00000000308', u'ENSMUSG00000020152', u'ENSMUSG00000037851', u'ENSMUSG00000020032', u'ENSMUSG00000055923', u'ENSMUSG00000020038', u'ENSMUSG00000022884', u'ENSMUSG00000022881', u'ENSMUSG00000033352', u'ENSMUSG00000022889', u'ENSMUSG00000053414', u'ENSMUSG00000001127', u'ENSMUSG00000024006', u'ENSMUSG00000033826', u'ENSMUSG00000041298', u'ENSMUSG00000028070', u'ENSMUSG00000041297', u'ENSMUSG00000024795', u'ENSMUSG00000001833', u'ENSMUSG00000032202', u'ENSMUSG00000017485', u'ENSMUSG00000037617', u'ENSMUSG00000049044', u'ENSMUSG00000027115', u'ENSMUSG00000040274', u'ENSMUSG00000033557', u'ENSMUSG00000024867', u'ENSMUSG00000055254', u'ENSMUSG00000030739', u'ENSMUSG00000054252', u'ENSMUSG00000014602', u'ENSMUSG00000027207', u'ENSMUSG00000020929', u'ENSMUSG00000038965', u'ENSMUSG00000030602', u'ENSMUSG00000037321', u'ENSMUSG00000030110', u'ENSMUSG00000007080', u'ENSMUSG00000027665', u'ENSMUSG00000040907', u'ENSMUSG00000026245', u'ENSMUSG00000040675', u'ENSMUSG00000030592', u'ENSMUSG00000040479', u'ENSMUSG00000031862', u'ENSMUSG00000055471', u'ENSMUSG00000048076', u'ENSMUSG00000059146', u'ENSMUSG00000030204', u'ENSMUSG00000051378', u'ENSMUSG00000006445', u'ENSMUSG00000021559', u'ENSMUSG00000055782', u'ENSMUSG00000026426', u'ENSMUSG00000026429', u'ENSMUSG00000029208', u'ENSMUSG00000021180', u'ENSMUSG00000022781', u'ENSMUSG00000022789', u'ENSMUSG00000031644', u'ENSMUSG00000003752', u'ENSMUSG00000026885', u'ENSMUSG00000057788', u'ENSMUSG00000009681', u'ENSMUSG00000028792', u'ENSMUSG00000022433', u'ENSMUSG00000022234', u'ENSMUSG00000020668', u'ENSMUSG00000034744', u'ENSMUSG00000034218', u'ENSMUSG00000012609', u'ENSMUSG00000061393', u'ENSMUSG00000045962', u'ENSMUSG00000028970', u'ENSMUSG00000028973', u'ENSMUSG00000021149', u'ENSMUSG00000046709', u'ENSMUSG00000046707', u'ENSMUSG00000024122', u'ENSMUSG00000014349', u'ENSMUSG00000042064', u'ENSMUSG00000007987', u'ENSMUSG00000034653', u'ENSMUSG00000032344', u'ENSMUSG00000018707', u'ENSMUSG00000042462', u'ENSMUSG00000032690', u'ENSMUSG00000032691', u'ENSMUSG00000020149', u'ENSMUSG00000035769', u'ENSMUSG00000021536', u'ENSMUSG00000022897', u'ENSMUSG00000044708', u'ENSMUSG00000024858', u'ENSMUSG00000018417', u'ENSMUSG00000053137', u'ENSMUSG00000019943', u'ENSMUSG00000019942', u'ENSMUSG00000019944', u'ENSMUSG00000032527', u'ENSMUSG00000044147', u'ENSMUSG00000024789', u'ENSMUSG00000024782', u'ENSMUSG00000058444', u'ENSMUSG00000017499', u'ENSMUSG00000015981', u'ENSMUSG00000073982', u'ENSMUSG00000053046', u'ENSMUSG00000005237', u'ENSMUSG00000024300', u'ENSMUSG00000027475', u'ENSMUSG00000053819', u'ENSMUSG00000024878', u'ENSMUSG00000024870', u'ENSMUSG00000059555', u'ENSMUSG00000001829', u'ENSMUSG00000027274', u'ENSMUSG00000067336', u'ENSMUSG00000005580', u'ENSMUSG00000059316', u'ENSMUSG00000004187', u'ENSMUSG00000030055', u'ENSMUSG00000040648', u'ENSMUSG00000040649', u'ENSMUSG00000030051', u'ENSMUSG00000031505', u'ENSMUSG00000040390', u'ENSMUSG00000030871', u'ENSMUSG00000015656', u'ENSMUSG00000030276', u'ENSMUSG00000034024', u'ENSMUSG00000030272', u'ENSMUSG00000030528', u'ENSMUSG00000073563', u'ENSMUSG00000022159', u'ENSMUSG00000031478', u'ENSMUSG00000026437', u'ENSMUSG00000040021', u'ENSMUSG00000026433', u'ENSMUSG00000030302', u'ENSMUSG00000062044', u'ENSMUSG00000015243', u'ENSMUSG00000031099', u'ENSMUSG00000031090', u'ENSMUSG00000029036', u'ENSMUSG00000021111', u'ENSMUSG00000031659', u'ENSMUSG00000015085', u'ENSMUSG00000015087', u'ENSMUSG00000025537', u'ENSMUSG00000025532', u'ENSMUSG00000028811', u'ENSMUSG00000005907', u'ENSMUSG00000003037', u'ENSMUSG00000029366', u'ENSMUSG00000022442', u'ENSMUSG00000022443', u'ENSMUSG00000034593', u'ENSMUSG00000049717', u'ENSMUSG00000029780', u'ENSMUSG00000042724', u'ENSMUSG00000034751', u'ENSMUSG00000025228', u'ENSMUSG00000034209', u'ENSMUSG00000077450', u'ENSMUSG00000002102', u'ENSMUSG00000060176', u'ENSMUSG00000029561', u'ENSMUSG00000043410', u'ENSMUSG00000024493', u'ENSMUSG00000025001', u'ENSMUSG00000032480', u'ENSMUSG00000025007', u'ENSMUSG00000025648', u'ENSMUSG00000034371', u'ENSMUSG00000014932', u'ENSMUSG00000028969', u'ENSMUSG00000020175', u'ENSMUSG00000018395', u'ENSMUSG00000018398', u'ENSMUSG00000035150', u'ENSMUSG00000017831', u'ENSMUSG00000062867', u'ENSMUSG00000042476', u'ENSMUSG00000050965', u'ENSMUSG00000032350', u'ENSMUSG00000002748', u'ENSMUSG00000024065', u'ENSMUSG00000028214', u'ENSMUSG00000034343', u'ENSMUSG00000020015', u'ENSMUSG00000024068', u'ENSMUSG00000068742', u'ENSMUSG00000068039', u'ENSMUSG00000015536', u'ENSMUSG00000052430', u'ENSMUSG00000019979', u'ENSMUSG00000019977', u'ENSMUSG00000019970', u'ENSMUSG00000017715', u'ENSMUSG00000032537', u'ENSMUSG00000021832', u'ENSMUSG00000053436', u'ENSMUSG00000020307', u'ENSMUSG00000062604', u'ENSMUSG00000058301', u'ENSMUSG00000019577', u'ENSMUSG00000021494', u'ENSMUSG00000021948', u'ENSMUSG00000033335', u'ENSMUSG00000032220', u'ENSMUSG00000029162', u'ENSMUSG00000050029', u'ENSMUSG00000027797', u'ENSMUSG00000058013', u'ENSMUSG00000033065', u'ENSMUSG00000033792', u'ENSMUSG00000024974', u'ENSMUSG00000001674', u'ENSMUSG00000000276', u'ENSMUSG00000022840', u'ENSMUSG00000020941', u'ENSMUSG00000005575', u'ENSMUSG00000004085', u'ENSMUSG00000024843', u'ENSMUSG00000050379', u'ENSMUSG00000037012', u'ENSMUSG00000027646', u'ENSMUSG00000030867', u'ENSMUSG00000041498', u'ENSMUSG00000004771', u'ENSMUSG00000027883', u'ENSMUSG00000030265', u'ENSMUSG00000004798', u'ENSMUSG00000031314', u'ENSMUSG00000071645', u'ENSMUSG00000004319', u'ENSMUSG00000004317', u'ENSMUSG00000038671', u'ENSMUSG00000031229', u'ENSMUSG00000042249', u'ENSMUSG00000051220', u'ENSMUSG00000027177', u'ENSMUSG00000029020', u'ENSMUSG00000032570', u'ENSMUSG00000026356', u'ENSMUSG00000026355', u'ENSMUSG00000029802', u'ENSMUSG00000022329', u'ENSMUSG00000068917', u'ENSMUSG00000035367', u'ENSMUSG00000020899', u'ENSMUSG00000052155', u'ENSMUSG00000020788', u'ENSMUSG00000020785', u'ENSMUSG00000022456', u'ENSMUSG00000018800', u'ENSMUSG00000025499', u'ENSMUSG00000048310', u'ENSMUSG00000034761', u'ENSMUSG00000029777', u'ENSMUSG00000059970', u'ENSMUSG00000061578', u'ENSMUSG00000053334', u'ENSMUSG00000028680', u'ENSMUSG00000029575', u'ENSMUSG00000034781', u'ENSMUSG00000028518', u'ENSMUSG00000034789', u'ENSMUSG00000023944', u'ENSMUSG00000029482', u'ENSMUSG00000038844', u'ENSMUSG00000013629', u'ENSMUSG00000028991', u'ENSMUSG00000035898', u'ENSMUSG00000035891', u'ENSMUSG00000042046', u'ENSMUSG00000028848', u'ENSMUSG00000016018', u'ENSMUSG00000035142', u'ENSMUSG00000020766', u'ENSMUSG00000050973', u'ENSMUSG00000035783', u'ENSMUSG00000002007', u'ENSMUSG00000052889', u'ENSMUSG00000024070', u'ENSMUSG00000022262', u'ENSMUSG00000024079', u'ENSMUSG00000032788', u'ENSMUSG00000018166', u'ENSMUSG00000021796', u'ENSMUSG00000021794', u'ENSMUSG00000021820', u'ENSMUSG00000039936', u'ENSMUSG00000033257', u'ENSMUSG00000021959', u'ENSMUSG00000021483', u'ENSMUSG00000032254', u'ENSMUSG00000079477', u'ENSMUSG00000032187', u'ENSMUSG00000059796', u'ENSMUSG00000038685', u'ENSMUSG00000030677', u'ENSMUSG00000001847', u'ENSMUSG00000058317', u'ENSMUSG00000024210', u'ENSMUSG00000027523', u'ENSMUSG00000019039', u'ENSMUSG00000023088', u'ENSMUSG00000020990', u'ENSMUSG00000032462', u'ENSMUSG00000037375', u'ENSMUSG00000030079', u'ENSMUSG00000041245', u'ENSMUSG00000027323', u'ENSMUSG00000026235', u'ENSMUSG00000040620', u'ENSMUSG00000004768', u'ENSMUSG00000030890', u'ENSMUSG00000031309', u'ENSMUSG00000041939', u'ENSMUSG00000031303', u'ENSMUSG00000040820', u'ENSMUSG00000000339', u'ENSMUSG00000023952', u'ENSMUSG00000011148', u'ENSMUSG00000031788', u'ENSMUSG00000014426', u'ENSMUSG00000017837', u'ENSMUSG00000030275', u'ENSMUSG00000061751', u'ENSMUSG00000017830', u'ENSMUSG00000029169', u'ENSMUSG00000056515', u'ENSMUSG00000004233', u'ENSMUSG00000003234', u'ENSMUSG00000029012', u'ENSMUSG00000026341', u'ENSMUSG00000029016', u'ENSMUSG00000024429', u'ENSMUSG00000020573', u'ENSMUSG00000022668', u'ENSMUSG00000043091', u'ENSMUSG00000034575', u'ENSMUSG00000022263', u'ENSMUSG00000006494', u'ENSMUSG00000057177', u'ENSMUSG00000020684', u'ENSMUSG00000034792', u'ENSMUSG00000029580', u'ENSMUSG00000025060', u'ENSMUSG00000022469', u'ENSMUSG00000034311', u'ENSMUSG00000025665', u'ENSMUSG00000021178', u'ENSMUSG00000038302']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000175', NS='MF', enrichment='e', name="3'-5'-exoribonuclease activity", ratio_in_study=(2, 624), ratio_in_pop=(15, 13836), p_uncorrected=0.1449197583534235, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039236', u'ENSMUSG00000027433']), pop_n=13836, pop_count=15, pop_items=set([u'ENSMUSG00000032396', u'ENSMUSG00000043702', u'ENSMUSG00000039236', u'ENSMUSG00000048039', u'ENSMUSG00000028688', u'ENSMUSG00000017264', u'ENSMUSG00000027433', u'ENSMUSG00000032026', u'ENSMUSG00000005682', u'ENSMUSG00000020464', u'ENSMUSG00000020515', u'ENSMUSG00000031792', u'ENSMUSG00000031601', u'ENSMUSG00000053333', u'ENSMUSG00000033166']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000176', NS='CC', enrichment='e', name='nuclear exosome (RNase complex)', ratio_in_study=(2, 624), ratio_in_pop=(11, 13836), p_uncorrected=0.08530221141860472, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039356', u'ENSMUSG00000027752']), pop_n=13836, pop_count=11, pop_items=set([u'ENSMUSG00000027752', u'ENSMUSG00000061286', u'ENSMUSG00000027714', u'ENSMUSG00000017264', u'ENSMUSG00000034259', u'ENSMUSG00000034321', u'ENSMUSG00000028322', u'ENSMUSG00000031843', u'ENSMUSG00000039356', u'ENSMUSG00000025785', u'ENSMUSG00000033166']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000177', NS='CC', enrichment='e', name='cytoplasmic exosome (RNase complex)', ratio_in_study=(2, 624), ratio_in_pop=(10, 13836), p_uncorrected=0.07188022378559596, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039356', u'ENSMUSG00000027752']), pop_n=13836, pop_count=10, pop_items=set([u'ENSMUSG00000032396', u'ENSMUSG00000027752', u'ENSMUSG00000061286', u'ENSMUSG00000027714', u'ENSMUSG00000034259', u'ENSMUSG00000008393', u'ENSMUSG00000028322', u'ENSMUSG00000042535', u'ENSMUSG00000039356', u'ENSMUSG00000025785']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000178', NS='CC', enrichment='e', name='exosome (RNase complex)', ratio_in_study=(2, 624), ratio_in_pop=(17, 13836), p_uncorrected=0.17720422816569675, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039356', u'ENSMUSG00000027752']), pop_n=13836, pop_count=17, pop_items=set([u'ENSMUSG00000032396', u'ENSMUSG00000027752', u'ENSMUSG00000034163', u'ENSMUSG00000016018', u'ENSMUSG00000061286', u'ENSMUSG00000027714', u'ENSMUSG00000017264', u'ENSMUSG00000053333', u'ENSMUSG00000034259', u'ENSMUSG00000000581', u'ENSMUSG00000034321', u'ENSMUSG00000028322', u'ENSMUSG00000031843', u'ENSMUSG00000039356', u'ENSMUSG00000025785', u'ENSMUSG00000033166', u'ENSMUSG00000044786']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000184', NS='BP', enrichment='p', name='nuclear-transcribed mRNA catabolic process, nonsense-mediated decay', ratio_in_study=(1, 624), ratio_in_pop=(30, 13836), p_uncorrected=1.0, depth=10, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024472']), pop_n=13836, pop_count=30, pop_items=set([u'ENSMUSG00000038374', u'ENSMUSG00000064030', u'ENSMUSG00000030655', u'ENSMUSG00000034681', u'ENSMUSG00000052928', u'ENSMUSG00000043241', u'ENSMUSG00000038290', u'ENSMUSG00000040128', u'ENSMUSG00000028675', u'ENSMUSG00000002210', u'ENSMUSG00000021962', u'ENSMUSG00000058301', u'ENSMUSG00000078676', u'ENSMUSG00000041477', u'ENSMUSG00000022774', u'ENSMUSG00000020495', u'ENSMUSG00000022283', u'ENSMUSG00000071723', u'ENSMUSG00000028330', u'ENSMUSG00000001415', u'ENSMUSG00000062203', u'ENSMUSG00000025580', u'ENSMUSG00000024360', u'ENSMUSG00000036572', u'ENSMUSG00000042772', u'ENSMUSG00000017264', u'ENSMUSG00000024472', u'ENSMUSG00000028609', u'ENSMUSG00000022336', u'ENSMUSG00000022685']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000186', NS='BP', enrichment='p', name='activation of MAPKK activity', ratio_in_study=(1, 624), ratio_in_pop=(27, 13836), p_uncorrected=1.0, depth=13, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024079']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000028062', u'ENSMUSG00000021453', u'ENSMUSG00000024079', u'ENSMUSG00000031303', u'ENSMUSG00000004085', u'ENSMUSG00000028284', u'ENSMUSG00000019828', u'ENSMUSG00000032562', u'ENSMUSG00000036273', u'ENSMUSG00000028862', u'ENSMUSG00000071369', u'ENSMUSG00000048376', u'ENSMUSG00000035773', u'ENSMUSG00000019969', u'ENSMUSG00000015312', u'ENSMUSG00000014426', u'ENSMUSG00000033618', u'ENSMUSG00000023050', u'ENSMUSG00000024789', u'ENSMUSG00000031555', u'ENSMUSG00000059981', u'ENSMUSG00000000441', u'ENSMUSG00000042429', u'ENSMUSG00000007613', u'ENSMUSG00000021835', u'ENSMUSG00000091512', u'ENSMUSG00000020122']), study_n=624, level=9, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0007255'])),
    NtGoeaResults(GO='GO:0000187', NS='BP', enrichment='p', name='activation of MAPK activity', ratio_in_study=(1, 624), ratio_in_pop=(55, 13836), p_uncorrected=0.5190423824152548, depth=13, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028068']), pop_n=13836, pop_count=55, pop_items=set([u'ENSMUSG00000020170', u'ENSMUSG00000009376', u'ENSMUSG00000021732', u'ENSMUSG00000028068', u'ENSMUSG00000030525', u'ENSMUSG00000029999', u'ENSMUSG00000021457', u'ENSMUSG00000042284', u'ENSMUSG00000005534', u'ENSMUSG00000021994', u'ENSMUSG00000031714', u'ENSMUSG00000005672', u'ENSMUSG00000055737', u'ENSMUSG00000019828', u'ENSMUSG00000029026', u'ENSMUSG00000036273', u'ENSMUSG00000029616', u'ENSMUSG00000004054', u'ENSMUSG00000028864', u'ENSMUSG00000036585', u'ENSMUSG00000018821', u'ENSMUSG00000076617', u'ENSMUSG00000032911', u'ENSMUSG00000049107', u'ENSMUSG00000041605', u'ENSMUSG00000031948', u'ENSMUSG00000004936', u'ENSMUSG00000038668', u'ENSMUSG00000018909', u'ENSMUSG00000027358', u'ENSMUSG00000042626', u'ENSMUSG00000026395', u'ENSMUSG00000020053', u'ENSMUSG00000020623', u'ENSMUSG00000029468', u'ENSMUSG00000055471', u'ENSMUSG00000021253', u'ENSMUSG00000059146', u'ENSMUSG00000029528', u'ENSMUSG00000020859', u'ENSMUSG00000071369', u'ENSMUSG00000037706', u'ENSMUSG00000058444', u'ENSMUSG00000022982', u'ENSMUSG00000043733', u'ENSMUSG00000040152', u'ENSMUSG00000040687', u'ENSMUSG00000024610', u'ENSMUSG00000005161', u'ENSMUSG00000063239', u'ENSMUSG00000020312', u'ENSMUSG00000035027', u'ENSMUSG00000018932', u'ENSMUSG00000039005', u'ENSMUSG00000024998']), study_n=624, level=9, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000209', NS='BP', enrichment='e', name='protein polyubiquitination', ratio_in_study=(8, 624), ratio_in_pop=(103, 13836), p_uncorrected=0.14338364715741767, depth=10, study_count=8, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000001403', u'ENSMUSG00000035293', u'ENSMUSG00000037474', u'ENSMUSG00000054115', u'ENSMUSG00000023307', u'ENSMUSG00000031885', u'ENSMUSG00000006418', u'ENSMUSG00000036822']), pop_n=13836, pop_count=103, pop_items=set([u'ENSMUSG00000020307', u'ENSMUSG00000027466', u'ENSMUSG00000044231', u'ENSMUSG00000039615', u'ENSMUSG00000029203', u'ENSMUSG00000023286', u'ENSMUSG00000026792', u'ENSMUSG00000029922', u'ENSMUSG00000022771', u'ENSMUSG00000037487', u'ENSMUSG00000025261', u'ENSMUSG00000040102', u'ENSMUSG00000091896', u'ENSMUSG00000021694', u'ENSMUSG00000031885', u'ENSMUSG00000059890', u'ENSMUSG00000041263', u'ENSMUSG00000057367', u'ENSMUSG00000027300', u'ENSMUSG00000030966', u'ENSMUSG00000025217', u'ENSMUSG00000032309', u'ENSMUSG00000032415', u'ENSMUSG00000026429', u'ENSMUSG00000060450', u'ENSMUSG00000025939', u'ENSMUSG00000031161', u'ENSMUSG00000009293', u'ENSMUSG00000021200', u'ENSMUSG00000023826', u'ENSMUSG00000034342', u'ENSMUSG00000078578', u'ENSMUSG00000035293', u'ENSMUSG00000004364', u'ENSMUSG00000020134', u'ENSMUSG00000023307', u'ENSMUSG00000051675', u'ENSMUSG00000019295', u'ENSMUSG00000021774', u'ENSMUSG00000016239', u'ENSMUSG00000048911', u'ENSMUSG00000028793', u'ENSMUSG00000037075', u'ENSMUSG00000031314', u'ENSMUSG00000025702', u'ENSMUSG00000025234', u'ENSMUSG00000037474', u'ENSMUSG00000019189', u'ENSMUSG00000024182', u'ENSMUSG00000020642', u'ENSMUSG00000063760', u'ENSMUSG00000028309', u'ENSMUSG00000001403', u'ENSMUSG00000064145', u'ENSMUSG00000020387', u'ENSMUSG00000047496', u'ENSMUSG00000038068', u'ENSMUSG00000038780', u'ENSMUSG00000047098', u'ENSMUSG00000054115', u'ENSMUSG00000025427', u'ENSMUSG00000019927', u'ENSMUSG00000022280', u'ENSMUSG00000021720', u'ENSMUSG00000064061', u'ENSMUSG00000002109', u'ENSMUSG00000014668', u'ENSMUSG00000022517', u'ENSMUSG00000036469', u'ENSMUSG00000038965', u'ENSMUSG00000024807', u'ENSMUSG00000055850', u'ENSMUSG00000027598', u'ENSMUSG00000032217', u'ENSMUSG00000057329', u'ENSMUSG00000024735', u'ENSMUSG00000028960', u'ENSMUSG00000040351', u'ENSMUSG00000022684', u'ENSMUSG00000075376', u'ENSMUSG00000039633', u'ENSMUSG00000025373', u'ENSMUSG00000031751', u'ENSMUSG00000060860', u'ENSMUSG00000024811', u'ENSMUSG00000006418', u'ENSMUSG00000015305', u'ENSMUSG00000040746', u'ENSMUSG00000021846', u'ENSMUSG00000024317', u'ENSMUSG00000039000', u'ENSMUSG00000036822', u'ENSMUSG00000014470', u'ENSMUSG00000048814', u'ENSMUSG00000090112', u'ENSMUSG00000020271', u'ENSMUSG00000058446', u'ENSMUSG00000022184', u'ENSMUSG00000020390', u'ENSMUSG00000031529', u'ENSMUSG00000027164', u'ENSMUSG00000039328', u'ENSMUSG00000016308']), study_n=624, level=9, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000212', NS='BP', enrichment='e', name='meiotic spindle organization', ratio_in_study=(2, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.026990741332852557, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000027496', u'ENSMUSG00000058290']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000035198', u'ENSMUSG00000041415', u'ENSMUSG00000027496', u'ENSMUSG00000031229', u'ENSMUSG00000058290', u'ENSMUSG00000022443']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0043147'])),
    NtGoeaResults(GO='GO:0000217', NS='MF', enrichment='e', name='DNA secondary structure binding', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000042489']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000042489']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000226', NS='BP', enrichment='e', name='microtubule cytoskeleton organization', ratio_in_study=(9, 624), ratio_in_pop=(81, 13836), p_uncorrected=0.010527911582993401, depth=5, study_count=9, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000074802', u'ENSMUSG00000027496', u'ENSMUSG00000027306', u'ENSMUSG00000037313', u'ENSMUSG00000019942', u'ENSMUSG00000017716', u'ENSMUSG00000025474', u'ENSMUSG00000000759', u'ENSMUSG00000038943']), pop_n=13836, pop_count=81, pop_items=set([u'ENSMUSG00000048799', u'ENSMUSG00000041117', u'ENSMUSG00000026490', u'ENSMUSG00000040327', u'ENSMUSG00000027306', u'ENSMUSG00000030137', u'ENSMUSG00000037313', u'ENSMUSG00000021738', u'ENSMUSG00000050930', u'ENSMUSG00000026696', u'ENSMUSG00000043051', u'ENSMUSG00000018567', u'ENSMUSG00000028556', u'ENSMUSG00000037415', u'ENSMUSG00000055407', u'ENSMUSG00000019996', u'ENSMUSG00000042766', u'ENSMUSG00000038545', u'ENSMUSG00000030397', u'ENSMUSG00000029053', u'ENSMUSG00000018411', u'ENSMUSG00000037013', u'ENSMUSG00000028849', u'ENSMUSG00000038943', u'ENSMUSG00000001134', u'ENSMUSG00000029121', u'ENSMUSG00000019942', u'ENSMUSG00000022055', u'ENSMUSG00000022054', u'ENSMUSG00000000127', u'ENSMUSG00000018736', u'ENSMUSG00000033392', u'ENSMUSG00000020135', u'ENSMUSG00000044433', u'ENSMUSG00000000759', u'ENSMUSG00000051786', u'ENSMUSG00000027254', u'ENSMUSG00000007411', u'ENSMUSG00000025812', u'ENSMUSG00000021022', u'ENSMUSG00000057666', u'ENSMUSG00000026933', u'ENSMUSG00000058070', u'ENSMUSG00000068876', u'ENSMUSG00000039230', u'ENSMUSG00000039233', u'ENSMUSG00000031016', u'ENSMUSG00000028078', u'ENSMUSG00000019261', u'ENSMUSG00000041020', u'ENSMUSG00000064302', u'ENSMUSG00000006464', u'ENSMUSG00000027394', u'ENSMUSG00000052727', u'ENSMUSG00000030852', u'ENSMUSG00000033149', u'ENSMUSG00000033790', u'ENSMUSG00000006782', u'ENSMUSG00000035770', u'ENSMUSG00000040936', u'ENSMUSG00000031731', u'ENSMUSG00000020396', u'ENSMUSG00000030983', u'ENSMUSG00000022607', u'ENSMUSG00000027496', u'ENSMUSG00000025235', u'ENSMUSG00000032435', u'ENSMUSG00000017716', u'ENSMUSG00000024969', u'ENSMUSG00000025474', u'ENSMUSG00000065954', u'ENSMUSG00000022961', u'ENSMUSG00000041205', u'ENSMUSG00000074802', u'ENSMUSG00000053024', u'ENSMUSG00000032078', u'ENSMUSG00000027263', u'ENSMUSG00000041570', u'ENSMUSG00000026620', u'ENSMUSG00000020745', u'ENSMUSG00000039298']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000228', NS='CC', enrichment='e', name='nuclear chromosome', ratio_in_study=(17, 624), ratio_in_pop=(39, 13836), p_uncorrected=5.052111777944728e-11, depth=6, study_count=17, p_sm_bonferroni=7.9348467584399898e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000035455', u'ENSMUSG00000067455', u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000017716', u'ENSMUSG00000020914', u'ENSMUSG00000027323', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000074403', u'ENSMUSG00000060093', u'ENSMUSG00000064288', u'ENSMUSG00000030528']), pop_n=13836, pop_count=39, pop_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000031229', u'ENSMUSG00000000902', u'ENSMUSG00000060639', u'ENSMUSG00000074403', u'ENSMUSG00000041974', u'ENSMUSG00000030528', u'ENSMUSG00000069305', u'ENSMUSG00000070544', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000060678', u'ENSMUSG00000078247', u'ENSMUSG00000020914', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000091405', u'ENSMUSG00000039630', u'ENSMUSG00000038252', u'ENSMUSG00000069306', u'ENSMUSG00000060981', u'ENSMUSG00000028312', u'ENSMUSG00000060743', u'ENSMUSG00000016559', u'ENSMUSG00000043535', u'ENSMUSG00000021958', u'ENSMUSG00000034274', u'ENSMUSG00000027714', u'ENSMUSG00000022314', u'ENSMUSG00000015937', u'ENSMUSG00000017716', u'ENSMUSG00000024474', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000035021', u'ENSMUSG00000069265', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000064288']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000235', NS='CC', enrichment='e', name='astral microtubule', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000051378']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000051378', u'ENSMUSG00000033900', u'ENSMUSG00000020745']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000242', NS='CC', enrichment='e', name='pericentriolar material', ratio_in_study=(2, 624), ratio_in_pop=(19, 13836), p_uncorrected=0.21044982133854892, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000068394', u'ENSMUSG00000024542']), pop_n=13836, pop_count=19, pop_items=set([u'ENSMUSG00000035198', u'ENSMUSG00000035919', u'ENSMUSG00000001847', u'ENSMUSG00000042050', u'ENSMUSG00000031644', u'ENSMUSG00000025235', u'ENSMUSG00000031592', u'ENSMUSG00000024542', u'ENSMUSG00000001151', u'ENSMUSG00000037443', u'ENSMUSG00000068394', u'ENSMUSG00000019988', u'ENSMUSG00000040407', u'ENSMUSG00000068039', u'ENSMUSG00000021068', u'ENSMUSG00000024811', u'ENSMUSG00000039298', u'ENSMUSG00000045007', u'ENSMUSG00000037234']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000245', NS='BP', enrichment='e', name='spliceosomal complex assembly', ratio_in_study=(1, 624), ratio_in_pop=(21, 13836), p_uncorrected=0.6208538864313186, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000055760']), pop_n=13836, pop_count=21, pop_items=set([u'ENSMUSG00000025982', u'ENSMUSG00000033228', u'ENSMUSG00000028330', u'ENSMUSG00000001767', u'ENSMUSG00000031723', u'ENSMUSG00000032580', u'ENSMUSG00000056305', u'ENSMUSG00000031370', u'ENSMUSG00000020180', u'ENSMUSG00000055760', u'ENSMUSG00000002477', u'ENSMUSG00000024735', u'ENSMUSG00000004865', u'ENSMUSG00000035125', u'ENSMUSG00000057130', u'ENSMUSG00000060121', u'ENSMUSG00000062604', u'ENSMUSG00000020211', u'ENSMUSG00000002007', u'ENSMUSG00000031848', u'ENSMUSG00000019432']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000266', NS='BP', enrichment='e', name='mitochondrial fission', ratio_in_study=(1, 624), ratio_in_pop=(18, 13836), p_uncorrected=0.5644708834863089, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000000386']), pop_n=13836, pop_count=18, pop_items=set([u'ENSMUSG00000024500', u'ENSMUSG00000019054', u'ENSMUSG00000033335', u'ENSMUSG00000046671', u'ENSMUSG00000026825', u'ENSMUSG00000041241', u'ENSMUSG00000025777', u'ENSMUSG00000040265', u'ENSMUSG00000038084', u'ENSMUSG00000020593', u'ENSMUSG00000048731', u'ENSMUSG00000026150', u'ENSMUSG00000022412', u'ENSMUSG00000027601', u'ENSMUSG00000022789', u'ENSMUSG00000042148', u'ENSMUSG00000004748', u'ENSMUSG00000000386']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000278', NS='BP', enrichment='e', name='mitotic cell cycle', ratio_in_study=(21, 624), ratio_in_pop=(79, 13836), p_uncorrected=2.4973461286259312e-11, depth=3, study_count=21, p_sm_bonferroni=3.9223318296198878e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000017499', u'ENSMUSG00000001855', u'ENSMUSG00000021374', u'ENSMUSG00000027496', u'ENSMUSG00000021965', u'ENSMUSG00000038252', u'ENSMUSG00000026683', u'ENSMUSG00000045328', u'ENSMUSG00000045273', u'ENSMUSG00000058290', u'ENSMUSG00000030867', u'ENSMUSG00000006585', u'ENSMUSG00000026779', u'ENSMUSG00000051378', u'ENSMUSG00000026605', u'ENSMUSG00000020897', u'ENSMUSG00000020492', u'ENSMUSG00000025912', u'ENSMUSG00000022033', u'ENSMUSG00000040599', u'ENSMUSG00000007080']), pop_n=13836, pop_count=79, pop_items=set([u'ENSMUSG00000047777', u'ENSMUSG00000022052', u'ENSMUSG00000029516', u'ENSMUSG00000062380', u'ENSMUSG00000027937', u'ENSMUSG00000053333', u'ENSMUSG00000045328', u'ENSMUSG00000024474', u'ENSMUSG00000025410', u'ENSMUSG00000045210', u'ENSMUSG00000030061', u'ENSMUSG00000032264', u'ENSMUSG00000030965', u'ENSMUSG00000007080', u'ENSMUSG00000024370', u'ENSMUSG00000075266', u'ENSMUSG00000014859', u'ENSMUSG00000028933', u'ENSMUSG00000025616', u'ENSMUSG00000002625', u'ENSMUSG00000032411', u'ENSMUSG00000018651', u'ENSMUSG00000000127', u'ENSMUSG00000004364', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000019907', u'ENSMUSG00000027330', u'ENSMUSG00000026779', u'ENSMUSG00000020752', u'ENSMUSG00000047126', u'ENSMUSG00000020897', u'ENSMUSG00000020492', u'ENSMUSG00000025912', u'ENSMUSG00000022033', u'ENSMUSG00000038252', u'ENSMUSG00000039230', u'ENSMUSG00000039285', u'ENSMUSG00000032376', u'ENSMUSG00000026484', u'ENSMUSG00000041769', u'ENSMUSG00000028214', u'ENSMUSG00000031016', u'ENSMUSG00000004936', u'ENSMUSG00000021701', u'ENSMUSG00000029253', u'ENSMUSG00000023932', u'ENSMUSG00000045273', u'ENSMUSG00000038241', u'ENSMUSG00000014668', u'ENSMUSG00000021374', u'ENSMUSG00000058290', u'ENSMUSG00000048930', u'ENSMUSG00000051378', u'ENSMUSG00000057110', u'ENSMUSG00000042364', u'ENSMUSG00000046010', u'ENSMUSG00000040599', u'ENSMUSG00000036672', u'ENSMUSG00000052087', u'ENSMUSG00000017499', u'ENSMUSG00000024500', u'ENSMUSG00000001855', u'ENSMUSG00000002365', u'ENSMUSG00000026683', u'ENSMUSG00000027496', u'ENSMUSG00000041408', u'ENSMUSG00000006585', u'ENSMUSG00000029913', u'ENSMUSG00000030428', u'ENSMUSG00000029120', u'ENSMUSG00000071350', u'ENSMUSG00000028495', u'ENSMUSG00000021965', u'ENSMUSG00000007656', u'ENSMUSG00000026605', u'ENSMUSG00000032733', u'ENSMUSG00000040667', u'ENSMUSG00000021918']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0007067'])),
    NtGoeaResults(GO='GO:0000281', NS='BP', enrichment='e', name='mitotic cytokinesis', ratio_in_study=(12, 624), ratio_in_pop=(40, 13836), p_uncorrected=1.1146290715377285e-07, depth=5, study_count=12, p_sm_bonferroni=0.0017506364197571564, p_fdr_bh=2.3522646704129768e-05, study_items=set([u'ENSMUSG00000030867', u'ENSMUSG00000029177', u'ENSMUSG00000027699', u'ENSMUSG00000037725', u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000027306', u'ENSMUSG00000034311', u'ENSMUSG00000002307', u'ENSMUSG00000003779', u'ENSMUSG00000026088', u'ENSMUSG00000024989']), pop_n=13836, pop_count=40, pop_items=set([u'ENSMUSG00000002058', u'ENSMUSG00000034311', u'ENSMUSG00000027937', u'ENSMUSG00000038467', u'ENSMUSG00000036777', u'ENSMUSG00000025035', u'ENSMUSG00000037725', u'ENSMUSG00000025235', u'ENSMUSG00000038545', u'ENSMUSG00000001833', u'ENSMUSG00000002307', u'ENSMUSG00000003779', u'ENSMUSG00000033949', u'ENSMUSG00000032504', u'ENSMUSG00000023015', u'ENSMUSG00000030867', u'ENSMUSG00000002233', u'ENSMUSG00000024989', u'ENSMUSG00000027699', u'ENSMUSG00000069601', u'ENSMUSG00000037855', u'ENSMUSG00000056201', u'ENSMUSG00000005871', u'ENSMUSG00000024068', u'ENSMUSG00000041809', u'ENSMUSG00000029516', u'ENSMUSG00000029177', u'ENSMUSG00000026088', u'ENSMUSG00000042364', u'ENSMUSG00000002365', u'ENSMUSG00000020900', u'ENSMUSG00000032254', u'ENSMUSG00000027306', u'ENSMUSG00000054364', u'ENSMUSG00000006906', u'ENSMUSG00000022961', u'ENSMUSG00000028832', u'ENSMUSG00000020315', u'ENSMUSG00000032733', u'ENSMUSG00000027363']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000287', NS='MF', enrichment='p', name='magnesium ion binding', ratio_in_study=(5, 624), ratio_in_pop=(156, 13836), p_uncorrected=0.5606141862751994, depth=5, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000030867', u'ENSMUSG00000005370', u'ENSMUSG00000035958', u'ENSMUSG00000024742', u'ENSMUSG00000020914']), pop_n=13836, pop_count=156, pop_items=set([u'ENSMUSG00000002010', u'ENSMUSG00000026490', u'ENSMUSG00000062604', u'ENSMUSG00000027546', u'ENSMUSG00000040482', u'ENSMUSG00000029326', u'ENSMUSG00000062949', u'ENSMUSG00000021180', u'ENSMUSG00000016526', u'ENSMUSG00000036737', u'ENSMUSG00000023809', u'ENSMUSG00000020715', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000004267', u'ENSMUSG00000032788', u'ENSMUSG00000029359', u'ENSMUSG00000071369', u'ENSMUSG00000024576', u'ENSMUSG00000037493', u'ENSMUSG00000048076', u'ENSMUSG00000056131', u'ENSMUSG00000024042', u'ENSMUSG00000003345', u'ENSMUSG00000024969', u'ENSMUSG00000003068', u'ENSMUSG00000002948', u'ENSMUSG00000025324', u'ENSMUSG00000031767', u'ENSMUSG00000032384', u'ENSMUSG00000021957', u'ENSMUSG00000024566', u'ENSMUSG00000031583', u'ENSMUSG00000026620', u'ENSMUSG00000034135', u'ENSMUSG00000045962', u'ENSMUSG00000029430', u'ENSMUSG00000013663', u'ENSMUSG00000020630', u'ENSMUSG00000021576', u'ENSMUSG00000062661', u'ENSMUSG00000018209', u'ENSMUSG00000004085', u'ENSMUSG00000073563', u'ENSMUSG00000026749', u'ENSMUSG00000021884', u'ENSMUSG00000047434', u'ENSMUSG00000061130', u'ENSMUSG00000024213', u'ENSMUSG00000028630', u'ENSMUSG00000025630', u'ENSMUSG00000031833', u'ENSMUSG00000052997', u'ENSMUSG00000057614', u'ENSMUSG00000024769', u'ENSMUSG00000045211', u'ENSMUSG00000031016', u'ENSMUSG00000059883', u'ENSMUSG00000045691', u'ENSMUSG00000028013', u'ENSMUSG00000020528', u'ENSMUSG00000005667', u'ENSMUSG00000054958', u'ENSMUSG00000021983', u'ENSMUSG00000061878', u'ENSMUSG00000030541', u'ENSMUSG00000043445', u'ENSMUSG00000011254', u'ENSMUSG00000028945', u'ENSMUSG00000029780', u'ENSMUSG00000020486', u'ENSMUSG00000005370', u'ENSMUSG00000026245', u'ENSMUSG00000027531', u'ENSMUSG00000032279', u'ENSMUSG00000060671', u'ENSMUSG00000025791', u'ENSMUSG00000026617', u'ENSMUSG00000025950', u'ENSMUSG00000026842', u'ENSMUSG00000026596', u'ENSMUSG00000031309', u'ENSMUSG00000009772', u'ENSMUSG00000029366', u'ENSMUSG00000037685', u'ENSMUSG00000032763', u'ENSMUSG00000025894', u'ENSMUSG00000017376', u'ENSMUSG00000002844', u'ENSMUSG00000060600', u'ENSMUSG00000028862', u'ENSMUSG00000020914', u'ENSMUSG00000025545', u'ENSMUSG00000051615', u'ENSMUSG00000024235', u'ENSMUSG00000024234', u'ENSMUSG00000034751', u'ENSMUSG00000005469', u'ENSMUSG00000025817', u'ENSMUSG00000024742', u'ENSMUSG00000022329', u'ENSMUSG00000057963', u'ENSMUSG00000053046', u'ENSMUSG00000015869', u'ENSMUSG00000021096', u'ENSMUSG00000025889', u'ENSMUSG00000022040', u'ENSMUSG00000017176', u'ENSMUSG00000000326', u'ENSMUSG00000001630', u'ENSMUSG00000001323', u'ENSMUSG00000027610', u'ENSMUSG00000004865', u'ENSMUSG00000041731', u'ENSMUSG00000037601', u'ENSMUSG00000024006', u'ENSMUSG00000039275', u'ENSMUSG00000032294', u'ENSMUSG00000021536', u'ENSMUSG00000053333', u'ENSMUSG00000042462', u'ENSMUSG00000024952', u'ENSMUSG00000031441', u'ENSMUSG00000028284', u'ENSMUSG00000028672', u'ENSMUSG00000079056', u'ENSMUSG00000026473', u'ENSMUSG00000031432', u'ENSMUSG00000035390', u'ENSMUSG00000034674', u'ENSMUSG00000032350', u'ENSMUSG00000005034', u'ENSMUSG00000020089', u'ENSMUSG00000024151', u'ENSMUSG00000003810', u'ENSMUSG00000049225', u'ENSMUSG00000053693', u'ENSMUSG00000028214', u'ENSMUSG00000031112', u'ENSMUSG00000032565', u'ENSMUSG00000035891', u'ENSMUSG00000009828', u'ENSMUSG00000035958', u'ENSMUSG00000028756', u'ENSMUSG00000029171', u'ENSMUSG00000029919', u'ENSMUSG00000003644', u'ENSMUSG00000029446', u'ENSMUSG00000058258', u'ENSMUSG00000025665', u'ENSMUSG00000027203', u'ENSMUSG00000037112', u'ENSMUSG00000025742', u'ENSMUSG00000039529', u'ENSMUSG00000038145', u'ENSMUSG00000039850']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000290', NS='BP', enrichment='e', name='deadenylation-dependent decapping of nuclear-transcribed mRNA', ratio_in_study=(1, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.33996234399139486, depth=10, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024472']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000023087', u'ENSMUSG00000046139', u'ENSMUSG00000024472', u'ENSMUSG00000029647', u'ENSMUSG00000021962', u'ENSMUSG00000037296', u'ENSMUSG00000031601', u'ENSMUSG00000041477', u'ENSMUSG00000032040']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000307', NS='CC', enrichment='e', name='cyclin-dependent protein kinase holoenzyme complex', ratio_in_study=(7, 624), ratio_in_pop=(19, 13836), p_uncorrected=1.1500061154251014e-05, depth=7, study_count=7, p_sm_bonferroni=0.18061996048866641, p_fdr_bh=0.0012901425749190459, study_items=set([u'ENSMUSG00000027715', u'ENSMUSG00000019942', u'ENSMUSG00000023067', u'ENSMUSG00000002068', u'ENSMUSG00000025358', u'ENSMUSG00000062248', u'ENSMUSG00000027342']), pop_n=13836, pop_count=19, pop_items=set([u'ENSMUSG00000040274', u'ENSMUSG00000021258', u'ENSMUSG00000034165', u'ENSMUSG00000026349', u'ENSMUSG00000027715', u'ENSMUSG00000027829', u'ENSMUSG00000019942', u'ENSMUSG00000023067', u'ENSMUSG00000049489', u'ENSMUSG00000021548', u'ENSMUSG00000028252', u'ENSMUSG00000029068', u'ENSMUSG00000070348', u'ENSMUSG00000025358', u'ENSMUSG00000027342', u'ENSMUSG00000006728', u'ENSMUSG00000062248', u'ENSMUSG00000002068', u'ENSMUSG00000000184']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000320', NS='BP', enrichment='e', name='re-entry into mitotic cell cycle', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000072082']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000070348', u'ENSMUSG00000022812', u'ENSMUSG00000072082', u'ENSMUSG00000022346']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000375', NS='BP', enrichment='e', name='RNA splicing, via transesterification reactions', ratio_in_study=(1, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.33996234399139486, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028809']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000033228', u'ENSMUSG00000028676', u'ENSMUSG00000032469', u'ENSMUSG00000028809', u'ENSMUSG00000003360', u'ENSMUSG00000037197', u'ENSMUSG00000005150', u'ENSMUSG00000020211', u'ENSMUSG00000020409']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0000385', 'GO:0031202'])),
    NtGoeaResults(GO='GO:0000380', NS='BP', enrichment='e', name='alternative mRNA splicing, via spliceosome', ratio_in_study=(1, 624), ratio_in_pop=(14, 13836), p_uncorrected=0.476065293901136, depth=12, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000042699']), pop_n=13836, pop_count=14, pop_items=set([u'ENSMUSG00000059208', u'ENSMUSG00000029439', u'ENSMUSG00000020409', u'ENSMUSG00000027763', u'ENSMUSG00000034544', u'ENSMUSG00000020719', u'ENSMUSG00000016921', u'ENSMUSG00000041297', u'ENSMUSG00000018379', u'ENSMUSG00000042699', u'ENSMUSG00000037197', u'ENSMUSG00000028820', u'ENSMUSG00000031157', u'ENSMUSG00000055065']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000387', NS='BP', enrichment='e', name='spliceosomal snRNP assembly', ratio_in_study=(1, 624), ratio_in_pop=(20, 13836), p_uncorrected=0.602919746446321, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000055760']), pop_n=13836, pop_count=20, pop_items=set([u'ENSMUSG00000027404', u'ENSMUSG00000037275', u'ENSMUSG00000018974', u'ENSMUSG00000060121', u'ENSMUSG00000030224', u'ENSMUSG00000027905', u'ENSMUSG00000020018', u'ENSMUSG00000039148', u'ENSMUSG00000020180', u'ENSMUSG00000024217', u'ENSMUSG00000023110', u'ENSMUSG00000040824', u'ENSMUSG00000055760', u'ENSMUSG00000002477', u'ENSMUSG00000090553', u'ENSMUSG00000060098', u'ENSMUSG00000024604', u'ENSMUSG00000040621', u'ENSMUSG00000031848', u'ENSMUSG00000025439']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000398', NS='BP', enrichment='p', name='mRNA splicing, via spliceosome', ratio_in_study=(4, 624), ratio_in_pop=(91, 13836), p_uncorrected=1.0, depth=11, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005481', u'ENSMUSG00000028809', u'ENSMUSG00000031311', u'ENSMUSG00000033732']), pop_n=13836, pop_count=91, pop_items=set([u'ENSMUSG00000048109', u'ENSMUSG00000039148', u'ENSMUSG00000031107', u'ENSMUSG00000031586', u'ENSMUSG00000021494', u'ENSMUSG00000001767', u'ENSMUSG00000061479', u'ENSMUSG00000040761', u'ENSMUSG00000084786', u'ENSMUSG00000022774', u'ENSMUSG00000028330', u'ENSMUSG00000018974', u'ENSMUSG00000034931', u'ENSMUSG00000027014', u'ENSMUSG00000022160', u'ENSMUSG00000003660', u'ENSMUSG00000078765', u'ENSMUSG00000027404', u'ENSMUSG00000090553', u'ENSMUSG00000037993', u'ENSMUSG00000066148', u'ENSMUSG00000038446', u'ENSMUSG00000001383', u'ENSMUSG00000063511', u'ENSMUSG00000004096', u'ENSMUSG00000031370', u'ENSMUSG00000024217', u'ENSMUSG00000061136', u'ENSMUSG00000040383', u'ENSMUSG00000028809', u'ENSMUSG00000022858', u'ENSMUSG00000021047', u'ENSMUSG00000035851', u'ENSMUSG00000031311', u'ENSMUSG00000024853', u'ENSMUSG00000008373', u'ENSMUSG00000023007', u'ENSMUSG00000007050', u'ENSMUSG00000029817', u'ENSMUSG00000020211', u'ENSMUSG00000021500', u'ENSMUSG00000035275', u'ENSMUSG00000059208', u'ENSMUSG00000022635', u'ENSMUSG00000018425', u'ENSMUSG00000037361', u'ENSMUSG00000067873', u'ENSMUSG00000020850', u'ENSMUSG00000032469', u'ENSMUSG00000024422', u'ENSMUSG00000005150', u'ENSMUSG00000019432', u'ENSMUSG00000029402', u'ENSMUSG00000005481', u'ENSMUSG00000029169', u'ENSMUSG00000044068', u'ENSMUSG00000004980', u'ENSMUSG00000061360', u'ENSMUSG00000024735', u'ENSMUSG00000060373', u'ENSMUSG00000002455', u'ENSMUSG00000038722', u'ENSMUSG00000044155', u'ENSMUSG00000031723', u'ENSMUSG00000028676', u'ENSMUSG00000027981', u'ENSMUSG00000078348', u'ENSMUSG00000031433', u'ENSMUSG00000031683', u'ENSMUSG00000015748', u'ENSMUSG00000031848', u'ENSMUSG00000033732', u'ENSMUSG00000002129', u'ENSMUSG00000020018', u'ENSMUSG00000057278', u'ENSMUSG00000074102', u'ENSMUSG00000021039', u'ENSMUSG00000090115', u'ENSMUSG00000008333', u'ENSMUSG00000024949', u'ENSMUSG00000030512', u'ENSMUSG00000028114', u'ENSMUSG00000030435', u'ENSMUSG00000025982', u'ENSMUSG00000028902', u'ENSMUSG00000030986', u'ENSMUSG00000027998', u'ENSMUSG00000034544', u'ENSMUSG00000010205', u'ENSMUSG00000021938', u'ENSMUSG00000063480']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0006374', 'GO:0006375'])),
    NtGoeaResults(GO='GO:0000400', NS='MF', enrichment='e', name='four-way junction DNA binding', ratio_in_study=(3, 624), ratio_in_pop=(13, 13836), p_uncorrected=0.018609045847913064, depth=6, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.52005991830484444, study_items=set([u'ENSMUSG00000030528', u'ENSMUSG00000005370', u'ENSMUSG00000027323']), pop_n=13836, pop_count=13, pop_items=set([u'ENSMUSG00000020232', u'ENSMUSG00000024151', u'ENSMUSG00000031393', u'ENSMUSG00000018841', u'ENSMUSG00000028933', u'ENSMUSG00000027323', u'ENSMUSG00000005370', u'ENSMUSG00000031583', u'ENSMUSG00000024947', u'ENSMUSG00000021264', u'ENSMUSG00000021287', u'ENSMUSG00000007646', u'ENSMUSG00000030528']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000403', NS='MF', enrichment='e', name='Y-form DNA binding', ratio_in_study=(2, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.026990741332852557, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000030528', u'ENSMUSG00000030254']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000014850', u'ENSMUSG00000030254', u'ENSMUSG00000024947', u'ENSMUSG00000031583', u'ENSMUSG00000030528', u'ENSMUSG00000024151']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000405', NS='MF', enrichment='e', name='bubble DNA binding', ratio_in_study=(2, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.011467047866411785, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000030528', u'ENSMUSG00000033762']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000030528', u'ENSMUSG00000031583', u'ENSMUSG00000026048', u'ENSMUSG00000033762']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000413', NS='BP', enrichment='e', name='protein peptidyl-prolyl isomerization', ratio_in_study=(1, 624), ratio_in_pop=(18, 13836), p_uncorrected=0.5644708834863089, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024007']), pop_n=13836, pop_count=18, pop_items=set([u'ENSMUSG00000021868', u'ENSMUSG00000020635', u'ENSMUSG00000032383', u'ENSMUSG00000032966', u'ENSMUSG00000032525', u'ENSMUSG00000021715', u'ENSMUSG00000021713', u'ENSMUSG00000071866', u'ENSMUSG00000042133', u'ENSMUSG00000024222', u'ENSMUSG00000015757', u'ENSMUSG00000003226', u'ENSMUSG00000026035', u'ENSMUSG00000028651', u'ENSMUSG00000022771', u'ENSMUSG00000024007', u'ENSMUSG00000027804', u'ENSMUSG00000030357']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000416', NS='BP', enrichment='e', name='positive regulation of histone H3-K36 methylation', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=11, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000002221']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000002221']), study_n=624, level=10, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000444', NS='CC', enrichment='e', name='MIS12/MIND type complex', ratio_in_study=(4, 624), ratio_in_pop=(4, 13836), p_uncorrected=4.099215555456427e-06, depth=5, study_count=4, p_sm_bonferroni=0.06438227951399865, p_fdr_bh=0.00053208495466114587, study_items=set([u'ENSMUSG00000062510', u'ENSMUSG00000027635', u'ENSMUSG00000028066', u'ENSMUSG00000040599']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000062510', u'ENSMUSG00000027635', u'ENSMUSG00000028066', u'ENSMUSG00000040599']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000462', NS='BP', enrichment='p', name='maturation of SSU-rRNA from tricistronic rRNA transcript (SSU-rRNA, 5.8S rRNA, LSU-rRNA)', ratio_in_study=(1, 624), ratio_in_pop=(27, 13836), p_uncorrected=1.0, depth=11, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000004356']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000030138', u'ENSMUSG00000032834', u'ENSMUSG00000060679', u'ENSMUSG00000025290', u'ENSMUSG00000040952', u'ENSMUSG00000022204', u'ENSMUSG00000024608', u'ENSMUSG00000038335', u'ENSMUSG00000004268', u'ENSMUSG00000037563', u'ENSMUSG00000022300', u'ENSMUSG00000024312', u'ENSMUSG00000047675', u'ENSMUSG00000025264', u'ENSMUSG00000023988', u'ENSMUSG00000016181', u'ENSMUSG00000054079', u'ENSMUSG00000025047', u'ENSMUSG00000063334', u'ENSMUSG00000033294', u'ENSMUSG00000023971', u'ENSMUSG00000004356', u'ENSMUSG00000050244', u'ENSMUSG00000040688', u'ENSMUSG00000030611', u'ENSMUSG00000035575', u'ENSMUSG00000070697']), study_n=624, level=9, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:1990041'])),
    NtGoeaResults(GO='GO:0000467', NS='BP', enrichment='e', name="exonucleolytic trimming to generate mature 3'-end of 5.8S rRNA from tricistronic rRNA transcript (SSU-rRNA, 5.8S rRNA, LSU-rRNA)", ratio_in_study=(2, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.018543260222111523, depth=11, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.52005991830484444, study_items=set([u'ENSMUSG00000039356', u'ENSMUSG00000027752']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000039356', u'ENSMUSG00000025785', u'ENSMUSG00000027752', u'ENSMUSG00000028322', u'ENSMUSG00000027714']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000578', NS='BP', enrichment='e', name='embryonic axis specification', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028718']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000028718', u'ENSMUSG00000030093', u'ENSMUSG00000020173', u'ENSMUSG00000045005', u'ENSMUSG00000006932']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000701', NS='MF', enrichment='e', name='purine-specific mismatch base pair DNA N-glycosylase activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000027342']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000027342']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000712', NS='BP', enrichment='e', name='resolution of meiotic recombination intermediates', ratio_in_study=(2, 624), ratio_in_pop=(11, 13836), p_uncorrected=0.08530221141860472, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000073705', u'ENSMUSG00000020914']), pop_n=13836, pop_count=11, pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000055884', u'ENSMUSG00000022545', u'ENSMUSG00000020914', u'ENSMUSG00000017485', u'ENSMUSG00000039738', u'ENSMUSG00000073705', u'ENSMUSG00000043410', u'ENSMUSG00000025144', u'ENSMUSG00000024906', u'ENSMUSG00000073436']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000722', NS='BP', enrichment='e', name='telomere maintenance via recombination', ratio_in_study=(4, 624), ratio_in_pop=(10, 13836), p_uncorrected=0.0006920361223044611, depth=9, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=0.046449227935529337, study_items=set([u'ENSMUSG00000027323', u'ENSMUSG00000020380', u'ENSMUSG00000020608', u'ENSMUSG00000041147']), pop_n=13836, pop_count=10, pop_items=set([u'ENSMUSG00000006281', u'ENSMUSG00000018841', u'ENSMUSG00000059586', u'ENSMUSG00000020380', u'ENSMUSG00000027323', u'ENSMUSG00000024943', u'ENSMUSG00000020608', u'ENSMUSG00000041147', u'ENSMUSG00000021287', u'ENSMUSG00000007646']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000723', NS='BP', enrichment='e', name='telomere maintenance', ratio_in_study=(12, 624), ratio_in_pop=(35, 13836), p_uncorrected=2.0487717169098736e-08, depth=7, study_count=12, p_sm_bonferroni=0.00032178008585786473, p_fdr_bh=5.2750833747190943e-06, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000028212', u'ENSMUSG00000028884', u'ENSMUSG00000020898', u'ENSMUSG00000020380', u'ENSMUSG00000002068', u'ENSMUSG00000036202', u'ENSMUSG00000036875', u'ENSMUSG00000034218', u'ENSMUSG00000038685', u'ENSMUSG00000033762', u'ENSMUSG00000030528']), pop_n=13836, pop_count=35, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000026496', u'ENSMUSG00000018841', u'ENSMUSG00000033762', u'ENSMUSG00000031583', u'ENSMUSG00000038685', u'ENSMUSG00000042694', u'ENSMUSG00000035960', u'ENSMUSG00000030528', u'ENSMUSG00000024811', u'ENSMUSG00000027845', u'ENSMUSG00000028884', u'ENSMUSG00000022471', u'ENSMUSG00000031921', u'ENSMUSG00000020380', u'ENSMUSG00000038000', u'ENSMUSG00000020898', u'ENSMUSG00000023249', u'ENSMUSG00000000751', u'ENSMUSG00000026648', u'ENSMUSG00000028212', u'ENSMUSG00000037855', u'ENSMUSG00000033430', u'ENSMUSG00000002068', u'ENSMUSG00000022672', u'ENSMUSG00000026187', u'ENSMUSG00000091971', u'ENSMUSG00000022545', u'ENSMUSG00000022184', u'ENSMUSG00000029676', u'ENSMUSG00000036202', u'ENSMUSG00000032410', u'ENSMUSG00000036875', u'ENSMUSG00000034218', u'ENSMUSG00000025925']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000724', NS='BP', enrichment='e', name='double-strand break repair via homologous recombination', ratio_in_study=(20, 624), ratio_in_pop=(62, 13836), p_uncorrected=1.4238967556843382e-11, depth=9, study_count=20, p_sm_bonferroni=2.2363722444778217e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000035266', u'ENSMUSG00000028224', u'ENSMUSG00000028884', u'ENSMUSG00000020608', u'ENSMUSG00000041238', u'ENSMUSG00000030346', u'ENSMUSG00000059323', u'ENSMUSG00000020380', u'ENSMUSG00000028702', u'ENSMUSG00000033762', u'ENSMUSG00000027323', u'ENSMUSG00000045751', u'ENSMUSG00000017146', u'ENSMUSG00000027353', u'ENSMUSG00000034218', u'ENSMUSG00000041147', u'ENSMUSG00000049932', u'ENSMUSG00000078773', u'ENSMUSG00000051235', u'ENSMUSG00000044702']), pop_n=13836, pop_count=62, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000035266', u'ENSMUSG00000018841', u'ENSMUSG00000059323', u'ENSMUSG00000074781', u'ENSMUSG00000033762', u'ENSMUSG00000020413', u'ENSMUSG00000068264', u'ENSMUSG00000031583', u'ENSMUSG00000025374', u'ENSMUSG00000021264', u'ENSMUSG00000033596', u'ENSMUSG00000030750', u'ENSMUSG00000032512', u'ENSMUSG00000041974', u'ENSMUSG00000049932', u'ENSMUSG00000028884', u'ENSMUSG00000041238', u'ENSMUSG00000028933', u'ENSMUSG00000020380', u'ENSMUSG00000053914', u'ENSMUSG00000066440', u'ENSMUSG00000026434', u'ENSMUSG00000026107', u'ENSMUSG00000017146', u'ENSMUSG00000027353', u'ENSMUSG00000024317', u'ENSMUSG00000032705', u'ENSMUSG00000021287', u'ENSMUSG00000000751', u'ENSMUSG00000078773', u'ENSMUSG00000026914', u'ENSMUSG00000033458', u'ENSMUSG00000030166', u'ENSMUSG00000028820', u'ENSMUSG00000058298', u'ENSMUSG00000030346', u'ENSMUSG00000039623', u'ENSMUSG00000014243', u'ENSMUSG00000034154', u'ENSMUSG00000025218', u'ENSMUSG00000041147', u'ENSMUSG00000024943', u'ENSMUSG00000051238', u'ENSMUSG00000030243', u'ENSMUSG00000031072', u'ENSMUSG00000062270', u'ENSMUSG00000045751', u'ENSMUSG00000025066', u'ENSMUSG00000051235', u'ENSMUSG00000042541', u'ENSMUSG00000039738', u'ENSMUSG00000022545', u'ENSMUSG00000007646', u'ENSMUSG00000059586', u'ENSMUSG00000028702', u'ENSMUSG00000012483', u'ENSMUSG00000027323', u'ENSMUSG00000044702', u'ENSMUSG00000020608', u'ENSMUSG00000034218', u'ENSMUSG00000044627']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0016924'])),
    NtGoeaResults(GO='GO:0000727', NS='BP', enrichment='e', name='double-strand break repair via break-induced replication', ratio_in_study=(3, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.0008527293334332374, depth=10, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.052728216184655223, study_items=set([u'ENSMUSG00000000028', u'ENSMUSG00000031821', u'ENSMUSG00000029283']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000024906', u'ENSMUSG00000000028', u'ENSMUSG00000031546', u'ENSMUSG00000029283', u'ENSMUSG00000031821']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000729', NS='BP', enrichment='e', name='DNA double-strand break processing', ratio_in_study=(2, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.026990741332852557, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000030528', u'ENSMUSG00000036875']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000036875', u'ENSMUSG00000029920', u'ENSMUSG00000022674', u'ENSMUSG00000074781', u'ENSMUSG00000032705', u'ENSMUSG00000030528']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000730', NS='BP', enrichment='e', name='DNA recombinase assembly', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027323']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000030166', u'ENSMUSG00000044627', u'ENSMUSG00000027323']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000731', NS='BP', enrichment='e', name='DNA synthesis involved in DNA repair', ratio_in_study=(3, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.002788066600034672, depth=8, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.13473653544659864, study_items=set([u'ENSMUSG00000038644', u'ENSMUSG00000023953', u'ENSMUSG00000007080']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000021400', u'ENSMUSG00000024854', u'ENSMUSG00000031583', u'ENSMUSG00000020063', u'ENSMUSG00000038644', u'ENSMUSG00000023953', u'ENSMUSG00000007080']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000732', NS='BP', enrichment='e', name='strand displacement', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000038685']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000038685']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000733', NS='BP', enrichment='e', name='DNA strand renaturation', ratio_in_study=(2, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.011467047866411785, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000033762']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000039354', u'ENSMUSG00000030243', u'ENSMUSG00000033762']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000738', NS='BP', enrichment='e', name='DNA catabolic process, exonucleolytic', ratio_in_study=(2, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.0020308737188951334, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.10596977617596998, study_items=set([u'ENSMUSG00000039236', u'ENSMUSG00000027433']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000039236', u'ENSMUSG00000027433']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000775', NS='CC', enrichment='e', name='chromosome, centromeric region', ratio_in_study=(51, 624), ratio_in_pop=(127, 13836), p_uncorrected=6.604560293994375e-11, depth=6, study_count=51, p_sm_bonferroni=1.0373122397747565e-06, p_fdr_bh=4.9395820941655067e-08, study_items=set([u'ENSMUSG00000029414', u'ENSMUSG00000031262', u'ENSMUSG00000040084', u'ENSMUSG00000028066', u'ENSMUSG00000031004', u'ENSMUSG00000036928', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000021714', u'ENSMUSG00000045328', u'ENSMUSG00000024974', u'ENSMUSG00000031756', u'ENSMUSG00000023940', u'ENSMUSG00000068101', u'ENSMUSG00000021965', u'ENSMUSG00000028678', u'ENSMUSG00000030867', u'ENSMUSG00000027331', u'ENSMUSG00000047534', u'ENSMUSG00000027379', u'ENSMUSG00000032400', u'ENSMUSG00000020897', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000062510', u'ENSMUSG00000069910', u'ENSMUSG00000074476', u'ENSMUSG00000045273', u'ENSMUSG00000006585', u'ENSMUSG00000073705', u'ENSMUSG00000026605', u'ENSMUSG00000052798', u'ENSMUSG00000025001', u'ENSMUSG00000031629', u'ENSMUSG00000040599', u'ENSMUSG00000029177', u'ENSMUSG00000037572', u'ENSMUSG00000026683', u'ENSMUSG00000028873', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000002307', u'ENSMUSG00000040034', u'ENSMUSG00000005233', u'ENSMUSG00000044783', u'ENSMUSG00000024660', u'ENSMUSG00000026622', u'ENSMUSG00000051220', u'ENSMUSG00000026039', u'ENSMUSG00000027326']), pop_n=13836, pop_count=127, pop_items=set([u'ENSMUSG00000031262', u'ENSMUSG00000040084', u'ENSMUSG00000026491', u'ENSMUSG00000021714', u'ENSMUSG00000029757', u'ENSMUSG00000006005', u'ENSMUSG00000024974', u'ENSMUSG00000009630', u'ENSMUSG00000018509', u'ENSMUSG00000052798', u'ENSMUSG00000020328', u'ENSMUSG00000031516', u'ENSMUSG00000040599', u'ENSMUSG00000024576', u'ENSMUSG00000020897', u'ENSMUSG00000075266', u'ENSMUSG00000038025', u'ENSMUSG00000062510', u'ENSMUSG00000039231', u'ENSMUSG00000022391', u'ENSMUSG00000031176', u'ENSMUSG00000045328', u'ENSMUSG00000032400', u'ENSMUSG00000039509', u'ENSMUSG00000033392', u'ENSMUSG00000039660', u'ENSMUSG00000021958', u'ENSMUSG00000005698', u'ENSMUSG00000029836', u'ENSMUSG00000022314', u'ENSMUSG00000002307', u'ENSMUSG00000018666', u'ENSMUSG00000020107', u'ENSMUSG00000026622', u'ENSMUSG00000026626', u'ENSMUSG00000031004', u'ENSMUSG00000024056', u'ENSMUSG00000031711', u'ENSMUSG00000050379', u'ENSMUSG00000022556', u'ENSMUSG00000021965', u'ENSMUSG00000030867', u'ENSMUSG00000001065', u'ENSMUSG00000047534', u'ENSMUSG00000020739', u'ENSMUSG00000035351', u'ENSMUSG00000035354', u'ENSMUSG00000030868', u'ENSMUSG00000009575', u'ENSMUSG00000066979', u'ENSMUSG00000007564', u'ENSMUSG00000029253', u'ENSMUSG00000029703', u'ENSMUSG00000028549', u'ENSMUSG00000025144', u'ENSMUSG00000031629', u'ENSMUSG00000037572', u'ENSMUSG00000026683', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000025626', u'ENSMUSG00000040034', u'ENSMUSG00000040549', u'ENSMUSG00000028863', u'ENSMUSG00000006585', u'ENSMUSG00000026605', u'ENSMUSG00000026039', u'ENSMUSG00000031954', u'ENSMUSG00000029414', u'ENSMUSG00000047710', u'ENSMUSG00000028066', u'ENSMUSG00000020349', u'ENSMUSG00000036928', u'ENSMUSG00000029554', u'ENSMUSG00000002055', u'ENSMUSG00000051220', u'ENSMUSG00000041133', u'ENSMUSG00000023919', u'ENSMUSG00000022204', u'ENSMUSG00000068267', u'ENSMUSG00000040945', u'ENSMUSG00000032264', u'ENSMUSG00000044502', u'ENSMUSG00000018736', u'ENSMUSG00000027331', u'ENSMUSG00000020652', u'ENSMUSG00000050668', u'ENSMUSG00000020492', u'ENSMUSG00000022978', u'ENSMUSG00000019923', u'ENSMUSG00000000838', u'ENSMUSG00000027379', u'ENSMUSG00000045273', u'ENSMUSG00000024660', u'ENSMUSG00000034974', u'ENSMUSG00000025001', u'ENSMUSG00000027339', u'ENSMUSG00000028873', u'ENSMUSG00000020661', u'ENSMUSG00000043909', u'ENSMUSG00000036672', u'ENSMUSG00000031529', u'ENSMUSG00000047539', u'ENSMUSG00000031756', u'ENSMUSG00000023940', u'ENSMUSG00000068101', u'ENSMUSG00000001833', u'ENSMUSG00000018412', u'ENSMUSG00000039086', u'ENSMUSG00000028447', u'ENSMUSG00000028678', u'ENSMUSG00000017843', u'ENSMUSG00000069910', u'ENSMUSG00000025862', u'ENSMUSG00000074476', u'ENSMUSG00000026646', u'ENSMUSG00000073705', u'ENSMUSG00000017421', u'ENSMUSG00000022678', u'ENSMUSG00000029177', u'ENSMUSG00000064302', u'ENSMUSG00000032435', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000005233', u'ENSMUSG00000044783', u'ENSMUSG00000079614']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0097521'])),
    NtGoeaResults(GO='GO:0000776', NS='CC', enrichment='e', name='kinetochore', ratio_in_study=(45, 624), ratio_in_pop=(117, 13836), p_uncorrected=5.803846347924567e-11, depth=5, study_count=45, p_sm_bonferroni=9.1155210740503252e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000029414', u'ENSMUSG00000031262', u'ENSMUSG00000040084', u'ENSMUSG00000028066', u'ENSMUSG00000038379', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000021714', u'ENSMUSG00000045328', u'ENSMUSG00000027115', u'ENSMUSG00000031756', u'ENSMUSG00000023940', u'ENSMUSG00000068101', u'ENSMUSG00000042557', u'ENSMUSG00000021965', u'ENSMUSG00000028678', u'ENSMUSG00000030867', u'ENSMUSG00000027331', u'ENSMUSG00000027379', u'ENSMUSG00000032400', u'ENSMUSG00000020897', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000062510', u'ENSMUSG00000069910', u'ENSMUSG00000074476', u'ENSMUSG00000045273', u'ENSMUSG00000006585', u'ENSMUSG00000073705', u'ENSMUSG00000052798', u'ENSMUSG00000031629', u'ENSMUSG00000040599', u'ENSMUSG00000020290', u'ENSMUSG00000029177', u'ENSMUSG00000026683', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000040034', u'ENSMUSG00000005233', u'ENSMUSG00000024660', u'ENSMUSG00000026622', u'ENSMUSG00000051220', u'ENSMUSG00000026039']), pop_n=13836, pop_count=117, pop_items=set([u'ENSMUSG00000031262', u'ENSMUSG00000040084', u'ENSMUSG00000026491', u'ENSMUSG00000021714', u'ENSMUSG00000029757', u'ENSMUSG00000006005', u'ENSMUSG00000030298', u'ENSMUSG00000018509', u'ENSMUSG00000022369', u'ENSMUSG00000001065', u'ENSMUSG00000031516', u'ENSMUSG00000024576', u'ENSMUSG00000020897', u'ENSMUSG00000019969', u'ENSMUSG00000075266', u'ENSMUSG00000031865', u'ENSMUSG00000038025', u'ENSMUSG00000062510', u'ENSMUSG00000022391', u'ENSMUSG00000020628', u'ENSMUSG00000045328', u'ENSMUSG00000032400', u'ENSMUSG00000039509', u'ENSMUSG00000033392', u'ENSMUSG00000039660', u'ENSMUSG00000021958', u'ENSMUSG00000020107', u'ENSMUSG00000026622', u'ENSMUSG00000020745', u'ENSMUSG00000024056', u'ENSMUSG00000050379', u'ENSMUSG00000022556', u'ENSMUSG00000021965', u'ENSMUSG00000030867', u'ENSMUSG00000019907', u'ENSMUSG00000020739', u'ENSMUSG00000035351', u'ENSMUSG00000047539', u'ENSMUSG00000030868', u'ENSMUSG00000009575', u'ENSMUSG00000066979', u'ENSMUSG00000000708', u'ENSMUSG00000029253', u'ENSMUSG00000042323', u'ENSMUSG00000029703', u'ENSMUSG00000028549', u'ENSMUSG00000025144', u'ENSMUSG00000031629', u'ENSMUSG00000020290', u'ENSMUSG00000026683', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000025626', u'ENSMUSG00000040034', u'ENSMUSG00000040549', u'ENSMUSG00000006585', u'ENSMUSG00000026039', u'ENSMUSG00000031954', u'ENSMUSG00000029414', u'ENSMUSG00000047710', u'ENSMUSG00000028066', u'ENSMUSG00000029554', u'ENSMUSG00000002055', u'ENSMUSG00000051220', u'ENSMUSG00000041133', u'ENSMUSG00000030801', u'ENSMUSG00000042557', u'ENSMUSG00000028863', u'ENSMUSG00000044502', u'ENSMUSG00000018736', u'ENSMUSG00000035770', u'ENSMUSG00000027331', u'ENSMUSG00000032264', u'ENSMUSG00000039630', u'ENSMUSG00000020652', u'ENSMUSG00000027339', u'ENSMUSG00000019923', u'ENSMUSG00000039086', u'ENSMUSG00000027379', u'ENSMUSG00000050668', u'ENSMUSG00000045273', u'ENSMUSG00000024660', u'ENSMUSG00000020492', u'ENSMUSG00000052798', u'ENSMUSG00000040599', u'ENSMUSG00000043909', u'ENSMUSG00000025410', u'ENSMUSG00000036672', u'ENSMUSG00000038379', u'ENSMUSG00000009013', u'ENSMUSG00000051329', u'ENSMUSG00000031756', u'ENSMUSG00000023940', u'ENSMUSG00000068101', u'ENSMUSG00000001833', u'ENSMUSG00000018412', u'ENSMUSG00000010609', u'ENSMUSG00000028447', u'ENSMUSG00000031176', u'ENSMUSG00000028678', u'ENSMUSG00000020328', u'ENSMUSG00000027115', u'ENSMUSG00000063550', u'ENSMUSG00000069910', u'ENSMUSG00000074476', u'ENSMUSG00000005871', u'ENSMUSG00000073705', u'ENSMUSG00000017421', u'ENSMUSG00000022678', u'ENSMUSG00000029177', u'ENSMUSG00000064302', u'ENSMUSG00000032435', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000005233', u'ENSMUSG00000024603', u'ENSMUSG00000079614']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0005699'])),
    NtGoeaResults(GO='GO:0000777', NS='CC', enrichment='e', name='condensed chromosome kinetochore', ratio_in_study=(12, 624), ratio_in_pop=(15, 13836), p_uncorrected=7.939556112148938e-11, depth=6, study_count=12, p_sm_bonferroni=1.2469866829741123e-06, p_fdr_bh=5.4216812303222265e-08, study_items=set([u'ENSMUSG00000062510', u'ENSMUSG00000040084', u'ENSMUSG00000028066', u'ENSMUSG00000044783', u'ENSMUSG00000024056', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000035024', u'ENSMUSG00000005233', u'ENSMUSG00000027379', u'ENSMUSG00000040599']), pop_n=13836, pop_count=15, pop_items=set([u'ENSMUSG00000062510', u'ENSMUSG00000040084', u'ENSMUSG00000047710', u'ENSMUSG00000026491', u'ENSMUSG00000044783', u'ENSMUSG00000024056', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000039509', u'ENSMUSG00000035024', u'ENSMUSG00000005233', u'ENSMUSG00000027379', u'ENSMUSG00000028066', u'ENSMUSG00000040599']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000778', NS='CC', enrichment='e', name='condensed nuclear chromosome kinetochore', ratio_in_study=(6, 624), ratio_in_pop=(7, 13836), p_uncorrected=5.535812391040618e-08, depth=7, study_count=6, p_sm_bonferroni=0.00086945469413683945, p_fdr_bh=1.2420781344811993e-05, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000029177', u'ENSMUSG00000024056', u'ENSMUSG00000045328', u'ENSMUSG00000047534', u'ENSMUSG00000027379']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000029177', u'ENSMUSG00000024056', u'ENSMUSG00000045328', u'ENSMUSG00000029253', u'ENSMUSG00000047534', u'ENSMUSG00000027379']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000779', NS='CC', enrichment='e', name='condensed chromosome, centromeric region', ratio_in_study=(6, 624), ratio_in_pop=(8, 13836), p_uncorrected=2.129577303502034e-07, depth=7, study_count=6, p_sm_bonferroni=0.0033447141128802949, p_fdr_bh=4.046705718723212e-05, study_items=set([u'ENSMUSG00000023940', u'ENSMUSG00000038252', u'ENSMUSG00000045328', u'ENSMUSG00000015880', u'ENSMUSG00000020897', u'ENSMUSG00000026039']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000023940', u'ENSMUSG00000029836', u'ENSMUSG00000038252', u'ENSMUSG00000045328', u'ENSMUSG00000020897', u'ENSMUSG00000056501', u'ENSMUSG00000015880', u'ENSMUSG00000026039']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000780', NS='CC', enrichment='e', name='condensed nuclear chromosome, centromeric region', ratio_in_study=(7, 624), ratio_in_pop=(13, 13836), p_uncorrected=4.967263163698786e-07, depth=8, study_count=7, p_sm_bonferroni=0.0078015835249053136, p_fdr_bh=8.5731687086871579e-05, study_items=set([u'ENSMUSG00000029177', u'ENSMUSG00000027496', u'ENSMUSG00000030867', u'ENSMUSG00000023940', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000026039']), pop_n=13836, pop_count=13, pop_items=set([u'ENSMUSG00000029177', u'ENSMUSG00000029253', u'ENSMUSG00000027496', u'ENSMUSG00000045098', u'ENSMUSG00000031229', u'ENSMUSG00000030867', u'ENSMUSG00000023940', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000039086', u'ENSMUSG00000026039', u'ENSMUSG00000068267', u'ENSMUSG00000059851']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000781', NS='CC', enrichment='e', name='chromosome, telomeric region', ratio_in_study=(15, 624), ratio_in_pop=(48, 13836), p_uncorrected=1.50471536737385e-09, depth=6, study_count=15, p_sm_bonferroni=2.3633059559973688e-05, p_fdr_bh=5.3711498999940207e-07, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000007589', u'ENSMUSG00000049932', u'ENSMUSG00000028884', u'ENSMUSG00000029521', u'ENSMUSG00000032113', u'ENSMUSG00000020380', u'ENSMUSG00000036202', u'ENSMUSG00000025358', u'ENSMUSG00000020608', u'ENSMUSG00000020898', u'ENSMUSG00000034218', u'ENSMUSG00000038685', u'ENSMUSG00000033762', u'ENSMUSG00000030528']), pop_n=13836, pop_count=48, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000027770', u'ENSMUSG00000018841', u'ENSMUSG00000031229', u'ENSMUSG00000033762', u'ENSMUSG00000039738', u'ENSMUSG00000025358', u'ENSMUSG00000031583', u'ENSMUSG00000038685', u'ENSMUSG00000042694', u'ENSMUSG00000030750', u'ENSMUSG00000024811', u'ENSMUSG00000049932', u'ENSMUSG00000030528', u'ENSMUSG00000027845', u'ENSMUSG00000031928', u'ENSMUSG00000006281', u'ENSMUSG00000028884', u'ENSMUSG00000031921', u'ENSMUSG00000032113', u'ENSMUSG00000020380', u'ENSMUSG00000028952', u'ENSMUSG00000070520', u'ENSMUSG00000038000', u'ENSMUSG00000020898', u'ENSMUSG00000090083', u'ENSMUSG00000020778', u'ENSMUSG00000024170', u'ENSMUSG00000029521', u'ENSMUSG00000059586', u'ENSMUSG00000033430', u'ENSMUSG00000024943', u'ENSMUSG00000029703', u'ENSMUSG00000038290', u'ENSMUSG00000053453', u'ENSMUSG00000043535', u'ENSMUSG00000004980', u'ENSMUSG00000021958', u'ENSMUSG00000022545', u'ENSMUSG00000007589', u'ENSMUSG00000031529', u'ENSMUSG00000029676', u'ENSMUSG00000036202', u'ENSMUSG00000021635', u'ENSMUSG00000020608', u'ENSMUSG00000043909', u'ENSMUSG00000034218', u'ENSMUSG00000025925']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000783', NS='CC', enrichment='e', name='nuclear telomere cap complex', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000007589']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000031921', u'ENSMUSG00000007589', u'ENSMUSG00000033430', u'ENSMUSG00000029676', u'ENSMUSG00000038000', u'ENSMUSG00000024174', u'ENSMUSG00000025925']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000784', NS='CC', enrichment='e', name='nuclear chromosome, telomeric region', ratio_in_study=(34, 624), ratio_in_pop=(106, 13836), p_uncorrected=3.8664856997059345e-11, depth=7, study_count=34, p_sm_bonferroni=6.0727024399581412e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000067455', u'ENSMUSG00000029730', u'ENSMUSG00000036986', u'ENSMUSG00000074403', u'ENSMUSG00000041859', u'ENSMUSG00000002870', u'ENSMUSG00000028884', u'ENSMUSG00000020380', u'ENSMUSG00000028587', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000063021', u'ENSMUSG00000020898', u'ENSMUSG00000024742', u'ENSMUSG00000038644', u'ENSMUSG00000075031', u'ENSMUSG00000041147', u'ENSMUSG00000022673', u'ENSMUSG00000019942', u'ENSMUSG00000051768', u'ENSMUSG00000027018', u'ENSMUSG00000007589', u'ENSMUSG00000027323', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000027342', u'ENSMUSG00000061482', u'ENSMUSG00000036875', u'ENSMUSG00000060093', u'ENSMUSG00000026355', u'ENSMUSG00000064288', u'ENSMUSG00000005410']), pop_n=13836, pop_count=106, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000026496', u'ENSMUSG00000039220', u'ENSMUSG00000060678', u'ENSMUSG00000042694', u'ENSMUSG00000058301', u'ENSMUSG00000027845', u'ENSMUSG00000022471', u'ENSMUSG00000020380', u'ENSMUSG00000028587', u'ENSMUSG00000020898', u'ENSMUSG00000024174', u'ENSMUSG00000024287', u'ENSMUSG00000021400', u'ENSMUSG00000056260', u'ENSMUSG00000041147', u'ENSMUSG00000021958', u'ENSMUSG00000024151', u'ENSMUSG00000029836', u'ENSMUSG00000027018', u'ENSMUSG00000018666', u'ENSMUSG00000053453', u'ENSMUSG00000036875', u'ENSMUSG00000025925', u'ENSMUSG00000063021', u'ENSMUSG00000005410', u'ENSMUSG00000024054', u'ENSMUSG00000020257', u'ENSMUSG00000036986', u'ENSMUSG00000074403', u'ENSMUSG00000002870', u'ENSMUSG00000028884', u'ENSMUSG00000040385', u'ENSMUSG00000069305', u'ENSMUSG00000069306', u'ENSMUSG00000060981', u'ENSMUSG00000009575', u'ENSMUSG00000021615', u'ENSMUSG00000060743', u'ENSMUSG00000029250', u'ENSMUSG00000051768', u'ENSMUSG00000022545', u'ENSMUSG00000068882', u'ENSMUSG00000037475', u'ENSMUSG00000015937', u'ENSMUSG00000022673', u'ENSMUSG00000027323', u'ENSMUSG00000021972', u'ENSMUSG00000042524', u'ENSMUSG00000026037', u'ENSMUSG00000060093', u'ENSMUSG00000018841', u'ENSMUSG00000031229', u'ENSMUSG00000060639', u'ENSMUSG00000040044', u'ENSMUSG00000026355', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000091405', u'ENSMUSG00000024742', u'ENSMUSG00000024740', u'ENSMUSG00000075031', u'ENSMUSG00000029730', u'ENSMUSG00000026187', u'ENSMUSG00000027185', u'ENSMUSG00000034274', u'ENSMUSG00000029012', u'ENSMUSG00000007589', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000027342', u'ENSMUSG00000061482', u'ENSMUSG00000043909', u'ENSMUSG00000067455', u'ENSMUSG00000025872', u'ENSMUSG00000039738', u'ENSMUSG00000025374', u'ENSMUSG00000016831', u'ENSMUSG00000025077', u'ENSMUSG00000041859', u'ENSMUSG00000031928', u'ENSMUSG00000003549', u'ENSMUSG00000031921', u'ENSMUSG00000019942', u'ENSMUSG00000014956', u'ENSMUSG00000038000', u'ENSMUSG00000036940', u'ENSMUSG00000026107', u'ENSMUSG00000020086', u'ENSMUSG00000020778', u'ENSMUSG00000000751', u'ENSMUSG00000038644', u'ENSMUSG00000026648', u'ENSMUSG00000026761', u'ENSMUSG00000033430', u'ENSMUSG00000016559', u'ENSMUSG00000022672', u'ENSMUSG00000024947', u'ENSMUSG00000041319', u'ENSMUSG00000029345', u'ENSMUSG00000001056', u'ENSMUSG00000031529', u'ENSMUSG00000029676', u'ENSMUSG00000026361', u'ENSMUSG00000064288']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000785', NS='CC', enrichment='e', name='chromatin', ratio_in_study=(19, 624), ratio_in_pop=(113, 13836), p_uncorrected=6.480530949743701e-07, depth=5, study_count=19, p_sm_bonferroni=0.010178321909667458, p_fdr_bh=0.00010493115370791193, study_items=set([u'ENSMUSG00000030867', u'ENSMUSG00000022034', u'ENSMUSG00000028884', u'ENSMUSG00000042557', u'ENSMUSG00000035365', u'ENSMUSG00000036097', u'ENSMUSG00000032113', u'ENSMUSG00000030677', u'ENSMUSG00000024974', u'ENSMUSG00000005470', u'ENSMUSG00000019961', u'ENSMUSG00000069273', u'ENSMUSG00000005566', u'ENSMUSG00000059552', u'ENSMUSG00000030254', u'ENSMUSG00000024691', u'ENSMUSG00000049932', u'ENSMUSG00000002870', u'ENSMUSG00000027323']), pop_n=13836, pop_count=113, pop_items=set([u'ENSMUSG00000026491', u'ENSMUSG00000039220', u'ENSMUSG00000023927', u'ENSMUSG00000024974', u'ENSMUSG00000059552', u'ENSMUSG00000058301', u'ENSMUSG00000029202', u'ENSMUSG00000022369', u'ENSMUSG00000018160', u'ENSMUSG00000040007', u'ENSMUSG00000053111', u'ENSMUSG00000019961', u'ENSMUSG00000006678', u'ENSMUSG00000028820', u'ENSMUSG00000019777', u'ENSMUSG00000025917', u'ENSMUSG00000039741', u'ENSMUSG00000024968', u'ENSMUSG00000005566', u'ENSMUSG00000022096', u'ENSMUSG00000005045', u'ENSMUSG00000029836', u'ENSMUSG00000022314', u'ENSMUSG00000018666', u'ENSMUSG00000024561', u'ENSMUSG00000029430', u'ENSMUSG00000024293', u'ENSMUSG00000034021', u'ENSMUSG00000024691', u'ENSMUSG00000015839', u'ENSMUSG00000028411', u'ENSMUSG00000049932', u'ENSMUSG00000002870', u'ENSMUSG00000024513', u'ENSMUSG00000028884', u'ENSMUSG00000068329', u'ENSMUSG00000030867', u'ENSMUSG00000044857', u'ENSMUSG00000026434', u'ENSMUSG00000028800', u'ENSMUSG00000018909', u'ENSMUSG00000039477', u'ENSMUSG00000021461', u'ENSMUSG00000055024', u'ENSMUSG00000055204', u'ENSMUSG00000036097', u'ENSMUSG00000041408', u'ENSMUSG00000034190', u'ENSMUSG00000027323', u'ENSMUSG00000022141', u'ENSMUSG00000026037', u'ENSMUSG00000020644', u'ENSMUSG00000024454', u'ENSMUSG00000005470', u'ENSMUSG00000037876', u'ENSMUSG00000033916', u'ENSMUSG00000025958', u'ENSMUSG00000003032', u'ENSMUSG00000030254', u'ENSMUSG00000029249', u'ENSMUSG00000022528', u'ENSMUSG00000025151', u'ENSMUSG00000029026', u'ENSMUSG00000042557', u'ENSMUSG00000040820', u'ENSMUSG00000069273', u'ENSMUSG00000022978', u'ENSMUSG00000022034', u'ENSMUSG00000030322', u'ENSMUSG00000049323', u'ENSMUSG00000046707', u'ENSMUSG00000074698', u'ENSMUSG00000023977', u'ENSMUSG00000020063', u'ENSMUSG00000004980', u'ENSMUSG00000040681', u'ENSMUSG00000066456', u'ENSMUSG00000037286', u'ENSMUSG00000035576', u'ENSMUSG00000028964', u'ENSMUSG00000021911', u'ENSMUSG00000006728', u'ENSMUSG00000035478', u'ENSMUSG00000026509', u'ENSMUSG00000015937', u'ENSMUSG00000029478', u'ENSMUSG00000028680', u'ENSMUSG00000016831', u'ENSMUSG00000035365', u'ENSMUSG00000002625', u'ENSMUSG00000032113', u'ENSMUSG00000031729', u'ENSMUSG00000030677', u'ENSMUSG00000058594', u'ENSMUSG00000020086', u'ENSMUSG00000020257', u'ENSMUSG00000025862', u'ENSMUSG00000024387', u'ENSMUSG00000021701', u'ENSMUSG00000021039', u'ENSMUSG00000026646', u'ENSMUSG00000038773', u'ENSMUSG00000033006', u'ENSMUSG00000024947', u'ENSMUSG00000031666', u'ENSMUSG00000028756', u'ENSMUSG00000000184', u'ENSMUSG00000025982', u'ENSMUSG00000020390', u'ENSMUSG00000043099', u'ENSMUSG00000053470', u'ENSMUSG00000031858', u'ENSMUSG00000016308']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0005717'])),
    NtGoeaResults(GO='GO:0000786', NS='CC', enrichment='e', name='nucleosome', ratio_in_study=(24, 624), ratio_in_pop=(48, 13836), p_uncorrected=1.2238926041936902e-11, depth=5, study_count=24, p_sm_bonferroni=1.9222457241466098e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000058773', u'ENSMUSG00000074403', u'ENSMUSG00000062727', u'ENSMUSG00000049932', u'ENSMUSG00000061991', u'ENSMUSG00000049539', u'ENSMUSG00000069308', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000069302', u'ENSMUSG00000075031', u'ENSMUSG00000068855', u'ENSMUSG00000064288', u'ENSMUSG00000029177', u'ENSMUSG00000052565', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000063021', u'ENSMUSG00000056895', u'ENSMUSG00000069310']), pop_n=13836, pop_count=48, pop_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000060678', u'ENSMUSG00000058773', u'ENSMUSG00000074403', u'ENSMUSG00000062727', u'ENSMUSG00000049932', u'ENSMUSG00000069267', u'ENSMUSG00000049539', u'ENSMUSG00000021597', u'ENSMUSG00000069308', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000091405', u'ENSMUSG00000020086', u'ENSMUSG00000069302', u'ENSMUSG00000060639', u'ENSMUSG00000069306', u'ENSMUSG00000069310', u'ENSMUSG00000075031', u'ENSMUSG00000068854', u'ENSMUSG00000060981', u'ENSMUSG00000068855', u'ENSMUSG00000060032', u'ENSMUSG00000060743', u'ENSMUSG00000016559', u'ENSMUSG00000078851', u'ENSMUSG00000022536', u'ENSMUSG00000028759', u'ENSMUSG00000063689', u'ENSMUSG00000069305', u'ENSMUSG00000064288', u'ENSMUSG00000036181', u'ENSMUSG00000031540', u'ENSMUSG00000029177', u'ENSMUSG00000015937', u'ENSMUSG00000090112', u'ENSMUSG00000052565', u'ENSMUSG00000061991', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000037894', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000063021', u'ENSMUSG00000056895', u'ENSMUSG00000041126', u'ENSMUSG00000021767', u'ENSMUSG00000051627']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0005718'])),
    NtGoeaResults(GO='GO:0000788', NS='CC', enrichment='e', name='nuclear nucleosome', ratio_in_study=(11, 624), ratio_in_pop=(23, 13836), p_uncorrected=1.1862758193236716e-09, depth=6, study_count=11, p_sm_bonferroni=1.8631648018297586e-05, p_fdr_bh=4.3329413996040901e-07, study_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000029177', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000074403', u'ENSMUSG00000060093', u'ENSMUSG00000064288']), pop_n=13836, pop_count=23, pop_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000060678', u'ENSMUSG00000060639', u'ENSMUSG00000074403', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000091405', u'ENSMUSG00000069306', u'ENSMUSG00000020167', u'ENSMUSG00000060981', u'ENSMUSG00000079184', u'ENSMUSG00000060743', u'ENSMUSG00000016559', u'ENSMUSG00000078851', u'ENSMUSG00000064288', u'ENSMUSG00000029177', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000036672', u'ENSMUSG00000051627']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000790', NS='CC', enrichment='e', name='nuclear chromatin', ratio_in_study=(37, 624), ratio_in_pop=(178, 13836), p_uncorrected=7.755711660948326e-11, depth=6, study_count=37, p_sm_bonferroni=1.2181120734685442e-06, p_fdr_bh=5.4216812303222265e-08, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000002835', u'ENSMUSG00000035842', u'ENSMUSG00000049932', u'ENSMUSG00000052684', u'ENSMUSG00000032397', u'ENSMUSG00000071516', u'ENSMUSG00000039994', u'ENSMUSG00000020380', u'ENSMUSG00000069272', u'ENSMUSG00000001228', u'ENSMUSG00000026104', u'ENSMUSG00000069301', u'ENSMUSG00000069302', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000051768', u'ENSMUSG00000030346', u'ENSMUSG00000068855', u'ENSMUSG00000028693', u'ENSMUSG00000036202', u'ENSMUSG00000029580', u'ENSMUSG00000008976', u'ENSMUSG00000028896', u'ENSMUSG00000071646', u'ENSMUSG00000027018', u'ENSMUSG00000027490', u'ENSMUSG00000052565', u'ENSMUSG00000061991', u'ENSMUSG00000020889', u'ENSMUSG00000005370', u'ENSMUSG00000000037', u'ENSMUSG00000005470', u'ENSMUSG00000063021', u'ENSMUSG00000061615', u'ENSMUSG00000022945', u'ENSMUSG00000027323']), pop_n=13836, pop_count=178, pop_items=set([u'ENSMUSG00000039220', u'ENSMUSG00000000902', u'ENSMUSG00000027544', u'ENSMUSG00000001288', u'ENSMUSG00000069270', u'ENSMUSG00000021264', u'ENSMUSG00000059552', u'ENSMUSG00000001280', u'ENSMUSG00000028104', u'ENSMUSG00000018501', u'ENSMUSG00000002250', u'ENSMUSG00000071516', u'ENSMUSG00000032228', u'ENSMUSG00000039117', u'ENSMUSG00000052837', u'ENSMUSG00000020380', u'ENSMUSG00000063870', u'ENSMUSG00000020063', u'ENSMUSG00000000776', u'ENSMUSG00000029687', u'ENSMUSG00000060032', u'ENSMUSG00000024045', u'ENSMUSG00000008855', u'ENSMUSG00000022521', u'ENSMUSG00000056770', u'ENSMUSG00000027018', u'ENSMUSG00000027490', u'ENSMUSG00000037894', u'ENSMUSG00000024563', u'ENSMUSG00000019768', u'ENSMUSG00000024561', u'ENSMUSG00000019857', u'ENSMUSG00000048170', u'ENSMUSG00000041773', u'ENSMUSG00000002147', u'ENSMUSG00000056501', u'ENSMUSG00000020167', u'ENSMUSG00000038331', u'ENSMUSG00000071076', u'ENSMUSG00000031393', u'ENSMUSG00000037992', u'ENSMUSG00000073616', u'ENSMUSG00000032481', u'ENSMUSG00000035842', u'ENSMUSG00000028411', u'ENSMUSG00000049932', u'ENSMUSG00000046532', u'ENSMUSG00000029507', u'ENSMUSG00000032397', u'ENSMUSG00000024513', u'ENSMUSG00000034341', u'ENSMUSG00000014859', u'ENSMUSG00000000552', u'ENSMUSG00000024515', u'ENSMUSG00000035834', u'ENSMUSG00000025049', u'ENSMUSG00000033016', u'ENSMUSG00000021779', u'ENSMUSG00000026434', u'ENSMUSG00000032402', u'ENSMUSG00000028800', u'ENSMUSG00000069301', u'ENSMUSG00000069302', u'ENSMUSG00000051177', u'ENSMUSG00000026932', u'ENSMUSG00000030557', u'ENSMUSG00000054611', u'ENSMUSG00000019777', u'ENSMUSG00000057236', u'ENSMUSG00000000708', u'ENSMUSG00000031099', u'ENSMUSG00000024826', u'ENSMUSG00000063689', u'ENSMUSG00000028397', u'ENSMUSG00000063021', u'ENSMUSG00000031314', u'ENSMUSG00000078619', u'ENSMUSG00000008976', u'ENSMUSG00000028896', u'ENSMUSG00000071646', u'ENSMUSG00000028949', u'ENSMUSG00000022702', u'ENSMUSG00000027323', u'ENSMUSG00000040481', u'ENSMUSG00000021635', u'ENSMUSG00000005370', u'ENSMUSG00000020647', u'ENSMUSG00000005470', u'ENSMUSG00000039910', u'ENSMUSG00000038679', u'ENSMUSG00000041126', u'ENSMUSG00000002111', u'ENSMUSG00000025958', u'ENSMUSG00000003032', u'ENSMUSG00000063576', u'ENSMUSG00000032187', u'ENSMUSG00000034848', u'ENSMUSG00000073436', u'ENSMUSG00000018537', u'ENSMUSG00000025223', u'ENSMUSG00000020918', u'ENSMUSG00000007880', u'ENSMUSG00000039994', u'ENSMUSG00000032376', u'ENSMUSG00000024985', u'ENSMUSG00000037935', u'ENSMUSG00000069272', u'ENSMUSG00000028974', u'ENSMUSG00000001156', u'ENSMUSG00000029027', u'ENSMUSG00000015605', u'ENSMUSG00000051768', u'ENSMUSG00000068855', u'ENSMUSG00000052684', u'ENSMUSG00000002108', u'ENSMUSG00000015697', u'ENSMUSG00000042308', u'ENSMUSG00000002319', u'ENSMUSG00000025369', u'ENSMUSG00000037486', u'ENSMUSG00000053411', u'ENSMUSG00000042390', u'ENSMUSG00000003233', u'ENSMUSG00000061991', u'ENSMUSG00000060373', u'ENSMUSG00000000037', u'ENSMUSG00000035478', u'ENSMUSG00000061615', u'ENSMUSG00000004040', u'ENSMUSG00000024002', u'ENSMUSG00000015937', u'ENSMUSG00000029478', u'ENSMUSG00000039738', u'ENSMUSG00000002835', u'ENSMUSG00000052565', u'ENSMUSG00000059436', u'ENSMUSG00000024927', u'ENSMUSG00000024926', u'ENSMUSG00000033712', u'ENSMUSG00000024921', u'ENSMUSG00000022346', u'ENSMUSG00000013787', u'ENSMUSG00000040929', u'ENSMUSG00000000127', u'ENSMUSG00000036940', u'ENSMUSG00000020086', u'ENSMUSG00000026104', u'ENSMUSG00000003382', u'ENSMUSG00000038902', u'ENSMUSG00000014767', u'ENSMUSG00000021546', u'ENSMUSG00000035873', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000031928', u'ENSMUSG00000030346', u'ENSMUSG00000026641', u'ENSMUSG00000039153', u'ENSMUSG00000028693', u'ENSMUSG00000053477', u'ENSMUSG00000015846', u'ENSMUSG00000078851', u'ENSMUSG00000026872', u'ENSMUSG00000024947', u'ENSMUSG00000048490', u'ENSMUSG00000055148', u'ENSMUSG00000029580', u'ENSMUSG00000001228', u'ENSMUSG00000027168', u'ENSMUSG00000027671', u'ENSMUSG00000020390', u'ENSMUSG00000027678', u'ENSMUSG00000023055', u'ENSMUSG00000036202', u'ENSMUSG00000020889', u'ENSMUSG00000016308', u'ENSMUSG00000025578', u'ENSMUSG00000022945']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000791', NS='CC', enrichment='e', name='euchromatin', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000001228']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000001228', u'ENSMUSG00000026484', u'ENSMUSG00000022556', u'ENSMUSG00000034160', u'ENSMUSG00000058392', u'ENSMUSG00000025577', u'ENSMUSG00000020661']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000792', NS='CC', enrichment='e', name='heterochromatin', ratio_in_study=(4, 624), ratio_in_pop=(33, 13836), p_uncorrected=0.05960012062393379, depth=6, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=0.98951320773731943, study_items=set([u'ENSMUSG00000036986', u'ENSMUSG00000001228', u'ENSMUSG00000004099', u'ENSMUSG00000002307']), pop_n=13836, pop_count=33, pop_items=set([u'ENSMUSG00000026739', u'ENSMUSG00000031229', u'ENSMUSG00000036986', u'ENSMUSG00000089715', u'ENSMUSG00000032187', u'ENSMUSG00000024513', u'ENSMUSG00000022556', u'ENSMUSG00000026021', u'ENSMUSG00000017485', u'ENSMUSG00000029920', u'ENSMUSG00000028800', u'ENSMUSG00000025577', u'ENSMUSG00000031393', u'ENSMUSG00000026484', u'ENSMUSG00000039231', u'ENSMUSG00000009575', u'ENSMUSG00000058392', u'ENSMUSG00000001924', u'ENSMUSG00000032097', u'ENSMUSG00000004099', u'ENSMUSG00000028796', u'ENSMUSG00000019777', u'ENSMUSG00000068039', u'ENSMUSG00000031665', u'ENSMUSG00000001228', u'ENSMUSG00000005045', u'ENSMUSG00000053411', u'ENSMUSG00000002307', u'ENSMUSG00000026037', u'ENSMUSG00000020661', u'ENSMUSG00000024561', u'ENSMUSG00000035478', u'ENSMUSG00000025578']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000793', NS='CC', enrichment='e', name='condensed chromosome', ratio_in_study=(13, 624), ratio_in_pop=(30, 13836), p_uncorrected=1.6647298040870506e-10, depth=6, study_count=13, p_sm_bonferroni=2.6146246302991218e-06, p_fdr_bh=8.7154154343304058e-08, study_items=set([u'ENSMUSG00000054717', u'ENSMUSG00000031004', u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000034023', u'ENSMUSG00000020914', u'ENSMUSG00000036202', u'ENSMUSG00000025358', u'ENSMUSG00000035024', u'ENSMUSG00000017146', u'ENSMUSG00000002748', u'ENSMUSG00000015880', u'ENSMUSG00000027323']), pop_n=13836, pop_count=30, pop_items=set([u'ENSMUSG00000047710', u'ENSMUSG00000031004', u'ENSMUSG00000020430', u'ENSMUSG00000038252', u'ENSMUSG00000021245', u'ENSMUSG00000005493', u'ENSMUSG00000025358', u'ENSMUSG00000031715', u'ENSMUSG00000024844', u'ENSMUSG00000049717', u'ENSMUSG00000020914', u'ENSMUSG00000022779', u'ENSMUSG00000017146', u'ENSMUSG00000002748', u'ENSMUSG00000015880', u'ENSMUSG00000000751', u'ENSMUSG00000032498', u'ENSMUSG00000054717', u'ENSMUSG00000028312', u'ENSMUSG00000034023', u'ENSMUSG00000024045', u'ENSMUSG00000021255', u'ENSMUSG00000036202', u'ENSMUSG00000008690', u'ENSMUSG00000005698', u'ENSMUSG00000032126', u'ENSMUSG00000015937', u'ENSMUSG00000027323', u'ENSMUSG00000035576', u'ENSMUSG00000035024']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000794', NS='CC', enrichment='e', name='condensed nuclear chromosome', ratio_in_study=(9, 624), ratio_in_pop=(30, 13836), p_uncorrected=4.445370408084244e-06, depth=7, study_count=9, p_sm_bonferroni=0.069818987629371138, p_fdr_bh=0.0005585519010349692, study_items=set([u'ENSMUSG00000028896', u'ENSMUSG00000032555', u'ENSMUSG00000036928', u'ENSMUSG00000032113', u'ENSMUSG00000020380', u'ENSMUSG00000027323', u'ENSMUSG00000017146', u'ENSMUSG00000026622', u'ENSMUSG00000049932']), pop_n=13836, pop_count=30, pop_items=set([u'ENSMUSG00000035198', u'ENSMUSG00000036928', u'ENSMUSG00000021245', u'ENSMUSG00000028430', u'ENSMUSG00000020697', u'ENSMUSG00000049932', u'ENSMUSG00000031928', u'ENSMUSG00000032113', u'ENSMUSG00000020380', u'ENSMUSG00000028842', u'ENSMUSG00000017146', u'ENSMUSG00000026377', u'ENSMUSG00000024033', u'ENSMUSG00000000751', u'ENSMUSG00000032498', u'ENSMUSG00000020232', u'ENSMUSG00000026585', u'ENSMUSG00000024120', u'ENSMUSG00000025026', u'ENSMUSG00000028896', u'ENSMUSG00000032555', u'ENSMUSG00000061024', u'ENSMUSG00000005493', u'ENSMUSG00000022314', u'ENSMUSG00000027323', u'ENSMUSG00000042524', u'ENSMUSG00000051747', u'ENSMUSG00000026622', u'ENSMUSG00000000743', u'ENSMUSG00000024002']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000795', NS='CC', enrichment='e', name='synaptonemal complex', ratio_in_study=(5, 624), ratio_in_pop=(14, 13836), p_uncorrected=0.0002616703282067204, depth=7, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=0.020245291501550498, study_items=set([u'ENSMUSG00000036928', u'ENSMUSG00000024660', u'ENSMUSG00000030867', u'ENSMUSG00000003824', u'ENSMUSG00000027323']), pop_n=13836, pop_count=14, pop_items=set([u'ENSMUSG00000031536', u'ENSMUSG00000032498', u'ENSMUSG00000059970', u'ENSMUSG00000036928', u'ENSMUSG00000041408', u'ENSMUSG00000021245', u'ENSMUSG00000006931', u'ENSMUSG00000027323', u'ENSMUSG00000030867', u'ENSMUSG00000005493', u'ENSMUSG00000020697', u'ENSMUSG00000037217', u'ENSMUSG00000024660', u'ENSMUSG00000003824']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0005716'])),
    NtGoeaResults(GO='GO:0000796', NS='CC', enrichment='e', name='condensin complex', ratio_in_study=(7, 624), ratio_in_pop=(8, 13836), p_uncorrected=2.824921766049989e-09, depth=5, study_count=7, p_sm_bonferroni=4.4368221257581124e-05, p_fdr_bh=9.2433794286627349e-07, study_items=set([u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000042029', u'ENSMUSG00000015880']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000008690', u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000042029', u'ENSMUSG00000015880']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0005676', 'GO:0008620'])),
    NtGoeaResults(GO='GO:0000799', NS='CC', enrichment='e', name='nuclear condensin complex', ratio_in_study=(3, 624), ratio_in_pop=(3, 13836), p_uncorrected=9.131151172475021e-05, depth=6, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.0079674366841607051, study_items=set([u'ENSMUSG00000038252', u'ENSMUSG00000035024', u'ENSMUSG00000034906']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000038252']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000800', NS='CC', enrichment='e', name='lateral element', ratio_in_study=(7, 624), ratio_in_pop=(9, 13836), p_uncorrected=1.2216162415705889e-08, depth=6, study_count=7, p_sm_bonferroni=0.00019186704690107669, p_fdr_bh=3.3660885421241526e-06, study_items=set([u'ENSMUSG00000036928', u'ENSMUSG00000041147', u'ENSMUSG00000024974', u'ENSMUSG00000017146', u'ENSMUSG00000024660', u'ENSMUSG00000030528', u'ENSMUSG00000027323']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000036928', u'ENSMUSG00000073125', u'ENSMUSG00000027323', u'ENSMUSG00000024974', u'ENSMUSG00000017146', u'ENSMUSG00000041147', u'ENSMUSG00000024660', u'ENSMUSG00000030528', u'ENSMUSG00000000751']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000801', NS='CC', enrichment='e', name='central element', ratio_in_study=(2, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.005909998133444449, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.22584533013109129, study_items=set([u'ENSMUSG00000024660', u'ENSMUSG00000003824']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000021098', u'ENSMUSG00000024660', u'ENSMUSG00000003824']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000802', NS='CC', enrichment='e', name='transverse filament', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000036928']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000036928']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000803', NS='CC', enrichment='e', name='sex chromosome', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020608']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000024943', u'ENSMUSG00000020608']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000805', NS='CC', enrichment='e', name='X chromosome', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025358']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000031622', u'ENSMUSG00000024805', u'ENSMUSG00000025358', u'ENSMUSG00000086503', u'ENSMUSG00000033623']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000806', NS='CC', enrichment='e', name='Y chromosome', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025358']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000031622', u'ENSMUSG00000025358']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000808', NS='CC', enrichment='e', name='origin recognition complex', ratio_in_study=(2, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.026990741332852557, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000028587', u'ENSMUSG00000031697']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000026761', u'ENSMUSG00000040044', u'ENSMUSG00000029012', u'ENSMUSG00000028587', u'ENSMUSG00000031697', u'ENSMUSG00000026037']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000811', NS='CC', enrichment='e', name='GINS complex', ratio_in_study=(2, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.005909998133444449, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.22584533013109129, study_items=set([u'ENSMUSG00000031821', u'ENSMUSG00000027454']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000031546', u'ENSMUSG00000027454', u'ENSMUSG00000031821']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000818', NS='CC', enrichment='e', name='nuclear MIS12/MIND complex', ratio_in_study=(2, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.0020308737188951334, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.10596977617596998, study_items=set([u'ENSMUSG00000027635', u'ENSMUSG00000040599']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000027635', u'ENSMUSG00000040599']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000819', NS='BP', enrichment='e', name='sister chromatid segregation', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020914']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000040021', u'ENSMUSG00000020914', u'ENSMUSG00000017485']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000900', NS='MF', enrichment='e', name='translation repressor activity, nucleic acid binding', ratio_in_study=(3, 624), ratio_in_pop=(11, 13836), p_uncorrected=0.011481279444533183, depth=5, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000025747', u'ENSMUSG00000020534', u'ENSMUSG00000021707']), pop_n=13836, pop_count=11, pop_items=set([u'ENSMUSG00000020300', u'ENSMUSG00000037992', u'ENSMUSG00000045896', u'ENSMUSG00000021707', u'ENSMUSG00000037058', u'ENSMUSG00000043991', u'ENSMUSG00000025747', u'ENSMUSG00000025586', u'ENSMUSG00000020534', u'ENSMUSG00000039652', u'ENSMUSG00000039782']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000902', NS='BP', enrichment='p', name='cell morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(56, 13836), p_uncorrected=0.5196351638762926, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027699']), pop_n=13836, pop_count=56, pop_items=set([u'ENSMUSG00000049336', u'ENSMUSG00000030223', u'ENSMUSG00000021669', u'ENSMUSG00000019256', u'ENSMUSG00000018209', u'ENSMUSG00000048078', u'ENSMUSG00000022508', u'ENSMUSG00000028864', u'ENSMUSG00000031897', u'ENSMUSG00000048450', u'ENSMUSG00000019996', u'ENSMUSG00000034908', u'ENSMUSG00000029468', u'ENSMUSG00000029106', u'ENSMUSG00000037013', u'ENSMUSG00000062991', u'ENSMUSG00000018160', u'ENSMUSG00000026027', u'ENSMUSG00000051910', u'ENSMUSG00000028664', u'ENSMUSG00000004364', u'ENSMUSG00000053110', u'ENSMUSG00000042121', u'ENSMUSG00000024576', u'ENSMUSG00000022037', u'ENSMUSG00000031561', u'ENSMUSG00000036908', u'ENSMUSG00000030302', u'ENSMUSG00000027699', u'ENSMUSG00000028059', u'ENSMUSG00000018974', u'ENSMUSG00000028583', u'ENSMUSG00000056602', u'ENSMUSG00000042548', u'ENSMUSG00000037890', u'ENSMUSG00000039239', u'ENSMUSG00000046822', u'ENSMUSG00000034274', u'ENSMUSG00000021373', u'ENSMUSG00000018387', u'ENSMUSG00000055148', u'ENSMUSG00000024781', u'ENSMUSG00000020122', u'ENSMUSG00000028656', u'ENSMUSG00000033540', u'ENSMUSG00000028745', u'ENSMUSG00000037475', u'ENSMUSG00000025473', u'ENSMUSG00000057329', u'ENSMUSG00000029381', u'ENSMUSG00000070733', u'ENSMUSG00000053436', u'ENSMUSG00000016150', u'ENSMUSG00000026380', u'ENSMUSG00000007815', u'ENSMUSG00000032187']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0045791', 'GO:0045790', 'GO:0007148'])),
    NtGoeaResults(GO='GO:0000910', NS='BP', enrichment='e', name='cytokinesis', ratio_in_study=(8, 624), ratio_in_pop=(27, 13836), p_uncorrected=1.6948343624928748e-05, depth=3, study_count=8, p_sm_bonferroni=0.26619068497313092, p_fdr_bh=0.0018549152296738944, study_items=set([u'ENSMUSG00000027699', u'ENSMUSG00000003779', u'ENSMUSG00000032254', u'ENSMUSG00000017716', u'ENSMUSG00000041147', u'ENSMUSG00000030867', u'ENSMUSG00000038943', u'ENSMUSG00000024660']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000026491', u'ENSMUSG00000029516', u'ENSMUSG00000029518', u'ENSMUSG00000033628', u'ENSMUSG00000017639', u'ENSMUSG00000066440', u'ENSMUSG00000070923', u'ENSMUSG00000003779', u'ENSMUSG00000028447', u'ENSMUSG00000036580', u'ENSMUSG00000031729', u'ENSMUSG00000030867', u'ENSMUSG00000037098', u'ENSMUSG00000024660', u'ENSMUSG00000004771', u'ENSMUSG00000036782', u'ENSMUSG00000035086', u'ENSMUSG00000027699', u'ENSMUSG00000033900', u'ENSMUSG00000041147', u'ENSMUSG00000021375', u'ENSMUSG00000038943', u'ENSMUSG00000032254', u'ENSMUSG00000017716', u'ENSMUSG00000015932', u'ENSMUSG00000032322', u'ENSMUSG00000007659']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0016288', 'GO:0007104', 'GO:0033205'])),
    NtGoeaResults(GO='GO:0000915', NS='BP', enrichment='e', name='actomyosin contractile ring assembly', ratio_in_study=(2, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.005909998133444449, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.22584533013109129, study_items=set([u'ENSMUSG00000032254', u'ENSMUSG00000023015']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000032504']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0045573'])),
    NtGoeaResults(GO='GO:0000920', NS='BP', enrichment='e', name='cell separation after cytokinesis', ratio_in_study=(3, 624), ratio_in_pop=(14, 13836), p_uncorrected=0.022905527883298242, depth=2, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.623490850840697, study_items=set([u'ENSMUSG00000003779', u'ENSMUSG00000026088', u'ENSMUSG00000024989']), pop_n=13836, pop_count=14, pop_items=set([u'ENSMUSG00000033916', u'ENSMUSG00000003779', u'ENSMUSG00000032504', u'ENSMUSG00000034190', u'ENSMUSG00000009907', u'ENSMUSG00000025371', u'ENSMUSG00000004843', u'ENSMUSG00000028419', u'ENSMUSG00000038467', u'ENSMUSG00000053119', u'ENSMUSG00000000743', u'ENSMUSG00000031913', u'ENSMUSG00000024989', u'ENSMUSG00000026088']), study_n=624, level=2, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:1902409', 'GO:2000695'])),
    NtGoeaResults(GO='GO:0000922', NS='CC', enrichment='e', name='spindle pole', ratio_in_study=(19, 624), ratio_in_pop=(71, 13836), p_uncorrected=1.9682622989296949e-10, depth=5, study_count=19, p_sm_bonferroni=3.0913527666989789e-06, p_fdr_bh=9.9721056990289646e-08, study_items=set([u'ENSMUSG00000029414', u'ENSMUSG00000017499', u'ENSMUSG00000023940', u'ENSMUSG00000041431', u'ENSMUSG00000069910', u'ENSMUSG00000027469', u'ENSMUSG00000027635', u'ENSMUSG00000061533', u'ENSMUSG00000029910', u'ENSMUSG00000025474', u'ENSMUSG00000030867', u'ENSMUSG00000035842', u'ENSMUSG00000068744', u'ENSMUSG00000033952', u'ENSMUSG00000026622', u'ENSMUSG00000026605', u'ENSMUSG00000012443', u'ENSMUSG00000000759', u'ENSMUSG00000036822']), pop_n=13836, pop_count=71, pop_items=set([u'ENSMUSG00000029414', u'ENSMUSG00000035198', u'ENSMUSG00000069910', u'ENSMUSG00000027635', u'ENSMUSG00000024073', u'ENSMUSG00000002058', u'ENSMUSG00000019794', u'ENSMUSG00000027330', u'ENSMUSG00000027469', u'ENSMUSG00000029757', u'ENSMUSG00000038215', u'ENSMUSG00000035842', u'ENSMUSG00000021365', u'ENSMUSG00000031913', u'ENSMUSG00000023940', u'ENSMUSG00000032264', u'ENSMUSG00000025337', u'ENSMUSG00000018372', u'ENSMUSG00000037020', u'ENSMUSG00000061533', u'ENSMUSG00000004221', u'ENSMUSG00000041431', u'ENSMUSG00000023072', u'ENSMUSG00000033790', u'ENSMUSG00000024603', u'ENSMUSG00000052087', u'ENSMUSG00000023345', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000031787', u'ENSMUSG00000000759', u'ENSMUSG00000020776', u'ENSMUSG00000014075', u'ENSMUSG00000033952', u'ENSMUSG00000021068', u'ENSMUSG00000035790', u'ENSMUSG00000056763', u'ENSMUSG00000031865', u'ENSMUSG00000036822', u'ENSMUSG00000021959', u'ENSMUSG00000040549', u'ENSMUSG00000021693', u'ENSMUSG00000037443', u'ENSMUSG00000068744', u'ENSMUSG00000041809', u'ENSMUSG00000019988', u'ENSMUSG00000052105', u'ENSMUSG00000004771', u'ENSMUSG00000025722', u'ENSMUSG00000029554', u'ENSMUSG00000026991', u'ENSMUSG00000032435', u'ENSMUSG00000033102', u'ENSMUSG00000017499', u'ENSMUSG00000051786', u'ENSMUSG00000033323', u'ENSMUSG00000019952', u'ENSMUSG00000002546', u'ENSMUSG00000033502', u'ENSMUSG00000029910', u'ENSMUSG00000025474', u'ENSMUSG00000009907', u'ENSMUSG00000042050', u'ENSMUSG00000047844', u'ENSMUSG00000053436', u'ENSMUSG00000027263', u'ENSMUSG00000026622', u'ENSMUSG00000026605', u'ENSMUSG00000012443', u'ENSMUSG00000066306', u'ENSMUSG00000039298']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0030615'])),
    NtGoeaResults(GO='GO:0000923', NS='CC', enrichment='e', name='equatorial microtubule organizing center', ratio_in_study=(2, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.026990741332852557, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000000759', u'ENSMUSG00000025474']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000051786', u'ENSMUSG00000025474', u'ENSMUSG00000000759', u'ENSMUSG00000027263', u'ENSMUSG00000033790', u'ENSMUSG00000033186']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000930', NS='CC', enrichment='e', name='gamma-tubulin complex', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000036822']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000035198', u'ENSMUSG00000031393', u'ENSMUSG00000028525', u'ENSMUSG00000040549', u'ENSMUSG00000037855', u'ENSMUSG00000057506', u'ENSMUSG00000019971', u'ENSMUSG00000001134', u'ENSMUSG00000045007', u'ENSMUSG00000027263', u'ENSMUSG00000030397', u'ENSMUSG00000036822']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000932', NS='CC', enrichment='p', name='P-body', ratio_in_study=(2, 624), ratio_in_pop=(58, 13836), p_uncorrected=1.0, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024472', u'ENSMUSG00000002227']), pop_n=13836, pop_count=58, pop_items=set([u'ENSMUSG00000079259', u'ENSMUSG00000021127', u'ENSMUSG00000028300', u'ENSMUSG00000052707', u'ENSMUSG00000020515', u'ENSMUSG00000057143', u'ENSMUSG00000015837', u'ENSMUSG00000020454', u'ENSMUSG00000038957', u'ENSMUSG00000036550', u'ENSMUSG00000028156', u'ENSMUSG00000022178', u'ENSMUSG00000036270', u'ENSMUSG00000037296', u'ENSMUSG00000028675', u'ENSMUSG00000024258', u'ENSMUSG00000021962', u'ENSMUSG00000031683', u'ENSMUSG00000005682', u'ENSMUSG00000074657', u'ENSMUSG00000028580', u'ENSMUSG00000046139', u'ENSMUSG00000041477', u'ENSMUSG00000021024', u'ENSMUSG00000031848', u'ENSMUSG00000040025', u'ENSMUSG00000020166', u'ENSMUSG00000023087', u'ENSMUSG00000053333', u'ENSMUSG00000002102', u'ENSMUSG00000035632', u'ENSMUSG00000029647', u'ENSMUSG00000036698', u'ENSMUSG00000070544', u'ENSMUSG00000003344', u'ENSMUSG00000025103', u'ENSMUSG00000032097', u'ENSMUSG00000031601', u'ENSMUSG00000066568', u'ENSMUSG00000040128', u'ENSMUSG00000071662', u'ENSMUSG00000027184', u'ENSMUSG00000025239', u'ENSMUSG00000036459', u'ENSMUSG00000024472', u'ENSMUSG00000042500', u'ENSMUSG00000040423', u'ENSMUSG00000032410', u'ENSMUSG00000026174', u'ENSMUSG00000044786', u'ENSMUSG00000007050', u'ENSMUSG00000041530', u'ENSMUSG00000002227', u'ENSMUSG00000032301', u'ENSMUSG00000015671', u'ENSMUSG00000028932', u'ENSMUSG00000021838', u'ENSMUSG00000032040']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000939', NS='CC', enrichment='e', name='condensed chromosome inner kinetochore', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029177']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000029177', u'ENSMUSG00000026037']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000940', NS='CC', enrichment='e', name='condensed chromosome outer kinetochore', ratio_in_study=(6, 624), ratio_in_pop=(8, 13836), p_uncorrected=2.129577303502034e-07, depth=5, study_count=6, p_sm_bonferroni=0.0033447141128802949, p_fdr_bh=4.046705718723212e-05, study_items=set([u'ENSMUSG00000069910', u'ENSMUSG00000040084', u'ENSMUSG00000021965', u'ENSMUSG00000045328', u'ENSMUSG00000020492', u'ENSMUSG00000026605']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000069910', u'ENSMUSG00000040084', u'ENSMUSG00000021965', u'ENSMUSG00000045328', u'ENSMUSG00000039509', u'ENSMUSG00000022521', u'ENSMUSG00000026605', u'ENSMUSG00000020492']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000941', NS='CC', enrichment='e', name='condensed nuclear chromosome inner kinetochore', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000027635']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000027635']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000942', NS='CC', enrichment='e', name='condensed nuclear chromosome outer kinetochore', ratio_in_study=(4, 624), ratio_in_pop=(4, 13836), p_uncorrected=4.099215555456427e-06, depth=6, study_count=4, p_sm_bonferroni=0.06438227951399865, p_fdr_bh=0.00053208495466114587, study_items=set([u'ENSMUSG00000030867', u'ENSMUSG00000024056', u'ENSMUSG00000041431', u'ENSMUSG00000027379']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000030867', u'ENSMUSG00000024056', u'ENSMUSG00000041431', u'ENSMUSG00000027379']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000972', NS='BP', enrichment='e', name='transcription-dependent tethering of RNA polymerase II gene DNA at nuclear periphery', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000022142']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000025223', u'ENSMUSG00000022142', u'ENSMUSG00000027509', u'ENSMUSG00000039509']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000973', NS='BP', enrichment='e', name='posttranscriptional tethering of RNA polymerase II gene DNA at nuclear periphery', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000052798']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000052798', u'ENSMUSG00000038542', u'ENSMUSG00000063550']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000976', NS='MF', enrichment='e', name='transcription regulatory region sequence-specific DNA binding', ratio_in_study=(3, 624), ratio_in_pop=(46, 13836), p_uncorrected=0.46321075236748177, depth=7, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020889', u'ENSMUSG00000071646', u'ENSMUSG00000042557']), pop_n=13836, pop_count=46, pop_items=set([u'ENSMUSG00000027544', u'ENSMUSG00000058756', u'ENSMUSG00000015839', u'ENSMUSG00000042557', u'ENSMUSG00000055116', u'ENSMUSG00000023826', u'ENSMUSG00000018143', u'ENSMUSG00000040007', u'ENSMUSG00000034227', u'ENSMUSG00000051817', u'ENSMUSG00000028820', u'ENSMUSG00000025408', u'ENSMUSG00000028800', u'ENSMUSG00000022811', u'ENSMUSG00000055866', u'ENSMUSG00000039231', u'ENSMUSG00000026663', u'ENSMUSG00000076431', u'ENSMUSG00000039741', u'ENSMUSG00000043008', u'ENSMUSG00000026646', u'ENSMUSG00000074221', u'ENSMUSG00000039477', u'ENSMUSG00000068742', u'ENSMUSG00000074637', u'ENSMUSG00000051034', u'ENSMUSG00000022096', u'ENSMUSG00000038418', u'ENSMUSG00000038550', u'ENSMUSG00000071646', u'ENSMUSG00000026565', u'ENSMUSG00000000567', u'ENSMUSG00000029836', u'ENSMUSG00000020893', u'ENSMUSG00000042292', u'ENSMUSG00000028163', u'ENSMUSG00000029913', u'ENSMUSG00000063632', u'ENSMUSG00000020889', u'ENSMUSG00000026628', u'ENSMUSG00000021938', u'ENSMUSG00000038773', u'ENSMUSG00000032419', u'ENSMUSG00000053470', u'ENSMUSG00000063281', u'ENSMUSG00000037876']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000977', NS='MF', enrichment='e', name='RNA polymerase II regulatory region sequence-specific DNA binding', ratio_in_study=(10, 624), ratio_in_pop=(164, 13836), p_uncorrected=0.3388843475067334, depth=8, study_count=10, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000001517', u'ENSMUSG00000020889', u'ENSMUSG00000018983', u'ENSMUSG00000020185', u'ENSMUSG00000021485', u'ENSMUSG00000027109', u'ENSMUSG00000059552', u'ENSMUSG00000016477', u'ENSMUSG00000024912', u'ENSMUSG00000038482']), pop_n=13836, pop_count=164, pop_items=set([u'ENSMUSG00000040363', u'ENSMUSG00000026496', u'ENSMUSG00000023927', u'ENSMUSG00000001288', u'ENSMUSG00000019947', u'ENSMUSG00000001911', u'ENSMUSG00000059552', u'ENSMUSG00000001280', u'ENSMUSG00000033016', u'ENSMUSG00000018377', u'ENSMUSG00000030189', u'ENSMUSG00000038518', u'ENSMUSG00000040167', u'ENSMUSG00000052837', u'ENSMUSG00000058230', u'ENSMUSG00000052534', u'ENSMUSG00000005583', u'ENSMUSG00000056493', u'ENSMUSG00000054808', u'ENSMUSG00000039231', u'ENSMUSG00000022952', u'ENSMUSG00000040310', u'ENSMUSG00000020275', u'ENSMUSG00000023932', u'ENSMUSG00000020185', u'ENSMUSG00000014303', u'ENSMUSG00000048385', u'ENSMUSG00000019564', u'ENSMUSG00000025050', u'ENSMUSG00000030057', u'ENSMUSG00000030199', u'ENSMUSG00000024206', u'ENSMUSG00000059824', u'ENSMUSG00000021485', u'ENSMUSG00000032411', u'ENSMUSG00000026628', u'ENSMUSG00000033249', u'ENSMUSG00000034333', u'ENSMUSG00000050295', u'ENSMUSG00000026380', u'ENSMUSG00000033943', u'ENSMUSG00000017801', u'ENSMUSG00000005893', u'ENSMUSG00000002147', u'ENSMUSG00000056501', u'ENSMUSG00000026826', u'ENSMUSG00000009739', u'ENSMUSG00000037992', u'ENSMUSG00000018983', u'ENSMUSG00000022389', u'ENSMUSG00000020538', u'ENSMUSG00000039671', u'ENSMUSG00000016624', u'ENSMUSG00000057637', u'ENSMUSG00000063889', u'ENSMUSG00000024912', u'ENSMUSG00000037791', u'ENSMUSG00000035934', u'ENSMUSG00000024515', u'ENSMUSG00000041703', u'ENSMUSG00000058318', u'ENSMUSG00000061524', u'ENSMUSG00000032402', u'ENSMUSG00000048249', u'ENSMUSG00000036923', u'ENSMUSG00000018750', u'ENSMUSG00000020052', u'ENSMUSG00000038342', u'ENSMUSG00000072294', u'ENSMUSG00000037601', u'ENSMUSG00000000708', u'ENSMUSG00000001419', u'ENSMUSG00000025025', u'ENSMUSG00000031627', u'ENSMUSG00000036972', u'ENSMUSG00000028466', u'ENSMUSG00000032368', u'ENSMUSG00000029135', u'ENSMUSG00000015937', u'ENSMUSG00000020484', u'ENSMUSG00000038679', u'ENSMUSG00000029705', u'ENSMUSG00000054604', u'ENSMUSG00000026610', u'ENSMUSG00000059040', u'ENSMUSG00000038331', u'ENSMUSG00000024137', u'ENSMUSG00000024831', u'ENSMUSG00000032187', u'ENSMUSG00000039656', u'ENSMUSG00000013089', u'ENSMUSG00000030557', u'ENSMUSG00000072889', u'ENSMUSG00000037235', u'ENSMUSG00000025225', u'ENSMUSG00000049657', u'ENSMUSG00000034041', u'ENSMUSG00000022521', u'ENSMUSG00000053560', u'ENSMUSG00000026663', u'ENSMUSG00000061911', u'ENSMUSG00000003949', u'ENSMUSG00000056749', u'ENSMUSG00000021318', u'ENSMUSG00000038418', u'ENSMUSG00000052942', u'ENSMUSG00000062012', u'ENSMUSG00000032698', u'ENSMUSG00000023027', u'ENSMUSG00000027109', u'ENSMUSG00000010505', u'ENSMUSG00000019817', u'ENSMUSG00000067071', u'ENSMUSG00000021156', u'ENSMUSG00000053552', u'ENSMUSG00000027104', u'ENSMUSG00000012640', u'ENSMUSG00000063524', u'ENSMUSG00000032238', u'ENSMUSG00000027684', u'ENSMUSG00000069114', u'ENSMUSG00000022895', u'ENSMUSG00000022508', u'ENSMUSG00000057469', u'ENSMUSG00000020473', u'ENSMUSG00000033740', u'ENSMUSG00000041911', u'ENSMUSG00000029267', u'ENSMUSG00000033863', u'ENSMUSG00000024927', u'ENSMUSG00000000282', u'ENSMUSG00000067860', u'ENSMUSG00000035877', u'ENSMUSG00000039087', u'ENSMUSG00000038482', u'ENSMUSG00000013787', u'ENSMUSG00000038255', u'ENSMUSG00000027985', u'ENSMUSG00000018654', u'ENSMUSG00000049532', u'ENSMUSG00000071341', u'ENSMUSG00000058886', u'ENSMUSG00000070643', u'ENSMUSG00000034673', u'ENSMUSG00000020086', u'ENSMUSG00000003382', u'ENSMUSG00000059436', u'ENSMUSG00000016477', u'ENSMUSG00000038539', u'ENSMUSG00000001517', u'ENSMUSG00000021540', u'ENSMUSG00000042589', u'ENSMUSG00000026646', u'ENSMUSG00000028423', u'ENSMUSG00000015846', u'ENSMUSG00000015843', u'ENSMUSG00000030744', u'ENSMUSG00000017491', u'ENSMUSG00000029178', u'ENSMUSG00000028163', u'ENSMUSG00000048450', u'ENSMUSG00000020889', u'ENSMUSG00000041515', u'ENSMUSG00000019878']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000978', NS='MF', enrichment='e', name='RNA polymerase II proximal promoter sequence-specific DNA binding', ratio_in_study=(16, 624), ratio_in_pop=(281, 13836), p_uncorrected=0.3093524101744521, depth=9, study_count=16, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000008976', u'ENSMUSG00000018899', u'ENSMUSG00000026536', u'ENSMUSG00000017861', u'ENSMUSG00000039997', u'ENSMUSG00000090272', u'ENSMUSG00000023994', u'ENSMUSG00000020889', u'ENSMUSG00000037868', u'ENSMUSG00000037214', u'ENSMUSG00000026104', u'ENSMUSG00000029580', u'ENSMUSG00000025912', u'ENSMUSG00000024912', u'ENSMUSG00000046179', u'ENSMUSG00000052684']), pop_n=13836, pop_count=281, pop_items=set([u'ENSMUSG00000016087', u'ENSMUSG00000037465', u'ENSMUSG00000048251', u'ENSMUSG00000031103', u'ENSMUSG00000000902', u'ENSMUSG00000035158', u'ENSMUSG00000027544', u'ENSMUSG00000034460', u'ENSMUSG00000031681', u'ENSMUSG00000000861', u'ENSMUSG00000004897', u'ENSMUSG00000004661', u'ENSMUSG00000028341', u'ENSMUSG00000021264', u'ENSMUSG00000001280', u'ENSMUSG00000009733', u'ENSMUSG00000033016', u'ENSMUSG00000034957', u'ENSMUSG00000027660', u'ENSMUSG00000025369', u'ENSMUSG00000018678', u'ENSMUSG00000036442', u'ENSMUSG00000027667', u'ENSMUSG00000052837', u'ENSMUSG00000018160', u'ENSMUSG00000042406', u'ENSMUSG00000006932', u'ENSMUSG00000032035', u'ENSMUSG00000031902', u'ENSMUSG00000051910', u'ENSMUSG00000017861', u'ENSMUSG00000028582', u'ENSMUSG00000063870', u'ENSMUSG00000019777', u'ENSMUSG00000045991', u'ENSMUSG00000005583', u'ENSMUSG00000020893', u'ENSMUSG00000032402', u'ENSMUSG00000079056', u'ENSMUSG00000026104', u'ENSMUSG00000042589', u'ENSMUSG00000026843', u'ENSMUSG00000057098', u'ENSMUSG00000061517', u'ENSMUSG00000034271', u'ENSMUSG00000068154', u'ENSMUSG00000052040', u'ENSMUSG00000026305', u'ENSMUSG00000061887', u'ENSMUSG00000030619', u'ENSMUSG00000045903', u'ENSMUSG00000005698', u'ENSMUSG00000042508', u'ENSMUSG00000030199', u'ENSMUSG00000041309', u'ENSMUSG00000024206', u'ENSMUSG00000038705', u'ENSMUSG00000029832', u'ENSMUSG00000026017', u'ENSMUSG00000025602', u'ENSMUSG00000035125', u'ENSMUSG00000026628', u'ENSMUSG00000037894', u'ENSMUSG00000024563', u'ENSMUSG00000019768', u'ENSMUSG00000000078', u'ENSMUSG00000005897', u'ENSMUSG00000060601', u'ENSMUSG00000052056', u'ENSMUSG00000005893', u'ENSMUSG00000031870', u'ENSMUSG00000020167', u'ENSMUSG00000026826', u'ENSMUSG00000071076', u'ENSMUSG00000022383', u'ENSMUSG00000027439', u'ENSMUSG00000049728', u'ENSMUSG00000022389', u'ENSMUSG00000021327', u'ENSMUSG00000015709', u'ENSMUSG00000020538', u'ENSMUSG00000041515', u'ENSMUSG00000071359', u'ENSMUSG00000032897', u'ENSMUSG00000024912', u'ENSMUSG00000046532', u'ENSMUSG00000043456', u'ENSMUSG00000035529', u'ENSMUSG00000024513', u'ENSMUSG00000003992', u'ENSMUSG00000014859', u'ENSMUSG00000022556', u'ENSMUSG00000024515', u'ENSMUSG00000026536', u'ENSMUSG00000020453', u'ENSMUSG00000034227', u'ENSMUSG00000000247', u'ENSMUSG00000049672', u'ENSMUSG00000003184', u'ENSMUSG00000037243', u'ENSMUSG00000026436', u'ENSMUSG00000037868', u'ENSMUSG00000022010', u'ENSMUSG00000036867', u'ENSMUSG00000017724', u'ENSMUSG00000028800', u'ENSMUSG00000034522', u'ENSMUSG00000061079', u'ENSMUSG00000005886', u'ENSMUSG00000059213', u'ENSMUSG00000026932', u'ENSMUSG00000020052', u'ENSMUSG00000057236', u'ENSMUSG00000043263', u'ENSMUSG00000003847', u'ENSMUSG00000040929', u'ENSMUSG00000037984', u'ENSMUSG00000001419', u'ENSMUSG00000003282', u'ENSMUSG00000024826', u'ENSMUSG00000055024', u'ENSMUSG00000032419', u'ENSMUSG00000028466', u'ENSMUSG00000030380', u'ENSMUSG00000008575', u'ENSMUSG00000055320', u'ENSMUSG00000078619', u'ENSMUSG00000008976', u'ENSMUSG00000032368', u'ENSMUSG00000005774', u'ENSMUSG00000055053', u'ENSMUSG00000028150', u'ENSMUSG00000040732', u'ENSMUSG00000028890', u'ENSMUSG00000039275', u'ENSMUSG00000061013', u'ENSMUSG00000067860', u'ENSMUSG00000051510', u'ENSMUSG00000005373', u'ENSMUSG00000018604', u'ENSMUSG00000031706', u'ENSMUSG00000005148', u'ENSMUSG00000023991', u'ENSMUSG00000023990', u'ENSMUSG00000075327', u'ENSMUSG00000049295', u'ENSMUSG00000070003', u'ENSMUSG00000021743', u'ENSMUSG00000032228', u'ENSMUSG00000074607', u'ENSMUSG00000041235', u'ENSMUSG00000039158', u'ENSMUSG00000002111', u'ENSMUSG00000035011', u'ENSMUSG00000025959', u'ENSMUSG00000025958', u'ENSMUSG00000061524', u'ENSMUSG00000090272', u'ENSMUSG00000037369', u'ENSMUSG00000032187', u'ENSMUSG00000030256', u'ENSMUSG00000030557', u'ENSMUSG00000047407', u'ENSMUSG00000029026', u'ENSMUSG00000027582', u'ENSMUSG00000052534', u'ENSMUSG00000030067', u'ENSMUSG00000039997', u'ENSMUSG00000004151', u'ENSMUSG00000024985', u'ENSMUSG00000037935', u'ENSMUSG00000062563', u'ENSMUSG00000001156', u'ENSMUSG00000022974', u'ENSMUSG00000020656', u'ENSMUSG00000015605', u'ENSMUSG00000037849', u'ENSMUSG00000074622', u'ENSMUSG00000020037', u'ENSMUSG00000073490', u'ENSMUSG00000025225', u'ENSMUSG00000026586', u'ENSMUSG00000021250', u'ENSMUSG00000037674', u'ENSMUSG00000052684', u'ENSMUSG00000002108', u'ENSMUSG00000003923', u'ENSMUSG00000048402', u'ENSMUSG00000027671', u'ENSMUSG00000032481', u'ENSMUSG00000021318', u'ENSMUSG00000036461', u'ENSMUSG00000046179', u'ENSMUSG00000028565', u'ENSMUSG00000039191', u'ENSMUSG00000041852', u'ENSMUSG00000052942', u'ENSMUSG00000025912', u'ENSMUSG00000024081', u'ENSMUSG00000041649', u'ENSMUSG00000029238', u'ENSMUSG00000042390', u'ENSMUSG00000000134', u'ENSMUSG00000002996', u'ENSMUSG00000060373', u'ENSMUSG00000057691', u'ENSMUSG00000024431', u'ENSMUSG00000041530', u'ENSMUSG00000037169', u'ENSMUSG00000035478', u'ENSMUSG00000042097', u'ENSMUSG00000008398', u'ENSMUSG00000008496', u'ENSMUSG00000006215', u'ENSMUSG00000069171', u'ENSMUSG00000030232', u'ENSMUSG00000056216', u'ENSMUSG00000034701', u'ENSMUSG00000033585', u'ENSMUSG00000028042', u'ENSMUSG00000073491', u'ENSMUSG00000009406', u'ENSMUSG00000022895', u'ENSMUSG00000015501', u'ENSMUSG00000078427', u'ENSMUSG00000024955', u'ENSMUSG00000026739', u'ENSMUSG00000003154', u'ENSMUSG00000022500', u'ENSMUSG00000026663', u'ENSMUSG00000024927', u'ENSMUSG00000036192', u'ENSMUSG00000038415', u'ENSMUSG00000048481', u'ENSMUSG00000022346', u'ENSMUSG00000035397', u'ENSMUSG00000071637', u'ENSMUSG00000037017', u'ENSMUSG00000027210', u'ENSMUSG00000027985', u'ENSMUSG00000003545', u'ENSMUSG00000038648', u'ENSMUSG00000002983', u'ENSMUSG00000025408', u'ENSMUSG00000021848', u'ENSMUSG00000022811', u'ENSMUSG00000014767', u'ENSMUSG00000002428', u'ENSMUSG00000068551', u'ENSMUSG00000021546', u'ENSMUSG00000032119', u'ENSMUSG00000018899', u'ENSMUSG00000020160', u'ENSMUSG00000058239', u'ENSMUSG00000039153', u'ENSMUSG00000038346', u'ENSMUSG00000073489', u'ENSMUSG00000053477', u'ENSMUSG00000033006', u'ENSMUSG00000063972', u'ENSMUSG00000059436', u'ENSMUSG00000036686', u'ENSMUSG00000029580', u'ENSMUSG00000031665', u'ENSMUSG00000041483', u'ENSMUSG00000044149', u'ENSMUSG00000058440', u'ENSMUSG00000028901', u'ENSMUSG00000056501', u'ENSMUSG00000027168', u'ENSMUSG00000022463', u'ENSMUSG00000028639', u'ENSMUSG00000004040', u'ENSMUSG00000004359', u'ENSMUSG00000029913', u'ENSMUSG00000020889', u'ENSMUSG00000027201', u'ENSMUSG00000029563', u'ENSMUSG00000038872', u'ENSMUSG00000023994', u'ENSMUSG00000037214']), study_n=624, level=8, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000979', NS='MF', enrichment='e', name='RNA polymerase II core promoter sequence-specific DNA binding', ratio_in_study=(6, 624), ratio_in_pop=(57, 13836), p_uncorrected=0.0425770353720733, depth=9, study_count=6, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000074151', u'ENSMUSG00000025498', u'ENSMUSG00000017548', u'ENSMUSG00000027109', u'ENSMUSG00000026104', u'ENSMUSG00000059552']), pop_n=13836, pop_count=57, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000055917', u'ENSMUSG00000026826', u'ENSMUSG00000002111', u'ENSMUSG00000029475', u'ENSMUSG00000032744', u'ENSMUSG00000074151', u'ENSMUSG00000030678', u'ENSMUSG00000056749', u'ENSMUSG00000018654', u'ENSMUSG00000059552', u'ENSMUSG00000001280', u'ENSMUSG00000033016', u'ENSMUSG00000053110', u'ENSMUSG00000020919', u'ENSMUSG00000029687', u'ENSMUSG00000022556', u'ENSMUSG00000022346', u'ENSMUSG00000035158', u'ENSMUSG00000031681', u'ENSMUSG00000006932', u'ENSMUSG00000017548', u'ENSMUSG00000024985', u'ENSMUSG00000035033', u'ENSMUSG00000038418', u'ENSMUSG00000026104', u'ENSMUSG00000019777', u'ENSMUSG00000024176', u'ENSMUSG00000039834', u'ENSMUSG00000063632', u'ENSMUSG00000014767', u'ENSMUSG00000049577', u'ENSMUSG00000021540', u'ENSMUSG00000021250', u'ENSMUSG00000039153', u'ENSMUSG00000060743', u'ENSMUSG00000003868', u'ENSMUSG00000016559', u'ENSMUSG00000034341', u'ENSMUSG00000055024', u'ENSMUSG00000055067', u'ENSMUSG00000031314', u'ENSMUSG00000039087', u'ENSMUSG00000027168', u'ENSMUSG00000021488', u'ENSMUSG00000026565', u'ENSMUSG00000039191', u'ENSMUSG00000028890', u'ENSMUSG00000025498', u'ENSMUSG00000004043', u'ENSMUSG00000015937', u'ENSMUSG00000009555', u'ENSMUSG00000027109', u'ENSMUSG00000037894', u'ENSMUSG00000019878', u'ENSMUSG00000002147', u'ENSMUSG00000056501']), study_n=624, level=8, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000980', NS='MF', enrichment='e', name='RNA polymerase II distal enhancer sequence-specific DNA binding', ratio_in_study=(4, 624), ratio_in_pop=(56, 13836), p_uncorrected=0.3203040456737657, depth=9, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029580', u'ENSMUSG00000031311', u'ENSMUSG00000023994', u'ENSMUSG00000052684']), pop_n=13836, pop_count=56, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000016087', u'ENSMUSG00000002111', u'ENSMUSG00000000902', u'ENSMUSG00000002393', u'ENSMUSG00000025958', u'ENSMUSG00000020248', u'ENSMUSG00000066687', u'ENSMUSG00000021366', u'ENSMUSG00000004661', u'ENSMUSG00000015839', u'ENSMUSG00000032187', u'ENSMUSG00000015461', u'ENSMUSG00000039656', u'ENSMUSG00000035277', u'ENSMUSG00000032897', u'ENSMUSG00000033016', u'ENSMUSG00000040270', u'ENSMUSG00000024927', u'ENSMUSG00000024513', u'ENSMUSG00000031311', u'ENSMUSG00000078619', u'ENSMUSG00000025612', u'ENSMUSG00000018654', u'ENSMUSG00000037935', u'ENSMUSG00000028820', u'ENSMUSG00000028800', u'ENSMUSG00000019777', u'ENSMUSG00000005583', u'ENSMUSG00000021775', u'ENSMUSG00000020167', u'ENSMUSG00000027439', u'ENSMUSG00000052684', u'ENSMUSG00000038615', u'ENSMUSG00000060743', u'ENSMUSG00000020275', u'ENSMUSG00000057236', u'ENSMUSG00000027434', u'ENSMUSG00000003868', u'ENSMUSG00000021255', u'ENSMUSG00000063870', u'ENSMUSG00000016559', u'ENSMUSG00000032481', u'ENSMUSG00000029580', u'ENSMUSG00000025369', u'ENSMUSG00000079487', u'ENSMUSG00000027671', u'ENSMUSG00000028163', u'ENSMUSG00000033006', u'ENSMUSG00000060373', u'ENSMUSG00000037894', u'ENSMUSG00000038718', u'ENSMUSG00000035478', u'ENSMUSG00000042390', u'ENSMUSG00000027104', u'ENSMUSG00000023994']), study_n=624, level=8, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000981', NS='MF', enrichment='e', name='RNA polymerase II transcription factor activity, sequence-specific DNA binding', ratio_in_study=(8, 624), ratio_in_pop=(117, 13836), p_uncorrected=0.2552437829605827, depth=3, study_count=8, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000001517', u'ENSMUSG00000052684', u'ENSMUSG00000027490', u'ENSMUSG00000017861', u'ENSMUSG00000059552', u'ENSMUSG00000037188', u'ENSMUSG00000025912', u'ENSMUSG00000038482']), pop_n=13836, pop_count=117, pop_items=set([u'ENSMUSG00000026803', u'ENSMUSG00000031103', u'ENSMUSG00000027544', u'ENSMUSG00000059552', u'ENSMUSG00000030753', u'ENSMUSG00000030757', u'ENSMUSG00000001988', u'ENSMUSG00000018678', u'ENSMUSG00000018160', u'ENSMUSG00000023079', u'ENSMUSG00000021945', u'ENSMUSG00000021796', u'ENSMUSG00000017861', u'ENSMUSG00000020950', u'ENSMUSG00000021109', u'ENSMUSG00000006673', u'ENSMUSG00000024176', u'ENSMUSG00000005583', u'ENSMUSG00000020275', u'ENSMUSG00000023932', u'ENSMUSG00000050619', u'ENSMUSG00000018347', u'ENSMUSG00000025128', u'ENSMUSG00000025323', u'ENSMUSG00000000567', u'ENSMUSG00000027490', u'ENSMUSG00000025602', u'ENSMUSG00000003154', u'ENSMUSG00000032411', u'ENSMUSG00000032035', u'ENSMUSG00000038482', u'ENSMUSG00000020415', u'ENSMUSG00000015709', u'ENSMUSG00000030678', u'ENSMUSG00000036281', u'ENSMUSG00000052684', u'ENSMUSG00000041540', u'ENSMUSG00000026436', u'ENSMUSG00000056493', u'ENSMUSG00000017724', u'ENSMUSG00000045903', u'ENSMUSG00000033961', u'ENSMUSG00000001419', u'ENSMUSG00000003282', u'ENSMUSG00000022987', u'ENSMUSG00000031310', u'ENSMUSG00000008575', u'ENSMUSG00000042406', u'ENSMUSG00000055053', u'ENSMUSG00000040732', u'ENSMUSG00000042408', u'ENSMUSG00000020484', u'ENSMUSG00000074637', u'ENSMUSG00000035277', u'ENSMUSG00000040321', u'ENSMUSG00000051695', u'ENSMUSG00000056501', u'ENSMUSG00000030256', u'ENSMUSG00000029249', u'ENSMUSG00000022528', u'ENSMUSG00000013089', u'ENSMUSG00000030557', u'ENSMUSG00000010175', u'ENSMUSG00000029026', u'ENSMUSG00000061013', u'ENSMUSG00000004151', u'ENSMUSG00000040123', u'ENSMUSG00000043872', u'ENSMUSG00000020653', u'ENSMUSG00000060261', u'ENSMUSG00000025225', u'ENSMUSG00000034041', u'ENSMUSG00000044876', u'ENSMUSG00000037174', u'ENSMUSG00000021514', u'ENSMUSG00000074622', u'ENSMUSG00000021010', u'ENSMUSG00000034173', u'ENSMUSG00000076431', u'ENSMUSG00000055435', u'ENSMUSG00000028565', u'ENSMUSG00000025912', u'ENSMUSG00000032698', u'ENSMUSG00000070822', u'ENSMUSG00000019817', u'ENSMUSG00000008398', u'ENSMUSG00000039275', u'ENSMUSG00000046572', u'ENSMUSG00000054939', u'ENSMUSG00000009406', u'ENSMUSG00000022895', u'ENSMUSG00000032998', u'ENSMUSG00000020472', u'ENSMUSG00000037188', u'ENSMUSG00000040857', u'ENSMUSG00000046785', u'ENSMUSG00000022346', u'ENSMUSG00000045071', u'ENSMUSG00000035158', u'ENSMUSG00000038845', u'ENSMUSG00000042903', u'ENSMUSG00000022952', u'ENSMUSG00000015942', u'ENSMUSG00000049164', u'ENSMUSG00000004328', u'ENSMUSG00000001517', u'ENSMUSG00000058638', u'ENSMUSG00000033006', u'ENSMUSG00000030103', u'ENSMUSG00000055148', u'ENSMUSG00000027168', u'ENSMUSG00000051413', u'ENSMUSG00000004040', u'ENSMUSG00000028163', u'ENSMUSG00000042446', u'ENSMUSG00000025902', u'ENSMUSG00000052135']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000982', NS='MF', enrichment='e', name='transcription factor activity, RNA polymerase II proximal promoter sequence-specific DNA binding', ratio_in_study=(2, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.16091278670984807, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025498', u'ENSMUSG00000052684']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000040187', u'ENSMUSG00000001280', u'ENSMUSG00000039191', u'ENSMUSG00000002111', u'ENSMUSG00000025498', u'ENSMUSG00000059213', u'ENSMUSG00000048450', u'ENSMUSG00000032035', u'ENSMUSG00000020538', u'ENSMUSG00000029238', u'ENSMUSG00000028466', u'ENSMUSG00000055116', u'ENSMUSG00000015605', u'ENSMUSG00000055320', u'ENSMUSG00000038418', u'ENSMUSG00000052684']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000983', NS='MF', enrichment='e', name='transcription factor activity, RNA polymerase II core promoter sequence-specific DNA binding', ratio_in_study=(1, 624), ratio_in_pop=(10, 13836), p_uncorrected=0.36974924624400735, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026104']), pop_n=13836, pop_count=10, pop_items=set([u'ENSMUSG00000024927', u'ENSMUSG00000005583', u'ENSMUSG00000026565', u'ENSMUSG00000032744', u'ENSMUSG00000040289', u'ENSMUSG00000032402', u'ENSMUSG00000026104', u'ENSMUSG00000019789', u'ENSMUSG00000015605', u'ENSMUSG00000059436']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000987', NS='MF', enrichment='e', name='proximal promoter sequence-specific DNA binding', ratio_in_study=(2, 624), ratio_in_pop=(21, 13836), p_uncorrected=0.2442369464600129, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027109', u'ENSMUSG00000001228']), pop_n=13836, pop_count=21, pop_items=set([u'ENSMUSG00000021546', u'ENSMUSG00000001228', u'ENSMUSG00000005583', u'ENSMUSG00000055053', u'ENSMUSG00000031902', u'ENSMUSG00000022346', u'ENSMUSG00000024515', u'ENSMUSG00000027434', u'ENSMUSG00000003032', u'ENSMUSG00000027109', u'ENSMUSG00000058881', u'ENSMUSG00000024560', u'ENSMUSG00000055024', u'ENSMUSG00000021264', u'ENSMUSG00000055320', u'ENSMUSG00000015605', u'ENSMUSG00000001280', u'ENSMUSG00000009733', u'ENSMUSG00000014767', u'ENSMUSG00000022521', u'ENSMUSG00000032402']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0001159'])),
    NtGoeaResults(GO='GO:0000989', NS='MF', enrichment='e', name='transcription factor activity, transcription factor binding', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000071646']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000055866', u'ENSMUSG00000020052', u'ENSMUSG00000071646', u'ENSMUSG00000038342', u'ENSMUSG00000044167', u'ENSMUSG00000020038', u'ENSMUSG00000025223', u'ENSMUSG00000039706', u'ENSMUSG00000068742', u'ENSMUSG00000021109', u'ENSMUSG00000020893', u'ENSMUSG00000015522']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000990', NS='MF', enrichment='e', name='transcription factor activity, core RNA polymerase binding', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000059552']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000059552']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0000993', NS='MF', enrichment='p', name='RNA polymerase II core binding', ratio_in_study=(1, 624), ratio_in_pop=(26, 13836), p_uncorrected=1.0, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000042699']), pop_n=13836, pop_count=26, pop_items=set([u'ENSMUSG00000039630', u'ENSMUSG00000033712', u'ENSMUSG00000028431', u'ENSMUSG00000042699', u'ENSMUSG00000036698', u'ENSMUSG00000037355', u'ENSMUSG00000003437', u'ENSMUSG00000024271', u'ENSMUSG00000029290', u'ENSMUSG00000021807', u'ENSMUSG00000022031', u'ENSMUSG00000024283', u'ENSMUSG00000013822', u'ENSMUSG00000021255', u'ENSMUSG00000005609', u'ENSMUSG00000055067', u'ENSMUSG00000020752', u'ENSMUSG00000027651', u'ENSMUSG00000027678', u'ENSMUSG00000027167', u'ENSMUSG00000020485', u'ENSMUSG00000041530', u'ENSMUSG00000026361', u'ENSMUSG00000041328', u'ENSMUSG00000024002', u'ENSMUSG00000026603']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001046', NS='MF', enrichment='e', name='core promoter sequence-specific DNA binding', ratio_in_study=(4, 624), ratio_in_pop=(39, 13836), p_uncorrected=0.09737658150675428, depth=8, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000020889', u'ENSMUSG00000039238', u'ENSMUSG00000023994']), pop_n=13836, pop_count=39, pop_items=set([u'ENSMUSG00000037465', u'ENSMUSG00000068739', u'ENSMUSG00000055116', u'ENSMUSG00000028341', u'ENSMUSG00000029249', u'ENSMUSG00000063889', u'ENSMUSG00000001280', u'ENSMUSG00000024927', u'ENSMUSG00000010175', u'ENSMUSG00000059552', u'ENSMUSG00000079056', u'ENSMUSG00000029238', u'ENSMUSG00000023110', u'ENSMUSG00000032376', u'ENSMUSG00000021144', u'ENSMUSG00000078671', u'ENSMUSG00000028800', u'ENSMUSG00000020063', u'ENSMUSG00000005583', u'ENSMUSG00000021775', u'ENSMUSG00000070544', u'ENSMUSG00000076431', u'ENSMUSG00000020038', u'ENSMUSG00000039238', u'ENSMUSG00000038550', u'ENSMUSG00000008855', u'ENSMUSG00000042406', u'ENSMUSG00000000567', u'ENSMUSG00000015937', u'ENSMUSG00000032238', u'ENSMUSG00000020889', u'ENSMUSG00000002028', u'ENSMUSG00000066613', u'ENSMUSG00000019768', u'ENSMUSG00000043962', u'ENSMUSG00000030180', u'ENSMUSG00000048490', u'ENSMUSG00000038872', u'ENSMUSG00000023994']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001047', NS='MF', enrichment='e', name='core promoter binding', ratio_in_study=(12, 624), ratio_in_pop=(66, 13836), p_uncorrected=3.3519894733810596e-05, depth=6, study_count=12, p_sm_bonferroni=0.52646346668922928, p_fdr_bh=0.0034635754387449288, study_items=set([u'ENSMUSG00000026536', u'ENSMUSG00000018983', u'ENSMUSG00000039997', u'ENSMUSG00000020185', u'ENSMUSG00000027490', u'ENSMUSG00000002325', u'ENSMUSG00000090272', u'ENSMUSG00000042699', u'ENSMUSG00000026104', u'ENSMUSG00000031311', u'ENSMUSG00000046179', u'ENSMUSG00000016477']), pop_n=13836, pop_count=66, pop_items=set([u'ENSMUSG00000055866', u'ENSMUSG00000026923', u'ENSMUSG00000027770', u'ENSMUSG00000055024', u'ENSMUSG00000073489', u'ENSMUSG00000002111', u'ENSMUSG00000018983', u'ENSMUSG00000073491', u'ENSMUSG00000009406', u'ENSMUSG00000031161', u'ENSMUSG00000003032', u'ENSMUSG00000055116', u'ENSMUSG00000090272', u'ENSMUSG00000036390', u'ENSMUSG00000042699', u'ENSMUSG00000033740', u'ENSMUSG00000029249', u'ENSMUSG00000036698', u'ENSMUSG00000068154', u'ENSMUSG00000026313', u'ENSMUSG00000031134', u'ENSMUSG00000002983', u'ENSMUSG00000018160', u'ENSMUSG00000039997', u'ENSMUSG00000046179', u'ENSMUSG00000039630', u'ENSMUSG00000057113', u'ENSMUSG00000037849', u'ENSMUSG00000021144', u'ENSMUSG00000026104', u'ENSMUSG00000028800', u'ENSMUSG00000019777', u'ENSMUSG00000014767', u'ENSMUSG00000016477', u'ENSMUSG00000048756', u'ENSMUSG00000031393', u'ENSMUSG00000005198', u'ENSMUSG00000022952', u'ENSMUSG00000029687', u'ENSMUSG00000043263', u'ENSMUSG00000020185', u'ENSMUSG00000020038', u'ENSMUSG00000021255', u'ENSMUSG00000037070', u'ENSMUSG00000028271', u'ENSMUSG00000031311', u'ENSMUSG00000073490', u'ENSMUSG00000041483', u'ENSMUSG00000008855', u'ENSMUSG00000040463', u'ENSMUSG00000029238', u'ENSMUSG00000028890', u'ENSMUSG00000002325', u'ENSMUSG00000023055', u'ENSMUSG00000027490', u'ENSMUSG00000071054', u'ENSMUSG00000020484', u'ENSMUSG00000026536', u'ENSMUSG00000024431', u'ENSMUSG00000041530', u'ENSMUSG00000021938', u'ENSMUSG00000022105', u'ENSMUSG00000028820', u'ENSMUSG00000006215', u'ENSMUSG00000020074', u'ENSMUSG00000053470']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001069', NS='MF', enrichment='e', name='regulatory region RNA binding', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000042699']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000032293', u'ENSMUSG00000006498', u'ENSMUSG00000042699', u'ENSMUSG00000027763', u'ENSMUSG00000004980']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001077', NS='MF', enrichment='e', name='transcriptional activator activity, RNA polymerase II proximal promoter sequence-specific DNA binding', ratio_in_study=(10, 624), ratio_in_pop=(185, 13836), p_uncorrected=0.47802269372177364, depth=5, study_count=10, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000008976', u'ENSMUSG00000018899', u'ENSMUSG00000039238', u'ENSMUSG00000023994', u'ENSMUSG00000037868', u'ENSMUSG00000017861', u'ENSMUSG00000059552', u'ENSMUSG00000025912', u'ENSMUSG00000024912', u'ENSMUSG00000052684']), pop_n=13836, pop_count=185, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000016087', u'ENSMUSG00000037465', u'ENSMUSG00000048251', u'ENSMUSG00000031103', u'ENSMUSG00000029026', u'ENSMUSG00000035158', u'ENSMUSG00000027544', u'ENSMUSG00000061517', u'ENSMUSG00000031681', u'ENSMUSG00000004661', u'ENSMUSG00000028341', u'ENSMUSG00000059552', u'ENSMUSG00000001280', u'ENSMUSG00000009733', u'ENSMUSG00000033016', u'ENSMUSG00000034957', u'ENSMUSG00000032228', u'ENSMUSG00000027667', u'ENSMUSG00000052837', u'ENSMUSG00000042406', u'ENSMUSG00000031902', u'ENSMUSG00000017861', u'ENSMUSG00000021109', u'ENSMUSG00000020063', u'ENSMUSG00000025912', u'ENSMUSG00000063632', u'ENSMUSG00000040712', u'ENSMUSG00000032744', u'ENSMUSG00000034460', u'ENSMUSG00000061524', u'ENSMUSG00000039238', u'ENSMUSG00000014303', u'ENSMUSG00000057098', u'ENSMUSG00000042508', u'ENSMUSG00000008855', u'ENSMUSG00000014592', u'ENSMUSG00000030199', u'ENSMUSG00000000567', u'ENSMUSG00000059824', u'ENSMUSG00000026017', u'ENSMUSG00000024563', u'ENSMUSG00000019768', u'ENSMUSG00000000078', u'ENSMUSG00000060601', u'ENSMUSG00000005893', u'ENSMUSG00000031870', u'ENSMUSG00000020167', u'ENSMUSG00000026826', u'ENSMUSG00000071076', u'ENSMUSG00000022383', u'ENSMUSG00000022389', u'ENSMUSG00000015709', u'ENSMUSG00000020538', u'ENSMUSG00000055116', u'ENSMUSG00000032897', u'ENSMUSG00000024912', u'ENSMUSG00000046532', u'ENSMUSG00000052684', u'ENSMUSG00000035529', u'ENSMUSG00000003992', u'ENSMUSG00000028639', u'ENSMUSG00000024515', u'ENSMUSG00000029238', u'ENSMUSG00000020453', u'ENSMUSG00000034227', u'ENSMUSG00000000247', u'ENSMUSG00000003184', u'ENSMUSG00000037868', u'ENSMUSG00000026434', u'ENSMUSG00000022010', u'ENSMUSG00000052040', u'ENSMUSG00000045903', u'ENSMUSG00000061887', u'ENSMUSG00000038346', u'ENSMUSG00000003847', u'ENSMUSG00000037984', u'ENSMUSG00000001419', u'ENSMUSG00000003282', u'ENSMUSG00000028466', u'ENSMUSG00000030380', u'ENSMUSG00000008575', u'ENSMUSG00000008976', u'ENSMUSG00000032368', u'ENSMUSG00000032369', u'ENSMUSG00000055053', u'ENSMUSG00000039191', u'ENSMUSG00000045991', u'ENSMUSG00000028890', u'ENSMUSG00000006215', u'ENSMUSG00000061013', u'ENSMUSG00000051510', u'ENSMUSG00000022335', u'ENSMUSG00000005148', u'ENSMUSG00000074637', u'ENSMUSG00000023990', u'ENSMUSG00000061079', u'ENSMUSG00000070003', u'ENSMUSG00000023994', u'ENSMUSG00000074607', u'ENSMUSG00000039158', u'ENSMUSG00000046711', u'ENSMUSG00000002111', u'ENSMUSG00000025959', u'ENSMUSG00000026843', u'ENSMUSG00000003032', u'ENSMUSG00000056501', u'ENSMUSG00000030557', u'ENSMUSG00000020919', u'ENSMUSG00000052534', u'ENSMUSG00000027230', u'ENSMUSG00000004151', u'ENSMUSG00000019803', u'ENSMUSG00000024985', u'ENSMUSG00000062563', u'ENSMUSG00000023034', u'ENSMUSG00000025225', u'ENSMUSG00000020656', u'ENSMUSG00000026201', u'ENSMUSG00000015605', u'ENSMUSG00000074622', u'ENSMUSG00000020037', u'ENSMUSG00000076431', u'ENSMUSG00000021250', u'ENSMUSG00000002108', u'ENSMUSG00000003949', u'ENSMUSG00000048402', u'ENSMUSG00000036461', u'ENSMUSG00000028565', u'ENSMUSG00000052942', u'ENSMUSG00000005583', u'ENSMUSG00000024081', u'ENSMUSG00000039275', u'ENSMUSG00000041420', u'ENSMUSG00000000134', u'ENSMUSG00000024431', u'ENSMUSG00000037169', u'ENSMUSG00000053007', u'ENSMUSG00000008398', u'ENSMUSG00000008496', u'ENSMUSG00000027104', u'ENSMUSG00000027678', u'ENSMUSG00000045302', u'ENSMUSG00000056216', u'ENSMUSG00000034701', u'ENSMUSG00000033585', u'ENSMUSG00000028042', u'ENSMUSG00000009406', u'ENSMUSG00000015501', u'ENSMUSG00000024955', u'ENSMUSG00000003154', u'ENSMUSG00000039967', u'ENSMUSG00000036192', u'ENSMUSG00000024927', u'ENSMUSG00000067860', u'ENSMUSG00000022346', u'ENSMUSG00000071637', u'ENSMUSG00000027210', u'ENSMUSG00000027985', u'ENSMUSG00000003545', u'ENSMUSG00000038648', u'ENSMUSG00000002983', u'ENSMUSG00000025408', u'ENSMUSG00000021848', u'ENSMUSG00000002428', u'ENSMUSG00000068551', u'ENSMUSG00000021546', u'ENSMUSG00000037017', u'ENSMUSG00000018899', u'ENSMUSG00000020160', u'ENSMUSG00000051817', u'ENSMUSG00000071359', u'ENSMUSG00000039153', u'ENSMUSG00000053477', u'ENSMUSG00000063972', u'ENSMUSG00000044149', u'ENSMUSG00000058440', u'ENSMUSG00000028901', u'ENSMUSG00000027168', u'ENSMUSG00000055320', u'ENSMUSG00000051413', u'ENSMUSG00000004040', u'ENSMUSG00000004359', u'ENSMUSG00000038418', u'ENSMUSG00000024140']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001078', NS='MF', enrichment='e', name='transcriptional repressor activity, RNA polymerase II proximal promoter sequence-specific DNA binding', ratio_in_study=(6, 624), ratio_in_pop=(113, 13836), p_uncorrected=0.6454337584743044, depth=5, study_count=6, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020889', u'ENSMUSG00000026536', u'ENSMUSG00000039997', u'ENSMUSG00000027109', u'ENSMUSG00000090272', u'ENSMUSG00000046179']), pop_n=13836, pop_count=113, pop_items=set([u'ENSMUSG00000047907', u'ENSMUSG00000049672', u'ENSMUSG00000027544', u'ENSMUSG00000000861', u'ENSMUSG00000004897', u'ENSMUSG00000021264', u'ENSMUSG00000037243', u'ENSMUSG00000027660', u'ENSMUSG00000018678', u'ENSMUSG00000036442', u'ENSMUSG00000043263', u'ENSMUSG00000025612', u'ENSMUSG00000046982', u'ENSMUSG00000051910', u'ENSMUSG00000031907', u'ENSMUSG00000049295', u'ENSMUSG00000028582', u'ENSMUSG00000020423', u'ENSMUSG00000042589', u'ENSMUSG00000021217', u'ENSMUSG00000068154', u'ENSMUSG00000005698', u'ENSMUSG00000024831', u'ENSMUSG00000026305', u'ENSMUSG00000041309', u'ENSMUSG00000035125', u'ENSMUSG00000029832', u'ENSMUSG00000025602', u'ENSMUSG00000037896', u'ENSMUSG00000026628', u'ENSMUSG00000032419', u'ENSMUSG00000052056', u'ENSMUSG00000022383', u'ENSMUSG00000027439', u'ENSMUSG00000021327', u'ENSMUSG00000002996', u'ENSMUSG00000043456', u'ENSMUSG00000026536', u'ENSMUSG00000022306', u'ENSMUSG00000048001', u'ENSMUSG00000048481', u'ENSMUSG00000026932', u'ENSMUSG00000031393', u'ENSMUSG00000005897', u'ENSMUSG00000030380', u'ENSMUSG00000022708', u'ENSMUSG00000027582', u'ENSMUSG00000005373', u'ENSMUSG00000018604', u'ENSMUSG00000041483', u'ENSMUSG00000002111', u'ENSMUSG00000059040', u'ENSMUSG00000022521', u'ENSMUSG00000090272', u'ENSMUSG00000030256', u'ENSMUSG00000029249', u'ENSMUSG00000022528', u'ENSMUSG00000010175', u'ENSMUSG00000028150', u'ENSMUSG00000061013', u'ENSMUSG00000039997', u'ENSMUSG00000040289', u'ENSMUSG00000019803', u'ENSMUSG00000001156', u'ENSMUSG00000041649', u'ENSMUSG00000020052', u'ENSMUSG00000072889', u'ENSMUSG00000037849', u'ENSMUSG00000055639', u'ENSMUSG00000061911', u'ENSMUSG00000026586', u'ENSMUSG00000044167', u'ENSMUSG00000073489', u'ENSMUSG00000029563', u'ENSMUSG00000046179', u'ENSMUSG00000052942', u'ENSMUSG00000034271', u'ENSMUSG00000049728', u'ENSMUSG00000047407', u'ENSMUSG00000027109', u'ENSMUSG00000057691', u'ENSMUSG00000042097', u'ENSMUSG00000069171', u'ENSMUSG00000030232', u'ENSMUSG00000073491', u'ENSMUSG00000073490', u'ENSMUSG00000021244', u'ENSMUSG00000022895', u'ENSMUSG00000024955', u'ENSMUSG00000059436', u'ENSMUSG00000032119', u'ENSMUSG00000079056', u'ENSMUSG00000035397', u'ENSMUSG00000035011', u'ENSMUSG00000022811', u'ENSMUSG00000049577', u'ENSMUSG00000020167', u'ENSMUSG00000024927', u'ENSMUSG00000056749', u'ENSMUSG00000063524', u'ENSMUSG00000028423', u'ENSMUSG00000030103', u'ENSMUSG00000036686', u'ENSMUSG00000031665', u'ENSMUSG00000023991', u'ENSMUSG00000022463', u'ENSMUSG00000022556', u'ENSMUSG00000078427', u'ENSMUSG00000029913', u'ENSMUSG00000020889', u'ENSMUSG00000027201', u'ENSMUSG00000038415', u'ENSMUSG00000041515']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001085', NS='MF', enrichment='e', name='RNA polymerase II transcription factor binding', ratio_in_study=(3, 624), ratio_in_pop=(41, 13836), p_uncorrected=0.43181223342675984, depth=4, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000071646', u'ENSMUSG00000042699']), pop_n=13836, pop_count=41, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000074607', u'ENSMUSG00000044548', u'ENSMUSG00000020361', u'ENSMUSG00000022831', u'ENSMUSG00000002111', u'ENSMUSG00000009406', u'ENSMUSG00000003032', u'ENSMUSG00000042699', u'ENSMUSG00000059552', u'ENSMUSG00000033016', u'ENSMUSG00000046532', u'ENSMUSG00000025332', u'ENSMUSG00000030557', u'ENSMUSG00000049577', u'ENSMUSG00000024515', u'ENSMUSG00000022306', u'ENSMUSG00000006932', u'ENSMUSG00000036940', u'ENSMUSG00000040761', u'ENSMUSG00000028800', u'ENSMUSG00000020593', u'ENSMUSG00000022812', u'ENSMUSG00000061013', u'ENSMUSG00000030796', u'ENSMUSG00000071646', u'ENSMUSG00000055024', u'ENSMUSG00000031665', u'ENSMUSG00000021379', u'ENSMUSG00000008855', u'ENSMUSG00000022521', u'ENSMUSG00000042406', u'ENSMUSG00000055320', u'ENSMUSG00000057522', u'ENSMUSG00000031930', u'ENSMUSG00000002249', u'ENSMUSG00000020484', u'ENSMUSG00000018604', u'ENSMUSG00000022255', u'ENSMUSG00000032419', u'ENSMUSG00000038679']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001102', NS='MF', enrichment='e', name='RNA polymerase II activating transcription factor binding', ratio_in_study=(3, 624), ratio_in_pop=(30, 13836), p_uncorrected=0.15145242773929718, depth=5, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037868', u'ENSMUSG00000042557', u'ENSMUSG00000052684']), pop_n=13836, pop_count=30, pop_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000064215', u'ENSMUSG00000025958', u'ENSMUSG00000015839', u'ENSMUSG00000030256', u'ENSMUSG00000018501', u'ENSMUSG00000042557', u'ENSMUSG00000049577', u'ENSMUSG00000029003', u'ENSMUSG00000006932', u'ENSMUSG00000025223', u'ENSMUSG00000037868', u'ENSMUSG00000032402', u'ENSMUSG00000052684', u'ENSMUSG00000021250', u'ENSMUSG00000030103', u'ENSMUSG00000039910', u'ENSMUSG00000055024', u'ENSMUSG00000039661', u'ENSMUSG00000019789', u'ENSMUSG00000056770', u'ENSMUSG00000032698', u'ENSMUSG00000027714', u'ENSMUSG00000034701', u'ENSMUSG00000042750', u'ENSMUSG00000028899', u'ENSMUSG00000018604', u'ENSMUSG00000043909', u'ENSMUSG00000022105', u'ENSMUSG00000027104']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001103', NS='MF', enrichment='e', name='RNA polymerase II repressing transcription factor binding', ratio_in_study=(3, 624), ratio_in_pop=(26, 13836), p_uncorrected=0.11029282078614151, depth=5, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000071646', u'ENSMUSG00000042557', u'ENSMUSG00000041238']), pop_n=13836, pop_count=26, pop_items=set([u'ENSMUSG00000022383', u'ENSMUSG00000068290', u'ENSMUSG00000037325', u'ENSMUSG00000031755', u'ENSMUSG00000001280', u'ENSMUSG00000042557', u'ENSMUSG00000041238', u'ENSMUSG00000035759', u'ENSMUSG00000024985', u'ENSMUSG00000027274', u'ENSMUSG00000021144', u'ENSMUSG00000028800', u'ENSMUSG00000019777', u'ENSMUSG00000014767', u'ENSMUSG00000021013', u'ENSMUSG00000063870', u'ENSMUSG00000006464', u'ENSMUSG00000009640', u'ENSMUSG00000063145', u'ENSMUSG00000071646', u'ENSMUSG00000039191', u'ENSMUSG00000033543', u'ENSMUSG00000025235', u'ENSMUSG00000004040', u'ENSMUSG00000024498', u'ENSMUSG00000020962']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001104', NS='MF', enrichment='p', name='RNA polymerase II transcription cofactor activity', ratio_in_study=(1, 624), ratio_in_pop=(32, 13836), p_uncorrected=1.0, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000042699']), pop_n=13836, pop_count=32, pop_items=set([u'ENSMUSG00000033871', u'ENSMUSG00000064127', u'ENSMUSG00000092558', u'ENSMUSG00000042699', u'ENSMUSG00000030291', u'ENSMUSG00000045248', u'ENSMUSG00000018160', u'ENSMUSG00000021598', u'ENSMUSG00000017210', u'ENSMUSG00000055491', u'ENSMUSG00000001134', u'ENSMUSG00000034674', u'ENSMUSG00000018923', u'ENSMUSG00000066042', u'ENSMUSG00000027080', u'ENSMUSG00000038622', u'ENSMUSG00000002679', u'ENSMUSG00000034297', u'ENSMUSG00000043962', u'ENSMUSG00000056476', u'ENSMUSG00000079487', u'ENSMUSG00000029167', u'ENSMUSG00000018076', u'ENSMUSG00000020801', u'ENSMUSG00000020397', u'ENSMUSG00000006392', u'ENSMUSG00000031935', u'ENSMUSG00000061650', u'ENSMUSG00000015776', u'ENSMUSG00000022109', u'ENSMUSG00000043909', u'ENSMUSG00000012114']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0016455'])),
    NtGoeaResults(GO='GO:0001105', NS='MF', enrichment='e', name='RNA polymerase II transcription coactivator activity', ratio_in_study=(3, 624), ratio_in_pop=(31, 13836), p_uncorrected=0.16241512681050038, depth=6, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005566', u'ENSMUSG00000042699', u'ENSMUSG00000017146']), pop_n=13836, pop_count=31, pop_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000042292', u'ENSMUSG00000009569', u'ENSMUSG00000022521', u'ENSMUSG00000042699', u'ENSMUSG00000032187', u'ENSMUSG00000032185', u'ENSMUSG00000063550', u'ENSMUSG00000030557', u'ENSMUSG00000034341', u'ENSMUSG00000024921', u'ENSMUSG00000028484', u'ENSMUSG00000076431', u'ENSMUSG00000004263', u'ENSMUSG00000061911', u'ENSMUSG00000017146', u'ENSMUSG00000058392', u'ENSMUSG00000063632', u'ENSMUSG00000057113', u'ENSMUSG00000051817', u'ENSMUSG00000026586', u'ENSMUSG00000056476', u'ENSMUSG00000005566', u'ENSMUSG00000079487', u'ENSMUSG00000004637', u'ENSMUSG00000031665', u'ENSMUSG00000039852', u'ENSMUSG00000010047', u'ENSMUSG00000025764', u'ENSMUSG00000034701', u'ENSMUSG00000039910']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001106', NS='MF', enrichment='e', name='RNA polymerase II transcription corepressor activity', ratio_in_study=(2, 624), ratio_in_pop=(21, 13836), p_uncorrected=0.2442369464600129, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000042557', u'ENSMUSG00000041238']), pop_n=13836, pop_count=21, pop_items=set([u'ENSMUSG00000037791', u'ENSMUSG00000029655', u'ENSMUSG00000041238', u'ENSMUSG00000030421', u'ENSMUSG00000032744', u'ENSMUSG00000091971', u'ENSMUSG00000042557', u'ENSMUSG00000008305', u'ENSMUSG00000005483', u'ENSMUSG00000024498', u'ENSMUSG00000031622', u'ENSMUSG00000001134', u'ENSMUSG00000004897', u'ENSMUSG00000042182', u'ENSMUSG00000039910', u'ENSMUSG00000042197', u'ENSMUSG00000028800', u'ENSMUSG00000032419', u'ENSMUSG00000008575', u'ENSMUSG00000037373', u'ENSMUSG00000039852']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001135', NS='MF', enrichment='e', name='transcription factor activity, RNA polymerase II transcription factor recruiting', ratio_in_study=(3, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.004312087798880901, depth=5, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.19024059261017817, study_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000025912', u'ENSMUSG00000017861']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000036281', u'ENSMUSG00000042508', u'ENSMUSG00000026803', u'ENSMUSG00000027678', u'ENSMUSG00000023932', u'ENSMUSG00000017861', u'ENSMUSG00000025912']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001147', NS='MF', enrichment='e', name='transcription termination site sequence-specific DNA binding', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027433']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000027433', u'ENSMUSG00000043535']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001158', NS='MF', enrichment='e', name='enhancer sequence-specific DNA binding', ratio_in_study=(1, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.5223055970896804, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000054717']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000025223', u'ENSMUSG00000031665', u'ENSMUSG00000054717', u'ENSMUSG00000046711', u'ENSMUSG00000000567', u'ENSMUSG00000063632', u'ENSMUSG00000021255', u'ENSMUSG00000020484', u'ENSMUSG00000010505', u'ENSMUSG00000034522', u'ENSMUSG00000040209', u'ENSMUSG00000028266', u'ENSMUSG00000021264', u'ENSMUSG00000021848', u'ENSMUSG00000027104']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001191', NS='MF', enrichment='e', name='transcriptional repressor activity, RNA polymerase II transcription factor binding', ratio_in_study=(1, 624), ratio_in_pop=(10, 13836), p_uncorrected=0.36974924624400735, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000022906']), pop_n=13836, pop_count=10, pop_items=set([u'ENSMUSG00000022906', u'ENSMUSG00000032355', u'ENSMUSG00000040761', u'ENSMUSG00000021255', u'ENSMUSG00000022521', u'ENSMUSG00000062563', u'ENSMUSG00000030103', u'ENSMUSG00000031601', u'ENSMUSG00000030256', u'ENSMUSG00000022724']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001221', NS='MF', enrichment='e', name='transcription cofactor binding', ratio_in_study=(2, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.04745838570330577, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.82000154659639202, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000023994']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000048756', u'ENSMUSG00000057133', u'ENSMUSG00000018143', u'ENSMUSG00000003032', u'ENSMUSG00000025372', u'ENSMUSG00000015839', u'ENSMUSG00000059552', u'ENSMUSG00000023994']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001222', NS='MF', enrichment='e', name='transcription corepressor binding', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020889']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000055866', u'ENSMUSG00000037791', u'ENSMUSG00000023932', u'ENSMUSG00000032238', u'ENSMUSG00000026021', u'ENSMUSG00000032589', u'ENSMUSG00000026749', u'ENSMUSG00000020889', u'ENSMUSG00000004897', u'ENSMUSG00000020738', u'ENSMUSG00000074221', u'ENSMUSG00000061601']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001227', NS='MF', enrichment='p', name='transcriptional repressor activity, RNA polymerase II transcription regulatory region sequence-specific DNA binding', ratio_in_study=(2, 624), ratio_in_pop=(49, 13836), p_uncorrected=0.9999999999995414, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020185', u'ENSMUSG00000021485']), pop_n=13836, pop_count=49, pop_items=set([u'ENSMUSG00000054604', u'ENSMUSG00000009739', u'ENSMUSG00000057469', u'ENSMUSG00000002393', u'ENSMUSG00000059040', u'ENSMUSG00000023927', u'ENSMUSG00000022508', u'ENSMUSG00000019947', u'ENSMUSG00000020473', u'ENSMUSG00000033016', u'ENSMUSG00000059436', u'ENSMUSG00000002250', u'ENSMUSG00000000282', u'ENSMUSG00000040167', u'ENSMUSG00000058886', u'ENSMUSG00000058230', u'ENSMUSG00000043099', u'ENSMUSG00000018654', u'ENSMUSG00000031902', u'ENSMUSG00000049657', u'ENSMUSG00000003382', u'ENSMUSG00000062012', u'ENSMUSG00000027387', u'ENSMUSG00000072294', u'ENSMUSG00000018750', u'ENSMUSG00000048756', u'ENSMUSG00000030189', u'ENSMUSG00000044167', u'ENSMUSG00000020185', u'ENSMUSG00000063524', u'ENSMUSG00000048385', u'ENSMUSG00000026872', u'ENSMUSG00000038518', u'ENSMUSG00000037235', u'ENSMUSG00000025050', u'ENSMUSG00000030057', u'ENSMUSG00000027168', u'ENSMUSG00000012640', u'ENSMUSG00000028163', u'ENSMUSG00000048450', u'ENSMUSG00000021485', u'ENSMUSG00000025626', u'ENSMUSG00000033249', u'ENSMUSG00000067071', u'ENSMUSG00000001120', u'ENSMUSG00000053768', u'ENSMUSG00000074220', u'ENSMUSG00000017801', u'ENSMUSG00000021743']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001228', NS='MF', enrichment='e', name='transcriptional activator activity, RNA polymerase II transcription regulatory region sequence-specific DNA binding', ratio_in_study=(6, 624), ratio_in_pop=(73, 13836), p_uncorrected=0.14499965218858638, depth=4, study_count=6, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000008976', u'ENSMUSG00000018983', u'ENSMUSG00000059552', u'ENSMUSG00000037188', u'ENSMUSG00000016477', u'ENSMUSG00000038482']), pop_n=13836, pop_count=73, pop_items=set([u'ENSMUSG00000061911', u'ENSMUSG00000026826', u'ENSMUSG00000026496', u'ENSMUSG00000057637', u'ENSMUSG00000018983', u'ENSMUSG00000022314', u'ENSMUSG00000038255', u'ENSMUSG00000048450', u'ENSMUSG00000022521', u'ENSMUSG00000059552', u'ENSMUSG00000026610', u'ENSMUSG00000001911', u'ENSMUSG00000039656', u'ENSMUSG00000029249', u'ENSMUSG00000037188', u'ENSMUSG00000013089', u'ENSMUSG00000018377', u'ENSMUSG00000033249', u'ENSMUSG00000024220', u'ENSMUSG00000014859', u'ENSMUSG00000024515', u'ENSMUSG00000027985', u'ENSMUSG00000051469', u'ENSMUSG00000049532', u'ENSMUSG00000031902', u'ENSMUSG00000053560', u'ENSMUSG00000022952', u'ENSMUSG00000021109', u'ENSMUSG00000015605', u'ENSMUSG00000016477', u'ENSMUSG00000048756', u'ENSMUSG00000034957', u'ENSMUSG00000006705', u'ENSMUSG00000038342', u'ENSMUSG00000033863', u'ENSMUSG00000040310', u'ENSMUSG00000025862', u'ENSMUSG00000055435', u'ENSMUSG00000029135', u'ENSMUSG00000023932', u'ENSMUSG00000003949', u'ENSMUSG00000048249', u'ENSMUSG00000031627', u'ENSMUSG00000055024', u'ENSMUSG00000044636', u'ENSMUSG00000019564', u'ENSMUSG00000053552', u'ENSMUSG00000039087', u'ENSMUSG00000008976', u'ENSMUSG00000027168', u'ENSMUSG00000038679', u'ENSMUSG00000005698', u'ENSMUSG00000032698', u'ENSMUSG00000000567', u'ENSMUSG00000044647', u'ENSMUSG00000032515', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000012640', u'ENSMUSG00000037286', u'ENSMUSG00000039191', u'ENSMUSG00000005893', u'ENSMUSG00000023027', u'ENSMUSG00000032411', u'ENSMUSG00000010505', u'ENSMUSG00000019817', u'ENSMUSG00000025902', u'ENSMUSG00000033943', u'ENSMUSG00000038482', u'ENSMUSG00000006215', u'ENSMUSG00000019878', u'ENSMUSG00000002147', u'ENSMUSG00000021743']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001302', NS='BP', enrichment='e', name='replicative cell aging', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029521']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000003549', u'ENSMUSG00000031583', u'ENSMUSG00000029521', u'ENSMUSG00000067847']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001501', NS='BP', enrichment='e', name='skeletal system development', ratio_in_study=(4, 624), ratio_in_pop=(71, 13836), p_uncorrected=0.5626996194605812, depth=4, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000008090', u'ENSMUSG00000028560', u'ENSMUSG00000006445', u'ENSMUSG00000033762']), pop_n=13836, pop_count=71, pop_items=set([u'ENSMUSG00000026739', u'ENSMUSG00000021665', u'ENSMUSG00000050295', u'ENSMUSG00000079317', u'ENSMUSG00000044177', u'ENSMUSG00000029661', u'ENSMUSG00000025854', u'ENSMUSG00000057123', u'ENSMUSG00000033762', u'ENSMUSG00000004894', u'ENSMUSG00000034781', u'ENSMUSG00000024330', u'ENSMUSG00000004892', u'ENSMUSG00000025352', u'ENSMUSG00000002799', u'ENSMUSG00000063172', u'ENSMUSG00000048402', u'ENSMUSG00000026313', u'ENSMUSG00000022206', u'ENSMUSG00000028560', u'ENSMUSG00000050335', u'ENSMUSG00000007594', u'ENSMUSG00000021613', u'ENSMUSG00000002603', u'ENSMUSG00000041235', u'ENSMUSG00000006932', u'ENSMUSG00000038000', u'ENSMUSG00000066324', u'ENSMUSG00000026042', u'ENSMUSG00000032402', u'ENSMUSG00000022952', u'ENSMUSG00000027523', u'ENSMUSG00000001506', u'ENSMUSG00000063632', u'ENSMUSG00000006958', u'ENSMUSG00000026917', u'ENSMUSG00000032179', u'ENSMUSG00000002103', u'ENSMUSG00000076431', u'ENSMUSG00000028053', u'ENSMUSG00000008090', u'ENSMUSG00000032492', u'ENSMUSG00000039153', u'ENSMUSG00000039239', u'ENSMUSG00000044471', u'ENSMUSG00000066687', u'ENSMUSG00000024940', u'ENSMUSG00000048616', u'ENSMUSG00000061393', u'ENSMUSG00000031668', u'ENSMUSG00000062115', u'ENSMUSG00000027339', u'ENSMUSG00000006445', u'ENSMUSG00000057322', u'ENSMUSG00000032368', u'ENSMUSG00000040711', u'ENSMUSG00000052430', u'ENSMUSG00000024247', u'ENSMUSG00000000567', u'ENSMUSG00000027808', u'ENSMUSG00000037664', u'ENSMUSG00000022483', u'ENSMUSG00000002341', u'ENSMUSG00000025232', u'ENSMUSG00000007613', u'ENSMUSG00000054452', u'ENSMUSG00000021835', u'ENSMUSG00000021614', u'ENSMUSG00000027204', u'ENSMUSG00000024639', u'ENSMUSG00000018604']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001503', NS='BP', enrichment='e', name='ossification', ratio_in_study=(4, 624), ratio_in_pop=(61, 13836), p_uncorrected=0.355249642914492, depth=2, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027109', u'ENSMUSG00000020641', u'ENSMUSG00000054675', u'ENSMUSG00000031885']), pop_n=13836, pop_count=61, pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000026674', u'ENSMUSG00000028226', u'ENSMUSG00000031283', u'ENSMUSG00000033871', u'ENSMUSG00000031668', u'ENSMUSG00000028469', u'ENSMUSG00000030218', u'ENSMUSG00000008999', u'ENSMUSG00000029304', u'ENSMUSG00000028108', u'ENSMUSG00000029307', u'ENSMUSG00000058756', u'ENSMUSG00000021340', u'ENSMUSG00000019997', u'ENSMUSG00000001280', u'ENSMUSG00000040856', u'ENSMUSG00000024098', u'ENSMUSG00000004473', u'ENSMUSG00000001761', u'ENSMUSG00000021493', u'ENSMUSG00000046985', u'ENSMUSG00000021943', u'ENSMUSG00000029838', u'ENSMUSG00000027198', u'ENSMUSG00000034320', u'ENSMUSG00000021835', u'ENSMUSG00000022952', u'ENSMUSG00000054675', u'ENSMUSG00000027339', u'ENSMUSG00000014813', u'ENSMUSG00000027358', u'ENSMUSG00000039004', u'ENSMUSG00000032179', u'ENSMUSG00000032492', u'ENSMUSG00000014301', u'ENSMUSG00000068747', u'ENSMUSG00000029335', u'ENSMUSG00000022098', u'ENSMUSG00000024947', u'ENSMUSG00000000957', u'ENSMUSG00000057329', u'ENSMUSG00000036334', u'ENSMUSG00000057322', u'ENSMUSG00000024247', u'ENSMUSG00000000567', u'ENSMUSG00000031342', u'ENSMUSG00000014599', u'ENSMUSG00000022483', u'ENSMUSG00000026321', u'ENSMUSG00000027770', u'ENSMUSG00000040297', u'ENSMUSG00000027164', u'ENSMUSG00000061731', u'ENSMUSG00000027109', u'ENSMUSG00000020641', u'ENSMUSG00000039883', u'ENSMUSG00000050295', u'ENSMUSG00000021936', u'ENSMUSG00000031885', u'ENSMUSG00000035673']), study_n=624, level=2, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001510', NS='BP', enrichment='e', name='RNA methylation', ratio_in_study=(1, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.3087700161198612, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028233']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000020706', u'ENSMUSG00000026707', u'ENSMUSG00000028233', u'ENSMUSG00000022160', u'ENSMUSG00000029557', u'ENSMUSG00000029726', u'ENSMUSG00000037525', u'ENSMUSG00000028114']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001516', NS='BP', enrichment='e', name='prostaglandin biosynthetic process', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=11, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032487']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000071072', u'ENSMUSG00000029919', u'ENSMUSG00000036257', u'ENSMUSG00000032487', u'ENSMUSG00000024610', u'ENSMUSG00000047250', u'ENSMUSG00000033307', u'ENSMUSG00000029925', u'ENSMUSG00000015090', u'ENSMUSG00000026820', u'ENSMUSG00000050737', u'ENSMUSG00000029059']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001525', NS='BP', enrichment='p', name='angiogenesis', ratio_in_study=(8, 624), ratio_in_pop=(186, 13836), p_uncorrected=1.0, depth=3, study_count=8, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024486', u'ENSMUSG00000032487', u'ENSMUSG00000005413', u'ENSMUSG00000031502', u'ENSMUSG00000070327', u'ENSMUSG00000035352', u'ENSMUSG00000006445', u'ENSMUSG00000052684']), pop_n=13836, pop_count=186, pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000056174', u'ENSMUSG00000028029', u'ENSMUSG00000062604', u'ENSMUSG00000028024', u'ENSMUSG00000025856', u'ENSMUSG00000027314', u'ENSMUSG00000019579', u'ENSMUSG00000046020', u'ENSMUSG00000021266', u'ENSMUSG00000020458', u'ENSMUSG00000026883', u'ENSMUSG00000044337', u'ENSMUSG00000037242', u'ENSMUSG00000018377', u'ENSMUSG00000046207', u'ENSMUSG00000048661', u'ENSMUSG00000027665', u'ENSMUSG00000029669', u'ENSMUSG00000018160', u'ENSMUSG00000038742', u'ENSMUSG00000063531', u'ENSMUSG00000032135', u'ENSMUSG00000021109', u'ENSMUSG00000020063', u'ENSMUSG00000020611', u'ENSMUSG00000032625', u'ENSMUSG00000026814', u'ENSMUSG00000063506', u'ENSMUSG00000009741', u'ENSMUSG00000039745', u'ENSMUSG00000035352', u'ENSMUSG00000041187', u'ENSMUSG00000009621', u'ENSMUSG00000046034', u'ENSMUSG00000036427', u'ENSMUSG00000005958', u'ENSMUSG00000024962', u'ENSMUSG00000006445', u'ENSMUSG00000057315', u'ENSMUSG00000023068', u'ENSMUSG00000050711', u'ENSMUSG00000028108', u'ENSMUSG00000049001', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000035725', u'ENSMUSG00000042626', u'ENSMUSG00000059456', u'ENSMUSG00000062352', u'ENSMUSG00000013663', u'ENSMUSG00000022382', u'ENSMUSG00000021681', u'ENSMUSG00000021576', u'ENSMUSG00000029710', u'ENSMUSG00000031380', u'ENSMUSG00000027954', u'ENSMUSG00000054364', u'ENSMUSG00000019997', u'ENSMUSG00000004565', u'ENSMUSG00000031714', u'ENSMUSG00000030671', u'ENSMUSG00000031565', u'ENSMUSG00000052684', u'ENSMUSG00000022309', u'ENSMUSG00000026029', u'ENSMUSG00000041415', u'ENSMUSG00000045005', u'ENSMUSG00000030605', u'ENSMUSG00000006386', u'ENSMUSG00000072115', u'ENSMUSG00000000392', u'ENSMUSG00000036904', u'ENSMUSG00000021281', u'ENSMUSG00000027087', u'ENSMUSG00000045216', u'ENSMUSG00000069763', u'ENSMUSG00000039217', u'ENSMUSG00000033191', u'ENSMUSG00000024109', u'ENSMUSG00000002289', u'ENSMUSG00000004791', u'ENSMUSG00000019880', u'ENSMUSG00000030849', u'ENSMUSG00000002688', u'ENSMUSG00000020357', u'ENSMUSG00000034353', u'ENSMUSG00000030770', u'ENSMUSG00000023008', u'ENSMUSG00000000600', u'ENSMUSG00000001300', u'ENSMUSG00000020484', u'ENSMUSG00000026234', u'ENSMUSG00000001098', u'ENSMUSG00000021974', u'ENSMUSG00000005148', u'ENSMUSG00000024754', u'ENSMUSG00000026921', u'ENSMUSG00000030093', u'ENSMUSG00000026923', u'ENSMUSG00000028064', u'ENSMUSG00000020717', u'ENSMUSG00000039062', u'ENSMUSG00000021457', u'ENSMUSG00000026193', u'ENSMUSG00000028664', u'ENSMUSG00000027835', u'ENSMUSG00000032487', u'ENSMUSG00000070327', u'ENSMUSG00000022443', u'ENSMUSG00000037362', u'ENSMUSG00000028868', u'ENSMUSG00000057722', u'ENSMUSG00000010660', u'ENSMUSG00000000530', u'ENSMUSG00000031785', u'ENSMUSG00000031486', u'ENSMUSG00000023905', u'ENSMUSG00000028978', u'ENSMUSG00000020154', u'ENSMUSG00000025810', u'ENSMUSG00000035086', u'ENSMUSG00000025969', u'ENSMUSG00000059588', u'ENSMUSG00000021822', u'ENSMUSG00000021256', u'ENSMUSG00000001435', u'ENSMUSG00000030538', u'ENSMUSG00000044562', u'ENSMUSG00000039191', u'ENSMUSG00000046318', u'ENSMUSG00000032011', u'ENSMUSG00000024087', u'ENSMUSG00000022607', u'ENSMUSG00000005413', u'ENSMUSG00000042460', u'ENSMUSG00000041445', u'ENSMUSG00000025473', u'ENSMUSG00000066392', u'ENSMUSG00000008398', u'ENSMUSG00000025393', u'ENSMUSG00000001240', u'ENSMUSG00000032911', u'ENSMUSG00000028041', u'ENSMUSG00000033933', u'ENSMUSG00000020573', u'ENSMUSG00000059439', u'ENSMUSG00000031990', u'ENSMUSG00000017417', u'ENSMUSG00000028763', u'ENSMUSG00000028284', u'ENSMUSG00000024486', u'ENSMUSG00000007613', u'ENSMUSG00000044813', u'ENSMUSG00000020937', u'ENSMUSG00000029648', u'ENSMUSG00000036585', u'ENSMUSG00000068196', u'ENSMUSG00000050965', u'ENSMUSG00000032125', u'ENSMUSG00000044791', u'ENSMUSG00000004328', u'ENSMUSG00000045092', u'ENSMUSG00000006705', u'ENSMUSG00000063273', u'ENSMUSG00000021540', u'ENSMUSG00000020160', u'ENSMUSG00000029999', u'ENSMUSG00000030123', u'ENSMUSG00000031740', u'ENSMUSG00000031668', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000032231', u'ENSMUSG00000035385', u'ENSMUSG00000022469', u'ENSMUSG00000031328', u'ENSMUSG00000032238', u'ENSMUSG00000032537', u'ENSMUSG00000021835', u'ENSMUSG00000053436', u'ENSMUSG00000026078', u'ENSMUSG00000025902', u'ENSMUSG00000024140', u'ENSMUSG00000007655', u'ENSMUSG00000020099']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001541', NS='BP', enrichment='e', name='ovarian follicle development', ratio_in_study=(2, 624), ratio_in_pop=(35, 13836), p_uncorrected=0.671110538166071, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000034218', u'ENSMUSG00000003873']), pop_n=13836, pop_count=35, pop_items=set([u'ENSMUSG00000034218', u'ENSMUSG00000050295', u'ENSMUSG00000006307', u'ENSMUSG00000003873', u'ENSMUSG00000039041', u'ENSMUSG00000019256', u'ENSMUSG00000005493', u'ENSMUSG00000056501', u'ENSMUSG00000029570', u'ENSMUSG00000004788', u'ENSMUSG00000005672', u'ENSMUSG00000046324', u'ENSMUSG00000022309', u'ENSMUSG00000024256', u'ENSMUSG00000037428', u'ENSMUSG00000062960', u'ENSMUSG00000019966', u'ENSMUSG00000079509', u'ENSMUSG00000092118', u'ENSMUSG00000021546', u'ENSMUSG00000035246', u'ENSMUSG00000031740', u'ENSMUSG00000032968', u'ENSMUSG00000046010', u'ENSMUSG00000022982', u'ENSMUSG00000023951', u'ENSMUSG00000029145', u'ENSMUSG00000028453', u'ENSMUSG00000003235', u'ENSMUSG00000057329', u'ENSMUSG00000024515', u'ENSMUSG00000021835', u'ENSMUSG00000007659', u'ENSMUSG00000025326', u'ENSMUSG00000039117']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001556', NS='BP', enrichment='e', name='oocyte maturation', ratio_in_study=(4, 624), ratio_in_pop=(14, 13836), p_uncorrected=0.0028552783859601277, depth=4, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=0.13672256807893221, study_items=set([u'ENSMUSG00000041431', u'ENSMUSG00000021569', u'ENSMUSG00000019773', u'ENSMUSG00000041147']), pop_n=13836, pop_count=14, pop_items=set([u'ENSMUSG00000048756', u'ENSMUSG00000021569', u'ENSMUSG00000022350', u'ENSMUSG00000024101', u'ENSMUSG00000041431', u'ENSMUSG00000059456', u'ENSMUSG00000041147', u'ENSMUSG00000027330', u'ENSMUSG00000040025', u'ENSMUSG00000041741', u'ENSMUSG00000051177', u'ENSMUSG00000023809', u'ENSMUSG00000019773', u'ENSMUSG00000010592']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001558', NS='BP', enrichment='p', name='regulation of cell growth', ratio_in_study=(1, 624), ratio_in_pop=(43, 13836), p_uncorrected=1.0, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000041498']), pop_n=13836, pop_count=43, pop_items=set([u'ENSMUSG00000028062', u'ENSMUSG00000014402', u'ENSMUSG00000021750', u'ENSMUSG00000029096', u'ENSMUSG00000020027', u'ENSMUSG00000072437', u'ENSMUSG00000022525', u'ENSMUSG00000020415', u'ENSMUSG00000019997', u'ENSMUSG00000024074', u'ENSMUSG00000037362', u'ENSMUSG00000039953', u'ENSMUSG00000036256', u'ENSMUSG00000037270', u'ENSMUSG00000036529', u'ENSMUSG00000029003', u'ENSMUSG00000030842', u'ENSMUSG00000041498', u'ENSMUSG00000021901', u'ENSMUSG00000024174', u'ENSMUSG00000071713', u'ENSMUSG00000028991', u'ENSMUSG00000025915', u'ENSMUSG00000006205', u'ENSMUSG00000005087', u'ENSMUSG00000008153', u'ENSMUSG00000028195', u'ENSMUSG00000030890', u'ENSMUSG00000024044', u'ENSMUSG00000020427', u'ENSMUSG00000042289', u'ENSMUSG00000003068', u'ENSMUSG00000028466', u'ENSMUSG00000025583', u'ENSMUSG00000026185', u'ENSMUSG00000030421', u'ENSMUSG00000023046', u'ENSMUSG00000017493', u'ENSMUSG00000026361', u'ENSMUSG00000039323', u'ENSMUSG00000023336', u'ENSMUSG00000022105', u'ENSMUSG00000003534']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001568', NS='BP', enrichment='p', name='blood vessel development', ratio_in_study=(2, 624), ratio_in_pop=(57, 13836), p_uncorrected=1.0, depth=3, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000006445', u'ENSMUSG00000020184']), pop_n=13836, pop_count=57, pop_items=set([u'ENSMUSG00000026921', u'ENSMUSG00000024294', u'ENSMUSG00000057123', u'ENSMUSG00000050295', u'ENSMUSG00000074272', u'ENSMUSG00000062232', u'ENSMUSG00000013584', u'ENSMUSG00000061878', u'ENSMUSG00000033420', u'ENSMUSG00000019256', u'ENSMUSG00000032187', u'ENSMUSG00000028517', u'ENSMUSG00000039844', u'ENSMUSG00000058454', u'ENSMUSG00000024985', u'ENSMUSG00000032327', u'ENSMUSG00000044813', u'ENSMUSG00000041235', u'ENSMUSG00000024620', u'ENSMUSG00000040289', u'ENSMUSG00000029661', u'ENSMUSG00000006445', u'ENSMUSG00000006134', u'ENSMUSG00000050234', u'ENSMUSG00000026043', u'ENSMUSG00000021109', u'ENSMUSG00000000378', u'ENSMUSG00000019969', u'ENSMUSG00000005583', u'ENSMUSG00000019846', u'ENSMUSG00000027168', u'ENSMUSG00000036180', u'ENSMUSG00000020700', u'ENSMUSG00000039239', u'ENSMUSG00000044167', u'ENSMUSG00000026837', u'ENSMUSG00000020184', u'ENSMUSG00000000489', u'ENSMUSG00000049791', u'ENSMUSG00000039910', u'ENSMUSG00000019789', u'ENSMUSG00000031980', u'ENSMUSG00000001506', u'ENSMUSG00000023951', u'ENSMUSG00000024529', u'ENSMUSG00000022607', u'ENSMUSG00000056962', u'ENSMUSG00000057342', u'ENSMUSG00000033792', u'ENSMUSG00000018604', u'ENSMUSG00000029287', u'ENSMUSG00000021835', u'ENSMUSG00000027087', u'ENSMUSG00000033191', u'ENSMUSG00000066595', u'ENSMUSG00000025531', u'ENSMUSG00000032855']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001569', NS='BP', enrichment='p', name='branching involved in blood vessel morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(28, 13836), p_uncorrected=1.0, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000031502']), pop_n=13836, pop_count=28, pop_items=set([u'ENSMUSG00000048109', u'ENSMUSG00000020611', u'ENSMUSG00000006386', u'ENSMUSG00000045382', u'ENSMUSG00000018209', u'ENSMUSG00000031616', u'ENSMUSG00000015468', u'ENSMUSG00000026556', u'ENSMUSG00000022309', u'ENSMUSG00000061353', u'ENSMUSG00000032440', u'ENSMUSG00000029648', u'ENSMUSG00000006932', u'ENSMUSG00000031902', u'ENSMUSG00000078202', u'ENSMUSG00000033953', u'ENSMUSG00000015605', u'ENSMUSG00000025810', u'ENSMUSG00000027314', u'ENSMUSG00000026814', u'ENSMUSG00000030123', u'ENSMUSG00000026836', u'ENSMUSG00000019256', u'ENSMUSG00000023951', u'ENSMUSG00000022231', u'ENSMUSG00000063531', u'ENSMUSG00000027985', u'ENSMUSG00000031502']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001570', NS='BP', enrichment='e', name='vasculogenesis', ratio_in_study=(3, 624), ratio_in_pop=(51, 13836), p_uncorrected=0.5005428360844005, depth=4, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000002221', u'ENSMUSG00000001517', u'ENSMUSG00000006445']), pop_n=13836, pop_count=51, pop_items=set([u'ENSMUSG00000026921', u'ENSMUSG00000032220', u'ENSMUSG00000021127', u'ENSMUSG00000021681', u'ENSMUSG00000030796', u'ENSMUSG00000040289', u'ENSMUSG00000032187', u'ENSMUSG00000074733', u'ENSMUSG00000034640', u'ENSMUSG00000038545', u'ENSMUSG00000069763', u'ENSMUSG00000044337', u'ENSMUSG00000022475', u'ENSMUSG00000001240', u'ENSMUSG00000022309', u'ENSMUSG00000001761', u'ENSMUSG00000052837', u'ENSMUSG00000002603', u'ENSMUSG00000022306', u'ENSMUSG00000006386', u'ENSMUSG00000006932', u'ENSMUSG00000055254', u'ENSMUSG00000053110', u'ENSMUSG00000032440', u'ENSMUSG00000044791', u'ENSMUSG00000000378', u'ENSMUSG00000001517', u'ENSMUSG00000026814', u'ENSMUSG00000075254', u'ENSMUSG00000049791', u'ENSMUSG00000029276', u'ENSMUSG00000041688', u'ENSMUSG00000039910', u'ENSMUSG00000072720', u'ENSMUSG00000019789', u'ENSMUSG00000044562', u'ENSMUSG00000006445', u'ENSMUSG00000004233', u'ENSMUSG00000025314', u'ENSMUSG00000062078', u'ENSMUSG00000022607', u'ENSMUSG00000062960', u'ENSMUSG00000028086', u'ENSMUSG00000020097', u'ENSMUSG00000002221', u'ENSMUSG00000029287', u'ENSMUSG00000034520', u'ENSMUSG00000033191', u'ENSMUSG00000025902', u'ENSMUSG00000007655', u'ENSMUSG00000007817']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001571', NS='MF', enrichment='e', name='non-tyrosine kinase fibroblast growth factor receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000008090']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000008090']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001578', NS='BP', enrichment='e', name='microtubule bundle formation', ratio_in_study=(4, 624), ratio_in_pop=(26, 13836), p_uncorrected=0.027817227972067003, depth=6, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=0.70353845817920191, study_items=set([u'ENSMUSG00000030867', u'ENSMUSG00000068744', u'ENSMUSG00000003779', u'ENSMUSG00000038943']), pop_n=13836, pop_count=26, pop_items=set([u'ENSMUSG00000019794', u'ENSMUSG00000021573', u'ENSMUSG00000019996', u'ENSMUSG00000003779', u'ENSMUSG00000049550', u'ENSMUSG00000053158', u'ENSMUSG00000042766', u'ENSMUSG00000030867', u'ENSMUSG00000014077', u'ENSMUSG00000034201', u'ENSMUSG00000052105', u'ENSMUSG00000067276', u'ENSMUSG00000009418', u'ENSMUSG00000019261', u'ENSMUSG00000024068', u'ENSMUSG00000064302', u'ENSMUSG00000068744', u'ENSMUSG00000038943', u'ENSMUSG00000058690', u'ENSMUSG00000023009', u'ENSMUSG00000052727', u'ENSMUSG00000033949', u'ENSMUSG00000014846', u'ENSMUSG00000066306', u'ENSMUSG00000015222', u'ENSMUSG00000039298']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001580', NS='BP', enrichment='e', name='detection of chemical stimulus involved in sensory perception of bitter taste', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000033355']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000033355', u'ENSMUSG00000040061']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001649', NS='BP', enrichment='e', name='osteoblast differentiation', ratio_in_study=(5, 624), ratio_in_pop=(85, 13836), p_uncorrected=0.4362745386312687, depth=4, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000035455', u'ENSMUSG00000054675', u'ENSMUSG00000042699', u'ENSMUSG00000006445', u'ENSMUSG00000031885']), pop_n=13836, pop_count=85, pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000055723', u'ENSMUSG00000022702', u'ENSMUSG00000074637', u'ENSMUSG00000020716', u'ENSMUSG00000038264', u'ENSMUSG00000028364', u'ENSMUSG00000027951', u'ENSMUSG00000001424', u'ENSMUSG00000063457', u'ENSMUSG00000005846', u'ENSMUSG00000020695', u'ENSMUSG00000038375', u'ENSMUSG00000042699', u'ENSMUSG00000073676', u'ENSMUSG00000051920', u'ENSMUSG00000027803', u'ENSMUSG00000025153', u'ENSMUSG00000028766', u'ENSMUSG00000048402', u'ENSMUSG00000040856', u'ENSMUSG00000032560', u'ENSMUSG00000001761', u'ENSMUSG00000028932', u'ENSMUSG00000024515', u'ENSMUSG00000024462', u'ENSMUSG00000021943', u'ENSMUSG00000027230', u'ENSMUSG00000026697', u'ENSMUSG00000027985', u'ENSMUSG00000032423', u'ENSMUSG00000038845', u'ENSMUSG00000020650', u'ENSMUSG00000040359', u'ENSMUSG00000032402', u'ENSMUSG00000001119', u'ENSMUSG00000039630', u'ENSMUSG00000050953', u'ENSMUSG00000001729', u'ENSMUSG00000001506', u'ENSMUSG00000005583', u'ENSMUSG00000003429', u'ENSMUSG00000027358', u'ENSMUSG00000006958', u'ENSMUSG00000020053', u'ENSMUSG00000020621', u'ENSMUSG00000037851', u'ENSMUSG00000024176', u'ENSMUSG00000020372', u'ENSMUSG00000031134', u'ENSMUSG00000028195', u'ENSMUSG00000039153', u'ENSMUSG00000060743', u'ENSMUSG00000020427', u'ENSMUSG00000001419', u'ENSMUSG00000016559', u'ENSMUSG00000027778', u'ENSMUSG00000029335', u'ENSMUSG00000031885', u'ENSMUSG00000052837', u'ENSMUSG00000004637', u'ENSMUSG00000006445', u'ENSMUSG00000026185', u'ENSMUSG00000029304', u'ENSMUSG00000021149', u'ENSMUSG00000024507', u'ENSMUSG00000027187', u'ENSMUSG00000025393', u'ENSMUSG00000003660', u'ENSMUSG00000054675', u'ENSMUSG00000078622', u'ENSMUSG00000035455', u'ENSMUSG00000048616', u'ENSMUSG00000029287', u'ENSMUSG00000021835', u'ENSMUSG00000008136', u'ENSMUSG00000039004', u'ENSMUSG00000021614', u'ENSMUSG00000021974', u'ENSMUSG00000019857', u'ENSMUSG00000050199', u'ENSMUSG00000040463', u'ENSMUSG00000020075', u'ENSMUSG00000047126', u'ENSMUSG00000060373']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001650', NS='CC', enrichment='e', name='fibrillar center', ratio_in_study=(7, 624), ratio_in_pop=(107, 13836), p_uncorrected=0.3413399660390077, depth=6, study_count=7, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000023852', u'ENSMUSG00000024691', u'ENSMUSG00000020641', u'ENSMUSG00000031697', u'ENSMUSG00000037214', u'ENSMUSG00000035842', u'ENSMUSG00000021175']), pop_n=13836, pop_count=107, pop_items=set([u'ENSMUSG00000069920', u'ENSMUSG00000042590', u'ENSMUSG00000000902', u'ENSMUSG00000047989', u'ENSMUSG00000074781', u'ENSMUSG00000042694', u'ENSMUSG00000058886', u'ENSMUSG00000041560', u'ENSMUSG00000022246', u'ENSMUSG00000015120', u'ENSMUSG00000020064', u'ENSMUSG00000027552', u'ENSMUSG00000038128', u'ENSMUSG00000033326', u'ENSMUSG00000027016', u'ENSMUSG00000050244', u'ENSMUSG00000049957', u'ENSMUSG00000042502', u'ENSMUSG00000022255', u'ENSMUSG00000020941', u'ENSMUSG00000000078', u'ENSMUSG00000026380', u'ENSMUSG00000022009', u'ENSMUSG00000027405', u'ENSMUSG00000038332', u'ENSMUSG00000049470', u'ENSMUSG00000021326', u'ENSMUSG00000055762', u'ENSMUSG00000024691', u'ENSMUSG00000018449', u'ENSMUSG00000035842', u'ENSMUSG00000020532', u'ENSMUSG00000031715', u'ENSMUSG00000026020', u'ENSMUSG00000026021', u'ENSMUSG00000024212', u'ENSMUSG00000068874', u'ENSMUSG00000023852', u'ENSMUSG00000028318', u'ENSMUSG00000008575', u'ENSMUSG00000025925', u'ENSMUSG00000039929', u'ENSMUSG00000063568', u'ENSMUSG00000055053', u'ENSMUSG00000031403', u'ENSMUSG00000024613', u'ENSMUSG00000020219', u'ENSMUSG00000026234', u'ENSMUSG00000020641', u'ENSMUSG00000038187', u'ENSMUSG00000021500', u'ENSMUSG00000042487', u'ENSMUSG00000070031', u'ENSMUSG00000036923', u'ENSMUSG00000040325', u'ENSMUSG00000003131', u'ENSMUSG00000004996', u'ENSMUSG00000070544', u'ENSMUSG00000033047', u'ENSMUSG00000041438', u'ENSMUSG00000026127', u'ENSMUSG00000027509', u'ENSMUSG00000028975', u'ENSMUSG00000032594', u'ENSMUSG00000052397', u'ENSMUSG00000025269', u'ENSMUSG00000020032', u'ENSMUSG00000029407', u'ENSMUSG00000063787', u'ENSMUSG00000033020', u'ENSMUSG00000037214', u'ENSMUSG00000022150', u'ENSMUSG00000030002', u'ENSMUSG00000074923', u'ENSMUSG00000061024', u'ENSMUSG00000025880', u'ENSMUSG00000033983', u'ENSMUSG00000047649', u'ENSMUSG00000031832', u'ENSMUSG00000054321', u'ENSMUSG00000047030', u'ENSMUSG00000003119', u'ENSMUSG00000003154', u'ENSMUSG00000025077', u'ENSMUSG00000049950', u'ENSMUSG00000023947', u'ENSMUSG00000032688', u'ENSMUSG00000041747', u'ENSMUSG00000060098', u'ENSMUSG00000025409', u'ENSMUSG00000024400', u'ENSMUSG00000041057', u'ENSMUSG00000039158', u'ENSMUSG00000009535', u'ENSMUSG00000020250', u'ENSMUSG00000008333', u'ENSMUSG00000036686', u'ENSMUSG00000024781', u'ENSMUSG00000039087', u'ENSMUSG00000027998', u'ENSMUSG00000041444', u'ENSMUSG00000025665', u'ENSMUSG00000020923', u'ENSMUSG00000031697', u'ENSMUSG00000021175', u'ENSMUSG00000021938', u'ENSMUSG00000021838']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001655', NS='BP', enrichment='e', name='urogenital system development', ratio_in_study=(1, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.3087700161198612, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025001']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000048616', u'ENSMUSG00000026836', u'ENSMUSG00000038000', u'ENSMUSG00000052534', u'ENSMUSG00000005958', u'ENSMUSG00000028664', u'ENSMUSG00000025001']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001658', NS='BP', enrichment='p', name='branching involved in ureteric bud morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(27, 13836), p_uncorrected=1.0, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039994']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000025932', u'ENSMUSG00000040998', u'ENSMUSG00000021318', u'ENSMUSG00000049538', u'ENSMUSG00000022346', u'ENSMUSG00000039994', u'ENSMUSG00000006932', u'ENSMUSG00000052534', u'ENSMUSG00000036862', u'ENSMUSG00000015647', u'ENSMUSG00000022770', u'ENSMUSG00000027358', u'ENSMUSG00000027439', u'ENSMUSG00000005087', u'ENSMUSG00000021466', u'ENSMUSG00000055653', u'ENSMUSG00000004791', u'ENSMUSG00000046743', u'ENSMUSG00000031665', u'ENSMUSG00000031980', u'ENSMUSG00000000567', u'ENSMUSG00000057329', u'ENSMUSG00000024515', u'ENSMUSG00000028988', u'ENSMUSG00000036856', u'ENSMUSG00000021835', u'ENSMUSG00000030890']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001660', NS='BP', enrichment='e', name='fever generation', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027399']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000027399', u'ENSMUSG00000040016']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001666', NS='BP', enrichment='e', name='response to hypoxia', ratio_in_study=(5, 624), ratio_in_pop=(97, 13836), p_uncorrected=0.6264562916977504, depth=5, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000036986', u'ENSMUSG00000020108', u'ENSMUSG00000005413', u'ENSMUSG00000034218', u'ENSMUSG00000037313']), pop_n=13836, pop_count=97, pop_items=set([u'ENSMUSG00000032115', u'ENSMUSG00000015522', u'ENSMUSG00000022178', u'ENSMUSG00000026791', u'ENSMUSG00000030592', u'ENSMUSG00000021820', u'ENSMUSG00000021109', u'ENSMUSG00000054640', u'ENSMUSG00000063142', u'ENSMUSG00000030209', u'ENSMUSG00000026814', u'ENSMUSG00000039239', u'ENSMUSG00000058709', u'ENSMUSG00000000441', u'ENSMUSG00000037313', u'ENSMUSG00000024962', u'ENSMUSG00000002496', u'ENSMUSG00000032259', u'ENSMUSG00000057367', u'ENSMUSG00000042429', u'ENSMUSG00000078566', u'ENSMUSG00000005413', u'ENSMUSG00000020108', u'ENSMUSG00000026826', u'ENSMUSG00000022383', u'ENSMUSG00000032485', u'ENSMUSG00000027950', u'ENSMUSG00000015709', u'ENSMUSG00000036986', u'ENSMUSG00000030287', u'ENSMUSG00000024515', u'ENSMUSG00000032648', u'ENSMUSG00000004070', u'ENSMUSG00000020048', u'ENSMUSG00000032402', u'ENSMUSG00000072941', u'ENSMUSG00000031393', u'ENSMUSG00000002280', u'ENSMUSG00000039217', u'ENSMUSG00000004791', u'ENSMUSG00000039910', u'ENSMUSG00000055024', u'ENSMUSG00000025239', u'ENSMUSG00000030774', u'ENSMUSG00000029135', u'ENSMUSG00000057880', u'ENSMUSG00000034218', u'ENSMUSG00000047139', u'ENSMUSG00000031380', u'ENSMUSG00000020716', u'ENSMUSG00000006362', u'ENSMUSG00000020828', u'ENSMUSG00000030525', u'ENSMUSG00000021226', u'ENSMUSG00000033685', u'ENSMUSG00000057530', u'ENSMUSG00000031902', u'ENSMUSG00000026354', u'ENSMUSG00000034205', u'ENSMUSG00000018634', u'ENSMUSG00000020230', u'ENSMUSG00000076431', u'ENSMUSG00000021253', u'ENSMUSG00000021822', u'ENSMUSG00000021313', u'ENSMUSG00000029084', u'ENSMUSG00000072115', u'ENSMUSG00000038418', u'ENSMUSG00000068040', u'ENSMUSG00000025888', u'ENSMUSG00000027187', u'ENSMUSG00000042650', u'ENSMUSG00000035000', u'ENSMUSG00000032060', u'ENSMUSG00000033933', u'ENSMUSG00000031616', u'ENSMUSG00000026576', u'ENSMUSG00000053819', u'ENSMUSG00000029648', u'ENSMUSG00000031538', u'ENSMUSG00000027358', u'ENSMUSG00000004328', u'ENSMUSG00000027577', u'ENSMUSG00000026641', u'ENSMUSG00000031740', u'ENSMUSG00000030102', u'ENSMUSG00000052593', u'ENSMUSG00000031987', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000036459', u'ENSMUSG00000025040', u'ENSMUSG00000025270', u'ENSMUSG00000024140', u'ENSMUSG00000007655', u'ENSMUSG00000052889', u'ENSMUSG00000014776']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001669', NS='CC', enrichment='p', name='acrosomal vesicle', ratio_in_study=(1, 624), ratio_in_pop=(43, 13836), p_uncorrected=1.0, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027326']), pop_n=13836, pop_count=43, pop_items=set([u'ENSMUSG00000021665', u'ENSMUSG00000072770', u'ENSMUSG00000039202', u'ENSMUSG00000040093', u'ENSMUSG00000026923', u'ENSMUSG00000052920', u'ENSMUSG00000005672', u'ENSMUSG00000022620', u'ENSMUSG00000027660', u'ENSMUSG00000003863', u'ENSMUSG00000039254', u'ENSMUSG00000042284', u'ENSMUSG00000032334', u'ENSMUSG00000003814', u'ENSMUSG00000046192', u'ENSMUSG00000005469', u'ENSMUSG00000021771', u'ENSMUSG00000032359', u'ENSMUSG00000021040', u'ENSMUSG00000037815', u'ENSMUSG00000031840', u'ENSMUSG00000026480', u'ENSMUSG00000038023', u'ENSMUSG00000025809', u'ENSMUSG00000046707', u'ENSMUSG00000058626', u'ENSMUSG00000029447', u'ENSMUSG00000016493', u'ENSMUSG00000068039', u'ENSMUSG00000030249', u'ENSMUSG00000026018', u'ENSMUSG00000028745', u'ENSMUSG00000032259', u'ENSMUSG00000027326', u'ENSMUSG00000050074', u'ENSMUSG00000033487', u'ENSMUSG00000033949', u'ENSMUSG00000022865', u'ENSMUSG00000027248', u'ENSMUSG00000022106', u'ENSMUSG00000027363', u'ENSMUSG00000039781', u'ENSMUSG00000025532']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001673', NS='CC', enrichment='e', name='male germ cell nucleus', ratio_in_study=(5, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.00011162420557807725, depth=7, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=0.0094256439398348445, study_items=set([u'ENSMUSG00000036928', u'ENSMUSG00000021569', u'ENSMUSG00000030528', u'ENSMUSG00000049932', u'ENSMUSG00000032555']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000021569', u'ENSMUSG00000029430', u'ENSMUSG00000049932', u'ENSMUSG00000032555', u'ENSMUSG00000059970', u'ENSMUSG00000031921', u'ENSMUSG00000021245', u'ENSMUSG00000036928', u'ENSMUSG00000023999', u'ENSMUSG00000030528', u'ENSMUSG00000000751']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set(['GO:0043081'])),
    NtGoeaResults(GO='GO:0001701', NS='BP', enrichment='e', name='in utero embryonic development', ratio_in_study=(13, 624), ratio_in_pop=(222, 13836), p_uncorrected=0.32523162581252, depth=7, study_count=13, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028718', u'ENSMUSG00000028224', u'ENSMUSG00000042557', u'ENSMUSG00000041431', u'ENSMUSG00000032218', u'ENSMUSG00000027109', u'ENSMUSG00000022587', u'ENSMUSG00000004846', u'ENSMUSG00000059552', u'ENSMUSG00000005566', u'ENSMUSG00000024912', u'ENSMUSG00000008976', u'ENSMUSG00000044702']), pop_n=13836, pop_count=222, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000048583', u'ENSMUSG00000059898', u'ENSMUSG00000021660', u'ENSMUSG00000019373', u'ENSMUSG00000021669', u'ENSMUSG00000016481', u'ENSMUSG00000027381', u'ENSMUSG00000059552', u'ENSMUSG00000001280', u'ENSMUSG00000002799', u'ENSMUSG00000029106', u'ENSMUSG00000030189', u'ENSMUSG00000036333', u'ENSMUSG00000018678', u'ENSMUSG00000001761', u'ENSMUSG00000028933', u'ENSMUSG00000018160', u'ENSMUSG00000053754', u'ENSMUSG00000032220', u'ENSMUSG00000006932', u'ENSMUSG00000021796', u'ENSMUSG00000051910', u'ENSMUSG00000070644', u'ENSMUSG00000028821', u'ENSMUSG00000000378', u'ENSMUSG00000024176', u'ENSMUSG00000039834', u'ENSMUSG00000020611', u'ENSMUSG00000003402', u'ENSMUSG00000024163', u'ENSMUSG00000039234', u'ENSMUSG00000030209', u'ENSMUSG00000022353', u'ENSMUSG00000021217', u'ENSMUSG00000035478', u'ENSMUSG00000005566', u'ENSMUSG00000022414', u'ENSMUSG00000036427', u'ENSMUSG00000046985', u'ENSMUSG00000053580', u'ENSMUSG00000033061', u'ENSMUSG00000027878', u'ENSMUSG00000018379', u'ENSMUSG00000000751', u'ENSMUSG00000063659', u'ENSMUSG00000029287', u'ENSMUSG00000024563', u'ENSMUSG00000021615', u'ENSMUSG00000038593', u'ENSMUSG00000033940', u'ENSMUSG00000026383', u'ENSMUSG00000025921', u'ENSMUSG00000054611', u'ENSMUSG00000035203', u'ENSMUSG00000024294', u'ENSMUSG00000001783', u'ENSMUSG00000009569', u'ENSMUSG00000027951', u'ENSMUSG00000015709', u'ENSMUSG00000052310', u'ENSMUSG00000039656', u'ENSMUSG00000024912', u'ENSMUSG00000046532', u'ENSMUSG00000048402', u'ENSMUSG00000029231', u'ENSMUSG00000021268', u'ENSMUSG00000022309', u'ENSMUSG00000022556', u'ENSMUSG00000024515', u'ENSMUSG00000001173', u'ENSMUSG00000022306', u'ENSMUSG00000022150', u'ENSMUSG00000074656', u'ENSMUSG00000004364', u'ENSMUSG00000032402', u'ENSMUSG00000051747', u'ENSMUSG00000023988', u'ENSMUSG00000015337', u'ENSMUSG00000004931', u'ENSMUSG00000039367', u'ENSMUSG00000028718', u'ENSMUSG00000021466', u'ENSMUSG00000069763', u'ENSMUSG00000024620', u'ENSMUSG00000026726', u'ENSMUSG00000039910', u'ENSMUSG00000026254', u'ENSMUSG00000026836', u'ENSMUSG00000031558', u'ENSMUSG00000030849', u'ENSMUSG00000042557', u'ENSMUSG00000008976', u'ENSMUSG00000000303', u'ENSMUSG00000028894', u'ENSMUSG00000049717', u'ENSMUSG00000048616', u'ENSMUSG00000030779', u'ENSMUSG00000052837', u'ENSMUSG00000032366', u'ENSMUSG00000030519', u'ENSMUSG00000051510', u'ENSMUSG00000024182', u'ENSMUSG00000007613', u'ENSMUSG00000041688', u'ENSMUSG00000004846', u'ENSMUSG00000024750', u'ENSMUSG00000031951', u'ENSMUSG00000050017', u'ENSMUSG00000003518', u'ENSMUSG00000007817', u'ENSMUSG00000026923', u'ENSMUSG00000041235', u'ENSMUSG00000047824', u'ENSMUSG00000026739', u'ENSMUSG00000020718', u'ENSMUSG00000020346', u'ENSMUSG00000088088', u'ENSMUSG00000033282', u'ENSMUSG00000037369', u'ENSMUSG00000032187', u'ENSMUSG00000055148', u'ENSMUSG00000033726', u'ENSMUSG00000022528', u'ENSMUSG00000022443', u'ENSMUSG00000030652', u'ENSMUSG00000018537', u'ENSMUSG00000020918', u'ENSMUSG00000041431', u'ENSMUSG00000030551', u'ENSMUSG00000030067', u'ENSMUSG00000022382', u'ENSMUSG00000000532', u'ENSMUSG00000048154', u'ENSMUSG00000000530', u'ENSMUSG00000079036', u'ENSMUSG00000001151', u'ENSMUSG00000029390', u'ENSMUSG00000000149', u'ENSMUSG00000029394', u'ENSMUSG00000028978', u'ENSMUSG00000015605', u'ENSMUSG00000049252', u'ENSMUSG00000026207', u'ENSMUSG00000021258', u'ENSMUSG00000075232', u'ENSMUSG00000021253', u'ENSMUSG00000025809', u'ENSMUSG00000021255', u'ENSMUSG00000046822', u'ENSMUSG00000024807', u'ENSMUSG00000072720', u'ENSMUSG00000021318', u'ENSMUSG00000036180', u'ENSMUSG00000037434', u'ENSMUSG00000033006', u'ENSMUSG00000024085', u'ENSMUSG00000001036', u'ENSMUSG00000029655', u'ENSMUSG00000047248', u'ENSMUSG00000020900', u'ENSMUSG00000032218', u'ENSMUSG00000037890', u'ENSMUSG00000001039', u'ENSMUSG00000027109', u'ENSMUSG00000050953', u'ENSMUSG00000030400', u'ENSMUSG00000033191', u'ENSMUSG00000066595', u'ENSMUSG00000022682', u'ENSMUSG00000006127', u'ENSMUSG00000091780', u'ENSMUSG00000029478', u'ENSMUSG00000016933', u'ENSMUSG00000027684', u'ENSMUSG00000054693', u'ENSMUSG00000018395', u'ENSMUSG00000032855', u'ENSMUSG00000031446', u'ENSMUSG00000031616', u'ENSMUSG00000040857', u'ENSMUSG00000044702', u'ENSMUSG00000032119', u'ENSMUSG00000025485', u'ENSMUSG00000031010', u'ENSMUSG00000018604', u'ENSMUSG00000003308', u'ENSMUSG00000031565', u'ENSMUSG00000020936', u'ENSMUSG00000032440', u'ENSMUSG00000036940', u'ENSMUSG00000041540', u'ENSMUSG00000022952', u'ENSMUSG00000024897', u'ENSMUSG00000024151', u'ENSMUSG00000035569', u'ENSMUSG00000027358', u'ENSMUSG00000069917', u'ENSMUSG00000069919', u'ENSMUSG00000032633', u'ENSMUSG00000063524', u'ENSMUSG00000044308', u'ENSMUSG00000015846', u'ENSMUSG00000027002', u'ENSMUSG00000005973', u'ENSMUSG00000050295', u'ENSMUSG00000037622', u'ENSMUSG00000023951', u'ENSMUSG00000020390', u'ENSMUSG00000028639', u'ENSMUSG00000027763', u'ENSMUSG00000048450', u'ENSMUSG00000075254', u'ENSMUSG00000031921', u'ENSMUSG00000022587', u'ENSMUSG00000007659', u'ENSMUSG00000074221', u'ENSMUSG00000039662', u'ENSMUSG00000014773', u'ENSMUSG00000070002', u'ENSMUSG00000021932', u'ENSMUSG00000016308']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001702', NS='BP', enrichment='e', name='gastrulation with mouth forming second', ratio_in_study=(1, 624), ratio_in_pop=(20, 13836), p_uncorrected=0.602919746446321, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029201']), pop_n=13836, pop_count=20, pop_items=set([u'ENSMUSG00000020170', u'ENSMUSG00000026484', u'ENSMUSG00000021488', u'ENSMUSG00000024515', u'ENSMUSG00000057103', u'ENSMUSG00000029201', u'ENSMUSG00000030201', u'ENSMUSG00000044548', u'ENSMUSG00000061393', u'ENSMUSG00000026836', u'ENSMUSG00000006932', u'ENSMUSG00000025223', u'ENSMUSG00000048078', u'ENSMUSG00000041688', u'ENSMUSG00000052155', u'ENSMUSG00000028517', u'ENSMUSG00000006215', u'ENSMUSG00000024913', u'ENSMUSG00000006958', u'ENSMUSG00000016028']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0010003', 'GO:0048276'])),
    NtGoeaResults(GO='GO:0001725', NS='CC', enrichment='p', name='stress fiber', ratio_in_study=(2, 624), ratio_in_pop=(64, 13836), p_uncorrected=1.0, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029580', u'ENSMUSG00000005057']), pop_n=13836, pop_count=64, pop_items=set([u'ENSMUSG00000022836', u'ENSMUSG00000053093', u'ENSMUSG00000070462', u'ENSMUSG00000034574', u'ENSMUSG00000034868', u'ENSMUSG00000024835', u'ENSMUSG00000021998', u'ENSMUSG00000004665', u'ENSMUSG00000036718', u'ENSMUSG00000022995', u'ENSMUSG00000059248', u'ENSMUSG00000001833', u'ENSMUSG00000029860', u'ENSMUSG00000026556', u'ENSMUSG00000020388', u'ENSMUSG00000005057', u'ENSMUSG00000021493', u'ENSMUSG00000024603', u'ENSMUSG00000006386', u'ENSMUSG00000050315', u'ENSMUSG00000022443', u'ENSMUSG00000034201', u'ENSMUSG00000035305', u'ENSMUSG00000021823', u'ENSMUSG00000032322', u'ENSMUSG00000037712', u'ENSMUSG00000006519', u'ENSMUSG00000015143', u'ENSMUSG00000024048', u'ENSMUSG00000035783', u'ENSMUSG00000058056', u'ENSMUSG00000054808', u'ENSMUSG00000027940', u'ENSMUSG00000025085', u'ENSMUSG00000025006', u'ENSMUSG00000029528', u'ENSMUSG00000072214', u'ENSMUSG00000031605', u'ENSMUSG00000041688', u'ENSMUSG00000029580', u'ENSMUSG00000029581', u'ENSMUSG00000022090', u'ENSMUSG00000043733', u'ENSMUSG00000032231', u'ENSMUSG00000026303', u'ENSMUSG00000068270', u'ENSMUSG00000031523', u'ENSMUSG00000030739', u'ENSMUSG00000022607', u'ENSMUSG00000020900', u'ENSMUSG00000026131', u'ENSMUSG00000005417', u'ENSMUSG00000067818', u'ENSMUSG00000030583', u'ENSMUSG00000025278', u'ENSMUSG00000018830', u'ENSMUSG00000058013', u'ENSMUSG00000031972', u'ENSMUSG00000023022', u'ENSMUSG00000043079', u'ENSMUSG00000030890', u'ENSMUSG00000032735', u'ENSMUSG00000041731', u'ENSMUSG00000031799']), study_n=624, level=5, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001726', NS='CC', enrichment='p', name='ruffle', ratio_in_study=(2, 624), ratio_in_pop=(77, 13836), p_uncorrected=0.5855620792312969, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027115', u'ENSMUSG00000005057']), pop_n=13836, pop_count=77, pop_items=set([u'ENSMUSG00000024013', u'ENSMUSG00000020173', u'ENSMUSG00000026925', u'ENSMUSG00000024290', u'ENSMUSG00000002059', u'ENSMUSG00000020717', u'ENSMUSG00000023905', u'ENSMUSG00000016933', u'ENSMUSG00000026842', u'ENSMUSG00000058056', u'ENSMUSG00000033763', u'ENSMUSG00000024397', u'ENSMUSG00000062352', u'ENSMUSG00000020476', u'ENSMUSG00000021998', u'ENSMUSG00000030064', u'ENSMUSG00000009073', u'ENSMUSG00000022443', u'ENSMUSG00000018001', u'ENSMUSG00000027002', u'ENSMUSG00000034593', u'ENSMUSG00000005057', u'ENSMUSG00000021493', u'ENSMUSG00000026024', u'ENSMUSG00000034570', u'ENSMUSG00000029516', u'ENSMUSG00000049076', u'ENSMUSG00000001025', u'ENSMUSG00000033577', u'ENSMUSG00000050357', u'ENSMUSG00000025504', u'ENSMUSG00000051735', u'ENSMUSG00000003269', u'ENSMUSG00000030881', u'ENSMUSG00000027523', u'ENSMUSG00000006154', u'ENSMUSG00000015143', u'ENSMUSG00000040274', u'ENSMUSG00000052397', u'ENSMUSG00000030269', u'ENSMUSG00000028583', u'ENSMUSG00000017831', u'ENSMUSG00000061665', u'ENSMUSG00000006273', u'ENSMUSG00000028868', u'ENSMUSG00000021549', u'ENSMUSG00000036995', u'ENSMUSG00000032050', u'ENSMUSG00000041688', u'ENSMUSG00000004677', u'ENSMUSG00000030536', u'ENSMUSG00000033066', u'ENSMUSG00000028465', u'ENSMUSG00000020857', u'ENSMUSG00000025265', u'ENSMUSG00000026879', u'ENSMUSG00000031078', u'ENSMUSG00000052698', u'ENSMUSG00000044147', u'ENSMUSG00000025609', u'ENSMUSG00000032231', u'ENSMUSG00000029581', u'ENSMUSG00000030774', u'ENSMUSG00000027115', u'ENSMUSG00000031337', u'ENSMUSG00000026341', u'ENSMUSG00000030733', u'ENSMUSG00000033208', u'ENSMUSG00000022272', u'ENSMUSG00000024451', u'ENSMUSG00000031955', u'ENSMUSG00000058587', u'ENSMUSG00000068566', u'ENSMUSG00000027247', u'ENSMUSG00000029359', u'ENSMUSG00000006127', u'ENSMUSG00000027365']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001730', NS='MF', enrichment='e', name="2'-5'-oligoadenylate synthetase activity", ratio_in_study=(2, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.018543260222111523, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.52005991830484444, study_items=set([u'ENSMUSG00000029561', u'ENSMUSG00000032661']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000029561', u'ENSMUSG00000032661', u'ENSMUSG00000066861', u'ENSMUSG00000032690', u'ENSMUSG00000052776']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001732', NS='BP', enrichment='e', name='formation of cytoplasmic translation initiation complex', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024991']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000024991', u'ENSMUSG00000016554']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001736', NS='BP', enrichment='e', name='establishment of planar polarity', ratio_in_study=(1, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.5223055970896804, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037188']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000037188', u'ENSMUSG00000026556', u'ENSMUSG00000021013', u'ENSMUSG00000022297', u'ENSMUSG00000063810', u'ENSMUSG00000023972', u'ENSMUSG00000033282', u'ENSMUSG00000001105', u'ENSMUSG00000036862', u'ENSMUSG00000046743', u'ENSMUSG00000007989', u'ENSMUSG00000021994', u'ENSMUSG00000000881', u'ENSMUSG00000039801', u'ENSMUSG00000011658', u'ENSMUSG00000016028']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001739', NS='CC', enrichment='e', name='sex chromatin', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000017548']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000018537', u'ENSMUSG00000030619', u'ENSMUSG00000026484', u'ENSMUSG00000040669', u'ENSMUSG00000024325', u'ENSMUSG00000017548']), study_n=624, level=7, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001741', NS='CC', enrichment='e', name='XY body', ratio_in_study=(7, 624), ratio_in_pop=(17, 13836), p_uncorrected=4.804111827681834e-06, depth=7, study_count=7, p_sm_bonferroni=0.07545338036557088, p_fdr_bh=0.0005894795341060225, study_items=set([u'ENSMUSG00000022034', u'ENSMUSG00000002307', u'ENSMUSG00000030254', u'ENSMUSG00000000037', u'ENSMUSG00000049932', u'ENSMUSG00000032409', u'ENSMUSG00000025758']), pop_n=13836, pop_count=17, pop_items=set([u'ENSMUSG00000032409', u'ENSMUSG00000031622', u'ENSMUSG00000049932', u'ENSMUSG00000020390', u'ENSMUSG00000057367', u'ENSMUSG00000000902', u'ENSMUSG00000022710', u'ENSMUSG00000026021', u'ENSMUSG00000032481', u'ENSMUSG00000002307', u'ENSMUSG00000000037', u'ENSMUSG00000020661', u'ENSMUSG00000031860', u'ENSMUSG00000030254', u'ENSMUSG00000022034', u'ENSMUSG00000016308', u'ENSMUSG00000025758']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001750', NS='CC', enrichment='p', name='photoreceptor outer segment', ratio_in_study=(1, 624), ratio_in_pop=(37, 13836), p_uncorrected=1.0, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020599']), pop_n=13836, pop_count=37, pop_items=set([u'ENSMUSG00000022837', u'ENSMUSG00000037325', u'ENSMUSG00000041794', u'ENSMUSG00000052613', u'ENSMUSG00000037541', u'ENSMUSG00000032202', u'ENSMUSG00000034593', u'ENSMUSG00000020284', u'ENSMUSG00000030701', u'ENSMUSG00000001173', u'ENSMUSG00000047250', u'ENSMUSG00000029064', u'ENSMUSG00000050965', u'ENSMUSG00000049044', u'ENSMUSG00000020599', u'ENSMUSG00000027254', u'ENSMUSG00000024169', u'ENSMUSG00000037493', u'ENSMUSG00000075256', u'ENSMUSG00000031174', u'ENSMUSG00000029086', u'ENSMUSG00000032192', u'ENSMUSG00000023484', u'ENSMUSG00000042064', u'ENSMUSG00000014361', u'ENSMUSG00000032968', u'ENSMUSG00000031450', u'ENSMUSG00000019986', u'ENSMUSG00000019889', u'ENSMUSG00000048439', u'ENSMUSG00000056055', u'ENSMUSG00000028125', u'ENSMUSG00000025235', u'ENSMUSG00000052727', u'ENSMUSG00000071648', u'ENSMUSG00000019971', u'ENSMUSG00000001105']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001756', NS='BP', enrichment='e', name='somitogenesis', ratio_in_study=(3, 624), ratio_in_pop=(36, 13836), p_uncorrected=0.22027003562402103, depth=5, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000034218', u'ENSMUSG00000044702']), pop_n=13836, pop_count=36, pop_items=set([u'ENSMUSG00000024294', u'ENSMUSG00000050295', u'ENSMUSG00000034064', u'ENSMUSG00000029570', u'ENSMUSG00000046020', u'ENSMUSG00000028780', u'ENSMUSG00000059552', u'ENSMUSG00000021994', u'ENSMUSG00000044702', u'ENSMUSG00000020918', u'ENSMUSG00000027002', u'ENSMUSG00000010609', u'ENSMUSG00000028933', u'ENSMUSG00000020692', u'ENSMUSG00000027985', u'ENSMUSG00000021796', u'ENSMUSG00000029390', u'ENSMUSG00000032402', u'ENSMUSG00000019969', u'ENSMUSG00000000142', u'ENSMUSG00000058835', u'ENSMUSG00000026640', u'ENSMUSG00000030201', u'ENSMUSG00000022672', u'ENSMUSG00000026872', u'ENSMUSG00000055024', u'ENSMUSG00000014773', u'ENSMUSG00000039191', u'ENSMUSG00000031548', u'ENSMUSG00000036422', u'ENSMUSG00000051747', u'ENSMUSG00000035403', u'ENSMUSG00000034218', u'ENSMUSG00000032419', u'ENSMUSG00000026383', u'ENSMUSG00000079487']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001764', NS='BP', enrichment='e', name='neuron migration', ratio_in_study=(6, 624), ratio_in_pop=(103, 13836), p_uncorrected=0.47094527011566434, depth=5, study_count=6, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032128', u'ENSMUSG00000003873', u'ENSMUSG00000045136', u'ENSMUSG00000035764', u'ENSMUSG00000033952', u'ENSMUSG00000020108']), pop_n=13836, pop_count=103, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000003873', u'ENSMUSG00000026504', u'ENSMUSG00000029207', u'ENSMUSG00000048895', u'ENSMUSG00000061353', u'ENSMUSG00000032036', u'ENSMUSG00000031292', u'ENSMUSG00000006932', u'ENSMUSG00000042766', u'ENSMUSG00000042453', u'ENSMUSG00000033952', u'ENSMUSG00000019969', u'ENSMUSG00000005583', u'ENSMUSG00000027797', u'ENSMUSG00000045136', u'ENSMUSG00000024969', u'ENSMUSG00000037251', u'ENSMUSG00000042292', u'ENSMUSG00000060534', u'ENSMUSG00000020108', u'ENSMUSG00000026620', u'ENSMUSG00000023473', u'ENSMUSG00000020745', u'ENSMUSG00000026826', u'ENSMUSG00000009569', u'ENSMUSG00000020849', u'ENSMUSG00000028414', u'ENSMUSG00000020283', u'ENSMUSG00000028883', u'ENSMUSG00000022305', u'ENSMUSG00000043051', u'ENSMUSG00000035764', u'ENSMUSG00000049001', u'ENSMUSG00000016028', u'ENSMUSG00000020052', u'ENSMUSG00000005069', u'ENSMUSG00000025235', u'ENSMUSG00000031010', u'ENSMUSG00000006464', u'ENSMUSG00000030077', u'ENSMUSG00000035910', u'ENSMUSG00000069171', u'ENSMUSG00000009376', u'ENSMUSG00000035277', u'ENSMUSG00000074505', u'ENSMUSG00000038331', u'ENSMUSG00000031517', u'ENSMUSG00000030551', u'ENSMUSG00000002602', u'ENSMUSG00000062232', u'ENSMUSG00000018736', u'ENSMUSG00000079036', u'ENSMUSG00000001151', u'ENSMUSG00000022324', u'ENSMUSG00000066235', u'ENSMUSG00000015605', u'ENSMUSG00000025810', u'ENSMUSG00000022031', u'ENSMUSG00000025969', u'ENSMUSG00000056222', u'ENSMUSG00000031137', u'ENSMUSG00000009418', u'ENSMUSG00000026587', u'ENSMUSG00000007989', u'ENSMUSG00000043557', u'ENSMUSG00000019843', u'ENSMUSG00000022607', u'ENSMUSG00000020900', u'ENSMUSG00000020902', u'ENSMUSG00000032340', u'ENSMUSG00000050953', u'ENSMUSG00000037605', u'ENSMUSG00000053024', u'ENSMUSG00000019647', u'ENSMUSG00000028969', u'ENSMUSG00000006711', u'ENSMUSG00000033585', u'ENSMUSG00000019794', u'ENSMUSG00000020003', u'ENSMUSG00000052920', u'ENSMUSG00000028519', u'ENSMUSG00000045382', u'ENSMUSG00000018411', u'ENSMUSG00000017485', u'ENSMUSG00000020770', u'ENSMUSG00000001507', u'ENSMUSG00000090071', u'ENSMUSG00000059146', u'ENSMUSG00000021270', u'ENSMUSG00000031592', u'ENSMUSG00000068740', u'ENSMUSG00000031451', u'ENSMUSG00000022678', u'ENSMUSG00000055254', u'ENSMUSG00000037032', u'ENSMUSG00000027168', u'ENSMUSG00000032128', u'ENSMUSG00000029673', u'ENSMUSG00000031285', u'ENSMUSG00000032532', u'ENSMUSG00000040374', u'ENSMUSG00000021936']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001772', NS='CC', enrichment='p', name='immunological synapse', ratio_in_study=(1, 624), ratio_in_pop=(25, 13836), p_uncorrected=1.0, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037405']), pop_n=13836, pop_count=25, pop_items=set([u'ENSMUSG00000030798', u'ENSMUSG00000056153', u'ENSMUSG00000019998', u'ENSMUSG00000025132', u'ENSMUSG00000029204', u'ENSMUSG00000022443', u'ENSMUSG00000030707', u'ENSMUSG00000050335', u'ENSMUSG00000032504', u'ENSMUSG00000050357', u'ENSMUSG00000026778', u'ENSMUSG00000022770', u'ENSMUSG00000020612', u'ENSMUSG00000052397', u'ENSMUSG00000028191', u'ENSMUSG00000037405', u'ENSMUSG00000028136', u'ENSMUSG00000022636', u'ENSMUSG00000028455', u'ENSMUSG00000025314', u'ENSMUSG00000026117', u'ENSMUSG00000020399', u'ENSMUSG00000003518', u'ENSMUSG00000037706', u'ENSMUSG00000040747']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001774', NS='BP', enrichment='e', name='microglial cell activation', ratio_in_study=(2, 624), ratio_in_pop=(14, 13836), p_uncorrected=0.12928950843456594, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000030786', u'ENSMUSG00000052684']), pop_n=13836, pop_count=14, pop_items=set([u'ENSMUSG00000025889', u'ENSMUSG00000025888', u'ENSMUSG00000045322', u'ENSMUSG00000052336', u'ENSMUSG00000030786', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000024397', u'ENSMUSG00000031639', u'ENSMUSG00000044583', u'ENSMUSG00000022037', u'ENSMUSG00000052684', u'ENSMUSG00000031778', u'ENSMUSG00000039005']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001775', NS='BP', enrichment='e', name='cell activation', ratio_in_study=(1, 624), ratio_in_pop=(10, 13836), p_uncorrected=0.36974924624400735, depth=2, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000001131']), pop_n=13836, pop_count=10, pop_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000044827', u'ENSMUSG00000002603', u'ENSMUSG00000027995', u'ENSMUSG00000026193', u'ENSMUSG00000001131', u'ENSMUSG00000032679', u'ENSMUSG00000026344', u'ENSMUSG00000047139', u'ENSMUSG00000068686']), study_n=624, level=2, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001776', NS='BP', enrichment='e', name='leukocyte homeostasis', ratio_in_study=(2, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.03667181122637655, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000057789', u'ENSMUSG00000003873']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000042817', u'ENSMUSG00000057789', u'ENSMUSG00000057329', u'ENSMUSG00000027381', u'ENSMUSG00000024947', u'ENSMUSG00000029371']), study_n=624, level=2, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001777', NS='BP', enrichment='e', name='T cell homeostatic proliferation', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000003873']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000003873']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001779', NS='BP', enrichment='e', name='natural killer cell differentiation', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027109']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000020167', u'ENSMUSG00000073889', u'ENSMUSG00000020919', u'ENSMUSG00000010054', u'ENSMUSG00000002602', u'ENSMUSG00000004043', u'ENSMUSG00000018654', u'ENSMUSG00000035247', u'ENSMUSG00000027109', u'ENSMUSG00000020644', u'ENSMUSG00000014361', u'ENSMUSG00000027298']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001781', NS='BP', enrichment='e', name='neutrophil apoptotic process', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000030786']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000030786', u'ENSMUSG00000045502']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001782', NS='BP', enrichment='e', name='B cell homeostasis', ratio_in_study=(2, 624), ratio_in_pop=(22, 13836), p_uncorrected=0.26122083018435993, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000057789', u'ENSMUSG00000003873']), pop_n=13836, pop_count=22, pop_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000075376', u'ENSMUSG00000038608', u'ENSMUSG00000027381', u'ENSMUSG00000034801', u'ENSMUSG00000031628', u'ENSMUSG00000057672', u'ENSMUSG00000031537', u'ENSMUSG00000004221', u'ENSMUSG00000005583', u'ENSMUSG00000057789', u'ENSMUSG00000021022', u'ENSMUSG00000058818', u'ENSMUSG00000039936', u'ENSMUSG00000031093', u'ENSMUSG00000019256', u'ENSMUSG00000042228', u'ENSMUSG00000022488', u'ENSMUSG00000024241', u'ENSMUSG00000057329', u'ENSMUSG00000040423', u'ENSMUSG00000040447']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001783', NS='BP', enrichment='e', name='B cell apoptotic process', ratio_in_study=(2, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.03667181122637655, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000057789', u'ENSMUSG00000003873']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000028191', u'ENSMUSG00000003873', u'ENSMUSG00000022346', u'ENSMUSG00000027381', u'ENSMUSG00000023915', u'ENSMUSG00000057789', u'ENSMUSG00000057672']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001816', NS='BP', enrichment='e', name='cytokine production', ratio_in_study=(1, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.5223055970896804, depth=2, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000067586']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000055435', u'ENSMUSG00000045322', u'ENSMUSG00000031400', u'ENSMUSG00000003847', u'ENSMUSG00000034610', u'ENSMUSG00000020275', u'ENSMUSG00000059883', u'ENSMUSG00000027544', u'ENSMUSG00000032114', u'ENSMUSG00000067586', u'ENSMUSG00000027347', u'ENSMUSG00000039285', u'ENSMUSG00000024781', u'ENSMUSG00000056529', u'ENSMUSG00000029371', u'ENSMUSG00000030722']), study_n=624, level=2, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001818', NS='BP', enrichment='e', name='negative regulation of cytokine production', ratio_in_study=(1, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.33996234399139486, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000006445']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000024098', u'ENSMUSG00000074272', u'ENSMUSG00000026177', u'ENSMUSG00000002602', u'ENSMUSG00000028163', u'ENSMUSG00000004558', u'ENSMUSG00000029816', u'ENSMUSG00000014361', u'ENSMUSG00000006445']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001819', NS='BP', enrichment='e', name='positive regulation of cytokine production', ratio_in_study=(2, 624), ratio_in_pop=(18, 13836), p_uncorrected=0.19373476853783986, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024079', u'ENSMUSG00000001123']), pop_n=13836, pop_count=18, pop_items=set([u'ENSMUSG00000034254', u'ENSMUSG00000058099', u'ENSMUSG00000026922', u'ENSMUSG00000047810', u'ENSMUSG00000026672', u'ENSMUSG00000024079', u'ENSMUSG00000020399', u'ENSMUSG00000028701', u'ENSMUSG00000030059', u'ENSMUSG00000020134', u'ENSMUSG00000026177', u'ENSMUSG00000033717', u'ENSMUSG00000059714', u'ENSMUSG00000001123', u'ENSMUSG00000031639', u'ENSMUSG00000021994', u'ENSMUSG00000022982', u'ENSMUSG00000040856']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001822', NS='BP', enrichment='e', name='kidney development', ratio_in_study=(4, 624), ratio_in_pop=(81, 13836), p_uncorrected=0.7856129336427371, depth=4, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039994', u'ENSMUSG00000026605', u'ENSMUSG00000003873', u'ENSMUSG00000011179']), pop_n=13836, pop_count=81, pop_items=set([u'ENSMUSG00000036862', u'ENSMUSG00000050295', u'ENSMUSG00000029436', u'ENSMUSG00000003873', u'ENSMUSG00000050332', u'ENSMUSG00000029994', u'ENSMUSG00000024392', u'ENSMUSG00000025035', u'ENSMUSG00000033282', u'ENSMUSG00000008999', u'ENSMUSG00000018395', u'ENSMUSG00000027381', u'ENSMUSG00000019947', u'ENSMUSG00000022893', u'ENSMUSG00000020692', u'ENSMUSG00000016918', u'ENSMUSG00000045515', u'ENSMUSG00000047824', u'ENSMUSG00000040943', u'ENSMUSG00000040040', u'ENSMUSG00000031665', u'ENSMUSG00000031644', u'ENSMUSG00000024515', u'ENSMUSG00000039994', u'ENSMUSG00000032220', u'ENSMUSG00000024620', u'ENSMUSG00000039474', u'ENSMUSG00000006932', u'ENSMUSG00000001151', u'ENSMUSG00000032327', u'ENSMUSG00000034462', u'ENSMUSG00000061393', u'ENSMUSG00000042460', u'ENSMUSG00000052516', u'ENSMUSG00000027253', u'ENSMUSG00000062563', u'ENSMUSG00000034101', u'ENSMUSG00000039004', u'ENSMUSG00000020319', u'ENSMUSG00000028344', u'ENSMUSG00000022292', u'ENSMUSG00000026812', u'ENSMUSG00000074733', u'ENSMUSG00000071711', u'ENSMUSG00000044042', u'ENSMUSG00000034292', u'ENSMUSG00000026768', u'ENSMUSG00000039239', u'ENSMUSG00000005871', u'ENSMUSG00000055653', u'ENSMUSG00000014303', u'ENSMUSG00000048402', u'ENSMUSG00000037003', u'ENSMUSG00000046743', u'ENSMUSG00000029705', u'ENSMUSG00000020681', u'ENSMUSG00000021318', u'ENSMUSG00000023951', u'ENSMUSG00000006800', u'ENSMUSG00000035342', u'ENSMUSG00000056962', u'ENSMUSG00000034910', u'ENSMUSG00000027187', u'ENSMUSG00000037664', u'ENSMUSG00000032558', u'ENSMUSG00000057329', u'ENSMUSG00000042797', u'ENSMUSG00000027777', u'ENSMUSG00000031980', u'ENSMUSG00000024713', u'ENSMUSG00000020097', u'ENSMUSG00000007613', u'ENSMUSG00000021835', u'ENSMUSG00000011179', u'ENSMUSG00000027204', u'ENSMUSG00000026605', u'ENSMUSG00000034640', u'ENSMUSG00000039801', u'ENSMUSG00000001105', u'ENSMUSG00000021650', u'ENSMUSG00000032855']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001824', NS='BP', enrichment='e', name='blastocyst development', ratio_in_study=(3, 624), ratio_in_pop=(20, 13836), p_uncorrected=0.058805205553011115, depth=3, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.98547485107011223, study_items=set([u'ENSMUSG00000026622', u'ENSMUSG00000035293', u'ENSMUSG00000028693']), pop_n=13836, pop_count=20, pop_items=set([u'ENSMUSG00000029655', u'ENSMUSG00000026576', u'ENSMUSG00000019470', u'ENSMUSG00000004268', u'ENSMUSG00000002102', u'ENSMUSG00000035293', u'ENSMUSG00000000902', u'ENSMUSG00000004359', u'ENSMUSG00000030603', u'ENSMUSG00000037475', u'ENSMUSG00000022174', u'ENSMUSG00000007613', u'ENSMUSG00000029287', u'ENSMUSG00000034274', u'ENSMUSG00000028693', u'ENSMUSG00000026622', u'ENSMUSG00000011958', u'ENSMUSG00000029062', u'ENSMUSG00000030291', u'ENSMUSG00000026509']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001829', NS='BP', enrichment='e', name='trophectodermal cell differentiation', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027109']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000020166', u'ENSMUSG00000000303', u'ENSMUSG00000001280', u'ENSMUSG00000052837', u'ENSMUSG00000059325', u'ENSMUSG00000027109', u'ENSMUSG00000005609', u'ENSMUSG00000039910', u'ENSMUSG00000035632', u'ENSMUSG00000015605', u'ENSMUSG00000023988', u'ENSMUSG00000036550']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001832', NS='BP', enrichment='e', name='blastocyst growth', ratio_in_study=(2, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.03667181122637655, depth=3, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000024486']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000024486', u'ENSMUSG00000029547', u'ENSMUSG00000027304', u'ENSMUSG00000005609', u'ENSMUSG00000032187', u'ENSMUSG00000046010']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001833', NS='BP', enrichment='e', name='inner cell mass cell proliferation', ratio_in_study=(5, 624), ratio_in_pop=(14, 13836), p_uncorrected=0.0002616703282067204, depth=2, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=0.020245291501550498, study_items=set([u'ENSMUSG00000032113', u'ENSMUSG00000042029', u'ENSMUSG00000041147', u'ENSMUSG00000027454', u'ENSMUSG00000044702']), pop_n=13836, pop_count=14, pop_items=set([u'ENSMUSG00000032078', u'ENSMUSG00000031546', u'ENSMUSG00000029547', u'ENSMUSG00000032113', u'ENSMUSG00000024735', u'ENSMUSG00000015697', u'ENSMUSG00000023980', u'ENSMUSG00000027454', u'ENSMUSG00000041147', u'ENSMUSG00000042029', u'ENSMUSG00000025337', u'ENSMUSG00000018736', u'ENSMUSG00000024002', u'ENSMUSG00000044702']), study_n=624, level=2, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001835', NS='BP', enrichment='e', name='blastocyst hatching', ratio_in_study=(2, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.011467047866411785, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000034708', u'ENSMUSG00000041238']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000000902', u'ENSMUSG00000034708', u'ENSMUSG00000032187', u'ENSMUSG00000041238']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001836', NS='BP', enrichment='e', name='release of cytochrome c from mitochondria', ratio_in_study=(7, 624), ratio_in_pop=(20, 13836), p_uncorrected=1.7006735838089953e-05, depth=6, study_count=7, p_sm_bonferroni=0.26710779307304078, p_fdr_bh=0.0018549152296738944, study_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000059552', u'ENSMUSG00000004446', u'ENSMUSG00000057789', u'ENSMUSG00000052684']), pop_n=13836, pop_count=20, pop_items=set([u'ENSMUSG00000026278', u'ENSMUSG00000019054', u'ENSMUSG00000020366', u'ENSMUSG00000003873', u'ENSMUSG00000059552', u'ENSMUSG00000002083', u'ENSMUSG00000029026', u'ENSMUSG00000024521', u'ENSMUSG00000033792', u'ENSMUSG00000006818', u'ENSMUSG00000022789', u'ENSMUSG00000002797', u'ENSMUSG00000032532', u'ENSMUSG00000007659', u'ENSMUSG00000004446', u'ENSMUSG00000024959', u'ENSMUSG00000057789', u'ENSMUSG00000057329', u'ENSMUSG00000003438', u'ENSMUSG00000052684']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001837', NS='BP', enrichment='p', name='epithelial to mesenchymal transition', ratio_in_study=(1, 624), ratio_in_pop=(29, 13836), p_uncorrected=1.0, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005566']), pop_n=13836, pop_count=29, pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000020719', u'ENSMUSG00000020846', u'ENSMUSG00000029287', u'ENSMUSG00000033016', u'ENSMUSG00000030849', u'ENSMUSG00000048616', u'ENSMUSG00000000693', u'ENSMUSG00000002603', u'ENSMUSG00000027985', u'ENSMUSG00000038545', u'ENSMUSG00000034205', u'ENSMUSG00000021109', u'ENSMUSG00000033953', u'ENSMUSG00000027358', u'ENSMUSG00000022812', u'ENSMUSG00000020358', u'ENSMUSG00000039239', u'ENSMUSG00000005566', u'ENSMUSG00000055065', u'ENSMUSG00000019487', u'ENSMUSG00000027654', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000031328', u'ENSMUSG00000048450', u'ENSMUSG00000007613', u'ENSMUSG00000021782', u'ENSMUSG00000026383']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001843', NS='BP', enrichment='e', name='neural tube closure', ratio_in_study=(5, 624), ratio_in_pop=(88, 13836), p_uncorrected=0.5998914247508733, depth=5, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028718', u'ENSMUSG00000037188', u'ENSMUSG00000027315', u'ENSMUSG00000019979', u'ENSMUSG00000024795']), pop_n=13836, pop_count=88, pop_items=set([u'ENSMUSG00000029199', u'ENSMUSG00000007989', u'ENSMUSG00000001288', u'ENSMUSG00000022568', u'ENSMUSG00000014232', u'ENSMUSG00000029050', u'ENSMUSG00000026556', u'ENSMUSG00000058230', u'ENSMUSG00000040675', u'ENSMUSG00000036606', u'ENSMUSG00000070509', u'ENSMUSG00000034121', u'ENSMUSG00000026812', u'ENSMUSG00000030201', u'ENSMUSG00000061524', u'ENSMUSG00000079487', u'ENSMUSG00000002496', u'ENSMUSG00000008859', u'ENSMUSG00000020580', u'ENSMUSG00000079259', u'ENSMUSG00000037992', u'ENSMUSG00000038564', u'ENSMUSG00000022995', u'ENSMUSG00000027002', u'ENSMUSG00000041703', u'ENSMUSG00000000247', u'ENSMUSG00000027315', u'ENSMUSG00000021048', u'ENSMUSG00000071226', u'ENSMUSG00000016028', u'ENSMUSG00000021466', u'ENSMUSG00000054611', u'ENSMUSG00000039910', u'ENSMUSG00000032965', u'ENSMUSG00000039765', u'ENSMUSG00000036158', u'ENSMUSG00000025235', u'ENSMUSG00000029381', u'ENSMUSG00000004768', u'ENSMUSG00000030796', u'ENSMUSG00000026842', u'ENSMUSG00000026596', u'ENSMUSG00000037369', u'ENSMUSG00000028266', u'ENSMUSG00000021994', u'ENSMUSG00000030403', u'ENSMUSG00000028718', u'ENSMUSG00000020918', u'ENSMUSG00000007880', u'ENSMUSG00000026121', u'ENSMUSG00000002603', u'ENSMUSG00000029390', u'ENSMUSG00000005469', u'ENSMUSG00000066043', u'ENSMUSG00000001521', u'ENSMUSG00000011658', u'ENSMUSG00000022297', u'ENSMUSG00000030323', u'ENSMUSG00000035247', u'ENSMUSG00000029276', u'ENSMUSG00000023972', u'ENSMUSG00000031995', u'ENSMUSG00000031548', u'ENSMUSG00000047407', u'ENSMUSG00000020173', u'ENSMUSG00000038084', u'ENSMUSG00000025231', u'ENSMUSG00000024795', u'ENSMUSG00000037188', u'ENSMUSG00000020888', u'ENSMUSG00000058886', u'ENSMUSG00000005034', u'ENSMUSG00000044791', u'ENSMUSG00000061477', u'ENSMUSG00000017009', u'ENSMUSG00000028191', u'ENSMUSG00000039239', u'ENSMUSG00000026872', u'ENSMUSG00000031665', u'ENSMUSG00000019979', u'ENSMUSG00000031523', u'ENSMUSG00000001052', u'ENSMUSG00000027164', u'ENSMUSG00000027070', u'ENSMUSG00000048616', u'ENSMUSG00000021835', u'ENSMUSG00000018293', u'ENSMUSG00000074227']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001844', NS='BP', enrichment='e', name='protein insertion into mitochondrial membrane involved in apoptotic signaling pathway', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000003873']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000003873']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001846', NS='MF', enrichment='e', name='opsonin binding', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000030786']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000030786', u'ENSMUSG00000027087']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001851', NS='MF', enrichment='e', name='complement component C3b binding', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000030786']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000030786', u'ENSMUSG00000038845', u'ENSMUSG00000026365', u'ENSMUSG00000000290']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001886', NS='BP', enrichment='e', name='endothelial cell morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000004846']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000040040', u'ENSMUSG00000020717', u'ENSMUSG00000075254', u'ENSMUSG00000001435', u'ENSMUSG00000004846', u'ENSMUSG00000042745', u'ENSMUSG00000036885', u'ENSMUSG00000014813', u'ENSMUSG00000037242', u'ENSMUSG00000022025', u'ENSMUSG00000015468']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001889', NS='BP', enrichment='e', name='liver development', ratio_in_study=(3, 624), ratio_in_pop=(53, 13836), p_uncorrected=0.5165145692674249, depth=5, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027109', u'ENSMUSG00000001517', u'ENSMUSG00000052684']), pop_n=13836, pop_count=53, pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000026923', u'ENSMUSG00000020173', u'ENSMUSG00000030314', u'ENSMUSG00000020716', u'ENSMUSG00000009569', u'ENSMUSG00000033282', u'ENSMUSG00000001930', u'ENSMUSG00000019256', u'ENSMUSG00000001280', u'ENSMUSG00000028864', u'ENSMUSG00000022528', u'ENSMUSG00000021268', u'ENSMUSG00000052684', u'ENSMUSG00000024927', u'ENSMUSG00000029482', u'ENSMUSG00000040040', u'ENSMUSG00000020919', u'ENSMUSG00000027665', u'ENSMUSG00000018160', u'ENSMUSG00000019802', u'ENSMUSG00000006818', u'ENSMUSG00000032076', u'ENSMUSG00000043241', u'ENSMUSG00000032402', u'ENSMUSG00000022952', u'ENSMUSG00000032855', u'ENSMUSG00000071711', u'ENSMUSG00000003402', u'ENSMUSG00000034462', u'ENSMUSG00000034175', u'ENSMUSG00000034957', u'ENSMUSG00000001517', u'ENSMUSG00000040888', u'ENSMUSG00000044147', u'ENSMUSG00000062908', u'ENSMUSG00000039662', u'ENSMUSG00000023830', u'ENSMUSG00000038518', u'ENSMUSG00000027878', u'ENSMUSG00000024085', u'ENSMUSG00000045991', u'ENSMUSG00000020484', u'ENSMUSG00000027109', u'ENSMUSG00000029287', u'ENSMUSG00000032294', u'ENSMUSG00000043866', u'ENSMUSG00000001247', u'ENSMUSG00000039910', u'ENSMUSG00000025533', u'ENSMUSG00000025907', u'ENSMUSG00000021650', u'ENSMUSG00000032187']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001890', NS='BP', enrichment='e', name='placenta development', ratio_in_study=(3, 624), ratio_in_pop=(27, 13836), p_uncorrected=0.12013868061444093, depth=4, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020185', u'ENSMUSG00000046179', u'ENSMUSG00000072082']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000001783', u'ENSMUSG00000024073', u'ENSMUSG00000001930', u'ENSMUSG00000072082', u'ENSMUSG00000003031', u'ENSMUSG00000023944', u'ENSMUSG00000038545', u'ENSMUSG00000002250', u'ENSMUSG00000079036', u'ENSMUSG00000070644', u'ENSMUSG00000092035', u'ENSMUSG00000014426', u'ENSMUSG00000073889', u'ENSMUSG00000020185', u'ENSMUSG00000042323', u'ENSMUSG00000046179', u'ENSMUSG00000027878', u'ENSMUSG00000040138', u'ENSMUSG00000037664', u'ENSMUSG00000073988', u'ENSMUSG00000037411', u'ENSMUSG00000015846', u'ENSMUSG00000057367', u'ENSMUSG00000053436', u'ENSMUSG00000028495', u'ENSMUSG00000006205']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001892', NS='BP', enrichment='e', name='embryonic placenta development', ratio_in_study=(2, 624), ratio_in_pop=(24, 13836), p_uncorrected=0.29517625400189107, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027109', u'ENSMUSG00000027315']), pop_n=13836, pop_count=24, pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000048583', u'ENSMUSG00000040481', u'ENSMUSG00000032855', u'ENSMUSG00000001280', u'ENSMUSG00000015522', u'ENSMUSG00000034957', u'ENSMUSG00000022556', u'ENSMUSG00000018160', u'ENSMUSG00000027315', u'ENSMUSG00000035247', u'ENSMUSG00000029390', u'ENSMUSG00000034462', u'ENSMUSG00000021109', u'ENSMUSG00000054640', u'ENSMUSG00000021255', u'ENSMUSG00000039910', u'ENSMUSG00000020122', u'ENSMUSG00000000489', u'ENSMUSG00000073988', u'ENSMUSG00000027109', u'ENSMUSG00000024140', u'ENSMUSG00000023990', u'ENSMUSG00000056501']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001917', NS='CC', enrichment='p', name='photoreceptor inner segment', ratio_in_study=(1, 624), ratio_in_pop=(25, 13836), p_uncorrected=1.0, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020599']), pop_n=13836, pop_count=25, pop_items=set([u'ENSMUSG00000026825', u'ENSMUSG00000040265', u'ENSMUSG00000029361', u'ENSMUSG00000037541', u'ENSMUSG00000033335', u'ENSMUSG00000004267', u'ENSMUSG00000066441', u'ENSMUSG00000049044', u'ENSMUSG00000035504', u'ENSMUSG00000037493', u'ENSMUSG00000067889', u'ENSMUSG00000075256', u'ENSMUSG00000020599', u'ENSMUSG00000027900', u'ENSMUSG00000012819', u'ENSMUSG00000042064', u'ENSMUSG00000032968', u'ENSMUSG00000040860', u'ENSMUSG00000029064', u'ENSMUSG00000031732', u'ENSMUSG00000056055', u'ENSMUSG00000025235', u'ENSMUSG00000032192', u'ENSMUSG00000015656', u'ENSMUSG00000039137']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001922', NS='BP', enrichment='e', name='B-1 B cell homeostasis', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005057']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000021109', u'ENSMUSG00000019850', u'ENSMUSG00000026842', u'ENSMUSG00000005057', u'ENSMUSG00000019256']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001932', NS='BP', enrichment='e', name='regulation of protein phosphorylation', ratio_in_study=(4, 624), ratio_in_pop=(58, 13836), p_uncorrected=0.3336437880187561, depth=8, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000036986', u'ENSMUSG00000040033', u'ENSMUSG00000028893', u'ENSMUSG00000027323']), pop_n=13836, pop_count=58, pop_items=set([u'ENSMUSG00000050310', u'ENSMUSG00000032601', u'ENSMUSG00000020349', u'ENSMUSG00000032740', u'ENSMUSG00000070871', u'ENSMUSG00000038976', u'ENSMUSG00000025855', u'ENSMUSG00000021478', u'ENSMUSG00000020573', u'ENSMUSG00000020413', u'ENSMUSG00000021182', u'ENSMUSG00000026193', u'ENSMUSG00000045322', u'ENSMUSG00000027323', u'ENSMUSG00000029071', u'ENSMUSG00000044340', u'ENSMUSG00000024256', u'ENSMUSG00000041560', u'ENSMUSG00000018651', u'ENSMUSG00000053914', u'ENSMUSG00000000127', u'ENSMUSG00000036606', u'ENSMUSG00000041936', u'ENSMUSG00000037526', u'ENSMUSG00000061175', u'ENSMUSG00000053113', u'ENSMUSG00000004951', u'ENSMUSG00000024777', u'ENSMUSG00000004936', u'ENSMUSG00000027253', u'ENSMUSG00000020612', u'ENSMUSG00000020053', u'ENSMUSG00000049583', u'ENSMUSG00000043448', u'ENSMUSG00000029687', u'ENSMUSG00000032633', u'ENSMUSG00000048930', u'ENSMUSG00000060216', u'ENSMUSG00000004530', u'ENSMUSG00000044583', u'ENSMUSG00000059409', u'ENSMUSG00000035992', u'ENSMUSG00000028893', u'ENSMUSG00000057455', u'ENSMUSG00000025583', u'ENSMUSG00000036986', u'ENSMUSG00000028991', u'ENSMUSG00000027852', u'ENSMUSG00000022607', u'ENSMUSG00000041415', u'ENSMUSG00000032253', u'ENSMUSG00000024182', u'ENSMUSG00000002997', u'ENSMUSG00000038855', u'ENSMUSG00000040033', u'ENSMUSG00000035027', u'ENSMUSG00000023473', u'ENSMUSG00000021764']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001933', NS='BP', enrichment='p', name='negative regulation of protein phosphorylation', ratio_in_study=(2, 624), ratio_in_pop=(80, 13836), p_uncorrected=0.587036085186408, depth=9, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000022033', u'ENSMUSG00000041431']), pop_n=13836, pop_count=80, pop_items=set([u'ENSMUSG00000045658', u'ENSMUSG00000020361', u'ENSMUSG00000013663', u'ENSMUSG00000020349', u'ENSMUSG00000079363', u'ENSMUSG00000041459', u'ENSMUSG00000055725', u'ENSMUSG00000028300', u'ENSMUSG00000006369', u'ENSMUSG00000026883', u'ENSMUSG00000021266', u'ENSMUSG00000023826', u'ENSMUSG00000028664', u'ENSMUSG00000005534', u'ENSMUSG00000029071', u'ENSMUSG00000046062', u'ENSMUSG00000028416', u'ENSMUSG00000057672', u'ENSMUSG00000032966', u'ENSMUSG00000050965', u'ENSMUSG00000035941', u'ENSMUSG00000046186', u'ENSMUSG00000010609', u'ENSMUSG00000034160', u'ENSMUSG00000027006', u'ENSMUSG00000002603', u'ENSMUSG00000041995', u'ENSMUSG00000068566', u'ENSMUSG00000030525', u'ENSMUSG00000037526', u'ENSMUSG00000019960', u'ENSMUSG00000014077', u'ENSMUSG00000068037', u'ENSMUSG00000078429', u'ENSMUSG00000019969', u'ENSMUSG00000018909', u'ENSMUSG00000022033', u'ENSMUSG00000034292', u'ENSMUSG00000024423', u'ENSMUSG00000024066', u'ENSMUSG00000027168', u'ENSMUSG00000059146', u'ENSMUSG00000079037', u'ENSMUSG00000026483', u'ENSMUSG00000030201', u'ENSMUSG00000041734', u'ENSMUSG00000068154', u'ENSMUSG00000020427', u'ENSMUSG00000033430', u'ENSMUSG00000004530', u'ENSMUSG00000022672', u'ENSMUSG00000025340', u'ENSMUSG00000041431', u'ENSMUSG00000024947', u'ENSMUSG00000022309', u'ENSMUSG00000027803', u'ENSMUSG00000029167', u'ENSMUSG00000042228', u'ENSMUSG00000003099', u'ENSMUSG00000028517', u'ENSMUSG00000002496', u'ENSMUSG00000025889', u'ENSMUSG00000028991', u'ENSMUSG00000027030', u'ENSMUSG00000005699', u'ENSMUSG00000032841', u'ENSMUSG00000034889', u'ENSMUSG00000036273', u'ENSMUSG00000026176', u'ENSMUSG00000032959', u'ENSMUSG00000028964', u'ENSMUSG00000047409', u'ENSMUSG00000019428', u'ENSMUSG00000019823', u'ENSMUSG00000036915', u'ENSMUSG00000031558', u'ENSMUSG00000018669', u'ENSMUSG00000060216', u'ENSMUSG00000006127', u'ENSMUSG00000030538']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001934', NS='BP', enrichment='p', name='positive regulation of protein phosphorylation', ratio_in_study=(3, 624), ratio_in_pop=(156, 13836), p_uncorrected=0.16904562740547407, depth=9, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000002307', u'ENSMUSG00000028068', u'ENSMUSG00000029521']), pop_n=13836, pop_count=156, pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000027765', u'ENSMUSG00000019579', u'ENSMUSG00000059714', u'ENSMUSG00000019997', u'ENSMUSG00000029616', u'ENSMUSG00000038119', u'ENSMUSG00000004056', u'ENSMUSG00000037526', u'ENSMUSG00000070348', u'ENSMUSG00000037523', u'ENSMUSG00000067336', u'ENSMUSG00000020614', u'ENSMUSG00000019969', u'ENSMUSG00000058594', u'ENSMUSG00000013921', u'ENSMUSG00000020623', u'ENSMUSG00000020372', u'ENSMUSG00000026814', u'ENSMUSG00000024164', u'ENSMUSG00000066129', u'ENSMUSG00000021408', u'ENSMUSG00000071369', u'ENSMUSG00000002948', u'ENSMUSG00000042228', u'ENSMUSG00000000567', u'ENSMUSG00000040016', u'ENSMUSG00000002307', u'ENSMUSG00000066551', u'ENSMUSG00000021057', u'ENSMUSG00000022847', u'ENSMUSG00000020580', u'ENSMUSG00000024778', u'ENSMUSG00000061436', u'ENSMUSG00000020366', u'ENSMUSG00000044674', u'ENSMUSG00000041936', u'ENSMUSG00000027954', u'ENSMUSG00000018209', u'ENSMUSG00000015837', u'ENSMUSG00000006699', u'ENSMUSG00000029468', u'ENSMUSG00000001847', u'ENSMUSG00000052593', u'ENSMUSG00000041417', u'ENSMUSG00000022150', u'ENSMUSG00000006386', u'ENSMUSG00000022855', u'ENSMUSG00000027523', u'ENSMUSG00000036904', u'ENSMUSG00000018909', u'ENSMUSG00000030265', u'ENSMUSG00000020357', u'ENSMUSG00000009281', u'ENSMUSG00000055024', u'ENSMUSG00000042249', u'ENSMUSG00000025147', u'ENSMUSG00000061878', u'ENSMUSG00000030774', u'ENSMUSG00000033307', u'ENSMUSG00000024610', u'ENSMUSG00000057531', u'ENSMUSG00000035992', u'ENSMUSG00000024182', u'ENSMUSG00000020484', u'ENSMUSG00000052155', u'ENSMUSG00000029816', u'ENSMUSG00000024454', u'ENSMUSG00000020122', u'ENSMUSG00000069874', u'ENSMUSG00000042632', u'ENSMUSG00000014547', u'ENSMUSG00000034165', u'ENSMUSG00000034160', u'ENSMUSG00000042817', u'ENSMUSG00000021451', u'ENSMUSG00000028068', u'ENSMUSG00000026842', u'ENSMUSG00000030525', u'ENSMUSG00000031639', u'ENSMUSG00000021994', u'ENSMUSG00000025584', u'ENSMUSG00000027584', u'ENSMUSG00000036273', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000024621', u'ENSMUSG00000051615', u'ENSMUSG00000000148', u'ENSMUSG00000001729', u'ENSMUSG00000000142', u'ENSMUSG00000032171', u'ENSMUSG00000063065', u'ENSMUSG00000000838', u'ENSMUSG00000027692', u'ENSMUSG00000029394', u'ENSMUSG00000020063', u'ENSMUSG00000044716', u'ENSMUSG00000030538', u'ENSMUSG00000029471', u'ENSMUSG00000033352', u'ENSMUSG00000000441', u'ENSMUSG00000022607', u'ENSMUSG00000028871', u'ENSMUSG00000025499', u'ENSMUSG00000005417', u'ENSMUSG00000003233', u'ENSMUSG00000062312', u'ENSMUSG00000027347', u'ENSMUSG00000022122', u'ENSMUSG00000036295', u'ENSMUSG00000070509', u'ENSMUSG00000059970', u'ENSMUSG00000024397', u'ENSMUSG00000031750', u'ENSMUSG00000028289', u'ENSMUSG00000008734', u'ENSMUSG00000022892', u'ENSMUSG00000045382', u'ENSMUSG00000005534', u'ENSMUSG00000029071', u'ENSMUSG00000031616', u'ENSMUSG00000029521', u'ENSMUSG00000020888', u'ENSMUSG00000025162', u'ENSMUSG00000061374', u'ENSMUSG00000030720', u'ENSMUSG00000071984', u'ENSMUSG00000036585', u'ENSMUSG00000036106', u'ENSMUSG00000050965', u'ENSMUSG00000021846', u'ENSMUSG00000028991', u'ENSMUSG00000027358', u'ENSMUSG00000061603', u'ENSMUSG00000038264', u'ENSMUSG00000026483', u'ENSMUSG00000028195', u'ENSMUSG00000032633', u'ENSMUSG00000021549', u'ENSMUSG00000032841', u'ENSMUSG00000031451', u'ENSMUSG00000031667', u'ENSMUSG00000028756', u'ENSMUSG00000004451', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000000184', u'ENSMUSG00000032231', u'ENSMUSG00000022469', u'ENSMUSG00000030854', u'ENSMUSG00000027859', u'ENSMUSG00000028760', u'ENSMUSG00000021835', u'ENSMUSG00000060216', u'ENSMUSG00000025907']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001935', NS='BP', enrichment='e', name='endothelial cell proliferation', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037214']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000032462', u'ENSMUSG00000020715', u'ENSMUSG00000067336', u'ENSMUSG00000006386', u'ENSMUSG00000035725', u'ENSMUSG00000020484', u'ENSMUSG00000066551', u'ENSMUSG00000034205', u'ENSMUSG00000037214', u'ENSMUSG00000016494', u'ENSMUSG00000022770', u'ENSMUSG00000037936']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001937', NS='BP', enrichment='p', name='negative regulation of endothelial cell proliferation', ratio_in_study=(1, 624), ratio_in_pop=(24, 13836), p_uncorrected=1.0, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026104']), pop_n=13836, pop_count=24, pop_items=set([u'ENSMUSG00000020716', u'ENSMUSG00000028029', u'ENSMUSG00000090935', u'ENSMUSG00000016918', u'ENSMUSG00000054428', u'ENSMUSG00000030551', u'ENSMUSG00000033278', u'ENSMUSG00000000530', u'ENSMUSG00000002985', u'ENSMUSG00000018593', u'ENSMUSG00000026104', u'ENSMUSG00000022018', u'ENSMUSG00000024066', u'ENSMUSG00000026814', u'ENSMUSG00000021256', u'ENSMUSG00000040152', u'ENSMUSG00000000058', u'ENSMUSG00000025428', u'ENSMUSG00000007613', u'ENSMUSG00000050953', u'ENSMUSG00000037621', u'ENSMUSG00000007655', u'ENSMUSG00000000600', u'ENSMUSG00000022025']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001938', NS='BP', enrichment='p', name='positive regulation of endothelial cell proliferation', ratio_in_study=(2, 624), ratio_in_pop=(55, 13836), p_uncorrected=0.9999999999923503, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000054717', u'ENSMUSG00000052684']), pop_n=13836, pop_count=55, pop_items=set([u'ENSMUSG00000026921', u'ENSMUSG00000031380', u'ENSMUSG00000031385', u'ENSMUSG00000020716', u'ENSMUSG00000021681', u'ENSMUSG00000021576', u'ENSMUSG00000067336', u'ENSMUSG00000019579', u'ENSMUSG00000021994', u'ENSMUSG00000072115', u'ENSMUSG00000006519', u'ENSMUSG00000010175', u'ENSMUSG00000037568', u'ENSMUSG00000037754', u'ENSMUSG00000050310', u'ENSMUSG00000000530', u'ENSMUSG00000062960', u'ENSMUSG00000050965', u'ENSMUSG00000023034', u'ENSMUSG00000078202', u'ENSMUSG00000031841', u'ENSMUSG00000020063', u'ENSMUSG00000028991', u'ENSMUSG00000019772', u'ENSMUSG00000027358', u'ENSMUSG00000039004', u'ENSMUSG00000033730', u'ENSMUSG00000010797', u'ENSMUSG00000055633', u'ENSMUSG00000021702', u'ENSMUSG00000052684', u'ENSMUSG00000000489', u'ENSMUSG00000004791', u'ENSMUSG00000001729', u'ENSMUSG00000024962', u'ENSMUSG00000002688', u'ENSMUSG00000020357', u'ENSMUSG00000054717', u'ENSMUSG00000025583', u'ENSMUSG00000023951', u'ENSMUSG00000020689', u'ENSMUSG00000022231', u'ENSMUSG00000024854', u'ENSMUSG00000050711', u'ENSMUSG00000028108', u'ENSMUSG00000035385', u'ENSMUSG00000004043', u'ENSMUSG00000028128', u'ENSMUSG00000054252', u'ENSMUSG00000061353', u'ENSMUSG00000021835', u'ENSMUSG00000041187', u'ENSMUSG00000026078', u'ENSMUSG00000007655', u'ENSMUSG00000000058']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001939', NS='CC', enrichment='e', name='female pronucleus', ratio_in_study=(2, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.03667181122637655, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000027715', u'ENSMUSG00000036202']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000034832', u'ENSMUSG00000027715', u'ENSMUSG00000024045', u'ENSMUSG00000036202', u'ENSMUSG00000018666', u'ENSMUSG00000014767', u'ENSMUSG00000028645']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001940', NS='CC', enrichment='e', name='male pronucleus', ratio_in_study=(2, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.018543260222111523, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.52005991830484444, study_items=set([u'ENSMUSG00000027715', u'ENSMUSG00000036202']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000027715', u'ENSMUSG00000034832', u'ENSMUSG00000036202', u'ENSMUSG00000014767', u'ENSMUSG00000018666']), study_n=624, level=6, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001947', NS='BP', enrichment='p', name='heart looping', ratio_in_study=(1, 624), ratio_in_pop=(39, 13836), p_uncorrected=1.0, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028718']), pop_n=13836, pop_count=39, pop_items=set([u'ENSMUSG00000022911', u'ENSMUSG00000026923', u'ENSMUSG00000024294', u'ENSMUSG00000013584', u'ENSMUSG00000018395', u'ENSMUSG00000038564', u'ENSMUSG00000021994', u'ENSMUSG00000014232', u'ENSMUSG00000039963', u'ENSMUSG00000028718', u'ENSMUSG00000026556', u'ENSMUSG00000067860', u'ENSMUSG00000001827', u'ENSMUSG00000001761', u'ENSMUSG00000032440', u'ENSMUSG00000029390', u'ENSMUSG00000032402', u'ENSMUSG00000021109', u'ENSMUSG00000019969', u'ENSMUSG00000015605', u'ENSMUSG00000034462', u'ENSMUSG00000026814', u'ENSMUSG00000054611', u'ENSMUSG00000030201', u'ENSMUSG00000039910', u'ENSMUSG00000032965', u'ENSMUSG00000019986', u'ENSMUSG00000047248', u'ENSMUSG00000027878', u'ENSMUSG00000005583', u'ENSMUSG00000027676', u'ENSMUSG00000039191', u'ENSMUSG00000032558', u'ENSMUSG00000025231', u'ENSMUSG00000018604', u'ENSMUSG00000050953', u'ENSMUSG00000025902', u'ENSMUSG00000017858', u'ENSMUSG00000014773']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001964', NS='BP', enrichment='e', name='startle response', ratio_in_study=(1, 624), ratio_in_pop=(17, 13836), p_uncorrected=0.5438744326614349, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000019874']), pop_n=13836, pop_count=17, pop_items=set([u'ENSMUSG00000001988', u'ENSMUSG00000021010', u'ENSMUSG00000030209', u'ENSMUSG00000031393', u'ENSMUSG00000058248', u'ENSMUSG00000002771', u'ENSMUSG00000062991', u'ENSMUSG00000028020', u'ENSMUSG00000052613', u'ENSMUSG00000019874', u'ENSMUSG00000047976', u'ENSMUSG00000060924', u'ENSMUSG00000026959', u'ENSMUSG00000023826', u'ENSMUSG00000059003', u'ENSMUSG00000045573', u'ENSMUSG00000032259']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001965', NS='MF', enrichment='p', name='G-protein alpha-subunit binding', ratio_in_study=(1, 624), ratio_in_pop=(27, 13836), p_uncorrected=1.0, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027883']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000026930', u'ENSMUSG00000021478', u'ENSMUSG00000045730', u'ENSMUSG00000005533', u'ENSMUSG00000025485', u'ENSMUSG00000043301', u'ENSMUSG00000029101', u'ENSMUSG00000030844', u'ENSMUSG00000052087', u'ENSMUSG00000030824', u'ENSMUSG00000048376', u'ENSMUSG00000034997', u'ENSMUSG00000039358', u'ENSMUSG00000038668', u'ENSMUSG00000018634', u'ENSMUSG00000027883', u'ENSMUSG00000000766', u'ENSMUSG00000021721', u'ENSMUSG00000038530', u'ENSMUSG00000027523', u'ENSMUSG00000023830', u'ENSMUSG00000020524', u'ENSMUSG00000003099', u'ENSMUSG00000035620', u'ENSMUSG00000042671', u'ENSMUSG00000026360', u'ENSMUSG00000002458']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0001974', NS='BP', enrichment='e', name='blood vessel remodeling', ratio_in_study=(4, 624), ratio_in_pop=(34, 13836), p_uncorrected=0.06524222081906111, depth=3, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000057789', u'ENSMUSG00000003873', u'ENSMUSG00000020184']), pop_n=13836, pop_count=34, pop_items=set([u'ENSMUSG00000050295', u'ENSMUSG00000003873', u'ENSMUSG00000037820', u'ENSMUSG00000021732', u'ENSMUSG00000067336', u'ENSMUSG00000061393', u'ENSMUSG00000019256', u'ENSMUSG00000028780', u'ENSMUSG00000024039', u'ENSMUSG00000002602', u'ENSMUSG00000041235', u'ENSMUSG00000027314', u'ENSMUSG00000000530', u'ENSMUSG00000027276', u'ENSMUSG00000031902', u'ENSMUSG00000023951', u'ENSMUSG00000028978', u'ENSMUSG00000005583', u'ENSMUSG00000057789', u'ENSMUSG00000020053', u'ENSMUSG00000034394', u'ENSMUSG00000039239', u'ENSMUSG00000020184', u'ENSMUSG00000042323', u'ENSMUSG00000019880', u'ENSMUSG00000033792', u'ENSMUSG00000050541', u'ENSMUSG00000039191', u'ENSMUSG00000031328', u'ENSMUSG00000027009', u'ENSMUSG00000029287', u'ENSMUSG00000024140', u'ENSMUSG00000038160', u'ENSMUSG00000014776']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002009', NS='BP', enrichment='e', name='morphogenesis of an epithelium', ratio_in_study=(1, 624), ratio_in_pop=(10, 13836), p_uncorrected=0.36974924624400735, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039994']), pop_n=13836, pop_count=10, pop_items=set([u'ENSMUSG00000048402', u'ENSMUSG00000037016', u'ENSMUSG00000027562', u'ENSMUSG00000039994', u'ENSMUSG00000030201', u'ENSMUSG00000054252', u'ENSMUSG00000052613', u'ENSMUSG00000021823', u'ENSMUSG00000021994', u'ENSMUSG00000034687']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002020', NS='MF', enrichment='e', name='protease binding', ratio_in_study=(5, 624), ratio_in_pop=(86, 13836), p_uncorrected=0.5955806507095137, depth=4, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000028282', u'ENSMUSG00000041147', u'ENSMUSG00000001131', u'ENSMUSG00000022074']), pop_n=13836, pop_count=86, pop_items=set([u'ENSMUSG00000040249', u'ENSMUSG00000047866', u'ENSMUSG00000028108', u'ENSMUSG00000020696', u'ENSMUSG00000059714', u'ENSMUSG00000030695', u'ENSMUSG00000030111', u'ENSMUSG00000059552', u'ENSMUSG00000015850', u'ENSMUSG00000003161', u'ENSMUSG00000005054', u'ENSMUSG00000029661', u'ENSMUSG00000030592', u'ENSMUSG00000041607', u'ENSMUSG00000022074', u'ENSMUSG00000041147', u'ENSMUSG00000000392', u'ENSMUSG00000042185', u'ENSMUSG00000030793', u'ENSMUSG00000032386', u'ENSMUSG00000037411', u'ENSMUSG00000045827', u'ENSMUSG00000068129', u'ENSMUSG00000024778', u'ENSMUSG00000019850', u'ENSMUSG00000039041', u'ENSMUSG00000035000', u'ENSMUSG00000005672', u'ENSMUSG00000008348', u'ENSMUSG00000025209', u'ENSMUSG00000001666', u'ENSMUSG00000020044', u'ENSMUSG00000027087', u'ENSMUSG00000038473', u'ENSMUSG00000037075', u'ENSMUSG00000031628', u'ENSMUSG00000091971', u'ENSMUSG00000021585', u'ENSMUSG00000033307', u'ENSMUSG00000028128', u'ENSMUSG00000030077', u'ENSMUSG00000020484', u'ENSMUSG00000026031', u'ENSMUSG00000038224', u'ENSMUSG00000030317', u'ENSMUSG00000060147', u'ENSMUSG00000022365', u'ENSMUSG00000026193', u'ENSMUSG00000017466', u'ENSMUSG00000079037', u'ENSMUSG00000061981', u'ENSMUSG00000039419', u'ENSMUSG00000026043', u'ENSMUSG00000020153', u'ENSMUSG00000039176', u'ENSMUSG00000025809', u'ENSMUSG00000006403', u'ENSMUSG00000030530', u'ENSMUSG00000032193', u'ENSMUSG00000046318', u'ENSMUSG00000057329', u'ENSMUSG00000031934', u'ENSMUSG00000003233', u'ENSMUSG00000045867', u'ENSMUSG00000051747', u'ENSMUSG00000001930', u'ENSMUSG00000028282', u'ENSMUSG00000028763', u'ENSMUSG00000032688', u'ENSMUSG00000001131', u'ENSMUSG00000020087', u'ENSMUSG00000001506', u'ENSMUSG00000001507', u'ENSMUSG00000027447', u'ENSMUSG00000022812', u'ENSMUSG00000028191', u'ENSMUSG00000025860', u'ENSMUSG00000005871', u'ENSMUSG00000030341', u'ENSMUSG00000028756', u'ENSMUSG00000020689', u'ENSMUSG00000025980', u'ENSMUSG00000032231', u'ENSMUSG00000030987', u'ENSMUSG00000040462', u'ENSMUSG00000026072']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002027', NS='BP', enrichment='e', name='regulation of heart rate', ratio_in_study=(1, 624), ratio_in_pop=(18, 13836), p_uncorrected=0.5644708834863089, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020184']), pop_n=13836, pop_count=18, pop_items=set([u'ENSMUSG00000020635', u'ENSMUSG00000021699', u'ENSMUSG00000027488', u'ENSMUSG00000053093', u'ENSMUSG00000032259', u'ENSMUSG00000045103', u'ENSMUSG00000032826', u'ENSMUSG00000032511', u'ENSMUSG00000020184', u'ENSMUSG00000050627', u'ENSMUSG00000021313', u'ENSMUSG00000028883', u'ENSMUSG00000020866', u'ENSMUSG00000054387', u'ENSMUSG00000054640', u'ENSMUSG00000004110', u'ENSMUSG00000024140', u'ENSMUSG00000031980']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002029', NS='BP', enrichment='e', name='desensitization of G-protein coupled receptor protein signaling pathway', ratio_in_study=(1, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.3087700161198612, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000013766']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000074886', u'ENSMUSG00000040016', u'ENSMUSG00000013766', u'ENSMUSG00000049583', u'ENSMUSG00000024858', u'ENSMUSG00000052783', u'ENSMUSG00000042249', u'ENSMUSG00000003228']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002039', NS='MF', enrichment='e', name='p53 binding', ratio_in_study=(4, 624), ratio_in_pop=(66, 13836), p_uncorrected=0.5424223552592468, depth=3, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000002307', u'ENSMUSG00000030528', u'ENSMUSG00000020184']), pop_n=13836, pop_count=66, pop_items=set([u'ENSMUSG00000071072', u'ENSMUSG00000028309', u'ENSMUSG00000055024', u'ENSMUSG00000042854', u'ENSMUSG00000000902', u'ENSMUSG00000029474', u'ENSMUSG00000009291', u'ENSMUSG00000028680', u'ENSMUSG00000038525', u'ENSMUSG00000022521', u'ENSMUSG00000059146', u'ENSMUSG00000020696', u'ENSMUSG00000029454', u'ENSMUSG00000032187', u'ENSMUSG00000059552', u'ENSMUSG00000030528', u'ENSMUSG00000038069', u'ENSMUSG00000052676', u'ENSMUSG00000027663', u'ENSMUSG00000006281', u'ENSMUSG00000000552', u'ENSMUSG00000057113', u'ENSMUSG00000013787', u'ENSMUSG00000037111', u'ENSMUSG00000053754', u'ENSMUSG00000053012', u'ENSMUSG00000026510', u'ENSMUSG00000036940', u'ENSMUSG00000029397', u'ENSMUSG00000031660', u'ENSMUSG00000021109', u'ENSMUSG00000028800', u'ENSMUSG00000020063', u'ENSMUSG00000078652', u'ENSMUSG00000022812', u'ENSMUSG00000037492', u'ENSMUSG00000041560', u'ENSMUSG00000033596', u'ENSMUSG00000020032', u'ENSMUSG00000029104', u'ENSMUSG00000034994', u'ENSMUSG00000020184', u'ENSMUSG00000029535', u'ENSMUSG00000049327', u'ENSMUSG00000029026', u'ENSMUSG00000003068', u'ENSMUSG00000048450', u'ENSMUSG00000039661', u'ENSMUSG00000039725', u'ENSMUSG00000036893', u'ENSMUSG00000031314', u'ENSMUSG00000025316', u'ENSMUSG00000025980', u'ENSMUSG00000027016', u'ENSMUSG00000028639', u'ENSMUSG00000021481', u'ENSMUSG00000031826', u'ENSMUSG00000029833', u'ENSMUSG00000024182', u'ENSMUSG00000002307', u'ENSMUSG00000052293', u'ENSMUSG00000028969', u'ENSMUSG00000043909', u'ENSMUSG00000022710', u'ENSMUSG00000025782', u'ENSMUSG00000026603']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002040', NS='BP', enrichment='e', name='sprouting angiogenesis', ratio_in_study=(3, 624), ratio_in_pop=(25, 13836), p_uncorrected=0.10077640623140441, depth=4, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020185', u'ENSMUSG00000046179', u'ENSMUSG00000070327']), pop_n=13836, pop_count=25, pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000031486', u'ENSMUSG00000006386', u'ENSMUSG00000006699', u'ENSMUSG00000022309', u'ENSMUSG00000029648', u'ENSMUSG00000063531', u'ENSMUSG00000034205', u'ENSMUSG00000078202', u'ENSMUSG00000027985', u'ENSMUSG00000031841', u'ENSMUSG00000025810', u'ENSMUSG00000020185', u'ENSMUSG00000020357', u'ENSMUSG00000004791', u'ENSMUSG00000019880', u'ENSMUSG00000046034', u'ENSMUSG00000070327', u'ENSMUSG00000046179', u'ENSMUSG00000023951', u'ENSMUSG00000030770', u'ENSMUSG00000040152', u'ENSMUSG00000056962', u'ENSMUSG00000059456', u'ENSMUSG00000001240']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002043', NS='BP', enrichment='e', name='blood vessel endothelial cell proliferation involved in sprouting angiogenesis', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000006445']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000022231', u'ENSMUSG00000021835', u'ENSMUSG00000078202', u'ENSMUSG00000031963', u'ENSMUSG00000062352', u'ENSMUSG00000006445', u'ENSMUSG00000023951']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002052', NS='BP', enrichment='e', name='positive regulation of neuroblast proliferation', ratio_in_study=(1, 624), ratio_in_pop=(21, 13836), p_uncorrected=0.6208538864313186, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000033952']), pop_n=13836, pop_count=21, pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000050071', u'ENSMUSG00000028949', u'ENSMUSG00000001761', u'ENSMUSG00000032259', u'ENSMUSG00000074637', u'ENSMUSG00000007989', u'ENSMUSG00000027168', u'ENSMUSG00000006932', u'ENSMUSG00000043051', u'ENSMUSG00000052336', u'ENSMUSG00000033006', u'ENSMUSG00000047143', u'ENSMUSG00000020950', u'ENSMUSG00000021109', u'ENSMUSG00000033952', u'ENSMUSG00000021936', u'ENSMUSG00000021318', u'ENSMUSG00000031778', u'ENSMUSG00000023951', u'ENSMUSG00000039834']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002102', NS='CC', enrichment='p', name='podosome', ratio_in_study=(1, 624), ratio_in_pop=(24, 13836), p_uncorrected=1.0, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029580']), pop_n=13836, pop_count=24, pop_items=set([u'ENSMUSG00000032489', u'ENSMUSG00000058056', u'ENSMUSG00000020476', u'ENSMUSG00000021998', u'ENSMUSG00000024696', u'ENSMUSG00000028771', u'ENSMUSG00000027646', u'ENSMUSG00000024965', u'ENSMUSG00000021823', u'ENSMUSG00000027962', u'ENSMUSG00000028059', u'ENSMUSG00000027940', u'ENSMUSG00000040711', u'ENSMUSG00000029580', u'ENSMUSG00000029581', u'ENSMUSG00000026879', u'ENSMUSG00000031078', u'ENSMUSG00000022377', u'ENSMUSG00000025473', u'ENSMUSG00000026341', u'ENSMUSG00000015950', u'ENSMUSG00000053617', u'ENSMUSG00000021936', u'ENSMUSG00000031799']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002113', NS='MF', enrichment='e', name='interleukin-33 binding', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000026069']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000026069']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002114', NS='MF', enrichment='e', name='interleukin-33 receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026069']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000022514', u'ENSMUSG00000026069']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002188', NS='BP', enrichment='e', name='translation reinitiation', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024991']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000042814', u'ENSMUSG00000023106', u'ENSMUSG00000000355', u'ENSMUSG00000024991']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002218', NS='BP', enrichment='e', name='activation of innate immune response', ratio_in_study=(3, 624), ratio_in_pop=(19, 13836), p_uncorrected=0.05165681972259031, depth=8, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.88379303982897972, study_items=set([u'ENSMUSG00000032344', u'ENSMUSG00000031311', u'ENSMUSG00000042557']), pop_n=13836, pop_count=19, pop_items=set([u'ENSMUSG00000031157', u'ENSMUSG00000024349', u'ENSMUSG00000048878', u'ENSMUSG00000042557', u'ENSMUSG00000022471', u'ENSMUSG00000032344', u'ENSMUSG00000020115', u'ENSMUSG00000030793', u'ENSMUSG00000022672', u'ENSMUSG00000037523', u'ENSMUSG00000028820', u'ENSMUSG00000021938', u'ENSMUSG00000006456', u'ENSMUSG00000037860', u'ENSMUSG00000031311', u'ENSMUSG00000026187', u'ENSMUSG00000037236', u'ENSMUSG00000045322', u'ENSMUSG00000039005']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set(['GO:0002219'])),
    NtGoeaResults(GO='GO:0002224', NS='BP', enrichment='e', name='toll-like receptor signaling pathway', ratio_in_study=(1, 624), ratio_in_pop=(15, 13836), p_uncorrected=0.49971854645333214, depth=11, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000021624']), pop_n=13836, pop_count=15, pop_items=set([u'ENSMUSG00000044827', u'ENSMUSG00000036908', u'ENSMUSG00000022901', u'ENSMUSG00000027995', u'ENSMUSG00000021277', u'ENSMUSG00000032577', u'ENSMUSG00000031309', u'ENSMUSG00000044583', u'ENSMUSG00000059883', u'ENSMUSG00000016528', u'ENSMUSG00000031639', u'ENSMUSG00000045322', u'ENSMUSG00000039005', u'ENSMUSG00000060477', u'ENSMUSG00000021624']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002227', NS='BP', enrichment='e', name='innate immune response in mucosa', ratio_in_study=(4, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.00012860653072037162, depth=5, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=0.010411825626258539, study_items=set([u'ENSMUSG00000062727', u'ENSMUSG00000058385', u'ENSMUSG00000047246', u'ENSMUSG00000069268']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000047246', u'ENSMUSG00000068854', u'ENSMUSG00000079641', u'ENSMUSG00000062727', u'ENSMUSG00000018102', u'ENSMUSG00000069268']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002230', NS='BP', enrichment='e', name='positive regulation of defense response to virus by host', ratio_in_study=(7, 624), ratio_in_pop=(16, 13836), p_uncorrected=2.9401082193258835e-06, depth=8, study_count=7, p_sm_bonferroni=0.046177339692732328, p_fdr_bh=0.00041601206930389487, study_items=set([u'ENSMUSG00000022906', u'ENSMUSG00000042557', u'ENSMUSG00000032344', u'ENSMUSG00000040296', u'ENSMUSG00000036986', u'ENSMUSG00000049502', u'ENSMUSG00000026104']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000022906', u'ENSMUSG00000024349', u'ENSMUSG00000042557', u'ENSMUSG00000005102', u'ENSMUSG00000032344', u'ENSMUSG00000027189', u'ENSMUSG00000031157', u'ENSMUSG00000040296', u'ENSMUSG00000030793', u'ENSMUSG00000036986', u'ENSMUSG00000049502', u'ENSMUSG00000037523', u'ENSMUSG00000026104', u'ENSMUSG00000028466', u'ENSMUSG00000037860', u'ENSMUSG00000042682']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002238', NS='BP', enrichment='e', name='response to molecule of fungal origin', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032508']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000027995', u'ENSMUSG00000032508']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002244', NS='BP', enrichment='e', name='hematopoietic progenitor cell differentiation', ratio_in_study=(6, 624), ratio_in_pop=(61, 13836), p_uncorrected=0.05617003453845029, depth=4, study_count=6, p_sm_bonferroni=1.0, p_fdr_bh=0.95476900699231626, study_items=set([u'ENSMUSG00000028911', u'ENSMUSG00000042557', u'ENSMUSG00000020914', u'ENSMUSG00000042167', u'ENSMUSG00000022034', u'ENSMUSG00000047735']), pop_n=13836, pop_count=61, pop_items=set([u'ENSMUSG00000035126', u'ENSMUSG00000048826', u'ENSMUSG00000052160', u'ENSMUSG00000028093', u'ENSMUSG00000027951', u'ENSMUSG00000028069', u'ENSMUSG00000052144', u'ENSMUSG00000031480', u'ENSMUSG00000040560', u'ENSMUSG00000028556', u'ENSMUSG00000036777', u'ENSMUSG00000029249', u'ENSMUSG00000009585', u'ENSMUSG00000031467', u'ENSMUSG00000058325', u'ENSMUSG00000029231', u'ENSMUSG00000070814', u'ENSMUSG00000028911', u'ENSMUSG00000010609', u'ENSMUSG00000028931', u'ENSMUSG00000004266', u'ENSMUSG00000002603', u'ENSMUSG00000071637', u'ENSMUSG00000019826', u'ENSMUSG00000020914', u'ENSMUSG00000037902', u'ENSMUSG00000031906', u'ENSMUSG00000061702', u'ENSMUSG00000034994', u'ENSMUSG00000042167', u'ENSMUSG00000025815', u'ENSMUSG00000019969', u'ENSMUSG00000022034', u'ENSMUSG00000047735', u'ENSMUSG00000026395', u'ENSMUSG00000040274', u'ENSMUSG00000058070', u'ENSMUSG00000028197', u'ENSMUSG00000002280', u'ENSMUSG00000039910', u'ENSMUSG00000079055', u'ENSMUSG00000002781', u'ENSMUSG00000033106', u'ENSMUSG00000070780', u'ENSMUSG00000042557', u'ENSMUSG00000010047', u'ENSMUSG00000068748', u'ENSMUSG00000061024', u'ENSMUSG00000034910', u'ENSMUSG00000029798', u'ENSMUSG00000002343', u'ENSMUSG00000061887', u'ENSMUSG00000031548', u'ENSMUSG00000043290', u'ENSMUSG00000030583', u'ENSMUSG00000046567', u'ENSMUSG00000021835', u'ENSMUSG00000022335', u'ENSMUSG00000031511', u'ENSMUSG00000040225', u'ENSMUSG00000020961']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002246', NS='BP', enrichment='e', name='wound healing involved in inflammatory response', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005413']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000005413', u'ENSMUSG00000005087']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002248', NS='BP', enrichment='e', name='connective tissue replacement involved in inflammatory response wound healing', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027399']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000027399', u'ENSMUSG00000048376', u'ENSMUSG00000021109']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002250', NS='BP', enrichment='p', name='adaptive immune response', ratio_in_study=(1, 624), ratio_in_pop=(59, 13836), p_uncorrected=0.5234406264560582, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037321']), pop_n=13836, pop_count=59, pop_items=set([u'ENSMUSG00000058818', u'ENSMUSG00000028064', u'ENSMUSG00000000732', u'ENSMUSG00000038495', u'ENSMUSG00000020437', u'ENSMUSG00000021457', u'ENSMUSG00000037321', u'ENSMUSG00000020476', u'ENSMUSG00000031990', u'ENSMUSG00000000134', u'ENSMUSG00000034686', u'ENSMUSG00000004567', u'ENSMUSG00000018446', u'ENSMUSG00000049686', u'ENSMUSG00000062593', u'ENSMUSG00000032462', u'ENSMUSG00000027665', u'ENSMUSG00000024339', u'ENSMUSG00000004730', u'ENSMUSG00000041439', u'ENSMUSG00000031805', u'ENSMUSG00000024767', u'ENSMUSG00000027508', u'ENSMUSG00000036908', u'ENSMUSG00000019843', u'ENSMUSG00000041135', u'ENSMUSG00000032312', u'ENSMUSG00000026648', u'ENSMUSG00000026812', u'ENSMUSG00000020573', u'ENSMUSG00000038260', u'ENSMUSG00000022901', u'ENSMUSG00000028191', u'ENSMUSG00000024789', u'ENSMUSG00000028793', u'ENSMUSG00000039936', u'ENSMUSG00000038128', u'ENSMUSG00000023915', u'ENSMUSG00000029217', u'ENSMUSG00000022636', u'ENSMUSG00000042228', u'ENSMUSG00000021583', u'ENSMUSG00000038147', u'ENSMUSG00000032216', u'ENSMUSG00000025702', u'ENSMUSG00000005102', u'ENSMUSG00000024610', u'ENSMUSG00000026321', u'ENSMUSG00000026117', u'ENSMUSG00000020399', u'ENSMUSG00000004707', u'ENSMUSG00000040751', u'ENSMUSG00000067212', u'ENSMUSG00000051212', u'ENSMUSG00000041187', u'ENSMUSG00000057058', u'ENSMUSG00000059456', u'ENSMUSG00000023990', u'ENSMUSG00000052889']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002262', NS='BP', enrichment='e', name='myeloid cell homeostasis', ratio_in_study=(2, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.04745838570330577, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.82000154659639202, study_items=set([u'ENSMUSG00000057789', u'ENSMUSG00000003873']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000022488', u'ENSMUSG00000021461', u'ENSMUSG00000003873', u'ENSMUSG00000027381', u'ENSMUSG00000003458', u'ENSMUSG00000038855', u'ENSMUSG00000057789', u'ENSMUSG00000022982']), study_n=624, level=2, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002291', NS='BP', enrichment='e', name='T cell activation via T cell receptor contact with antigen bound to MHC molecule on antigen presenting cell', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037405']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000037405', u'ENSMUSG00000026786']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002309', NS='BP', enrichment='e', name='T cell proliferation involved in immune response', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000026177', u'ENSMUSG00000028495']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002322', NS='BP', enrichment='e', name='B cell proliferation involved in immune response', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000021624']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000038910', u'ENSMUSG00000026842', u'ENSMUSG00000039005', u'ENSMUSG00000021624']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002326', NS='BP', enrichment='e', name='B cell lineage commitment', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000020167', u'ENSMUSG00000059552', u'ENSMUSG00000057329', u'ENSMUSG00000022672']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002331', NS='BP', enrichment='e', name='pre-B cell allelic exclusion', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000034218']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000034218']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002352', NS='BP', enrichment='e', name='B cell negative selection', ratio_in_study=(2, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.0020308737188951334, depth=3, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.10596977617596998, study_items=set([u'ENSMUSG00000057789', u'ENSMUSG00000003873']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000057789', u'ENSMUSG00000003873']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002358', NS='BP', enrichment='e', name='B cell homeostatic proliferation', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000003873']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000003873']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002360', NS='BP', enrichment='e', name='T cell lineage commitment', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000057329', u'ENSMUSG00000022672']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002376', NS='BP', enrichment='e', name='immune system process', ratio_in_study=(34, 624), ratio_in_pop=(256, 13836), p_uncorrected=1.492990500106324e-08, depth=1, study_count=34, p_sm_bonferroni=0.00023448908794669924, p_fdr_bh=4.0429153094258486e-06, study_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000070034', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000036986', u'ENSMUSG00000074896', u'ENSMUSG00000041827', u'ENSMUSG00000032508', u'ENSMUSG00000017830', u'ENSMUSG00000028633', u'ENSMUSG00000054072', u'ENSMUSG00000024404', u'ENSMUSG00000021624', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000027514', u'ENSMUSG00000046718', u'ENSMUSG00000046879', u'ENSMUSG00000029561', u'ENSMUSG00000031311', u'ENSMUSG00000026896', u'ENSMUSG00000037321', u'ENSMUSG00000034459', u'ENSMUSG00000032344', u'ENSMUSG00000040296', u'ENSMUSG00000025498', u'ENSMUSG00000020641', u'ENSMUSG00000001123', u'ENSMUSG00000045932', u'ENSMUSG00000034218', u'ENSMUSG00000042699', u'ENSMUSG00000000386']), pop_n=13836, pop_count=256, pop_items=set([u'ENSMUSG00000034453', u'ENSMUSG00000045322', u'ENSMUSG00000051212', u'ENSMUSG00000078942', u'ENSMUSG00000024079', u'ENSMUSG00000052384', u'ENSMUSG00000060586', u'ENSMUSG00000016481', u'ENSMUSG00000042699', u'ENSMUSG00000055172', u'ENSMUSG00000030751', u'ENSMUSG00000009585', u'ENSMUSG00000047123', u'ENSMUSG00000022476', u'ENSMUSG00000024371', u'ENSMUSG00000022471', u'ENSMUSG00000043279', u'ENSMUSG00000017707', u'ENSMUSG00000032035', u'ENSMUSG00000071369', u'ENSMUSG00000026399', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000028820', u'ENSMUSG00000020115', u'ENSMUSG00000000776', u'ENSMUSG00000019843', u'ENSMUSG00000015217', u'ENSMUSG00000035629', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000049686', u'ENSMUSG00000024164', u'ENSMUSG00000046718', u'ENSMUSG00000024045', u'ENSMUSG00000038128', u'ENSMUSG00000075705', u'ENSMUSG00000032109', u'ENSMUSG00000038517', u'ENSMUSG00000046034', u'ENSMUSG00000062593', u'ENSMUSG00000042228', u'ENSMUSG00000026896', u'ENSMUSG00000037321', u'ENSMUSG00000037649', u'ENSMUSG00000014599', u'ENSMUSG00000000275', u'ENSMUSG00000032344', u'ENSMUSG00000038058', u'ENSMUSG00000025512', u'ENSMUSG00000074896', u'ENSMUSG00000074151', u'ENSMUSG00000034889', u'ENSMUSG00000047798', u'ENSMUSG00000027951', u'ENSMUSG00000020437', u'ENSMUSG00000040296', u'ENSMUSG00000036986', u'ENSMUSG00000036887', u'ENSMUSG00000025139', u'ENSMUSG00000000134', u'ENSMUSG00000031897', u'ENSMUSG00000026883', u'ENSMUSG00000006456', u'ENSMUSG00000004567', u'ENSMUSG00000040751', u'ENSMUSG00000018446', u'ENSMUSG00000038260', u'ENSMUSG00000032508', u'ENSMUSG00000028885', u'ENSMUSG00000029826', u'ENSMUSG00000028633', u'ENSMUSG00000027646', u'ENSMUSG00000003184', u'ENSMUSG00000031805', u'ENSMUSG00000059883', u'ENSMUSG00000024767', u'ENSMUSG00000016024', u'ENSMUSG00000054072', u'ENSMUSG00000032690', u'ENSMUSG00000036908', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000061232', u'ENSMUSG00000031392', u'ENSMUSG00000021277', u'ENSMUSG00000041439', u'ENSMUSG00000022901', u'ENSMUSG00000033777', u'ENSMUSG00000045932', u'ENSMUSG00000030263', u'ENSMUSG00000035834', u'ENSMUSG00000039936', u'ENSMUSG00000003283', u'ENSMUSG00000028793', u'ENSMUSG00000044583', u'ENSMUSG00000023915', u'ENSMUSG00000031157', u'ENSMUSG00000002688', u'ENSMUSG00000022636', u'ENSMUSG00000078945', u'ENSMUSG00000021583', u'ENSMUSG00000024349', u'ENSMUSG00000038495', u'ENSMUSG00000028099', u'ENSMUSG00000025702', u'ENSMUSG00000027639', u'ENSMUSG00000033307', u'ENSMUSG00000024610', u'ENSMUSG00000000787', u'ENSMUSG00000030748', u'ENSMUSG00000002602', u'ENSMUSG00000020641', u'ENSMUSG00000024457', u'ENSMUSG00000070390', u'ENSMUSG00000034218', u'ENSMUSG00000047139', u'ENSMUSG00000023990', u'ENSMUSG00000025532', u'ENSMUSG00000060550', u'ENSMUSG00000000386', u'ENSMUSG00000032661', u'ENSMUSG00000070034', u'ENSMUSG00000028064', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000000732', u'ENSMUSG00000036594', u'ENSMUSG00000035279', u'ENSMUSG00000040264', u'ENSMUSG00000030793', u'ENSMUSG00000021457', u'ENSMUSG00000050199', u'ENSMUSG00000029217', u'ENSMUSG00000031639', u'ENSMUSG00000020823', u'ENSMUSG00000031311', u'ENSMUSG00000026285', u'ENSMUSG00000024338', u'ENSMUSG00000024339', u'ENSMUSG00000026288', u'ENSMUSG00000071203', u'ENSMUSG00000053647', u'ENSMUSG00000060591', u'ENSMUSG00000024621', u'ENSMUSG00000032076', u'ENSMUSG00000051439', u'ENSMUSG00000024235', u'ENSMUSG00000001150', u'ENSMUSG00000027508', u'ENSMUSG00000066839', u'ENSMUSG00000037447', u'ENSMUSG00000079547', u'ENSMUSG00000030880', u'ENSMUSG00000041187', u'ENSMUSG00000041135', u'ENSMUSG00000067212', u'ENSMUSG00000021624', u'ENSMUSG00000020707', u'ENSMUSG00000038213', u'ENSMUSG00000048878', u'ENSMUSG00000034686', u'ENSMUSG00000041605', u'ENSMUSG00000017830', u'ENSMUSG00000037731', u'ENSMUSG00000030122', u'ENSMUSG00000055204', u'ENSMUSG00000033454', u'ENSMUSG00000022514', u'ENSMUSG00000022887', u'ENSMUSG00000036469', u'ENSMUSG00000023973', u'ENSMUSG00000020573', u'ENSMUSG00000026187', u'ENSMUSG00000034652', u'ENSMUSG00000055065', u'ENSMUSG00000036712', u'ENSMUSG00000025492', u'ENSMUSG00000027598', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000025498', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000028874', u'ENSMUSG00000004707', u'ENSMUSG00000032691', u'ENSMUSG00000032905', u'ENSMUSG00000022508', u'ENSMUSG00000001123', u'ENSMUSG00000038160', u'ENSMUSG00000031838', u'ENSMUSG00000001128', u'ENSMUSG00000029771', u'ENSMUSG00000058818', u'ENSMUSG00000013707', u'ENSMUSG00000056851', u'ENSMUSG00000026672', u'ENSMUSG00000024392', u'ENSMUSG00000038521', u'ENSMUSG00000019256', u'ENSMUSG00000031750', u'ENSMUSG00000020476', u'ENSMUSG00000073421', u'ENSMUSG00000015837', u'ENSMUSG00000057058', u'ENSMUSG00000041827', u'ENSMUSG00000050335', u'ENSMUSG00000044811', u'ENSMUSG00000026471', u'ENSMUSG00000027514', u'ENSMUSG00000004730', u'ENSMUSG00000034459', u'ENSMUSG00000023224', u'ENSMUSG00000015947', u'ENSMUSG00000026778', u'ENSMUSG00000044791', u'ENSMUSG00000024404', u'ENSMUSG00000039005', u'ENSMUSG00000026648', u'ENSMUSG00000028059', u'ENSMUSG00000028191', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000046879', u'ENSMUSG00000021703', u'ENSMUSG00000051256', u'ENSMUSG00000024789', u'ENSMUSG00000022672', u'ENSMUSG00000033538', u'ENSMUSG00000028291', u'ENSMUSG00000024948', u'ENSMUSG00000022575', u'ENSMUSG00000037236', u'ENSMUSG00000036896', u'ENSMUSG00000073411', u'ENSMUSG00000005102', u'ENSMUSG00000029561', u'ENSMUSG00000029915', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000020399', u'ENSMUSG00000027164', u'ENSMUSG00000050132', u'ENSMUSG00000045038', u'ENSMUSG00000026365', u'ENSMUSG00000032322', u'ENSMUSG00000032737', u'ENSMUSG00000021938', u'ENSMUSG00000034730', u'ENSMUSG00000021423', u'ENSMUSG00000038147', u'ENSMUSG00000052889', u'ENSMUSG00000043496', u'ENSMUSG00000032041']), study_n=624, level=1, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002377', NS='BP', enrichment='e', name='immunoglobulin production', ratio_in_study=(2, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.026990741332852557, depth=3, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000017550', u'ENSMUSG00000034218']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000017550', u'ENSMUSG00000031239', u'ENSMUSG00000022672', u'ENSMUSG00000034218', u'ENSMUSG00000028803', u'ENSMUSG00000024778']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002437', NS='BP', enrichment='e', name='inflammatory response to antigenic stimulus', ratio_in_study=(1, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.3087700161198612, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000054717']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000027878', u'ENSMUSG00000026923', u'ENSMUSG00000054717', u'ENSMUSG00000039191', u'ENSMUSG00000052821', u'ENSMUSG00000063281', u'ENSMUSG00000027347', u'ENSMUSG00000041323']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002438', NS='BP', enrichment='e', name='acute inflammatory response to antigenic stimulus', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037405']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000037405', u'ENSMUSG00000045827']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002455', NS='BP', enrichment='e', name='humoral immune response mediated by circulating immunoglobulin', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000039748']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000039748', u'ENSMUSG00000073421', u'ENSMUSG00000076617', u'ENSMUSG00000053175']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002457', NS='BP', enrichment='e', name='T cell antigen processing and presentation', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037405']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000037405', u'ENSMUSG00000039316']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002474', NS='BP', enrichment='e', name='antigen processing and presentation of peptide antigen via MHC class I', ratio_in_study=(1, 624), ratio_in_pop=(13, 13836), p_uncorrected=0.4512955949428027, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000056116']), pop_n=13836, pop_count=13, pop_items=set([u'ENSMUSG00000073411', u'ENSMUSG00000060802', u'ENSMUSG00000024392', u'ENSMUSG00000035929', u'ENSMUSG00000067212', u'ENSMUSG00000073409', u'ENSMUSG00000056116', u'ENSMUSG00000079507', u'ENSMUSG00000061232', u'ENSMUSG00000016206', u'ENSMUSG00000053835', u'ENSMUSG00000060550', u'ENSMUSG00000026471']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002479', NS='BP', enrichment='e', name='antigen processing and presentation of exogenous peptide antigen via MHC class I, TAP-dependent', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000024308']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000024308']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002523', NS='BP', enrichment='e', name='leukocyte migration involved in inflammatory response', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000030786']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000000290', u'ENSMUSG00000030786', u'ENSMUSG00000025473', u'ENSMUSG00000035385', u'ENSMUSG00000031990', u'ENSMUSG00000047139', u'ENSMUSG00000031778']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002548', NS='BP', enrichment='e', name='monocyte chemotaxis', ratio_in_study=(2, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.09940214291590645, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000035352', u'ENSMUSG00000018930']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000000982', u'ENSMUSG00000030223', u'ENSMUSG00000050335', u'ENSMUSG00000029648', u'ENSMUSG00000000489', u'ENSMUSG00000018927', u'ENSMUSG00000019122', u'ENSMUSG00000004677', u'ENSMUSG00000035352', u'ENSMUSG00000018930', u'ENSMUSG00000031778', u'ENSMUSG00000040952']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002687', NS='BP', enrichment='e', name='positive regulation of leukocyte migration', ratio_in_study=(2, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.059231393060625616, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.98547485107011223, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000035352']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000000562', u'ENSMUSG00000059552', u'ENSMUSG00000020717', u'ENSMUSG00000027009', u'ENSMUSG00000027995', u'ENSMUSG00000035385', u'ENSMUSG00000019966', u'ENSMUSG00000035352', u'ENSMUSG00000020689']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002690', NS='BP', enrichment='e', name='positive regulation of leukocyte chemotaxis', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000034855']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000029417', u'ENSMUSG00000055633', u'ENSMUSG00000023078', u'ENSMUSG00000034786', u'ENSMUSG00000034855', u'ENSMUSG00000027524']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002693', NS='BP', enrichment='e', name='positive regulation of cellular extravasation', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037405']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000037405', u'ENSMUSG00000020717', u'ENSMUSG00000035385', u'ENSMUSG00000025473', u'ENSMUSG00000032011', u'ENSMUSG00000034845', u'ENSMUSG00000056529']), study_n=624, level=6, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002755', NS='BP', enrichment='e', name='MyD88-dependent toll-like receptor signaling pathway', ratio_in_study=(1, 624), ratio_in_pop=(10, 13836), p_uncorrected=0.36974924624400735, depth=12, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032508']), pop_n=13836, pop_count=10, pop_items=set([u'ENSMUSG00000025980', u'ENSMUSG00000045322', u'ENSMUSG00000032508', u'ENSMUSG00000033777', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000020400', u'ENSMUSG00000044583', u'ENSMUSG00000060477', u'ENSMUSG00000039005']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002819', NS='BP', enrichment='e', name='regulation of adaptive immune response', ratio_in_study=(2, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.011467047866411785, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000025498', u'ENSMUSG00000018899']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000025498', u'ENSMUSG00000015355', u'ENSMUSG00000039384', u'ENSMUSG00000018899']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002826', NS='BP', enrichment='e', name='negative regulation of T-helper 1 type immune response', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026069']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000026069', u'ENSMUSG00000024810', u'ENSMUSG00000020399']), study_n=624, level=8, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002903', NS='BP', enrichment='e', name='negative regulation of B cell apoptotic process', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=10, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020897']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000020897', u'ENSMUSG00000025986', u'ENSMUSG00000038894']), study_n=624, level=10, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002904', NS='BP', enrichment='e', name='positive regulation of B cell apoptotic process', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=10, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000003873']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000047139', u'ENSMUSG00000035992', u'ENSMUSG00000003873', u'ENSMUSG00000022346']), study_n=624, level=10, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0002931', NS='BP', enrichment='p', name='response to ischemia', ratio_in_study=(1, 624), ratio_in_pop=(23, 13836), p_uncorrected=1.0, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552']), pop_n=13836, pop_count=23, pop_items=set([u'ENSMUSG00000020300', u'ENSMUSG00000074064', u'ENSMUSG00000024617', u'ENSMUSG00000059552', u'ENSMUSG00000021868', u'ENSMUSG00000037012', u'ENSMUSG00000032115', u'ENSMUSG00000023011', u'ENSMUSG00000038028', u'ENSMUSG00000038418', u'ENSMUSG00000022951', u'ENSMUSG00000049001', u'ENSMUSG00000055866', u'ENSMUSG00000030538', u'ENSMUSG00000058441', u'ENSMUSG00000029223', u'ENSMUSG00000057329', u'ENSMUSG00000031934', u'ENSMUSG00000030965', u'ENSMUSG00000000628', u'ENSMUSG00000007659', u'ENSMUSG00000007655', u'ENSMUSG00000014776']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003151', NS='BP', enrichment='p', name='outflow tract morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(41, 13836), p_uncorrected=1.0, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000052684']), pop_n=13836, pop_count=41, pop_items=set([u'ENSMUSG00000025932', u'ENSMUSG00000057123', u'ENSMUSG00000032440', u'ENSMUSG00000044014', u'ENSMUSG00000067336', u'ENSMUSG00000032744', u'ENSMUSG00000066026', u'ENSMUSG00000040289', u'ENSMUSG00000028004', u'ENSMUSG00000032187', u'ENSMUSG00000028780', u'ENSMUSG00000022528', u'ENSMUSG00000052684', u'ENSMUSG00000049577', u'ENSMUSG00000021796', u'ENSMUSG00000022306', u'ENSMUSG00000022141', u'ENSMUSG00000030592', u'ENSMUSG00000021109', u'ENSMUSG00000005583', u'ENSMUSG00000063632', u'ENSMUSG00000039239', u'ENSMUSG00000030123', u'ENSMUSG00000050288', u'ENSMUSG00000048616', u'ENSMUSG00000039910', u'ENSMUSG00000044674', u'ENSMUSG00000019789', u'ENSMUSG00000023951', u'ENSMUSG00000032216', u'ENSMUSG00000039191', u'ENSMUSG00000040152', u'ENSMUSG00000001052', u'ENSMUSG00000020888', u'ENSMUSG00000018604', u'ENSMUSG00000029287', u'ENSMUSG00000021835', u'ENSMUSG00000025902', u'ENSMUSG00000030890', u'ENSMUSG00000027104', u'ENSMUSG00000036437']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003170', NS='BP', enrichment='e', name='heart valve development', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020184']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000000567', u'ENSMUSG00000054387', u'ENSMUSG00000049672', u'ENSMUSG00000020184', u'ENSMUSG00000035247', u'ENSMUSG00000036867', u'ENSMUSG00000037236']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003179', NS='BP', enrichment='e', name='heart valve morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000008090']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000030022', u'ENSMUSG00000000567', u'ENSMUSG00000002603', u'ENSMUSG00000039239', u'ENSMUSG00000008090', u'ENSMUSG00000028991', u'ENSMUSG00000033016']), study_n=624, level=3, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003181', NS='BP', enrichment='e', name='atrioventricular valve morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020184']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000032440', u'ENSMUSG00000040289', u'ENSMUSG00000049577', u'ENSMUSG00000028195', u'ENSMUSG00000039239', u'ENSMUSG00000022306', u'ENSMUSG00000032744', u'ENSMUSG00000020184', u'ENSMUSG00000026836', u'ENSMUSG00000054387', u'ENSMUSG00000027358']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003203', NS='BP', enrichment='e', name='endocardial cushion morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(13, 13836), p_uncorrected=0.4512955949428027, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020184']), pop_n=13836, pop_count=13, pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000026814', u'ENSMUSG00000000567', u'ENSMUSG00000048616', u'ENSMUSG00000039239', u'ENSMUSG00000054387', u'ENSMUSG00000032744', u'ENSMUSG00000026836', u'ENSMUSG00000000530', u'ENSMUSG00000020184', u'ENSMUSG00000021796', u'ENSMUSG00000040289', u'ENSMUSG00000027358']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003215', NS='BP', enrichment='e', name='cardiac right ventricle morphogenesis', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000040734']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000040734', u'ENSMUSG00000076431', u'ENSMUSG00000039239', u'ENSMUSG00000027276', u'ENSMUSG00000021796', u'ENSMUSG00000028780', u'ENSMUSG00000019789']), study_n=624, level=5, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003229', NS='BP', enrichment='e', name='ventricular cardiac muscle tissue development', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000040734']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000040734', u'ENSMUSG00000030022', u'ENSMUSG00000022371']), study_n=624, level=7, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003281', NS='BP', enrichment='p', name='ventricular septum development', ratio_in_study=(1, 624), ratio_in_pop=(30, 13836), p_uncorrected=1.0, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020184']), pop_n=13836, pop_count=30, pop_items=set([u'ENSMUSG00000020170', u'ENSMUSG00000057123', u'ENSMUSG00000039801', u'ENSMUSG00000032187', u'ENSMUSG00000028266', u'ENSMUSG00000045382', u'ENSMUSG00000022528', u'ENSMUSG00000021188', u'ENSMUSG00000033335', u'ENSMUSG00000035152', u'ENSMUSG00000020289', u'ENSMUSG00000001089', u'ENSMUSG00000036867', u'ENSMUSG00000030868', u'ENSMUSG00000057110', u'ENSMUSG00000028195', u'ENSMUSG00000020184', u'ENSMUSG00000035247', u'ENSMUSG00000039910', u'ENSMUSG00000022883', u'ENSMUSG00000023972', u'ENSMUSG00000031665', u'ENSMUSG00000037236', u'ENSMUSG00000054387', u'ENSMUSG00000001870', u'ENSMUSG00000025231', u'ENSMUSG00000075254', u'ENSMUSG00000027070', u'ENSMUSG00000032327', u'ENSMUSG00000053226']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003283', NS='BP', enrichment='e', name='atrial septum development', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020184']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000032558', u'ENSMUSG00000057123', u'ENSMUSG00000053226', u'ENSMUSG00000020184', u'ENSMUSG00000054387']), study_n=624, level=4, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003374', NS='BP', enrichment='e', name='dynamin family protein polymerization involved in mitochondrial fission', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000000386']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000026825', u'ENSMUSG00000033335', u'ENSMUSG00000038084', u'ENSMUSG00000040265', u'ENSMUSG00000022789', u'ENSMUSG00000000386']), study_n=624, level=9, is_obsolete=False, namespace='biological_process', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003676', NS='MF', enrichment='e', name='nucleic acid binding', ratio_in_study=(33, 624), ratio_in_pop=(719, 13836), p_uncorrected=0.9263502471168293, depth=3, study_count=33, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000033732', u'ENSMUSG00000002297', u'ENSMUSG00000033762', u'ENSMUSG00000042699', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000006418', u'ENSMUSG00000030528', u'ENSMUSG00000025134', u'ENSMUSG00000036086', u'ENSMUSG00000028911', u'ENSMUSG00000030609', u'ENSMUSG00000042439', u'ENSMUSG00000024097', u'ENSMUSG00000044934', u'ENSMUSG00000034206', u'ENSMUSG00000037868', u'ENSMUSG00000034329', u'ENSMUSG00000007080', u'ENSMUSG00000038644', u'ENSMUSG00000035266', u'ENSMUSG00000039236', u'ENSMUSG00000027968', u'ENSMUSG00000027433', u'ENSMUSG00000005481', u'ENSMUSG00000037214', u'ENSMUSG00000031311', u'ENSMUSG00000028382', u'ENSMUSG00000031527', u'ENSMUSG00000036249', u'ENSMUSG00000027109', u'ENSMUSG00000038774', u'ENSMUSG00000030929']), pop_n=13836, pop_count=719, pop_items=set([u'ENSMUSG00000039759', u'ENSMUSG00000047907', u'ENSMUSG00000048109', u'ENSMUSG00000021716', u'ENSMUSG00000046380', u'ENSMUSG00000021712', u'ENSMUSG00000018379', u'ENSMUSG00000031586', u'ENSMUSG00000030443', u'ENSMUSG00000059713', u'ENSMUSG00000031583', u'ENSMUSG00000036315', u'ENSMUSG00000038895', u'ENSMUSG00000055991', u'ENSMUSG00000037243', u'ENSMUSG00000007080', u'ENSMUSG00000030189', u'ENSMUSG00000027663', u'ENSMUSG00000018678', u'ENSMUSG00000005506', u'ENSMUSG00000064264', u'ENSMUSG00000030846', u'ENSMUSG00000055491', u'ENSMUSG00000031907', u'ENSMUSG00000038628', u'ENSMUSG00000020752', u'ENSMUSG00000032705', u'ENSMUSG00000015023', u'ENSMUSG00000008668', u'ENSMUSG00000030204', u'ENSMUSG00000021217', u'ENSMUSG00000032097', u'ENSMUSG00000047371', u'ENSMUSG00000068154', u'ENSMUSG00000052040', u'ENSMUSG00000071662', u'ENSMUSG00000071661', u'ENSMUSG00000027016', u'ENSMUSG00000047686', u'ENSMUSG00000056076', u'ENSMUSG00000032026', u'ENSMUSG00000032410', u'ENSMUSG00000026889', u'ENSMUSG00000018583', u'ENSMUSG00000003271', u'ENSMUSG00000061898', u'ENSMUSG00000042396', u'ENSMUSG00000022009', u'ENSMUSG00000020364', u'ENSMUSG00000038132', u'ENSMUSG00000049728', u'ENSMUSG00000031167', u'ENSMUSG00000048921', u'ENSMUSG00000021327', u'ENSMUSG00000052707', u'ENSMUSG00000039841', u'ENSMUSG00000043059', u'ENSMUSG00000049577', u'ENSMUSG00000026333', u'ENSMUSG00000022306', u'ENSMUSG00000019826', u'ENSMUSG00000029127', u'ENSMUSG00000037868', u'ENSMUSG00000050240', u'ENSMUSG00000002578', u'ENSMUSG00000015337', u'ENSMUSG00000028807', u'ENSMUSG00000035266', u'ENSMUSG00000021134', u'ENSMUSG00000020409', u'ENSMUSG00000018995', u'ENSMUSG00000051351', u'ENSMUSG00000039210', u'ENSMUSG00000028790', u'ENSMUSG00000029701', u'ENSMUSG00000015597', u'ENSMUSG00000028651', u'ENSMUSG00000037784', u'ENSMUSG00000027667', u'ENSMUSG00000028890', u'ENSMUSG00000034621', u'ENSMUSG00000000787', u'ENSMUSG00000043602', u'ENSMUSG00000046897', u'ENSMUSG00000028898', u'ENSMUSG00000024220', u'ENSMUSG00000046404', u'ENSMUSG00000020335', u'ENSMUSG00000037149', u'ENSMUSG00000024587', u'ENSMUSG00000063108', u'ENSMUSG00000015165', u'ENSMUSG00000042496', u'ENSMUSG00000020719', u'ENSMUSG00000002052', u'ENSMUSG00000033762', u'ENSMUSG00000024831', u'ENSMUSG00000039717', u'ENSMUSG00000038784', u'ENSMUSG00000037364', u'ENSMUSG00000049657', u'ENSMUSG00000030016', u'ENSMUSG00000030400', u'ENSMUSG00000046792', u'ENSMUSG00000068267', u'ENSMUSG00000027582', u'ENSMUSG00000027583', u'ENSMUSG00000027620', u'ENSMUSG00000052488', u'ENSMUSG00000052675', u'ENSMUSG00000040209', u'ENSMUSG00000031948', u'ENSMUSG00000021621', u'ENSMUSG00000092035', u'ENSMUSG00000019432', u'ENSMUSG00000014550', u'ENSMUSG00000030087', u'ENSMUSG00000063808', u'ENSMUSG00000059975', u'ENSMUSG00000040596', u'ENSMUSG00000030243', u'ENSMUSG00000027905', u'ENSMUSG00000046667', u'ENSMUSG00000051034', u'ENSMUSG00000089824', u'ENSMUSG00000053950', u'ENSMUSG00000079509', u'ENSMUSG00000031428', u'ENSMUSG00000028382', u'ENSMUSG00000062012', u'ENSMUSG00000052253', u'ENSMUSG00000028389', u'ENSMUSG00000034820', u'ENSMUSG00000040524', u'ENSMUSG00000023025', u'ENSMUSG00000052926', u'ENSMUSG00000026058', u'ENSMUSG00000039782', u'ENSMUSG00000030232', u'ENSMUSG00000045268', u'ENSMUSG00000079215', u'ENSMUSG00000062078', u'ENSMUSG00000047036', u'ENSMUSG00000024019', u'ENSMUSG00000021366', u'ENSMUSG00000039236', u'ENSMUSG00000015501', u'ENSMUSG00000039967', u'ENSMUSG00000006418', u'ENSMUSG00000033863', u'ENSMUSG00000032119', u'ENSMUSG00000067860', u'ENSMUSG00000022194', u'ENSMUSG00000039087', u'ENSMUSG00000052406', u'ENSMUSG00000059878', u'ENSMUSG00000063281', u'ENSMUSG00000031728', u'ENSMUSG00000047003', u'ENSMUSG00000026377', u'ENSMUSG00000025404', u'ENSMUSG00000036249', u'ENSMUSG00000039531', u'ENSMUSG00000061524', u'ENSMUSG00000044224', u'ENSMUSG00000026970', u'ENSMUSG00000044221', u'ENSMUSG00000026872', u'ENSMUSG00000025586', u'ENSMUSG00000014303', u'ENSMUSG00000044149', u'ENSMUSG00000035649', u'ENSMUSG00000024491', u'ENSMUSG00000032297', u'ENSMUSG00000061894', u'ENSMUSG00000029179', u'ENSMUSG00000029178', u'ENSMUSG00000010205', u'ENSMUSG00000029913', u'ENSMUSG00000002524', u'ENSMUSG00000025571', u'ENSMUSG00000028850', u'ENSMUSG00000025576', u'ENSMUSG00000071337', u'ENSMUSG00000026806', u'ENSMUSG00000048251', u'ENSMUSG00000059208', u'ENSMUSG00000032621', u'ENSMUSG00000023805', u'ENSMUSG00000042699', u'ENSMUSG00000029458', u'ENSMUSG00000042694', u'ENSMUSG00000029328', u'ENSMUSG00000049532', u'ENSMUSG00000029594', u'ENSMUSG00000054893', u'ENSMUSG00000071341', u'ENSMUSG00000048661', u'ENSMUSG00000036442', u'ENSMUSG00000025997', u'ENSMUSG00000046201', u'ENSMUSG00000045639', u'ENSMUSG00000006678', u'ENSMUSG00000037001', u'ENSMUSG00000034329', u'ENSMUSG00000071054', u'ENSMUSG00000023938', u'ENSMUSG00000028034', u'ENSMUSG00000058655', u'ENSMUSG00000034931', u'ENSMUSG00000054967', u'ENSMUSG00000042426', u'ENSMUSG00000018347', u'ENSMUSG00000037253', u'ENSMUSG00000059708', u'ENSMUSG00000030057', u'ENSMUSG00000037419', u'ENSMUSG00000005698', u'ENSMUSG00000026788', u'ENSMUSG00000000568', u'ENSMUSG00000066798', u'ENSMUSG00000042500', u'ENSMUSG00000059796', u'ENSMUSG00000048047', u'ENSMUSG00000007836', u'ENSMUSG00000050919', u'ENSMUSG00000055305', u'ENSMUSG00000051184', u'ENSMUSG00000033871', u'ENSMUSG00000034022', u'ENSMUSG00000024050', u'ENSMUSG00000053985', u'ENSMUSG00000074406', u'ENSMUSG00000023495', u'ENSMUSG00000006456', u'ENSMUSG00000031715', u'ENSMUSG00000030393', u'ENSMUSG00000035051', u'ENSMUSG00000036036', u'ENSMUSG00000031370', u'ENSMUSG00000031374', u'ENSMUSG00000032407', u'ENSMUSG00000020137', u'ENSMUSG00000003500', u'ENSMUSG00000022012', u'ENSMUSG00000040028', u'ENSMUSG00000041703', u'ENSMUSG00000067873', u'ENSMUSG00000074102', u'ENSMUSG00000020358', u'ENSMUSG00000027439', u'ENSMUSG00000062040', u'ENSMUSG00000027433', u'ENSMUSG00000031256', u'ENSMUSG00000069769', u'ENSMUSG00000031099', u'ENSMUSG00000003282', u'ENSMUSG00000031626', u'ENSMUSG00000022635', u'ENSMUSG00000064043', u'ENSMUSG00000043639', u'ENSMUSG00000022708', u'ENSMUSG00000032579', u'ENSMUSG00000040731', u'ENSMUSG00000017999', u'ENSMUSG00000017264', u'ENSMUSG00000021876', u'ENSMUSG00000063804', u'ENSMUSG00000018287', u'ENSMUSG00000078765', u'ENSMUSG00000022332', u'ENSMUSG00000022335', u'ENSMUSG00000060257', u'ENSMUSG00000029817', u'ENSMUSG00000021500', u'ENSMUSG00000022760', u'ENSMUSG00000017421', u'ENSMUSG00000035275', u'ENSMUSG00000061410', u'ENSMUSG00000040321', u'ENSMUSG00000050064', u'ENSMUSG00000003032', u'ENSMUSG00000009079', u'ENSMUSG00000029715', u'ENSMUSG00000039410', u'ENSMUSG00000029249', u'ENSMUSG00000034681', u'ENSMUSG00000059689', u'ENSMUSG00000075595', u'ENSMUSG00000092417', u'ENSMUSG00000029627', u'ENSMUSG00000022201', u'ENSMUSG00000029625', u'ENSMUSG00000036376', u'ENSMUSG00000034610', u'ENSMUSG00000025899', u'ENSMUSG00000005267', u'ENSMUSG00000034206', u'ENSMUSG00000041649', u'ENSMUSG00000050668', u'ENSMUSG00000041130', u'ENSMUSG00000041645', u'ENSMUSG00000036721', u'ENSMUSG00000055835', u'ENSMUSG00000039176', u'ENSMUSG00000026667', u'ENSMUSG00000002107', u'ENSMUSG00000057113', u'ENSMUSG00000029402', u'ENSMUSG00000016921', u'ENSMUSG00000029405', u'ENSMUSG00000033454', u'ENSMUSG00000005481', u'ENSMUSG00000038797', u'ENSMUSG00000043410', u'ENSMUSG00000037197', u'ENSMUSG00000055531', u'ENSMUSG00000004980', u'ENSMUSG00000046556', u'ENSMUSG00000038384', u'ENSMUSG00000027593', u'ENSMUSG00000034278', u'ENSMUSG00000042156', u'ENSMUSG00000055480', u'ENSMUSG00000015757', u'ENSMUSG00000066613', u'ENSMUSG00000042097', u'ENSMUSG00000025470', u'ENSMUSG00000028042', u'ENSMUSG00000033931', u'ENSMUSG00000001424', u'ENSMUSG00000020705', u'ENSMUSG00000061079', u'ENSMUSG00000042079', u'ENSMUSG00000041912', u'ENSMUSG00000062861', u'ENSMUSG00000028911', u'ENSMUSG00000035877', u'ENSMUSG00000030435', u'ENSMUSG00000041459', u'ENSMUSG00000027981', u'ENSMUSG00000052713', u'ENSMUSG00000031433', u'ENSMUSG00000018654', u'ENSMUSG00000042472', u'ENSMUSG00000022119', u'ENSMUSG00000049321', u'ENSMUSG00000062309', u'ENSMUSG00000020677', u'ENSMUSG00000002428', u'ENSMUSG00000038644', u'ENSMUSG00000021546', u'ENSMUSG00000035529', u'ENSMUSG00000014329', u'ENSMUSG00000054716', u'ENSMUSG00000048696', u'ENSMUSG00000027968', u'ENSMUSG00000035781', u'ENSMUSG00000045252', u'ENSMUSG00000031665', u'ENSMUSG00000022185', u'ENSMUSG00000043456', u'ENSMUSG00000036054', u'ENSMUSG00000026404', u'ENSMUSG00000053536', u'ENSMUSG00000053289', u'ENSMUSG00000036114', u'ENSMUSG00000021938', u'ENSMUSG00000074221', u'ENSMUSG00000055538', u'ENSMUSG00000029169', u'ENSMUSG00000031109', u'ENSMUSG00000020300', u'ENSMUSG00000045733', u'ENSMUSG00000031107', u'ENSMUSG00000031060', u'ENSMUSG00000020515', u'ENSMUSG00000057894', u'ENSMUSG00000001280', u'ENSMUSG00000046351', u'ENSMUSG00000002814', u'ENSMUSG00000021494', u'ENSMUSG00000048897', u'ENSMUSG00000029167', u'ENSMUSG00000034088', u'ENSMUSG00000034071', u'ENSMUSG00000022361', u'ENSMUSG00000046982', u'ENSMUSG00000028820', u'ENSMUSG00000034120', u'ENSMUSG00000034653', u'ENSMUSG00000048012', u'ENSMUSG00000037492', u'ENSMUSG00000018974', u'ENSMUSG00000029729', u'ENSMUSG00000026709', u'ENSMUSG00000032940', u'ENSMUSG00000028134', u'ENSMUSG00000059540', u'ENSMUSG00000028137', u'ENSMUSG00000025323', u'ENSMUSG00000029599', u'ENSMUSG00000001674', u'ENSMUSG00000024369', u'ENSMUSG00000037640', u'ENSMUSG00000057788', u'ENSMUSG00000049421', u'ENSMUSG00000024565', u'ENSMUSG00000000078', u'ENSMUSG00000071064', u'ENSMUSG00000036972', u'ENSMUSG00000021116', u'ENSMUSG00000029538', u'ENSMUSG00000020630', u'ENSMUSG00000032480', u'ENSMUSG00000035842', u'ENSMUSG00000028411', u'ENSMUSG00000041815', u'ENSMUSG00000030753', u'ENSMUSG00000025134', u'ENSMUSG00000025047', u'ENSMUSG00000000552', u'ENSMUSG00000060373', u'ENSMUSG00000034839', u'ENSMUSG00000037465', u'ENSMUSG00000028952', u'ENSMUSG00000032298', u'ENSMUSG00000034800', u'ENSMUSG00000005682', u'ENSMUSG00000052751', u'ENSMUSG00000031960', u'ENSMUSG00000063334', u'ENSMUSG00000018750', u'ENSMUSG00000036499', u'ENSMUSG00000053080', u'ENSMUSG00000033964', u'ENSMUSG00000072115', u'ENSMUSG00000022987', u'ENSMUSG00000073423', u'ENSMUSG00000031311', u'ENSMUSG00000063568', u'ENSMUSG00000044519', u'ENSMUSG00000032368', u'ENSMUSG00000016503', u'ENSMUSG00000040429', u'ENSMUSG00000068551', u'ENSMUSG00000031816', u'ENSMUSG00000022023', u'ENSMUSG00000042197', u'ENSMUSG00000021743', u'ENSMUSG00000038116', u'ENSMUSG00000025959', u'ENSMUSG00000044068', u'ENSMUSG00000062761', u'ENSMUSG00000044934', u'ENSMUSG00000019338', u'ENSMUSG00000031148', u'ENSMUSG00000036086', u'ENSMUSG00000026356', u'ENSMUSG00000061374', u'ENSMUSG00000032503', u'ENSMUSG00000011306', u'ENSMUSG00000047412', u'ENSMUSG00000001150', u'ENSMUSG00000024420', u'ENSMUSG00000047141', u'ENSMUSG00000021514', u'ENSMUSG00000024740', u'ENSMUSG00000035248', u'ENSMUSG00000031134', u'ENSMUSG00000071645', u'ENSMUSG00000068856', u'ENSMUSG00000020464', u'ENSMUSG00000038679', u'ENSMUSG00000028772', u'ENSMUSG00000038418', u'ENSMUSG00000029389', u'ENSMUSG00000032212', u'ENSMUSG00000046311', u'ENSMUSG00000033565', u'ENSMUSG00000001632', u'ENSMUSG00000022961', u'ENSMUSG00000027109', u'ENSMUSG00000057691', u'ENSMUSG00000025255', u'ENSMUSG00000041530', u'ENSMUSG00000021392', u'ENSMUSG00000063511', u'ENSMUSG00000027104', u'ENSMUSG00000006720', u'ENSMUSG00000030929', u'ENSMUSG00000060657', u'ENSMUSG00000049232', u'ENSMUSG00000028688', u'ENSMUSG00000035011', u'ENSMUSG00000033423', u'ENSMUSG00000019792', u'ENSMUSG00000027288', u'ENSMUSG00000025374', u'ENSMUSG00000037029', u'ENSMUSG00000034194', u'ENSMUSG00000042787', u'ENSMUSG00000046541', u'ENSMUSG00000028676', u'ENSMUSG00000055239', u'ENSMUSG00000035397', u'ENSMUSG00000061479', u'ENSMUSG00000085795', u'ENSMUSG00000051730', u'ENSMUSG00000036916', u'ENSMUSG00000068823', u'ENSMUSG00000048271', u'ENSMUSG00000033732', u'ENSMUSG00000033730', u'ENSMUSG00000029504', u'ENSMUSG00000051499', u'ENSMUSG00000039607', u'ENSMUSG00000058638', u'ENSMUSG00000039601', u'ENSMUSG00000008333', u'ENSMUSG00000005621', u'ENSMUSG00000028423', u'ENSMUSG00000042369', u'ENSMUSG00000028358', u'ENSMUSG00000055148', u'ENSMUSG00000055065', u'ENSMUSG00000037236', u'ENSMUSG00000026279', u'ENSMUSG00000053286', u'ENSMUSG00000031527', u'ENSMUSG00000028902', u'ENSMUSG00000027677', u'ENSMUSG00000016018', u'ENSMUSG00000030584', u'ENSMUSG00000027770', u'ENSMUSG00000007850', u'ENSMUSG00000037730', u'ENSMUSG00000018765', u'ENSMUSG00000003410', u'ENSMUSG00000038774', u'ENSMUSG00000033813', u'ENSMUSG00000073062', u'ENSMUSG00000024097', u'ENSMUSG00000046909', u'ENSMUSG00000055660', u'ENSMUSG00000000861', u'ENSMUSG00000028842', u'ENSMUSG00000021264', u'ENSMUSG00000045538', u'ENSMUSG00000068134', u'ENSMUSG00000040167', u'ENSMUSG00000051469', u'ENSMUSG00000051390', u'ENSMUSG00000032423', u'ENSMUSG00000020116', u'ENSMUSG00000040761', u'ENSMUSG00000020115', u'ENSMUSG00000019841', u'ENSMUSG00000022774', u'ENSMUSG00000007670', u'ENSMUSG00000043290', u'ENSMUSG00000002265', u'ENSMUSG00000045333', u'ENSMUSG00000027551', u'ENSMUSG00000033760', u'ENSMUSG00000048385', u'ENSMUSG00000034430', u'ENSMUSG00000057706', u'ENSMUSG00000039834', u'ENSMUSG00000021958', u'ENSMUSG00000040717', u'ENSMUSG00000021951', u'ENSMUSG00000021481', u'ENSMUSG00000003660', u'ENSMUSG00000020075', u'ENSMUSG00000020076', u'ENSMUSG00000049600', u'ENSMUSG00000040302', u'ENSMUSG00000021681', u'ENSMUSG00000071679', u'ENSMUSG00000010362', u'ENSMUSG00000001383', u'ENSMUSG00000030678', u'ENSMUSG00000024695', u'ENSMUSG00000045598', u'ENSMUSG00000038685', u'ENSMUSG00000028639', u'ENSMUSG00000037361', u'ENSMUSG00000022228', u'ENSMUSG00000028634', u'ENSMUSG00000024604', u'ENSMUSG00000039652', u'ENSMUSG00000001065', u'ENSMUSG00000071172', u'ENSMUSG00000022858', u'ENSMUSG00000021040', u'ENSMUSG00000021047', u'ENSMUSG00000042625', u'ENSMUSG00000048485', u'ENSMUSG00000004393', u'ENSMUSG00000029427', u'ENSMUSG00000040043', u'ENSMUSG00000072294', u'ENSMUSG00000007216', u'ENSMUSG00000037070', u'ENSMUSG00000024826', u'ENSMUSG00000028546', u'ENSMUSG00000051695', u'ENSMUSG00000046010', u'ENSMUSG00000037370', u'ENSMUSG00000060397', u'ENSMUSG00000059475', u'ENSMUSG00000069565', u'ENSMUSG00000055204', u'ENSMUSG00000027639', u'ENSMUSG00000030779', u'ENSMUSG00000078779', u'ENSMUSG00000026234', u'ENSMUSG00000035456', u'ENSMUSG00000075528', u'ENSMUSG00000040620', u'ENSMUSG00000005148', u'ENSMUSG00000041483', u'ENSMUSG00000021639', u'ENSMUSG00000002297', u'ENSMUSG00000047710', u'ENSMUSG00000046658', u'ENSMUSG00000032580', u'ENSMUSG00000070866', u'ENSMUSG00000028069', u'ENSMUSG00000024135', u'ENSMUSG00000024137', u'ENSMUSG00000018428', u'ENSMUSG00000018425', u'ENSMUSG00000030528', u'ENSMUSG00000026199', u'ENSMUSG00000021221', u'ENSMUSG00000008658', u'ENSMUSG00000052676', u'ENSMUSG00000038902', u'ENSMUSG00000045193', u'ENSMUSG00000018040', u'ENSMUSG00000020653', u'ENSMUSG00000008489', u'ENSMUSG00000026519', u'ENSMUSG00000019738', u'ENSMUSG00000059005', u'ENSMUSG00000000838', u'ENSMUSG00000048039', u'ENSMUSG00000055633', u'ENSMUSG00000047417', u'ENSMUSG00000070319', u'ENSMUSG00000051550', u'ENSMUSG00000048402', u'ENSMUSG00000022884', u'ENSMUSG00000056851', u'ENSMUSG00000031601', u'ENSMUSG00000057982', u'ENSMUSG00000021318', u'ENSMUSG00000070780', u'ENSMUSG00000010592', u'ENSMUSG00000052942', u'ENSMUSG00000044475', u'ENSMUSG00000022425', u'ENSMUSG00000032101', u'ENSMUSG00000044807', u'ENSMUSG00000033499', u'ENSMUSG00000008393', u'ENSMUSG00000022721', u'ENSMUSG00000001120', u'ENSMUSG00000075592', u'ENSMUSG00000022283', u'ENSMUSG00000006215', u'ENSMUSG00000022685', u'ENSMUSG00000054737', u'ENSMUSG00000044390', u'ENSMUSG00000047888', u'ENSMUSG00000027684', u'ENSMUSG00000027680', u'ENSMUSG00000022508', u'ENSMUSG00000020472', u'ENSMUSG00000036698', u'ENSMUSG00000036699', u'ENSMUSG00000047388', u'ENSMUSG00000047473', u'ENSMUSG00000044452', u'ENSMUSG00000010608', u'ENSMUSG00000043099', u'ENSMUSG00000037017', u'ENSMUSG00000028840', u'ENSMUSG00000024095', u'ENSMUSG00000006498', u'ENSMUSG00000022951', u'ENSMUSG00000058881', u'ENSMUSG00000049164', u'ENSMUSG00000000751', u'ENSMUSG00000022811', u'ENSMUSG00000063659', u'ENSMUSG00000045427', u'ENSMUSG00000038866', u'ENSMUSG00000046287', u'ENSMUSG00000038535', u'ENSMUSG00000074220', u'ENSMUSG00000024949', u'ENSMUSG00000029345', u'ENSMUSG00000029587', u'ENSMUSG00000030609', u'ENSMUSG00000054256', u'ENSMUSG00000046572', u'ENSMUSG00000042109', u'ENSMUSG00000024268', u'ENSMUSG00000071291', u'ENSMUSG00000042439', u'ENSMUSG00000049672', u'ENSMUSG00000038872', u'ENSMUSG00000068882', u'ENSMUSG00000024217', u'ENSMUSG00000052137', u'ENSMUSG00000037214']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003677', NS='MF', enrichment='e', name='DNA binding', ratio_in_study=(150, 624), ratio_in_pop=(1233, 13836), p_uncorrected=2.280207037776259e-10, depth=4, study_count=150, p_sm_bonferroni=3.5812931735313925e-06, p_fdr_bh=1.1103184308338814e-07, study_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000021668', u'ENSMUSG00000042699', u'ENSMUSG00000059552', u'ENSMUSG00000007080', u'ENSMUSG00000071516', u'ENSMUSG00000020380', u'ENSMUSG00000044934', u'ENSMUSG00000027067', u'ENSMUSG00000028587', u'ENSMUSG00000017146', u'ENSMUSG00000020898', u'ENSMUSG00000034329', u'ENSMUSG00000025912', u'ENSMUSG00000039748', u'ENSMUSG00000020185', u'ENSMUSG00000041147', u'ENSMUSG00000005566', u'ENSMUSG00000016477', u'ENSMUSG00000031885', u'ENSMUSG00000026896', u'ENSMUSG00000030677', u'ENSMUSG00000032555', u'ENSMUSG00000027306', u'ENSMUSG00000027490', u'ENSMUSG00000025498', u'ENSMUSG00000036875', u'ENSMUSG00000030254', u'ENSMUSG00000063021', u'ENSMUSG00000038482', u'ENSMUSG00000056895', u'ENSMUSG00000031004', u'ENSMUSG00000018983', u'ENSMUSG00000029730', u'ENSMUSG00000028702', u'ENSMUSG00000036986', u'ENSMUSG00000019214', u'ENSMUSG00000045102', u'ENSMUSG00000021485', u'ENSMUSG00000035842', u'ENSMUSG00000054717', u'ENSMUSG00000038685', u'ENSMUSG00000049932', u'ENSMUSG00000024912', u'ENSMUSG00000056394', u'ENSMUSG00000052684', u'ENSMUSG00000032397', u'ENSMUSG00000028884', u'ENSMUSG00000027109', u'ENSMUSG00000042439', u'ENSMUSG00000069308', u'ENSMUSG00000028809', u'ENSMUSG00000037868', u'ENSMUSG00000047534', u'ENSMUSG00000069300', u'ENSMUSG00000069301', u'ENSMUSG00000069302', u'ENSMUSG00000033970', u'ENSMUSG00000032409', u'ENSMUSG00000035266', u'ENSMUSG00000027433', u'ENSMUSG00000004099', u'ENSMUSG00000031311', u'ENSMUSG00000008976', u'ENSMUSG00000028896', u'ENSMUSG00000071646', u'ENSMUSG00000037572', u'ENSMUSG00000022673', u'ENSMUSG00000026134', u'ENSMUSG00000052565', u'ENSMUSG00000005370', u'ENSMUSG00000040033', u'ENSMUSG00000042489', u'ENSMUSG00000006585', u'ENSMUSG00000027242', u'ENSMUSG00000023994', u'ENSMUSG00000070034', u'ENSMUSG00000058773', u'ENSMUSG00000033762', u'ENSMUSG00000024833', u'ENSMUSG00000051220', u'ENSMUSG00000030528', u'ENSMUSG00000029363', u'ENSMUSG00000027580', u'ENSMUSG00000042557', u'ENSMUSG00000041238', u'ENSMUSG00000023953', u'ENSMUSG00000026355', u'ENSMUSG00000019961', u'ENSMUSG00000020914', u'ENSMUSG00000034206', u'ENSMUSG00000069272', u'ENSMUSG00000069274', u'ENSMUSG00000024742', u'ENSMUSG00000017861', u'ENSMUSG00000075031', u'ENSMUSG00000035365', u'ENSMUSG00000027514', u'ENSMUSG00000068855', u'ENSMUSG00000026669', u'ENSMUSG00000037214', u'ENSMUSG00000022881', u'ENSMUSG00000046179', u'ENSMUSG00000051235', u'ENSMUSG00000036822', u'ENSMUSG00000032344', u'ENSMUSG00000005410', u'ENSMUSG00000047246', u'ENSMUSG00000040296', u'ENSMUSG00000061991', u'ENSMUSG00000069266', u'ENSMUSG00000027342', u'ENSMUSG00000061482', u'ENSMUSG00000061615', u'ENSMUSG00000069268', u'ENSMUSG00000067455', u'ENSMUSG00000035310', u'ENSMUSG00000020471', u'ENSMUSG00000037188', u'ENSMUSG00000041859', u'ENSMUSG00000044702', u'ENSMUSG00000041827', u'ENSMUSG00000049539', u'ENSMUSG00000017830', u'ENSMUSG00000002870', u'ENSMUSG00000027353', u'ENSMUSG00000026104', u'ENSMUSG00000064168', u'ENSMUSG00000060093', u'ENSMUSG00000038644', u'ENSMUSG00000073705', u'ENSMUSG00000001517', u'ENSMUSG00000018899', u'ENSMUSG00000062727', u'ENSMUSG00000030346', u'ENSMUSG00000034218', u'ENSMUSG00000021377', u'ENSMUSG00000019303', u'ENSMUSG00000001228', u'ENSMUSG00000029177', u'ENSMUSG00000002325', u'ENSMUSG00000033222', u'ENSMUSG00000030042', u'ENSMUSG00000034311', u'ENSMUSG00000020889', u'ENSMUSG00000031697', u'ENSMUSG00000044783', u'ENSMUSG00000064288', u'ENSMUSG00000001103', u'ENSMUSG00000027323']), pop_n=13836, pop_count=1233, pop_items=set([u'ENSMUSG00000026496', u'ENSMUSG00000026491', u'ENSMUSG00000047907', u'ENSMUSG00000030811', u'ENSMUSG00000031374', u'ENSMUSG00000002393', u'ENSMUSG00000059325', u'ENSMUSG00000023927', u'ENSMUSG00000021743', u'ENSMUSG00000020863', u'ENSMUSG00000004897', u'ENSMUSG00000039759', u'ENSMUSG00000031583', u'ENSMUSG00000042197', u'ENSMUSG00000028341', u'ENSMUSG00000038895', u'ENSMUSG00000046691', u'ENSMUSG00000055991', u'ENSMUSG00000037243', u'ENSMUSG00000007080', u'ENSMUSG00000034957', u'ENSMUSG00000030189', u'ENSMUSG00000033454', u'ENSMUSG00000018678', u'ENSMUSG00000047143', u'ENSMUSG00000027667', u'ENSMUSG00000028933', u'ENSMUSG00000030180', u'ENSMUSG00000053950', u'ENSMUSG00000030846', u'ENSMUSG00000027067', u'ENSMUSG00000031902', u'ENSMUSG00000031907', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000031860', u'ENSMUSG00000058301', u'ENSMUSG00000040661', u'ENSMUSG00000021400', u'ENSMUSG00000030166', u'ENSMUSG00000033863', u'ENSMUSG00000051220', u'ENSMUSG00000040681', u'ENSMUSG00000029191', u'ENSMUSG00000034032', u'ENSMUSG00000078671', u'ENSMUSG00000024045', u'ENSMUSG00000063972', u'ENSMUSG00000014303', u'ENSMUSG00000021217', u'ENSMUSG00000031540', u'ENSMUSG00000047371', u'ENSMUSG00000068154', u'ENSMUSG00000031885', u'ENSMUSG00000018102', u'ENSMUSG00000022096', u'ENSMUSG00000036281', u'ENSMUSG00000046101', u'ENSMUSG00000045903', u'ENSMUSG00000033740', u'ENSMUSG00000033970', u'ENSMUSG00000059824', u'ENSMUSG00000044647', u'ENSMUSG00000030443', u'ENSMUSG00000026017', u'ENSMUSG00000032410', u'ENSMUSG00000032411', u'ENSMUSG00000033249', u'ENSMUSG00000018583', u'ENSMUSG00000046351', u'ENSMUSG00000038056', u'ENSMUSG00000026380', u'ENSMUSG00000033943', u'ENSMUSG00000002658', u'ENSMUSG00000001472', u'ENSMUSG00000019850', u'ENSMUSG00000020364', u'ENSMUSG00000047246', u'ENSMUSG00000090258', u'ENSMUSG00000027439', u'ENSMUSG00000049728', u'ENSMUSG00000021326', u'ENSMUSG00000021327', u'ENSMUSG00000067995', u'ENSMUSG00000020538', u'ENSMUSG00000019214', u'ENSMUSG00000032898', u'ENSMUSG00000036983', u'ENSMUSG00000036980', u'ENSMUSG00000015461', u'ENSMUSG00000029634', u'ENSMUSG00000046380', u'ENSMUSG00000032897', u'ENSMUSG00000002870', u'ENSMUSG00000039841', u'ENSMUSG00000003992', u'ENSMUSG00000043059', u'ENSMUSG00000049577', u'ENSMUSG00000053175', u'ENSMUSG00000020453', u'ENSMUSG00000022306', u'ENSMUSG00000019826', u'ENSMUSG00000029127', u'ENSMUSG00000069308', u'ENSMUSG00000028809', u'ENSMUSG00000037868', u'ENSMUSG00000047534', u'ENSMUSG00000030400', u'ENSMUSG00000050240', u'ENSMUSG00000002578', u'ENSMUSG00000069301', u'ENSMUSG00000021287', u'ENSMUSG00000020519', u'ENSMUSG00000045598', u'ENSMUSG00000069306', u'ENSMUSG00000017801', u'ENSMUSG00000035266', u'ENSMUSG00000041272', u'ENSMUSG00000027433', u'ENSMUSG00000031015', u'ENSMUSG00000039219', u'ENSMUSG00000026313', u'ENSMUSG00000075600', u'ENSMUSG00000029253', u'ENSMUSG00000029250', u'ENSMUSG00000032228', u'ENSMUSG00000022536', u'ENSMUSG00000029705', u'ENSMUSG00000028796', u'ENSMUSG00000054199', u'ENSMUSG00000024906', u'ENSMUSG00000028654', u'ENSMUSG00000028896', u'ENSMUSG00000022545', u'ENSMUSG00000061887', u'ENSMUSG00000022237', u'ENSMUSG00000028890', u'ENSMUSG00000000787', u'ENSMUSG00000015937', u'ENSMUSG00000028899', u'ENSMUSG00000069270', u'ENSMUSG00000024220', u'ENSMUSG00000025626', u'ENSMUSG00000005370', u'ENSMUSG00000063049', u'ENSMUSG00000037608', u'ENSMUSG00000034218', u'ENSMUSG00000025025', u'ENSMUSG00000036916', u'ENSMUSG00000037149', u'ENSMUSG00000020962', u'ENSMUSG00000031627', u'ENSMUSG00000039068', u'ENSMUSG00000026610', u'ENSMUSG00000061755', u'ENSMUSG00000042496', u'ENSMUSG00000002111', u'ENSMUSG00000020718', u'ENSMUSG00000070643', u'ENSMUSG00000060639', u'ENSMUSG00000030796', u'ENSMUSG00000032744', u'ENSMUSG00000002052', u'ENSMUSG00000033762', u'ENSMUSG00000024831', u'ENSMUSG00000005493', u'ENSMUSG00000024833', u'ENSMUSG00000067455', u'ENSMUSG00000069895', u'ENSMUSG00000059436', u'ENSMUSG00000037364', u'ENSMUSG00000046982', u'ENSMUSG00000030016', u'ENSMUSG00000025019', u'ENSMUSG00000046792', u'ENSMUSG00000070544', u'ENSMUSG00000047407', u'ENSMUSG00000010175', u'ENSMUSG00000020919', u'ENSMUSG00000027580', u'ENSMUSG00000027582', u'ENSMUSG00000030067', u'ENSMUSG00000027230', u'ENSMUSG00000041235', u'ENSMUSG00000035666', u'ENSMUSG00000004151', u'ENSMUSG00000020914', u'ENSMUSG00000030060', u'ENSMUSG00000043872', u'ENSMUSG00000032555', u'ENSMUSG00000069272', u'ENSMUSG00000052675', u'ENSMUSG00000069274', u'ENSMUSG00000030493', u'ENSMUSG00000021144', u'ENSMUSG00000037447', u'ENSMUSG00000035033', u'ENSMUSG00000015605', u'ENSMUSG00000092035', u'ENSMUSG00000049295', u'ENSMUSG00000059475', u'ENSMUSG00000006050', u'ENSMUSG00000028820', u'ENSMUSG00000030087', u'ENSMUSG00000055435', u'ENSMUSG00000024120', u'ENSMUSG00000042063', u'ENSMUSG00000040596', u'ENSMUSG00000056749', u'ENSMUSG00000030243', u'ENSMUSG00000027905', u'ENSMUSG00000028271', u'ENSMUSG00000037860', u'ENSMUSG00000046668', u'ENSMUSG00000039987', u'ENSMUSG00000026187', u'ENSMUSG00000079509', u'ENSMUSG00000022895', u'ENSMUSG00000025912', u'ENSMUSG00000045991', u'ENSMUSG00000032698', u'ENSMUSG00000032344', u'ENSMUSG00000042548', u'ENSMUSG00000028389', u'ENSMUSG00000041420', u'ENSMUSG00000040296', u'ENSMUSG00000023027', u'ENSMUSG00000031832', u'ENSMUSG00000002028', u'ENSMUSG00000003435', u'ENSMUSG00000020661', u'ENSMUSG00000023021', u'ENSMUSG00000053552', u'ENSMUSG00000008496', u'ENSMUSG00000057469', u'ENSMUSG00000030232', u'ENSMUSG00000041238', u'ENSMUSG00000045268', u'ENSMUSG00000079215', u'ENSMUSG00000069302', u'ENSMUSG00000048100', u'ENSMUSG00000024955', u'ENSMUSG00000034453', u'ENSMUSG00000021366', u'ENSMUSG00000031618', u'ENSMUSG00000015501', u'ENSMUSG00000029131', u'ENSMUSG00000022892', u'ENSMUSG00000039967', u'ENSMUSG00000052565', u'ENSMUSG00000036192', u'ENSMUSG00000032119', u'ENSMUSG00000018411', u'ENSMUSG00000003549', u'ENSMUSG00000039086', u'ENSMUSG00000018143', u'ENSMUSG00000026234', u'ENSMUSG00000036061', u'ENSMUSG00000002625', u'ENSMUSG00000044365', u'ENSMUSG00000029729', u'ENSMUSG00000031681', u'ENSMUSG00000019947', u'ENSMUSG00000003545', u'ENSMUSG00000047003', u'ENSMUSG00000038000', u'ENSMUSG00000042903', u'ENSMUSG00000038002', u'ENSMUSG00000026374', u'ENSMUSG00000056596', u'ENSMUSG00000002983', u'ENSMUSG00000025408', u'ENSMUSG00000003382', u'ENSMUSG00000024151', u'ENSMUSG00000048047', u'ENSMUSG00000073705', u'ENSMUSG00000006705', u'ENSMUSG00000052293', u'ENSMUSG00000018899', u'ENSMUSG00000043716', u'ENSMUSG00000051817', u'ENSMUSG00000061524', u'ENSMUSG00000019261', u'ENSMUSG00000000581', u'ENSMUSG00000059669', u'ENSMUSG00000024750', u'ENSMUSG00000022673', u'ENSMUSG00000022672', u'ENSMUSG00000026872', u'ENSMUSG00000036686', u'ENSMUSG00000038954', u'ENSMUSG00000069268', u'ENSMUSG00000041483', u'ENSMUSG00000044149', u'ENSMUSG00000036721', u'ENSMUSG00000001228', u'ENSMUSG00000039117', u'ENSMUSG00000029177', u'ENSMUSG00000057098', u'ENSMUSG00000017491', u'ENSMUSG00000025470', u'ENSMUSG00000002249', u'ENSMUSG00000029911', u'ENSMUSG00000036875', u'ENSMUSG00000012483', u'ENSMUSG00000002524', u'ENSMUSG00000025577', u'ENSMUSG00000025576', u'ENSMUSG00000059878', u'ENSMUSG00000025902', u'ENSMUSG00000029913', u'ENSMUSG00000041515', u'ENSMUSG00000037001', u'ENSMUSG00000063281', u'ENSMUSG00000079109', u'ENSMUSG00000026803', u'ENSMUSG00000016087', u'ENSMUSG00000039220', u'ENSMUSG00000060678', u'ENSMUSG00000052837', u'ENSMUSG00000005198', u'ENSMUSG00000058388', u'ENSMUSG00000021668', u'ENSMUSG00000020697', u'ENSMUSG00000050295', u'ENSMUSG00000042699', u'ENSMUSG00000001911', u'ENSMUSG00000059540', u'ENSMUSG00000059552', u'ENSMUSG00000042694', u'ENSMUSG00000029328', u'ENSMUSG00000031728', u'ENSMUSG00000034801', u'ENSMUSG00000033016', u'ENSMUSG00000033014', u'ENSMUSG00000001988', u'ENSMUSG00000022476', u'ENSMUSG00000067148', u'ENSMUSG00000038518', u'ENSMUSG00000037138', u'ENSMUSG00000036442', u'ENSMUSG00000022471', u'ENSMUSG00000039087', u'ENSMUSG00000020380', u'ENSMUSG00000025612', u'ENSMUSG00000045639', u'ENSMUSG00000052534', u'ENSMUSG00000028545', u'ENSMUSG00000006678', u'ENSMUSG00000020950', u'ENSMUSG00000020898', u'ENSMUSG00000006673', u'ENSMUSG00000034329', u'ENSMUSG00000037486', u'ENSMUSG00000005583', u'ENSMUSG00000071054', u'ENSMUSG00000040943', u'ENSMUSG00000032369', u'ENSMUSG00000040097', u'ENSMUSG00000051910', u'ENSMUSG00000025409', u'ENSMUSG00000052676', u'ENSMUSG00000033713', u'ENSMUSG00000056608', u'ENSMUSG00000028034', u'ENSMUSG00000023932', u'ENSMUSG00000020185', u'ENSMUSG00000030199', u'ENSMUSG00000071661', u'ENSMUSG00000005566', u'ENSMUSG00000036972', u'ENSMUSG00000018347', u'ENSMUSG00000031575', u'ENSMUSG00000025050', u'ENSMUSG00000003032', u'ENSMUSG00000031585', u'ENSMUSG00000021848', u'ENSMUSG00000005698', u'ENSMUSG00000026788', u'ENSMUSG00000000567', u'ENSMUSG00000041309', u'ENSMUSG00000035125', u'ENSMUSG00000000568', u'ENSMUSG00000066798', u'ENSMUSG00000027306', u'ENSMUSG00000027304', u'ENSMUSG00000030059', u'ENSMUSG00000042185', u'ENSMUSG00000026159', u'ENSMUSG00000026628', u'ENSMUSG00000050919', u'ENSMUSG00000019768', u'ENSMUSG00000057894', u'ENSMUSG00000021615', u'ENSMUSG00000032652', u'ENSMUSG00000038482', u'ENSMUSG00000055305', u'ENSMUSG00000002147', u'ENSMUSG00000031870', u'ENSMUSG00000048118', u'ENSMUSG00000006307', u'ENSMUSG00000021470', u'ENSMUSG00000041740', u'ENSMUSG00000028329', u'ENSMUSG00000017299', u'ENSMUSG00000022389', u'ENSMUSG00000049421', u'ENSMUSG00000034021', u'ENSMUSG00000030271', u'ENSMUSG00000029249', u'ENSMUSG00000045102', u'ENSMUSG00000074406', u'ENSMUSG00000042557', u'ENSMUSG00000023495', u'ENSMUSG00000041126', u'ENSMUSG00000031715', u'ENSMUSG00000030528', u'ENSMUSG00000038425', u'ENSMUSG00000032397', u'ENSMUSG00000036036', u'ENSMUSG00000051510', u'ENSMUSG00000014859', u'ENSMUSG00000041415', u'ENSMUSG00000042439', u'ENSMUSG00000029505', u'ENSMUSG00000014850', u'ENSMUSG00000075595', u'ENSMUSG00000021779', u'ENSMUSG00000026436', u'ENSMUSG00000032405', u'ENSMUSG00000020137', u'ENSMUSG00000032402', u'ENSMUSG00000003500', u'ENSMUSG00000017724', u'ENSMUSG00000034333', u'ENSMUSG00000004934', u'ENSMUSG00000073436', u'ENSMUSG00000021775', u'ENSMUSG00000032409', u'ENSMUSG00000020358', u'ENSMUSG00000020052', u'ENSMUSG00000027430', u'ENSMUSG00000000078', u'ENSMUSG00000027434', u'ENSMUSG00000031099', u'ENSMUSG00000071064', u'ENSMUSG00000040167', u'ENSMUSG00000003282', u'ENSMUSG00000026970', u'ENSMUSG00000032419', u'ENSMUSG00000039850', u'ENSMUSG00000039852', u'ENSMUSG00000022708', u'ENSMUSG00000040732', u'ENSMUSG00000036098', u'ENSMUSG00000053007', u'ENSMUSG00000029135', u'ENSMUSG00000047036', u'ENSMUSG00000063804', u'ENSMUSG00000019837', u'ENSMUSG00000021767', u'ENSMUSG00000021972', u'ENSMUSG00000031706', u'ENSMUSG00000044702', u'ENSMUSG00000022335', u'ENSMUSG00000060257', u'ENSMUSG00000024454', u'ENSMUSG00000006585', u'ENSMUSG00000022760', u'ENSMUSG00000036792', u'ENSMUSG00000028759', u'ENSMUSG00000061911', u'ENSMUSG00000035277', u'ENSMUSG00000036923', u'ENSMUSG00000054737', u'ENSMUSG00000018841', u'ENSMUSG00000058773', u'ENSMUSG00000044636', u'ENSMUSG00000026842', u'ENSMUSG00000040321', u'ENSMUSG00000066687', u'ENSMUSG00000022521', u'ENSMUSG00000030659', u'ENSMUSG00000055148', u'ENSMUSG00000022529', u'ENSMUSG00000022528', u'ENSMUSG00000029363', u'ENSMUSG00000022205', u'ENSMUSG00000029627', u'ENSMUSG00000022201', u'ENSMUSG00000049717', u'ENSMUSG00000006288', u'ENSMUSG00000036376', u'ENSMUSG00000050064', u'ENSMUSG00000005267', u'ENSMUSG00000028639', u'ENSMUSG00000024985', u'ENSMUSG00000034206', u'ENSMUSG00000091405', u'ENSMUSG00000022974', u'ENSMUSG00000038214', u'ENSMUSG00000015882', u'ENSMUSG00000058440', u'ENSMUSG00000025384', u'ENSMUSG00000074622', u'ENSMUSG00000039176', u'ENSMUSG00000028901', u'ENSMUSG00000025225', u'ENSMUSG00000057113', u'ENSMUSG00000026586', u'ENSMUSG00000032178', u'ENSMUSG00000002109', u'ENSMUSG00000002108', u'ENSMUSG00000026669', u'ENSMUSG00000009555', u'ENSMUSG00000029563', u'ENSMUSG00000025364', u'ENSMUSG00000068267', u'ENSMUSG00000025369', u'ENSMUSG00000046179', u'ENSMUSG00000028565', u'ENSMUSG00000008958', u'ENSMUSG00000025316', u'ENSMUSG00000030717', u'ENSMUSG00000024241', u'ENSMUSG00000037174', u'ENSMUSG00000005410', u'ENSMUSG00000000134', u'ENSMUSG00000075266', u'ENSMUSG00000069266', u'ENSMUSG00000027342', u'ENSMUSG00000061482', u'ENSMUSG00000021156', u'ENSMUSG00000042097', u'ENSMUSG00000026740', u'ENSMUSG00000038495', u'ENSMUSG00000039275', u'ENSMUSG00000033222', u'ENSMUSG00000051627', u'ENSMUSG00000029178', u'ENSMUSG00000061991', u'ENSMUSG00000028042', u'ENSMUSG00000032238', u'ENSMUSG00000049038', u'ENSMUSG00000055639', u'ENSMUSG00000041852', u'ENSMUSG00000055116', u'ENSMUSG00000031996', u'ENSMUSG00000043909', u'ENSMUSG00000061079', u'ENSMUSG00000029676', u'ENSMUSG00000069114', u'ENSMUSG00000041911', u'ENSMUSG00000036615', u'ENSMUSG00000040857', u'ENSMUSG00000026663', u'ENSMUSG00000031536', u'ENSMUSG00000031928', u'ENSMUSG00000035877', u'ENSMUSG00000030322', u'ENSMUSG00000046785', u'ENSMUSG00000041459', u'ENSMUSG00000031921', u'ENSMUSG00000045071', u'ENSMUSG00000071637', u'ENSMUSG00000018651', u'ENSMUSG00000035011', u'ENSMUSG00000027985', u'ENSMUSG00000018654', u'ENSMUSG00000030824', u'ENSMUSG00000038648', u'ENSMUSG00000026107', u'ENSMUSG00000048481', u'ENSMUSG00000026104', u'ENSMUSG00000020778', u'ENSMUSG00000052684', u'ENSMUSG00000014767', u'ENSMUSG00000002428', u'ENSMUSG00000004328', u'ENSMUSG00000021546', u'ENSMUSG00000037017', u'ENSMUSG00000001517', u'ENSMUSG00000028634', u'ENSMUSG00000021540', u'ENSMUSG00000071341', u'ENSMUSG00000030346', u'ENSMUSG00000058239', u'ENSMUSG00000034154', u'ENSMUSG00000041859', u'ENSMUSG00000024382', u'ENSMUSG00000055762', u'ENSMUSG00000026082', u'ENSMUSG00000026077', u'ENSMUSG00000021377', u'ENSMUSG00000057406', u'ENSMUSG00000042207', u'ENSMUSG00000037621', u'ENSMUSG00000031666', u'ENSMUSG00000031665', u'ENSMUSG00000019303', u'ENSMUSG00000064288', u'ENSMUSG00000028522', u'ENSMUSG00000051550', u'ENSMUSG00000040463', u'ENSMUSG00000026565', u'ENSMUSG00000059842', u'ENSMUSG00000002325', u'ENSMUSG00000004359', u'ENSMUSG00000033020', u'ENSMUSG00000044786', u'ENSMUSG00000031697', u'ENSMUSG00000044783', u'ENSMUSG00000041703', u'ENSMUSG00000001100', u'ENSMUSG00000024140', u'ENSMUSG00000001103', u'ENSMUSG00000034800', u'ENSMUSG00000019878', u'ENSMUSG00000051034', u'ENSMUSG00000006335', u'ENSMUSG00000033813', u'ENSMUSG00000058385', u'ENSMUSG00000031103', u'ENSMUSG00000049672', u'ENSMUSG00000068739', u'ENSMUSG00000027544', u'ENSMUSG00000038255', u'ENSMUSG00000001288', u'ENSMUSG00000022641', u'ENSMUSG00000009739', u'ENSMUSG00000063889', u'ENSMUSG00000037188', u'ENSMUSG00000001280', u'ENSMUSG00000009733', u'ENSMUSG00000032965', u'ENSMUSG00000002814', u'ENSMUSG00000021494', u'ENSMUSG00000002250', u'ENSMUSG00000048897', u'ENSMUSG00000029167', u'ENSMUSG00000035934', u'ENSMUSG00000058230', u'ENSMUSG00000042406', u'ENSMUSG00000022361', u'ENSMUSG00000006932', u'ENSMUSG00000021945', u'ENSMUSG00000029920', u'ENSMUSG00000034551', u'ENSMUSG00000017861', u'ENSMUSG00000025269', u'ENSMUSG00000052751', u'ENSMUSG00000000776', u'ENSMUSG00000007646', u'ENSMUSG00000063632', u'ENSMUSG00000079056', u'ENSMUSG00000015217', u'ENSMUSG00000049321', u'ENSMUSG00000037492', u'ENSMUSG00000027796', u'ENSMUSG00000015714', u'ENSMUSG00000040310', u'ENSMUSG00000026816', u'ENSMUSG00000009741', u'ENSMUSG00000042589', u'ENSMUSG00000061360', u'ENSMUSG00000028800', u'ENSMUSG00000024968', u'ENSMUSG00000057156', u'ENSMUSG00000058594', u'ENSMUSG00000029754', u'ENSMUSG00000025323', u'ENSMUSG00000028629', u'ENSMUSG00000025218', u'ENSMUSG00000024206', u'ENSMUSG00000063659', u'ENSMUSG00000037640', u'ENSMUSG00000030966', u'ENSMUSG00000027490', u'ENSMUSG00000036023', u'ENSMUSG00000024565', u'ENSMUSG00000041649', u'ENSMUSG00000024563', u'ENSMUSG00000024561', u'ENSMUSG00000024560', u'ENSMUSG00000041168', u'ENSMUSG00000005897', u'ENSMUSG00000063021', u'ENSMUSG00000028807', u'ENSMUSG00000005893', u'ENSMUSG00000021113', u'ENSMUSG00000049658', u'ENSMUSG00000040669', u'ENSMUSG00000037730', u'ENSMUSG00000056459', u'ENSMUSG00000037992', u'ENSMUSG00000037991', u'ENSMUSG00000039771', u'ENSMUSG00000032481', u'ENSMUSG00000042109', u'ENSMUSG00000038718', u'ENSMUSG00000068391', u'ENSMUSG00000074220', u'ENSMUSG00000035842', u'ENSMUSG00000029290', u'ENSMUSG00000028411', u'ENSMUSG00000049932', u'ENSMUSG00000034908', u'ENSMUSG00000030753', u'ENSMUSG00000062861', u'ENSMUSG00000051184', u'ENSMUSG00000035529', u'ENSMUSG00000024513', u'ENSMUSG00000034832', u'ENSMUSG00000024844', u'ENSMUSG00000020287', u'ENSMUSG00000043456', u'ENSMUSG00000024515', u'ENSMUSG00000028484', u'ENSMUSG00000037395', u'ENSMUSG00000049232', u'ENSMUSG00000037465', u'ENSMUSG00000028952', u'ENSMUSG00000071350', u'ENSMUSG00000025049', u'ENSMUSG00000028483', u'ENSMUSG00000026222', u'ENSMUSG00000019817', u'ENSMUSG00000054893', u'ENSMUSG00000029475', u'ENSMUSG00000056216', u'ENSMUSG00000018750', u'ENSMUSG00000033964', u'ENSMUSG00000072115', u'ENSMUSG00000042446', u'ENSMUSG00000035478', u'ENSMUSG00000028318', u'ENSMUSG00000071359', u'ENSMUSG00000001419', u'ENSMUSG00000072872', u'ENSMUSG00000042323', u'ENSMUSG00000048661', u'ENSMUSG00000055024', u'ENSMUSG00000058881', u'ENSMUSG00000022987', u'ENSMUSG00000073423', u'ENSMUSG00000031310', u'ENSMUSG00000031311', u'ENSMUSG00000036672', u'ENSMUSG00000031314', u'ENSMUSG00000036611', u'ENSMUSG00000027035', u'ENSMUSG00000032368', u'ENSMUSG00000005774', u'ENSMUSG00000055053', u'ENSMUSG00000025997', u'ENSMUSG00000068551', u'ENSMUSG00000051469', u'ENSMUSG00000042408', u'ENSMUSG00000026134', u'ENSMUSG00000040033', u'ENSMUSG00000020647', u'ENSMUSG00000002679', u'ENSMUSG00000053477', u'ENSMUSG00000023991', u'ENSMUSG00000023990', u'ENSMUSG00000003923', u'ENSMUSG00000063689', u'ENSMUSG00000031229', u'ENSMUSG00000049184', u'ENSMUSG00000030629', u'ENSMUSG00000027424', u'ENSMUSG00000025959', u'ENSMUSG00000013973', u'ENSMUSG00000062761', u'ENSMUSG00000039473', u'ENSMUSG00000046556', u'ENSMUSG00000044934', u'ENSMUSG00000033726', u'ENSMUSG00000068855', u'ENSMUSG00000019338', u'ENSMUSG00000019230', u'ENSMUSG00000018537', u'ENSMUSG00000051351', u'ENSMUSG00000029027', u'ENSMUSG00000029026', u'ENSMUSG00000045817', u'ENSMUSG00000075376', u'ENSMUSG00000040044', u'ENSMUSG00000049516', u'ENSMUSG00000049553', u'ENSMUSG00000026355', u'ENSMUSG00000036160', u'ENSMUSG00000028587', u'ENSMUSG00000019803', u'ENSMUSG00000021519', u'ENSMUSG00000047412', u'ENSMUSG00000034173', u'ENSMUSG00000001156', u'ENSMUSG00000024420', u'ENSMUSG00000038080', u'ENSMUSG00000034041', u'ENSMUSG00000054051', u'ENSMUSG00000034042', u'ENSMUSG00000021514', u'ENSMUSG00000024740', u'ENSMUSG00000021010', u'ENSMUSG00000020232', u'ENSMUSG00000075031', u'ENSMUSG00000036932', u'ENSMUSG00000035365', u'ENSMUSG00000027514', u'ENSMUSG00000021018', u'ENSMUSG00000044167', u'ENSMUSG00000021109', u'ENSMUSG00000037262', u'ENSMUSG00000056493', u'ENSMUSG00000063870', u'ENSMUSG00000015697', u'ENSMUSG00000016503', u'ENSMUSG00000036779', u'ENSMUSG00000078779', u'ENSMUSG00000033510', u'ENSMUSG00000053985', u'ENSMUSG00000036461', u'ENSMUSG00000038418', u'ENSMUSG00000037692', u'ENSMUSG00000038797', u'ENSMUSG00000032998', u'ENSMUSG00000025498', u'ENSMUSG00000025880', u'ENSMUSG00000001632', u'ENSMUSG00000028702', u'ENSMUSG00000022961', u'ENSMUSG00000027109', u'ENSMUSG00000057691', u'ENSMUSG00000025255', u'ENSMUSG00000037169', u'ENSMUSG00000030921', u'ENSMUSG00000055320', u'ENSMUSG00000043991', u'ENSMUSG00000027104', u'ENSMUSG00000006720', u'ENSMUSG00000021395', u'ENSMUSG00000020335', u'ENSMUSG00000029771', u'ENSMUSG00000043602', u'ENSMUSG00000033585', u'ENSMUSG00000078851', u'ENSMUSG00000029478', u'ENSMUSG00000039748', u'ENSMUSG00000040187', u'ENSMUSG00000069300', u'ENSMUSG00000009406', u'ENSMUSG00000059975', u'ENSMUSG00000025374', u'ENSMUSG00000003154', u'ENSMUSG00000035960', u'ENSMUSG00000046160', u'ENSMUSG00000024817', u'ENSMUSG00000038615', u'ENSMUSG00000024927', u'ENSMUSG00000005373', u'ENSMUSG00000000282', u'ENSMUSG00000022500', u'ENSMUSG00000046541', u'ENSMUSG00000024921', u'ENSMUSG00000055835', u'ENSMUSG00000035397', u'ENSMUSG00000031939', u'ENSMUSG00000027210', u'ENSMUSG00000039630', u'ENSMUSG00000036940', u'ENSMUSG00000038489', u'ENSMUSG00000027353', u'ENSMUSG00000034460', u'ENSMUSG00000068823', u'ENSMUSG00000016477', u'ENSMUSG00000020167', u'ENSMUSG00000041827', u'ENSMUSG00000033730', u'ENSMUSG00000060032', u'ENSMUSG00000020160', u'ENSMUSG00000028053', u'ENSMUSG00000051499', u'ENSMUSG00000049539', u'ENSMUSG00000058638', u'ENSMUSG00000064043', u'ENSMUSG00000005621', u'ENSMUSG00000028423', u'ENSMUSG00000030103', u'ENSMUSG00000054716', u'ENSMUSG00000004880', u'ENSMUSG00000074637', u'ENSMUSG00000028358', u'ENSMUSG00000042570', u'ENSMUSG00000041147', u'ENSMUSG00000031986', u'ENSMUSG00000037235', u'ENSMUSG00000026279', u'ENSMUSG00000038679', u'ENSMUSG00000041360', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000027770', u'ENSMUSG00000071291', u'ENSMUSG00000062012', u'ENSMUSG00000027242', u'ENSMUSG00000041995', u'ENSMUSG00000035285', u'ENSMUSG00000014771', u'ENSMUSG00000027395', u'ENSMUSG00000022105', u'ENSMUSG00000023994', u'ENSMUSG00000032329', u'ENSMUSG00000015053', u'ENSMUSG00000063108', u'ENSMUSG00000008206', u'ENSMUSG00000056394', u'ENSMUSG00000061315', u'ENSMUSG00000000902', u'ENSMUSG00000035158', u'ENSMUSG00000004661', u'ENSMUSG00000004667', u'ENSMUSG00000021264', u'ENSMUSG00000062727', u'ENSMUSG00000070034', u'ENSMUSG00000042472', u'ENSMUSG00000015522', u'ENSMUSG00000018501', u'ENSMUSG00000071516', u'ENSMUSG00000039830', u'ENSMUSG00000068134', u'ENSMUSG00000026890', u'ENSMUSG00000049657', u'ENSMUSG00000018160', u'ENSMUSG00000051390', u'ENSMUSG00000023079', u'ENSMUSG00000031358', u'ENSMUSG00000032035', u'ENSMUSG00000022779', u'ENSMUSG00000019961', u'ENSMUSG00000032745', u'ENSMUSG00000038116', u'ENSMUSG00000036120', u'ENSMUSG00000019841', u'ENSMUSG00000024176', u'ENSMUSG00000039834', u'ENSMUSG00000034673', u'ENSMUSG00000007670', u'ENSMUSG00000024287', u'ENSMUSG00000038342', u'ENSMUSG00000020086', u'ENSMUSG00000043290', u'ENSMUSG00000030057', u'ENSMUSG00000045333', u'ENSMUSG00000020275', u'ENSMUSG00000015942', u'ENSMUSG00000051695', u'ENSMUSG00000027552', u'ENSMUSG00000027551', u'ENSMUSG00000025958', u'ENSMUSG00000048385', u'ENSMUSG00000061517', u'ENSMUSG00000053754', u'ENSMUSG00000071646', u'ENSMUSG00000005045', u'ENSMUSG00000019564', u'ENSMUSG00000026896', u'ENSMUSG00000040712', u'ENSMUSG00000067071', u'ENSMUSG00000014592', u'ENSMUSG00000026305', u'ENSMUSG00000029110', u'ENSMUSG00000043061', u'ENSMUSG00000049600', u'ENSMUSG00000029832', u'ENSMUSG00000029833', u'ENSMUSG00000021485', u'ENSMUSG00000032727', u'ENSMUSG00000020079', u'ENSMUSG00000037896', u'ENSMUSG00000076431', u'ENSMUSG00000037894', u'ENSMUSG00000034522', u'ENSMUSG00000062867', u'ENSMUSG00000093668', u'ENSMUSG00000043668', u'ENSMUSG00000025925', u'ENSMUSG00000038644', u'ENSMUSG00000054766', u'ENSMUSG00000054611', u'ENSMUSG00000056501', u'ENSMUSG00000039158', u'ENSMUSG00000026826', u'ENSMUSG00000039191', u'ENSMUSG00000026820', u'ENSMUSG00000037652', u'ENSMUSG00000031004', u'ENSMUSG00000021127', u'ENSMUSG00000018983', u'ENSMUSG00000054967', u'ENSMUSG00000044519', u'ENSMUSG00000028466', u'ENSMUSG00000029730', u'ENSMUSG00000015709', u'ENSMUSG00000010362', u'ENSMUSG00000001383', u'ENSMUSG00000030678', u'ENSMUSG00000045215', u'ENSMUSG00000015839', u'ENSMUSG00000039656', u'ENSMUSG00000030042', u'ENSMUSG00000024914', u'ENSMUSG00000024912', u'ENSMUSG00000030677', u'ENSMUSG00000046532', u'ENSMUSG00000025332', u'ENSMUSG00000028882', u'ENSMUSG00000028884', u'ENSMUSG00000024218', u'ENSMUSG00000022556', u'ENSMUSG00000029238', u'ENSMUSG00000034227', u'ENSMUSG00000000247', u'ENSMUSG00000041540', u'ENSMUSG00000003184', u'ENSMUSG00000006818', u'ENSMUSG00000001065', u'ENSMUSG00000036867', u'ENSMUSG00000005442', u'ENSMUSG00000052040', u'ENSMUSG00000034738', u'ENSMUSG00000042625', u'ENSMUSG00000048485', u'ENSMUSG00000057133', u'ENSMUSG00000032777', u'ENSMUSG00000090112', u'ENSMUSG00000060981', u'ENSMUSG00000030788', u'ENSMUSG00000003847', u'ENSMUSG00000072294', u'ENSMUSG00000040929', u'ENSMUSG00000037984', u'ENSMUSG00000008575', u'ENSMUSG00000007216', u'ENSMUSG00000039410', u'ENSMUSG00000004099', u'ENSMUSG00000020994', u'ENSMUSG00000028394', u'ENSMUSG00000038290', u'ENSMUSG00000025144', u'ENSMUSG00000066456', u'ENSMUSG00000061878', u'ENSMUSG00000008976', u'ENSMUSG00000045996', u'ENSMUSG00000036181', u'ENSMUSG00000060601', u'ENSMUSG00000001016', u'ENSMUSG00000028099', u'ENSMUSG00000037572', u'ENSMUSG00000048416', u'ENSMUSG00000061013', u'ENSMUSG00000033006', u'ENSMUSG00000027630', u'ENSMUSG00000027323', u'ENSMUSG00000020484', u'ENSMUSG00000018604', u'ENSMUSG00000035456', u'ENSMUSG00000042489', u'ENSMUSG00000048756', u'ENSMUSG00000005148', u'ENSMUSG00000031393', u'ENSMUSG00000034271', u'ENSMUSG00000043969', u'ENSMUSG00000068742', u'ENSMUSG00000054604', u'ENSMUSG00000056820', u'ENSMUSG00000051235', u'ENSMUSG00000046658', u'ENSMUSG00000030094', u'ENSMUSG00000069171', u'ENSMUSG00000038331', u'ENSMUSG00000024137', u'ENSMUSG00000030254', u'ENSMUSG00000049532', u'ENSMUSG00000030256', u'ENSMUSG00000060261', u'ENSMUSG00000030393', u'ENSMUSG00000013089', u'ENSMUSG00000045515', u'ENSMUSG00000071076', u'ENSMUSG00000030557', u'ENSMUSG00000047146', u'ENSMUSG00000038902', u'ENSMUSG00000022383', u'ENSMUSG00000030551', u'ENSMUSG00000007880', u'ENSMUSG00000064168', u'ENSMUSG00000037029', u'ENSMUSG00000048001', u'ENSMUSG00000040289', u'ENSMUSG00000040123', u'ENSMUSG00000037935', u'ENSMUSG00000020653', u'ENSMUSG00000045252', u'ENSMUSG00000023034', u'ENSMUSG00000053560', u'ENSMUSG00000031783', u'ENSMUSG00000020656', u'ENSMUSG00000038705', u'ENSMUSG00000027951', u'ENSMUSG00000026048', u'ENSMUSG00000015092', u'ENSMUSG00000043866', u'ENSMUSG00000020037', u'ENSMUSG00000046876', u'ENSMUSG00000025423', u'ENSMUSG00000000934', u'ENSMUSG00000017830', u'ENSMUSG00000055633', u'ENSMUSG00000021250', u'ENSMUSG00000047141', u'ENSMUSG00000021255', u'ENSMUSG00000048402', u'ENSMUSG00000051238', u'ENSMUSG00000061615', u'ENSMUSG00000022881', u'ENSMUSG00000021318', u'ENSMUSG00000054717', u'ENSMUSG00000031609', u'ENSMUSG00000048012', u'ENSMUSG00000029345', u'ENSMUSG00000023104', u'ENSMUSG00000052942', u'ENSMUSG00000044477', u'ENSMUSG00000040054', u'ENSMUSG00000032515', u'ENSMUSG00000025261', u'ENSMUSG00000029014', u'ENSMUSG00000044807', u'ENSMUSG00000024742', u'ENSMUSG00000002996', u'ENSMUSG00000008393', u'ENSMUSG00000032298', u'ENSMUSG00000010505', u'ENSMUSG00000024431', u'ENSMUSG00000001120', u'ENSMUSG00000054321', u'ENSMUSG00000008398', u'ENSMUSG00000040429', u'ENSMUSG00000006215', u'ENSMUSG00000024002', u'ENSMUSG00000025223', u'ENSMUSG00000045302', u'ENSMUSG00000044390', u'ENSMUSG00000056851', u'ENSMUSG00000055817', u'ENSMUSG00000035310', u'ENSMUSG00000055884', u'ENSMUSG00000034311', u'ENSMUSG00000028150', u'ENSMUSG00000027684', u'ENSMUSG00000062627', u'ENSMUSG00000020248', u'ENSMUSG00000019256', u'ENSMUSG00000020474', u'ENSMUSG00000022508', u'ENSMUSG00000020471', u'ENSMUSG00000020473', u'ENSMUSG00000020472', u'ENSMUSG00000016831', u'ENSMUSG00000011960', u'ENSMUSG00000029267', u'ENSMUSG00000038685', u'ENSMUSG00000029265', u'ENSMUSG00000047473', u'ENSMUSG00000044452', u'ENSMUSG00000058298', u'ENSMUSG00000022346', u'ENSMUSG00000043099', u'ENSMUSG00000036986', u'ENSMUSG00000056895', u'ENSMUSG00000028840', u'ENSMUSG00000046574', u'ENSMUSG00000017485', u'ENSMUSG00000020329', u'ENSMUSG00000058886', u'ENSMUSG00000034674', u'ENSMUSG00000025246', u'ENSMUSG00000020085', u'ENSMUSG00000022952', u'ENSMUSG00000024317', u'ENSMUSG00000054499', u'ENSMUSG00000049164', u'ENSMUSG00000000751', u'ENSMUSG00000022811', u'ENSMUSG00000060093', u'ENSMUSG00000036822', u'ENSMUSG00000038539', u'ENSMUSG00000026761', u'ENSMUSG00000068854', u'ENSMUSG00000040270', u'ENSMUSG00000026641', u'ENSMUSG00000039153', u'ENSMUSG00000038535', u'ENSMUSG00000033430', u'ENSMUSG00000067860', u'ENSMUSG00000074221', u'ENSMUSG00000015846', u'ENSMUSG00000025340', u'ENSMUSG00000024947', u'ENSMUSG00000015843', u'ENSMUSG00000019789', u'ENSMUSG00000003949', u'ENSMUSG00000023953', u'ENSMUSG00000030744', u'ENSMUSG00000042508', u'ENSMUSG00000058318', u'ENSMUSG00000027168', u'ENSMUSG00000022463', u'ENSMUSG00000024548', u'ENSMUSG00000029642', u'ENSMUSG00000046572', u'ENSMUSG00000034701', u'ENSMUSG00000028163', u'ENSMUSG00000048450', u'ENSMUSG00000020923', u'ENSMUSG00000020889', u'ENSMUSG00000048921', u'ENSMUSG00000038415', u'ENSMUSG00000038872', u'ENSMUSG00000052135', u'ENSMUSG00000037214']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0043566'])),
    NtGoeaResults(GO='GO:0003678', NS='MF', enrichment='e', name='DNA helicase activity', ratio_in_study=(6, 624), ratio_in_pop=(16, 13836), p_uncorrected=4.462381350505715e-05, depth=8, study_count=6, p_sm_bonferroni=0.70086161491042764, p_fdr_bh=0.0044927026596822284, study_items=set([u'ENSMUSG00000005410', u'ENSMUSG00000026355', u'ENSMUSG00000029730', u'ENSMUSG00000022673', u'ENSMUSG00000030528', u'ENSMUSG00000002870']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000025209', u'ENSMUSG00000030079', u'ENSMUSG00000034154', u'ENSMUSG00000005410', u'ENSMUSG00000026355', u'ENSMUSG00000003868', u'ENSMUSG00000029730', u'ENSMUSG00000020079', u'ENSMUSG00000022673', u'ENSMUSG00000053754', u'ENSMUSG00000030243', u'ENSMUSG00000058594', u'ENSMUSG00000020752', u'ENSMUSG00000031583', u'ENSMUSG00000030528', u'ENSMUSG00000002870']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0003679'])),
    NtGoeaResults(GO='GO:0003682', NS='MF', enrichment='e', name='chromatin binding', ratio_in_study=(48, 624), ratio_in_pop=(382, 13836), p_uncorrected=1.0577515056012412e-10, depth=2, study_count=48, p_sm_bonferroni=1.6613045146973094e-06, p_fdr_bh=6.6452180587892372e-08, study_items=set([u'ENSMUSG00000022360', u'ENSMUSG00000038252', u'ENSMUSG00000035024', u'ENSMUSG00000024974', u'ENSMUSG00000035842', u'ENSMUSG00000034906', u'ENSMUSG00000046591', u'ENSMUSG00000059552', u'ENSMUSG00000007080', u'ENSMUSG00000034349', u'ENSMUSG00000000028', u'ENSMUSG00000042557', u'ENSMUSG00000019942', u'ENSMUSG00000037868', u'ENSMUSG00000020914', u'ENSMUSG00000017548', u'ENSMUSG00000027067', u'ENSMUSG00000034206', u'ENSMUSG00000028587', u'ENSMUSG00000017146', u'ENSMUSG00000040204', u'ENSMUSG00000034329', u'ENSMUSG00000041133', u'ENSMUSG00000052684', u'ENSMUSG00000038644', u'ENSMUSG00000039748', u'ENSMUSG00000028312', u'ENSMUSG00000023852', u'ENSMUSG00000021374', u'ENSMUSG00000021377', u'ENSMUSG00000005566', u'ENSMUSG00000025001', u'ENSMUSG00000031311', u'ENSMUSG00000027342', u'ENSMUSG00000017499', u'ENSMUSG00000028896', u'ENSMUSG00000071646', u'ENSMUSG00000037572', u'ENSMUSG00000032344', u'ENSMUSG00000005410', u'ENSMUSG00000073705', u'ENSMUSG00000027323', u'ENSMUSG00000027109', u'ENSMUSG00000005370', u'ENSMUSG00000062248', u'ENSMUSG00000006585', u'ENSMUSG00000004099', u'ENSMUSG00000008976']), pop_n=13836, pop_count=382, pop_items=set([u'ENSMUSG00000026496', u'ENSMUSG00000047907', u'ENSMUSG00000006005', u'ENSMUSG00000046591', u'ENSMUSG00000031583', u'ENSMUSG00000007080', u'ENSMUSG00000027660', u'ENSMUSG00000030180', u'ENSMUSG00000027067', u'ENSMUSG00000031902', u'ENSMUSG00000017146', u'ENSMUSG00000045482', u'ENSMUSG00000019777', u'ENSMUSG00000024045', u'ENSMUSG00000023927', u'ENSMUSG00000021217', u'ENSMUSG00000019857', u'ENSMUSG00000026429', u'ENSMUSG00000048170', u'ENSMUSG00000066456', u'ENSMUSG00000020052', u'ENSMUSG00000021327', u'ENSMUSG00000020538', u'ENSMUSG00000024193', u'ENSMUSG00000009575', u'ENSMUSG00000037868', u'ENSMUSG00000006599', u'ENSMUSG00000028800', u'ENSMUSG00000039477', u'ENSMUSG00000029250', u'ENSMUSG00000029703', u'ENSMUSG00000029705', u'ENSMUSG00000028896', u'ENSMUSG00000029221', u'ENSMUSG00000015937', u'ENSMUSG00000005370', u'ENSMUSG00000063049', u'ENSMUSG00000074637', u'ENSMUSG00000037149', u'ENSMUSG00000034748', u'ENSMUSG00000024999', u'ENSMUSG00000047824', u'ENSMUSG00000028576', u'ENSMUSG00000037369', u'ENSMUSG00000050697', u'ENSMUSG00000046982', u'ENSMUSG00000070544', u'ENSMUSG00000020918', u'ENSMUSG00000028397', u'ENSMUSG00000000028', u'ENSMUSG00000030067', u'ENSMUSG00000027230', u'ENSMUSG00000020914', u'ENSMUSG00000062563', u'ENSMUSG00000018921', u'ENSMUSG00000021144', u'ENSMUSG00000037447', u'ENSMUSG00000040204', u'ENSMUSG00000015605', u'ENSMUSG00000042063', u'ENSMUSG00000052812', u'ENSMUSG00000040681', u'ENSMUSG00000031540', u'ENSMUSG00000032698', u'ENSMUSG00000032344', u'ENSMUSG00000041420', u'ENSMUSG00000037286', u'ENSMUSG00000003437', u'ENSMUSG00000002028', u'ENSMUSG00000003435', u'ENSMUSG00000020661', u'ENSMUSG00000021245', u'ENSMUSG00000032119', u'ENSMUSG00000023055', u'ENSMUSG00000019942', u'ENSMUSG00000001134', u'ENSMUSG00000038002', u'ENSMUSG00000025409', u'ENSMUSG00000062270', u'ENSMUSG00000025403', u'ENSMUSG00000020257', u'ENSMUSG00000022338', u'ENSMUSG00000028759', u'ENSMUSG00000017499', u'ENSMUSG00000029673', u'ENSMUSG00000029911', u'ENSMUSG00000025577', u'ENSMUSG00000026803', u'ENSMUSG00000016087', u'ENSMUSG00000023110', u'ENSMUSG00000026923', u'ENSMUSG00000024974', u'ENSMUSG00000059552', u'ENSMUSG00000030752', u'ENSMUSG00000033016', u'ENSMUSG00000022475', u'ENSMUSG00000020381', u'ENSMUSG00000028587', u'ENSMUSG00000006678', u'ENSMUSG00000034329', u'ENSMUSG00000005583', u'ENSMUSG00000071054', u'ENSMUSG00000032498', u'ENSMUSG00000039748', u'ENSMUSG00000002983', u'ENSMUSG00000039741', u'ENSMUSG00000042182', u'ENSMUSG00000005566', u'ENSMUSG00000025128', u'ENSMUSG00000008855', u'ENSMUSG00000005045', u'ENSMUSG00000000567', u'ENSMUSG00000000568', u'ENSMUSG00000019768', u'ENSMUSG00000048001', u'ENSMUSG00000016624', u'ENSMUSG00000023018', u'ENSMUSG00000020160', u'ENSMUSG00000026436', u'ENSMUSG00000026434', u'ENSMUSG00000032402', u'ENSMUSG00000022019', u'ENSMUSG00000031393', u'ENSMUSG00000027434', u'ENSMUSG00000000708', u'ENSMUSG00000031622', u'ENSMUSG00000039910', u'ENSMUSG00000039852', u'ENSMUSG00000040732', u'ENSMUSG00000029135', u'ENSMUSG00000024454', u'ENSMUSG00000006585', u'ENSMUSG00000036792', u'ENSMUSG00000031026', u'ENSMUSG00000022521', u'ENSMUSG00000029249', u'ENSMUSG00000022528', u'ENSMUSG00000030652', u'ENSMUSG00000024985', u'ENSMUSG00000006288', u'ENSMUSG00000024335', u'ENSMUSG00000028639', u'ENSMUSG00000025223', u'ENSMUSG00000034206', u'ENSMUSG00000075028', u'ENSMUSG00000025225', u'ENSMUSG00000041133', u'ENSMUSG00000039176', u'ENSMUSG00000014074', u'ENSMUSG00000009555', u'ENSMUSG00000027671', u'ENSMUSG00000068267', u'ENSMUSG00000025001', u'ENSMUSG00000025369', u'ENSMUSG00000028565', u'ENSMUSG00000055884', u'ENSMUSG00000030717', u'ENSMUSG00000034271', u'ENSMUSG00000041229', u'ENSMUSG00000005410', u'ENSMUSG00000059518', u'ENSMUSG00000035576', u'ENSMUSG00000027342', u'ENSMUSG00000035478', u'ENSMUSG00000047777', u'ENSMUSG00000028369', u'ENSMUSG00000039630', u'ENSMUSG00000008305', u'ENSMUSG00000021738', u'ENSMUSG00000046876', u'ENSMUSG00000061079', u'ENSMUSG00000041911', u'ENSMUSG00000018651', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000044950', u'ENSMUSG00000038644', u'ENSMUSG00000068428', u'ENSMUSG00000025862', u'ENSMUSG00000024387', u'ENSMUSG00000021374', u'ENSMUSG00000021377', u'ENSMUSG00000018476', u'ENSMUSG00000018572', u'ENSMUSG00000031665', u'ENSMUSG00000026565', u'ENSMUSG00000062248', u'ENSMUSG00000038252', u'ENSMUSG00000029196', u'ENSMUSG00000027544', u'ENSMUSG00000020453', u'ENSMUSG00000058301', u'ENSMUSG00000026313', u'ENSMUSG00000029167', u'ENSMUSG00000053754', u'ENSMUSG00000022360', u'ENSMUSG00000006932', u'ENSMUSG00000017548', u'ENSMUSG00000029922', u'ENSMUSG00000028820', u'ENSMUSG00000000776', u'ENSMUSG00000029687', u'ENSMUSG00000025280', u'ENSMUSG00000079487', u'ENSMUSG00000038518', u'ENSMUSG00000030619', u'ENSMUSG00000024563', u'ENSMUSG00000024561', u'ENSMUSG00000032481', u'ENSMUSG00000032480', u'ENSMUSG00000034906', u'ENSMUSG00000025138', u'ENSMUSG00000039671', u'ENSMUSG00000035842', u'ENSMUSG00000028411', u'ENSMUSG00000052684', u'ENSMUSG00000048402', u'ENSMUSG00000024513', u'ENSMUSG00000024515', u'ENSMUSG00000028484', u'ENSMUSG00000034349', u'ENSMUSG00000015149', u'ENSMUSG00000021911', u'ENSMUSG00000028312', u'ENSMUSG00000021156', u'ENSMUSG00000042323', u'ENSMUSG00000055024', u'ENSMUSG00000031311', u'ENSMUSG00000071646', u'ENSMUSG00000039191', u'ENSMUSG00000022141', u'ENSMUSG00000020647', u'ENSMUSG00000053477', u'ENSMUSG00000020122', u'ENSMUSG00000038679', u'ENSMUSG00000003923', u'ENSMUSG00000031229', u'ENSMUSG00000032187', u'ENSMUSG00000018548', u'ENSMUSG00000018537', u'ENSMUSG00000029026', u'ENSMUSG00000049553', u'ENSMUSG00000021901', u'ENSMUSG00000090083', u'ENSMUSG00000054051', u'ENSMUSG00000059288', u'ENSMUSG00000021514', u'ENSMUSG00000038369', u'ENSMUSG00000031134', u'ENSMUSG00000026918', u'ENSMUSG00000015697', u'ENSMUSG00000024325', u'ENSMUSG00000027109', u'ENSMUSG00000066613', u'ENSMUSG00000027104', u'ENSMUSG00000020335', u'ENSMUSG00000029478', u'ENSMUSG00000009406', u'ENSMUSG00000059439', u'ENSMUSG00000028518', u'ENSMUSG00000024927', u'ENSMUSG00000024926', u'ENSMUSG00000000282', u'ENSMUSG00000024921', u'ENSMUSG00000037111', u'ENSMUSG00000036940', u'ENSMUSG00000020167', u'ENSMUSG00000082229', u'ENSMUSG00000026484', u'ENSMUSG00000029505', u'ENSMUSG00000028053', u'ENSMUSG00000058638', u'ENSMUSG00000025104', u'ENSMUSG00000040669', u'ENSMUSG00000037343', u'ENSMUSG00000030421', u'ENSMUSG00000038225', u'ENSMUSG00000027678', u'ENSMUSG00000035024', u'ENSMUSG00000057406', u'ENSMUSG00000021743', u'ENSMUSG00000052889', u'ENSMUSG00000015053', u'ENSMUSG00000021264', u'ENSMUSG00000029050', u'ENSMUSG00000018501', u'ENSMUSG00000022178', u'ENSMUSG00000018160', u'ENSMUSG00000040007', u'ENSMUSG00000031386', u'ENSMUSG00000053110', u'ENSMUSG00000016409', u'ENSMUSG00000024283', u'ENSMUSG00000020275', u'ENSMUSG00000005698', u'ENSMUSG00000019564', u'ENSMUSG00000040712', u'ENSMUSG00000021488', u'ENSMUSG00000029111', u'ENSMUSG00000022314', u'ENSMUSG00000029833', u'ENSMUSG00000006920', u'ENSMUSG00000043668', u'ENSMUSG00000056501', u'ENSMUSG00000026739', u'ENSMUSG00000038331', u'ENSMUSG00000030678', u'ENSMUSG00000046532', u'ENSMUSG00000037791', u'ENSMUSG00000022556', u'ENSMUSG00000030970', u'ENSMUSG00000000247', u'ENSMUSG00000036867', u'ENSMUSG00000005442', u'ENSMUSG00000005886', u'ENSMUSG00000049300', u'ENSMUSG00000023852', u'ENSMUSG00000037070', u'ENSMUSG00000020919', u'ENSMUSG00000004099', u'ENSMUSG00000028466', u'ENSMUSG00000043439', u'ENSMUSG00000008976', u'ENSMUSG00000055204', u'ENSMUSG00000028949', u'ENSMUSG00000037572', u'ENSMUSG00000073705', u'ENSMUSG00000027323', u'ENSMUSG00000021635', u'ENSMUSG00000035456', u'ENSMUSG00000028496', u'ENSMUSG00000028309', u'ENSMUSG00000046711', u'ENSMUSG00000006362', u'ENSMUSG00000027936', u'ENSMUSG00000063576', u'ENSMUSG00000030557', u'ENSMUSG00000026283', u'ENSMUSG00000042557', u'ENSMUSG00000053647', u'ENSMUSG00000032376', u'ENSMUSG00000030493', u'ENSMUSG00000020037', u'ENSMUSG00000000838', u'ENSMUSG00000021250', u'ENSMUSG00000021318', u'ENSMUSG00000057455', u'ENSMUSG00000067567', u'ENSMUSG00000026349', u'ENSMUSG00000053801', u'ENSMUSG00000053411', u'ENSMUSG00000029014', u'ENSMUSG00000047407', u'ENSMUSG00000024431', u'ENSMUSG00000039989', u'ENSMUSG00000024002', u'ENSMUSG00000055817', u'ENSMUSG00000002833', u'ENSMUSG00000022508', u'ENSMUSG00000039804', u'ENSMUSG00000035277', u'ENSMUSG00000011960', u'ENSMUSG00000057672', u'ENSMUSG00000017485', u'ENSMUSG00000025246', u'ENSMUSG00000024642', u'ENSMUSG00000034673', u'ENSMUSG00000000751', u'ENSMUSG00000038539', u'ENSMUSG00000039153', u'ENSMUSG00000026646', u'ENSMUSG00000033006', u'ENSMUSG00000024947', u'ENSMUSG00000037032', u'ENSMUSG00000025982', u'ENSMUSG00000058318', u'ENSMUSG00000027168', u'ENSMUSG00000022463', u'ENSMUSG00000028886', u'ENSMUSG00000034701', u'ENSMUSG00000028163', u'ENSMUSG00000020923']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003684', NS='MF', enrichment='e', name='damaged DNA binding', ratio_in_study=(13, 624), ratio_in_pop=(48, 13836), p_uncorrected=1.26541467064009e-07, depth=5, study_count=13, p_sm_bonferroni=0.0019874602817073254, p_fdr_bh=2.6150793180359543e-05, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000051768', u'ENSMUSG00000054717', u'ENSMUSG00000041238', u'ENSMUSG00000021668', u'ENSMUSG00000005370', u'ENSMUSG00000027342', u'ENSMUSG00000017146', u'ENSMUSG00000059552', u'ENSMUSG00000028884', u'ENSMUSG00000049932', u'ENSMUSG00000023953', u'ENSMUSG00000038644']), pop_n=13836, pop_count=48, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000038644', u'ENSMUSG00000030094', u'ENSMUSG00000028329', u'ENSMUSG00000053914', u'ENSMUSG00000031095', u'ENSMUSG00000021668', u'ENSMUSG00000022521', u'ENSMUSG00000059552', u'ENSMUSG00000035960', u'ENSMUSG00000029591', u'ENSMUSG00000025077', u'ENSMUSG00000028411', u'ENSMUSG00000049932', u'ENSMUSG00000038425', u'ENSMUSG00000027845', u'ENSMUSG00000003549', u'ENSMUSG00000028884', u'ENSMUSG00000022471', u'ENSMUSG00000023953', u'ENSMUSG00000014850', u'ENSMUSG00000017146', u'ENSMUSG00000022248', u'ENSMUSG00000000751', u'ENSMUSG00000024740', u'ENSMUSG00000026648', u'ENSMUSG00000031536', u'ENSMUSG00000054717', u'ENSMUSG00000002109', u'ENSMUSG00000026082', u'ENSMUSG00000029026', u'ENSMUSG00000028426', u'ENSMUSG00000068742', u'ENSMUSG00000055024', u'ENSMUSG00000030271', u'ENSMUSG00000026187', u'ENSMUSG00000030744', u'ENSMUSG00000051768', u'ENSMUSG00000022545', u'ENSMUSG00000024151', u'ENSMUSG00000041238', u'ENSMUSG00000029387', u'ENSMUSG00000012483', u'ENSMUSG00000032298', u'ENSMUSG00000005370', u'ENSMUSG00000027342', u'ENSMUSG00000043909', u'ENSMUSG00000003813']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003688', NS='MF', enrichment='e', name='DNA replication origin binding', ratio_in_study=(7, 624), ratio_in_pop=(13, 13836), p_uncorrected=4.967263163698786e-07, depth=7, study_count=7, p_sm_bonferroni=0.0078015835249053136, p_fdr_bh=8.5731687086871579e-05, study_items=set([u'ENSMUSG00000000028', u'ENSMUSG00000005410', u'ENSMUSG00000026669', u'ENSMUSG00000031697', u'ENSMUSG00000035842', u'ENSMUSG00000042699', u'ENSMUSG00000002870']), pop_n=13836, pop_count=13, pop_items=set([u'ENSMUSG00000026761', u'ENSMUSG00000000028', u'ENSMUSG00000040044', u'ENSMUSG00000053801', u'ENSMUSG00000038909', u'ENSMUSG00000005410', u'ENSMUSG00000029012', u'ENSMUSG00000042699', u'ENSMUSG00000026669', u'ENSMUSG00000026037', u'ENSMUSG00000035842', u'ENSMUSG00000031697', u'ENSMUSG00000002870']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003689', NS='MF', enrichment='e', name='DNA clamp loader activity', ratio_in_study=(4, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.0002480312688115781, depth=11, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=0.019477895539773228, study_items=set([u'ENSMUSG00000019214', u'ENSMUSG00000033970', u'ENSMUSG00000029363', u'ENSMUSG00000022881']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000023104', u'ENSMUSG00000021635', u'ENSMUSG00000029191', u'ENSMUSG00000019214', u'ENSMUSG00000022881', u'ENSMUSG00000046691', u'ENSMUSG00000033970', u'ENSMUSG00000029363']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003690', NS='MF', enrichment='e', name='double-stranded DNA binding', ratio_in_study=(17, 624), ratio_in_pop=(110, 13836), p_uncorrected=8.165054327518069e-06, depth=5, study_count=17, p_sm_bonferroni=0.1282403432679988, p_fdr_bh=0.00097151775203029381, study_items=set([u'ENSMUSG00000073705', u'ENSMUSG00000039997', u'ENSMUSG00000054717', u'ENSMUSG00000021374', u'ENSMUSG00000032344', u'ENSMUSG00000026536', u'ENSMUSG00000020380', u'ENSMUSG00000040296', u'ENSMUSG00000027323', u'ENSMUSG00000027109', u'ENSMUSG00000090272', u'ENSMUSG00000005370', u'ENSMUSG00000042699', u'ENSMUSG00000030346', u'ENSMUSG00000026104', u'ENSMUSG00000035842', u'ENSMUSG00000052684']), pop_n=13836, pop_count=110, pop_items=set([u'ENSMUSG00000027466', u'ENSMUSG00000029191', u'ENSMUSG00000042699', u'ENSMUSG00000029328', u'ENSMUSG00000001280', u'ENSMUSG00000058239', u'ENSMUSG00000037138', u'ENSMUSG00000066568', u'ENSMUSG00000022471', u'ENSMUSG00000028933', u'ENSMUSG00000043263', u'ENSMUSG00000020380', u'ENSMUSG00000006932', u'ENSMUSG00000006678', u'ENSMUSG00000007646', u'ENSMUSG00000071054', u'ENSMUSG00000024045', u'ENSMUSG00000037860', u'ENSMUSG00000066551', u'ENSMUSG00000024563', u'ENSMUSG00000000078', u'ENSMUSG00000071076', u'ENSMUSG00000048001', u'ENSMUSG00000022389', u'ENSMUSG00000035842', u'ENSMUSG00000028411', u'ENSMUSG00000052684', u'ENSMUSG00000026536', u'ENSMUSG00000021779', u'ENSMUSG00000026434', u'ENSMUSG00000032402', u'ENSMUSG00000021287', u'ENSMUSG00000042625', u'ENSMUSG00000020052', u'ENSMUSG00000049038', u'ENSMUSG00000008575', u'ENSMUSG00000020919', u'ENSMUSG00000031157', u'ENSMUSG00000002963', u'ENSMUSG00000025144', u'ENSMUSG00000037262', u'ENSMUSG00000055053', u'ENSMUSG00000040429', u'ENSMUSG00000029135', u'ENSMUSG00000052837', u'ENSMUSG00000073705', u'ENSMUSG00000027323', u'ENSMUSG00000005370', u'ENSMUSG00000053477', u'ENSMUSG00000054604', u'ENSMUSG00000018841', u'ENSMUSG00000027427', u'ENSMUSG00000025958', u'ENSMUSG00000066687', u'ENSMUSG00000003032', u'ENSMUSG00000090272', u'ENSMUSG00000038542', u'ENSMUSG00000070544', u'ENSMUSG00000029026', u'ENSMUSG00000039997', u'ENSMUSG00000021519', u'ENSMUSG00000037849', u'ENSMUSG00000001524', u'ENSMUSG00000073490', u'ENSMUSG00000055435', u'ENSMUSG00000021250', u'ENSMUSG00000020038', u'ENSMUSG00000041459', u'ENSMUSG00000026187', u'ENSMUSG00000038418', u'ENSMUSG00000032212', u'ENSMUSG00000034271', u'ENSMUSG00000032344', u'ENSMUSG00000040296', u'ENSMUSG00000027109', u'ENSMUSG00000024431', u'ENSMUSG00000026048', u'ENSMUSG00000001120', u'ENSMUSG00000021156', u'ENSMUSG00000037921', u'ENSMUSG00000051627', u'ENSMUSG00000056216', u'ENSMUSG00000039630', u'ENSMUSG00000073491', u'ENSMUSG00000009406', u'ENSMUSG00000031618', u'ENSMUSG00000043991', u'ENSMUSG00000022346', u'ENSMUSG00000003545', u'ENSMUSG00000034674', u'ENSMUSG00000058594', u'ENSMUSG00000026104', u'ENSMUSG00000024151', u'ENSMUSG00000022811', u'ENSMUSG00000021546', u'ENSMUSG00000054717', u'ENSMUSG00000030346', u'ENSMUSG00000026641', u'ENSMUSG00000073489', u'ENSMUSG00000021374', u'ENSMUSG00000015846', u'ENSMUSG00000022672', u'ENSMUSG00000024947', u'ENSMUSG00000027168', u'ENSMUSG00000004043', u'ENSMUSG00000026273', u'ENSMUSG00000034701', u'ENSMUSG00000028163', u'ENSMUSG00000021177', u'ENSMUSG00000031858']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003691', NS='MF', enrichment='e', name='double-stranded telomeric DNA binding', ratio_in_study=(1, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.33996234399139486, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020380']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000022471', u'ENSMUSG00000031921', u'ENSMUSG00000020380', u'ENSMUSG00000028952', u'ENSMUSG00000021972', u'ENSMUSG00000043991', u'ENSMUSG00000035960', u'ENSMUSG00000025925', u'ENSMUSG00000026187']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003692', NS='MF', enrichment='e', name='left-handed Z-DNA binding', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027514']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000027951', u'ENSMUSG00000027514']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003697', NS='MF', enrichment='e', name='single-stranded DNA binding', ratio_in_study=(19, 624), ratio_in_pop=(78, 13836), p_uncorrected=1.133122283094298e-09, depth=5, study_count=19, p_sm_bonferroni=1.7796818578279044e-05, p_fdr_bh=4.2373377567331055e-07, study_items=set([u'ENSMUSG00000026355', u'ENSMUSG00000028884', u'ENSMUSG00000028312', u'ENSMUSG00000030346', u'ENSMUSG00000034349', u'ENSMUSG00000029730', u'ENSMUSG00000026134', u'ENSMUSG00000026669', u'ENSMUSG00000027323', u'ENSMUSG00000022673', u'ENSMUSG00000042699', u'ENSMUSG00000020898', u'ENSMUSG00000035842', u'ENSMUSG00000000028', u'ENSMUSG00000025395', u'ENSMUSG00000041147', u'ENSMUSG00000035958', u'ENSMUSG00000030528', u'ENSMUSG00000025134']), pop_n=13836, pop_count=78, pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000034349', u'ENSMUSG00000056820', u'ENSMUSG00000018841', u'ENSMUSG00000039630', u'ENSMUSG00000041147', u'ENSMUSG00000021245', u'ENSMUSG00000026843', u'ENSMUSG00000042699', u'ENSMUSG00000025374', u'ENSMUSG00000042694', u'ENSMUSG00000035842', u'ENSMUSG00000026098', u'ENSMUSG00000029328', u'ENSMUSG00000030528', u'ENSMUSG00000025134', u'ENSMUSG00000025209', u'ENSMUSG00000022205', u'ENSMUSG00000003992', u'ENSMUSG00000000028', u'ENSMUSG00000030094', u'ENSMUSG00000028099', u'ENSMUSG00000028933', u'ENSMUSG00000036061', u'ENSMUSG00000024258', u'ENSMUSG00000026355', u'ENSMUSG00000014850', u'ENSMUSG00000027304', u'ENSMUSG00000030346', u'ENSMUSG00000006498', u'ENSMUSG00000026107', u'ENSMUSG00000033099', u'ENSMUSG00000040761', u'ENSMUSG00000020898', u'ENSMUSG00000026374', u'ENSMUSG00000020778', u'ENSMUSG00000007646', u'ENSMUSG00000061887', u'ENSMUSG00000024151', u'ENSMUSG00000026048', u'ENSMUSG00000058594', u'ENSMUSG00000021546', u'ENSMUSG00000070544', u'ENSMUSG00000030166', u'ENSMUSG00000028312', u'ENSMUSG00000030189', u'ENSMUSG00000021018', u'ENSMUSG00000024317', u'ENSMUSG00000041168', u'ENSMUSG00000024120', u'ENSMUSG00000026134', u'ENSMUSG00000022673', u'ENSMUSG00000003549', u'ENSMUSG00000035958', u'ENSMUSG00000026434', u'ENSMUSG00000051695', u'ENSMUSG00000028884', u'ENSMUSG00000068742', u'ENSMUSG00000026669', u'ENSMUSG00000021287', u'ENSMUSG00000071662', u'ENSMUSG00000030057', u'ENSMUSG00000022545', u'ENSMUSG00000000751', u'ENSMUSG00000028639', u'ENSMUSG00000029730', u'ENSMUSG00000027770', u'ENSMUSG00000029911', u'ENSMUSG00000012483', u'ENSMUSG00000027323', u'ENSMUSG00000026234', u'ENSMUSG00000051238', u'ENSMUSG00000037601', u'ENSMUSG00000043991', u'ENSMUSG00000025395', u'ENSMUSG00000021177', u'ENSMUSG00000079109', u'ENSMUSG00000026999']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0003698', 'GO:0003699'])),
    NtGoeaResults(GO='GO:0003700', NS='MF', enrichment='e', name='DNA binding transcription factor activity', ratio_in_study=(27, 624), ratio_in_pop=(573, 13836), p_uncorrected=0.7581823197781257, depth=2, study_count=27, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020889', u'ENSMUSG00000018983', u'ENSMUSG00000059552', u'ENSMUSG00000054717', u'ENSMUSG00000024912', u'ENSMUSG00000052684', u'ENSMUSG00000042557', u'ENSMUSG00000027109', u'ENSMUSG00000044934', u'ENSMUSG00000037868', u'ENSMUSG00000026104', u'ENSMUSG00000038482', u'ENSMUSG00000001517', u'ENSMUSG00000018899', u'ENSMUSG00000039501', u'ENSMUSG00000020185', u'ENSMUSG00000005566', u'ENSMUSG00000046179', u'ENSMUSG00000008976', u'ENSMUSG00000071646', u'ENSMUSG00000025498', u'ENSMUSG00000027490', u'ENSMUSG00000002325', u'ENSMUSG00000040033', u'ENSMUSG00000027361', u'ENSMUSG00000016477', u'ENSMUSG00000023994']), pop_n=13836, pop_count=573, pop_items=set([u'ENSMUSG00000028634', u'ENSMUSG00000026491', u'ENSMUSG00000002393', u'ENSMUSG00000023927', u'ENSMUSG00000027387', u'ENSMUSG00000028341', u'ENSMUSG00000030446', u'ENSMUSG00000034957', u'ENSMUSG00000023284', u'ENSMUSG00000027667', u'ENSMUSG00000030180', u'ENSMUSG00000031902', u'ENSMUSG00000035033', u'ENSMUSG00000049295', u'ENSMUSG00000031860', u'ENSMUSG00000019777', u'ENSMUSG00000022010', u'ENSMUSG00000042745', u'ENSMUSG00000039501', u'ENSMUSG00000014303', u'ENSMUSG00000068154', u'ENSMUSG00000057551', u'ENSMUSG00000059824', u'ENSMUSG00000042292', u'ENSMUSG00000026017', u'ENSMUSG00000061894', u'ENSMUSG00000032411', u'ENSMUSG00000033249', u'ENSMUSG00000060336', u'ENSMUSG00000026380', u'ENSMUSG00000033943', u'ENSMUSG00000074166', u'ENSMUSG00000001472', u'ENSMUSG00000020364', u'ENSMUSG00000020052', u'ENSMUSG00000062743', u'ENSMUSG00000021327', u'ENSMUSG00000020538', u'ENSMUSG00000056493', u'ENSMUSG00000078868', u'ENSMUSG00000036980', u'ENSMUSG00000015461', u'ENSMUSG00000063889', u'ENSMUSG00000078861', u'ENSMUSG00000032897', u'ENSMUSG00000078867', u'ENSMUSG00000078866', u'ENSMUSG00000078864', u'ENSMUSG00000053175', u'ENSMUSG00000019826', u'ENSMUSG00000037868', u'ENSMUSG00000028800', u'ENSMUSG00000034538', u'ENSMUSG00000017801', u'ENSMUSG00000038342', u'ENSMUSG00000058239', u'ENSMUSG00000058402', u'ENSMUSG00000029313', u'ENSMUSG00000028654', u'ENSMUSG00000028890', u'ENSMUSG00000043602', u'ENSMUSG00000028899', u'ENSMUSG00000005373', u'ENSMUSG00000078903', u'ENSMUSG00000074637', u'ENSMUSG00000063047', u'ENSMUSG00000017667', u'ENSMUSG00000063108', u'ENSMUSG00000026610', u'ENSMUSG00000002111', u'ENSMUSG00000059897', u'ENSMUSG00000030796', u'ENSMUSG00000032744', u'ENSMUSG00000002052', u'ENSMUSG00000090641', u'ENSMUSG00000039656', u'ENSMUSG00000025019', u'ENSMUSG00000010175', u'ENSMUSG00000020919', u'ENSMUSG00000027582', u'ENSMUSG00000067928', u'ENSMUSG00000030067', u'ENSMUSG00000027230', u'ENSMUSG00000004151', u'ENSMUSG00000052675', u'ENSMUSG00000021144', u'ENSMUSG00000034998', u'ENSMUSG00000048728', u'ENSMUSG00000030087', u'ENSMUSG00000055435', u'ENSMUSG00000003949', u'ENSMUSG00000042063', u'ENSMUSG00000071291', u'ENSMUSG00000056749', u'ENSMUSG00000051037', u'ENSMUSG00000007872', u'ENSMUSG00000042390', u'ENSMUSG00000023027', u'ENSMUSG00000038718', u'ENSMUSG00000092416', u'ENSMUSG00000008496', u'ENSMUSG00000066687', u'ENSMUSG00000037029', u'ENSMUSG00000022895', u'ENSMUSG00000031618', u'ENSMUSG00000015501', u'ENSMUSG00000057469', u'ENSMUSG00000036192', u'ENSMUSG00000032119', u'ENSMUSG00000067860', u'ENSMUSG00000039086', u'ENSMUSG00000018143', u'ENSMUSG00000020485', u'ENSMUSG00000063281', u'ENSMUSG00000039089', u'ENSMUSG00000031681', u'ENSMUSG00000031728', u'ENSMUSG00000042903', u'ENSMUSG00000002983', u'ENSMUSG00000025408', u'ENSMUSG00000003382', u'ENSMUSG00000021848', u'ENSMUSG00000061371', u'ENSMUSG00000018899', u'ENSMUSG00000063972', u'ENSMUSG00000044636', u'ENSMUSG00000058331', u'ENSMUSG00000041483', u'ENSMUSG00000036721', u'ENSMUSG00000054381', u'ENSMUSG00000033883', u'ENSMUSG00000017491', u'ENSMUSG00000002249', u'ENSMUSG00000032238', u'ENSMUSG00000024498', u'ENSMUSG00000047264', u'ENSMUSG00000025902', u'ENSMUSG00000037621', u'ENSMUSG00000041515', u'ENSMUSG00000067942', u'ENSMUSG00000016087', u'ENSMUSG00000001911', u'ENSMUSG00000059552', u'ENSMUSG00000003545', u'ENSMUSG00000033016', u'ENSMUSG00000037138', u'ENSMUSG00000025997', u'ENSMUSG00000039087', u'ENSMUSG00000025612', u'ENSMUSG00000045639', u'ENSMUSG00000052534', u'ENSMUSG00000020954', u'ENSMUSG00000020950', u'ENSMUSG00000021109', u'ENSMUSG00000005583', u'ENSMUSG00000038615', u'ENSMUSG00000047603', u'ENSMUSG00000033713', u'ENSMUSG00000072763', u'ENSMUSG00000020185', u'ENSMUSG00000005566', u'ENSMUSG00000054967', u'ENSMUSG00000018697', u'ENSMUSG00000018347', u'ENSMUSG00000025050', u'ENSMUSG00000003032', u'ENSMUSG00000005698', u'ENSMUSG00000030199', u'ENSMUSG00000037007', u'ENSMUSG00000035125', u'ENSMUSG00000042507', u'ENSMUSG00000050855', u'ENSMUSG00000026628', u'ENSMUSG00000019768', u'ENSMUSG00000032652', u'ENSMUSG00000038482', u'ENSMUSG00000002147', u'ENSMUSG00000031870', u'ENSMUSG00000022383', u'ENSMUSG00000022389', u'ENSMUSG00000045519', u'ENSMUSG00000049086', u'ENSMUSG00000045515', u'ENSMUSG00000059839', u'ENSMUSG00000014859', u'ENSMUSG00000032398', u'ENSMUSG00000021779', u'ENSMUSG00000026436', u'ENSMUSG00000038766', u'ENSMUSG00000032402', u'ENSMUSG00000078779', u'ENSMUSG00000017724', u'ENSMUSG00000034333', u'ENSMUSG00000021775', u'ENSMUSG00000020358', u'ENSMUSG00000031393', u'ENSMUSG00000062040', u'ENSMUSG00000027434', u'ENSMUSG00000039910', u'ENSMUSG00000031627', u'ENSMUSG00000032419', u'ENSMUSG00000044676', u'ENSMUSG00000039852', u'ENSMUSG00000040732', u'ENSMUSG00000036098', u'ENSMUSG00000053007', u'ENSMUSG00000029135', u'ENSMUSG00000047036', u'ENSMUSG00000090093', u'ENSMUSG00000006586', u'ENSMUSG00000061911', u'ENSMUSG00000026923', u'ENSMUSG00000050295', u'ENSMUSG00000053470', u'ENSMUSG00000022521', u'ENSMUSG00000074406', u'ENSMUSG00000022526', u'ENSMUSG00000029249', u'ENSMUSG00000022528', u'ENSMUSG00000029627', u'ENSMUSG00000005267', u'ENSMUSG00000024985', u'ENSMUSG00000025225', u'ENSMUSG00000037674', u'ENSMUSG00000058440', u'ENSMUSG00000037174', u'ENSMUSG00000074622', u'ENSMUSG00000022974', u'ENSMUSG00000076431', u'ENSMUSG00000049321', u'ENSMUSG00000050945', u'ENSMUSG00000002108', u'ENSMUSG00000038797', u'ENSMUSG00000029563', u'ENSMUSG00000025364', u'ENSMUSG00000059423', u'ENSMUSG00000046179', u'ENSMUSG00000028565', u'ENSMUSG00000055228', u'ENSMUSG00000034271', u'ENSMUSG00000055835', u'ENSMUSG00000000134', u'ENSMUSG00000035576', u'ENSMUSG00000090659', u'ENSMUSG00000067071', u'ENSMUSG00000043866', u'ENSMUSG00000042097', u'ENSMUSG00000039275', u'ENSMUSG00000054939', u'ENSMUSG00000028042', u'ENSMUSG00000039634', u'ENSMUSG00000041852', u'ENSMUSG00000043008', u'ENSMUSG00000040857', u'ENSMUSG00000026663', u'ENSMUSG00000062861', u'ENSMUSG00000035877', u'ENSMUSG00000069208', u'ENSMUSG00000030823', u'ENSMUSG00000071637', u'ENSMUSG00000018651', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000031431', u'ENSMUSG00000038648', u'ENSMUSG00000026104', u'ENSMUSG00000014767', u'ENSMUSG00000004328', u'ENSMUSG00000048756', u'ENSMUSG00000048402', u'ENSMUSG00000001517', u'ENSMUSG00000021540', u'ENSMUSG00000051316', u'ENSMUSG00000026565', u'ENSMUSG00000059842', u'ENSMUSG00000002325', u'ENSMUSG00000004359', u'ENSMUSG00000057098', u'ENSMUSG00000069727', u'ENSMUSG00000041703', u'ENSMUSG00000074221', u'ENSMUSG00000024140', u'ENSMUSG00000019878', u'ENSMUSG00000069184', u'ENSMUSG00000031103', u'ENSMUSG00000049672', u'ENSMUSG00000029196', u'ENSMUSG00000027544', u'ENSMUSG00000061517', u'ENSMUSG00000001288', u'ENSMUSG00000057895', u'ENSMUSG00000009739', u'ENSMUSG00000001280', u'ENSMUSG00000009733', u'ENSMUSG00000046351', u'ENSMUSG00000002250', u'ENSMUSG00000032228', u'ENSMUSG00000022361', u'ENSMUSG00000006932', u'ENSMUSG00000051910', u'ENSMUSG00000063632', u'ENSMUSG00000027796', u'ENSMUSG00000040310', u'ENSMUSG00000029729', u'ENSMUSG00000020420', u'ENSMUSG00000009741', u'ENSMUSG00000061524', u'ENSMUSG00000029723', u'ENSMUSG00000002578', u'ENSMUSG00000024968', u'ENSMUSG00000057156', u'ENSMUSG00000089756', u'ENSMUSG00000057093', u'ENSMUSG00000025323', u'ENSMUSG00000024206', u'ENSMUSG00000037640', u'ENSMUSG00000027490', u'ENSMUSG00000046185', u'ENSMUSG00000024565', u'ENSMUSG00000024563', u'ENSMUSG00000000078', u'ENSMUSG00000005897', u'ENSMUSG00000005893', u'ENSMUSG00000009569', u'ENSMUSG00000037992', u'ENSMUSG00000074220', u'ENSMUSG00000055116', u'ENSMUSG00000033669', u'ENSMUSG00000052684', u'ENSMUSG00000037017', u'ENSMUSG00000034429', u'ENSMUSG00000062944', u'ENSMUSG00000024515', u'ENSMUSG00000037395', u'ENSMUSG00000025049', u'ENSMUSG00000034800', u'ENSMUSG00000078886', u'ENSMUSG00000007415', u'ENSMUSG00000050846', u'ENSMUSG00000060314', u'ENSMUSG00000001418', u'ENSMUSG00000001419', u'ENSMUSG00000055024', u'ENSMUSG00000031706', u'ENSMUSG00000030386', u'ENSMUSG00000032368', u'ENSMUSG00000016503', u'ENSMUSG00000055053', u'ENSMUSG00000039191', u'ENSMUSG00000031365', u'ENSMUSG00000052837', u'ENSMUSG00000051510', u'ENSMUSG00000040033', u'ENSMUSG00000051451', u'ENSMUSG00000053477', u'ENSMUSG00000023991', u'ENSMUSG00000023990', u'ENSMUSG00000003923', u'ENSMUSG00000025959', u'ENSMUSG00000025958', u'ENSMUSG00000047342', u'ENSMUSG00000021994', u'ENSMUSG00000051351', u'ENSMUSG00000029026', u'ENSMUSG00000019803', u'ENSMUSG00000078897', u'ENSMUSG00000057842', u'ENSMUSG00000047143', u'ENSMUSG00000074867', u'ENSMUSG00000062115', u'ENSMUSG00000062116', u'ENSMUSG00000034042', u'ENSMUSG00000021514', u'ENSMUSG00000001524', u'ENSMUSG00000078899', u'ENSMUSG00000020232', u'ENSMUSG00000058748', u'ENSMUSG00000044167', u'ENSMUSG00000042406', u'ENSMUSG00000005774', u'ENSMUSG00000053985', u'ENSMUSG00000036461', u'ENSMUSG00000038418', u'ENSMUSG00000044647', u'ENSMUSG00000025498', u'ENSMUSG00000025880', u'ENSMUSG00000049728', u'ENSMUSG00000027109', u'ENSMUSG00000057691', u'ENSMUSG00000037169', u'ENSMUSG00000062794', u'ENSMUSG00000027104', u'ENSMUSG00000006720', u'ENSMUSG00000069171', u'ENSMUSG00000020335', u'ENSMUSG00000029771', u'ENSMUSG00000040187', u'ENSMUSG00000009406', u'ENSMUSG00000033740', u'ENSMUSG00000046160', u'ENSMUSG00000059436', u'ENSMUSG00000024927', u'ENSMUSG00000000282', u'ENSMUSG00000035397', u'ENSMUSG00000036940', u'ENSMUSG00000034460', u'ENSMUSG00000016477', u'ENSMUSG00000020167', u'ENSMUSG00000049421', u'ENSMUSG00000058638', u'ENSMUSG00000064043', u'ENSMUSG00000028423', u'ENSMUSG00000055148', u'ENSMUSG00000028901', u'ENSMUSG00000038679', u'ENSMUSG00000024955', u'ENSMUSG00000069206', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000026077', u'ENSMUSG00000023994', u'ENSMUSG00000023892', u'ENSMUSG00000038630', u'ENSMUSG00000015053', u'ENSMUSG00000035011', u'ENSMUSG00000018654', u'ENSMUSG00000021264', u'ENSMUSG00000067931', u'ENSMUSG00000015522', u'ENSMUSG00000018501', u'ENSMUSG00000068130', u'ENSMUSG00000039830', u'ENSMUSG00000051469', u'ENSMUSG00000023079', u'ENSMUSG00000044934', u'ENSMUSG00000032035', u'ENSMUSG00000054648', u'ENSMUSG00000040761', u'ENSMUSG00000024176', u'ENSMUSG00000055639', u'ENSMUSG00000058881', u'ENSMUSG00000020275', u'ENSMUSG00000027552', u'ENSMUSG00000032745', u'ENSMUSG00000071646', u'ENSMUSG00000026890', u'ENSMUSG00000019564', u'ENSMUSG00000031079', u'ENSMUSG00000002266', u'ENSMUSG00000000567', u'ENSMUSG00000003662', u'ENSMUSG00000041309', u'ENSMUSG00000029832', u'ENSMUSG00000057409', u'ENSMUSG00000037896', u'ENSMUSG00000093668', u'ENSMUSG00000056501', u'ENSMUSG00000072915', u'ENSMUSG00000026826', u'ENSMUSG00000071076', u'ENSMUSG00000018983', u'ENSMUSG00000015709', u'ENSMUSG00000015839', u'ENSMUSG00000054717', u'ENSMUSG00000024912', u'ENSMUSG00000046532', u'ENSMUSG00000022556', u'ENSMUSG00000029238', u'ENSMUSG00000034227', u'ENSMUSG00000030604', u'ENSMUSG00000041540', u'ENSMUSG00000003184', u'ENSMUSG00000055991', u'ENSMUSG00000036867', u'ENSMUSG00000048249', u'ENSMUSG00000048481', u'ENSMUSG00000003847', u'ENSMUSG00000072294', u'ENSMUSG00000040929', u'ENSMUSG00000008575', u'ENSMUSG00000028466', u'ENSMUSG00000037373', u'ENSMUSG00000008976', u'ENSMUSG00000060601', u'ENSMUSG00000028150', u'ENSMUSG00000045991', u'ENSMUSG00000015846', u'ENSMUSG00000028086', u'ENSMUSG00000020484', u'ENSMUSG00000018604', u'ENSMUSG00000005148', u'ENSMUSG00000007812', u'ENSMUSG00000039117', u'ENSMUSG00000061544', u'ENSMUSG00000006362', u'ENSMUSG00000074158', u'ENSMUSG00000049532', u'ENSMUSG00000013089', u'ENSMUSG00000030557', u'ENSMUSG00000042557', u'ENSMUSG00000030551', u'ENSMUSG00000038909', u'ENSMUSG00000070709', u'ENSMUSG00000040289', u'ENSMUSG00000040433', u'ENSMUSG00000020653', u'ENSMUSG00000023034', u'ENSMUSG00000020656', u'ENSMUSG00000061360', u'ENSMUSG00000060261', u'ENSMUSG00000020037', u'ENSMUSG00000021250', u'ENSMUSG00000021255', u'ENSMUSG00000057982', u'ENSMUSG00000074519', u'ENSMUSG00000021318', u'ENSMUSG00000091474', u'ENSMUSG00000052942', u'ENSMUSG00000015605', u'ENSMUSG00000051341', u'ENSMUSG00000032515', u'ENSMUSG00000044807', u'ENSMUSG00000078887', u'ENSMUSG00000010505', u'ENSMUSG00000024431', u'ENSMUSG00000078898', u'ENSMUSG00000054321', u'ENSMUSG00000008398', u'ENSMUSG00000006215', u'ENSMUSG00000054737', u'ENSMUSG00000045302', u'ENSMUSG00000055817', u'ENSMUSG00000087598', u'ENSMUSG00000027684', u'ENSMUSG00000020248', u'ENSMUSG00000019256', u'ENSMUSG00000032998', u'ENSMUSG00000022508', u'ENSMUSG00000043991', u'ENSMUSG00000058756', u'ENSMUSG00000078902', u'ENSMUSG00000020472', u'ENSMUSG00000003154', u'ENSMUSG00000047473', u'ENSMUSG00000056383', u'ENSMUSG00000022346', u'ENSMUSG00000043099', u'ENSMUSG00000058886', u'ENSMUSG00000034673', u'ENSMUSG00000022952', u'ENSMUSG00000022811', u'ENSMUSG00000038539', u'ENSMUSG00000040270', u'ENSMUSG00000026641', u'ENSMUSG00000038533', u'ENSMUSG00000039153', u'ENSMUSG00000034430', u'ENSMUSG00000033006', u'ENSMUSG00000015843', u'ENSMUSG00000019789', u'ENSMUSG00000029587', u'ENSMUSG00000066839', u'ENSMUSG00000066838', u'ENSMUSG00000027168', u'ENSMUSG00000022463', u'ENSMUSG00000055320', u'ENSMUSG00000034701', u'ENSMUSG00000028163', u'ENSMUSG00000020889', u'ENSMUSG00000038415', u'ENSMUSG00000027361', u'ENSMUSG00000052135', u'ENSMUSG00000022228']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0001071', 'GO:0000130'])),
    NtGoeaResults(GO='GO:0003705', NS='MF', enrichment='p', name='transcription factor activity, RNA polymerase II distal enhancer sequence-specific binding', ratio_in_study=(1, 624), ratio_in_pop=(36, 13836), p_uncorrected=1.0, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000052684']), pop_n=13836, pop_count=36, pop_items=set([u'ENSMUSG00000050295', u'ENSMUSG00000002111', u'ENSMUSG00000030796', u'ENSMUSG00000025958', u'ENSMUSG00000019256', u'ENSMUSG00000056501', u'ENSMUSG00000030256', u'ENSMUSG00000015522', u'ENSMUSG00000045515', u'ENSMUSG00000052684', u'ENSMUSG00000024927', u'ENSMUSG00000058239', u'ENSMUSG00000010175', u'ENSMUSG00000030067', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000033016', u'ENSMUSG00000024642', u'ENSMUSG00000021109', u'ENSMUSG00000091243', u'ENSMUSG00000015605', u'ENSMUSG00000063632', u'ENSMUSG00000030557', u'ENSMUSG00000006705', u'ENSMUSG00000020160', u'ENSMUSG00000026641', u'ENSMUSG00000021255', u'ENSMUSG00000033006', u'ENSMUSG00000030103', u'ENSMUSG00000039830', u'ENSMUSG00000005583', u'ENSMUSG00000000567', u'ENSMUSG00000023027', u'ENSMUSG00000034957', u'ENSMUSG00000025902', u'ENSMUSG00000058756']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003707', NS='MF', enrichment='p', name='steroid hormone receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(41, 13836), p_uncorrected=1.0, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020889']), pop_n=13836, pop_count=41, pop_items=set([u'ENSMUSG00000025931', u'ENSMUSG00000026610', u'ENSMUSG00000022383', u'ENSMUSG00000037992', u'ENSMUSG00000039202', u'ENSMUSG00000002393', u'ENSMUSG00000026826', u'ENSMUSG00000001288', u'ENSMUSG00000058756', u'ENSMUSG00000028341', u'ENSMUSG00000024955', u'ENSMUSG00000039656', u'ENSMUSG00000036192', u'ENSMUSG00000002250', u'ENSMUSG00000028150', u'ENSMUSG00000053647', u'ENSMUSG00000019803', u'ENSMUSG00000021779', u'ENSMUSG00000023034', u'ENSMUSG00000021775', u'ENSMUSG00000041423', u'ENSMUSG00000064225', u'ENSMUSG00000002108', u'ENSMUSG00000021255', u'ENSMUSG00000015846', u'ENSMUSG00000063972', u'ENSMUSG00000015843', u'ENSMUSG00000030551', u'ENSMUSG00000017491', u'ENSMUSG00000032238', u'ENSMUSG00000037348', u'ENSMUSG00000020889', u'ENSMUSG00000031618', u'ENSMUSG00000024431', u'ENSMUSG00000019768', u'ENSMUSG00000032278', u'ENSMUSG00000005897', u'ENSMUSG00000060601', u'ENSMUSG00000005893', u'ENSMUSG00000069171', u'ENSMUSG00000031870']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003713', NS='MF', enrichment='p', name='transcription coactivator activity', ratio_in_study=(6, 624), ratio_in_pop=(159, 13836), p_uncorrected=0.8470783633164798, depth=5, study_count=6, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000002307', u'ENSMUSG00000028066', u'ENSMUSG00000036986', u'ENSMUSG00000005566', u'ENSMUSG00000031885', u'ENSMUSG00000052684']), pop_n=13836, pop_count=159, pop_items=set([u'ENSMUSG00000013833', u'ENSMUSG00000000902', u'ENSMUSG00000029196', u'ENSMUSG00000038256', u'ENSMUSG00000031586', u'ENSMUSG00000031776', u'ENSMUSG00000015522', u'ENSMUSG00000038954', u'ENSMUSG00000034957', u'ENSMUSG00000002250', u'ENSMUSG00000026799', u'ENSMUSG00000026796', u'ENSMUSG00000006932', u'ENSMUSG00000053110', u'ENSMUSG00000002409', u'ENSMUSG00000045482', u'ENSMUSG00000050029', u'ENSMUSG00000020593', u'ENSMUSG00000025917', u'ENSMUSG00000027412', u'ENSMUSG00000021690', u'ENSMUSG00000052293', u'ENSMUSG00000048930', u'ENSMUSG00000033054', u'ENSMUSG00000005566', u'ENSMUSG00000079487', u'ENSMUSG00000029440', u'ENSMUSG00000025326', u'ENSMUSG00000025323', u'ENSMUSG00000038697', u'ENSMUSG00000060534', u'ENSMUSG00000056770', u'ENSMUSG00000032386', u'ENSMUSG00000057367', u'ENSMUSG00000042292', u'ENSMUSG00000029833', u'ENSMUSG00000002307', u'ENSMUSG00000022255', u'ENSMUSG00000021810', u'ENSMUSG00000020074', u'ENSMUSG00000055866', u'ENSMUSG00000042506', u'ENSMUSG00000071076', u'ENSMUSG00000009569', u'ENSMUSG00000037992', u'ENSMUSG00000059995', u'ENSMUSG00000064127', u'ENSMUSG00000024052', u'ENSMUSG00000036986', u'ENSMUSG00000028647', u'ENSMUSG00000052684', u'ENSMUSG00000046229', u'ENSMUSG00000034341', u'ENSMUSG00000037013', u'ENSMUSG00000024218', u'ENSMUSG00000018160', u'ENSMUSG00000030970', u'ENSMUSG00000017210', u'ENSMUSG00000030291', u'ENSMUSG00000023984', u'ENSMUSG00000075000', u'ENSMUSG00000005886', u'ENSMUSG00000022019', u'ENSMUSG00000063382', u'ENSMUSG00000003680', u'ENSMUSG00000027434', u'ENSMUSG00000054321', u'ENSMUSG00000030782', u'ENSMUSG00000000708', u'ENSMUSG00000001552', u'ENSMUSG00000053483', u'ENSMUSG00000039910', u'ENSMUSG00000055024', u'ENSMUSG00000027803', u'ENSMUSG00000034297', u'ENSMUSG00000031314', u'ENSMUSG00000033543', u'ENSMUSG00000052837', u'ENSMUSG00000061143', u'ENSMUSG00000028899', u'ENSMUSG00000030180', u'ENSMUSG00000020647', u'ENSMUSG00000002679', u'ENSMUSG00000021039', u'ENSMUSG00000022338', u'ENSMUSG00000048490', u'ENSMUSG00000031885', u'ENSMUSG00000039117', u'ENSMUSG00000020962', u'ENSMUSG00000028309', u'ENSMUSG00000050295', u'ENSMUSG00000028066', u'ENSMUSG00000031386', u'ENSMUSG00000018849', u'ENSMUSG00000022521', u'ENSMUSG00000092558', u'ENSMUSG00000064128', u'ENSMUSG00000025159', u'ENSMUSG00000032187', u'ENSMUSG00000032185', u'ENSMUSG00000025151', u'ENSMUSG00000022205', u'ENSMUSG00000020918', u'ENSMUSG00000027620', u'ENSMUSG00000055839', u'ENSMUSG00000061315', u'ENSMUSG00000015092', u'ENSMUSG00000021144', u'ENSMUSG00000038705', u'ENSMUSG00000039410', u'ENSMUSG00000038369', u'ENSMUSG00000020230', u'ENSMUSG00000057113', u'ENSMUSG00000021255', u'ENSMUSG00000038965', u'ENSMUSG00000029167', u'ENSMUSG00000031540', u'ENSMUSG00000044475', u'ENSMUSG00000042548', u'ENSMUSG00000050567', u'ENSMUSG00000031935', u'ENSMUSG00000028964', u'ENSMUSG00000024431', u'ENSMUSG00000038025', u'ENSMUSG00000002455', u'ENSMUSG00000043866', u'ENSMUSG00000030330', u'ENSMUSG00000062627', u'ENSMUSG00000006050', u'ENSMUSG00000035960', u'ENSMUSG00000032119', u'ENSMUSG00000024926', u'ENSMUSG00000039086', u'ENSMUSG00000023055', u'ENSMUSG00000053134', u'ENSMUSG00000018651', u'ENSMUSG00000031925', u'ENSMUSG00000019947', u'ENSMUSG00000032526', u'ENSMUSG00000063659', u'ENSMUSG00000004328', u'ENSMUSG00000020167', u'ENSMUSG00000028191', u'ENSMUSG00000043962', u'ENSMUSG00000025616', u'ENSMUSG00000051316', u'ENSMUSG00000055044', u'ENSMUSG00000055065', u'ENSMUSG00000031660', u'ENSMUSG00000049800', u'ENSMUSG00000028901', u'ENSMUSG00000020801', u'ENSMUSG00000026563', u'ENSMUSG00000020397', u'ENSMUSG00000027678', u'ENSMUSG00000034701', u'ENSMUSG00000036615', u'ENSMUSG00000025902', u'ENSMUSG00000020098']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003714', NS='MF', enrichment='e', name='transcription corepressor activity', ratio_in_study=(7, 624), ratio_in_pop=(121, 13836), p_uncorrected=0.5036654223217462, depth=5, study_count=7, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000042557', u'ENSMUSG00000020185', u'ENSMUSG00000002307', u'ENSMUSG00000005566', u'ENSMUSG00000028282', u'ENSMUSG00000046179', u'ENSMUSG00000006715']), pop_n=13836, pop_count=121, pop_items=set([u'ENSMUSG00000040363', u'ENSMUSG00000030213', u'ENSMUSG00000044030', u'ENSMUSG00000038255', u'ENSMUSG00000029599', u'ENSMUSG00000000861', u'ENSMUSG00000038895', u'ENSMUSG00000029050', u'ENSMUSG00000018501', u'ENSMUSG00000026313', u'ENSMUSG00000022475', u'ENSMUSG00000022361', u'ENSMUSG00000023170', u'ENSMUSG00000027177', u'ENSMUSG00000046179', u'ENSMUSG00000053110', u'ENSMUSG00000070348', u'ENSMUSG00000040761', u'ENSMUSG00000004698', u'ENSMUSG00000020063', u'ENSMUSG00000035236', u'ENSMUSG00000020185', u'ENSMUSG00000024968', u'ENSMUSG00000005566', u'ENSMUSG00000057156', u'ENSMUSG00000022096', u'ENSMUSG00000008855', u'ENSMUSG00000021488', u'ENSMUSG00000030103', u'ENSMUSG00000002307', u'ENSMUSG00000037896', u'ENSMUSG00000036225', u'ENSMUSG00000050919', u'ENSMUSG00000042613', u'ENSMUSG00000020074', u'ENSMUSG00000061436', u'ENSMUSG00000037992', u'ENSMUSG00000008398', u'ENSMUSG00000040390', u'ENSMUSG00000024914', u'ENSMUSG00000018446', u'ENSMUSG00000049577', u'ENSMUSG00000037395', u'ENSMUSG00000022306', u'ENSMUSG00000032405', u'ENSMUSG00000028800', u'ENSMUSG00000004934', u'ENSMUSG00000091337', u'ENSMUSG00000027660', u'ENSMUSG00000022178', u'ENSMUSG00000031622', u'ENSMUSG00000039910', u'ENSMUSG00000054199', u'ENSMUSG00000027803', u'ENSMUSG00000037373', u'ENSMUSG00000063568', u'ENSMUSG00000057604', u'ENSMUSG00000025239', u'ENSMUSG00000054452', u'ENSMUSG00000037573', u'ENSMUSG00000022702', u'ENSMUSG00000025231', u'ENSMUSG00000027630', u'ENSMUSG00000036856', u'ENSMUSG00000035456', u'ENSMUSG00000024454', u'ENSMUSG00000053477', u'ENSMUSG00000048490', u'ENSMUSG00000041483', u'ENSMUSG00000006586', u'ENSMUSG00000034748', u'ENSMUSG00000006362', u'ENSMUSG00000032744', u'ENSMUSG00000004263', u'ENSMUSG00000032187', u'ENSMUSG00000030256', u'ENSMUSG00000045763', u'ENSMUSG00000018326', u'ENSMUSG00000010175', u'ENSMUSG00000042557', u'ENSMUSG00000048546', u'ENSMUSG00000028975', u'ENSMUSG00000021144', u'ENSMUSG00000037447', u'ENSMUSG00000059288', u'ENSMUSG00000049327', u'ENSMUSG00000031609', u'ENSMUSG00000033054', u'ENSMUSG00000033565', u'ENSMUSG00000021156', u'ENSMUSG00000072872', u'ENSMUSG00000031839', u'ENSMUSG00000030232', u'ENSMUSG00000014402', u'ENSMUSG00000006715', u'ENSMUSG00000029478', u'ENSMUSG00000039630', u'ENSMUSG00000008305', u'ENSMUSG00000008730', u'ENSMUSG00000020473', u'ENSMUSG00000028282', u'ENSMUSG00000040857', u'ENSMUSG00000035877', u'ENSMUSG00000023110', u'ENSMUSG00000025246', u'ENSMUSG00000024642', u'ENSMUSG00000025408', u'ENSMUSG00000034771', u'ENSMUSG00000004328', u'ENSMUSG00000051495', u'ENSMUSG00000038533', u'ENSMUSG00000021039', u'ENSMUSG00000000581', u'ENSMUSG00000009640', u'ENSMUSG00000042207', u'ENSMUSG00000031660', u'ENSMUSG00000036459', u'ENSMUSG00000027206', u'ENSMUSG00000030970', u'ENSMUSG00000040463', u'ENSMUSG00000030905']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003723', NS='MF', enrichment='e', name='RNA binding', ratio_in_study=(70, 624), ratio_in_pop=(1318, 13836), p_uncorrected=0.1427452683506442, depth=4, study_count=70, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000067455', u'ENSMUSG00000031004', u'ENSMUSG00000038507', u'ENSMUSG00000024079', u'ENSMUSG00000090272', u'ENSMUSG00000042699', u'ENSMUSG00000004642', u'ENSMUSG00000035842', u'ENSMUSG00000026196', u'ENSMUSG00000045932', u'ENSMUSG00000021222', u'ENSMUSG00000052684', u'ENSMUSG00000041827', u'ENSMUSG00000028911', u'ENSMUSG00000027580', u'ENSMUSG00000042557', u'ENSMUSG00000026536', u'ENSMUSG00000034422', u'ENSMUSG00000020290', u'ENSMUSG00000024097', u'ENSMUSG00000020914', u'ENSMUSG00000017548', u'ENSMUSG00000027067', u'ENSMUSG00000002227', u'ENSMUSG00000069274', u'ENSMUSG00000017146', u'ENSMUSG00000039456', u'ENSMUSG00000039356', u'ENSMUSG00000039997', u'ENSMUSG00000041133', u'ENSMUSG00000025134', u'ENSMUSG00000033732', u'ENSMUSG00000037965', u'ENSMUSG00000039236', u'ENSMUSG00000054717', u'ENSMUSG00000039501', u'ENSMUSG00000027514', u'ENSMUSG00000030346', u'ENSMUSG00000027968', u'ENSMUSG00000027433', u'ENSMUSG00000034708', u'ENSMUSG00000021707', u'ENSMUSG00000005481', u'ENSMUSG00000029561', u'ENSMUSG00000021377', u'ENSMUSG00000005566', u'ENSMUSG00000018362', u'ENSMUSG00000026896', u'ENSMUSG00000031311', u'ENSMUSG00000031353', u'ENSMUSG00000028382', u'ENSMUSG00000031527', u'ENSMUSG00000027752', u'ENSMUSG00000004356', u'ENSMUSG00000037572', u'ENSMUSG00000034459', u'ENSMUSG00000036249', u'ENSMUSG00000024472', u'ENSMUSG00000027306', u'ENSMUSG00000040296', u'ENSMUSG00000052565', u'ENSMUSG00000069266', u'ENSMUSG00000017830', u'ENSMUSG00000061482', u'ENSMUSG00000024991', u'ENSMUSG00000060093', u'ENSMUSG00000004099', u'ENSMUSG00000064288', u'ENSMUSG00000038774']), pop_n=13836, pop_count=1318, pop_items=set([u'ENSMUSG00000051391', u'ENSMUSG00000028180', u'ENSMUSG00000026496', u'ENSMUSG00000002017', u'ENSMUSG00000017404', u'ENSMUSG00000028187', u'ENSMUSG00000026492', u'ENSMUSG00000060679', u'ENSMUSG00000046667', u'ENSMUSG00000039756', u'ENSMUSG00000006005', u'ENSMUSG00000073838', u'ENSMUSG00000003970', u'ENSMUSG00000018379', u'ENSMUSG00000020863', u'ENSMUSG00000004897', u'ENSMUSG00000050335', u'ENSMUSG00000005610', u'ENSMUSG00000027387', u'ENSMUSG00000046756', u'ENSMUSG00000053286', u'ENSMUSG00000020869', u'ENSMUSG00000038957', u'ENSMUSG00000034889', u'ENSMUSG00000030189', u'ENSMUSG00000027663', u'ENSMUSG00000026248', u'ENSMUSG00000048109', u'ENSMUSG00000005506', u'ENSMUSG00000035139', u'ENSMUSG00000060678', u'ENSMUSG00000026245', u'ENSMUSG00000028029', u'ENSMUSG00000041375', u'ENSMUSG00000027067', u'ENSMUSG00000062604', u'ENSMUSG00000031901', u'ENSMUSG00000017146', u'ENSMUSG00000055319', u'ENSMUSG00000068220', u'ENSMUSG00000059291', u'ENSMUSG00000019777', u'ENSMUSG00000015120', u'ENSMUSG00000003402', u'ENSMUSG00000066357', u'ENSMUSG00000036983', u'ENSMUSG00000069833', u'ENSMUSG00000028330', u'ENSMUSG00000028331', u'ENSMUSG00000051695', u'ENSMUSG00000015023', u'ENSMUSG00000022390', u'ENSMUSG00000022391', u'ENSMUSG00000000976', u'ENSMUSG00000037815', u'ENSMUSG00000078671', u'ENSMUSG00000024045', u'ENSMUSG00000028234', u'ENSMUSG00000040028', u'ENSMUSG00000032096', u'ENSMUSG00000032097', u'ENSMUSG00000047371', u'ENSMUSG00000092035', u'ENSMUSG00000071415', u'ENSMUSG00000031767', u'ENSMUSG00000021218', u'ENSMUSG00000063457', u'ENSMUSG00000071662', u'ENSMUSG00000032383', u'ENSMUSG00000027016', u'ENSMUSG00000035047', u'ENSMUSG00000027014', u'ENSMUSG00000028430', u'ENSMUSG00000069274', u'ENSMUSG00000022160', u'ENSMUSG00000035049', u'ENSMUSG00000028433', u'ENSMUSG00000044927', u'ENSMUSG00000032410', u'ENSMUSG00000014907', u'ENSMUSG00000026889', u'ENSMUSG00000018583', u'ENSMUSG00000053453', u'ENSMUSG00000026427', u'ENSMUSG00000038056', u'ENSMUSG00000032396', u'ENSMUSG00000021814', u'ENSMUSG00000002658', u'ENSMUSG00000022009', u'ENSMUSG00000027405', u'ENSMUSG00000025932', u'ENSMUSG00000090553', u'ENSMUSG00000025937', u'ENSMUSG00000001783', u'ENSMUSG00000038914', u'ENSMUSG00000020362', u'ENSMUSG00000018199', u'ENSMUSG00000029389', u'ENSMUSG00000074781', u'ENSMUSG00000020368', u'ENSMUSG00000040296', u'ENSMUSG00000031068', u'ENSMUSG00000032690', u'ENSMUSG00000039929', u'ENSMUSG00000031167', u'ENSMUSG00000041438', u'ENSMUSG00000003299', u'ENSMUSG00000070699', u'ENSMUSG00000038507', u'ENSMUSG00000032565', u'ENSMUSG00000022718', u'ENSMUSG00000029206', u'ENSMUSG00000029427', u'ENSMUSG00000032563', u'ENSMUSG00000018293', u'ENSMUSG00000047126', u'ENSMUSG00000029826', u'ENSMUSG00000010554', u'ENSMUSG00000029823', u'ENSMUSG00000021963', u'ENSMUSG00000051934', u'ENSMUSG00000066037', u'ENSMUSG00000020048', u'ENSMUSG00000030611', u'ENSMUSG00000060639', u'ENSMUSG00000036781', u'ENSMUSG00000057788', u'ENSMUSG00000038500', u'ENSMUSG00000021282', u'ENSMUSG00000042396', u'ENSMUSG00000029106', u'ENSMUSG00000021134', u'ENSMUSG00000038279', u'ENSMUSG00000021131', u'ENSMUSG00000026723', u'ENSMUSG00000028936', u'ENSMUSG00000071659', u'ENSMUSG00000028790', u'ENSMUSG00000029701', u'ENSMUSG00000029250', u'ENSMUSG00000056076', u'ENSMUSG00000050188', u'ENSMUSG00000067194', u'ENSMUSG00000022433', u'ENSMUSG00000030662', u'ENSMUSG00000033166', u'ENSMUSG00000024902', u'ENSMUSG00000029227', u'ENSMUSG00000005054', u'ENSMUSG00000011257', u'ENSMUSG00000021585', u'ENSMUSG00000034621', u'ENSMUSG00000000787', u'ENSMUSG00000042535', u'ENSMUSG00000028729', u'ENSMUSG00000040112', u'ENSMUSG00000030942', u'ENSMUSG00000028898', u'ENSMUSG00000025626', u'ENSMUSG00000036850', u'ENSMUSG00000037608', u'ENSMUSG00000058392', u'ENSMUSG00000005374', u'ENSMUSG00000020211', u'ENSMUSG00000025785', u'ENSMUSG00000005378', u'ENSMUSG00000037149', u'ENSMUSG00000025781', u'ENSMUSG00000024999', u'ENSMUSG00000053317', u'ENSMUSG00000015165', u'ENSMUSG00000030846', u'ENSMUSG00000060636', u'ENSMUSG00000026615', u'ENSMUSG00000002111', u'ENSMUSG00000020719', u'ENSMUSG00000059070', u'ENSMUSG00000039108', u'ENSMUSG00000059040', u'ENSMUSG00000002052', u'ENSMUSG00000066800', u'ENSMUSG00000029552', u'ENSMUSG00000024831', u'ENSMUSG00000037376', u'ENSMUSG00000038784', u'ENSMUSG00000070436', u'ENSMUSG00000055491', u'ENSMUSG00000069895', u'ENSMUSG00000009549', u'ENSMUSG00000030016', u'ENSMUSG00000039652', u'ENSMUSG00000025153', u'ENSMUSG00000020821', u'ENSMUSG00000028156', u'ENSMUSG00000030707', u'ENSMUSG00000020850', u'ENSMUSG00000027580', u'ENSMUSG00000033047', u'ENSMUSG00000037563', u'ENSMUSG00000027620', u'ENSMUSG00000020914', u'ENSMUSG00000050244', u'ENSMUSG00000006134', u'ENSMUSG00000030888', u'ENSMUSG00000060739', u'ENSMUSG00000043639', u'ENSMUSG00000018921', u'ENSMUSG00000031949', u'ENSMUSG00000034994', u'ENSMUSG00000039262', u'ENSMUSG00000021621', u'ENSMUSG00000021149', u'ENSMUSG00000073491', u'ENSMUSG00000000439', u'ENSMUSG00000019432', u'ENSMUSG00000042426', u'ENSMUSG00000041632', u'ENSMUSG00000006050', u'ENSMUSG00000029290', u'ENSMUSG00000048039', u'ENSMUSG00000033902', u'ENSMUSG00000059743', u'ENSMUSG00000028821', u'ENSMUSG00000033909', u'ENSMUSG00000055204', u'ENSMUSG00000024120', u'ENSMUSG00000073409', u'ENSMUSG00000073411', u'ENSMUSG00000038965', u'ENSMUSG00000024853', u'ENSMUSG00000042354', u'ENSMUSG00000026187', u'ENSMUSG00000028948', u'ENSMUSG00000028382', u'ENSMUSG00000027752', u'ENSMUSG00000041346', u'ENSMUSG00000052253', u'ENSMUSG00000040521', u'ENSMUSG00000040940', u'ENSMUSG00000018707', u'ENSMUSG00000026111', u'ENSMUSG00000032342', u'ENSMUSG00000047649', u'ENSMUSG00000037475', u'ENSMUSG00000023025', u'ENSMUSG00000003435', u'ENSMUSG00000025261', u'ENSMUSG00000002455', u'ENSMUSG00000057421', u'ENSMUSG00000056820', u'ENSMUSG00000037921', u'ENSMUSG00000053553', u'ENSMUSG00000050213', u'ENSMUSG00000026058', u'ENSMUSG00000039782', u'ENSMUSG00000021532', u'ENSMUSG00000067455', u'ENSMUSG00000025872', u'ENSMUSG00000033777', u'ENSMUSG00000062078', u'ENSMUSG00000046841', u'ENSMUSG00000021243', u'ENSMUSG00000024393', u'ENSMUSG00000034820', u'ENSMUSG00000021244', u'ENSMUSG00000074088', u'ENSMUSG00000047888', u'ENSMUSG00000061104', u'ENSMUSG00000074129', u'ENSMUSG00000039236', u'ENSMUSG00000052926', u'ENSMUSG00000047423', u'ENSMUSG00000031754', u'ENSMUSG00000052928', u'ENSMUSG00000052565', u'ENSMUSG00000059796', u'ENSMUSG00000048076', u'ENSMUSG00000022191', u'ENSMUSG00000023051', u'ENSMUSG00000022194', u'ENSMUSG00000008668', u'ENSMUSG00000030309', u'ENSMUSG00000038299', u'ENSMUSG00000002625', u'ENSMUSG00000034459', u'ENSMUSG00000031683', u'ENSMUSG00000029726', u'ENSMUSG00000026374', u'ENSMUSG00000003226', u'ENSMUSG00000026377', u'ENSMUSG00000024400', u'ENSMUSG00000022696', u'ENSMUSG00000045948', u'ENSMUSG00000025404', u'ENSMUSG00000063884', u'ENSMUSG00000056209', u'ENSMUSG00000040620', u'ENSMUSG00000061024', u'ENSMUSG00000058546', u'ENSMUSG00000044224', u'ENSMUSG00000074480', u'ENSMUSG00000055334', u'ENSMUSG00000013736', u'ENSMUSG00000044221', u'ENSMUSG00000039810', u'ENSMUSG00000003360', u'ENSMUSG00000022672', u'ENSMUSG00000017421', u'ENSMUSG00000031984', u'ENSMUSG00000025586', u'ENSMUSG00000020441', u'ENSMUSG00000030204', u'ENSMUSG00000025823', u'ENSMUSG00000025580', u'ENSMUSG00000029486', u'ENSMUSG00000029173', u'ENSMUSG00000009927', u'ENSMUSG00000054079', u'ENSMUSG00000022370', u'ENSMUSG00000022371', u'ENSMUSG00000024491', u'ENSMUSG00000032297', u'ENSMUSG00000052406', u'ENSMUSG00000010205', u'ENSMUSG00000032239', u'ENSMUSG00000002524', u'ENSMUSG00000025278', u'ENSMUSG00000037742', u'ENSMUSG00000025571', u'ENSMUSG00000037740', u'ENSMUSG00000025576', u'ENSMUSG00000020315', u'ENSMUSG00000064288', u'ENSMUSG00000062006', u'ENSMUSG00000063646', u'ENSMUSG00000071337', u'ENSMUSG00000027248', u'ENSMUSG00000027787', u'ENSMUSG00000026806', u'ENSMUSG00000021662', u'ENSMUSG00000039220', u'ENSMUSG00000021660', u'ENSMUSG00000071650', u'ENSMUSG00000005198', u'ENSMUSG00000007739', u'ENSMUSG00000059208', u'ENSMUSG00000032621', u'ENSMUSG00000028706', u'ENSMUSG00000023805', u'ENSMUSG00000024975', u'ENSMUSG00000025290', u'ENSMUSG00000041815', u'ENSMUSG00000030695', u'ENSMUSG00000009585', u'ENSMUSG00000029328', u'ENSMUSG00000069565', u'ENSMUSG00000052397', u'ENSMUSG00000029594', u'ENSMUSG00000068479', u'ENSMUSG00000047213', u'ENSMUSG00000001767', u'ENSMUSG00000025995', u'ENSMUSG00000037296', u'ENSMUSG00000022471', u'ENSMUSG00000032288', u'ENSMUSG00000034243', u'ENSMUSG00000063334', u'ENSMUSG00000041560', u'ENSMUSG00000062981', u'ENSMUSG00000016253', u'ENSMUSG00000034321', u'ENSMUSG00000042605', u'ENSMUSG00000061458', u'ENSMUSG00000028580', u'ENSMUSG00000026970', u'ENSMUSG00000052105', u'ENSMUSG00000020594', u'ENSMUSG00000027374', u'ENSMUSG00000016319', u'ENSMUSG00000071054', u'ENSMUSG00000001962', u'ENSMUSG00000023938', u'ENSMUSG00000037965', u'ENSMUSG00000033285', u'ENSMUSG00000003099', u'ENSMUSG00000006019', u'ENSMUSG00000020180', u'ENSMUSG00000023932', u'ENSMUSG00000060036', u'ENSMUSG00000034931', u'ENSMUSG00000028405', u'ENSMUSG00000031578', u'ENSMUSG00000034932', u'ENSMUSG00000005566', u'ENSMUSG00000038014', u'ENSMUSG00000039660', u'ENSMUSG00000040054', u'ENSMUSG00000018697', u'ENSMUSG00000070780', u'ENSMUSG00000037253', u'ENSMUSG00000044533', u'ENSMUSG00000016409', u'ENSMUSG00000027655', u'ENSMUSG00000031585', u'ENSMUSG00000057863', u'ENSMUSG00000027498', u'ENSMUSG00000028199', u'ENSMUSG00000049957', u'ENSMUSG00000000568', u'ENSMUSG00000061286', u'ENSMUSG00000027306', u'ENSMUSG00000023277', u'ENSMUSG00000027304', u'ENSMUSG00000061477', u'ENSMUSG00000007836', u'ENSMUSG00000030871', u'ENSMUSG00000030521', u'ENSMUSG00000015656', u'ENSMUSG00000020743', u'ENSMUSG00000034839', u'ENSMUSG00000044763', u'ENSMUSG00000021476', u'ENSMUSG00000027893', u'ENSMUSG00000039826', u'ENSMUSG00000022386', u'ENSMUSG00000033871', u'ENSMUSG00000005981', u'ENSMUSG00000028248', u'ENSMUSG00000043962', u'ENSMUSG00000030966', u'ENSMUSG00000027951', u'ENSMUSG00000033712', u'ENSMUSG00000034022', u'ENSMUSG00000035726', u'ENSMUSG00000063511', u'ENSMUSG00000042557', u'ENSMUSG00000004642', u'ENSMUSG00000023495', u'ENSMUSG00000006456', u'ENSMUSG00000038542', u'ENSMUSG00000063273', u'ENSMUSG00000035051', u'ENSMUSG00000013465', u'ENSMUSG00000044068', u'ENSMUSG00000026421', u'ENSMUSG00000026536', u'ENSMUSG00000040412', u'ENSMUSG00000026020', u'ENSMUSG00000026021', u'ENSMUSG00000032399', u'ENSMUSG00000032407', u'ENSMUSG00000026434', u'ENSMUSG00000040025', u'ENSMUSG00000038762', u'ENSMUSG00000052738', u'ENSMUSG00000021807', u'ENSMUSG00000038046', u'ENSMUSG00000022019', u'ENSMUSG00000039197', u'ENSMUSG00000051675', u'ENSMUSG00000020358', u'ENSMUSG00000029623', u'ENSMUSG00000003808', u'ENSMUSG00000027430', u'ENSMUSG00000027433', u'ENSMUSG00000031256', u'ENSMUSG00000079259', u'ENSMUSG00000069769', u'ENSMUSG00000028869', u'ENSMUSG00000031626', u'ENSMUSG00000000581', u'ENSMUSG00000023723', u'ENSMUSG00000022635', u'ENSMUSG00000034593', u'ENSMUSG00000008333', u'ENSMUSG00000078812', u'ENSMUSG00000039850', u'ENSMUSG00000067873', u'ENSMUSG00000032469', u'ENSMUSG00000041841', u'ENSMUSG00000057541', u'ENSMUSG00000070697', u'ENSMUSG00000031652', u'ENSMUSG00000038888', u'ENSMUSG00000028423', u'ENSMUSG00000021111', u'ENSMUSG00000017264', u'ENSMUSG00000032479', u'ENSMUSG00000024181', u'ENSMUSG00000063804', u'ENSMUSG00000032575', u'ENSMUSG00000022706', u'ENSMUSG00000022332', u'ENSMUSG00000037331', u'ENSMUSG00000006941', u'ENSMUSG00000024456', u'ENSMUSG00000022336', u'ENSMUSG00000029817', u'ENSMUSG00000055538', u'ENSMUSG00000030870', u'ENSMUSG00000021500', u'ENSMUSG00000063316', u'ENSMUSG00000036572', u'ENSMUSG00000028811', u'ENSMUSG00000025439', u'ENSMUSG00000035275', u'ENSMUSG00000036376', u'ENSMUSG00000025794', u'ENSMUSG00000074682', u'ENSMUSG00000036371', u'ENSMUSG00000032265', u'ENSMUSG00000026843', u'ENSMUSG00000052146', u'ENSMUSG00000009079', u'ENSMUSG00000029715', u'ENSMUSG00000036779', u'ENSMUSG00000030655', u'ENSMUSG00000034681', u'ENSMUSG00000003039', u'ENSMUSG00000022443', u'ENSMUSG00000050192', u'ENSMUSG00000022204', u'ENSMUSG00000022205', u'ENSMUSG00000006281', u'ENSMUSG00000021595', u'ENSMUSG00000022201', u'ENSMUSG00000029625', u'ENSMUSG00000032077', u'ENSMUSG00000028861', u'ENSMUSG00000034610', u'ENSMUSG00000025899', u'ENSMUSG00000046364', u'ENSMUSG00000015889', u'ENSMUSG00000007603', u'ENSMUSG00000024234', u'ENSMUSG00000020228', u'ENSMUSG00000027509', u'ENSMUSG00000027133', u'ENSMUSG00000000631', u'ENSMUSG00000021024', u'ENSMUSG00000041133', u'ENSMUSG00000008683', u'ENSMUSG00000006732', u'ENSMUSG00000022876', u'ENSMUSG00000091405', u'ENSMUSG00000040213', u'ENSMUSG00000020706', u'ENSMUSG00000002107', u'ENSMUSG00000026516', u'ENSMUSG00000057113', u'ENSMUSG00000029402', u'ENSMUSG00000001924', u'ENSMUSG00000016921', u'ENSMUSG00000029407', u'ENSMUSG00000031527', u'ENSMUSG00000029405', u'ENSMUSG00000029404', u'ENSMUSG00000005481', u'ENSMUSG00000020224', u'ENSMUSG00000023971', u'ENSMUSG00000037197', u'ENSMUSG00000025364', u'ENSMUSG00000041130', u'ENSMUSG00000041360', u'ENSMUSG00000030002', u'ENSMUSG00000025007', u'ENSMUSG00000041645', u'ENSMUSG00000020832', u'ENSMUSG00000079043', u'ENSMUSG00000041638', u'ENSMUSG00000024528', u'ENSMUSG00000024246', u'ENSMUSG00000005102', u'ENSMUSG00000034274', u'ENSMUSG00000027593', u'ENSMUSG00000042650', u'ENSMUSG00000034278', u'ENSMUSG00000062997', u'ENSMUSG00000012848', u'ENSMUSG00000069266', u'ENSMUSG00000041297', u'ENSMUSG00000015757', u'ENSMUSG00000060981', u'ENSMUSG00000007050', u'ENSMUSG00000063480', u'ENSMUSG00000059708', u'ENSMUSG00000044847', u'ENSMUSG00000021650', u'ENSMUSG00000027349', u'ENSMUSG00000058600', u'ENSMUSG00000031917', u'ENSMUSG00000021731', u'ENSMUSG00000030138', u'ENSMUSG00000075376', u'ENSMUSG00000026667', u'ENSMUSG00000008301', u'ENSMUSG00000029911', u'ENSMUSG00000028367', u'ENSMUSG00000001424', u'ENSMUSG00000020705', u'ENSMUSG00000032604', u'ENSMUSG00000034653', u'ENSMUSG00000046876', u'ENSMUSG00000033228', u'ENSMUSG00000063888', u'ENSMUSG00000042079', u'ENSMUSG00000040463', u'ENSMUSG00000024498', u'ENSMUSG00000046909', u'ENSMUSG00000037935', u'ENSMUSG00000041827', u'ENSMUSG00000025161', u'ENSMUSG00000023348', u'ENSMUSG00000025130', u'ENSMUSG00000050312', u'ENSMUSG00000030435', u'ENSMUSG00000027763', u'ENSMUSG00000047215', u'ENSMUSG00000027981', u'ENSMUSG00000061979', u'ENSMUSG00000000355', u'ENSMUSG00000031433', u'ENSMUSG00000034667', u'ENSMUSG00000020849', u'ENSMUSG00000022119', u'ENSMUSG00000020770', u'ENSMUSG00000003421', u'ENSMUSG00000031843', u'ENSMUSG00000037958', u'ENSMUSG00000058503', u'ENSMUSG00000003814', u'ENSMUSG00000047675', u'ENSMUSG00000039001', u'ENSMUSG00000020677', u'ENSMUSG00000038646', u'ENSMUSG00000002428', u'ENSMUSG00000027479', u'ENSMUSG00000021546', u'ENSMUSG00000042109', u'ENSMUSG00000000916', u'ENSMUSG00000014329', u'ENSMUSG00000054717', u'ENSMUSG00000030224', u'ENSMUSG00000054309', u'ENSMUSG00000020018', u'ENSMUSG00000030346', u'ENSMUSG00000048696', u'ENSMUSG00000027968', u'ENSMUSG00000043279', u'ENSMUSG00000021270', u'ENSMUSG00000079641', u'ENSMUSG00000063524', u'ENSMUSG00000073489', u'ENSMUSG00000026083', u'ENSMUSG00000021377', u'ENSMUSG00000073702', u'ENSMUSG00000018474', u'ENSMUSG00000000740', u'ENSMUSG00000068039', u'ENSMUSG00000073490', u'ENSMUSG00000006782', u'ENSMUSG00000029066', u'ENSMUSG00000025362', u'ENSMUSG00000022185', u'ENSMUSG00000031320', u'ENSMUSG00000004356', u'ENSMUSG00000037849', u'ENSMUSG00000029561', u'ENSMUSG00000036054', u'ENSMUSG00000026404', u'ENSMUSG00000002731', u'ENSMUSG00000053536', u'ENSMUSG00000053289', u'ENSMUSG00000032435', u'ENSMUSG00000036114', u'ENSMUSG00000044786', u'ENSMUSG00000021938', u'ENSMUSG00000006333', u'ENSMUSG00000074457', u'ENSMUSG00000024414', u'ENSMUSG00000022748', u'ENSMUSG00000021838', u'ENSMUSG00000024991', u'ENSMUSG00000064030', u'ENSMUSG00000020300', u'ENSMUSG00000059447', u'ENSMUSG00000055531', u'ENSMUSG00000040249', u'ENSMUSG00000027540', u'ENSMUSG00000020262', u'ENSMUSG00000031107', u'ENSMUSG00000073676', u'ENSMUSG00000068921', u'ENSMUSG00000022300', u'ENSMUSG00000031060', u'ENSMUSG00000018882', u'ENSMUSG00000020514', u'ENSMUSG00000020515', u'ENSMUSG00000020459', u'ENSMUSG00000020458', u'ENSMUSG00000022565', u'ENSMUSG00000039456', u'ENSMUSG00000020454', u'ENSMUSG00000058301', u'ENSMUSG00000029614', u'ENSMUSG00000078765', u'ENSMUSG00000021494', u'ENSMUSG00000039607', u'ENSMUSG00000034088', u'ENSMUSG00000045817', u'ENSMUSG00000039148', u'ENSMUSG00000017548', u'ENSMUSG00000029922', u'ENSMUSG00000020069', u'ENSMUSG00000079507', u'ENSMUSG00000028820', u'ENSMUSG00000022247', u'ENSMUSG00000039356', u'ENSMUSG00000025266', u'ENSMUSG00000034120', u'ENSMUSG00000004980', u'ENSMUSG00000025262', u'ENSMUSG00000015217', u'ENSMUSG00000025260', u'ENSMUSG00000037492', u'ENSMUSG00000026707', u'ENSMUSG00000018974', u'ENSMUSG00000039286', u'ENSMUSG00000029687', u'ENSMUSG00000021692', u'ENSMUSG00000028228', u'ENSMUSG00000091086', u'ENSMUSG00000048439', u'ENSMUSG00000032940', u'ENSMUSG00000037805', u'ENSMUSG00000029447', u'ENSMUSG00000024969', u'ENSMUSG00000038510', u'ENSMUSG00000061479', u'ENSMUSG00000028134', u'ENSMUSG00000027184', u'ENSMUSG00000028137', u'ENSMUSG00000024966', u'ENSMUSG00000027185', u'ENSMUSG00000058558', u'ENSMUSG00000024360', u'ENSMUSG00000028741', u'ENSMUSG00000001674', u'ENSMUSG00000054256', u'ENSMUSG00000024369', u'ENSMUSG00000028907', u'ENSMUSG00000028622', u'ENSMUSG00000000275', u'ENSMUSG00000060657', u'ENSMUSG00000033487', u'ENSMUSG00000036873', u'ENSMUSG00000074656', u'ENSMUSG00000069306', u'ENSMUSG00000041670', u'ENSMUSG00000045932', u'ENSMUSG00000042699', u'ENSMUSG00000033099', u'ENSMUSG00000021116', u'ENSMUSG00000020949', u'ENSMUSG00000020580', u'ENSMUSG00000004100', u'ENSMUSG00000027881', u'ENSMUSG00000029430', u'ENSMUSG00000029538', u'ENSMUSG00000037993', u'ENSMUSG00000029439', u'ENSMUSG00000032480', u'ENSMUSG00000042500', u'ENSMUSG00000026797', u'ENSMUSG00000035842', u'ENSMUSG00000004085', u'ENSMUSG00000034908', u'ENSMUSG00000008348', u'ENSMUSG00000040952', u'ENSMUSG00000025134', u'ENSMUSG00000025047', u'ENSMUSG00000023043', u'ENSMUSG00000020280', u'ENSMUSG00000045983', u'ENSMUSG00000041319', u'ENSMUSG00000000552', u'ENSMUSG00000004865', u'ENSMUSG00000028484', u'ENSMUSG00000034422', u'ENSMUSG00000054889', u'ENSMUSG00000063200', u'ENSMUSG00000040383', u'ENSMUSG00000059005', u'ENSMUSG00000005683', u'ENSMUSG00000040651', u'ENSMUSG00000028964', u'ENSMUSG00000052751', u'ENSMUSG00000031960', u'ENSMUSG00000020738', u'ENSMUSG00000039536', u'ENSMUSG00000032316', u'ENSMUSG00000036880', u'ENSMUSG00000038446', u'ENSMUSG00000016181', u'ENSMUSG00000061232', u'ENSMUSG00000027086', u'ENSMUSG00000001416', u'ENSMUSG00000040688', u'ENSMUSG00000063919', u'ENSMUSG00000021460', u'ENSMUSG00000034259', u'ENSMUSG00000072115', u'ENSMUSG00000030264', u'ENSMUSG00000062203', u'ENSMUSG00000033845', u'ENSMUSG00000021238', u'ENSMUSG00000091971', u'ENSMUSG00000050505', u'ENSMUSG00000031311', u'ENSMUSG00000022983', u'ENSMUSG00000018433', u'ENSMUSG00000062309', u'ENSMUSG00000031353', u'ENSMUSG00000071645', u'ENSMUSG00000037262', u'ENSMUSG00000016503', u'ENSMUSG00000031403', u'ENSMUSG00000051518', u'ENSMUSG00000023007', u'ENSMUSG00000046201', u'ENSMUSG00000002477', u'ENSMUSG00000031816', u'ENSMUSG00000031796', u'ENSMUSG00000043263', u'ENSMUSG00000001056', u'ENSMUSG00000060093', u'ENSMUSG00000040720', u'ENSMUSG00000067274', u'ENSMUSG00000003923', u'ENSMUSG00000038384', u'ENSMUSG00000000827', u'ENSMUSG00000034163', u'ENSMUSG00000049184', u'ENSMUSG00000042814', u'ENSMUSG00000025869', u'ENSMUSG00000020029', u'ENSMUSG00000028651', u'ENSMUSG00000090272', u'ENSMUSG00000032181', u'ENSMUSG00000028959', u'ENSMUSG00000051223', u'ENSMUSG00000031639', u'ENSMUSG00000027176', u'ENSMUSG00000019897', u'ENSMUSG00000062647', u'ENSMUSG00000067150', u'ENSMUSG00000040043', u'ENSMUSG00000047084', u'ENSMUSG00000048148', u'ENSMUSG00000024829', u'ENSMUSG00000026356', u'ENSMUSG00000060373', u'ENSMUSG00000036167', u'ENSMUSG00000036160', u'ENSMUSG00000029028', u'ENSMUSG00000019802', u'ENSMUSG00000021866', u'ENSMUSG00000011306', u'ENSMUSG00000022325', u'ENSMUSG00000022323', u'ENSMUSG00000015092', u'ENSMUSG00000033931', u'ENSMUSG00000078427', u'ENSMUSG00000022285', u'ENSMUSG00000061482', u'ENSMUSG00000025817', u'ENSMUSG00000025428', u'ENSMUSG00000022283', u'ENSMUSG00000020549', u'ENSMUSG00000026915', u'ENSMUSG00000021012', u'ENSMUSG00000068882', u'ENSMUSG00000031134', u'ENSMUSG00000027514', u'ENSMUSG00000057388', u'ENSMUSG00000033294', u'ENSMUSG00000038774', u'ENSMUSG00000034708', u'ENSMUSG00000020464', u'ENSMUSG00000028779', u'ENSMUSG00000020460', u'ENSMUSG00000028772', u'ENSMUSG00000027680', u'ENSMUSG00000020783', u'ENSMUSG00000055065', u'ENSMUSG00000020780', u'ENSMUSG00000032212', u'ENSMUSG00000041852', u'ENSMUSG00000037487', u'ENSMUSG00000058267', u'ENSMUSG00000024081', u'ENSMUSG00000032215', u'ENSMUSG00000024732', u'ENSMUSG00000022774', u'ENSMUSG00000033565', u'ENSMUSG00000089824', u'ENSMUSG00000017478', u'ENSMUSG00000022961', u'ENSMUSG00000036249', u'ENSMUSG00000041530', u'ENSMUSG00000037601', u'ENSMUSG00000021392', u'ENSMUSG00000045193', u'ENSMUSG00000054808', u'ENSMUSG00000024613', u'ENSMUSG00000022800', u'ENSMUSG00000052707', u'ENSMUSG00000023939', u'ENSMUSG00000019143', u'ENSMUSG00000035093', u'ENSMUSG00000029475', u'ENSMUSG00000033423', u'ENSMUSG00000019792', u'ENSMUSG00000040269', u'ENSMUSG00000041781', u'ENSMUSG00000027288', u'ENSMUSG00000041912', u'ENSMUSG00000078676', u'ENSMUSG00000035960', u'ENSMUSG00000040423', u'ENSMUSG00000023944', u'ENSMUSG00000037020', u'ENSMUSG00000043716', u'ENSMUSG00000041199', u'ENSMUSG00000029480', u'ENSMUSG00000027193', u'ENSMUSG00000028676', u'ENSMUSG00000034211', u'ENSMUSG00000031601', u'ENSMUSG00000032231', u'ENSMUSG00000061983', u'ENSMUSG00000039630', u'ENSMUSG00000041747', u'ENSMUSG00000052551', u'ENSMUSG00000015748', u'ENSMUSG00000025086', u'ENSMUSG00000075600', u'ENSMUSG00000028034', u'ENSMUSG00000021645', u'ENSMUSG00000068823', u'ENSMUSG00000063550', u'ENSMUSG00000038848', u'ENSMUSG00000076437', u'ENSMUSG00000033732', u'ENSMUSG00000052684', u'ENSMUSG00000058655', u'ENSMUSG00000009535', u'ENSMUSG00000029507', u'ENSMUSG00000029504', u'ENSMUSG00000029860', u'ENSMUSG00000074102', u'ENSMUSG00000021039', u'ENSMUSG00000030432', u'ENSMUSG00000021707', u'ENSMUSG00000031590', u'ENSMUSG00000017999', u'ENSMUSG00000036990', u'ENSMUSG00000028911', u'ENSMUSG00000005625', u'ENSMUSG00000004880', u'ENSMUSG00000042043', u'ENSMUSG00000018362', u'ENSMUSG00000030512', u'ENSMUSG00000028292', u'ENSMUSG00000037236', u'ENSMUSG00000008682', u'ENSMUSG00000016554', u'ENSMUSG00000018648', u'ENSMUSG00000020802', u'ENSMUSG00000028902', u'ENSMUSG00000030423', u'ENSMUSG00000028452', u'ENSMUSG00000016018', u'ENSMUSG00000056962', u'ENSMUSG00000026273', u'ENSMUSG00000027770', u'ENSMUSG00000007850', u'ENSMUSG00000037316', u'ENSMUSG00000004044', u'ENSMUSG00000027774', u'ENSMUSG00000052337', u'ENSMUSG00000018765', u'ENSMUSG00000031851', u'ENSMUSG00000076441', u'ENSMUSG00000003410', u'ENSMUSG00000049287', u'ENSMUSG00000032044', u'ENSMUSG00000040464', u'ENSMUSG00000032042', u'ENSMUSG00000038884', u'ENSMUSG00000025980', u'ENSMUSG00000030216', u'ENSMUSG00000045128', u'ENSMUSG00000043323', u'ENSMUSG00000030357', u'ENSMUSG00000061787', u'ENSMUSG00000024079', u'ENSMUSG00000032661', u'ENSMUSG00000001569', u'ENSMUSG00000040482', u'ENSMUSG00000040725', u'ENSMUSG00000028842', u'ENSMUSG00000021264', u'ENSMUSG00000057561', u'ENSMUSG00000045538', u'ENSMUSG00000032178', u'ENSMUSG00000031672', u'ENSMUSG00000046330', u'ENSMUSG00000051550', u'ENSMUSG00000022179', u'ENSMUSG00000031189', u'ENSMUSG00000004268', u'ENSMUSG00000052488', u'ENSMUSG00000045838', u'ENSMUSG00000004591', u'ENSMUSG00000032423', u'ENSMUSG00000049517', u'ENSMUSG00000022779', u'ENSMUSG00000020116', u'ENSMUSG00000004951', u'ENSMUSG00000040761', u'ENSMUSG00000001440', u'ENSMUSG00000026107', u'ENSMUSG00000001445', u'ENSMUSG00000054312', u'ENSMUSG00000014504', u'ENSMUSG00000021413', u'ENSMUSG00000007670', u'ENSMUSG00000024287', u'ENSMUSG00000059119', u'ENSMUSG00000020372', u'ENSMUSG00000045624', u'ENSMUSG00000030057', u'ENSMUSG00000090223', u'ENSMUSG00000031174', u'ENSMUSG00000018189', u'ENSMUSG00000020273', u'ENSMUSG00000033760', u'ENSMUSG00000022792', u'ENSMUSG00000032050', u'ENSMUSG00000079108', u'ENSMUSG00000022797', u'ENSMUSG00000045427', u'ENSMUSG00000026896', u'ENSMUSG00000041308', u'ENSMUSG00000039717', u'ENSMUSG00000003429', u'ENSMUSG00000021481', u'ENSMUSG00000003660', u'ENSMUSG00000022312', u'ENSMUSG00000022313', u'ENSMUSG00000044149', u'ENSMUSG00000020079', u'ENSMUSG00000069305', u'ENSMUSG00000022255', u'ENSMUSG00000064061', u'ENSMUSG00000031848', u'ENSMUSG00000027714', u'ENSMUSG00000051557', u'ENSMUSG00000020075', u'ENSMUSG00000020074', u'ENSMUSG00000020076', u'ENSMUSG00000012405', u'ENSMUSG00000024472', u'ENSMUSG00000032959', u'ENSMUSG00000031004', u'ENSMUSG00000021127', u'ENSMUSG00000020430', u'ENSMUSG00000048000', u'ENSMUSG00000025451', u'ENSMUSG00000010362', u'ENSMUSG00000001383', u'ENSMUSG00000030678', u'ENSMUSG00000048755', u'ENSMUSG00000028882', u'ENSMUSG00000078622', u'ENSMUSG00000037364', u'ENSMUSG00000060126', u'ENSMUSG00000025337', u'ENSMUSG00000038132', u'ENSMUSG00000036550', u'ENSMUSG00000025208', u'ENSMUSG00000024608', u'ENSMUSG00000028639', u'ENSMUSG00000022557', u'ENSMUSG00000010095', u'ENSMUSG00000024217', u'ENSMUSG00000010097', u'ENSMUSG00000024359', u'ENSMUSG00000024604', u'ENSMUSG00000046791', u'ENSMUSG00000040731', u'ENSMUSG00000046139', u'ENSMUSG00000028140', u'ENSMUSG00000071172', u'ENSMUSG00000022858', u'ENSMUSG00000019297', u'ENSMUSG00000021040', u'ENSMUSG00000021047', u'ENSMUSG00000042625', u'ENSMUSG00000059923', u'ENSMUSG00000070544', u'ENSMUSG00000023087', u'ENSMUSG00000009470', u'ENSMUSG00000004393', u'ENSMUSG00000003849', u'ENSMUSG00000024841', u'ENSMUSG00000061136', u'ENSMUSG00000026254', u'ENSMUSG00000040225', u'ENSMUSG00000037070', u'ENSMUSG00000023911', u'ENSMUSG00000004099', u'ENSMUSG00000025024', u'ENSMUSG00000020994', u'ENSMUSG00000028546', u'ENSMUSG00000035851', u'ENSMUSG00000038290', u'ENSMUSG00000008373', u'ENSMUSG00000059273', u'ENSMUSG00000030411', u'ENSMUSG00000020290', u'ENSMUSG00000036181', u'ENSMUSG00000060550', u'ENSMUSG00000001016', u'ENSMUSG00000001017', u'ENSMUSG00000037572', u'ENSMUSG00000027639', u'ENSMUSG00000027324', u'ENSMUSG00000025920', u'ENSMUSG00000030779', u'ENSMUSG00000035517', u'ENSMUSG00000035929', u'ENSMUSG00000042133', u'ENSMUSG00000026234', u'ENSMUSG00000028495', u'ENSMUSG00000015672', u'ENSMUSG00000031393', u'ENSMUSG00000093661', u'ENSMUSG00000020721', u'ENSMUSG00000000384', u'ENSMUSG00000037361', u'ENSMUSG00000079339', u'ENSMUSG00000028060', u'ENSMUSG00000039997', u'ENSMUSG00000032582', u'ENSMUSG00000032580', u'ENSMUSG00000026825', u'ENSMUSG00000062867', u'ENSMUSG00000028069', u'ENSMUSG00000024135', u'ENSMUSG00000038069', u'ENSMUSG00000030062', u'ENSMUSG00000026196', u'ENSMUSG00000028322', u'ENSMUSG00000018428', u'ENSMUSG00000051062', u'ENSMUSG00000031586', u'ENSMUSG00000018425', u'ENSMUSG00000053012', u'ENSMUSG00000021222', u'ENSMUSG00000063800', u'ENSMUSG00000008658', u'ENSMUSG00000038900', u'ENSMUSG00000052676', u'ENSMUSG00000037275', u'ENSMUSG00000023988', u'ENSMUSG00000038335', u'ENSMUSG00000040945', u'ENSMUSG00000024038', u'ENSMUSG00000027404', u'ENSMUSG00000031826', u'ENSMUSG00000040302', u'ENSMUSG00000040824', u'ENSMUSG00000000339', u'ENSMUSG00000026127', u'ENSMUSG00000018040', u'ENSMUSG00000053565', u'ENSMUSG00000026511', u'ENSMUSG00000002767', u'ENSMUSG00000030744', u'ENSMUSG00000019929', u'ENSMUSG00000008489', u'ENSMUSG00000060938', u'ENSMUSG00000024422', u'ENSMUSG00000053333', u'ENSMUSG00000022139', u'ENSMUSG00000030980', u'ENSMUSG00000000838', u'ENSMUSG00000037857', u'ENSMUSG00000017830', u'ENSMUSG00000025962', u'ENSMUSG00000037447', u'ENSMUSG00000070319', u'ENSMUSG00000018405', u'ENSMUSG00000057322', u'ENSMUSG00000063787', u'ENSMUSG00000022884', u'ENSMUSG00000063785', u'ENSMUSG00000029169', u'ENSMUSG00000041459', u'ENSMUSG00000035649', u'ENSMUSG00000029167', u'ENSMUSG00000066568', u'ENSMUSG00000010592', u'ENSMUSG00000061360', u'ENSMUSG00000032518', u'ENSMUSG00000044475', u'ENSMUSG00000053801', u'ENSMUSG00000053411', u'ENSMUSG00000032103', u'ENSMUSG00000032101', u'ENSMUSG00000029014', u'ENSMUSG00000056851', u'ENSMUSG00000002996', u'ENSMUSG00000008393', u'ENSMUSG00000022721', u'ENSMUSG00000039501', u'ENSMUSG00000001120', u'ENSMUSG00000002227', u'ENSMUSG00000024800', u'ENSMUSG00000032293', u'ENSMUSG00000040429', u'ENSMUSG00000022685', u'ENSMUSG00000032294', u'ENSMUSG00000035248', u'ENSMUSG00000031328', u'ENSMUSG00000056211', u'ENSMUSG00000038374', u'ENSMUSG00000071866', u'ENSMUSG00000005846', u'ENSMUSG00000036693', u'ENSMUSG00000020477', u'ENSMUSG00000038406', u'ENSMUSG00000043991', u'ENSMUSG00000044155', u'ENSMUSG00000039804', u'ENSMUSG00000048222', u'ENSMUSG00000028760', u'ENSMUSG00000036698', u'ENSMUSG00000041598', u'ENSMUSG00000032590', u'ENSMUSG00000027203', u'ENSMUSG00000029647', u'ENSMUSG00000024483', u'ENSMUSG00000010608', u'ENSMUSG00000040354', u'ENSMUSG00000072437', u'ENSMUSG00000078348', u'ENSMUSG00000024097', u'ENSMUSG00000027201', u'ENSMUSG00000024095', u'ENSMUSG00000044986', u'ENSMUSG00000020329', u'ENSMUSG00000024312', u'ENSMUSG00000006498', u'ENSMUSG00000068856', u'ENSMUSG00000057706', u'ENSMUSG00000041057', u'ENSMUSG00000041506', u'ENSMUSG00000047021', u'ENSMUSG00000071723', u'ENSMUSG00000039221', u'ENSMUSG00000055436', u'ENSMUSG00000067367', u'ENSMUSG00000002129', u'ENSMUSG00000007721', u'ENSMUSG00000073079', u'ENSMUSG00000057278', u'ENSMUSG00000036112', u'ENSMUSG00000028691', u'ENSMUSG00000019179', u'ENSMUSG00000058799', u'ENSMUSG00000032637', u'ENSMUSG00000051169', u'ENSMUSG00000020680', u'ENSMUSG00000055322', u'ENSMUSG00000024949', u'ENSMUSG00000001909', u'ENSMUSG00000029581', u'ENSMUSG00000028114', u'ENSMUSG00000025982', u'ENSMUSG00000036323', u'ENSMUSG00000022889', u'ENSMUSG00000030983', u'ENSMUSG00000036285', u'ENSMUSG00000033499', u'ENSMUSG00000030986', u'ENSMUSG00000030738', u'ENSMUSG00000022468', u'ENSMUSG00000041453', u'ENSMUSG00000028165', u'ENSMUSG00000041415', u'ENSMUSG00000024268', u'ENSMUSG00000022516', u'ENSMUSG00000028609', u'ENSMUSG00000020923', u'ENSMUSG00000031370', u'ENSMUSG00000004127', u'ENSMUSG00000021178', u'ENSMUSG00000029599', u'ENSMUSG00000014606', u'ENSMUSG00000042369', u'ENSMUSG00000031533', u'ENSMUSG00000020929', u'ENSMUSG00000067288', u'ENSMUSG00000052137', u'ENSMUSG00000038305']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0044822'])),
    NtGoeaResults(GO='GO:0003725', NS='MF', enrichment='e', name='double-stranded RNA binding', ratio_in_study=(8, 624), ratio_in_pop=(62, 13836), p_uncorrected=0.0064492548336028115, depth=5, study_count=8, p_sm_bonferroni=1.0, p_fdr_bh=0.23721779020273009, study_items=set([u'ENSMUSG00000041827', u'ENSMUSG00000032661', u'ENSMUSG00000017830', u'ENSMUSG00000024079', u'ENSMUSG00000040296', u'ENSMUSG00000029561', u'ENSMUSG00000042699', u'ENSMUSG00000026896']), pop_n=13836, pop_count=62, pop_items=set([u'ENSMUSG00000020075', u'ENSMUSG00000032661', u'ENSMUSG00000027770', u'ENSMUSG00000066861', u'ENSMUSG00000039630', u'ENSMUSG00000020262', u'ENSMUSG00000024079', u'ENSMUSG00000032480', u'ENSMUSG00000042500', u'ENSMUSG00000042699', u'ENSMUSG00000037149', u'ENSMUSG00000031207', u'ENSMUSG00000031639', u'ENSMUSG00000036752', u'ENSMUSG00000028411', u'ENSMUSG00000023944', u'ENSMUSG00000036698', u'ENSMUSG00000039737', u'ENSMUSG00000041827', u'ENSMUSG00000022191', u'ENSMUSG00000022718', u'ENSMUSG00000023051', u'ENSMUSG00000026248', u'ENSMUSG00000066568', u'ENSMUSG00000027763', u'ENSMUSG00000010095', u'ENSMUSG00000047126', u'ENSMUSG00000026728', u'ENSMUSG00000041415', u'ENSMUSG00000028842', u'ENSMUSG00000031901', u'ENSMUSG00000039316', u'ENSMUSG00000032178', u'ENSMUSG00000034908', u'ENSMUSG00000022696', u'ENSMUSG00000059796', u'ENSMUSG00000015143', u'ENSMUSG00000026915', u'ENSMUSG00000039536', u'ENSMUSG00000017830', u'ENSMUSG00000040028', u'ENSMUSG00000029561', u'ENSMUSG00000044583', u'ENSMUSG00000022797', u'ENSMUSG00000052776', u'ENSMUSG00000091971', u'ENSMUSG00000026896', u'ENSMUSG00000025980', u'ENSMUSG00000001016', u'ENSMUSG00000023004', u'ENSMUSG00000021481', u'ENSMUSG00000002731', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000020079', u'ENSMUSG00000066551', u'ENSMUSG00000022255', u'ENSMUSG00000041530', u'ENSMUSG00000028889', u'ENSMUSG00000037921', u'ENSMUSG00000025920', u'ENSMUSG00000029169']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003726', NS='MF', enrichment='e', name='double-stranded RNA adenosine deaminase activity', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027514']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000020262', u'ENSMUSG00000027951', u'ENSMUSG00000027514']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0003971'])),
    NtGoeaResults(GO='GO:0003727', NS='MF', enrichment='e', name='single-stranded RNA binding', ratio_in_study=(5, 624), ratio_in_pop=(37, 13836), p_uncorrected=0.02425825059425211, depth=5, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=0.65803123287275245, study_items=set([u'ENSMUSG00000035842', u'ENSMUSG00000017830', u'ENSMUSG00000042699', u'ENSMUSG00000040296', u'ENSMUSG00000026896']), pop_n=13836, pop_count=37, pop_items=set([u'ENSMUSG00000025937', u'ENSMUSG00000039630', u'ENSMUSG00000042500', u'ENSMUSG00000042079', u'ENSMUSG00000042699', u'ENSMUSG00000058756', u'ENSMUSG00000035842', u'ENSMUSG00000036698', u'ENSMUSG00000037921', u'ENSMUSG00000066568', u'ENSMUSG00000066551', u'ENSMUSG00000024258', u'ENSMUSG00000010097', u'ENSMUSG00000028842', u'ENSMUSG00000021519', u'ENSMUSG00000026915', u'ENSMUSG00000031134', u'ENSMUSG00000017830', u'ENSMUSG00000041168', u'ENSMUSG00000069769', u'ENSMUSG00000044583', u'ENSMUSG00000089715', u'ENSMUSG00000039850', u'ENSMUSG00000026896', u'ENSMUSG00000071662', u'ENSMUSG00000030057', u'ENSMUSG00000056962', u'ENSMUSG00000054256', u'ENSMUSG00000053411', u'ENSMUSG00000026273', u'ENSMUSG00000040296', u'ENSMUSG00000020485', u'ENSMUSG00000022332', u'ENSMUSG00000041530', u'ENSMUSG00000039989', u'ENSMUSG00000025578', u'ENSMUSG00000042396']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0003728'])),
    NtGoeaResults(GO='GO:0003729', NS='MF', enrichment='p', name='mRNA binding', ratio_in_study=(5, 624), ratio_in_pop=(117, 13836), p_uncorrected=1.0, depth=5, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025747', u'ENSMUSG00000021707', u'ENSMUSG00000042699', u'ENSMUSG00000004642', u'ENSMUSG00000024991']), pop_n=13836, pop_count=117, pop_items=set([u'ENSMUSG00000006005', u'ENSMUSG00000018379', u'ENSMUSG00000020863', u'ENSMUSG00000042699', u'ENSMUSG00000021962', u'ENSMUSG00000046756', u'ENSMUSG00000025580', u'ENSMUSG00000020454', u'ENSMUSG00000038957', u'ENSMUSG00000059005', u'ENSMUSG00000029614', u'ENSMUSG00000038398', u'ENSMUSG00000027176', u'ENSMUSG00000041477', u'ENSMUSG00000022774', u'ENSMUSG00000007670', u'ENSMUSG00000028330', u'ENSMUSG00000091086', u'ENSMUSG00000028134', u'ENSMUSG00000058558', u'ENSMUSG00000040482', u'ENSMUSG00000044533', u'ENSMUSG00000063919', u'ENSMUSG00000000568', u'ENSMUSG00000018583', u'ENSMUSG00000022160', u'ENSMUSG00000020741', u'ENSMUSG00000021127', u'ENSMUSG00000034022', u'ENSMUSG00000063511', u'ENSMUSG00000004642', u'ENSMUSG00000027810', u'ENSMUSG00000018446', u'ENSMUSG00000024513', u'ENSMUSG00000028882', u'ENSMUSG00000045983', u'ENSMUSG00000028639', u'ENSMUSG00000010097', u'ENSMUSG00000029823', u'ENSMUSG00000028964', u'ENSMUSG00000040028', u'ENSMUSG00000022858', u'ENSMUSG00000021047', u'ENSMUSG00000031393', u'ENSMUSG00000023087', u'ENSMUSG00000031256', u'ENSMUSG00000028546', u'ENSMUSG00000051695', u'ENSMUSG00000029141', u'ENSMUSG00000044786', u'ENSMUSG00000024188', u'ENSMUSG00000011257', u'ENSMUSG00000037475', u'ENSMUSG00000028081', u'ENSMUSG00000035517', u'ENSMUSG00000040423', u'ENSMUSG00000028495', u'ENSMUSG00000024991', u'ENSMUSG00000041328', u'ENSMUSG00000032580', u'ENSMUSG00000041939', u'ENSMUSG00000008658', u'ENSMUSG00000067150', u'ENSMUSG00000050213', u'ENSMUSG00000030744', u'ENSMUSG00000022283', u'ENSMUSG00000000838', u'ENSMUSG00000031134', u'ENSMUSG00000029402', u'ENSMUSG00000029405', u'ENSMUSG00000074129', u'ENSMUSG00000025362', u'ENSMUSG00000037058', u'ENSMUSG00000046380', u'ENSMUSG00000041360', u'ENSMUSG00000020783', u'ENSMUSG00000055531', u'ENSMUSG00000023106', u'ENSMUSG00000036572', u'ENSMUSG00000034274', u'ENSMUSG00000033565', u'ENSMUSG00000062997', u'ENSMUSG00000012848', u'ENSMUSG00000060373', u'ENSMUSG00000003435', u'ENSMUSG00000022800', u'ENSMUSG00000075376', u'ENSMUSG00000062078', u'ENSMUSG00000053536', u'ENSMUSG00000038374', u'ENSMUSG00000031754', u'ENSMUSG00000036698', u'ENSMUSG00000063550', u'ENSMUSG00000043716', u'ENSMUSG00000010608', u'ENSMUSG00000024095', u'ENSMUSG00000037296', u'ENSMUSG00000006498', u'ENSMUSG00000026374', u'ENSMUSG00000037958', u'ENSMUSG00000003814', u'ENSMUSG00000040613', u'ENSMUSG00000032565', u'ENSMUSG00000021270', u'ENSMUSG00000021707', u'ENSMUSG00000025586', u'ENSMUSG00000028114', u'ENSMUSG00000025982', u'ENSMUSG00000079065', u'ENSMUSG00000022370', u'ENSMUSG00000024268', u'ENSMUSG00000037742', u'ENSMUSG00000018765', u'ENSMUSG00000025576', u'ENSMUSG00000025747', u'ENSMUSG00000063646', u'ENSMUSG00000021838']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003730', NS='MF', enrichment='p', name="mRNA 3'-UTR binding", ratio_in_study=(1, 624), ratio_in_pop=(50, 13836), p_uncorrected=0.7276382812681743, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552']), pop_n=13836, pop_count=50, pop_items=set([u'ENSMUSG00000021546', u'ENSMUSG00000015165', u'ENSMUSG00000020300', u'ENSMUSG00000035093', u'ENSMUSG00000038132', u'ENSMUSG00000020719', u'ENSMUSG00000028309', u'ENSMUSG00000027680', u'ENSMUSG00000023495', u'ENSMUSG00000059552', u'ENSMUSG00000061477', u'ENSMUSG00000034681', u'ENSMUSG00000039652', u'ENSMUSG00000042109', u'ENSMUSG00000030189', u'ENSMUSG00000037275', u'ENSMUSG00000000552', u'ENSMUSG00000035139', u'ENSMUSG00000060373', u'ENSMUSG00000036371', u'ENSMUSG00000058558', u'ENSMUSG00000028580', u'ENSMUSG00000039630', u'ENSMUSG00000040028', u'ENSMUSG00000020594', u'ENSMUSG00000004980', u'ENSMUSG00000026634', u'ENSMUSG00000022283', u'ENSMUSG00000007670', u'ENSMUSG00000000838', u'ENSMUSG00000021460', u'ENSMUSG00000066037', u'ENSMUSG00000048696', u'ENSMUSG00000028199', u'ENSMUSG00000037331', u'ENSMUSG00000028546', u'ENSMUSG00000025586', u'ENSMUSG00000005846', u'ENSMUSG00000010592', u'ENSMUSG00000071645', u'ENSMUSG00000030816', u'ENSMUSG00000022234', u'ENSMUSG00000045193', u'ENSMUSG00000041459', u'ENSMUSG00000022313', u'ENSMUSG00000040423', u'ENSMUSG00000008393', u'ENSMUSG00000044786', u'ENSMUSG00000039607', u'ENSMUSG00000039782']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003743', NS='MF', enrichment='p', name='translation initiation factor activity', ratio_in_study=(1, 624), ratio_in_pop=(47, 13836), p_uncorrected=0.7239562341383725, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024991']), pop_n=13836, pop_count=47, pop_items=set([u'ENSMUSG00000028683', u'ENSMUSG00000005610', u'ENSMUSG00000043424', u'ENSMUSG00000020459', u'ENSMUSG00000028760', u'ENSMUSG00000057561', u'ENSMUSG00000004788', u'ENSMUSG00000027810', u'ENSMUSG00000028156', u'ENSMUSG00000024841', u'ENSMUSG00000045983', u'ENSMUSG00000035150', u'ENSMUSG00000016510', u'ENSMUSG00000027170', u'ENSMUSG00000000355', u'ENSMUSG00000027236', u'ENSMUSG00000053565', u'ENSMUSG00000029145', u'ENSMUSG00000059796', u'ENSMUSG00000021282', u'ENSMUSG00000058655', u'ENSMUSG00000026254', u'ENSMUSG00000070319', u'ENSMUSG00000031029', u'ENSMUSG00000026083', u'ENSMUSG00000022884', u'ENSMUSG00000067194', u'ENSMUSG00000028798', u'ENSMUSG00000042426', u'ENSMUSG00000093661', u'ENSMUSG00000016554', u'ENSMUSG00000023106', u'ENSMUSG00000029388', u'ENSMUSG00000040731', u'ENSMUSG00000030738', u'ENSMUSG00000003235', u'ENSMUSG00000035530', u'ENSMUSG00000033047', u'ENSMUSG00000022312', u'ENSMUSG00000056076', u'ENSMUSG00000074656', u'ENSMUSG00000027613', u'ENSMUSG00000006941', u'ENSMUSG00000022336', u'ENSMUSG00000026427', u'ENSMUSG00000021116', u'ENSMUSG00000024991']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0003744', 'GO:0003745'])),
    NtGoeaResults(GO='GO:0003755', NS='MF', enrichment='p', name='peptidyl-prolyl cis-trans isomerase activity', ratio_in_study=(1, 624), ratio_in_pop=(26, 13836), p_uncorrected=1.0, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024007']), pop_n=13836, pop_count=26, pop_items=set([u'ENSMUSG00000020635', u'ENSMUSG00000039515', u'ENSMUSG00000021715', u'ENSMUSG00000021713', u'ENSMUSG00000021868', u'ENSMUSG00000029781', u'ENSMUSG00000056629', u'ENSMUSG00000032525', u'ENSMUSG00000022771', u'ENSMUSG00000030357', u'ENSMUSG00000032171', u'ENSMUSG00000003226', u'ENSMUSG00000071866', u'ENSMUSG00000038074', u'ENSMUSG00000019428', u'ENSMUSG00000001555', u'ENSMUSG00000032966', u'ENSMUSG00000028651', u'ENSMUSG00000027804', u'ENSMUSG00000032383', u'ENSMUSG00000042133', u'ENSMUSG00000024222', u'ENSMUSG00000015757', u'ENSMUSG00000026035', u'ENSMUSG00000024007', u'ENSMUSG00000020949']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0004752', 'GO:0042028'])),
    NtGoeaResults(GO='GO:0003774', NS='MF', enrichment='p', name='motor activity', ratio_in_study=(2, 624), ratio_in_pop=(56, 13836), p_uncorrected=0.9999999999939221, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005237', u'ENSMUSG00000051378']), pop_n=13836, pop_count=56, pop_items=set([u'ENSMUSG00000032435', u'ENSMUSG00000042064', u'ENSMUSG00000053093', u'ENSMUSG00000009013', u'ENSMUSG00000029757', u'ENSMUSG00000063605', u'ENSMUSG00000020437', u'ENSMUSG00000039824', u'ENSMUSG00000047193', u'ENSMUSG00000068876', u'ENSMUSG00000022420', u'ENSMUSG00000022443', u'ENSMUSG00000068696', u'ENSMUSG00000024253', u'ENSMUSG00000034593', u'ENSMUSG00000018417', u'ENSMUSG00000032220', u'ENSMUSG00000022262', u'ENSMUSG00000047459', u'ENSMUSG00000033577', u'ENSMUSG00000035770', u'ENSMUSG00000061322', u'ENSMUSG00000035441', u'ENSMUSG00000000631', u'ENSMUSG00000031865', u'ENSMUSG00000032171', u'ENSMUSG00000039057', u'ENSMUSG00000055775', u'ENSMUSG00000090841', u'ENSMUSG00000066952', u'ENSMUSG00000052273', u'ENSMUSG00000031176', u'ENSMUSG00000033826', u'ENSMUSG00000020483', u'ENSMUSG00000004677', u'ENSMUSG00000020527', u'ENSMUSG00000039585', u'ENSMUSG00000051378', u'ENSMUSG00000030761', u'ENSMUSG00000027012', u'ENSMUSG00000020908', u'ENSMUSG00000021879', u'ENSMUSG00000032232', u'ENSMUSG00000030739', u'ENSMUSG00000020900', u'ENSMUSG00000018707', u'ENSMUSG00000034706', u'ENSMUSG00000025885', u'ENSMUSG00000022272', u'ENSMUSG00000005237', u'ENSMUSG00000018830', u'ENSMUSG00000042523', u'ENSMUSG00000074652', u'ENSMUSG00000024300', u'ENSMUSG00000025410', u'ENSMUSG00000017774']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003777', NS='MF', enrichment='e', name='microtubule motor activity', ratio_in_study=(15, 624), ratio_in_pop=(59, 13836), p_uncorrected=3.4596846922072495e-08, depth=8, study_count=15, p_sm_bonferroni=0.00054337807775807056, p_fdr_bh=8.3596627347395482e-06, study_items=set([u'ENSMUSG00000003779', u'ENSMUSG00000051378', u'ENSMUSG00000024795', u'ENSMUSG00000027115', u'ENSMUSG00000032254', u'ENSMUSG00000028678', u'ENSMUSG00000045328', u'ENSMUSG00000034311', u'ENSMUSG00000030677', u'ENSMUSG00000005237', u'ENSMUSG00000041498', u'ENSMUSG00000024301', u'ENSMUSG00000012443', u'ENSMUSG00000079553', u'ENSMUSG00000036768']), pop_n=13836, pop_count=59, pop_items=set([u'ENSMUSG00000026494', u'ENSMUSG00000032435', u'ENSMUSG00000019027', u'ENSMUSG00000032489', u'ENSMUSG00000063077', u'ENSMUSG00000003546', u'ENSMUSG00000029757', u'ENSMUSG00000033705', u'ENSMUSG00000010021', u'ENSMUSG00000024795', u'ENSMUSG00000018395', u'ENSMUSG00000022629', u'ENSMUSG00000028438', u'ENSMUSG00000052861', u'ENSMUSG00000030677', u'ENSMUSG00000020821', u'ENSMUSG00000074657', u'ENSMUSG00000003779', u'ENSMUSG00000028678', u'ENSMUSG00000022262', u'ENSMUSG00000034706', u'ENSMUSG00000035770', u'ENSMUSG00000038844', u'ENSMUSG00000041498', u'ENSMUSG00000038011', u'ENSMUSG00000021288', u'ENSMUSG00000027115', u'ENSMUSG00000031788', u'ENSMUSG00000033826', u'ENSMUSG00000026764', u'ENSMUSG00000079553', u'ENSMUSG00000021693', u'ENSMUSG00000060176', u'ENSMUSG00000045328', u'ENSMUSG00000021375', u'ENSMUSG00000060012', u'ENSMUSG00000028758', u'ENSMUSG00000051378', u'ENSMUSG00000036768', u'ENSMUSG00000024862', u'ENSMUSG00000004187', u'ENSMUSG00000052273', u'ENSMUSG00000021879', u'ENSMUSG00000040714', u'ENSMUSG00000025235', u'ENSMUSG00000032254', u'ENSMUSG00000018707', u'ENSMUSG00000034311', u'ENSMUSG00000047193', u'ENSMUSG00000041642', u'ENSMUSG00000005237', u'ENSMUSG00000023999', u'ENSMUSG00000014602', u'ENSMUSG00000024301', u'ENSMUSG00000027475', u'ENSMUSG00000012443', u'ENSMUSG00000006740', u'ENSMUSG00000020668', u'ENSMUSG00000050382']), study_n=624, level=8, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003779', NS='MF', enrichment='p', name='actin binding', ratio_in_study=(5, 624), ratio_in_pop=(275, 13836), p_uncorrected=0.026535656881473517, depth=4, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000022021', u'ENSMUSG00000027115', u'ENSMUSG00000047945', u'ENSMUSG00000028337', u'ENSMUSG00000074802']), pop_n=13836, pop_count=275, pop_items=set([u'ENSMUSG00000022836', u'ENSMUSG00000074802', u'ENSMUSG00000018965', u'ENSMUSG00000022831', u'ENSMUSG00000055322', u'ENSMUSG00000039754', u'ENSMUSG00000021262', u'ENSMUSG00000051586', u'ENSMUSG00000030447', u'ENSMUSG00000004665', u'ENSMUSG00000022565', u'ENSMUSG00000002812', u'ENSMUSG00000066151', u'ENSMUSG00000029106', u'ENSMUSG00000039952', u'ENSMUSG00000043079', u'ENSMUSG00000033088', u'ENSMUSG00000026418', u'ENSMUSG00000053931', u'ENSMUSG00000039959', u'ENSMUSG00000031934', u'ENSMUSG00000032220', u'ENSMUSG00000068699', u'ENSMUSG00000050315', u'ENSMUSG00000030761', u'ENSMUSG00000021061', u'ENSMUSG00000025504', u'ENSMUSG00000058587', u'ENSMUSG00000021823', u'ENSMUSG00000011751', u'ENSMUSG00000062014', u'ENSMUSG00000063142', u'ENSMUSG00000026705', u'ENSMUSG00000054808', u'ENSMUSG00000027940', u'ENSMUSG00000028337', u'ENSMUSG00000001964', u'ENSMUSG00000020908', u'ENSMUSG00000021690', u'ENSMUSG00000038244', u'ENSMUSG00000024044', u'ENSMUSG00000041263', u'ENSMUSG00000075705', u'ENSMUSG00000068270', u'ENSMUSG00000022099', u'ENSMUSG00000004677', u'ENSMUSG00000010154', u'ENSMUSG00000039585', u'ENSMUSG00000052698', u'ENSMUSG00000027115', u'ENSMUSG00000026303', u'ENSMUSG00000041308', u'ENSMUSG00000028745', u'ENSMUSG00000015733', u'ENSMUSG00000023277', u'ENSMUSG00000021057', u'ENSMUSG00000074652', u'ENSMUSG00000025429', u'ENSMUSG00000029094', u'ENSMUSG00000041773', u'ENSMUSG00000057738', u'ENSMUSG00000015222', u'ENSMUSG00000029095', u'ENSMUSG00000020439', u'ENSMUSG00000023094', u'ENSMUSG00000042292', u'ENSMUSG00000074272', u'ENSMUSG00000036777', u'ENSMUSG00000006304', u'ENSMUSG00000031165', u'ENSMUSG00000028328', u'ENSMUSG00000063450', u'ENSMUSG00000079426', u'ENSMUSG00000031161', u'ENSMUSG00000045103', u'ENSMUSG00000020437', u'ENSMUSG00000028649', u'ENSMUSG00000025885', u'ENSMUSG00000022788', u'ENSMUSG00000029636', u'ENSMUSG00000022623', u'ENSMUSG00000027488', u'ENSMUSG00000027007', u'ENSMUSG00000038013', u'ENSMUSG00000018293', u'ENSMUSG00000019820', u'ENSMUSG00000031328', u'ENSMUSG00000045795', u'ENSMUSG00000049775', u'ENSMUSG00000035441', u'ENSMUSG00000014158', u'ENSMUSG00000027254', u'ENSMUSG00000015143', u'ENSMUSG00000027525', u'ENSMUSG00000009687', u'ENSMUSG00000070372', u'ENSMUSG00000039057', u'ENSMUSG00000034154', u'ENSMUSG00000024101', u'ENSMUSG00000079562', u'ENSMUSG00000030707', u'ENSMUSG00000072115', u'ENSMUSG00000049493', u'ENSMUSG00000026830', u'ENSMUSG00000029621', u'ENSMUSG00000060429', u'ENSMUSG00000034295', u'ENSMUSG00000022439', u'ENSMUSG00000022438', u'ENSMUSG00000008475', u'ENSMUSG00000025026', u'ENSMUSG00000020527', u'ENSMUSG00000019823', u'ENSMUSG00000028464', u'ENSMUSG00000028465', u'ENSMUSG00000027805', u'ENSMUSG00000045180', u'ENSMUSG00000028656', u'ENSMUSG00000030770', u'ENSMUSG00000023008', u'ENSMUSG00000019831', u'ENSMUSG00000041710', u'ENSMUSG00000026131', u'ENSMUSG00000032366', u'ENSMUSG00000029381', u'ENSMUSG00000015932', u'ENSMUSG00000052374', u'ENSMUSG00000014164', u'ENSMUSG00000086040', u'ENSMUSG00000024456', u'ENSMUSG00000034216', u'ENSMUSG00000051359', u'ENSMUSG00000037196', u'ENSMUSG00000022021', u'ENSMUSG00000036273', u'ENSMUSG00000009569', u'ENSMUSG00000079227', u'ENSMUSG00000038775', u'ENSMUSG00000031799', u'ENSMUSG00000031827', u'ENSMUSG00000053093', u'ENSMUSG00000037736', u'ENSMUSG00000032740', u'ENSMUSG00000047945', u'ENSMUSG00000032186', u'ENSMUSG00000070462', u'ENSMUSG00000033763', u'ENSMUSG00000062929', u'ENSMUSG00000028785', u'ENSMUSG00000024835', u'ENSMUSG00000021998', u'ENSMUSG00000028572', u'ENSMUSG00000034593', u'ENSMUSG00000009073', u'ENSMUSG00000022443', u'ENSMUSG00000030403', u'ENSMUSG00000029622', u'ENSMUSG00000028868', u'ENSMUSG00000015804', u'ENSMUSG00000041729', u'ENSMUSG00000024533', u'ENSMUSG00000027624', u'ENSMUSG00000034616', u'ENSMUSG00000001864', u'ENSMUSG00000054728', u'ENSMUSG00000034595', u'ENSMUSG00000033577', u'ENSMUSG00000024236', u'ENSMUSG00000042121', u'ENSMUSG00000024423', u'ENSMUSG00000015766', u'ENSMUSG00000028978', u'ENSMUSG00000066043', u'ENSMUSG00000037679', u'ENSMUSG00000020152', u'ENSMUSG00000019433', u'ENSMUSG00000025813', u'ENSMUSG00000069662', u'ENSMUSG00000052397', u'ENSMUSG00000029761', u'ENSMUSG00000034480', u'ENSMUSG00000066952', u'ENSMUSG00000025809', u'ENSMUSG00000038365', u'ENSMUSG00000038366', u'ENSMUSG00000031605', u'ENSMUSG00000004530', u'ENSMUSG00000028273', u'ENSMUSG00000042064', u'ENSMUSG00000018387', u'ENSMUSG00000030000', u'ENSMUSG00000022451', u'ENSMUSG00000021097', u'ENSMUSG00000022353', u'ENSMUSG00000022602', u'ENSMUSG00000053702', u'ENSMUSG00000022607', u'ENSMUSG00000056737', u'ENSMUSG00000020900', u'ENSMUSG00000032517', u'ENSMUSG00000028906', u'ENSMUSG00000026341', u'ENSMUSG00000005417', u'ENSMUSG00000001630', u'ENSMUSG00000032064', u'ENSMUSG00000018830', u'ENSMUSG00000031997', u'ENSMUSG00000023022', u'ENSMUSG00000055805', u'ENSMUSG00000026755', u'ENSMUSG00000017774', u'ENSMUSG00000037926', u'ENSMUSG00000041794', u'ENSMUSG00000020173', u'ENSMUSG00000040260', u'ENSMUSG00000006021', u'ENSMUSG00000039630', u'ENSMUSG00000031207', u'ENSMUSG00000058056', u'ENSMUSG00000039637', u'ENSMUSG00000024397', u'ENSMUSG00000038976', u'ENSMUSG00000020476', u'ENSMUSG00000023826', u'ENSMUSG00000045382', u'ENSMUSG00000036053', u'ENSMUSG00000016382', u'ENSMUSG00000029684', u'ENSMUSG00000035873', u'ENSMUSG00000056367', u'ENSMUSG00000040852', u'ENSMUSG00000018417', u'ENSMUSG00000027411', u'ENSMUSG00000034574', u'ENSMUSG00000000127', u'ENSMUSG00000022995', u'ENSMUSG00000034675', u'ENSMUSG00000075284', u'ENSMUSG00000025085', u'ENSMUSG00000032050', u'ENSMUSG00000020672', u'ENSMUSG00000006154', u'ENSMUSG00000000915', u'ENSMUSG00000055775', u'ENSMUSG00000029465', u'ENSMUSG00000044042', u'ENSMUSG00000056201', u'ENSMUSG00000028696', u'ENSMUSG00000030340', u'ENSMUSG00000031590', u'ENSMUSG00000031214', u'ENSMUSG00000028354', u'ENSMUSG00000021373', u'ENSMUSG00000020681', u'ENSMUSG00000029060', u'ENSMUSG00000029581', u'ENSMUSG00000040860', u'ENSMUSG00000026879', u'ENSMUSG00000068206', u'ENSMUSG00000033885', u'ENSMUSG00000019978', u'ENSMUSG00000030739', u'ENSMUSG00000005103', u'ENSMUSG00000027365', u'ENSMUSG00000022272', u'ENSMUSG00000025278', u'ENSMUSG00000014778', u'ENSMUSG00000025909', u'ENSMUSG00000032322', u'ENSMUSG00000024300', u'ENSMUSG00000020315', u'ENSMUSG00000032735', u'ENSMUSG00000018819', u'ENSMUSG00000032737', u'ENSMUSG00000052727']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003810', NS='MF', enrichment='e', name='protein-glutamine gamma-glutamyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000022218']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000039109', u'ENSMUSG00000022218', u'ENSMUSG00000037820']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003823', NS='MF', enrichment='e', name='antigen binding', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=2, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000036822']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000027009', u'ENSMUSG00000002603', u'ENSMUSG00000015355', u'ENSMUSG00000025511', u'ENSMUSG00000055024', u'ENSMUSG00000076617', u'ENSMUSG00000036822']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003824', NS='MF', enrichment='p', name='catalytic activity', ratio_in_study=(17, 624), ratio_in_pop=(378, 13836), p_uncorrected=1.0, depth=1, study_count=17, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000015027', u'ENSMUSG00000010651', u'ENSMUSG00000039748', u'ENSMUSG00000029201', u'ENSMUSG00000030528', u'ENSMUSG00000036086', u'ENSMUSG00000022814', u'ENSMUSG00000020641', u'ENSMUSG00000004099', u'ENSMUSG00000011179', u'ENSMUSG00000036875', u'ENSMUSG00000021036', u'ENSMUSG00000030978', u'ENSMUSG00000020525', u'ENSMUSG00000020534', u'ENSMUSG00000024742', u'ENSMUSG00000051235']), pop_n=13836, pop_count=378, pop_items=set([u'ENSMUSG00000046598', u'ENSMUSG00000023921', u'ENSMUSG00000005615', u'ENSMUSG00000031583', u'ENSMUSG00000039616', u'ENSMUSG00000031266', u'ENSMUSG00000027709', u'ENSMUSG00000031516', u'ENSMUSG00000031901', u'ENSMUSG00000038582', u'ENSMUSG00000052738', u'ENSMUSG00000015027', u'ENSMUSG00000028334', u'ENSMUSG00000006442', u'ENSMUSG00000055137', u'ENSMUSG00000053510', u'ENSMUSG00000036138', u'ENSMUSG00000019850', u'ENSMUSG00000062031', u'ENSMUSG00000064120', u'ENSMUSG00000070880', u'ENSMUSG00000022781', u'ENSMUSG00000020532', u'ENSMUSG00000020534', u'ENSMUSG00000022620', u'ENSMUSG00000026335', u'ENSMUSG00000021884', u'ENSMUSG00000061130', u'ENSMUSG00000001270', u'ENSMUSG00000026839', u'ENSMUSG00000051855', u'ENSMUSG00000039308', u'ENSMUSG00000022546', u'ENSMUSG00000014164', u'ENSMUSG00000000628', u'ENSMUSG00000041650', u'ENSMUSG00000021033', u'ENSMUSG00000020715', u'ENSMUSG00000026615', u'ENSMUSG00000048899', u'ENSMUSG00000056536', u'ENSMUSG00000028479', u'ENSMUSG00000023960', u'ENSMUSG00000023961', u'ENSMUSG00000025155', u'ENSMUSG00000028470', u'ENSMUSG00000025153', u'ENSMUSG00000055214', u'ENSMUSG00000025651', u'ENSMUSG00000042642', u'ENSMUSG00000020917', u'ENSMUSG00000059447', u'ENSMUSG00000042082', u'ENSMUSG00000030884', u'ENSMUSG00000064294', u'ENSMUSG00000030088', u'ENSMUSG00000024120', u'ENSMUSG00000030246', u'ENSMUSG00000028274', u'ENSMUSG00000030978', u'ENSMUSG00000026181', u'ENSMUSG00000018796', u'ENSMUSG00000016179', u'ENSMUSG00000042010', u'ENSMUSG00000030774', u'ENSMUSG00000023026', u'ENSMUSG00000011179', u'ENSMUSG00000037826', u'ENSMUSG00000025877', u'ENSMUSG00000020000', u'ENSMUSG00000052920', u'ENSMUSG00000031613', u'ENSMUSG00000031758', u'ENSMUSG00000029009', u'ENSMUSG00000026473', u'ENSMUSG00000032281', u'ENSMUSG00000020256', u'ENSMUSG00000020253', u'ENSMUSG00000029482', u'ENSMUSG00000003363', u'ENSMUSG00000057880', u'ENSMUSG00000024785', u'ENSMUSG00000029173', u'ENSMUSG00000020097', u'ENSMUSG00000025270', u'ENSMUSG00000025579', u'ENSMUSG00000025277', u'ENSMUSG00000027784', u'ENSMUSG00000029695', u'ENSMUSG00000039145', u'ENSMUSG00000022407', u'ENSMUSG00000009585', u'ENSMUSG00000016918', u'ENSMUSG00000022471', u'ENSMUSG00000043262', u'ENSMUSG00000046561', u'ENSMUSG00000021069', u'ENSMUSG00000020892', u'ENSMUSG00000027371', u'ENSMUSG00000003865', u'ENSMUSG00000039748', u'ENSMUSG00000059316', u'ENSMUSG00000020182', u'ENSMUSG00000028032', u'ENSMUSG00000038886', u'ENSMUSG00000040649', u'ENSMUSG00000025190', u'ENSMUSG00000026787', u'ENSMUSG00000035948', u'ENSMUSG00000027875', u'ENSMUSG00000043943', u'ENSMUSG00000030276', u'ENSMUSG00000030272', u'ENSMUSG00000030271', u'ENSMUSG00000031808', u'ENSMUSG00000045316', u'ENSMUSG00000003500', u'ENSMUSG00000020359', u'ENSMUSG00000019883', u'ENSMUSG00000002963', u'ENSMUSG00000033373', u'ENSMUSG00000020525', u'ENSMUSG00000021982', u'ENSMUSG00000029147', u'ENSMUSG00000041774', u'ENSMUSG00000033308', u'ENSMUSG00000017264', u'ENSMUSG00000021871', u'ENSMUSG00000022707', u'ENSMUSG00000040532', u'ENSMUSG00000025533', u'ENSMUSG00000025532', u'ENSMUSG00000034055', u'ENSMUSG00000071650', u'ENSMUSG00000026926', u'ENSMUSG00000000339', u'ENSMUSG00000029247', u'ENSMUSG00000025545', u'ENSMUSG00000028789', u'ENSMUSG00000032883', u'ENSMUSG00000021592', u'ENSMUSG00000025899', u'ENSMUSG00000034613', u'ENSMUSG00000007603', u'ENSMUSG00000024981', u'ENSMUSG00000022570', u'ENSMUSG00000035370', u'ENSMUSG00000040213', u'ENSMUSG00000026664', u'ENSMUSG00000076435', u'ENSMUSG00000033595', u'ENSMUSG00000024800', u'ENSMUSG00000025007', u'ENSMUSG00000025648', u'ENSMUSG00000034371', u'ENSMUSG00000030718', u'ENSMUSG00000033059', u'ENSMUSG00000022031', u'ENSMUSG00000027618', u'ENSMUSG00000035473', u'ENSMUSG00000037458', u'ENSMUSG00000021096', u'ENSMUSG00000017390', u'ENSMUSG00000009394', u'ENSMUSG00000010051', u'ENSMUSG00000038975', u'ENSMUSG00000063558', u'ENSMUSG00000073481', u'ENSMUSG00000062867', u'ENSMUSG00000030826', u'ENSMUSG00000056999', u'ENSMUSG00000032350', u'ENSMUSG00000022110', u'ENSMUSG00000027359', u'ENSMUSG00000007908', u'ENSMUSG00000024066', u'ENSMUSG00000048755', u'ENSMUSG00000030225', u'ENSMUSG00000024068', u'ENSMUSG00000021273', u'ENSMUSG00000074576', u'ENSMUSG00000037012', u'ENSMUSG00000023044', u'ENSMUSG00000039096', u'ENSMUSG00000002326', u'ENSMUSG00000031284', u'ENSMUSG00000017715', u'ENSMUSG00000021786', u'ENSMUSG00000033805', u'ENSMUSG00000063849', u'ENSMUSG00000029199', u'ENSMUSG00000063730', u'ENSMUSG00000013833', u'ENSMUSG00000020267', u'ENSMUSG00000029201', u'ENSMUSG00000022562', u'ENSMUSG00000047454', u'ENSMUSG00000025465', u'ENSMUSG00000022244', u'ENSMUSG00000025503', u'ENSMUSG00000026701', u'ENSMUSG00000028672', u'ENSMUSG00000022414', u'ENSMUSG00000023832', u'ENSMUSG00000033065', u'ENSMUSG00000006800', u'ENSMUSG00000010651', u'ENSMUSG00000001773', u'ENSMUSG00000042751', u'ENSMUSG00000036875', u'ENSMUSG00000036879', u'ENSMUSG00000032763', u'ENSMUSG00000062937', u'ENSMUSG00000028411', u'ENSMUSG00000031562', u'ENSMUSG00000025137', u'ENSMUSG00000035847', u'ENSMUSG00000021460', u'ENSMUSG00000020287', u'ENSMUSG00000025041', u'ENSMUSG00000032648', u'ENSMUSG00000036880', u'ENSMUSG00000074264', u'ENSMUSG00000030268', u'ENSMUSG00000064325', u'ENSMUSG00000059602', u'ENSMUSG00000021468', u'ENSMUSG00000006378', u'ENSMUSG00000016757', u'ENSMUSG00000031700', u'ENSMUSG00000000308', u'ENSMUSG00000026526', u'ENSMUSG00000020641', u'ENSMUSG00000021748', u'ENSMUSG00000020648', u'ENSMUSG00000038776', u'ENSMUSG00000020124', u'ENSMUSG00000031387', u'ENSMUSG00000019232', u'ENSMUSG00000062646', u'ENSMUSG00000036086', u'ENSMUSG00000019808', u'ENSMUSG00000044340', u'ENSMUSG00000032263', u'ENSMUSG00000059288', u'ENSMUSG00000024742', u'ENSMUSG00000020231', u'ENSMUSG00000027695', u'ENSMUSG00000035246', u'ENSMUSG00000029376', u'ENSMUSG00000022453', u'ENSMUSG00000024085', u'ENSMUSG00000001323', u'ENSMUSG00000022962', u'ENSMUSG00000007950', u'ENSMUSG00000027452', u'ENSMUSG00000020333', u'ENSMUSG00000019791', u'ENSMUSG00000030036', u'ENSMUSG00000023868', u'ENSMUSG00000028179', u'ENSMUSG00000024556', u'ENSMUSG00000024258', u'ENSMUSG00000069516', u'ENSMUSG00000027605', u'ENSMUSG00000013629', u'ENSMUSG00000040613', u'ENSMUSG00000061838', u'ENSMUSG00000046442', u'ENSMUSG00000021036', u'ENSMUSG00000031985', u'ENSMUSG00000028454', u'ENSMUSG00000023456', u'ENSMUSG00000032047', u'ENSMUSG00000020604', u'ENSMUSG00000027971', u'ENSMUSG00000027977', u'ENSMUSG00000021260', u'ENSMUSG00000031672', u'ENSMUSG00000032786', u'ENSMUSG00000004383', u'ENSMUSG00000031295', u'ENSMUSG00000026005', u'ENSMUSG00000038028', u'ENSMUSG00000011752', u'ENSMUSG00000021417', u'ENSMUSG00000024172', u'ENSMUSG00000086784', u'ENSMUSG00000073609', u'ENSMUSG00000020277', u'ENSMUSG00000031278', u'ENSMUSG00000021196', u'ENSMUSG00000021193', u'ENSMUSG00000026307', u'ENSMUSG00000026309', u'ENSMUSG00000029119', u'ENSMUSG00000021957', u'ENSMUSG00000002428', u'ENSMUSG00000075270', u'ENSMUSG00000054008', u'ENSMUSG00000056310', u'ENSMUSG00000020828', u'ENSMUSG00000052160', u'ENSMUSG00000006191', u'ENSMUSG00000022425', u'ENSMUSG00000024477', u'ENSMUSG00000036412', u'ENSMUSG00000022223', u'ENSMUSG00000010095', u'ENSMUSG00000027487', u'ENSMUSG00000024601', u'ENSMUSG00000022853', u'ENSMUSG00000021048', u'ENSMUSG00000039648', u'ENSMUSG00000004099', u'ENSMUSG00000024827', u'ENSMUSG00000028467', u'ENSMUSG00000005667', u'ENSMUSG00000037370', u'ENSMUSG00000028393', u'ENSMUSG00000041718', u'ENSMUSG00000027639', u'ENSMUSG00000028085', u'ENSMUSG00000031958', u'ENSMUSG00000005142', u'ENSMUSG00000052605', u'ENSMUSG00000028309', u'ENSMUSG00000015016', u'ENSMUSG00000024132', u'ENSMUSG00000028307', u'ENSMUSG00000027932', u'ENSMUSG00000026192', u'ENSMUSG00000030528', u'ENSMUSG00000053965', u'ENSMUSG00000026698', u'ENSMUSG00000040820', u'ENSMUSG00000042410', u'ENSMUSG00000000253', u'ENSMUSG00000063229', u'ENSMUSG00000026048', u'ENSMUSG00000053898', u'ENSMUSG00000030322', u'ENSMUSG00000055923', u'ENSMUSG00000051235', u'ENSMUSG00000031730', u'ENSMUSG00000031732', u'ENSMUSG00000022040', u'ENSMUSG00000029017', u'ENSMUSG00000032298', u'ENSMUSG00000022680', u'ENSMUSG00000032294', u'ENSMUSG00000032295', u'ENSMUSG00000020475', u'ENSMUSG00000028766', u'ENSMUSG00000034160', u'ENSMUSG00000043153', u'ENSMUSG00000079110', u'ENSMUSG00000030934', u'ENSMUSG00000024640', u'ENSMUSG00000020321', u'ENSMUSG00000022814', u'ENSMUSG00000038173', u'ENSMUSG00000049225', u'ENSMUSG00000040272', u'ENSMUSG00000019179', u'ENSMUSG00000028980', u'ENSMUSG00000042684', u'ENSMUSG00000010047', u'ENSMUSG00000001755', u'ENSMUSG00000028603', u'ENSMUSG00000030630', u'ENSMUSG00000028601', u'ENSMUSG00000034707', u'ENSMUSG00000024892', u'ENSMUSG00000025745', u'ENSMUSG00000027360', u'ENSMUSG00000038871', u'ENSMUSG00000024899']), study_n=624, level=1, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003883', NS='MF', enrichment='e', name='CTP synthase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028633']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000028633', u'ENSMUSG00000031360']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003886', NS='MF', enrichment='e', name='DNA (cytosine-5-)-methyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000004099']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000004099', u'ENSMUSG00000020661']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0008326'])),
    NtGoeaResults(GO='GO:0003887', NS='MF', enrichment='e', name='DNA-directed DNA polymerase activity', ratio_in_study=(10, 624), ratio_in_pop=(24, 13836), p_uncorrected=3.58209532492208e-08, depth=6, study_count=10, p_sm_bonferroni=0.00056260389173226188, p_fdr_bh=8.3970730109292804e-06, study_items=set([u'ENSMUSG00000030042', u'ENSMUSG00000045102', u'ENSMUSG00000026134', u'ENSMUSG00000021668', u'ENSMUSG00000034206', u'ENSMUSG00000024833', u'ENSMUSG00000020471', u'ENSMUSG00000007080', u'ENSMUSG00000023953', u'ENSMUSG00000038644']), pop_n=13836, pop_count=24, pop_items=set([u'ENSMUSG00000020718', u'ENSMUSG00000021668', u'ENSMUSG00000020474', u'ENSMUSG00000024833', u'ENSMUSG00000020471', u'ENSMUSG00000036779', u'ENSMUSG00000038425', u'ENSMUSG00000007080', u'ENSMUSG00000031536', u'ENSMUSG00000030042', u'ENSMUSG00000034206', u'ENSMUSG00000006678', u'ENSMUSG00000019841', u'ENSMUSG00000038644', u'ENSMUSG00000039176', u'ENSMUSG00000028394', u'ENSMUSG00000023953', u'ENSMUSG00000025218', u'ENSMUSG00000024854', u'ENSMUSG00000068391', u'ENSMUSG00000045102', u'ENSMUSG00000026134', u'ENSMUSG00000040463', u'ENSMUSG00000038225']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0016449', 'GO:0016000', 'GO:0008723', 'GO:0019984', 'GO:0015999', 'GO:0003890', 'GO:0003891', 'GO:0003893', 'GO:0003894', 'GO:0003895', 'GO:0016448', 'GO:0016452', 'GO:0016450', 'GO:0016451', 'GO:0003889', 'GO:0003888'])),
    NtGoeaResults(GO='GO:0003896', NS='MF', enrichment='e', name='DNA primase activity', ratio_in_study=(2, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.005909998133444449, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.22584533013109129, study_items=set([u'ENSMUSG00000025395', u'ENSMUSG00000026134']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000025395', u'ENSMUSG00000038225', u'ENSMUSG00000026134']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0003898', 'GO:0003897'])),
    NtGoeaResults(GO='GO:0003899', NS='MF', enrichment='e', name="DNA-directed 5'-3' RNA polymerase activity", ratio_in_study=(2, 624), ratio_in_pop=(36, 13836), p_uncorrected=0.6769845004731256, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025395', u'ENSMUSG00000026134']), pop_n=13836, pop_count=36, pop_items=set([u'ENSMUSG00000027427', u'ENSMUSG00000005198', u'ENSMUSG00000039771', u'ENSMUSG00000034453', u'ENSMUSG00000004667', u'ENSMUSG00000028104', u'ENSMUSG00000022476', u'ENSMUSG00000028099', u'ENSMUSG00000029642', u'ENSMUSG00000049553', u'ENSMUSG00000024258', u'ENSMUSG00000035834', u'ENSMUSG00000036315', u'ENSMUSG00000020329', u'ENSMUSG00000067148', u'ENSMUSG00000038489', u'ENSMUSG00000038628', u'ENSMUSG00000031783', u'ENSMUSG00000030880', u'ENSMUSG00000019738', u'ENSMUSG00000033020', u'ENSMUSG00000021018', u'ENSMUSG00000034032', u'ENSMUSG00000028318', u'ENSMUSG00000025280', u'ENSMUSG00000029250', u'ENSMUSG00000027395', u'ENSMUSG00000032199', u'ENSMUSG00000000776', u'ENSMUSG00000071662', u'ENSMUSG00000045996', u'ENSMUSG00000020561', u'ENSMUSG00000026134', u'ENSMUSG00000025395', u'ENSMUSG00000038225', u'ENSMUSG00000025532']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0000129'])),
    NtGoeaResults(GO='GO:0003909', NS='MF', enrichment='e', name='DNA ligase activity', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000056394']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000020697', u'ENSMUSG00000056394', u'ENSMUSG00000049717']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003910', NS='MF', enrichment='e', name='DNA ligase (ATP) activity', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000056394']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000026496', u'ENSMUSG00000049717', u'ENSMUSG00000020697', u'ENSMUSG00000036023', u'ENSMUSG00000023249', u'ENSMUSG00000056394']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003916', NS='MF', enrichment='e', name='DNA topoisomerase activity', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020914']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000070544', u'ENSMUSG00000000934', u'ENSMUSG00000020914', u'ENSMUSG00000017485', u'ENSMUSG00000022779', u'ENSMUSG00000002814']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0009387'])),
    NtGoeaResults(GO='GO:0003918', NS='MF', enrichment='e', name='DNA topoisomerase type II (ATP-hydrolyzing) activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=10, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020914']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000020914', u'ENSMUSG00000017485']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003924', NS='MF', enrichment='p', name='GTPase activity', ratio_in_study=(8, 624), ratio_in_pop=(226, 13836), p_uncorrected=0.6264109834079653, depth=7, study_count=8, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000068606', u'ENSMUSG00000045136', u'ENSMUSG00000046879', u'ENSMUSG00000078853', u'ENSMUSG00000078921', u'ENSMUSG00000054072', u'ENSMUSG00000019845', u'ENSMUSG00000000386']), pop_n=13836, pop_count=226, pop_items=set([u'ENSMUSG00000057614', u'ENSMUSG00000021666', u'ENSMUSG00000034226', u'ENSMUSG00000029518', u'ENSMUSG00000047187', u'ENSMUSG00000028270', u'ENSMUSG00000049892', u'ENSMUSG00000021712', u'ENSMUSG00000031104', u'ENSMUSG00000020929', u'ENSMUSG00000036430', u'ENSMUSG00000059811', u'ENSMUSG00000020513', u'ENSMUSG00000020459', u'ENSMUSG00000029204', u'ENSMUSG00000029208', u'ENSMUSG00000024870', u'ENSMUSG00000043463', u'ENSMUSG00000033335', u'ENSMUSG00000073838', u'ENSMUSG00000040009', u'ENSMUSG00000027669', u'ENSMUSG00000027668', u'ENSMUSG00000053291', u'ENSMUSG00000032549', u'ENSMUSG00000022176', u'ENSMUSG00000035133', u'ENSMUSG00000021062', u'ENSMUSG00000022075', u'ENSMUSG00000017144', u'ENSMUSG00000043670', u'ENSMUSG00000019478', u'ENSMUSG00000020611', u'ENSMUSG00000019845', u'ENSMUSG00000073079', u'ENSMUSG00000045136', u'ENSMUSG00000055723', u'ENSMUSG00000068922', u'ENSMUSG00000016637', u'ENSMUSG00000027523', u'ENSMUSG00000062591', u'ENSMUSG00000029449', u'ENSMUSG00000030055', u'ENSMUSG00000042354', u'ENSMUSG00000008859', u'ENSMUSG00000047446', u'ENSMUSG00000054364', u'ENSMUSG00000078921', u'ENSMUSG00000079477', u'ENSMUSG00000001473', u'ENSMUSG00000035198', u'ENSMUSG00000026825', u'ENSMUSG00000029430', u'ENSMUSG00000038335', u'ENSMUSG00000000711', u'ENSMUSG00000064037', u'ENSMUSG00000052688', u'ENSMUSG00000068798', u'ENSMUSG00000038563', u'ENSMUSG00000025035', u'ENSMUSG00000022789', u'ENSMUSG00000052681', u'ENSMUSG00000006699', u'ENSMUSG00000022621', u'ENSMUSG00000029128', u'ENSMUSG00000025730', u'ENSMUSG00000001847', u'ENSMUSG00000024511', u'ENSMUSG00000022159', u'ENSMUSG00000032562', u'ENSMUSG00000000001', u'ENSMUSG00000026433', u'ENSMUSG00000042535', u'ENSMUSG00000020132', u'ENSMUSG00000004771', u'ENSMUSG00000021772', u'ENSMUSG00000017686', u'ENSMUSG00000023460', u'ENSMUSG00000034994', u'ENSMUSG00000045007', u'ENSMUSG00000071723', u'ENSMUSG00000030265', u'ENSMUSG00000062203', u'ENSMUSG00000058672', u'ENSMUSG00000071658', u'ENSMUSG00000022538', u'ENSMUSG00000049907', u'ENSMUSG00000070934', u'ENSMUSG00000069893', u'ENSMUSG00000032470', u'ENSMUSG00000016349', u'ENSMUSG00000078853', u'ENSMUSG00000028945', u'ENSMUSG00000023004', u'ENSMUSG00000000787', u'ENSMUSG00000021589', u'ENSMUSG00000050029', u'ENSMUSG00000041658', u'ENSMUSG00000024759', u'ENSMUSG00000020486', u'ENSMUSG00000034792', u'ENSMUSG00000079657', u'ENSMUSG00000010086', u'ENSMUSG00000004768', u'ENSMUSG00000072235', u'ENSMUSG00000007815', u'ENSMUSG00000027739', u'ENSMUSG00000000386', u'ENSMUSG00000039069', u'ENSMUSG00000002059', u'ENSMUSG00000046768', u'ENSMUSG00000040264', u'ENSMUSG00000021303', u'ENSMUSG00000078922', u'ENSMUSG00000078920', u'ENSMUSG00000040265', u'ENSMUSG00000029713', u'ENSMUSG00000003037', u'ENSMUSG00000031748', u'ENSMUSG00000028268', u'ENSMUSG00000035150', u'ENSMUSG00000073639', u'ENSMUSG00000030138', u'ENSMUSG00000030704', u'ENSMUSG00000028869', u'ENSMUSG00000029020', u'ENSMUSG00000036273', u'ENSMUSG00000036894', u'ENSMUSG00000001313', u'ENSMUSG00000058163', u'ENSMUSG00000029064', u'ENSMUSG00000051615', u'ENSMUSG00000011148', u'ENSMUSG00000020657', u'ENSMUSG00000025422', u'ENSMUSG00000026202', u'ENSMUSG00000021149', u'ENSMUSG00000079316', u'ENSMUSG00000034209', u'ENSMUSG00000001525', u'ENSMUSG00000017837', u'ENSMUSG00000077450', u'ENSMUSG00000068606', u'ENSMUSG00000000149', u'ENSMUSG00000017831', u'ENSMUSG00000027519', u'ENSMUSG00000021066', u'ENSMUSG00000046879', u'ENSMUSG00000073982', u'ENSMUSG00000025266', u'ENSMUSG00000057455', u'ENSMUSG00000056515', u'ENSMUSG00000028278', u'ENSMUSG00000025499', u'ENSMUSG00000090942', u'ENSMUSG00000041696', u'ENSMUSG00000024524', u'ENSMUSG00000054072', u'ENSMUSG00000034472', u'ENSMUSG00000020149', u'ENSMUSG00000060904', u'ENSMUSG00000024639', u'ENSMUSG00000024429', u'ENSMUSG00000047842', u'ENSMUSG00000028646', u'ENSMUSG00000019832', u'ENSMUSG00000054855', u'ENSMUSG00000020175', u'ENSMUSG00000019066', u'ENSMUSG00000062380', u'ENSMUSG00000030137', u'ENSMUSG00000038084', u'ENSMUSG00000055013', u'ENSMUSG00000031202', u'ENSMUSG00000034781', u'ENSMUSG00000023755', u'ENSMUSG00000036752', u'ENSMUSG00000034789', u'ENSMUSG00000037022', u'ENSMUSG00000039960', u'ENSMUSG00000018012', u'ENSMUSG00000073555', u'ENSMUSG00000030643', u'ENSMUSG00000043091', u'ENSMUSG00000032202', u'ENSMUSG00000028848', u'ENSMUSG00000039018', u'ENSMUSG00000007610', u'ENSMUSG00000019944', u'ENSMUSG00000036943', u'ENSMUSG00000038671', u'ENSMUSG00000002233', u'ENSMUSG00000031840', u'ENSMUSG00000020671', u'ENSMUSG00000069874', u'ENSMUSG00000036285', u'ENSMUSG00000030220', u'ENSMUSG00000030222', u'ENSMUSG00000028214', u'ENSMUSG00000019173', u'ENSMUSG00000021700', u'ENSMUSG00000029464', u'ENSMUSG00000028057', u'ENSMUSG00000025733', u'ENSMUSG00000044147', u'ENSMUSG00000026083', u'ENSMUSG00000020684', u'ENSMUSG00000033216', u'ENSMUSG00000024944', u'ENSMUSG00000029641', u'ENSMUSG00000004451', u'ENSMUSG00000023952', u'ENSMUSG00000026878', u'ENSMUSG00000058230', u'ENSMUSG00000027852', u'ENSMUSG00000025170', u'ENSMUSG00000033220', u'ENSMUSG00000023353', u'ENSMUSG00000019977', u'ENSMUSG00000027774', u'ENSMUSG00000037742', u'ENSMUSG00000003411', u'ENSMUSG00000024143', u'ENSMUSG00000043004', u'ENSMUSG00000032042', u'ENSMUSG00000079108']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003950', NS='MF', enrichment='e', name='NAD+ ADP-ribosyltransferase activity', ratio_in_study=(3, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.03296855981999863, depth=5, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000022906', u'ENSMUSG00000038507', u'ENSMUSG00000034422']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000029524', u'ENSMUSG00000022906', u'ENSMUSG00000026496', u'ENSMUSG00000054509', u'ENSMUSG00000034422', u'ENSMUSG00000025237', u'ENSMUSG00000031529', u'ENSMUSG00000037997', u'ENSMUSG00000063268', u'ENSMUSG00000021725', u'ENSMUSG00000029826', u'ENSMUSG00000036023', u'ENSMUSG00000023249', u'ENSMUSG00000038507', u'ENSMUSG00000024811', u'ENSMUSG00000034640']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003979', NS='MF', enrichment='e', name='UDP-glucose 6-dehydrogenase activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000029201']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000029201']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0003988', NS='MF', enrichment='e', name='acetyl-CoA C-acyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000010651']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000010651', u'ENSMUSG00000028603', u'ENSMUSG00000059447', u'ENSMUSG00000025745', u'ENSMUSG00000036138', u'ENSMUSG00000036880']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004003', NS='MF', enrichment='e', name='ATP-dependent DNA helicase activity', ratio_in_study=(10, 624), ratio_in_pop=(23, 13836), p_uncorrected=2.1771093169576827e-08, depth=10, study_count=10, p_sm_bonferroni=0.00034193678932137366, p_fdr_bh=5.5151095051834462e-06, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000026355', u'ENSMUSG00000020380', u'ENSMUSG00000029730', u'ENSMUSG00000022673', u'ENSMUSG00000042699', u'ENSMUSG00000035842', u'ENSMUSG00000034329', u'ENSMUSG00000038685', u'ENSMUSG00000030528']), pop_n=13836, pop_count=23, pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000020380', u'ENSMUSG00000029730', u'ENSMUSG00000042699', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000030528', u'ENSMUSG00000031928', u'ENSMUSG00000022471', u'ENSMUSG00000026355', u'ENSMUSG00000030400', u'ENSMUSG00000020228', u'ENSMUSG00000058594', u'ENSMUSG00000034329', u'ENSMUSG00000001524', u'ENSMUSG00000030079', u'ENSMUSG00000003868', u'ENSMUSG00000024382', u'ENSMUSG00000022673', u'ENSMUSG00000026187', u'ENSMUSG00000028089', u'ENSMUSG00000000787', u'ENSMUSG00000031583']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004004', NS='MF', enrichment='e', name='ATP-dependent RNA helicase activity', ratio_in_study=(3, 624), ratio_in_pop=(58, 13836), p_uncorrected=0.7459975338709294, depth=10, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000035266', u'ENSMUSG00000005481', u'ENSMUSG00000042699']), pop_n=13836, pop_count=58, pop_items=set([u'ENSMUSG00000027770', u'ENSMUSG00000026806', u'ENSMUSG00000020719', u'ENSMUSG00000032480', u'ENSMUSG00000029599', u'ENSMUSG00000042699', u'ENSMUSG00000059796', u'ENSMUSG00000018425', u'ENSMUSG00000045538', u'ENSMUSG00000058301', u'ENSMUSG00000015023', u'ENSMUSG00000021494', u'ENSMUSG00000029480', u'ENSMUSG00000029504', u'ENSMUSG00000040356', u'ENSMUSG00000053289', u'ENSMUSG00000020228', u'ENSMUSG00000037993', u'ENSMUSG00000024422', u'ENSMUSG00000041645', u'ENSMUSG00000034653', u'ENSMUSG00000020677', u'ENSMUSG00000057788', u'ENSMUSG00000019432', u'ENSMUSG00000035266', u'ENSMUSG00000035051', u'ENSMUSG00000020705', u'ENSMUSG00000004393', u'ENSMUSG00000006019', u'ENSMUSG00000032101', u'ENSMUSG00000040620', u'ENSMUSG00000030204', u'ENSMUSG00000005481', u'ENSMUSG00000017999', u'ENSMUSG00000022884', u'ENSMUSG00000032097', u'ENSMUSG00000043410', u'ENSMUSG00000027905', u'ENSMUSG00000055065', u'ENSMUSG00000025580', u'ENSMUSG00000029389', u'ENSMUSG00000027655', u'ENSMUSG00000042426', u'ENSMUSG00000016018', u'ENSMUSG00000001674', u'ENSMUSG00000030986', u'ENSMUSG00000037149', u'ENSMUSG00000000787', u'ENSMUSG00000003660', u'ENSMUSG00000003360', u'ENSMUSG00000033658', u'ENSMUSG00000020079', u'ENSMUSG00000029169', u'ENSMUSG00000034931', u'ENSMUSG00000021500', u'ENSMUSG00000020075', u'ENSMUSG00000026404', u'ENSMUSG00000020076']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004017', NS='MF', enrichment='e', name='adenylate kinase activity', ratio_in_study=(1, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.3087700161198612, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020380']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000028527', u'ENSMUSG00000078941', u'ENSMUSG00000026817', u'ENSMUSG00000020380', u'ENSMUSG00000039058', u'ENSMUSG00000028792', u'ENSMUSG00000041323', u'ENSMUSG00000024782']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004146', NS='MF', enrichment='e', name='dihydrofolate reductase activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000021707']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000021707']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004180', NS='MF', enrichment='e', name='carboxypeptidase activity', ratio_in_study=(1, 624), ratio_in_pop=(19, 13836), p_uncorrected=0.5841387202644939, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020841']), pop_n=13836, pop_count=19, pop_items=set([u'ENSMUSG00000000278', u'ENSMUSG00000021557', u'ENSMUSG00000061298', u'ENSMUSG00000037852', u'ENSMUSG00000001773', u'ENSMUSG00000038836', u'ENSMUSG00000016256', u'ENSMUSG00000040812', u'ENSMUSG00000042501', u'ENSMUSG00000039007', u'ENSMUSG00000043943', u'ENSMUSG00000024644', u'ENSMUSG00000020841', u'ENSMUSG00000020473', u'ENSMUSG00000020681', u'ENSMUSG00000029165', u'ENSMUSG00000061119', u'ENSMUSG00000020183', u'ENSMUSG00000017760']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004181', NS='MF', enrichment='e', name='metallocarboxypeptidase activity', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020841']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000037852', u'ENSMUSG00000021557', u'ENSMUSG00000061298', u'ENSMUSG00000040812', u'ENSMUSG00000020183', u'ENSMUSG00000042501', u'ENSMUSG00000027408', u'ENSMUSG00000020841', u'ENSMUSG00000020473', u'ENSMUSG00000029165', u'ENSMUSG00000038836', u'ENSMUSG00000030862']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004185', NS='MF', enrichment='e', name='serine-type carboxypeptidase activity', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020841']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000000278', u'ENSMUSG00000037852', u'ENSMUSG00000020183', u'ENSMUSG00000020841', u'ENSMUSG00000020473', u'ENSMUSG00000017760']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004197', NS='MF', enrichment='e', name='cysteine-type endopeptidase activity', ratio_in_study=(3, 624), ratio_in_pop=(41, 13836), p_uncorrected=0.43181223342675984, depth=6, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028560', u'ENSMUSG00000033364', u'ENSMUSG00000058290']), pop_n=13836, pop_count=41, pop_items=set([u'ENSMUSG00000021477', u'ENSMUSG00000090115', u'ENSMUSG00000028550', u'ENSMUSG00000020840', u'ENSMUSG00000025076', u'ENSMUSG00000029592', u'ENSMUSG00000033364', u'ENSMUSG00000030560', u'ENSMUSG00000026280', u'ENSMUSG00000029863', u'ENSMUSG00000083282', u'ENSMUSG00000024889', u'ENSMUSG00000028914', u'ENSMUSG00000025616', u'ENSMUSG00000016256', u'ENSMUSG00000032688', u'ENSMUSG00000032359', u'ENSMUSG00000031826', u'ENSMUSG00000026854', u'ENSMUSG00000056342', u'ENSMUSG00000058290', u'ENSMUSG00000028015', u'ENSMUSG00000033538', u'ENSMUSG00000021190', u'ENSMUSG00000038642', u'ENSMUSG00000029640', u'ENSMUSG00000031628', u'ENSMUSG00000028560', u'ENSMUSG00000026029', u'ENSMUSG00000079418', u'ENSMUSG00000025888', u'ENSMUSG00000029223', u'ENSMUSG00000027997', u'ENSMUSG00000031548', u'ENSMUSG00000002820', u'ENSMUSG00000025437', u'ENSMUSG00000026031', u'ENSMUSG00000021939', u'ENSMUSG00000056900', u'ENSMUSG00000022710', u'ENSMUSG00000020124']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004252', NS='MF', enrichment='p', name='serine-type endopeptidase activity', ratio_in_study=(2, 624), ratio_in_pop=(48, 13836), p_uncorrected=1.0, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020282', u'ENSMUSG00000050063']), pop_n=13836, pop_count=48, pop_items=set([u'ENSMUSG00000055172', u'ENSMUSG00000027978', u'ENSMUSG00000038521', u'ENSMUSG00000030530', u'ENSMUSG00000031995', u'ENSMUSG00000031538', u'ENSMUSG00000029096', u'ENSMUSG00000035382', u'ENSMUSG00000030560', u'ENSMUSG00000020282', u'ENSMUSG00000054206', u'ENSMUSG00000031740', u'ENSMUSG00000024371', u'ENSMUSG00000023031', u'ENSMUSG00000050063', u'ENSMUSG00000068329', u'ENSMUSG00000028864', u'ENSMUSG00000019849', u'ENSMUSG00000021822', u'ENSMUSG00000002660', u'ENSMUSG00000032359', u'ENSMUSG00000041763', u'ENSMUSG00000026142', u'ENSMUSG00000006205', u'ENSMUSG00000034175', u'ENSMUSG00000070371', u'ENSMUSG00000047866', u'ENSMUSG00000032590', u'ENSMUSG00000024127', u'ENSMUSG00000020087', u'ENSMUSG00000041168', u'ENSMUSG00000027419', u'ENSMUSG00000000392', u'ENSMUSG00000039917', u'ENSMUSG00000033918', u'ENSMUSG00000030513', u'ENSMUSG00000033491', u'ENSMUSG00000021587', u'ENSMUSG00000022887', u'ENSMUSG00000027188', u'ENSMUSG00000028128', u'ENSMUSG00000035000', u'ENSMUSG00000024713', u'ENSMUSG00000031835', u'ENSMUSG00000039405', u'ENSMUSG00000017692', u'ENSMUSG00000030894', u'ENSMUSG00000064023']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004362', NS='MF', enrichment='e', name='glutathione-disulfide reductase activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000031584']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000031584']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004372', NS='MF', enrichment='e', name='glycine hydroxymethyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020534']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000025403', u'ENSMUSG00000020534']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004386', NS='MF', enrichment='e', name='helicase activity', ratio_in_study=(28, 624), ratio_in_pop=(115, 13836), p_uncorrected=3.898358886864664e-11, depth=7, study_count=28, p_sm_bonferroni=6.1227624677096416e-07, p_fdr_bh=4.7976426705528023e-08, study_items=set([u'ENSMUSG00000030528', u'ENSMUSG00000029730', u'ENSMUSG00000040296', u'ENSMUSG00000051220', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000041859', u'ENSMUSG00000002870', u'ENSMUSG00000036086', u'ENSMUSG00000027580', u'ENSMUSG00000026355', u'ENSMUSG00000027353', u'ENSMUSG00000034329', u'ENSMUSG00000035266', u'ENSMUSG00000017830', u'ENSMUSG00000023852', u'ENSMUSG00000002227', u'ENSMUSG00000005481', u'ENSMUSG00000022673', u'ENSMUSG00000025001', u'ENSMUSG00000033762', u'ENSMUSG00000026896', u'ENSMUSG00000005410', u'ENSMUSG00000028702', u'ENSMUSG00000036875', u'ENSMUSG00000042699', u'ENSMUSG00000033222', u'ENSMUSG00000038774']), pop_n=13836, pop_count=115, pop_items=set([u'ENSMUSG00000026806', u'ENSMUSG00000029599', u'ENSMUSG00000031583', u'ENSMUSG00000045538', u'ENSMUSG00000058301', u'ENSMUSG00000021494', u'ENSMUSG00000022471', u'ENSMUSG00000056608', u'ENSMUSG00000053754', u'ENSMUSG00000029920', u'ENSMUSG00000020752', u'ENSMUSG00000063870', u'ENSMUSG00000034329', u'ENSMUSG00000039354', u'ENSMUSG00000034653', u'ENSMUSG00000015023', u'ENSMUSG00000006019', u'ENSMUSG00000003868', u'ENSMUSG00000030204', u'ENSMUSG00000034931', u'ENSMUSG00000032097', u'ENSMUSG00000042426', u'ENSMUSG00000026896', u'ENSMUSG00000005045', u'ENSMUSG00000001674', u'ENSMUSG00000003660', u'ENSMUSG00000059796', u'ENSMUSG00000020079', u'ENSMUSG00000018583', u'ENSMUSG00000036875', u'ENSMUSG00000042699', u'ENSMUSG00000020075', u'ENSMUSG00000020076', u'ENSMUSG00000021470', u'ENSMUSG00000029730', u'ENSMUSG00000067995', u'ENSMUSG00000032480', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000031715', u'ENSMUSG00000002870', u'ENSMUSG00000025209', u'ENSMUSG00000041415', u'ENSMUSG00000078671', u'ENSMUSG00000057788', u'ENSMUSG00000035266', u'ENSMUSG00000057133', u'ENSMUSG00000090112', u'ENSMUSG00000004393', u'ENSMUSG00000023852', u'ENSMUSG00000031099', u'ENSMUSG00000040296', u'ENSMUSG00000043535', u'ENSMUSG00000030079', u'ENSMUSG00000029389', u'ENSMUSG00000000787', u'ENSMUSG00000040620', u'ENSMUSG00000021500', u'ENSMUSG00000037149', u'ENSMUSG00000038774', u'ENSMUSG00000041235', u'ENSMUSG00000031229', u'ENSMUSG00000020719', u'ENSMUSG00000033762', u'ENSMUSG00000024831', u'ENSMUSG00000051220', u'ENSMUSG00000032187', u'ENSMUSG00000018425', u'ENSMUSG00000030528', u'ENSMUSG00000030400', u'ENSMUSG00000036086', u'ENSMUSG00000027580', u'ENSMUSG00000026355', u'ENSMUSG00000020228', u'ENSMUSG00000041645', u'ENSMUSG00000019432', u'ENSMUSG00000020705', u'ENSMUSG00000058298', u'ENSMUSG00000017830', u'ENSMUSG00000005481', u'ENSMUSG00000022884', u'ENSMUSG00000030243', u'ENSMUSG00000027905', u'ENSMUSG00000025001', u'ENSMUSG00000026187', u'ENSMUSG00000055884', u'ENSMUSG00000016018', u'ENSMUSG00000028089', u'ENSMUSG00000005410', u'ENSMUSG00000032101', u'ENSMUSG00000028702', u'ENSMUSG00000002227', u'ENSMUSG00000033222', u'ENSMUSG00000040661', u'ENSMUSG00000041859', u'ENSMUSG00000024921', u'ENSMUSG00000058594', u'ENSMUSG00000027353', u'ENSMUSG00000020677', u'ENSMUSG00000002428', u'ENSMUSG00000035051', u'ENSMUSG00000029504', u'ENSMUSG00000029505', u'ENSMUSG00000034154', u'ENSMUSG00000024382', u'ENSMUSG00000017999', u'ENSMUSG00000022673', u'ENSMUSG00000055065', u'ENSMUSG00000030986', u'ENSMUSG00000020721', u'ENSMUSG00000026404', u'ENSMUSG00000027770', u'ENSMUSG00000053289', u'ENSMUSG00000043410', u'ENSMUSG00000029169']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004392', NS='MF', enrichment='e', name='heme oxygenase (decyclizing) activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005413']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000005413', u'ENSMUSG00000004070']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004402', NS='MF', enrichment='p', name='histone acetyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(40, 13836), p_uncorrected=0.9999999999996365, depth=9, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027018']), pop_n=13836, pop_count=40, pop_items=set([u'ENSMUSG00000017210', u'ENSMUSG00000026563', u'ENSMUSG00000027425', u'ENSMUSG00000029196', u'ENSMUSG00000069495', u'ENSMUSG00000022521', u'ENSMUSG00000041975', u'ENSMUSG00000047242', u'ENSMUSG00000038954', u'ENSMUSG00000030801', u'ENSMUSG00000024926', u'ENSMUSG00000020918', u'ENSMUSG00000029238', u'ENSMUSG00000038909', u'ENSMUSG00000053134', u'ENSMUSG00000018651', u'ENSMUSG00000035666', u'ENSMUSG00000025049', u'ENSMUSG00000025220', u'ENSMUSG00000005982', u'ENSMUSG00000059288', u'ENSMUSG00000022031', u'ENSMUSG00000003680', u'ENSMUSG00000052293', u'ENSMUSG00000000708', u'ENSMUSG00000048930', u'ENSMUSG00000055024', u'ENSMUSG00000031314', u'ENSMUSG00000038697', u'ENSMUSG00000024240', u'ENSMUSG00000031540', u'ENSMUSG00000029670', u'ENSMUSG00000027018', u'ENSMUSG00000027167', u'ENSMUSG00000028899', u'ENSMUSG00000021767', u'ENSMUSG00000020647', u'ENSMUSG00000043866', u'ENSMUSG00000027104', u'ENSMUSG00000027678']), study_n=624, level=9, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0004406', 'GO:0004404', 'GO:0004405', 'GO:0004403', 'GO:0043166', 'GO:0046971'])),
    NtGoeaResults(GO='GO:0004407', NS='MF', enrichment='e', name='histone deacetylase activity', ratio_in_study=(2, 624), ratio_in_pop=(25, 13836), p_uncorrected=0.3120805885885919, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000071646', u'ENSMUSG00000042557']), pop_n=13836, pop_count=25, pop_items=set([u'ENSMUSG00000031161', u'ENSMUSG00000066900', u'ENSMUSG00000020519', u'ENSMUSG00000026313', u'ENSMUSG00000022475', u'ENSMUSG00000042570', u'ENSMUSG00000028522', u'ENSMUSG00000034245', u'ENSMUSG00000031609', u'ENSMUSG00000015149', u'ENSMUSG00000012076', u'ENSMUSG00000004698', u'ENSMUSG00000028800', u'ENSMUSG00000020063', u'ENSMUSG00000026932', u'ENSMUSG00000031622', u'ENSMUSG00000019777', u'ENSMUSG00000031665', u'ENSMUSG00000062906', u'ENSMUSG00000042557', u'ENSMUSG00000008855', u'ENSMUSG00000071646', u'ENSMUSG00000067567', u'ENSMUSG00000080268', u'ENSMUSG00000024454']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004441', NS='MF', enrichment='e', name='inositol-1,4-bisphosphate 1-phosphatase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026102']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000026102', u'ENSMUSG00000026617']), study_n=624, level=8, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004468', NS='MF', enrichment='e', name='lysine N-acetyltransferase activity, acting on acetyl phosphate as donor', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000022034']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000024426', u'ENSMUSG00000057103', u'ENSMUSG00000022034', u'ENSMUSG00000000708', u'ENSMUSG00000055024']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004518', NS='MF', enrichment='e', name='nuclease activity', ratio_in_study=(14, 624), ratio_in_pop=(91, 13836), p_uncorrected=5.3432495556328326e-05, depth=4, study_count=14, p_sm_bonferroni=0.83921077520769272, p_fdr_bh=0.0053114606025803333, study_items=set([u'ENSMUSG00000039748', u'ENSMUSG00000031527', u'ENSMUSG00000039236', u'ENSMUSG00000030609', u'ENSMUSG00000041238', u'ENSMUSG00000036086', u'ENSMUSG00000046295', u'ENSMUSG00000027433', u'ENSMUSG00000035958', u'ENSMUSG00000036875', u'ENSMUSG00000030929', u'ENSMUSG00000024742', u'ENSMUSG00000051235', u'ENSMUSG00000038644']), pop_n=13836, pop_count=91, pop_items=set([u'ENSMUSG00000073678', u'ENSMUSG00000046295', u'ENSMUSG00000040482', u'ENSMUSG00000020515', u'ENSMUSG00000031583', u'ENSMUSG00000027845', u'ENSMUSG00000033126', u'ENSMUSG00000026248', u'ENSMUSG00000025269', u'ENSMUSG00000022248', u'ENSMUSG00000032705', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000066800', u'ENSMUSG00000028629', u'ENSMUSG00000037419', u'ENSMUSG00000034724', u'ENSMUSG00000027714', u'ENSMUSG00000032026', u'ENSMUSG00000032410', u'ENSMUSG00000018583', u'ENSMUSG00000036875', u'ENSMUSG00000059772', u'ENSMUSG00000028322', u'ENSMUSG00000025937', u'ENSMUSG00000020362', u'ENSMUSG00000032396', u'ENSMUSG00000030609', u'ENSMUSG00000041415', u'ENSMUSG00000005682', u'ENSMUSG00000026632', u'ENSMUSG00000015337', u'ENSMUSG00000023087', u'ENSMUSG00000072115', u'ENSMUSG00000027433', u'ENSMUSG00000024824', u'ENSMUSG00000024906', u'ENSMUSG00000039850', u'ENSMUSG00000022545', u'ENSMUSG00000017264', u'ENSMUSG00000021876', u'ENSMUSG00000031792', u'ENSMUSG00000037149', u'ENSMUSG00000027424', u'ENSMUSG00000024136', u'ENSMUSG00000050751', u'ENSMUSG00000073436', u'ENSMUSG00000036086', u'ENSMUSG00000029027', u'ENSMUSG00000038290', u'ENSMUSG00000041238', u'ENSMUSG00000020630', u'ENSMUSG00000033166', u'ENSMUSG00000047417', u'ENSMUSG00000024742', u'ENSMUSG00000026048', u'ENSMUSG00000020549', u'ENSMUSG00000053333', u'ENSMUSG00000048039', u'ENSMUSG00000031527', u'ENSMUSG00000020464', u'ENSMUSG00000031601', u'ENSMUSG00000050891', u'ENSMUSG00000051235', u'ENSMUSG00000055884', u'ENSMUSG00000043702', u'ENSMUSG00000035164', u'ENSMUSG00000022685', u'ENSMUSG00000030929', u'ENSMUSG00000001424', u'ENSMUSG00000033423', u'ENSMUSG00000033458', u'ENSMUSG00000052926', u'ENSMUSG00000035960', u'ENSMUSG00000036698', u'ENSMUSG00000042787', u'ENSMUSG00000022191', u'ENSMUSG00000003549', u'ENSMUSG00000052406', u'ENSMUSG00000036941', u'ENSMUSG00000026374', u'ENSMUSG00000003812', u'ENSMUSG00000038644', u'ENSMUSG00000026648', u'ENSMUSG00000031928', u'ENSMUSG00000035958', u'ENSMUSG00000042275', u'ENSMUSG00000022468', u'ENSMUSG00000027243', u'ENSMUSG00000054309', u'ENSMUSG00000079109']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004519', NS='MF', enrichment='e', name='endonuclease activity', ratio_in_study=(8, 624), ratio_in_pop=(51, 13836), p_uncorrected=0.0018719715226934578, depth=5, study_count=8, p_sm_bonferroni=1.0, p_fdr_bh=0.10596977617596998, study_items=set([u'ENSMUSG00000039748', u'ENSMUSG00000041238', u'ENSMUSG00000036086', u'ENSMUSG00000046295', u'ENSMUSG00000035958', u'ENSMUSG00000036875', u'ENSMUSG00000024742', u'ENSMUSG00000051235']), pop_n=13836, pop_count=51, pop_items=set([u'ENSMUSG00000059772', u'ENSMUSG00000026648', u'ENSMUSG00000025937', u'ENSMUSG00000020715', u'ENSMUSG00000020630', u'ENSMUSG00000046295', u'ENSMUSG00000036086', u'ENSMUSG00000024136', u'ENSMUSG00000052926', u'ENSMUSG00000035960', u'ENSMUSG00000036698', u'ENSMUSG00000050751', u'ENSMUSG00000073436', u'ENSMUSG00000042787', u'ENSMUSG00000022191', u'ENSMUSG00000003549', u'ENSMUSG00000026248', u'ENSMUSG00000037795', u'ENSMUSG00000041238', u'ENSMUSG00000041415', u'ENSMUSG00000039850', u'ENSMUSG00000036941', u'ENSMUSG00000026374', u'ENSMUSG00000033126', u'ENSMUSG00000025269', u'ENSMUSG00000015337', u'ENSMUSG00000026048', u'ENSMUSG00000020549', u'ENSMUSG00000039748', u'ENSMUSG00000033458', u'ENSMUSG00000031928', u'ENSMUSG00000072115', u'ENSMUSG00000037419', u'ENSMUSG00000024120', u'ENSMUSG00000035958', u'ENSMUSG00000066800', u'ENSMUSG00000038290', u'ENSMUSG00000024906', u'ENSMUSG00000033166', u'ENSMUSG00000051235', u'ENSMUSG00000042275', u'ENSMUSG00000022545', u'ENSMUSG00000035164', u'ENSMUSG00000003812', u'ENSMUSG00000022468', u'ENSMUSG00000021876', u'ENSMUSG00000024742', u'ENSMUSG00000054309', u'ENSMUSG00000018583', u'ENSMUSG00000036875', u'ENSMUSG00000079109']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004520', NS='MF', enrichment='e', name='endodeoxyribonuclease activity', ratio_in_study=(2, 624), ratio_in_pop=(11, 13836), p_uncorrected=0.08530221141860472, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000036086', u'ENSMUSG00000027323']), pop_n=13836, pop_count=11, pop_items=set([u'ENSMUSG00000031928', u'ENSMUSG00000022545', u'ENSMUSG00000018841', u'ENSMUSG00000028933', u'ENSMUSG00000030744', u'ENSMUSG00000030051', u'ENSMUSG00000036086', u'ENSMUSG00000027323', u'ENSMUSG00000003812', u'ENSMUSG00000021287', u'ENSMUSG00000026048']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004523', NS='MF', enrichment='e', name='RNA-DNA hybrid ribonuclease activity', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024742']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000024742', u'ENSMUSG00000052926', u'ENSMUSG00000021932', u'ENSMUSG00000020630']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0004524'])),
    NtGoeaResults(GO='GO:0004527', NS='MF', enrichment='e', name='exonuclease activity', ratio_in_study=(8, 624), ratio_in_pop=(45, 13836), p_uncorrected=0.0008033906036283867, depth=5, study_count=8, p_sm_bonferroni=1.0, p_fdr_bh=0.052728216184655223, study_items=set([u'ENSMUSG00000039748', u'ENSMUSG00000031527', u'ENSMUSG00000039236', u'ENSMUSG00000030609', u'ENSMUSG00000027433', u'ENSMUSG00000038644', u'ENSMUSG00000024742', u'ENSMUSG00000030929']), pop_n=13836, pop_count=45, pop_items=set([u'ENSMUSG00000039176', u'ENSMUSG00000039236', u'ENSMUSG00000028322', u'ENSMUSG00000020362', u'ENSMUSG00000027424', u'ENSMUSG00000033423', u'ENSMUSG00000040482', u'ENSMUSG00000020515', u'ENSMUSG00000031583', u'ENSMUSG00000035960', u'ENSMUSG00000027845', u'ENSMUSG00000031928', u'ENSMUSG00000030609', u'ENSMUSG00000052406', u'ENSMUSG00000005682', u'ENSMUSG00000025269', u'ENSMUSG00000047417', u'ENSMUSG00000022248', u'ENSMUSG00000032705', u'ENSMUSG00000053333', u'ENSMUSG00000024742', u'ENSMUSG00000038644', u'ENSMUSG00000026648', u'ENSMUSG00000039748', u'ENSMUSG00000023087', u'ENSMUSG00000033458', u'ENSMUSG00000048039', u'ENSMUSG00000032396', u'ENSMUSG00000027433', u'ENSMUSG00000043702', u'ENSMUSG00000020464', u'ENSMUSG00000031601', u'ENSMUSG00000024824', u'ENSMUSG00000033166', u'ENSMUSG00000037370', u'ENSMUSG00000028629', u'ENSMUSG00000031527', u'ENSMUSG00000034724', u'ENSMUSG00000027714', u'ENSMUSG00000017264', u'ENSMUSG00000032026', u'ENSMUSG00000032410', u'ENSMUSG00000037149', u'ENSMUSG00000022685', u'ENSMUSG00000030929']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0008857'])),
    NtGoeaResults(GO='GO:0004534', NS='MF', enrichment='e', name="5'-3' exoribonuclease activity", ratio_in_study=(2, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.005909998133444449, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.22584533013109129, study_items=set([u'ENSMUSG00000027433', u'ENSMUSG00000024472']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000032410', u'ENSMUSG00000024472', u'ENSMUSG00000027433']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004553', NS='MF', enrichment='p', name='hydrolase activity, hydrolyzing O-glycosyl compounds', ratio_in_study=(1, 624), ratio_in_pop=(23, 13836), p_uncorrected=1.0, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025534']), pop_n=13836, pop_count=23, pop_items=set([u'ENSMUSG00000021665', u'ENSMUSG00000031266', u'ENSMUSG00000028189', u'ENSMUSG00000021737', u'ENSMUSG00000028479', u'ENSMUSG00000025232', u'ENSMUSG00000062646', u'ENSMUSG00000071650', u'ENSMUSG00000026200', u'ENSMUSG00000031864', u'ENSMUSG00000030306', u'ENSMUSG00000028467', u'ENSMUSG00000022453', u'ENSMUSG00000033540', u'ENSMUSG00000046312', u'ENSMUSG00000028164', u'ENSMUSG00000022707', u'ENSMUSG00000058488', u'ENSMUSG00000039307', u'ENSMUSG00000045594', u'ENSMUSG00000025579', u'ENSMUSG00000025534', u'ENSMUSG00000033157']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0016800'])),
    NtGoeaResults(GO='GO:0004566', NS='MF', enrichment='e', name='beta-glucuronidase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025534']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000025534', u'ENSMUSG00000058488']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004586', NS='MF', enrichment='e', name='ornithine decarboxylase activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000011179']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000011179']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004588', NS='MF', enrichment='e', name='orotate phosphoribosyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000022814']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000022814']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004590', NS='MF', enrichment='e', name="orotidine-5'-phosphate decarboxylase activity", ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000022814']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000022814']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004601', NS='MF', enrichment='e', name='peroxidase activity', ratio_in_study=(1, 624), ratio_in_pop=(19, 13836), p_uncorrected=0.5841387202644939, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032487']), pop_n=13836, pop_count=19, pop_items=set([u'ENSMUSG00000020803', u'ENSMUSG00000026701', u'ENSMUSG00000073940', u'ENSMUSG00000069917', u'ENSMUSG00000020810', u'ENSMUSG00000032487', u'ENSMUSG00000052305', u'ENSMUSG00000024997', u'ENSMUSG00000028691', u'ENSMUSG00000047250', u'ENSMUSG00000005161', u'ENSMUSG00000063856', u'ENSMUSG00000024953', u'ENSMUSG00000075706', u'ENSMUSG00000027187', u'ENSMUSG00000069919', u'ENSMUSG00000025289', u'ENSMUSG00000021760', u'ENSMUSG00000020674']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0016687', 'GO:0016686', 'GO:0016685', 'GO:0016693'])),
    NtGoeaResults(GO='GO:0004622', NS='MF', enrichment='e', name='lysophospholipase activity', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029134']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000033917', u'ENSMUSG00000036257', u'ENSMUSG00000056220', u'ENSMUSG00000029134', u'ENSMUSG00000037686', u'ENSMUSG00000061666', u'ENSMUSG00000022425', u'ENSMUSG00000040997', u'ENSMUSG00000025903', u'ENSMUSG00000004565', u'ENSMUSG00000032046', u'ENSMUSG00000036833']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0045126'])),
    NtGoeaResults(GO='GO:0004623', NS='MF', enrichment='e', name='phospholipase A2 activity', ratio_in_study=(1, 624), ratio_in_pop=(14, 13836), p_uncorrected=0.476065293901136, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000029134']), pop_n=13836, pop_count=14, pop_items=set([u'ENSMUSG00000056220', u'ENSMUSG00000060675', u'ENSMUSG00000026701', u'ENSMUSG00000027999', u'ENSMUSG00000041193', u'ENSMUSG00000028749', u'ENSMUSG00000029134', u'ENSMUSG00000002475', u'ENSMUSG00000024180', u'ENSMUSG00000033847', u'ENSMUSG00000050211', u'ENSMUSG00000041653', u'ENSMUSG00000042632', u'ENSMUSG00000035237']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004630', NS='MF', enrichment='e', name='phospholipase D activity', ratio_in_study=(1, 624), ratio_in_pop=(5, 13836), p_uncorrected=0.20608276463934042, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005413']), pop_n=13836, pop_count=5, pop_items=set([u'ENSMUSG00000021340', u'ENSMUSG00000003363', u'ENSMUSG00000027695', u'ENSMUSG00000020828', u'ENSMUSG00000005413']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004652', NS='MF', enrichment='e', name='polynucleotide adenylyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000042167']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000071645', u'ENSMUSG00000034575', u'ENSMUSG00000020273', u'ENSMUSG00000042167', u'ENSMUSG00000024234', u'ENSMUSG00000036779', u'ENSMUSG00000021111']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004666', NS='MF', enrichment='e', name='prostaglandin-endoperoxide synthase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032487']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000032487', u'ENSMUSG00000047250']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004672', NS='MF', enrichment='e', name='protein kinase activity', ratio_in_study=(25, 624), ratio_in_pop=(439, 13836), p_uncorrected=0.2406273189348677, depth=5, study_count=25, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000019942', u'ENSMUSG00000023908', u'ENSMUSG00000038379', u'ENSMUSG00000024079', u'ENSMUSG00000025358', u'ENSMUSG00000035683', u'ENSMUSG00000032113', u'ENSMUSG00000031478', u'ENSMUSG00000030867', u'ENSMUSG00000026779', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000021115', u'ENSMUSG00000022033', u'ENSMUSG00000032409', u'ENSMUSG00000025758', u'ENSMUSG00000029521', u'ENSMUSG00000026622', u'ENSMUSG00000005566', u'ENSMUSG00000006445', u'ENSMUSG00000027496', u'ENSMUSG00000026274', u'ENSMUSG00000029283', u'ENSMUSG00000034218']), pop_n=13836, pop_count=439, pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000029513', u'ENSMUSG00000029512', u'ENSMUSG00000026490', u'ENSMUSG00000029516', u'ENSMUSG00000020190', u'ENSMUSG00000074886', u'ENSMUSG00000040084', u'ENSMUSG00000028431', u'ENSMUSG00000016528', u'ENSMUSG00000030110', u'ENSMUSG00000016526', u'ENSMUSG00000089872', u'ENSMUSG00000030849', u'ENSMUSG00000004054', u'ENSMUSG00000004056', u'ENSMUSG00000002409', u'ENSMUSG00000035032', u'ENSMUSG00000055471', u'ENSMUSG00000033862', u'ENSMUSG00000024042', u'ENSMUSG00000021408', u'ENSMUSG00000042228', u'ENSMUSG00000006445', u'ENSMUSG00000059981', u'ENSMUSG00000032384', u'ENSMUSG00000061288', u'ENSMUSG00000022607', u'ENSMUSG00000035725', u'ENSMUSG00000020366', u'ENSMUSG00000024290', u'ENSMUSG00000022781', u'ENSMUSG00000018209', u'ENSMUSG00000029635', u'ENSMUSG00000062312', u'ENSMUSG00000031644', u'ENSMUSG00000027379', u'ENSMUSG00000006386', u'ENSMUSG00000006599', u'ENSMUSG00000024769', u'ENSMUSG00000031012', u'ENSMUSG00000031016', u'ENSMUSG00000015599', u'ENSMUSG00000026836', u'ENSMUSG00000026834', u'ENSMUSG00000069089', u'ENSMUSG00000022433', u'ENSMUSG00000029387', u'ENSMUSG00000024617', u'ENSMUSG00000007613', u'ENSMUSG00000034218', u'ENSMUSG00000020715', u'ENSMUSG00000061393', u'ENSMUSG00000026596', u'ENSMUSG00000024830', u'ENSMUSG00000030409', u'ENSMUSG00000050697', u'ENSMUSG00000020827', u'ENSMUSG00000030400', u'ENSMUSG00000057672', u'ENSMUSG00000045962', u'ENSMUSG00000000532', u'ENSMUSG00000000530', u'ENSMUSG00000066800', u'ENSMUSG00000026201', u'ENSMUSG00000027339', u'ENSMUSG00000026207', u'ENSMUSG00000046709', u'ENSMUSG00000028078', u'ENSMUSG00000046707', u'ENSMUSG00000024122', u'ENSMUSG00000003948', u'ENSMUSG00000035486', u'ENSMUSG00000042064', u'ENSMUSG00000069539', u'ENSMUSG00000040936', u'ENSMUSG00000018334', u'ENSMUSG00000000441', u'ENSMUSG00000016179', u'ENSMUSG00000062960', u'ENSMUSG00000026117', u'ENSMUSG00000052920', u'ENSMUSG00000031833', u'ENSMUSG00000003534', u'ENSMUSG00000021532', u'ENSMUSG00000022897', u'ENSMUSG00000048310', u'ENSMUSG00000023050', u'ENSMUSG00000053137', u'ENSMUSG00000032113', u'ENSMUSG00000032440', u'ENSMUSG00000053819', u'ENSMUSG00000003228', u'ENSMUSG00000039533', u'ENSMUSG00000035305', u'ENSMUSG00000059146', u'ENSMUSG00000031112', u'ENSMUSG00000024789', u'ENSMUSG00000022672', u'ENSMUSG00000029217', u'ENSMUSG00000028756', u'ENSMUSG00000058444', u'ENSMUSG00000033885', u'ENSMUSG00000053046', u'ENSMUSG00000031478', u'ENSMUSG00000029674', u'ENSMUSG00000021639', u'ENSMUSG00000034663', u'ENSMUSG00000038145', u'ENSMUSG00000019942', u'ENSMUSG00000039145', u'ENSMUSG00000032936', u'ENSMUSG00000020694', u'ENSMUSG00000025358', u'ENSMUSG00000029454', u'ENSMUSG00000035390', u'ENSMUSG00000023809', u'ENSMUSG00000020389', u'ENSMUSG00000064090', u'ENSMUSG00000027177', u'ENSMUSG00000021108', u'ENSMUSG00000020897', u'ENSMUSG00000005034', u'ENSMUSG00000035232', u'ENSMUSG00000042608', u'ENSMUSG00000020890', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000005566', u'ENSMUSG00000053693', u'ENSMUSG00000037251', u'ENSMUSG00000025199', u'ENSMUSG00000055540', u'ENSMUSG00000000567', u'ENSMUSG00000028926', u'ENSMUSG00000040390', u'ENSMUSG00000032308', u'ENSMUSG00000026622', u'ENSMUSG00000026620', u'ENSMUSG00000002413', u'ENSMUSG00000062234', u'ENSMUSG00000017291', u'ENSMUSG00000030272', u'ENSMUSG00000075590', u'ENSMUSG00000073563', u'ENSMUSG00000026027', u'ENSMUSG00000042349', u'ENSMUSG00000031805', u'ENSMUSG00000026437', u'ENSMUSG00000040021', u'ENSMUSG00000004936', u'ENSMUSG00000004933', u'ENSMUSG00000032409', u'ENSMUSG00000031392', u'ENSMUSG00000062044', u'ENSMUSG00000034290', u'ENSMUSG00000020357', u'ENSMUSG00000003283', u'ENSMUSG00000031155', u'ENSMUSG00000039913', u'ENSMUSG00000078816', u'ENSMUSG00000002688', u'ENSMUSG00000032571', u'ENSMUSG00000002205', u'ENSMUSG00000032577', u'ENSMUSG00000025537', u'ENSMUSG00000074305', u'ENSMUSG00000026842', u'ENSMUSG00000009772', u'ENSMUSG00000029245', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000028661', u'ENSMUSG00000033276', u'ENSMUSG00000036273', u'ENSMUSG00000028862', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000042724', u'ENSMUSG00000024235', u'ENSMUSG00000034751', u'ENSMUSG00000005469', u'ENSMUSG00000001729', u'ENSMUSG00000041135', u'ENSMUSG00000026667', u'ENSMUSG00000020700', u'ENSMUSG00000029403', u'ENSMUSG00000026584', u'ENSMUSG00000009555', u'ENSMUSG00000027297', u'ENSMUSG00000023972', u'ENSMUSG00000034974', u'ENSMUSG00000027298', u'ENSMUSG00000003644', u'ENSMUSG00000024242', u'ENSMUSG00000079043', u'ENSMUSG00000041187', u'ENSMUSG00000024247', u'ENSMUSG00000059456', u'ENSMUSG00000026749', u'ENSMUSG00000051747', u'ENSMUSG00000018932', u'ENSMUSG00000028969', u'ENSMUSG00000033628', u'ENSMUSG00000008730', u'ENSMUSG00000038970', u'ENSMUSG00000028289', u'ENSMUSG00000063410', u'ENSMUSG00000038976', u'ENSMUSG00000028284', u'ENSMUSG00000031537', u'ENSMUSG00000025162', u'ENSMUSG00000031565', u'ENSMUSG00000050965', u'ENSMUSG00000003810', u'ENSMUSG00000021279', u'ENSMUSG00000020015', u'ENSMUSG00000015133', u'ENSMUSG00000024383', u'ENSMUSG00000024382', u'ENSMUSG00000031668', u'ENSMUSG00000029062', u'ENSMUSG00000050271', u'ENSMUSG00000002007', u'ENSMUSG00000052430', u'ENSMUSG00000028959', u'ENSMUSG00000031284', u'ENSMUSG00000032537', u'ENSMUSG00000053436', u'ENSMUSG00000021936', u'ENSMUSG00000022836', u'ENSMUSG00000062604', u'ENSMUSG00000020516', u'ENSMUSG00000031065', u'ENSMUSG00000021180', u'ENSMUSG00000029613', u'ENSMUSG00000036737', u'ENSMUSG00000020451', u'ENSMUSG00000019577', u'ENSMUSG00000021948', u'ENSMUSG00000039954', u'ENSMUSG00000032547', u'ENSMUSG00000070348', u'ENSMUSG00000037885', u'ENSMUSG00000057897', u'ENSMUSG00000025915', u'ENSMUSG00000037738', u'ENSMUSG00000001034', u'ENSMUSG00000027797', u'ENSMUSG00000024079', u'ENSMUSG00000015981', u'ENSMUSG00000024969', u'ENSMUSG00000029334', u'ENSMUSG00000027496', u'ENSMUSG00000037643', u'ENSMUSG00000032312', u'ENSMUSG00000020941', u'ENSMUSG00000021115', u'ENSMUSG00000052504', u'ENSMUSG00000020580', u'ENSMUSG00000019699', u'ENSMUSG00000023908', u'ENSMUSG00000004085', u'ENSMUSG00000005672', u'ENSMUSG00000067713', u'ENSMUSG00000035683', u'ENSMUSG00000037012', u'ENSMUSG00000004865', u'ENSMUSG00000027646', u'ENSMUSG00000030867', u'ENSMUSG00000035112', u'ENSMUSG00000032316', u'ENSMUSG00000007411', u'ENSMUSG00000027086', u'ENSMUSG00000062209', u'ENSMUSG00000033966', u'ENSMUSG00000042978', u'ENSMUSG00000014361', u'ENSMUSG00000004798', u'ENSMUSG00000027030', u'ENSMUSG00000030815', u'ENSMUSG00000026034', u'ENSMUSG00000020122', u'ENSMUSG00000042817', u'ENSMUSG00000042249', u'ENSMUSG00000031292', u'ENSMUSG00000020385', u'ENSMUSG00000019235', u'ENSMUSG00000028530', u'ENSMUSG00000017376', u'ENSMUSG00000002602', u'ENSMUSG00000053158', u'ENSMUSG00000032500', u'ENSMUSG00000022329', u'ENSMUSG00000068917', u'ENSMUSG00000063065', u'ENSMUSG00000024576', u'ENSMUSG00000027692', u'ENSMUSG00000017405', u'ENSMUSG00000050890', u'ENSMUSG00000020785', u'ENSMUSG00000074923', u'ENSMUSG00000028708', u'ENSMUSG00000028874', u'ENSMUSG00000001630', u'ENSMUSG00000028876', u'ENSMUSG00000006728', u'ENSMUSG00000033191', u'ENSMUSG00000034761', u'ENSMUSG00000025758', u'ENSMUSG00000026674', u'ENSMUSG00000061578', u'ENSMUSG00000028680', u'ENSMUSG00000029471', u'ENSMUSG00000024952', u'ENSMUSG00000025375', u'ENSMUSG00000028518', u'ENSMUSG00000005534', u'ENSMUSG00000005533', u'ENSMUSG00000024558', u'ENSMUSG00000010057', u'ENSMUSG00000037112', u'ENSMUSG00000000127', u'ENSMUSG00000013629', u'ENSMUSG00000026778', u'ENSMUSG00000026779', u'ENSMUSG00000028991', u'ENSMUSG00000038481', u'ENSMUSG00000021701', u'ENSMUSG00000042046', u'ENSMUSG00000031450', u'ENSMUSG00000005102', u'ENSMUSG00000042567', u'ENSMUSG00000026274', u'ENSMUSG00000026277', u'ENSMUSG00000028458', u'ENSMUSG00000041997', u'ENSMUSG00000031853', u'ENSMUSG00000035027', u'ENSMUSG00000045038', u'ENSMUSG00000026074', u'ENSMUSG00000052889', u'ENSMUSG00000020601', u'ENSMUSG00000024070', u'ENSMUSG00000069631', u'ENSMUSG00000021559', u'ENSMUSG00000022263', u'ENSMUSG00000026094', u'ENSMUSG00000029053', u'ENSMUSG00000004591', u'ENSMUSG00000018166', u'ENSMUSG00000021796', u'ENSMUSG00000071369', u'ENSMUSG00000021820', u'ENSMUSG00000020115', u'ENSMUSG00000026393', u'ENSMUSG00000019843', u'ENSMUSG00000021413', u'ENSMUSG00000035828', u'ENSMUSG00000020272', u'ENSMUSG00000038128', u'ENSMUSG00000003345', u'ENSMUSG00000022791', u'ENSMUSG00000003068', u'ENSMUSG00000005958', u'ENSMUSG00000002948', u'ENSMUSG00000021959', u'ENSMUSG00000021483', u'ENSMUSG00000029833', u'ENSMUSG00000029283', u'ENSMUSG00000006494', u'ENSMUSG00000034135', u'ENSMUSG00000061436', u'ENSMUSG00000003119', u'ENSMUSG00000029231', u'ENSMUSG00000030602', u'ENSMUSG00000028630', u'ENSMUSG00000021044', u'ENSMUSG00000037989', u'ENSMUSG00000051590', u'ENSMUSG00000059883', u'ENSMUSG00000020990', u'ENSMUSG00000028469', u'ENSMUSG00000030774', u'ENSMUSG00000041245', u'ENSMUSG00000024858', u'ENSMUSG00000026235', u'ENSMUSG00000030890', u'ENSMUSG00000000384', u'ENSMUSG00000009376', u'ENSMUSG00000021754', u'ENSMUSG00000067336', u'ENSMUSG00000027931', u'ENSMUSG00000021457', u'ENSMUSG00000031309', u'ENSMUSG00000052783', u'ENSMUSG00000031303', u'ENSMUSG00000030397', u'ENSMUSG00000030802', u'ENSMUSG00000055254', u'ENSMUSG00000032175', u'ENSMUSG00000022033', u'ENSMUSG00000014932', u'ENSMUSG00000014426', u'ENSMUSG00000061751', u'ENSMUSG00000020032', u'ENSMUSG00000025962', u'ENSMUSG00000056458', u'ENSMUSG00000033352', u'ENSMUSG00000033985', u'ENSMUSG00000053414', u'ENSMUSG00000001127', u'ENSMUSG00000001524', u'ENSMUSG00000024006', u'ENSMUSG00000021918', u'ENSMUSG00000024002', u'ENSMUSG00000038379', u'ENSMUSG00000019970', u'ENSMUSG00000041297', u'ENSMUSG00000060477', u'ENSMUSG00000037593', u'ENSMUSG00000029647', u'ENSMUSG00000029869', u'ENSMUSG00000029648', u'ENSMUSG00000033618', u'ENSMUSG00000052155', u'ENSMUSG00000022812', u'ENSMUSG00000040274', u'ENSMUSG00000057177', u'ENSMUSG00000063358', u'ENSMUSG00000024941', u'ENSMUSG00000009828', u'ENSMUSG00000042688', u'ENSMUSG00000024948', u'ENSMUSG00000025060', u'ENSMUSG00000054252', u'ENSMUSG00000025665', u'ENSMUSG00000061462', u'ENSMUSG00000027365']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0050222'])),
    NtGoeaResults(GO='GO:0004674', NS='MF', enrichment='e', name='protein serine/threonine kinase activity', ratio_in_study=(25, 624), ratio_in_pop=(355, 13836), p_uncorrected=0.026663249524653956, depth=6, study_count=25, p_sm_bonferroni=1.0, p_fdr_bh=0.68929525751834508, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000019942', u'ENSMUSG00000023908', u'ENSMUSG00000038379', u'ENSMUSG00000024079', u'ENSMUSG00000002297', u'ENSMUSG00000025358', u'ENSMUSG00000035683', u'ENSMUSG00000032113', u'ENSMUSG00000031478', u'ENSMUSG00000030867', u'ENSMUSG00000026779', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000024404', u'ENSMUSG00000032409', u'ENSMUSG00000025758', u'ENSMUSG00000029521', u'ENSMUSG00000021115', u'ENSMUSG00000034218', u'ENSMUSG00000027496', u'ENSMUSG00000022033', u'ENSMUSG00000026274', u'ENSMUSG00000029283', u'ENSMUSG00000026622']), pop_n=13836, pop_count=355, pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000040084', u'ENSMUSG00000029512', u'ENSMUSG00000026490', u'ENSMUSG00000028028', u'ENSMUSG00000029516', u'ENSMUSG00000020190', u'ENSMUSG00000074886', u'ENSMUSG00000016528', u'ENSMUSG00000016526', u'ENSMUSG00000089872', u'ENSMUSG00000027665', u'ENSMUSG00000004054', u'ENSMUSG00000004056', u'ENSMUSG00000002409', u'ENSMUSG00000035032', u'ENSMUSG00000033862', u'ENSMUSG00000024042', u'ENSMUSG00000021408', u'ENSMUSG00000059981', u'ENSMUSG00000032384', u'ENSMUSG00000061288', u'ENSMUSG00000035725', u'ENSMUSG00000020366', u'ENSMUSG00000021180', u'ENSMUSG00000022781', u'ENSMUSG00000018209', u'ENSMUSG00000029635', u'ENSMUSG00000031644', u'ENSMUSG00000024769', u'ENSMUSG00000006728', u'ENSMUSG00000031012', u'ENSMUSG00000009681', u'ENSMUSG00000057230', u'ENSMUSG00000026834', u'ENSMUSG00000069089', u'ENSMUSG00000022433', u'ENSMUSG00000024617', u'ENSMUSG00000007613', u'ENSMUSG00000034218', u'ENSMUSG00000020715', u'ENSMUSG00000061393', u'ENSMUSG00000024830', u'ENSMUSG00000030409', u'ENSMUSG00000050697', u'ENSMUSG00000020827', u'ENSMUSG00000070544', u'ENSMUSG00000045962', u'ENSMUSG00000000532', u'ENSMUSG00000000530', u'ENSMUSG00000026201', u'ENSMUSG00000026207', u'ENSMUSG00000046709', u'ENSMUSG00000028078', u'ENSMUSG00000046707', u'ENSMUSG00000024122', u'ENSMUSG00000038967', u'ENSMUSG00000042064', u'ENSMUSG00000040936', u'ENSMUSG00000000441', u'ENSMUSG00000016179', u'ENSMUSG00000022897', u'ENSMUSG00000031833', u'ENSMUSG00000090100', u'ENSMUSG00000052920', u'ENSMUSG00000048310', u'ENSMUSG00000023050', u'ENSMUSG00000053137', u'ENSMUSG00000032113', u'ENSMUSG00000032440', u'ENSMUSG00000053819', u'ENSMUSG00000003228', u'ENSMUSG00000024404', u'ENSMUSG00000031112', u'ENSMUSG00000022672', u'ENSMUSG00000028756', u'ENSMUSG00000058444', u'ENSMUSG00000053046', u'ENSMUSG00000003644', u'ENSMUSG00000029674', u'ENSMUSG00000034663', u'ENSMUSG00000038145', u'ENSMUSG00000019942', u'ENSMUSG00000039145', u'ENSMUSG00000020694', u'ENSMUSG00000025358', u'ENSMUSG00000029454', u'ENSMUSG00000023809', u'ENSMUSG00000020389', u'ENSMUSG00000021754', u'ENSMUSG00000020385', u'ENSMUSG00000021108', u'ENSMUSG00000020897', u'ENSMUSG00000005034', u'ENSMUSG00000035232', u'ENSMUSG00000060477', u'ENSMUSG00000025758', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000039745', u'ENSMUSG00000045038', u'ENSMUSG00000053693', u'ENSMUSG00000035828', u'ENSMUSG00000028926', u'ENSMUSG00000040390', u'ENSMUSG00000032308', u'ENSMUSG00000026622', u'ENSMUSG00000026620', u'ENSMUSG00000002413', u'ENSMUSG00000061207', u'ENSMUSG00000062234', u'ENSMUSG00000017291', u'ENSMUSG00000030272', u'ENSMUSG00000025854', u'ENSMUSG00000073563', u'ENSMUSG00000031478', u'ENSMUSG00000042349', u'ENSMUSG00000026437', u'ENSMUSG00000040021', u'ENSMUSG00000004936', u'ENSMUSG00000032409', u'ENSMUSG00000031392', u'ENSMUSG00000062044', u'ENSMUSG00000034290', u'ENSMUSG00000029148', u'ENSMUSG00000031155', u'ENSMUSG00000039913', u'ENSMUSG00000078816', u'ENSMUSG00000002688', u'ENSMUSG00000032571', u'ENSMUSG00000002205', u'ENSMUSG00000032577', u'ENSMUSG00000025537', u'ENSMUSG00000040325', u'ENSMUSG00000009772', u'ENSMUSG00000075590', u'ENSMUSG00000030655', u'ENSMUSG00000024290', u'ENSMUSG00000033276', u'ENSMUSG00000036273', u'ENSMUSG00000028862', u'ENSMUSG00000042724', u'ENSMUSG00000024235', u'ENSMUSG00000034751', u'ENSMUSG00000005469', u'ENSMUSG00000001729', u'ENSMUSG00000041135', u'ENSMUSG00000026667', u'ENSMUSG00000020700', u'ENSMUSG00000029403', u'ENSMUSG00000009555', u'ENSMUSG00000034974', u'ENSMUSG00000028228', u'ENSMUSG00000024242', u'ENSMUSG00000041187', u'ENSMUSG00000026749', u'ENSMUSG00000051747', u'ENSMUSG00000018932', u'ENSMUSG00000028969', u'ENSMUSG00000008730', u'ENSMUSG00000038970', u'ENSMUSG00000063410', u'ENSMUSG00000028284', u'ENSMUSG00000031537', u'ENSMUSG00000025162', u'ENSMUSG00000050965', u'ENSMUSG00000003810', u'ENSMUSG00000021279', u'ENSMUSG00000024387', u'ENSMUSG00000020015', u'ENSMUSG00000015133', u'ENSMUSG00000024383', u'ENSMUSG00000031668', u'ENSMUSG00000029062', u'ENSMUSG00000002007', u'ENSMUSG00000052430', u'ENSMUSG00000028959', u'ENSMUSG00000031284', u'ENSMUSG00000021428', u'ENSMUSG00000053436', u'ENSMUSG00000021936', u'ENSMUSG00000022836', u'ENSMUSG00000042854', u'ENSMUSG00000062604', u'ENSMUSG00000020516', u'ENSMUSG00000031065', u'ENSMUSG00000057897', u'ENSMUSG00000029613', u'ENSMUSG00000036737', u'ENSMUSG00000020451', u'ENSMUSG00000021948', u'ENSMUSG00000039954', u'ENSMUSG00000037885', u'ENSMUSG00000025915', u'ENSMUSG00000037738', u'ENSMUSG00000001034', u'ENSMUSG00000027797', u'ENSMUSG00000024079', u'ENSMUSG00000015981', u'ENSMUSG00000024969', u'ENSMUSG00000029334', u'ENSMUSG00000027496', u'ENSMUSG00000037643', u'ENSMUSG00000020941', u'ENSMUSG00000021115', u'ENSMUSG00000020580', u'ENSMUSG00000019699', u'ENSMUSG00000023908', u'ENSMUSG00000004085', u'ENSMUSG00000035683', u'ENSMUSG00000004865', u'ENSMUSG00000030867', u'ENSMUSG00000035112', u'ENSMUSG00000032316', u'ENSMUSG00000007411', u'ENSMUSG00000033966', u'ENSMUSG00000042978', u'ENSMUSG00000026836', u'ENSMUSG00000042249', u'ENSMUSG00000004798', u'ENSMUSG00000031314', u'ENSMUSG00000035064', u'ENSMUSG00000027030', u'ENSMUSG00000030815', u'ENSMUSG00000026034', u'ENSMUSG00000004591', u'ENSMUSG00000027177', u'ENSMUSG00000019235', u'ENSMUSG00000017376', u'ENSMUSG00000032500', u'ENSMUSG00000046947', u'ENSMUSG00000068917', u'ENSMUSG00000063065', u'ENSMUSG00000027379', u'ENSMUSG00000052155', u'ENSMUSG00000017405', u'ENSMUSG00000050890', u'ENSMUSG00000020785', u'ENSMUSG00000020573', u'ENSMUSG00000074923', u'ENSMUSG00000028708', u'ENSMUSG00000001630', u'ENSMUSG00000042608', u'ENSMUSG00000015599', u'ENSMUSG00000034761', u'ENSMUSG00000061578', u'ENSMUSG00000028680', u'ENSMUSG00000029471', u'ENSMUSG00000024952', u'ENSMUSG00000025375', u'ENSMUSG00000028518', u'ENSMUSG00000024558', u'ENSMUSG00000037112', u'ENSMUSG00000035390', u'ENSMUSG00000026778', u'ENSMUSG00000026779', u'ENSMUSG00000028991', u'ENSMUSG00000038481', u'ENSMUSG00000037593', u'ENSMUSG00000021701', u'ENSMUSG00000042046', u'ENSMUSG00000031450', u'ENSMUSG00000005102', u'ENSMUSG00000042567', u'ENSMUSG00000026274', u'ENSMUSG00000026277', u'ENSMUSG00000028458', u'ENSMUSG00000041997', u'ENSMUSG00000031853', u'ENSMUSG00000035027', u'ENSMUSG00000026074', u'ENSMUSG00000052889', u'ENSMUSG00000024070', u'ENSMUSG00000069631', u'ENSMUSG00000021559', u'ENSMUSG00000026094', u'ENSMUSG00000029053', u'ENSMUSG00000031292', u'ENSMUSG00000021796', u'ENSMUSG00000071369', u'ENSMUSG00000021820', u'ENSMUSG00000020115', u'ENSMUSG00000026393', u'ENSMUSG00000021413', u'ENSMUSG00000025199', u'ENSMUSG00000020272', u'ENSMUSG00000038128', u'ENSMUSG00000003345', u'ENSMUSG00000022791', u'ENSMUSG00000003068', u'ENSMUSG00000002948', u'ENSMUSG00000021959', u'ENSMUSG00000021483', u'ENSMUSG00000029283', u'ENSMUSG00000006494', u'ENSMUSG00000034135', u'ENSMUSG00000061436', u'ENSMUSG00000003119', u'ENSMUSG00000022550', u'ENSMUSG00000036707', u'ENSMUSG00000024576', u'ENSMUSG00000030602', u'ENSMUSG00000028630', u'ENSMUSG00000021044', u'ENSMUSG00000037989', u'ENSMUSG00000051590', u'ENSMUSG00000059883', u'ENSMUSG00000020990', u'ENSMUSG00000020857', u'ENSMUSG00000030774', u'ENSMUSG00000041245', u'ENSMUSG00000024858', u'ENSMUSG00000030890', u'ENSMUSG00000002297', u'ENSMUSG00000064090', u'ENSMUSG00000067336', u'ENSMUSG00000021457', u'ENSMUSG00000031309', u'ENSMUSG00000052783', u'ENSMUSG00000031303', u'ENSMUSG00000030397', u'ENSMUSG00000030802', u'ENSMUSG00000022033', u'ENSMUSG00000014426', u'ENSMUSG00000061751', u'ENSMUSG00000020032', u'ENSMUSG00000074698', u'ENSMUSG00000056458', u'ENSMUSG00000033352', u'ENSMUSG00000033985', u'ENSMUSG00000053414', u'ENSMUSG00000001127', u'ENSMUSG00000022329', u'ENSMUSG00000024006', u'ENSMUSG00000021918', u'ENSMUSG00000024002', u'ENSMUSG00000038379', u'ENSMUSG00000019970', u'ENSMUSG00000041297', u'ENSMUSG00000057672', u'ENSMUSG00000022263', u'ENSMUSG00000033618', u'ENSMUSG00000027692', u'ENSMUSG00000022812', u'ENSMUSG00000040274', u'ENSMUSG00000057177', u'ENSMUSG00000063358', u'ENSMUSG00000009828', u'ENSMUSG00000042688', u'ENSMUSG00000024948', u'ENSMUSG00000039725', u'ENSMUSG00000025060', u'ENSMUSG00000025665', u'ENSMUSG00000061462', u'ENSMUSG00000027365']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0004696', 'GO:0004695', 'GO:0004700'])),
    NtGoeaResults(GO='GO:0004675', NS='MF', enrichment='e', name='transmembrane receptor protein serine/threonine kinase activity', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000013766']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000052430', u'ENSMUSG00000013766', u'ENSMUSG00000021796', u'ENSMUSG00000061393', u'ENSMUSG00000052155', u'ENSMUSG00000032440', u'ENSMUSG00000000532', u'ENSMUSG00000026836', u'ENSMUSG00000000530', u'ENSMUSG00000026834', u'ENSMUSG00000007613', u'ENSMUSG00000067336']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004677', NS='MF', enrichment='e', name='DNA-dependent protein kinase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000034218']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000034218', u'ENSMUSG00000022672']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004693', NS='MF', enrichment='e', name='cyclin-dependent protein serine/threonine kinase activity', ratio_in_study=(3, 624), ratio_in_pop=(30, 13836), p_uncorrected=0.15145242773929718, depth=7, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025358', u'ENSMUSG00000019942', u'ENSMUSG00000023067']), pop_n=13836, pop_count=30, pop_items=set([u'ENSMUSG00000034165', u'ENSMUSG00000041297', u'ENSMUSG00000025358', u'ENSMUSG00000031065', u'ENSMUSG00000003119', u'ENSMUSG00000029635', u'ENSMUSG00000069089', u'ENSMUSG00000020389', u'ENSMUSG00000019942', u'ENSMUSG00000031292', u'ENSMUSG00000026437', u'ENSMUSG00000070348', u'ENSMUSG00000038481', u'ENSMUSG00000040274', u'ENSMUSG00000021258', u'ENSMUSG00000033862', u'ENSMUSG00000033966', u'ENSMUSG00000029403', u'ENSMUSG00000020015', u'ENSMUSG00000021548', u'ENSMUSG00000020990', u'ENSMUSG00000056458', u'ENSMUSG00000029062', u'ENSMUSG00000021483', u'ENSMUSG00000023067', u'ENSMUSG00000028926', u'ENSMUSG00000003031', u'ENSMUSG00000006728', u'ENSMUSG00000009555', u'ENSMUSG00000028969']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0016537'])),
    NtGoeaResults(GO='GO:0004694', NS='MF', enrichment='e', name='eukaryotic translation initiation factor 2alpha kinase activity', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024079']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000029613', u'ENSMUSG00000024079', u'ENSMUSG00000031668', u'ENSMUSG00000005102']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004712', NS='MF', enrichment='e', name='protein serine/threonine/tyrosine kinase activity', ratio_in_study=(3, 624), ratio_in_pop=(27, 13836), p_uncorrected=0.12013868061444093, depth=6, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020897', u'ENSMUSG00000027496', u'ENSMUSG00000038379']), pop_n=13836, pop_count=27, pop_items=set([u'ENSMUSG00000038379', u'ENSMUSG00000061393', u'ENSMUSG00000020516', u'ENSMUSG00000022897', u'ENSMUSG00000028518', u'ENSMUSG00000016526', u'ENSMUSG00000023809', u'ENSMUSG00000019577', u'ENSMUSG00000020385', u'ENSMUSG00000028630', u'ENSMUSG00000002409', u'ENSMUSG00000005469', u'ENSMUSG00000004936', u'ENSMUSG00000032316', u'ENSMUSG00000068917', u'ENSMUSG00000026034', u'ENSMUSG00000020897', u'ENSMUSG00000042046', u'ENSMUSG00000022791', u'ENSMUSG00000001729', u'ENSMUSG00000078816', u'ENSMUSG00000003644', u'ENSMUSG00000033985', u'ENSMUSG00000019970', u'ENSMUSG00000028458', u'ENSMUSG00000027496', u'ENSMUSG00000035027']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004713', NS='MF', enrichment='p', name='protein tyrosine kinase activity', ratio_in_study=(4, 624), ratio_in_pop=(94, 13836), p_uncorrected=1.0, depth=6, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024079', u'ENSMUSG00000006445', u'ENSMUSG00000038379', u'ENSMUSG00000002748']), pop_n=13836, pop_count=94, pop_items=set([u'ENSMUSG00000024079', u'ENSMUSG00000027646', u'ENSMUSG00000030110', u'ENSMUSG00000016526', u'ENSMUSG00000031805', u'ENSMUSG00000030849', u'ENSMUSG00000022451', u'ENSMUSG00000020385', u'ENSMUSG00000019471', u'ENSMUSG00000002409', u'ENSMUSG00000019843', u'ENSMUSG00000055471', u'ENSMUSG00000020623', u'ENSMUSG00000059146', u'ENSMUSG00000022791', u'ENSMUSG00000005958', u'ENSMUSG00000002948', u'ENSMUSG00000042228', u'ENSMUSG00000006445', u'ENSMUSG00000028530', u'ENSMUSG00000055540', u'ENSMUSG00000004933', u'ENSMUSG00000052504', u'ENSMUSG00000005672', u'ENSMUSG00000029231', u'ENSMUSG00000031644', u'ENSMUSG00000050271', u'ENSMUSG00000006386', u'ENSMUSG00000028630', u'ENSMUSG00000004936', u'ENSMUSG00000032316', u'ENSMUSG00000032312', u'ENSMUSG00000062209', u'ENSMUSG00000031016', u'ENSMUSG00000020357', u'ENSMUSG00000003283', u'ENSMUSG00000014361', u'ENSMUSG00000024789', u'ENSMUSG00000026235', u'ENSMUSG00000026034', u'ENSMUSG00000020122', u'ENSMUSG00000074305', u'ENSMUSG00000009376', u'ENSMUSG00000042817', u'ENSMUSG00000024620', u'ENSMUSG00000026842', u'ENSMUSG00000026596', u'ENSMUSG00000021457', u'ENSMUSG00000029245', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000028661', u'ENSMUSG00000002602', u'ENSMUSG00000053158', u'ENSMUSG00000024621', u'ENSMUSG00000062960', u'ENSMUSG00000032175', u'ENSMUSG00000014932', u'ENSMUSG00000068917', u'ENSMUSG00000027297', u'ENSMUSG00000027298', u'ENSMUSG00000033352', u'ENSMUSG00000024247', u'ENSMUSG00000022607', u'ENSMUSG00000033985', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000028874', u'ENSMUSG00000028876', u'ENSMUSG00000062312', u'ENSMUSG00000051747', u'ENSMUSG00000033191', u'ENSMUSG00000018932', u'ENSMUSG00000003534', u'ENSMUSG00000026674', u'ENSMUSG00000038379', u'ENSMUSG00000022897', u'ENSMUSG00000028289', u'ENSMUSG00000025375', u'ENSMUSG00000005534', u'ENSMUSG00000005533', u'ENSMUSG00000031565', u'ENSMUSG00000029648', u'ENSMUSG00000000127', u'ENSMUSG00000002748', u'ENSMUSG00000021270', u'ENSMUSG00000042046', u'ENSMUSG00000029217', u'ENSMUSG00000058444', u'ENSMUSG00000055254', u'ENSMUSG00000054252', u'ENSMUSG00000028458', u'ENSMUSG00000032537', u'ENSMUSG00000035027']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0004718'])),
    NtGoeaResults(GO='GO:0004714', NS='MF', enrichment='p', name='transmembrane receptor protein tyrosine kinase activity', ratio_in_study=(1, 624), ratio_in_pop=(44, 13836), p_uncorrected=0.7225579603145144, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000006445']), pop_n=13836, pop_count=44, pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000032537', u'ENSMUSG00000026674', u'ENSMUSG00000042817', u'ENSMUSG00000005958', u'ENSMUSG00000006386', u'ENSMUSG00000028289', u'ENSMUSG00000029245', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000005534', u'ENSMUSG00000005672', u'ENSMUSG00000028661', u'ENSMUSG00000005533', u'ENSMUSG00000029231', u'ENSMUSG00000030849', u'ENSMUSG00000032547', u'ENSMUSG00000002602', u'ENSMUSG00000031565', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000018166', u'ENSMUSG00000055254', u'ENSMUSG00000062312', u'ENSMUSG00000035305', u'ENSMUSG00000062209', u'ENSMUSG00000055471', u'ENSMUSG00000029648', u'ENSMUSG00000059146', u'ENSMUSG00000020357', u'ENSMUSG00000027297', u'ENSMUSG00000014361', u'ENSMUSG00000027298', u'ENSMUSG00000006445', u'ENSMUSG00000055540', u'ENSMUSG00000062960', u'ENSMUSG00000054252', u'ENSMUSG00000028876', u'ENSMUSG00000026235', u'ENSMUSG00000033191', u'ENSMUSG00000030110', u'ENSMUSG00000020122', u'ENSMUSG00000003534', u'ENSMUSG00000052504']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004715', NS='MF', enrichment='e', name='non-membrane spanning protein tyrosine kinase activity', ratio_in_study=(3, 624), ratio_in_pop=(36, 13836), p_uncorrected=0.22027003562402103, depth=7, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000035683', u'ENSMUSG00000024079', u'ENSMUSG00000002748']), pop_n=13836, pop_count=36, pop_items=set([u'ENSMUSG00000004837', u'ENSMUSG00000028874', u'ENSMUSG00000026842', u'ENSMUSG00000026596', u'ENSMUSG00000021457', u'ENSMUSG00000022897', u'ENSMUSG00000021948', u'ENSMUSG00000035683', u'ENSMUSG00000050271', u'ENSMUSG00000053158', u'ENSMUSG00000027646', u'ENSMUSG00000000127', u'ENSMUSG00000031805', u'ENSMUSG00000002748', u'ENSMUSG00000026201', u'ENSMUSG00000032175', u'ENSMUSG00000019843', u'ENSMUSG00000041135', u'ENSMUSG00000004933', u'ENSMUSG00000059923', u'ENSMUSG00000031016', u'ENSMUSG00000024079', u'ENSMUSG00000032312', u'ENSMUSG00000024789', u'ENSMUSG00000022791', u'ENSMUSG00000029217', u'ENSMUSG00000042228', u'ENSMUSG00000028530', u'ENSMUSG00000024247', u'ENSMUSG00000022372', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000003283', u'ENSMUSG00000014932', u'ENSMUSG00000074305']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004721', NS='MF', enrichment='p', name='phosphoprotein phosphatase activity', ratio_in_study=(4, 624), ratio_in_pop=(119, 13836), p_uncorrected=0.822427363041095, depth=6, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000031506', u'ENSMUSG00000020525', u'ENSMUSG00000032477', u'ENSMUSG00000037544']), pop_n=13836, pop_count=119, pop_items=set([u'ENSMUSG00000027784', u'ENSMUSG00000069255', u'ENSMUSG00000026659', u'ENSMUSG00000027540', u'ENSMUSG00000009630', u'ENSMUSG00000030697', u'ENSMUSG00000028771', u'ENSMUSG00000027303', u'ENSMUSG00000004266', u'ENSMUSG00000055493', u'ENSMUSG00000047067', u'ENSMUSG00000013236', u'ENSMUSG00000038582', u'ENSMUSG00000037887', u'ENSMUSG00000033953', u'ENSMUSG00000026395', u'ENSMUSG00000033411', u'ENSMUSG00000039661', u'ENSMUSG00000022092', u'ENSMUSG00000037003', u'ENSMUSG00000047205', u'ENSMUSG00000033323', u'ENSMUSG00000026309', u'ENSMUSG00000031506', u'ENSMUSG00000032020', u'ENSMUSG00000026384', u'ENSMUSG00000021816', u'ENSMUSG00000025932', u'ENSMUSG00000019889', u'ENSMUSG00000013663', u'ENSMUSG00000065979', u'ENSMUSG00000030223', u'ENSMUSG00000041231', u'ENSMUSG00000027001', u'ENSMUSG00000056553', u'ENSMUSG00000037544', u'ENSMUSG00000028886', u'ENSMUSG00000040385', u'ENSMUSG00000061130', u'ENSMUSG00000024190', u'ENSMUSG00000028528', u'ENSMUSG00000038764', u'ENSMUSG00000019907', u'ENSMUSG00000038042', u'ENSMUSG00000033773', u'ENSMUSG00000028399', u'ENSMUSG00000020525', u'ENSMUSG00000029147', u'ENSMUSG00000043733', u'ENSMUSG00000043445', u'ENSMUSG00000034354', u'ENSMUSG00000029038', u'ENSMUSG00000037926', u'ENSMUSG00000032477', u'ENSMUSG00000047409', u'ENSMUSG00000026604', u'ENSMUSG00000021745', u'ENSMUSG00000003518', u'ENSMUSG00000063235', u'ENSMUSG00000049999', u'ENSMUSG00000020349', u'ENSMUSG00000059895', u'ENSMUSG00000046794', u'ENSMUSG00000044573', u'ENSMUSG00000034613', u'ENSMUSG00000028788', u'ENSMUSG00000053716', u'ENSMUSG00000044340', u'ENSMUSG00000034616', u'ENSMUSG00000033278', u'ENSMUSG00000024539', u'ENSMUSG00000026126', u'ENSMUSG00000042121', u'ENSMUSG00000027330', u'ENSMUSG00000026753', u'ENSMUSG00000020154', u'ENSMUSG00000020151', u'ENSMUSG00000002103', u'ENSMUSG00000033295', u'ENSMUSG00000039384', u'ENSMUSG00000036504', u'ENSMUSG00000018559', u'ENSMUSG00000026181', u'ENSMUSG00000031337', u'ENSMUSG00000021096', u'ENSMUSG00000033102', u'ENSMUSG00000031732', u'ENSMUSG00000025314', u'ENSMUSG00000041836', u'ENSMUSG00000010461', u'ENSMUSG00000053141', u'ENSMUSG00000032290', u'ENSMUSG00000034765', u'ENSMUSG00000003438', u'ENSMUSG00000037826', u'ENSMUSG00000021009', u'ENSMUSG00000033502', u'ENSMUSG00000078429', u'ENSMUSG00000031530', u'ENSMUSG00000046442', u'ENSMUSG00000034573', u'ENSMUSG00000042662', u'ENSMUSG00000014956', u'ENSMUSG00000067279', u'ENSMUSG00000026064', u'ENSMUSG00000049225', u'ENSMUSG00000029500', u'ENSMUSG00000020253', u'ENSMUSG00000068748', u'ENSMUSG00000018648', u'ENSMUSG00000002329', u'ENSMUSG00000003099', u'ENSMUSG00000018401', u'ENSMUSG00000028909', u'ENSMUSG00000030854', u'ENSMUSG00000036057', u'ENSMUSG00000028161', u'ENSMUSG00000026176', u'ENSMUSG00000019960']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004722', NS='MF', enrichment='p', name='protein serine/threonine phosphatase activity', ratio_in_study=(1, 624), ratio_in_pop=(42, 13836), p_uncorrected=0.9999999999909562, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020525']), pop_n=13836, pop_count=42, pop_items=set([u'ENSMUSG00000037826', u'ENSMUSG00000027784', u'ENSMUSG00000061130', u'ENSMUSG00000013663', u'ENSMUSG00000020349', u'ENSMUSG00000034613', u'ENSMUSG00000041231', u'ENSMUSG00000004455', u'ENSMUSG00000009630', u'ENSMUSG00000030697', u'ENSMUSG00000033502', u'ENSMUSG00000026181', u'ENSMUSG00000044340', u'ENSMUSG00000029120', u'ENSMUSG00000022052', u'ENSMUSG00000055493', u'ENSMUSG00000014956', u'ENSMUSG00000041769', u'ENSMUSG00000048371', u'ENSMUSG00000026753', u'ENSMUSG00000049225', u'ENSMUSG00000020253', u'ENSMUSG00000007564', u'ENSMUSG00000033773', u'ENSMUSG00000028013', u'ENSMUSG00000003438', u'ENSMUSG00000018559', u'ENSMUSG00000020525', u'ENSMUSG00000046442', u'ENSMUSG00000029147', u'ENSMUSG00000021096', u'ENSMUSG00000033102', u'ENSMUSG00000024500', u'ENSMUSG00000031732', u'ENSMUSG00000034354', u'ENSMUSG00000018401', u'ENSMUSG00000026309', u'ENSMUSG00000028161', u'ENSMUSG00000040385', u'ENSMUSG00000020092', u'ENSMUSG00000021816', u'ENSMUSG00000022414']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0000158', 'GO:0000163', 'GO:0030360', 'GO:0015071', 'GO:0030361', 'GO:0030357', 'GO:0008600', 'GO:0030358', 'GO:0008598'])),
    NtGoeaResults(GO='GO:0004724', NS='MF', enrichment='e', name='magnesium-dependent protein serine/threonine phosphatase activity', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020525']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000049225', u'ENSMUSG00000020525', u'ENSMUSG00000048371']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004725', NS='MF', enrichment='p', name='protein tyrosine phosphatase activity', ratio_in_study=(2, 624), ratio_in_pop=(81, 13836), p_uncorrected=0.5879638905977268, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000031506', u'ENSMUSG00000032477']), pop_n=13836, pop_count=81, pop_items=set([u'ENSMUSG00000025932', u'ENSMUSG00000036057', u'ENSMUSG00000013663', u'ENSMUSG00000039431', u'ENSMUSG00000053141', u'ENSMUSG00000027540', u'ENSMUSG00000027330', u'ENSMUSG00000059895', u'ENSMUSG00000039661', u'ENSMUSG00000041836', u'ENSMUSG00000021009', u'ENSMUSG00000013236', u'ENSMUSG00000034354', u'ENSMUSG00000042662', u'ENSMUSG00000034765', u'ENSMUSG00000038042', u'ENSMUSG00000044573', u'ENSMUSG00000028528', u'ENSMUSG00000028788', u'ENSMUSG00000027001', u'ENSMUSG00000030002', u'ENSMUSG00000053716', u'ENSMUSG00000028886', u'ENSMUSG00000004266', u'ENSMUSG00000034573', u'ENSMUSG00000033278', u'ENSMUSG00000055493', u'ENSMUSG00000024539', u'ENSMUSG00000024190', u'ENSMUSG00000026126', u'ENSMUSG00000038764', u'ENSMUSG00000042121', u'ENSMUSG00000019960', u'ENSMUSG00000069255', u'ENSMUSG00000037887', u'ENSMUSG00000020154', u'ENSMUSG00000033102', u'ENSMUSG00000026064', u'ENSMUSG00000015214', u'ENSMUSG00000020151', u'ENSMUSG00000030223', u'ENSMUSG00000030269', u'ENSMUSG00000047067', u'ENSMUSG00000033295', u'ENSMUSG00000034616', u'ENSMUSG00000039384', u'ENSMUSG00000037926', u'ENSMUSG00000028274', u'ENSMUSG00000028399', u'ENSMUSG00000032020', u'ENSMUSG00000021987', u'ENSMUSG00000028771', u'ENSMUSG00000068748', u'ENSMUSG00000019889', u'ENSMUSG00000043733', u'ENSMUSG00000032477', u'ENSMUSG00000056553', u'ENSMUSG00000018648', u'ENSMUSG00000043445', u'ENSMUSG00000025314', u'ENSMUSG00000002329', u'ENSMUSG00000031530', u'ENSMUSG00000018401', u'ENSMUSG00000047205', u'ENSMUSG00000010461', u'ENSMUSG00000027303', u'ENSMUSG00000030854', u'ENSMUSG00000031337', u'ENSMUSG00000033502', u'ENSMUSG00000031918', u'ENSMUSG00000026384', u'ENSMUSG00000028909', u'ENSMUSG00000020092', u'ENSMUSG00000031506', u'ENSMUSG00000026604', u'ENSMUSG00000021745', u'ENSMUSG00000032290', u'ENSMUSG00000026395', u'ENSMUSG00000003518', u'ENSMUSG00000003438', u'ENSMUSG00000063235']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004748', NS='MF', enrichment='e', name='ribonucleoside-diphosphate reductase activity, thioredoxin disulfide as acceptor', ratio_in_study=(2, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.005909998133444449, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.22584533013109129, study_items=set([u'ENSMUSG00000030978', u'ENSMUSG00000020649']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000022292', u'ENSMUSG00000020649', u'ENSMUSG00000030978']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0016959', 'GO:0016961', 'GO:0016960'])),
    NtGoeaResults(GO='GO:0004758', NS='MF', enrichment='e', name='serine C-palmitoyltransferase activity', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000021036']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000021036', u'ENSMUSG00000021468', u'ENSMUSG00000044408']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004797', NS='MF', enrichment='e', name='thymidine kinase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000025574']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000035824', u'ENSMUSG00000025574']), study_n=624, level=8, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004798', NS='MF', enrichment='e', name='thymidylate kinase activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026281']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000026281', u'ENSMUSG00000020638']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004799', NS='MF', enrichment='e', name='thymidylate synthase activity', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000025747']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000025747']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004839', NS='MF', enrichment='e', name='ubiquitin activating enzyme activity', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032596']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000001924', u'ENSMUSG00000032596', u'ENSMUSG00000035898']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004842', NS='MF', enrichment='e', name='ubiquitin-protein transferase activity', ratio_in_study=(19, 624), ratio_in_pop=(293, 13836), p_uncorrected=0.11493140959491253, depth=4, study_count=19, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032586', u'ENSMUSG00000001228', u'ENSMUSG00000032596', u'ENSMUSG00000001403', u'ENSMUSG00000075502', u'ENSMUSG00000072082', u'ENSMUSG00000035293', u'ENSMUSG00000037474', u'ENSMUSG00000054115', u'ENSMUSG00000020184', u'ENSMUSG00000070327', u'ENSMUSG00000017716', u'ENSMUSG00000023307', u'ENSMUSG00000049502', u'ENSMUSG00000005566', u'ENSMUSG00000017146', u'ENSMUSG00000026196', u'ENSMUSG00000006418', u'ENSMUSG00000036822']), pop_n=13836, pop_count=293, pop_items=set([u'ENSMUSG00000040363', u'ENSMUSG00000040746', u'ENSMUSG00000020307', u'ENSMUSG00000027466', u'ENSMUSG00000024073', u'ENSMUSG00000039753', u'ENSMUSG00000044231', u'ENSMUSG00000021712', u'ENSMUSG00000036432', u'ENSMUSG00000022400', u'ENSMUSG00000039615', u'ENSMUSG00000074781', u'ENSMUSG00000029458', u'ENSMUSG00000030750', u'ENSMUSG00000020455', u'ENSMUSG00000029203', u'ENSMUSG00000072082', u'ENSMUSG00000074001', u'ENSMUSG00000066640', u'ENSMUSG00000020305', u'ENSMUSG00000040410', u'ENSMUSG00000038784', u'ENSMUSG00000046861', u'ENSMUSG00000025612', u'ENSMUSG00000036964', u'ENSMUSG00000029922', u'ENSMUSG00000027272', u'ENSMUSG00000017146', u'ENSMUSG00000057143', u'ENSMUSG00000022771', u'ENSMUSG00000015120', u'ENSMUSG00000015127', u'ENSMUSG00000020064', u'ENSMUSG00000020376', u'ENSMUSG00000052299', u'ENSMUSG00000058446', u'ENSMUSG00000041740', u'ENSMUSG00000020627', u'ENSMUSG00000055707', u'ENSMUSG00000079562', u'ENSMUSG00000020184', u'ENSMUSG00000020271', u'ENSMUSG00000030685', u'ENSMUSG00000005566', u'ENSMUSG00000025326', u'ENSMUSG00000041180', u'ENSMUSG00000059890', u'ENSMUSG00000033060', u'ENSMUSG00000042350', u'ENSMUSG00000029833', u'ENSMUSG00000027011', u'ENSMUSG00000055675', u'ENSMUSG00000029110', u'ENSMUSG00000057367', u'ENSMUSG00000027300', u'ENSMUSG00000029798', u'ENSMUSG00000000275', u'ENSMUSG00000025217', u'ENSMUSG00000090112', u'ENSMUSG00000035357', u'ENSMUSG00000033949', u'ENSMUSG00000032309', u'ENSMUSG00000032898', u'ENSMUSG00000066036', u'ENSMUSG00000026429', u'ENSMUSG00000020948', u'ENSMUSG00000001366', u'ENSMUSG00000019850', u'ENSMUSG00000001786', u'ENSMUSG00000024294', u'ENSMUSG00000039372', u'ENSMUSG00000060450', u'ENSMUSG00000038780', u'ENSMUSG00000079259', u'ENSMUSG00000039159', u'ENSMUSG00000030966', u'ENSMUSG00000025939', u'ENSMUSG00000021326', u'ENSMUSG00000059486', u'ENSMUSG00000009293', u'ENSMUSG00000005575', u'ENSMUSG00000026942', u'ENSMUSG00000025034', u'ENSMUSG00000029634', u'ENSMUSG00000023826', u'ENSMUSG00000042115', u'ENSMUSG00000025597', u'ENSMUSG00000025135', u'ENSMUSG00000036989', u'ENSMUSG00000034342', u'ENSMUSG00000078578', u'ENSMUSG00000022552', u'ENSMUSG00000058317', u'ENSMUSG00000047648', u'ENSMUSG00000035293', u'ENSMUSG00000025738', u'ENSMUSG00000040387', u'ENSMUSG00000034636', u'ENSMUSG00000037463', u'ENSMUSG00000004364', u'ENSMUSG00000020134', u'ENSMUSG00000023307', u'ENSMUSG00000048232', u'ENSMUSG00000051675', u'ENSMUSG00000052752', u'ENSMUSG00000036782', u'ENSMUSG00000040785', u'ENSMUSG00000021774', u'ENSMUSG00000079184', u'ENSMUSG00000041000', u'ENSMUSG00000030788', u'ENSMUSG00000038876', u'ENSMUSG00000042807', u'ENSMUSG00000028793', u'ENSMUSG00000037075', u'ENSMUSG00000039911', u'ENSMUSG00000056537', u'ENSMUSG00000029312', u'ENSMUSG00000022637', u'ENSMUSG00000024901', u'ENSMUSG00000015478', u'ENSMUSG00000043881', u'ENSMUSG00000033545', u'ENSMUSG00000035696', u'ENSMUSG00000017615', u'ENSMUSG00000030811', u'ENSMUSG00000030816', u'ENSMUSG00000078945', u'ENSMUSG00000025702', u'ENSMUSG00000025234', u'ENSMUSG00000037474', u'ENSMUSG00000030779', u'ENSMUSG00000028098', u'ENSMUSG00000028086', u'ENSMUSG00000029228', u'ENSMUSG00000020642', u'ENSMUSG00000005371', u'ENSMUSG00000032000', u'ENSMUSG00000063760', u'ENSMUSG00000041556', u'ENSMUSG00000032307', u'ENSMUSG00000052934', u'ENSMUSG00000032586', u'ENSMUSG00000049502', u'ENSMUSG00000028309', u'ENSMUSG00000039100', u'ENSMUSG00000001403', u'ENSMUSG00000021754', u'ENSMUSG00000064145', u'ENSMUSG00000026792', u'ENSMUSG00000006435', u'ENSMUSG00000021301', u'ENSMUSG00000047496', u'ENSMUSG00000038068', u'ENSMUSG00000026196', u'ENSMUSG00000030019', u'ENSMUSG00000017677', u'ENSMUSG00000029060', u'ENSMUSG00000018548', u'ENSMUSG00000020794', u'ENSMUSG00000079557', u'ENSMUSG00000026455', u'ENSMUSG00000025893', u'ENSMUSG00000078234', u'ENSMUSG00000032507', u'ENSMUSG00000018733', u'ENSMUSG00000054115', u'ENSMUSG00000038822', u'ENSMUSG00000015095', u'ENSMUSG00000029397', u'ENSMUSG00000025226', u'ENSMUSG00000014074', u'ENSMUSG00000071203', u'ENSMUSG00000019927', u'ENSMUSG00000066258', u'ENSMUSG00000008167', u'ENSMUSG00000036840', u'ENSMUSG00000022280', u'ENSMUSG00000004018', u'ENSMUSG00000020707', u'ENSMUSG00000036241', u'ENSMUSG00000034177', u'ENSMUSG00000032596', u'ENSMUSG00000033596', u'ENSMUSG00000075502', u'ENSMUSG00000073968', u'ENSMUSG00000044164', u'ENSMUSG00000032867', u'ENSMUSG00000059586', u'ENSMUSG00000002109', u'ENSMUSG00000078942', u'ENSMUSG00000014668', u'ENSMUSG00000031605', u'ENSMUSG00000023977', u'ENSMUSG00000022517', u'ENSMUSG00000036469', u'ENSMUSG00000032244', u'ENSMUSG00000038965', u'ENSMUSG00000062901', u'ENSMUSG00000055850', u'ENSMUSG00000035509', u'ENSMUSG00000027598', u'ENSMUSG00000032216', u'ENSMUSG00000024083', u'ENSMUSG00000035235', u'ENSMUSG00000022358', u'ENSMUSG00000024735', u'ENSMUSG00000022124', u'ENSMUSG00000002222', u'ENSMUSG00000042155', u'ENSMUSG00000025261', u'ENSMUSG00000026219', u'ENSMUSG00000030921', u'ENSMUSG00000024695', u'ENSMUSG00000040351', u'ENSMUSG00000041241', u'ENSMUSG00000047098', u'ENSMUSG00000028557', u'ENSMUSG00000026705', u'ENSMUSG00000040913', u'ENSMUSG00000035949', u'ENSMUSG00000075376', u'ENSMUSG00000027993', u'ENSMUSG00000029474', u'ENSMUSG00000032609', u'ENSMUSG00000047013', u'ENSMUSG00000029577', u'ENSMUSG00000055401', u'ENSMUSG00000025373', u'ENSMUSG00000031751', u'ENSMUSG00000070327', u'ENSMUSG00000060860', u'ENSMUSG00000070923', u'ENSMUSG00000054920', u'ENSMUSG00000044628', u'ENSMUSG00000006418', u'ENSMUSG00000024817', u'ENSMUSG00000030031', u'ENSMUSG00000024589', u'ENSMUSG00000028677', u'ENSMUSG00000032688', u'ENSMUSG00000066892', u'ENSMUSG00000003308', u'ENSMUSG00000090083', u'ENSMUSG00000029686', u'ENSMUSG00000014164', u'ENSMUSG00000029001', u'ENSMUSG00000079658', u'ENSMUSG00000041058', u'ENSMUSG00000052557', u'ENSMUSG00000040102', u'ENSMUSG00000022750', u'ENSMUSG00000031828', u'ENSMUSG00000039000', u'ENSMUSG00000036309', u'ENSMUSG00000038175', u'ENSMUSG00000052656', u'ENSMUSG00000036822', u'ENSMUSG00000037487', u'ENSMUSG00000026484', u'ENSMUSG00000064061', u'ENSMUSG00000025860', u'ENSMUSG00000043929', u'ENSMUSG00000028696', u'ENSMUSG00000039633', u'ENSMUSG00000091896', u'ENSMUSG00000044308', u'ENSMUSG00000031930', u'ENSMUSG00000030451', u'ENSMUSG00000021694', u'ENSMUSG00000073700', u'ENSMUSG00000018363', u'ENSMUSG00000040270', u'ENSMUSG00000035247', u'ENSMUSG00000041961', u'ENSMUSG00000001228', u'ENSMUSG00000020802', u'ENSMUSG00000022184', u'ENSMUSG00000020390', u'ENSMUSG00000036503', u'ENSMUSG00000054792', u'ENSMUSG00000001054', u'ENSMUSG00000026988', u'ENSMUSG00000017716', u'ENSMUSG00000043279', u'ENSMUSG00000027164', u'ENSMUSG00000039686', u'ENSMUSG00000021071', u'ENSMUSG00000020496', u'ENSMUSG00000026171', u'ENSMUSG00000020883', u'ENSMUSG00000016308', u'ENSMUSG00000028986']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0004840', 'GO:0004841'])),
    NtGoeaResults(GO='GO:0004843', NS='MF', enrichment='p', name='thiol-dependent ubiquitin-specific protease activity', ratio_in_study=(2, 624), ratio_in_pop=(66, 13836), p_uncorrected=0.7701690633775816, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028560', u'ENSMUSG00000033364']), pop_n=13836, pop_count=66, pop_items=set([u'ENSMUSG00000054814', u'ENSMUSG00000042506', u'ENSMUSG00000031066', u'ENSMUSG00000000804', u'ENSMUSG00000038250', u'ENSMUSG00000090115', u'ENSMUSG00000031029', u'ENSMUSG00000046034', u'ENSMUSG00000031201', u'ENSMUSG00000022426', u'ENSMUSG00000033364', u'ENSMUSG00000021203', u'ENSMUSG00000045210', u'ENSMUSG00000029592', u'ENSMUSG00000051306', u'ENSMUSG00000026199', u'ENSMUSG00000035713', u'ENSMUSG00000059263', u'ENSMUSG00000029640', u'ENSMUSG00000025616', u'ENSMUSG00000022710', u'ENSMUSG00000047879', u'ENSMUSG00000032010', u'ENSMUSG00000032376', u'ENSMUSG00000032267', u'ENSMUSG00000024767', u'ENSMUSG00000021901', u'ENSMUSG00000022111', u'ENSMUSG00000005204', u'ENSMUSG00000006676', u'ENSMUSG00000025917', u'ENSMUSG00000064289', u'ENSMUSG00000040455', u'ENSMUSG00000032612', u'ENSMUSG00000041161', u'ENSMUSG00000026854', u'ENSMUSG00000018189', u'ENSMUSG00000033909', u'ENSMUSG00000062627', u'ENSMUSG00000043415', u'ENSMUSG00000031154', u'ENSMUSG00000036990', u'ENSMUSG00000043411', u'ENSMUSG00000056342', u'ENSMUSG00000033510', u'ENSMUSG00000028560', u'ENSMUSG00000038712', u'ENSMUSG00000038695', u'ENSMUSG00000038495', u'ENSMUSG00000029223', u'ENSMUSG00000036712', u'ENSMUSG00000046269', u'ENSMUSG00000053483', u'ENSMUSG00000019850', u'ENSMUSG00000030967', u'ENSMUSG00000006906', u'ENSMUSG00000025437', u'ENSMUSG00000022867', u'ENSMUSG00000042444', u'ENSMUSG00000056900', u'ENSMUSG00000046404', u'ENSMUSG00000038429', u'ENSMUSG00000027363', u'ENSMUSG00000031826', u'ENSMUSG00000063317', u'ENSMUSG00000020124']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004857', NS='MF', enrichment='e', name='enzyme inhibitor activity', ratio_in_study=(3, 624), ratio_in_pop=(28, 13836), p_uncorrected=0.13029401230312693, depth=3, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000022906', u'ENSMUSG00000049502', u'ENSMUSG00000001131']), pop_n=13836, pop_count=28, pop_items=set([u'ENSMUSG00000024074', u'ENSMUSG00000026923', u'ENSMUSG00000030317', u'ENSMUSG00000009013', u'ENSMUSG00000038393', u'ENSMUSG00000031387', u'ENSMUSG00000017466', u'ENSMUSG00000056602', u'ENSMUSG00000019907', u'ENSMUSG00000026399', u'ENSMUSG00000001131', u'ENSMUSG00000040479', u'ENSMUSG00000044177', u'ENSMUSG00000020044', u'ENSMUSG00000004931', u'ENSMUSG00000022906', u'ENSMUSG00000029767', u'ENSMUSG00000033712', u'ENSMUSG00000002289', u'ENSMUSG00000016493', u'ENSMUSG00000054162', u'ENSMUSG00000047557', u'ENSMUSG00000063802', u'ENSMUSG00000027859', u'ENSMUSG00000023236', u'ENSMUSG00000060373', u'ENSMUSG00000049502', u'ENSMUSG00000037622']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0048551'])),
    NtGoeaResults(GO='GO:0004860', NS='MF', enrichment='p', name='protein kinase inhibitor activity', ratio_in_study=(1, 624), ratio_in_pop=(47, 13836), p_uncorrected=0.7239562341383725, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000023067']), pop_n=13836, pop_count=47, pop_items=set([u'ENSMUSG00000020027', u'ENSMUSG00000060780', u'ENSMUSG00000043811', u'ENSMUSG00000056153', u'ENSMUSG00000055003', u'ENSMUSG00000013646', u'ENSMUSG00000050587', u'ENSMUSG00000049939', u'ENSMUSG00000003031', u'ENSMUSG00000039737', u'ENSMUSG00000027001', u'ENSMUSG00000045962', u'ENSMUSG00000051652', u'ENSMUSG00000031375', u'ENSMUSG00000029359', u'ENSMUSG00000032501', u'ENSMUSG00000022136', u'ENSMUSG00000031901', u'ENSMUSG00000051146', u'ENSMUSG00000047414', u'ENSMUSG00000014077', u'ENSMUSG00000019929', u'ENSMUSG00000038485', u'ENSMUSG00000048379', u'ENSMUSG00000046447', u'ENSMUSG00000057113', u'ENSMUSG00000049323', u'ENSMUSG00000035268', u'ENSMUSG00000047787', u'ENSMUSG00000051379', u'ENSMUSG00000044715', u'ENSMUSG00000047085', u'ENSMUSG00000052581', u'ENSMUSG00000021892', u'ENSMUSG00000032578', u'ENSMUSG00000045287', u'ENSMUSG00000028600', u'ENSMUSG00000027499', u'ENSMUSG00000037664', u'ENSMUSG00000032475', u'ENSMUSG00000023067', u'ENSMUSG00000037104', u'ENSMUSG00000053113', u'ENSMUSG00000019876', u'ENSMUSG00000050896', u'ENSMUSG00000042846', u'ENSMUSG00000020601']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004861', NS='MF', enrichment='e', name='cyclin-dependent protein serine/threonine kinase inhibitor activity', ratio_in_study=(2, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.04745838570330577, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.82000154659639202, study_items=set([u'ENSMUSG00000028551', u'ENSMUSG00000023067']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000048878', u'ENSMUSG00000037664', u'ENSMUSG00000023067', u'ENSMUSG00000000708', u'ENSMUSG00000043372', u'ENSMUSG00000028551', u'ENSMUSG00000003031', u'ENSMUSG00000031628']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004867', NS='MF', enrichment='p', name='serine-type endopeptidase inhibitor activity', ratio_in_study=(1, 624), ratio_in_pop=(33, 13836), p_uncorrected=1.0, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027315']), pop_n=13836, pop_count=33, pop_items=set([u'ENSMUSG00000024074', u'ENSMUSG00000032959', u'ENSMUSG00000044177', u'ENSMUSG00000060147', u'ENSMUSG00000050074', u'ENSMUSG00000030111', u'ENSMUSG00000022892', u'ENSMUSG00000027834', u'ENSMUSG00000028476', u'ENSMUSG00000021223', u'ENSMUSG00000025650', u'ENSMUSG00000044734', u'ENSMUSG00000026249', u'ENSMUSG00000026315', u'ENSMUSG00000027315', u'ENSMUSG00000023224', u'ENSMUSG00000000753', u'ENSMUSG00000027082', u'ENSMUSG00000030530', u'ENSMUSG00000022766', u'ENSMUSG00000037254', u'ENSMUSG00000031980', u'ENSMUSG00000006522', u'ENSMUSG00000037411', u'ENSMUSG00000045827', u'ENSMUSG00000021091', u'ENSMUSG00000039278', u'ENSMUSG00000046186', u'ENSMUSG00000023336', u'ENSMUSG00000070436', u'ENSMUSG00000025780', u'ENSMUSG00000038224', u'ENSMUSG00000074227']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004869', NS='MF', enrichment='e', name='cysteine-type endopeptidase inhibitor activity', ratio_in_study=(1, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.3087700161198612, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000017716']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000056222', u'ENSMUSG00000005054', u'ENSMUSG00000024073', u'ENSMUSG00000021585', u'ENSMUSG00000017716', u'ENSMUSG00000068129', u'ENSMUSG00000020415', u'ENSMUSG00000027447']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0004870'])),
    NtGoeaResults(GO='GO:0004871', NS='MF', enrichment='p', name='signal transducer activity', ratio_in_study=(9, 624), ratio_in_pop=(298, 13836), p_uncorrected=0.25788445098411844, depth=1, study_count=9, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027699', u'ENSMUSG00000005057', u'ENSMUSG00000025647', u'ENSMUSG00000005413', u'ENSMUSG00000020599', u'ENSMUSG00000067586', u'ENSMUSG00000040033', u'ENSMUSG00000026104', u'ENSMUSG00000063234']), pop_n=13836, pop_count=298, pop_items=set([u'ENSMUSG00000057614', u'ENSMUSG00000042594', u'ENSMUSG00000067377', u'ENSMUSG00000028184', u'ENSMUSG00000045087', u'ENSMUSG00000049148', u'ENSMUSG00000003974', u'ENSMUSG00000034009', u'ENSMUSG00000028108', u'ENSMUSG00000042190', u'ENSMUSG00000042429', u'ENSMUSG00000029454', u'ENSMUSG00000036437', u'ENSMUSG00000016528', u'ENSMUSG00000029055', u'ENSMUSG00000044337', u'ENSMUSG00000045005', u'ENSMUSG00000018500', u'ENSMUSG00000035235', u'ENSMUSG00000038390', u'ENSMUSG00000052229', u'ENSMUSG00000001761', u'ENSMUSG00000040009', u'ENSMUSG00000024462', u'ENSMUSG00000002885', u'ENSMUSG00000037605', u'ENSMUSG00000040003', u'ENSMUSG00000006932', u'ENSMUSG00000053647', u'ENSMUSG00000013033', u'ENSMUSG00000040229', u'ENSMUSG00000037523', u'ENSMUSG00000039358', u'ENSMUSG00000020599', u'ENSMUSG00000036353', u'ENSMUSG00000019843', u'ENSMUSG00000020611', u'ENSMUSG00000050558', u'ENSMUSG00000020591', u'ENSMUSG00000087141', u'ENSMUSG00000048779', u'ENSMUSG00000079227', u'ENSMUSG00000041135', u'ENSMUSG00000000766', u'ENSMUSG00000041380', u'ENSMUSG00000063234', u'ENSMUSG00000032492', u'ENSMUSG00000021408', u'ENSMUSG00000047123', u'ENSMUSG00000049929', u'ENSMUSG00000040495', u'ENSMUSG00000030471', u'ENSMUSG00000027397', u'ENSMUSG00000024960', u'ENSMUSG00000040552', u'ENSMUSG00000021219', u'ENSMUSG00000050511', u'ENSMUSG00000033569', u'ENSMUSG00000046159', u'ENSMUSG00000032259', u'ENSMUSG00000041241', u'ENSMUSG00000056755', u'ENSMUSG00000035283', u'ENSMUSG00000049583', u'ENSMUSG00000033985', u'ENSMUSG00000035431', u'ENSMUSG00000056679', u'ENSMUSG00000026424', u'ENSMUSG00000034330', u'ENSMUSG00000050199', u'ENSMUSG00000023473', u'ENSMUSG00000002147', u'ENSMUSG00000039713', u'ENSMUSG00000032766', u'ENSMUSG00000048240', u'ENSMUSG00000038811', u'ENSMUSG00000038894', u'ENSMUSG00000031486', u'ENSMUSG00000044674', u'ENSMUSG00000021478', u'ENSMUSG00000055762', u'ENSMUSG00000028004', u'ENSMUSG00000071658', u'ENSMUSG00000039844', u'ENSMUSG00000051043', u'ENSMUSG00000031714', u'ENSMUSG00000056529', u'ENSMUSG00000045502', u'ENSMUSG00000043895', u'ENSMUSG00000034342', u'ENSMUSG00000021886', u'ENSMUSG00000019828', u'ENSMUSG00000037014', u'ENSMUSG00000028522', u'ENSMUSG00000032562', u'ENSMUSG00000037089', u'ENSMUSG00000025739', u'ENSMUSG00000000001', u'ENSMUSG00000024211', u'ENSMUSG00000035773', u'ENSMUSG00000045730', u'ENSMUSG00000034730', u'ENSMUSG00000038760', u'ENSMUSG00000020451', u'ENSMUSG00000045318', u'ENSMUSG00000032641', u'ENSMUSG00000027523', u'ENSMUSG00000036904', u'ENSMUSG00000041468', u'ENSMUSG00000016028', u'ENSMUSG00000004394', u'ENSMUSG00000047875', u'ENSMUSG00000032773', u'ENSMUSG00000059456', u'ENSMUSG00000042804', u'ENSMUSG00000039116', u'ENSMUSG00000039059', u'ENSMUSG00000001552', u'ENSMUSG00000028458', u'ENSMUSG00000051212', u'ENSMUSG00000032966', u'ENSMUSG00000044067', u'ENSMUSG00000036402', u'ENSMUSG00000022637', u'ENSMUSG00000038349', u'ENSMUSG00000036834', u'ENSMUSG00000005057', u'ENSMUSG00000068740', u'ENSMUSG00000039106', u'ENSMUSG00000053164', u'ENSMUSG00000091735', u'ENSMUSG00000026322', u'ENSMUSG00000026527', u'ENSMUSG00000024186', u'ENSMUSG00000032577', u'ENSMUSG00000025231', u'ENSMUSG00000053004', u'ENSMUSG00000024182', u'ENSMUSG00000027669', u'ENSMUSG00000030898', u'ENSMUSG00000058488', u'ENSMUSG00000040033', u'ENSMUSG00000044933', u'ENSMUSG00000020122', u'ENSMUSG00000022022', u'ENSMUSG00000037872', u'ENSMUSG00000031955', u'ENSMUSG00000024998', u'ENSMUSG00000038607', u'ENSMUSG00000033446', u'ENSMUSG00000045613', u'ENSMUSG00000031021', u'ENSMUSG00000051177', u'ENSMUSG00000049511', u'ENSMUSG00000053253', u'ENSMUSG00000046961', u'ENSMUSG00000021303', u'ENSMUSG00000029090', u'ENSMUSG00000029713', u'ENSMUSG00000028782', u'ENSMUSG00000068220', u'ENSMUSG00000031748', u'ENSMUSG00000032360', u'ENSMUSG00000039904', u'ENSMUSG00000027584', u'ENSMUSG00000079037', u'ENSMUSG00000020919', u'ENSMUSG00000036273', u'ENSMUSG00000040125', u'ENSMUSG00000028096', u'ENSMUSG00000010660', u'ENSMUSG00000024620', u'ENSMUSG00000045967', u'ENSMUSG00000031785', u'ENSMUSG00000024425', u'ENSMUSG00000034997', u'ENSMUSG00000045875', u'ENSMUSG00000000149', u'ENSMUSG00000049791', u'ENSMUSG00000038668', u'ENSMUSG00000047904', u'ENSMUSG00000050541', u'ENSMUSG00000018634', u'ENSMUSG00000048216', u'ENSMUSG00000047415', u'ENSMUSG00000027699', u'ENSMUSG00000022297', u'ENSMUSG00000027335', u'ENSMUSG00000021721', u'ENSMUSG00000030890', u'ENSMUSG00000043398', u'ENSMUSG00000040836', u'ENSMUSG00000050288', u'ENSMUSG00000037788', u'ENSMUSG00000022514', u'ENSMUSG00000030245', u'ENSMUSG00000032192', u'ENSMUSG00000007989', u'ENSMUSG00000046668', u'ENSMUSG00000021096', u'ENSMUSG00000052821', u'ENSMUSG00000018334', u'ENSMUSG00000050783', u'ENSMUSG00000025647', u'ENSMUSG00000022607', u'ENSMUSG00000031932', u'ENSMUSG00000005413', u'ENSMUSG00000030733', u'ENSMUSG00000024524', u'ENSMUSG00000026749', u'ENSMUSG00000050953', u'ENSMUSG00000028172', u'ENSMUSG00000047259', u'ENSMUSG00000022122', u'ENSMUSG00000055980', u'ENSMUSG00000049112', u'ENSMUSG00000024639', u'ENSMUSG00000060735', u'ENSMUSG00000074939', u'ENSMUSG00000011171', u'ENSMUSG00000049649', u'ENSMUSG00000069170', u'ENSMUSG00000032911', u'ENSMUSG00000023192', u'ENSMUSG00000039167', u'ENSMUSG00000032570', u'ENSMUSG00000048965', u'ENSMUSG00000044014', u'ENSMUSG00000040016', u'ENSMUSG00000029778', u'ENSMUSG00000016933', u'ENSMUSG00000061578', u'ENSMUSG00000027568', u'ENSMUSG00000036299', u'ENSMUSG00000057193', u'ENSMUSG00000034781', u'ENSMUSG00000008734', u'ENSMUSG00000041075', u'ENSMUSG00000062585', u'ENSMUSG00000045382', u'ENSMUSG00000022500', u'ENSMUSG00000024798', u'ENSMUSG00000031616', u'ENSMUSG00000050534', u'ENSMUSG00000027765', u'ENSMUSG00000023050', u'ENSMUSG00000039809', u'ENSMUSG00000032688', u'ENSMUSG00000052336', u'ENSMUSG00000043999', u'ENSMUSG00000024091', u'ENSMUSG00000020937', u'ENSMUSG00000004730', u'ENSMUSG00000036357', u'ENSMUSG00000022757', u'ENSMUSG00000035798', u'ENSMUSG00000063239', u'ENSMUSG00000002233', u'ENSMUSG00000036362', u'ENSMUSG00000059588', u'ENSMUSG00000026104', u'ENSMUSG00000032528', u'ENSMUSG00000068696', u'ENSMUSG00000043659', u'ENSMUSG00000045092', u'ENSMUSG00000044288', u'ENSMUSG00000034987', u'ENSMUSG00000066839', u'ENSMUSG00000021701', u'ENSMUSG00000040133', u'ENSMUSG00000058396', u'ENSMUSG00000034792', u'ENSMUSG00000067586', u'ENSMUSG00000068037', u'ENSMUSG00000036686', u'ENSMUSG00000029060', u'ENSMUSG00000029064', u'ENSMUSG00000048376', u'ENSMUSG00000040061', u'ENSMUSG00000038910', u'ENSMUSG00000003099', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000031328', u'ENSMUSG00000029674', u'ENSMUSG00000027164', u'ENSMUSG00000018819', u'ENSMUSG00000046793', u'ENSMUSG00000050164', u'ENSMUSG00000020921', u'ENSMUSG00000041907', u'ENSMUSG00000026173', u'ENSMUSG00000025575', u'ENSMUSG00000015133', u'ENSMUSG00000043004', u'ENSMUSG00000026072', u'ENSMUSG00000040372', u'ENSMUSG00000031887']), study_n=624, level=1, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0009370', 'GO:0005062', 'GO:0009369'])),
    NtGoeaResults(GO='GO:0004872', NS='MF', enrichment='e', name='receptor activity', ratio_in_study=(5, 624), ratio_in_pop=(104, 13836), p_uncorrected=0.811065728506168, depth=2, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000049401', u'ENSMUSG00000034457', u'ENSMUSG00000006411', u'ENSMUSG00000025089', u'ENSMUSG00000021624']), pop_n=13836, pop_count=104, pop_items=set([u'ENSMUSG00000017210', u'ENSMUSG00000026712', u'ENSMUSG00000013833', u'ENSMUSG00000015355', u'ENSMUSG00000026959', u'ENSMUSG00000003378', u'ENSMUSG00000059003', u'ENSMUSG00000051790', u'ENSMUSG00000025993', u'ENSMUSG00000001827', u'ENSMUSG00000018160', u'ENSMUSG00000001985', u'ENSMUSG00000001986', u'ENSMUSG00000022656', u'ENSMUSG00000041078', u'ENSMUSG00000022935', u'ENSMUSG00000020758', u'ENSMUSG00000031639', u'ENSMUSG00000038622', u'ENSMUSG00000030209', u'ENSMUSG00000020372', u'ENSMUSG00000030168', u'ENSMUSG00000079487', u'ENSMUSG00000029338', u'ENSMUSG00000025089', u'ENSMUSG00000027878', u'ENSMUSG00000056073', u'ENSMUSG00000026158', u'ENSMUSG00000071068', u'ENSMUSG00000043811', u'ENSMUSG00000023909', u'ENSMUSG00000022383', u'ENSMUSG00000032340', u'ENSMUSG00000064127', u'ENSMUSG00000022999', u'ENSMUSG00000063887', u'ENSMUSG00000015468', u'ENSMUSG00000029468', u'ENSMUSG00000027312', u'ENSMUSG00000006386', u'ENSMUSG00000032012', u'ENSMUSG00000027316', u'ENSMUSG00000034730', u'ENSMUSG00000026726', u'ENSMUSG00000020734', u'ENSMUSG00000029426', u'ENSMUSG00000033777', u'ENSMUSG00000034297', u'ENSMUSG00000020524', u'ENSMUSG00000034353', u'ENSMUSG00000026457', u'ENSMUSG00000034457', u'ENSMUSG00000043962', u'ENSMUSG00000002771', u'ENSMUSG00000021978', u'ENSMUSG00000026923', u'ENSMUSG00000021451', u'ENSMUSG00000027422', u'ENSMUSG00000028664', u'ENSMUSG00000031302', u'ENSMUSG00000031007', u'ENSMUSG00000079037', u'ENSMUSG00000032017', u'ENSMUSG00000025892', u'ENSMUSG00000032076', u'ENSMUSG00000060548', u'ENSMUSG00000021624', u'ENSMUSG00000028073', u'ENSMUSG00000025809', u'ENSMUSG00000050896', u'ENSMUSG00000071424', u'ENSMUSG00000036078', u'ENSMUSG00000045287', u'ENSMUSG00000033981', u'ENSMUSG00000026469', u'ENSMUSG00000031935', u'ENSMUSG00000056962', u'ENSMUSG00000031751', u'ENSMUSG00000049401', u'ENSMUSG00000055725', u'ENSMUSG00000033420', u'ENSMUSG00000006411', u'ENSMUSG00000022661', u'ENSMUSG00000079298', u'ENSMUSG00000032440', u'ENSMUSG00000040511', u'ENSMUSG00000062300', u'ENSMUSG00000022817', u'ENSMUSG00000038486', u'ENSMUSG00000039005', u'ENSMUSG00000031111', u'ENSMUSG00000064115', u'ENSMUSG00000041688', u'ENSMUSG00000020689', u'ENSMUSG00000000290', u'ENSMUSG00000054793', u'ENSMUSG00000032125', u'ENSMUSG00000027995', u'ENSMUSG00000027070', u'ENSMUSG00000032327', u'ENSMUSG00000022109', u'ENSMUSG00000005338', u'ENSMUSG00000038146', u'ENSMUSG00000022103']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0019041'])),
    NtGoeaResults(GO='GO:0004908', NS='MF', enrichment='e', name='interleukin-1 receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(3, 13836), p_uncorrected=0.1292979097870594, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026069']), pop_n=13836, pop_count=3, pop_items=set([u'ENSMUSG00000022514', u'ENSMUSG00000026069', u'ENSMUSG00000026072']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0004930', NS='MF', enrichment='p', name='G-protein coupled receptor activity', ratio_in_study=(2, 624), ratio_in_pop=(167, 13836), p_uncorrected=0.036369849844842074, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000067586', u'ENSMUSG00000063234']), pop_n=13836, pop_count=167, pop_items=set([u'ENSMUSG00000028184', u'ENSMUSG00000045087', u'ENSMUSG00000003974', u'ENSMUSG00000034009', u'ENSMUSG00000042190', u'ENSMUSG00000056679', u'ENSMUSG00000036437', u'ENSMUSG00000044337', u'ENSMUSG00000045005', u'ENSMUSG00000018500', u'ENSMUSG00000038390', u'ENSMUSG00000052229', u'ENSMUSG00000001761', u'ENSMUSG00000024462', u'ENSMUSG00000002885', u'ENSMUSG00000013033', u'ENSMUSG00000040229', u'ENSMUSG00000039358', u'ENSMUSG00000041075', u'ENSMUSG00000050783', u'ENSMUSG00000050558', u'ENSMUSG00000020591', u'ENSMUSG00000048779', u'ENSMUSG00000000766', u'ENSMUSG00000041380', u'ENSMUSG00000032492', u'ENSMUSG00000058396', u'ENSMUSG00000049929', u'ENSMUSG00000040495', u'ENSMUSG00000045502', u'ENSMUSG00000023830', u'ENSMUSG00000052917', u'ENSMUSG00000040552', u'ENSMUSG00000050511', u'ENSMUSG00000052821', u'ENSMUSG00000035283', u'ENSMUSG00000056755', u'ENSMUSG00000040016', u'ENSMUSG00000035431', u'ENSMUSG00000056492', u'ENSMUSG00000026424', u'ENSMUSG00000023473', u'ENSMUSG00000041468', u'ENSMUSG00000042429', u'ENSMUSG00000031486', u'ENSMUSG00000021478', u'ENSMUSG00000028004', u'ENSMUSG00000051043', u'ENSMUSG00000062585', u'ENSMUSG00000056529', u'ENSMUSG00000043895', u'ENSMUSG00000044288', u'ENSMUSG00000021886', u'ENSMUSG00000019828', u'ENSMUSG00000037014', u'ENSMUSG00000027004', u'ENSMUSG00000050164', u'ENSMUSG00000024211', u'ENSMUSG00000045730', u'ENSMUSG00000034730', u'ENSMUSG00000038760', u'ENSMUSG00000032641', u'ENSMUSG00000036904', u'ENSMUSG00000046793', u'ENSMUSG00000016028', u'ENSMUSG00000049583', u'ENSMUSG00000032773', u'ENSMUSG00000042804', u'ENSMUSG00000039059', u'ENSMUSG00000051212', u'ENSMUSG00000044067', u'ENSMUSG00000044674', u'ENSMUSG00000046159', u'ENSMUSG00000053164', u'ENSMUSG00000091735', u'ENSMUSG00000026322', u'ENSMUSG00000032360', u'ENSMUSG00000034987', u'ENSMUSG00000036362', u'ENSMUSG00000040133', u'ENSMUSG00000053004', u'ENSMUSG00000030898', u'ENSMUSG00000063239', u'ENSMUSG00000044933', u'ENSMUSG00000039116', u'ENSMUSG00000037872', u'ENSMUSG00000079227', u'ENSMUSG00000063234', u'ENSMUSG00000033446', u'ENSMUSG00000053647', u'ENSMUSG00000039106', u'ENSMUSG00000032259', u'ENSMUSG00000046961', u'ENSMUSG00000029090', u'ENSMUSG00000028782', u'ENSMUSG00000039904', u'ENSMUSG00000027584', u'ENSMUSG00000047259', u'ENSMUSG00000040125', u'ENSMUSG00000045613', u'ENSMUSG00000045967', u'ENSMUSG00000031785', u'ENSMUSG00000035773', u'ENSMUSG00000034997', u'ENSMUSG00000045875', u'ENSMUSG00000027335', u'ENSMUSG00000049791', u'ENSMUSG00000038668', u'ENSMUSG00000047904', u'ENSMUSG00000018634', u'ENSMUSG00000048216', u'ENSMUSG00000047415', u'ENSMUSG00000022297', u'ENSMUSG00000049511', u'ENSMUSG00000021721', u'ENSMUSG00000043398', u'ENSMUSG00000050288', u'ENSMUSG00000067586', u'ENSMUSG00000041907', u'ENSMUSG00000007989', u'ENSMUSG00000028563', u'ENSMUSG00000021319', u'ENSMUSG00000033569', u'ENSMUSG00000031932', u'ENSMUSG00000040836', u'ENSMUSG00000031548', u'ENSMUSG00000037605', u'ENSMUSG00000022122', u'ENSMUSG00000049112', u'ENSMUSG00000060735', u'ENSMUSG00000074939', u'ENSMUSG00000011171', u'ENSMUSG00000049649', u'ENSMUSG00000069170', u'ENSMUSG00000023192', u'ENSMUSG00000039167', u'ENSMUSG00000048965', u'ENSMUSG00000044014', u'ENSMUSG00000029778', u'ENSMUSG00000027568', u'ENSMUSG00000008734', u'ENSMUSG00000045382', u'ENSMUSG00000039809', u'ENSMUSG00000024798', u'ENSMUSG00000031616', u'ENSMUSG00000050534', u'ENSMUSG00000027765', u'ENSMUSG00000043999', u'ENSMUSG00000028172', u'ENSMUSG00000004730', u'ENSMUSG00000036357', u'ENSMUSG00000048376', u'ENSMUSG00000036353', u'ENSMUSG00000059588', u'ENSMUSG00000032528', u'ENSMUSG00000068696', u'ENSMUSG00000043659', u'ENSMUSG00000045092', u'ENSMUSG00000049580', u'ENSMUSG00000045318', u'ENSMUSG00000047875', u'ENSMUSG00000068037', u'ENSMUSG00000068740', u'ENSMUSG00000050541', u'ENSMUSG00000025475', u'ENSMUSG00000052336', u'ENSMUSG00000040372']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0016526', 'GO:0001623', 'GO:0001622', 'GO:0001625', 'GO:0001624'])),
    NtGoeaResults(GO='GO:0004966', NS='MF', enrichment='e', name='galanin receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(2, 13836), p_uncorrected=0.08816860589785164, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000063234']), pop_n=13836, pop_count=2, pop_items=set([u'ENSMUSG00000063234', u'ENSMUSG00000060735']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005003', NS='MF', enrichment='e', name='ephrin receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(13, 13836), p_uncorrected=0.4512955949428027, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000006445']), pop_n=13836, pop_count=13, pop_items=set([u'ENSMUSG00000032537', u'ENSMUSG00000055540', u'ENSMUSG00000029869', u'ENSMUSG00000029710', u'ENSMUSG00000006445', u'ENSMUSG00000026235', u'ENSMUSG00000028289', u'ENSMUSG00000029245', u'ENSMUSG00000005958', u'ENSMUSG00000028664', u'ENSMUSG00000028876', u'ENSMUSG00000052504', u'ENSMUSG00000028661']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005007', NS='MF', enrichment='e', name='fibroblast growth factor-activated receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000008090']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000008090', u'ENSMUSG00000031565', u'ENSMUSG00000030849', u'ENSMUSG00000054252']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005031', NS='MF', enrichment='e', name='tumor necrosis factor-activated receptor activity', ratio_in_study=(1, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.33996234399139486, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000022074']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000008318', u'ENSMUSG00000026321', u'ENSMUSG00000022074', u'ENSMUSG00000030339', u'ENSMUSG00000030341', u'ENSMUSG00000023915', u'ENSMUSG00000024793', u'ENSMUSG00000024778', u'ENSMUSG00000028599']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0005032', 'GO:0005033'])),
    NtGoeaResults(GO='GO:0005049', NS='MF', enrichment='e', name='nuclear export signal receptor activity', ratio_in_study=(2, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.04745838570330577, depth=4, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.82000154659639202, study_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000001855']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000048439', u'ENSMUSG00000001855', u'ENSMUSG00000002718', u'ENSMUSG00000067150', u'ENSMUSG00000021952', u'ENSMUSG00000040594', u'ENSMUSG00000022100']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0008262'])),
    NtGoeaResults(GO='GO:0005057', NS='MF', enrichment='e', name='signal transducer activity, downstream of receptor', ratio_in_study=(1, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.5223055970896804, depth=2, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000032586']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000032586', u'ENSMUSG00000000441', u'ENSMUSG00000027560', u'ENSMUSG00000024256', u'ENSMUSG00000002489', u'ENSMUSG00000052087', u'ENSMUSG00000029101', u'ENSMUSG00000035283', u'ENSMUSG00000027859', u'ENSMUSG00000001127', u'ENSMUSG00000068335', u'ENSMUSG00000040631', u'ENSMUSG00000023800', u'ENSMUSG00000026656', u'ENSMUSG00000002413', u'ENSMUSG00000048216']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005068', NS='MF', enrichment='e', name='transmembrane receptor protein tyrosine kinase adaptor activity', ratio_in_study=(1, 624), ratio_in_pop=(7, 13836), p_uncorrected=0.27610606231266455, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005057']), pop_n=13836, pop_count=7, pop_items=set([u'ENSMUSG00000020170', u'ENSMUSG00000005057', u'ENSMUSG00000061132', u'ENSMUSG00000055980', u'ENSMUSG00000004508', u'ENSMUSG00000027508', u'ENSMUSG00000059013']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0005069'])),
    NtGoeaResults(GO='GO:0005070', NS='MF', enrichment='p', name='SH3/SH2 adaptor activity', ratio_in_study=(1, 624), ratio_in_pop=(23, 13836), p_uncorrected=1.0, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005057']), pop_n=13836, pop_count=23, pop_items=set([u'ENSMUSG00000020176', u'ENSMUSG00000026888', u'ENSMUSG00000039844', u'ENSMUSG00000005057', u'ENSMUSG00000061132', u'ENSMUSG00000044813', u'ENSMUSG00000054520', u'ENSMUSG00000059923', u'ENSMUSG00000057058', u'ENSMUSG00000066877', u'ENSMUSG00000039154', u'ENSMUSG00000046280', u'ENSMUSG00000028790', u'ENSMUSG00000059182', u'ENSMUSG00000059013', u'ENSMUSG00000025006', u'ENSMUSG00000043733', u'ENSMUSG00000033256', u'ENSMUSG00000028121', u'ENSMUSG00000022372', u'ENSMUSG00000032475', u'ENSMUSG00000026058', u'ENSMUSG00000017776']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005080', NS='MF', enrichment='p', name='protein kinase C binding', ratio_in_study=(1, 624), ratio_in_pop=(54, 13836), p_uncorrected=0.5188099258089595, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020914']), pop_n=13836, pop_count=54, pop_items=set([u'ENSMUSG00000019699', u'ENSMUSG00000027466', u'ENSMUSG00000069662', u'ENSMUSG00000025026', u'ENSMUSG00000026842', u'ENSMUSG00000051391', u'ENSMUSG00000037060', u'ENSMUSG00000063796', u'ENSMUSG00000020828', u'ENSMUSG00000031555', u'ENSMUSG00000031068', u'ENSMUSG00000055409', u'ENSMUSG00000015837', u'ENSMUSG00000017485', u'ENSMUSG00000018446', u'ENSMUSG00000057672', u'ENSMUSG00000035873', u'ENSMUSG00000032118', u'ENSMUSG00000022475', u'ENSMUSG00000068206', u'ENSMUSG00000054889', u'ENSMUSG00000044548', u'ENSMUSG00000027646', u'ENSMUSG00000020914', u'ENSMUSG00000004056', u'ENSMUSG00000034674', u'ENSMUSG00000004951', u'ENSMUSG00000004698', u'ENSMUSG00000014158', u'ENSMUSG00000034120', u'ENSMUSG00000003402', u'ENSMUSG00000025812', u'ENSMUSG00000021798', u'ENSMUSG00000041957', u'ENSMUSG00000020372', u'ENSMUSG00000017009', u'ENSMUSG00000041187', u'ENSMUSG00000028273', u'ENSMUSG00000078794', u'ENSMUSG00000001729', u'ENSMUSG00000022454', u'ENSMUSG00000008855', u'ENSMUSG00000013698', u'ENSMUSG00000005699', u'ENSMUSG00000031328', u'ENSMUSG00000032458', u'ENSMUSG00000023277', u'ENSMUSG00000027087', u'ENSMUSG00000045954', u'ENSMUSG00000055980', u'ENSMUSG00000048826', u'ENSMUSG00000020120', u'ENSMUSG00000052889', u'ENSMUSG00000032041']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0097024', 'GO:0072568', 'GO:0072569'])),
    NtGoeaResults(GO='GO:0005085', NS='MF', enrichment='p', name='guanyl-nucleotide exchange factor activity', ratio_in_study=(4, 624), ratio_in_pop=(147, 13836), p_uncorrected=0.4208230662586114, depth=5, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028896', u'ENSMUSG00000007379', u'ENSMUSG00000031133', u'ENSMUSG00000027699']), pop_n=13836, pop_count=147, pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000031024', u'ENSMUSG00000021662', u'ENSMUSG00000059495', u'ENSMUSG00000023800', u'ENSMUSG00000064181', u'ENSMUSG00000017631', u'ENSMUSG00000029617', u'ENSMUSG00000050552', u'ENSMUSG00000018001', u'ENSMUSG00000066406', u'ENSMUSG00000002489', u'ENSMUSG00000018008', u'ENSMUSG00000030842', u'ENSMUSG00000051735', u'ENSMUSG00000035620', u'ENSMUSG00000025265', u'ENSMUSG00000024663', u'ENSMUSG00000038024', u'ENSMUSG00000020374', u'ENSMUSG00000032875', u'ENSMUSG00000056268', u'ENSMUSG00000032946', u'ENSMUSG00000066129', u'ENSMUSG00000031174', u'ENSMUSG00000038456', u'ENSMUSG00000034037', u'ENSMUSG00000021215', u'ENSMUSG00000009621', u'ENSMUSG00000039621', u'ENSMUSG00000007379', u'ENSMUSG00000040964', u'ENSMUSG00000037552', u'ENSMUSG00000021895', u'ENSMUSG00000025195', u'ENSMUSG00000017132', u'ENSMUSG00000037126', u'ENSMUSG00000091512', u'ENSMUSG00000026259', u'ENSMUSG00000019852', u'ENSMUSG00000026821', u'ENSMUSG00000062232', u'ENSMUSG00000038608', u'ENSMUSG00000028556', u'ENSMUSG00000004568', u'ENSMUSG00000022788', u'ENSMUSG00000039844', u'ENSMUSG00000067851', u'ENSMUSG00000030465', u'ENSMUSG00000004562', u'ENSMUSG00000026024', u'ENSMUSG00000034801', u'ENSMUSG00000040146', u'ENSMUSG00000059013', u'ENSMUSG00000003269', u'ENSMUSG00000071176', u'ENSMUSG00000034116', u'ENSMUSG00000009681', u'ENSMUSG00000087260', u'ENSMUSG00000025188', u'ENSMUSG00000035992', u'ENSMUSG00000028468', u'ENSMUSG00000042328', u'ENSMUSG00000031093', u'ENSMUSG00000033166', u'ENSMUSG00000029145', u'ENSMUSG00000042404', u'ENSMUSG00000028896', u'ENSMUSG00000028121', u'ENSMUSG00000029388', u'ENSMUSG00000033542', u'ENSMUSG00000038831', u'ENSMUSG00000031511', u'ENSMUSG00000049044', u'ENSMUSG00000024998', u'ENSMUSG00000028062', u'ENSMUSG00000030313', u'ENSMUSG00000032583', u'ENSMUSG00000020021', u'ENSMUSG00000028300', u'ENSMUSG00000026594', u'ENSMUSG00000032892', u'ENSMUSG00000039716', u'ENSMUSG00000004788', u'ENSMUSG00000021990', u'ENSMUSG00000040940', u'ENSMUSG00000025656', u'ENSMUSG00000074582', u'ENSMUSG00000031133', u'ENSMUSG00000038206', u'ENSMUSG00000061751', u'ENSMUSG00000031139', u'ENSMUSG00000032198', u'ENSMUSG00000041112', u'ENSMUSG00000025558', u'ENSMUSG00000024241', u'ENSMUSG00000040687', u'ENSMUSG00000003235', u'ENSMUSG00000049323', u'ENSMUSG00000025555', u'ENSMUSG00000030839', u'ENSMUSG00000035901', u'ENSMUSG00000027347', u'ENSMUSG00000042229', u'ENSMUSG00000038658', u'ENSMUSG00000020143', u'ENSMUSG00000024013', u'ENSMUSG00000015377', u'ENSMUSG00000034066', u'ENSMUSG00000027699', u'ENSMUSG00000028683', u'ENSMUSG00000040818', u'ENSMUSG00000052921', u'ENSMUSG00000026867', u'ENSMUSG00000031442', u'ENSMUSG00000034867', u'ENSMUSG00000058325', u'ENSMUSG00000038020', u'ENSMUSG00000025485', u'ENSMUSG00000037509', u'ENSMUSG00000041354', u'ENSMUSG00000052085', u'ENSMUSG00000048960', u'ENSMUSG00000028919', u'ENSMUSG00000035392', u'ENSMUSG00000022263', u'ENSMUSG00000022957', u'ENSMUSG00000032356', u'ENSMUSG00000036661', u'ENSMUSG00000021708', u'ENSMUSG00000028059', u'ENSMUSG00000033450', u'ENSMUSG00000026482', u'ENSMUSG00000026979', u'ENSMUSG00000032633', u'ENSMUSG00000035954', u'ENSMUSG00000036529', u'ENSMUSG00000034412', u'ENSMUSG00000022469', u'ENSMUSG00000044447', u'ENSMUSG00000034312', u'ENSMUSG00000041992', u'ENSMUSG00000037533', u'ENSMUSG00000019467', u'ENSMUSG00000050973', u'ENSMUSG00000040495', u'ENSMUSG00000037946']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0008433', 'GO:0019839', 'GO:0016219'])),
    NtGoeaResults(GO='GO:0005087', NS='MF', enrichment='e', name='Ran guanyl-nucleotide exchange factor activity', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028896']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000061979', u'ENSMUSG00000028896', u'ENSMUSG00000030839', u'ENSMUSG00000037415']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005089', NS='MF', enrichment='p', name='Rho guanyl-nucleotide exchange factor activity', ratio_in_study=(2, 624), ratio_in_pop=(61, 13836), p_uncorrected=1.0, depth=8, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027699', u'ENSMUSG00000031133']), pop_n=13836, pop_count=61, pop_items=set([u'ENSMUSG00000024013', u'ENSMUSG00000033721', u'ENSMUSG00000039713', u'ENSMUSG00000021662', u'ENSMUSG00000020021', u'ENSMUSG00000025555', u'ENSMUSG00000032875', u'ENSMUSG00000031133', u'ENSMUSG00000038608', u'ENSMUSG00000052921', u'ENSMUSG00000023800', u'ENSMUSG00000031442', u'ENSMUSG00000022788', u'ENSMUSG00000017631', u'ENSMUSG00000021990', u'ENSMUSG00000004562', u'ENSMUSG00000040940', u'ENSMUSG00000025656', u'ENSMUSG00000041354', u'ENSMUSG00000026024', u'ENSMUSG00000002489', u'ENSMUSG00000048960', u'ENSMUSG00000028919', u'ENSMUSG00000022263', u'ENSMUSG00000040964', u'ENSMUSG00000025504', u'ENSMUSG00000022957', u'ENSMUSG00000061751', u'ENSMUSG00000032356', u'ENSMUSG00000006154', u'ENSMUSG00000071176', u'ENSMUSG00000034066', u'ENSMUSG00000021708', u'ENSMUSG00000027699', u'ENSMUSG00000028059', u'ENSMUSG00000034116', u'ENSMUSG00000009681', u'ENSMUSG00000039621', u'ENSMUSG00000052609', u'ENSMUSG00000034037', u'ENSMUSG00000021215', u'ENSMUSG00000009621', u'ENSMUSG00000059495', u'ENSMUSG00000037509', u'ENSMUSG00000031093', u'ENSMUSG00000025265', u'ENSMUSG00000034801', u'ENSMUSG00000037552', u'ENSMUSG00000025558', u'ENSMUSG00000024241', u'ENSMUSG00000021895', u'ENSMUSG00000033542', u'ENSMUSG00000025195', u'ENSMUSG00000061462', u'ENSMUSG00000020640', u'ENSMUSG00000019467', u'ENSMUSG00000031511', u'ENSMUSG00000066406', u'ENSMUSG00000026259', u'ENSMUSG00000037946', u'ENSMUSG00000004568']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005092', NS='MF', enrichment='e', name='GDP-dissociation inhibitor activity', ratio_in_study=(2, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.09940214291590645, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027883', u'ENSMUSG00000028893']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000015291', u'ENSMUSG00000078185', u'ENSMUSG00000026930', u'ENSMUSG00000028893', u'ENSMUSG00000052087', u'ENSMUSG00000036206', u'ENSMUSG00000027883', u'ENSMUSG00000021218', u'ENSMUSG00000005732', u'ENSMUSG00000073433', u'ENSMUSG00000062352', u'ENSMUSG00000025531']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005096', NS='MF', enrichment='p', name='GTPase activator activity', ratio_in_study=(7, 624), ratio_in_pop=(215, 13836), p_uncorrected=0.5053679085214675, depth=5, study_count=7, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000027699', u'ENSMUSG00000036246', u'ENSMUSG00000023015', u'ENSMUSG00000039813', u'ENSMUSG00000020599', u'ENSMUSG00000041219', u'ENSMUSG00000052684']), pop_n=13836, pop_count=215, pop_items=set([u'ENSMUSG00000053199', u'ENSMUSG00000020289', u'ENSMUSG00000038515', u'ENSMUSG00000027465', u'ENSMUSG00000048865', u'ENSMUSG00000023923', u'ENSMUSG00000044037', u'ENSMUSG00000033389', u'ENSMUSG00000029192', u'ENSMUSG00000042303', u'ENSMUSG00000023800', u'ENSMUSG00000042216', u'ENSMUSG00000036533', u'ENSMUSG00000026883', u'ENSMUSG00000030727', u'ENSMUSG00000017631', u'ENSMUSG00000036882', u'ENSMUSG00000020817', u'ENSMUSG00000029602', u'ENSMUSG00000029101', u'ENSMUSG00000052632', u'ENSMUSG00000030844', u'ENSMUSG00000016128', u'ENSMUSG00000001768', u'ENSMUSG00000035133', u'ENSMUSG00000033083', u'ENSMUSG00000049076', u'ENSMUSG00000004952', u'ENSMUSG00000020599', u'ENSMUSG00000019775', u'ENSMUSG00000051864', u'ENSMUSG00000038860', u'ENSMUSG00000039031', u'ENSMUSG00000039230', u'ENSMUSG00000022391', u'ENSMUSG00000063506', u'ENSMUSG00000029722', u'ENSMUSG00000028030', u'ENSMUSG00000011831', u'ENSMUSG00000011832', u'ENSMUSG00000033763', u'ENSMUSG00000004677', u'ENSMUSG00000030766', u'ENSMUSG00000022799', u'ENSMUSG00000040964', u'ENSMUSG00000021218', u'ENSMUSG00000021219', u'ENSMUSG00000002496', u'ENSMUSG00000022488', u'ENSMUSG00000027652', u'ENSMUSG00000001995', u'ENSMUSG00000037410', u'ENSMUSG00000026159', u'ENSMUSG00000056698', u'ENSMUSG00000032413', u'ENSMUSG00000035437', u'ENSMUSG00000026425', u'ENSMUSG00000054277', u'ENSMUSG00000026155', u'ENSMUSG00000039585', u'ENSMUSG00000039046', u'ENSMUSG00000037999', u'ENSMUSG00000032812', u'ENSMUSG00000062232', u'ENSMUSG00000039201', u'ENSMUSG00000067629', u'ENSMUSG00000059495', u'ENSMUSG00000025132', u'ENSMUSG00000002459', u'ENSMUSG00000020536', u'ENSMUSG00000044456', u'ENSMUSG00000002372', u'ENSMUSG00000030047', u'ENSMUSG00000070565', u'ENSMUSG00000026024', u'ENSMUSG00000001173', u'ENSMUSG00000023015', u'ENSMUSG00000032011', u'ENSMUSG00000038807', u'ENSMUSG00000020130', u'ENSMUSG00000038530', u'ENSMUSG00000018909', u'ENSMUSG00000027255', u'ENSMUSG00000051177', u'ENSMUSG00000015291', u'ENSMUSG00000009681', u'ENSMUSG00000026721', u'ENSMUSG00000036995', u'ENSMUSG00000031355', u'ENSMUSG00000031709', u'ENSMUSG00000057315', u'ENSMUSG00000022436', u'ENSMUSG00000035697', u'ENSMUSG00000042203', u'ENSMUSG00000036246', u'ENSMUSG00000039831', u'ENSMUSG00000026527', u'ENSMUSG00000024186', u'ENSMUSG00000024182', u'ENSMUSG00000058230', u'ENSMUSG00000024451', u'ENSMUSG00000056486', u'ENSMUSG00000041890', u'ENSMUSG00000027247', u'ENSMUSG00000020121', u'ENSMUSG00000060090', u'ENSMUSG00000037148', u'ENSMUSG00000025531', u'ENSMUSG00000042492', u'ENSMUSG00000038351', u'ENSMUSG00000020716', u'ENSMUSG00000031389', u'ENSMUSG00000052142', u'ENSMUSG00000032870', u'ENSMUSG00000030257', u'ENSMUSG00000025154', u'ENSMUSG00000073433', u'ENSMUSG00000003134', u'ENSMUSG00000048424', u'ENSMUSG00000040940', u'ENSMUSG00000036273', u'ENSMUSG00000052302', u'ENSMUSG00000036644', u'ENSMUSG00000025422', u'ENSMUSG00000021027', u'ENSMUSG00000025810', u'ENSMUSG00000000142', u'ENSMUSG00000019433', u'ENSMUSG00000027699', u'ENSMUSG00000042473', u'ENSMUSG00000035620', u'ENSMUSG00000059810', u'ENSMUSG00000020709', u'ENSMUSG00000032192', u'ENSMUSG00000039976', u'ENSMUSG00000011877', u'ENSMUSG00000039318', u'ENSMUSG00000004633', u'ENSMUSG00000039678', u'ENSMUSG00000033569', u'ENSMUSG00000041225', u'ENSMUSG00000035007', u'ENSMUSG00000049521', u'ENSMUSG00000027347', u'ENSMUSG00000024639', u'ENSMUSG00000002458', u'ENSMUSG00000049744', u'ENSMUSG00000020143', u'ENSMUSG00000045302', u'ENSMUSG00000048960', u'ENSMUSG00000048720', u'ENSMUSG00000038520', u'ENSMUSG00000019790', u'ENSMUSG00000026678', u'ENSMUSG00000055013', u'ENSMUSG00000052921', u'ENSMUSG00000026867', u'ENSMUSG00000050730', u'ENSMUSG00000005732', u'ENSMUSG00000041598', u'ENSMUSG00000034867', u'ENSMUSG00000045664', u'ENSMUSG00000021368', u'ENSMUSG00000058325', u'ENSMUSG00000041351', u'ENSMUSG00000078185', u'ENSMUSG00000025485', u'ENSMUSG00000037426', u'ENSMUSG00000035151', u'ENSMUSG00000010057', u'ENSMUSG00000037110', u'ENSMUSG00000028919', u'ENSMUSG00000024096', u'ENSMUSG00000026475', u'ENSMUSG00000024883', u'ENSMUSG00000036106', u'ENSMUSG00000056413', u'ENSMUSG00000036104', u'ENSMUSG00000051735', u'ENSMUSG00000003226', u'ENSMUSG00000056917', u'ENSMUSG00000041219', u'ENSMUSG00000052684', u'ENSMUSG00000040345', u'ENSMUSG00000042700', u'ENSMUSG00000027575', u'ENSMUSG00000030220', u'ENSMUSG00000029500', u'ENSMUSG00000022829', u'ENSMUSG00000032714', u'ENSMUSG00000049807', u'ENSMUSG00000021549', u'ENSMUSG00000031216', u'ENSMUSG00000039813', u'ENSMUSG00000031214', u'ENSMUSG00000035954', u'ENSMUSG00000031453', u'ENSMUSG00000052087', u'ENSMUSG00000034412', u'ENSMUSG00000034255', u'ENSMUSG00000036452', u'ENSMUSG00000022377', u'ENSMUSG00000024493', u'ENSMUSG00000031523', u'ENSMUSG00000029174', u'ENSMUSG00000036591', u'ENSMUSG00000041444', u'ENSMUSG00000023353', u'ENSMUSG00000030583', u'ENSMUSG00000042671', u'ENSMUSG00000036501', u'ENSMUSG00000026360', u'ENSMUSG00000071042', u'ENSMUSG00000041986', u'ENSMUSG00000037627']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0005098', 'GO:0005099', 'GO:0017123', 'GO:0005097', 'GO:0030675', 'GO:0008060', 'GO:0046582', 'GO:0005100', 'GO:0005101'])),
    NtGoeaResults(GO='GO:0005102', NS='MF', enrichment='p', name='receptor binding', ratio_in_study=(7, 624), ratio_in_pop=(269, 13836), p_uncorrected=0.13884330603322378, depth=3, study_count=7, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000032508', u'ENSMUSG00000006930', u'ENSMUSG00000056116', u'ENSMUSG00000006411', u'ENSMUSG00000001123', u'ENSMUSG00000025534']), pop_n=13836, pop_count=269, pop_items=set([u'ENSMUSG00000074064', u'ENSMUSG00000031266', u'ENSMUSG00000039515', u'ENSMUSG00000051920', u'ENSMUSG00000047866', u'ENSMUSG00000040511', u'ENSMUSG00000029599', u'ENSMUSG00000045532', u'ENSMUSG00000031538', u'ENSMUSG00000030111', u'ENSMUSG00000019996', u'ENSMUSG00000059003', u'ENSMUSG00000047454', u'ENSMUSG00000079110', u'ENSMUSG00000029104', u'ENSMUSG00000026249', u'ENSMUSG00000062300', u'ENSMUSG00000042228', u'ENSMUSG00000053835', u'ENSMUSG00000006930', u'ENSMUSG00000025464', u'ENSMUSG00000042284', u'ENSMUSG00000022656', u'ENSMUSG00000026167', u'ENSMUSG00000022244', u'ENSMUSG00000015647', u'ENSMUSG00000028583', u'ENSMUSG00000026234', u'ENSMUSG00000070509', u'ENSMUSG00000021417', u'ENSMUSG00000019772', u'ENSMUSG00000019846', u'ENSMUSG00000034462', u'ENSMUSG00000030209', u'ENSMUSG00000010797', u'ENSMUSG00000038619', u'ENSMUSG00000030201', u'ENSMUSG00000039239', u'ENSMUSG00000067212', u'ENSMUSG00000000489', u'ENSMUSG00000032312', u'ENSMUSG00000019054', u'ENSMUSG00000022099', u'ENSMUSG00000063428', u'ENSMUSG00000026959', u'ENSMUSG00000028603', u'ENSMUSG00000031767', u'ENSMUSG00000004035', u'ENSMUSG00000025321', u'ENSMUSG00000033208', u'ENSMUSG00000032259', u'ENSMUSG00000036634', u'ENSMUSG00000061762', u'ENSMUSG00000037411', u'ENSMUSG00000027187', u'ENSMUSG00000032796', u'ENSMUSG00000020733', u'ENSMUSG00000024789', u'ENSMUSG00000037003', u'ENSMUSG00000002897', u'ENSMUSG00000022847', u'ENSMUSG00000015656', u'ENSMUSG00000031871', u'ENSMUSG00000031870', u'ENSMUSG00000004837', u'ENSMUSG00000035212', u'ENSMUSG00000020635', u'ENSMUSG00000026117', u'ENSMUSG00000032959', u'ENSMUSG00000069539', u'ENSMUSG00000022382', u'ENSMUSG00000037992', u'ENSMUSG00000021478', u'ENSMUSG00000029098', u'ENSMUSG00000026942', u'ENSMUSG00000021226', u'ENSMUSG00000022994', u'ENSMUSG00000046532', u'ENSMUSG00000030281', u'ENSMUSG00000021884', u'ENSMUSG00000022309', u'ENSMUSG00000041417', u'ENSMUSG00000023018', u'ENSMUSG00000037010', u'ENSMUSG00000050164', u'ENSMUSG00000018293', u'ENSMUSG00000027646', u'ENSMUSG00000029126', u'ENSMUSG00000031805', u'ENSMUSG00000072115', u'ENSMUSG00000022853', u'ENSMUSG00000016024', u'ENSMUSG00000048482', u'ENSMUSG00000036904', u'ENSMUSG00000005886', u'ENSMUSG00000006611', u'ENSMUSG00000004933', u'ENSMUSG00000027087', u'ENSMUSG00000015243', u'ENSMUSG00000022901', u'ENSMUSG00000035914', u'ENSMUSG00000034292', u'ENSMUSG00000030309', u'ENSMUSG00000024109', u'ENSMUSG00000060216', u'ENSMUSG00000025020', u'ENSMUSG00000009281', u'ENSMUSG00000019880', u'ENSMUSG00000028399', u'ENSMUSG00000032968', u'ENSMUSG00000044674', u'ENSMUSG00000034101', u'ENSMUSG00000091971', u'ENSMUSG00000059456', u'ENSMUSG00000028949', u'ENSMUSG00000033540', u'ENSMUSG00000024507', u'ENSMUSG00000032475', u'ENSMUSG00000033307', u'ENSMUSG00000052372', u'ENSMUSG00000001300', u'ENSMUSG00000035929', u'ENSMUSG00000003283', u'ENSMUSG00000024182', u'ENSMUSG00000022865', u'ENSMUSG00000036856', u'ENSMUSG00000041895', u'ENSMUSG00000007617', u'ENSMUSG00000044933', u'ENSMUSG00000020122', u'ENSMUSG00000022148', u'ENSMUSG00000060550', u'ENSMUSG00000030093', u'ENSMUSG00000053158', u'ENSMUSG00000025950', u'ENSMUSG00000021451', u'ENSMUSG00000000732', u'ENSMUSG00000041014', u'ENSMUSG00000026596', u'ENSMUSG00000031451', u'ENSMUSG00000019899', u'ENSMUSG00000036775', u'ENSMUSG00000054855', u'ENSMUSG00000026193', u'ENSMUSG00000028664', u'ENSMUSG00000021994', u'ENSMUSG00000015568', u'ENSMUSG00000032508', u'ENSMUSG00000030806', u'ENSMUSG00000027624', u'ENSMUSG00000005262', u'ENSMUSG00000024620', u'ENSMUSG00000061232', u'ENSMUSG00000032076', u'ENSMUSG00000021904', u'ENSMUSG00000049107', u'ENSMUSG00000029397', u'ENSMUSG00000028975', u'ENSMUSG00000024421', u'ENSMUSG00000079507', u'ENSMUSG00000032175', u'ENSMUSG00000041135', u'ENSMUSG00000014932', u'ENSMUSG00000019433', u'ENSMUSG00000046719', u'ENSMUSG00000034394', u'ENSMUSG00000021721', u'ENSMUSG00000025809', u'ENSMUSG00000026853', u'ENSMUSG00000020708', u'ENSMUSG00000034875', u'ENSMUSG00000029276', u'ENSMUSG00000031558', u'ENSMUSG00000073409', u'ENSMUSG00000023973', u'ENSMUSG00000040811', u'ENSMUSG00000029167', u'ENSMUSG00000046178', u'ENSMUSG00000047085', u'ENSMUSG00000028452', u'ENSMUSG00000056427', u'ENSMUSG00000022353', u'ENSMUSG00000019843', u'ENSMUSG00000002504', u'ENSMUSG00000022607', u'ENSMUSG00000028871', u'ENSMUSG00000036968', u'ENSMUSG00000022040', u'ENSMUSG00000022210', u'ENSMUSG00000052310', u'ENSMUSG00000031934', u'ENSMUSG00000003233', u'ENSMUSG00000050953', u'ENSMUSG00000028964', u'ENSMUSG00000003623', u'ENSMUSG00000001123', u'ENSMUSG00000005312', u'ENSMUSG00000016206', u'ENSMUSG00000039988', u'ENSMUSG00000017774', u'ENSMUSG00000060275', u'ENSMUSG00000032012', u'ENSMUSG00000032913', u'ENSMUSG00000056999', u'ENSMUSG00000049336', u'ENSMUSG00000024392', u'ENSMUSG00000031207', u'ENSMUSG00000028048', u'ENSMUSG00000029470', u'ENSMUSG00000056116', u'ENSMUSG00000024953', u'ENSMUSG00000006411', u'ENSMUSG00000022661', u'ENSMUSG00000044708', u'ENSMUSG00000022892', u'ENSMUSG00000053898', u'ENSMUSG00000068206', u'ENSMUSG00000028672', u'ENSMUSG00000028910', u'ENSMUSG00000028444', u'ENSMUSG00000029864', u'ENSMUSG00000007613', u'ENSMUSG00000041193', u'ENSMUSG00000031565', u'ENSMUSG00000037295', u'ENSMUSG00000022054', u'ENSMUSG00000000127', u'ENSMUSG00000000126', u'ENSMUSG00000002985', u'ENSMUSG00000036943', u'ENSMUSG00000048376', u'ENSMUSG00000020777', u'ENSMUSG00000031985', u'ENSMUSG00000022817', u'ENSMUSG00000027359', u'ENSMUSG00000027358', u'ENSMUSG00000039005', u'ENSMUSG00000021709', u'ENSMUSG00000021278', u'ENSMUSG00000030224', u'ENSMUSG00000064115', u'ENSMUSG00000024387', u'ENSMUSG00000056201', u'ENSMUSG00000021549', u'ENSMUSG00000006464', u'ENSMUSG00000048490', u'ENSMUSG00000022679', u'ENSMUSG00000026028', u'ENSMUSG00000034813', u'ENSMUSG00000023951', u'ENSMUSG00000026278', u'ENSMUSG00000073411', u'ENSMUSG00000025534', u'ENSMUSG00000026565', u'ENSMUSG00000027007', u'ENSMUSG00000022372', u'ENSMUSG00000054793', u'ENSMUSG00000017307', u'ENSMUSG00000024256', u'ENSMUSG00000027859', u'ENSMUSG00000045038', u'ENSMUSG00000022791', u'ENSMUSG00000035000', u'ENSMUSG00000005338', u'ENSMUSG00000007656', u'ENSMUSG00000030579', u'ENSMUSG00000007655', u'ENSMUSG00000020886', u'ENSMUSG00000014776']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005113', NS='MF', enrichment='e', name='patched binding', ratio_in_study=(1, 624), ratio_in_pop=(4, 13836), p_uncorrected=0.16857486375487116, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000041431']), pop_n=13836, pop_count=4, pop_items=set([u'ENSMUSG00000006464', u'ENSMUSG00000021466', u'ENSMUSG00000001761', u'ENSMUSG00000041431']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005121', NS='MF', enrichment='e', name='Toll binding', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=4, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000032508']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000032508']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005125', NS='MF', enrichment='e', name='cytokine activity', ratio_in_study=(7, 624), ratio_in_pop=(64, 13836), p_uncorrected=0.02464289544405156, depth=5, study_count=7, p_sm_bonferroni=1.0, p_fdr_bh=0.66616405480942142, study_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000034708', u'ENSMUSG00000035352', u'ENSMUSG00000001131', u'ENSMUSG00000034855', u'ENSMUSG00000027399', u'ENSMUSG00000018930']), pop_n=13836, pop_count=64, pop_items=set([u'ENSMUSG00000030093', u'ENSMUSG00000029417', u'ENSMUSG00000033467', u'ENSMUSG00000028029', u'ENSMUSG00000008999', u'ENSMUSG00000020572', u'ENSMUSG00000028362', u'ENSMUSG00000029304', u'ENSMUSG00000032968', u'ENSMUSG00000031750', u'ENSMUSG00000037035', u'ENSMUSG00000019122', u'ENSMUSG00000025352', u'ENSMUSG00000021994', u'ENSMUSG00000024810', u'ENSMUSG00000031778', u'ENSMUSG00000050069', u'ENSMUSG00000001741', u'ENSMUSG00000038793', u'ENSMUSG00000066551', u'ENSMUSG00000061353', u'ENSMUSG00000002603', u'ENSMUSG00000023078', u'ENSMUSG00000007888', u'ENSMUSG00000018927', u'ENSMUSG00000001131', u'ENSMUSG00000019966', u'ENSMUSG00000032179', u'ENSMUSG00000035352', u'ENSMUSG00000018920', u'ENSMUSG00000027358', u'ENSMUSG00000039004', u'ENSMUSG00000039304', u'ENSMUSG00000073888', u'ENSMUSG00000034394', u'ENSMUSG00000010797', u'ENSMUSG00000039217', u'ENSMUSG00000021253', u'ENSMUSG00000039239', u'ENSMUSG00000033307', u'ENSMUSG00000050222', u'ENSMUSG00000029335', u'ENSMUSG00000022098', u'ENSMUSG00000036427', u'ENSMUSG00000034855', u'ENSMUSG00000027399', u'ENSMUSG00000029371', u'ENSMUSG00000023951', u'ENSMUSG00000000982', u'ENSMUSG00000034708', u'ENSMUSG00000035385', u'ENSMUSG00000040138', u'ENSMUSG00000040759', u'ENSMUSG00000014599', u'ENSMUSG00000032434', u'ENSMUSG00000050711', u'ENSMUSG00000032436', u'ENSMUSG00000021508', u'ENSMUSG00000021835', u'ENSMUSG00000022847', u'ENSMUSG00000021943', u'ENSMUSG00000031875', u'ENSMUSG00000018930', u'ENSMUSG00000040794']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005146', NS='MF', enrichment='e', name='leukemia inhibitory factor receptor binding', ratio_in_study=(1, 624), ratio_in_pop=(1, 13836), p_uncorrected=0.04509973980936192, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000034394']), pop_n=13836, pop_count=1, pop_items=set([u'ENSMUSG00000034394']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005149', NS='MF', enrichment='e', name='interleukin-1 receptor binding', ratio_in_study=(2, 624), ratio_in_pop=(8, 13836), p_uncorrected=0.04745838570330577, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.82000154659639202, study_items=set([u'ENSMUSG00000027399', u'ENSMUSG00000032508']), pop_n=13836, pop_count=8, pop_items=set([u'ENSMUSG00000031392', u'ENSMUSG00000023348', u'ENSMUSG00000045322', u'ENSMUSG00000032508', u'ENSMUSG00000059883', u'ENSMUSG00000030209', u'ENSMUSG00000022514', u'ENSMUSG00000027399']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005154', NS='MF', enrichment='p', name='epidermal growth factor receptor binding', ratio_in_study=(1, 624), ratio_in_pop=(25, 13836), p_uncorrected=1.0, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024486']), pop_n=13836, pop_count=25, pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000037104', u'ENSMUSG00000034342', u'ENSMUSG00000000555', u'ENSMUSG00000024486', u'ENSMUSG00000049556', u'ENSMUSG00000000127', u'ENSMUSG00000042605', u'ENSMUSG00000034484', u'ENSMUSG00000042626', u'ENSMUSG00000059923', u'ENSMUSG00000062209', u'ENSMUSG00000005087', u'ENSMUSG00000029999', u'ENSMUSG00000035890', u'ENSMUSG00000020467', u'ENSMUSG00000022791', u'ENSMUSG00000009621', u'ENSMUSG00000032382', u'ENSMUSG00000032369', u'ENSMUSG00000021877', u'ENSMUSG00000014932', u'ENSMUSG00000026174', u'ENSMUSG00000022808', u'ENSMUSG00000060275']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0008185'])),
    NtGoeaResults(GO='GO:0005164', NS='MF', enrichment='e', name='tumor necrosis factor receptor binding', ratio_in_study=(1, 624), ratio_in_pop=(15, 13836), p_uncorrected=0.49971854645333214, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000026104']), pop_n=13836, pop_count=15, pop_items=set([u'ENSMUSG00000021583', u'ENSMUSG00000017386', u'ENSMUSG00000026029', u'ENSMUSG00000039304', u'ENSMUSG00000059327', u'ENSMUSG00000021277', u'ENSMUSG00000027164', u'ENSMUSG00000028362', u'ENSMUSG00000052139', u'ENSMUSG00000026942', u'ENSMUSG00000026104', u'ENSMUSG00000018548', u'ENSMUSG00000064326', u'ENSMUSG00000031887', u'ENSMUSG00000030659']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005178', NS='MF', enrichment='p', name='integrin binding', ratio_in_study=(3, 624), ratio_in_pop=(82, 13836), p_uncorrected=0.9999999999853041, depth=4, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000037405', u'ENSMUSG00000025089', u'ENSMUSG00000067586']), pop_n=13836, pop_count=82, pop_items=set([u'ENSMUSG00000026043', u'ENSMUSG00000027962', u'ENSMUSG00000028041', u'ENSMUSG00000079465', u'ENSMUSG00000027111', u'ENSMUSG00000000957', u'ENSMUSG00000006369', u'ENSMUSG00000001930', u'ENSMUSG00000021457', u'ENSMUSG00000021186', u'ENSMUSG00000035493', u'ENSMUSG00000031990', u'ENSMUSG00000021998', u'ENSMUSG00000026193', u'ENSMUSG00000040998', u'ENSMUSG00000019997', u'ENSMUSG00000009073', u'ENSMUSG00000031778', u'ENSMUSG00000043895', u'ENSMUSG00000022505', u'ENSMUSG00000037362', u'ENSMUSG00000000555', u'ENSMUSG00000027238', u'ENSMUSG00000025130', u'ENSMUSG00000052593', u'ENSMUSG00000037405', u'ENSMUSG00000017466', u'ENSMUSG00000034488', u'ENSMUSG00000042228', u'ENSMUSG00000019820', u'ENSMUSG00000022150', u'ENSMUSG00000024539', u'ENSMUSG00000020932', u'ENSMUSG00000036585', u'ENSMUSG00000025089', u'ENSMUSG00000038264', u'ENSMUSG00000015647', u'ENSMUSG00000003814', u'ENSMUSG00000022817', u'ENSMUSG00000001507', u'ENSMUSG00000025809', u'ENSMUSG00000015143', u'ENSMUSG00000022812', u'ENSMUSG00000020053', u'ENSMUSG00000021709', u'ENSMUSG00000031391', u'ENSMUSG00000028195', u'ENSMUSG00000030342', u'ENSMUSG00000021702', u'ENSMUSG00000029528', u'ENSMUSG00000067586', u'ENSMUSG00000000392', u'ENSMUSG00000015829', u'ENSMUSG00000057554', u'ENSMUSG00000031555', u'ENSMUSG00000052911', u'ENSMUSG00000028465', u'ENSMUSG00000025348', u'ENSMUSG00000002900', u'ENSMUSG00000024965', u'ENSMUSG00000020689', u'ENSMUSG00000028517', u'ENSMUSG00000032011', u'ENSMUSG00000032174', u'ENSMUSG00000017344', u'ENSMUSG00000040152', u'ENSMUSG00000022607', u'ENSMUSG00000037493', u'ENSMUSG00000025473', u'ENSMUSG00000062960', u'ENSMUSG00000040690', u'ENSMUSG00000025510', u'ENSMUSG00000022865', u'ENSMUSG00000062352', u'ENSMUSG00000025511', u'ENSMUSG00000021910', u'ENSMUSG00000029816', u'ENSMUSG00000027204', u'ENSMUSG00000020122', u'ENSMUSG00000030890', u'ENSMUSG00000021814', u'ENSMUSG00000030605']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005198', NS='MF', enrichment='p', name='structural molecule activity', ratio_in_study=(1, 624), ratio_in_pop=(73, 13836), p_uncorrected=0.26328664301347127, depth=1, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024590']), pop_n=13836, pop_count=73, pop_items=set([u'ENSMUSG00000064201', u'ENSMUSG00000028063', u'ENSMUSG00000038271', u'ENSMUSG00000021241', u'ENSMUSG00000049382', u'ENSMUSG00000062075', u'ENSMUSG00000034282', u'ENSMUSG00000035849', u'ENSMUSG00000004891', u'ENSMUSG00000028478', u'ENSMUSG00000019996', u'ENSMUSG00000055681', u'ENSMUSG00000030754', u'ENSMUSG00000025487', u'ENSMUSG00000030554', u'ENSMUSG00000047230', u'ENSMUSG00000027488', u'ENSMUSG00000026553', u'ENSMUSG00000027624', u'ENSMUSG00000047126', u'ENSMUSG00000060771', u'ENSMUSG00000022055', u'ENSMUSG00000022054', u'ENSMUSG00000020932', u'ENSMUSG00000026208', u'ENSMUSG00000001552', u'ENSMUSG00000022132', u'ENSMUSG00000021823', u'ENSMUSG00000020672', u'ENSMUSG00000024590', u'ENSMUSG00000041025', u'ENSMUSG00000054889', u'ENSMUSG00000052298', u'ENSMUSG00000029106', u'ENSMUSG00000031273', u'ENSMUSG00000046722', u'ENSMUSG00000063063', u'ENSMUSG00000026728', u'ENSMUSG00000037815', u'ENSMUSG00000028339', u'ENSMUSG00000024044', u'ENSMUSG00000020396', u'ENSMUSG00000060429', u'ENSMUSG00000001435', u'ENSMUSG00000041782', u'ENSMUSG00000041378', u'ENSMUSG00000004098', u'ENSMUSG00000022512', u'ENSMUSG00000025026', u'ENSMUSG00000030000', u'ENSMUSG00000041020', u'ENSMUSG00000017428', u'ENSMUSG00000028849', u'ENSMUSG00000023043', u'ENSMUSG00000019978', u'ENSMUSG00000047547', u'ENSMUSG00000041308', u'ENSMUSG00000028906', u'ENSMUSG00000025607', u'ENSMUSG00000032556', u'ENSMUSG00000032458', u'ENSMUSG00000031425', u'ENSMUSG00000030058', u'ENSMUSG00000063661', u'ENSMUSG00000034336', u'ENSMUSG00000025909', u'ENSMUSG00000046798', u'ENSMUSG00000044792', u'ENSMUSG00000007655', u'ENSMUSG00000040860', u'ENSMUSG00000037625', u'ENSMUSG00000020886', u'ENSMUSG00000023484']), study_n=624, level=1, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005200', NS='MF', enrichment='e', name='structural constituent of cytoskeleton', ratio_in_study=(4, 624), ratio_in_pop=(56, 13836), p_uncorrected=0.3203040456737657, depth=2, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024056', u'ENSMUSG00000045136', u'ENSMUSG00000000759', u'ENSMUSG00000025474']), pop_n=13836, pop_count=56, pop_items=set([u'ENSMUSG00000035198', u'ENSMUSG00000006304', u'ENSMUSG00000024056', u'ENSMUSG00000030137', u'ENSMUSG00000020513', u'ENSMUSG00000022565', u'ENSMUSG00000036752', u'ENSMUSG00000049122', u'ENSMUSG00000026208', u'ENSMUSG00000027238', u'ENSMUSG00000030554', u'ENSMUSG00000024376', u'ENSMUSG00000027624', u'ENSMUSG00000079426', u'ENSMUSG00000026790', u'ENSMUSG00000022055', u'ENSMUSG00000072235', u'ENSMUSG00000020932', u'ENSMUSG00000021061', u'ENSMUSG00000000759', u'ENSMUSG00000051786', u'ENSMUSG00000026202', u'ENSMUSG00000020061', u'ENSMUSG00000020152', u'ENSMUSG00000029622', u'ENSMUSG00000001525', u'ENSMUSG00000062380', u'ENSMUSG00000024049', u'ENSMUSG00000069601', u'ENSMUSG00000026728', u'ENSMUSG00000029465', u'ENSMUSG00000048285', u'ENSMUSG00000045136', u'ENSMUSG00000024044', u'ENSMUSG00000062825', u'ENSMUSG00000058672', u'ENSMUSG00000032366', u'ENSMUSG00000008475', u'ENSMUSG00000062591', u'ENSMUSG00000028464', u'ENSMUSG00000028465', u'ENSMUSG00000033790', u'ENSMUSG00000052698', u'ENSMUSG00000043091', u'ENSMUSG00000020396', u'ENSMUSG00000019978', u'ENSMUSG00000028906', u'ENSMUSG00000023004', u'ENSMUSG00000026341', u'ENSMUSG00000025474', u'ENSMUSG00000051747', u'ENSMUSG00000027263', u'ENSMUSG00000020315', u'ENSMUSG00000026383', u'ENSMUSG00000028434', u'ENSMUSG00000001473']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005201', NS='MF', enrichment='p', name='extracellular matrix structural constituent', ratio_in_study=(1, 624), ratio_in_pop=(31, 13836), p_uncorrected=1.0, depth=2, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000031502']), pop_n=13836, pop_count=31, pop_items=set([u'ENSMUSG00000006369', u'ENSMUSG00000031502', u'ENSMUSG00000004894', u'ENSMUSG00000024330', u'ENSMUSG00000004892', u'ENSMUSG00000026478', u'ENSMUSG00000007594', u'ENSMUSG00000030607', u'ENSMUSG00000029661', u'ENSMUSG00000024598', u'ENSMUSG00000026042', u'ENSMUSG00000026043', u'ENSMUSG00000001506', u'ENSMUSG00000079465', u'ENSMUSG00000020674', u'ENSMUSG00000027966', u'ENSMUSG00000028197', u'ENSMUSG00000030218', u'ENSMUSG00000026837', u'ENSMUSG00000032796', u'ENSMUSG00000045672', u'ENSMUSG00000067158', u'ENSMUSG00000002900', u'ENSMUSG00000022483', u'ENSMUSG00000002341', u'ENSMUSG00000031503', u'ENSMUSG00000029675', u'ENSMUSG00000041577', u'ENSMUSG00000021613', u'ENSMUSG00000021614', u'ENSMUSG00000027204']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005215', NS='MF', enrichment='p', name='transporter activity', ratio_in_study=(3, 624), ratio_in_pop=(100, 13836), p_uncorrected=0.6302857004181801, depth=1, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000009035', u'ENSMUSG00000024737', u'ENSMUSG00000019874']), pop_n=13836, pop_count=100, pop_items=set([u'ENSMUSG00000009035', u'ENSMUSG00000006576', u'ENSMUSG00000020865', u'ENSMUSG00000029843', u'ENSMUSG00000032548', u'ENSMUSG00000026791', u'ENSMUSG00000029924', u'ENSMUSG00000018800', u'ENSMUSG00000016319', u'ENSMUSG00000020620', u'ENSMUSG00000037490', u'ENSMUSG00000041216', u'ENSMUSG00000014077', u'ENSMUSG00000023830', u'ENSMUSG00000003585', u'ENSMUSG00000018459', u'ENSMUSG00000035722', u'ENSMUSG00000060961', u'ENSMUSG00000031974', u'ENSMUSG00000026944', u'ENSMUSG00000041797', u'ENSMUSG00000044749', u'ENSMUSG00000028645', u'ENSMUSG00000041945', u'ENSMUSG00000000792', u'ENSMUSG00000015653', u'ENSMUSG00000018900', u'ENSMUSG00000024597', u'ENSMUSG00000053025', u'ENSMUSG00000030307', u'ENSMUSG00000027887', u'ENSMUSG00000023088', u'ENSMUSG00000046402', u'ENSMUSG00000004655', u'ENSMUSG00000089774', u'ENSMUSG00000039194', u'ENSMUSG00000028125', u'ENSMUSG00000022548', u'ENSMUSG00000017756', u'ENSMUSG00000015243', u'ENSMUSG00000024990', u'ENSMUSG00000027533', u'ENSMUSG00000029416', u'ENSMUSG00000025790', u'ENSMUSG00000024130', u'ENSMUSG00000031633', u'ENSMUSG00000031144', u'ENSMUSG00000020829', u'ENSMUSG00000017679', u'ENSMUSG00000023030', u'ENSMUSG00000051111', u'ENSMUSG00000028970', u'ENSMUSG00000023032', u'ENSMUSG00000017740', u'ENSMUSG00000028976', u'ENSMUSG00000015090', u'ENSMUSG00000001082', u'ENSMUSG00000038212', u'ENSMUSG00000024036', u'ENSMUSG00000028773', u'ENSMUSG00000032519', u'ENSMUSG00000042797', u'ENSMUSG00000024737', u'ENSMUSG00000006641', u'ENSMUSG00000028962', u'ENSMUSG00000027340', u'ENSMUSG00000020334', u'ENSMUSG00000030237', u'ENSMUSG00000021733', u'ENSMUSG00000030235', u'ENSMUSG00000020570', u'ENSMUSG00000036298', u'ENSMUSG00000026904', u'ENSMUSG00000018566', u'ENSMUSG00000056296', u'ENSMUSG00000031617', u'ENSMUSG00000003153', u'ENSMUSG00000040693', u'ENSMUSG00000019874', u'ENSMUSG00000022199', u'ENSMUSG00000041828', u'ENSMUSG00000025243', u'ENSMUSG00000017765', u'ENSMUSG00000038486', u'ENSMUSG00000038267', u'ENSMUSG00000019785', u'ENSMUSG00000030108', u'ENSMUSG00000030109', u'ENSMUSG00000037344', u'ENSMUSG00000020805', u'ENSMUSG00000030737', u'ENSMUSG00000073988', u'ENSMUSG00000040667', u'ENSMUSG00000032122', u'ENSMUSG00000089911', u'ENSMUSG00000026177', u'ENSMUSG00000027076', u'ENSMUSG00000014606', u'ENSMUSG00000021079', u'ENSMUSG00000024411']), study_n=624, level=1, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0005478'])),
    NtGoeaResults(GO='GO:0005261', NS='MF', enrichment='p', name='cation channel activity', ratio_in_study=(1, 624), ratio_in_pop=(24, 13836), p_uncorrected=1.0, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000033033']), pop_n=13836, pop_count=24, pop_items=set([u'ENSMUSG00000052387', u'ENSMUSG00000032839', u'ENSMUSG00000009292', u'ENSMUSG00000033033', u'ENSMUSG00000000197', u'ENSMUSG00000032855', u'ENSMUSG00000048827', u'ENSMUSG00000018507', u'ENSMUSG00000004567', u'ENSMUSG00000059003', u'ENSMUSG00000049872', u'ENSMUSG00000023017', u'ENSMUSG00000014444', u'ENSMUSG00000014158', u'ENSMUSG00000020734', u'ENSMUSG00000030209', u'ENSMUSG00000020704', u'ENSMUSG00000031791', u'ENSMUSG00000028420', u'ENSMUSG00000026959', u'ENSMUSG00000031997', u'ENSMUSG00000002771', u'ENSMUSG00000041482', u'ENSMUSG00000027365']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0015338', 'GO:0015281'])),
    NtGoeaResults(GO='GO:0005355', NS='MF', enrichment='e', name='glucose transmembrane transporter activity', ratio_in_study=(1, 624), ratio_in_pop=(11, 13836), p_uncorrected=0.39819394973056993, depth=7, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000005107']), pop_n=13836, pop_count=11, pop_items=set([u'ENSMUSG00000005107', u'ENSMUSG00000059149', u'ENSMUSG00000039838', u'ENSMUSG00000036067', u'ENSMUSG00000026791', u'ENSMUSG00000018566', u'ENSMUSG00000037490', u'ENSMUSG00000036298', u'ENSMUSG00000028976', u'ENSMUSG00000003153', u'ENSMUSG00000028645']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0015579'])),
    NtGoeaResults(GO='GO:0005487', NS='MF', enrichment='e', name='nucleocytoplasmic transporter activity', ratio_in_study=(4, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.004831621977420333, depth=2, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=0.21020901600377773, study_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000052798', u'ENSMUSG00000001855', u'ENSMUSG00000021374']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000029430', u'ENSMUSG00000001855', u'ENSMUSG00000034826', u'ENSMUSG00000053293', u'ENSMUSG00000008450', u'ENSMUSG00000010097', u'ENSMUSG00000039509', u'ENSMUSG00000006005', u'ENSMUSG00000024604', u'ENSMUSG00000021374', u'ENSMUSG00000026999', u'ENSMUSG00000063895', u'ENSMUSG00000051329', u'ENSMUSG00000052798', u'ENSMUSG00000063550']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005504', NS='MF', enrichment='e', name='fatty acid binding', ratio_in_study=(1, 624), ratio_in_pop=(12, 13836), p_uncorrected=0.42535684125782375, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000019874']), pop_n=13836, pop_count=12, pop_items=set([u'ENSMUSG00000002250', u'ENSMUSG00000022555', u'ENSMUSG00000037062', u'ENSMUSG00000019874', u'ENSMUSG00000028138', u'ENSMUSG00000020777', u'ENSMUSG00000015090', u'ENSMUSG00000029098', u'ENSMUSG00000025132', u'ENSMUSG00000027533', u'ENSMUSG00000020857', u'ENSMUSG00000028773']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005506', NS='MF', enrichment='p', name='iron ion binding', ratio_in_study=(1, 624), ratio_in_pop=(72, 13836), p_uncorrected=0.3821958741710792, depth=6, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000004846']), pop_n=13836, pop_count=72, pop_items=set([u'ENSMUSG00000023191', u'ENSMUSG00000064294', u'ENSMUSG00000001467', u'ENSMUSG00000024292', u'ENSMUSG00000021241', u'ENSMUSG00000039519', u'ENSMUSG00000032374', u'ENSMUSG00000037071', u'ENSMUSG00000064254', u'ENSMUSG00000050103', u'ENSMUSG00000063415', u'ENSMUSG00000063558', u'ENSMUSG00000064351', u'ENSMUSG00000028641', u'ENSMUSG00000051048', u'ENSMUSG00000046791', u'ENSMUSG00000029361', u'ENSMUSG00000022477', u'ENSMUSG00000033579', u'ENSMUSG00000032018', u'ENSMUSG00000079057', u'ENSMUSG00000020810', u'ENSMUSG00000050708', u'ENSMUSG00000025169', u'ENSMUSG00000058355', u'ENSMUSG00000027983', u'ENSMUSG00000025899', u'ENSMUSG00000023030', u'ENSMUSG00000050370', u'ENSMUSG00000018906', u'ENSMUSG00000029925', u'ENSMUSG00000039753', u'ENSMUSG00000003814', u'ENSMUSG00000024661', u'ENSMUSG00000058709', u'ENSMUSG00000052914', u'ENSMUSG00000020892', u'ENSMUSG00000020891', u'ENSMUSG00000049439', u'ENSMUSG00000024066', u'ENSMUSG00000021259', u'ENSMUSG00000029993', u'ENSMUSG00000026833', u'ENSMUSG00000032807', u'ENSMUSG00000038168', u'ENSMUSG00000031604', u'ENSMUSG00000028978', u'ENSMUSG00000019055', u'ENSMUSG00000023707', u'ENSMUSG00000032051', u'ENSMUSG00000042599', u'ENSMUSG00000031987', u'ENSMUSG00000033009', u'ENSMUSG00000047155', u'ENSMUSG00000036450', u'ENSMUSG00000033022', u'ENSMUSG00000024087', u'ENSMUSG00000041229', u'ENSMUSG00000033308', u'ENSMUSG00000056962', u'ENSMUSG00000048495', u'ENSMUSG00000037710', u'ENSMUSG00000047146', u'ENSMUSG00000019916', u'ENSMUSG00000024588', u'ENSMUSG00000035105', u'ENSMUSG00000004846', u'ENSMUSG00000006675', u'ENSMUSG00000026170', u'ENSMUSG00000038025', u'ENSMUSG00000025825', u'ENSMUSG00000053470']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005507', NS='MF', enrichment='e', name='copper ion binding', ratio_in_study=(2, 624), ratio_in_pop=(38, 13836), p_uncorrected=0.689130661647687, depth=6, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000027399']), pop_n=13836, pop_count=38, pop_items=set([u'ENSMUSG00000091780', u'ENSMUSG00000020000', u'ENSMUSG00000029470', u'ENSMUSG00000042312', u'ENSMUSG00000059552', u'ENSMUSG00000031209', u'ENSMUSG00000046516', u'ENSMUSG00000026335', u'ENSMUSG00000051355', u'ENSMUSG00000000693', u'ENSMUSG00000003617', u'ENSMUSG00000024194', u'ENSMUSG00000026579', u'ENSMUSG00000034220', u'ENSMUSG00000023030', u'ENSMUSG00000032334', u'ENSMUSG00000034205', u'ENSMUSG00000028964', u'ENSMUSG00000034108', u'ENSMUSG00000033792', u'ENSMUSG00000078651', u'ENSMUSG00000072941', u'ENSMUSG00000079037', u'ENSMUSG00000072115', u'ENSMUSG00000020544', u'ENSMUSG00000064354', u'ENSMUSG00000006567', u'ENSMUSG00000027399', u'ENSMUSG00000031196', u'ENSMUSG00000022982', u'ENSMUSG00000031765', u'ENSMUSG00000024529', u'ENSMUSG00000044350', u'ENSMUSG00000025193', u'ENSMUSG00000027597', u'ENSMUSG00000025889', u'ENSMUSG00000018585', u'ENSMUSG00000041926']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005509', NS='MF', enrichment='p', name='calcium ion binding', ratio_in_study=(5, 624), ratio_in_pop=(393, 13836), p_uncorrected=0.0004888518126729105, depth=5, study_count=5, p_sm_bonferroni=1.0, p_fdr_bh=0.03443007430421853, study_items=set([u'ENSMUSG00000027171', u'ENSMUSG00000028860', u'ENSMUSG00000035683', u'ENSMUSG00000050944', u'ENSMUSG00000059674']), pop_n=13836, pop_count=393, pop_items=set([u'ENSMUSG00000026495', u'ENSMUSG00000066842', u'ENSMUSG00000063260', u'ENSMUSG00000058626', u'ENSMUSG00000027386', u'ENSMUSG00000055172', u'ENSMUSG00000004892', u'ENSMUSG00000027849', u'ENSMUSG00000030592', u'ENSMUSG00000023885', u'ENSMUSG00000023886', u'ENSMUSG00000003402', u'ENSMUSG00000016995', u'ENSMUSG00000074364', u'ENSMUSG00000021567', u'ENSMUSG00000022098', u'ENSMUSG00000055670', u'ENSMUSG00000039824', u'ENSMUSG00000031347', u'ENSMUSG00000053519', u'ENSMUSG00000040152', u'ENSMUSG00000019854', u'ENSMUSG00000021814', u'ENSMUSG00000021816', u'ENSMUSG00000002308', u'ENSMUSG00000022912', u'ENSMUSG00000030110', u'ENSMUSG00000020368', u'ENSMUSG00000062661', u'ENSMUSG00000001323', u'ENSMUSG00000015468', u'ENSMUSG00000026335', u'ENSMUSG00000032246', u'ENSMUSG00000001175', u'ENSMUSG00000039478', u'ENSMUSG00000048895', u'ENSMUSG00000026726', u'ENSMUSG00000024909', u'ENSMUSG00000057378', u'ENSMUSG00000054453', u'ENSMUSG00000001870', u'ENSMUSG00000054459', u'ENSMUSG00000022861', u'ENSMUSG00000031558', u'ENSMUSG00000069170', u'ENSMUSG00000045912', u'ENSMUSG00000059898', u'ENSMUSG00000035864', u'ENSMUSG00000042644', u'ENSMUSG00000046093', u'ENSMUSG00000074743', u'ENSMUSG00000049252', u'ENSMUSG00000028373', u'ENSMUSG00000030538', u'ENSMUSG00000068115', u'ENSMUSG00000047428', u'ENSMUSG00000025370', u'ENSMUSG00000015112', u'ENSMUSG00000031837', u'ENSMUSG00000026509', u'ENSMUSG00000021537', u'ENSMUSG00000028207', u'ENSMUSG00000037820', u'ENSMUSG00000024397', u'ENSMUSG00000051323', u'ENSMUSG00000029076', u'ENSMUSG00000040061', u'ENSMUSG00000036062', u'ENSMUSG00000043019', u'ENSMUSG00000058420', u'ENSMUSG00000024150', u'ENSMUSG00000061601', u'ENSMUSG00000005973', u'ENSMUSG00000032946', u'ENSMUSG00000002808', u'ENSMUSG00000026879', u'ENSMUSG00000029919', u'ENSMUSG00000032231', u'ENSMUSG00000034098', u'ENSMUSG00000025473', u'ENSMUSG00000079056', u'ENSMUSG00000024304', u'ENSMUSG00000025575', u'ENSMUSG00000038146', u'ENSMUSG00000040249', u'ENSMUSG00000036438', u'ENSMUSG00000016918', u'ENSMUSG00000025357', u'ENSMUSG00000050989', u'ENSMUSG00000003161', u'ENSMUSG00000028613', u'ENSMUSG00000027171', u'ENSMUSG00000029359', u'ENSMUSG00000027276', u'ENSMUSG00000034488', u'ENSMUSG00000034891', u'ENSMUSG00000004110', u'ENSMUSG00000021068', u'ENSMUSG00000004113', u'ENSMUSG00000006675', u'ENSMUSG00000054808', u'ENSMUSG00000027010', u'ENSMUSG00000046743', u'ENSMUSG00000045039', u'ENSMUSG00000018340', u'ENSMUSG00000045031', u'ENSMUSG00000027878', u'ENSMUSG00000023272', u'ENSMUSG00000028927', u'ENSMUSG00000027712', u'ENSMUSG00000021614', u'ENSMUSG00000023473', u'ENSMUSG00000002413', u'ENSMUSG00000031871', u'ENSMUSG00000030279', u'ENSMUSG00000021576', u'ENSMUSG00000041936', u'ENSMUSG00000059674', u'ENSMUSG00000030287', u'ENSMUSG00000030284', u'ENSMUSG00000044912', u'ENSMUSG00000018593', u'ENSMUSG00000021806', u'ENSMUSG00000021803', u'ENSMUSG00000017686', u'ENSMUSG00000030302', u'ENSMUSG00000001794', u'ENSMUSG00000063600', u'ENSMUSG00000027435', u'ENSMUSG00000022637', u'ENSMUSG00000036095', u'ENSMUSG00000053166', u'ENSMUSG00000032570', u'ENSMUSG00000021973', u'ENSMUSG00000090841', u'ENSMUSG00000024754', u'ENSMUSG00000026921', u'ENSMUSG00000026923', u'ENSMUSG00000010660', u'ENSMUSG00000019539', u'ENSMUSG00000040322', u'ENSMUSG00000028785', u'ENSMUSG00000057751', u'ENSMUSG00000030659', u'ENSMUSG00000005397', u'ENSMUSG00000009075', u'ENSMUSG00000022441', u'ENSMUSG00000034593', u'ENSMUSG00000021596', u'ENSMUSG00000029781', u'ENSMUSG00000028860', u'ENSMUSG00000001864', u'ENSMUSG00000046329', u'ENSMUSG00000025221', u'ENSMUSG00000014077', u'ENSMUSG00000027506', u'ENSMUSG00000050944', u'ENSMUSG00000027293', u'ENSMUSG00000027188', u'ENSMUSG00000027220', u'ENSMUSG00000027347', u'ENSMUSG00000051747', u'ENSMUSG00000048347', u'ENSMUSG00000051627', u'ENSMUSG00000028047', u'ENSMUSG00000028369', u'ENSMUSG00000040998', u'ENSMUSG00000055409', u'ENSMUSG00000040855', u'ENSMUSG00000029767', u'ENSMUSG00000035403', u'ENSMUSG00000004730', u'ENSMUSG00000042473', u'ENSMUSG00000030824', u'ENSMUSG00000053626', u'ENSMUSG00000022620', u'ENSMUSG00000040452', u'ENSMUSG00000003814', u'ENSMUSG00000029994', u'ENSMUSG00000024065', u'ENSMUSG00000068740', u'ENSMUSG00000031661', u'ENSMUSG00000073791', u'ENSMUSG00000078622', u'ENSMUSG00000067818', u'ENSMUSG00000004961', u'ENSMUSG00000071379', u'ENSMUSG00000019370', u'ENSMUSG00000021186', u'ENSMUSG00000048827', u'ENSMUSG00000026312', u'ENSMUSG00000039952', u'ENSMUSG00000039953', u'ENSMUSG00000002885', u'ENSMUSG00000037493', u'ENSMUSG00000026819', u'ENSMUSG00000030218', u'ENSMUSG00000044043', u'ENSMUSG00000029446', u'ENSMUSG00000036422', u'ENSMUSG00000024960', u'ENSMUSG00000006800', u'ENSMUSG00000051678', u'ENSMUSG00000028749', u'ENSMUSG00000030616', u'ENSMUSG00000051177', u'ENSMUSG00000041771', u'ENSMUSG00000021136', u'ENSMUSG00000037996', u'ENSMUSG00000009292', u'ENSMUSG00000028552', u'ENSMUSG00000039676', u'ENSMUSG00000020848', u'ENSMUSG00000037306', u'ENSMUSG00000034342', u'ENSMUSG00000025733', u'ENSMUSG00000035683', u'ENSMUSG00000027314', u'ENSMUSG00000052613', u'ENSMUSG00000021608', u'ENSMUSG00000040659', u'ENSMUSG00000050840', u'ENSMUSG00000015143', u'ENSMUSG00000016028', u'ENSMUSG00000064080', u'ENSMUSG00000074264', u'ENSMUSG00000038074', u'ENSMUSG00000008763', u'ENSMUSG00000006276', u'ENSMUSG00000001555', u'ENSMUSG00000024109', u'ENSMUSG00000031709', u'ENSMUSG00000050505', u'ENSMUSG00000035064', u'ENSMUSG00000000303', u'ENSMUSG00000032369', u'ENSMUSG00000000305', u'ENSMUSG00000042401', u'ENSMUSG00000026131', u'ENSMUSG00000041959', u'ENSMUSG00000052374', u'ENSMUSG00000020640', u'ENSMUSG00000056481', u'ENSMUSG00000038677', u'ENSMUSG00000036766', u'ENSMUSG00000017692', u'ENSMUSG00000074505', u'ENSMUSG00000021998', u'ENSMUSG00000033361', u'ENSMUSG00000049493', u'ENSMUSG00000026452', u'ENSMUSG00000047793', u'ENSMUSG00000051359', u'ENSMUSG00000021866', u'ENSMUSG00000036644', u'ENSMUSG00000022324', u'ENSMUSG00000022321', u'ENSMUSG00000024743', u'ENSMUSG00000056220', u'ENSMUSG00000056222', u'ENSMUSG00000058297', u'ENSMUSG00000020467', u'ENSMUSG00000028779', u'ENSMUSG00000022454', u'ENSMUSG00000044080', u'ENSMUSG00000046318', u'ENSMUSG00000025889', u'ENSMUSG00000033208', u'ENSMUSG00000036264', u'ENSMUSG00000057738', u'ENSMUSG00000037605', u'ENSMUSG00000033192', u'ENSMUSG00000020891', u'ENSMUSG00000036834', u'ENSMUSG00000025393', u'ENSMUSG00000016200', u'ENSMUSG00000039167', u'ENSMUSG00000016933', u'ENSMUSG00000038521', u'ENSMUSG00000029471', u'ENSMUSG00000036510', u'ENSMUSG00000034868', u'ENSMUSG00000016382', u'ENSMUSG00000024924', u'ENSMUSG00000029484', u'ENSMUSG00000041193', u'ENSMUSG00000056755', u'ENSMUSG00000001025', u'ENSMUSG00000034462', u'ENSMUSG00000062542', u'ENSMUSG00000040856', u'ENSMUSG00000021702', u'ENSMUSG00000030102', u'ENSMUSG00000030104', u'ENSMUSG00000031451', u'ENSMUSG00000027999', u'ENSMUSG00000075254', u'ENSMUSG00000030428', u'ENSMUSG00000027070', u'ENSMUSG00000026173', u'ENSMUSG00000032320', u'ENSMUSG00000014773', u'ENSMUSG00000014776', u'ENSMUSG00000028222', u'ENSMUSG00000025854', u'ENSMUSG00000017639', u'ENSMUSG00000062591', u'ENSMUSG00000029055', u'ENSMUSG00000040488', u'ENSMUSG00000002799', u'ENSMUSG00000031673', u'ENSMUSG00000042286', u'ENSMUSG00000020111', u'ENSMUSG00000033953', u'ENSMUSG00000063873', u'ENSMUSG00000090223', u'ENSMUSG00000031841', u'ENSMUSG00000029608', u'ENSMUSG00000026959', u'ENSMUSG00000026893', u'ENSMUSG00000024772', u'ENSMUSG00000037892', u'ENSMUSG00000003746', u'ENSMUSG00000054162', u'ENSMUSG00000026827', u'ENSMUSG00000022425', u'ENSMUSG00000028649', u'ENSMUSG00000060126', u'ENSMUSG00000029309', u'ENSMUSG00000027489', u'ENSMUSG00000036707', u'ENSMUSG00000030607', u'ENSMUSG00000024598', u'ENSMUSG00000036862', u'ENSMUSG00000037098', u'ENSMUSG00000074643', u'ENSMUSG00000027253', u'ENSMUSG00000062372', u'ENSMUSG00000032776', u'ENSMUSG00000049303', u'ENSMUSG00000029544', u'ENSMUSG00000025020', u'ENSMUSG00000041809', u'ENSMUSG00000037370', u'ENSMUSG00000068263', u'ENSMUSG00000035694', u'ENSMUSG00000033788', u'ENSMUSG00000026234', u'ENSMUSG00000012819', u'ENSMUSG00000042961', u'ENSMUSG00000006369', u'ENSMUSG00000042312', u'ENSMUSG00000005716', u'ENSMUSG00000040536', u'ENSMUSG00000002190', u'ENSMUSG00000052301', u'ENSMUSG00000036646', u'ENSMUSG00000045876', u'ENSMUSG00000008153', u'ENSMUSG00000039385', u'ENSMUSG00000074457', u'ENSMUSG00000021313', u'ENSMUSG00000022887', u'ENSMUSG00000032193', u'ENSMUSG00000026994', u'ENSMUSG00000029161', u'ENSMUSG00000029088', u'ENSMUSG00000056427', u'ENSMUSG00000016763', u'ENSMUSG00000032452', u'ENSMUSG00000002341', u'ENSMUSG00000060371', u'ENSMUSG00000044393', u'ENSMUSG00000068617', u'ENSMUSG00000035311', u'ENSMUSG00000028763', u'ENSMUSG00000003657', u'ENSMUSG00000026255', u'ENSMUSG00000054423', u'ENSMUSG00000079110', u'ENSMUSG00000022957', u'ENSMUSG00000022952', u'ENSMUSG00000022816', u'ENSMUSG00000049225', u'ENSMUSG00000029467', u'ENSMUSG00000039156', u'ENSMUSG00000024940', u'ENSMUSG00000024942', u'ENSMUSG00000024261', u'ENSMUSG00000030987', u'ENSMUSG00000030731', u'ENSMUSG00000027204', u'ENSMUSG00000021171']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005515', NS='MF', enrichment='e', name='protein binding', ratio_in_study=(198, 624), ratio_in_pop=(3772, 13836), p_uncorrected=0.011375416361626303, depth=2, study_count=198, p_sm_bonferroni=1.0, p_fdr_bh=0.35082679952497703, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000008200', u'ENSMUSG00000040084', u'ENSMUSG00000003873', u'ENSMUSG00000027469', u'ENSMUSG00000021714', u'ENSMUSG00000024079', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000042699', u'ENSMUSG00000059552', u'ENSMUSG00000005057', u'ENSMUSG00000022360', u'ENSMUSG00000006930', u'ENSMUSG00000017548', u'ENSMUSG00000025507', u'ENSMUSG00000019961', u'ENSMUSG00000020599', u'ENSMUSG00000020897', u'ENSMUSG00000020592', u'ENSMUSG00000019773', u'ENSMUSG00000025758', u'ENSMUSG00000021569', u'ENSMUSG00000028233', u'ENSMUSG00000042029', u'ENSMUSG00000002748', u'ENSMUSG00000020185', u'ENSMUSG00000020184', u'ENSMUSG00000002068', u'ENSMUSG00000041147', u'ENSMUSG00000026950', u'ENSMUSG00000005566', u'ENSMUSG00000037313', u'ENSMUSG00000006445', u'ENSMUSG00000033257', u'ENSMUSG00000026896', u'ENSMUSG00000027715', u'ENSMUSG00000047735', u'ENSMUSG00000028068', u'ENSMUSG00000023067', u'ENSMUSG00000027490', u'ENSMUSG00000002307', u'ENSMUSG00000027496', u'ENSMUSG00000036875', u'ENSMUSG00000026622', u'ENSMUSG00000054675', u'ENSMUSG00000038482', u'ENSMUSG00000028873', u'ENSMUSG00000007589', u'ENSMUSG00000032487', u'ENSMUSG00000024056', u'ENSMUSG00000034023', u'ENSMUSG00000029730', u'ENSMUSG00000036986', u'ENSMUSG00000068394', u'ENSMUSG00000021485', u'ENSMUSG00000054717', u'ENSMUSG00000038685', u'ENSMUSG00000049932', u'ENSMUSG00000052684', u'ENSMUSG00000032397', u'ENSMUSG00000003573', u'ENSMUSG00000035683', u'ENSMUSG00000028884', u'ENSMUSG00000002221', u'ENSMUSG00000034422', u'ENSMUSG00000027641', u'ENSMUSG00000034349', u'ENSMUSG00000030867', u'ENSMUSG00000037868', u'ENSMUSG00000047534', u'ENSMUSG00000047730', u'ENSMUSG00000057789', u'ENSMUSG00000032409', u'ENSMUSG00000027883', u'ENSMUSG00000028312', u'ENSMUSG00000027433', u'ENSMUSG00000004099', u'ENSMUSG00000036992', u'ENSMUSG00000031629', u'ENSMUSG00000031353', u'ENSMUSG00000040734', u'ENSMUSG00000020290', u'ENSMUSG00000071646', u'ENSMUSG00000028893', u'ENSMUSG00000035692', u'ENSMUSG00000037572', u'ENSMUSG00000021374', u'ENSMUSG00000052565', u'ENSMUSG00000020641', u'ENSMUSG00000040033', u'ENSMUSG00000024991', u'ENSMUSG00000006585', u'ENSMUSG00000022021', u'ENSMUSG00000031885', u'ENSMUSG00000020649', u'ENSMUSG00000022026', u'ENSMUSG00000023994', u'ENSMUSG00000032586', u'ENSMUSG00000028066', u'ENSMUSG00000036928', u'ENSMUSG00000058773', u'ENSMUSG00000030107', u'ENSMUSG00000039395', u'ENSMUSG00000024833', u'ENSMUSG00000025017', u'ENSMUSG00000074896', u'ENSMUSG00000002699', u'ENSMUSG00000030528', u'ENSMUSG00000028718', u'ENSMUSG00000025498', u'ENSMUSG00000031311', u'ENSMUSG00000042557', u'ENSMUSG00000032508', u'ENSMUSG00000039994', u'ENSMUSG00000028860', u'ENSMUSG00000026355', u'ENSMUSG00000054115', u'ENSMUSG00000020914', u'ENSMUSG00000027331', u'ENSMUSG00000042726', u'ENSMUSG00000022322', u'ENSMUSG00000018983', u'ENSMUSG00000000037', u'ENSMUSG00000041133', u'ENSMUSG00000024989', u'ENSMUSG00000021624', u'ENSMUSG00000027699', u'ENSMUSG00000027514', u'ENSMUSG00000020898', u'ENSMUSG00000040195', u'ENSMUSG00000055760', u'ENSMUSG00000042167', u'ENSMUSG00000030254', u'ENSMUSG00000033355', u'ENSMUSG00000025001', u'ENSMUSG00000036822', u'ENSMUSG00000024795', u'ENSMUSG00000032344', u'ENSMUSG00000024521', u'ENSMUSG00000034459', u'ENSMUSG00000040296', u'ENSMUSG00000027109', u'ENSMUSG00000034601', u'ENSMUSG00000035764', u'ENSMUSG00000027342', u'ENSMUSG00000001123', u'ENSMUSG00000002227', u'ENSMUSG00000025395', u'ENSMUSG00000018930', u'ENSMUSG00000003824', u'ENSMUSG00000027454', u'ENSMUSG00000006715', u'ENSMUSG00000031133', u'ENSMUSG00000028282', u'ENSMUSG00000002835', u'ENSMUSG00000004446', u'ENSMUSG00000037188', u'ENSMUSG00000027323', u'ENSMUSG00000049539', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000024097', u'ENSMUSG00000026069', u'ENSMUSG00000000386', u'ENSMUSG00000026104', u'ENSMUSG00000016477', u'ENSMUSG00000001517', u'ENSMUSG00000018899', u'ENSMUSG00000006398', u'ENSMUSG00000030978', u'ENSMUSG00000070337', u'ENSMUSG00000028693', u'ENSMUSG00000045273', u'ENSMUSG00000034218', u'ENSMUSG00000022673', u'ENSMUSG00000068744', u'ENSMUSG00000016496', u'ENSMUSG00000041431', u'ENSMUSG00000041846', u'ENSMUSG00000018362', u'ENSMUSG00000029580', u'ENSMUSG00000026039', u'ENSMUSG00000001228', u'ENSMUSG00000031527', u'ENSMUSG00000079553', u'ENSMUSG00000032128', u'ENSMUSG00000002083', u'ENSMUSG00000002325', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000036202', u'ENSMUSG00000020889', u'ENSMUSG00000027078', u'ENSMUSG00000060519', u'ENSMUSG00000022945', u'ENSMUSG00000024308']), pop_n=13836, pop_count=3772, pop_items=set([u'ENSMUSG00000002017', u'ENSMUSG00000002015', u'ENSMUSG00000040415', u'ENSMUSG00000020190', u'ENSMUSG00000074886', u'ENSMUSG00000006005', u'ENSMUSG00000026021', u'ENSMUSG00000018379', u'ENSMUSG00000004897', u'ENSMUSG00000028344', u'ENSMUSG00000004891', u'ENSMUSG00000028434', u'ENSMUSG00000038894', u'ENSMUSG00000031378', u'ENSMUSG00000045005', u'ENSMUSG00000044080', u'ENSMUSG00000034957', u'ENSMUSG00000034403', u'ENSMUSG00000035139', u'ENSMUSG00000032334', u'ENSMUSG00000042453', u'ENSMUSG00000045482', u'ENSMUSG00000023885', u'ENSMUSG00000038550', u'ENSMUSG00000023883', u'ENSMUSG00000056493', u'ENSMUSG00000024048', u'ENSMUSG00000021569', u'ENSMUSG00000021714', u'ENSMUSG00000033862', u'ENSMUSG00000022013', u'ENSMUSG00000028233', u'ENSMUSG00000024042', u'ENSMUSG00000026430', u'ENSMUSG00000074364', u'ENSMUSG00000024045', u'ENSMUSG00000052852', u'ENSMUSG00000043962', u'ENSMUSG00000042487', u'ENSMUSG00000038332', u'ENSMUSG00000058267', u'ENSMUSG00000053581', u'ENSMUSG00000068015', u'ENSMUSG00000002496', u'ENSMUSG00000053693', u'ENSMUSG00000046269', u'ENSMUSG00000032020', u'ENSMUSG00000042292', u'ENSMUSG00000045827', u'ENSMUSG00000032796', u'ENSMUSG00000002307', u'ENSMUSG00000044847', u'ENSMUSG00000041598', u'ENSMUSG00000053453', u'ENSMUSG00000021810', u'ENSMUSG00000028343', u'ENSMUSG00000004947', u'ENSMUSG00000002658', u'ENSMUSG00000021816', u'ENSMUSG00000049630', u'ENSMUSG00000027404', u'ENSMUSG00000041014', u'ENSMUSG00000020366', u'ENSMUSG00000020361', u'ENSMUSG00000013858', u'ENSMUSG00000020368', u'ENSMUSG00000015461', u'ENSMUSG00000018209', u'ENSMUSG00000044667', u'ENSMUSG00000024735', u'ENSMUSG00000043895', u'ENSMUSG00000015468', u'ENSMUSG00000034116', u'ENSMUSG00000002279', u'ENSMUSG00000032249', u'ENSMUSG00000019823', u'ENSMUSG00000019820', u'ENSMUSG00000024193', u'ENSMUSG00000021963', u'ENSMUSG00000041417', u'ENSMUSG00000060240', u'ENSMUSG00000001270', u'ENSMUSG00000069539', u'ENSMUSG00000005204', u'ENSMUSG00000090247', u'ENSMUSG00000006958', u'ENSMUSG00000079037', u'ENSMUSG00000035279', u'ENSMUSG00000048285', u'ENSMUSG00000010376', u'ENSMUSG00000066640', u'ENSMUSG00000030662', u'ENSMUSG00000054455', u'ENSMUSG00000036499', u'ENSMUSG00000054452', u'ENSMUSG00000054453', u'ENSMUSG00000027104', u'ENSMUSG00000001300', u'ENSMUSG00000021589', u'ENSMUSG00000055980', u'ENSMUSG00000057982', u'ENSMUSG00000005373', u'ENSMUSG00000022865', u'ENSMUSG00000001098', u'ENSMUSG00000037608', u'ENSMUSG00000024990', u'ENSMUSG00000024991', u'ENSMUSG00000020211', u'ENSMUSG00000027245', u'ENSMUSG00000020964', u'ENSMUSG00000037149', u'ENSMUSG00000020962', u'ENSMUSG00000020961', u'ENSMUSG00000041548', u'ENSMUSG00000030796', u'ENSMUSG00000027273', u'ENSMUSG00000026596', u'ENSMUSG00000007207', u'ENSMUSG00000030409', u'ENSMUSG00000038780', u'ENSMUSG00000020986', u'ENSMUSG00000037364', u'ENSMUSG00000031628', u'ENSMUSG00000030403', u'ENSMUSG00000036560', u'ENSMUSG00000010175', u'ENSMUSG00000022636', u'ENSMUSG00000036564', u'ENSMUSG00000033047', u'ENSMUSG00000030067', u'ENSMUSG00000027624', u'ENSMUSG00000026672', u'ENSMUSG00000024539', u'ENSMUSG00000030061', u'ENSMUSG00000023328', u'ENSMUSG00000019066', u'ENSMUSG00000027331', u'ENSMUSG00000027330', u'ENSMUSG00000030881', u'ENSMUSG00000071713', u'ENSMUSG00000027339', u'ENSMUSG00000015605', u'ENSMUSG00000026204', u'ENSMUSG00000026754', u'ENSMUSG00000049313', u'ENSMUSG00000030084', u'ENSMUSG00000030087', u'ENSMUSG00000030089', u'ENSMUSG00000030088', u'ENSMUSG00000050947', u'ENSMUSG00000037211', u'ENSMUSG00000030530', u'ENSMUSG00000030533', u'ENSMUSG00000056749', u'ENSMUSG00000030534', u'ENSMUSG00000037217', u'ENSMUSG00000030536', u'ENSMUSG00000030539', u'ENSMUSG00000030538', u'ENSMUSG00000031337', u'ENSMUSG00000031429', u'ENSMUSG00000040732', u'ENSMUSG00000031930', u'ENSMUSG00000026117', u'ENSMUSG00000031425', u'ENSMUSG00000000325', u'ENSMUSG00000031935', u'ENSMUSG00000022125', u'ENSMUSG00000022124', u'ENSMUSG00000033032', u'ENSMUSG00000014418', u'ENSMUSG00000022122', u'ENSMUSG00000019647', u'ENSMUSG00000058589', u'ENSMUSG00000003824', u'ENSMUSG00000039782', u'ENSMUSG00000073888', u'ENSMUSG00000030339', u'ENSMUSG00000025872', u'ENSMUSG00000070509', u'ENSMUSG00000039431', u'ENSMUSG00000048100', u'ENSMUSG00000030330', u'ENSMUSG00000040093', u'ENSMUSG00000021366', u'ENSMUSG00000031201', u'ENSMUSG00000031202', u'ENSMUSG00000021365', u'ENSMUSG00000030035', u'ENSMUSG00000004446', u'ENSMUSG00000051243', u'ENSMUSG00000023051', u'ENSMUSG00000026576', u'ENSMUSG00000026577', u'ENSMUSG00000023055', u'ENSMUSG00000022051', u'ENSMUSG00000026578', u'ENSMUSG00000022055', u'ENSMUSG00000031681', u'ENSMUSG00000029001', u'ENSMUSG00000063856', u'ENSMUSG00000042903', u'ENSMUSG00000026374', u'ENSMUSG00000003226', u'ENSMUSG00000022698', u'ENSMUSG00000062270', u'ENSMUSG00000003228', u'ENSMUSG00000007021', u'ENSMUSG00000037815', u'ENSMUSG00000025967', u'ENSMUSG00000024168', u'ENSMUSG00000058975', u'ENSMUSG00000036817', u'ENSMUSG00000029817', u'ENSMUSG00000022673', u'ENSMUSG00000009640', u'ENSMUSG00000009647', u'ENSMUSG00000022674', u'ENSMUSG00000022679', u'ENSMUSG00000022678', u'ENSMUSG00000025583', u'ENSMUSG00000029173', u'ENSMUSG00000025478', u'ENSMUSG00000057342', u'ENSMUSG00000029915', u'ENSMUSG00000025473', u'ENSMUSG00000029910', u'ENSMUSG00000022272', u'ENSMUSG00000025278', u'ENSMUSG00000037112', u'ENSMUSG00000025902', u'ENSMUSG00000025907', u'ENSMUSG00000026803', u'ENSMUSG00000042594', u'ENSMUSG00000068154', u'ENSMUSG00000039220', u'ENSMUSG00000029757', u'ENSMUSG00000039989', u'ENSMUSG00000072235', u'ENSMUSG00000020697', u'ENSMUSG00000001025', u'ENSMUSG00000000126', u'ENSMUSG00000061436', u'ENSMUSG00000043463', u'ENSMUSG00000022475', u'ENSMUSG00000022472', u'ENSMUSG00000022471', u'ENSMUSG00000025616', u'ENSMUSG00000067578', u'ENSMUSG00000025612', u'ENSMUSG00000025613', u'ENSMUSG00000034321', u'ENSMUSG00000051735', u'ENSMUSG00000021108', u'ENSMUSG00000021109', u'ENSMUSG00000027351', u'ENSMUSG00000038312', u'ENSMUSG00000052539', u'ENSMUSG00000021103', u'ENSMUSG00000032586', u'ENSMUSG00000027602', u'ENSMUSG00000020189', u'ENSMUSG00000042298', u'ENSMUSG00000031028', u'ENSMUSG00000020185', u'ENSMUSG00000020184', u'ENSMUSG00000002068', u'ENSMUSG00000020186', u'ENSMUSG00000045038', u'ENSMUSG00000028402', u'ENSMUSG00000042029', u'ENSMUSG00000018697', u'ENSMUSG00000039615', u'ENSMUSG00000025128', u'ENSMUSG00000025050', u'ENSMUSG00000068335', u'ENSMUSG00000034432', u'ENSMUSG00000003033', u'ENSMUSG00000035949', u'ENSMUSG00000042116', u'ENSMUSG00000032309', u'ENSMUSG00000035431', u'ENSMUSG00000035722', u'ENSMUSG00000032652', u'ENSMUSG00000029713', u'ENSMUSG00000039130', u'ENSMUSG00000021619', u'ENSMUSG00000039137', u'ENSMUSG00000020745', u'ENSMUSG00000028782', u'ENSMUSG00000033871', u'ENSMUSG00000079259', u'ENSMUSG00000006304', u'ENSMUSG00000021576', u'ENSMUSG00000063450', u'ENSMUSG00000063457', u'ENSMUSG00000024050', u'ENSMUSG00000029249', u'ENSMUSG00000045103', u'ENSMUSG00000068798', u'ENSMUSG00000057156', u'ENSMUSG00000033949', u'ENSMUSG00000034687', u'ENSMUSG00000046352', u'ENSMUSG00000032017', u'ENSMUSG00000032010', u'ENSMUSG00000032412', u'ENSMUSG00000032012', u'ENSMUSG00000021779', u'ENSMUSG00000053929', u'ENSMUSG00000019907', u'ENSMUSG00000019906', u'ENSMUSG00000023980', u'ENSMUSG00000036023', u'ENSMUSG00000078671', u'ENSMUSG00000004936', u'ENSMUSG00000021806', u'ENSMUSG00000004934', u'ENSMUSG00000021803', u'ENSMUSG00000044365', u'ENSMUSG00000020358', u'ENSMUSG00000001794', u'ENSMUSG00000022905', u'ENSMUSG00000049583', u'ENSMUSG00000027433', u'ENSMUSG00000020354', u'ENSMUSG00000029621', u'ENSMUSG00000020357', u'ENSMUSG00000068663', u'ENSMUSG00000039910', u'ENSMUSG00000039911', u'ENSMUSG00000032419', u'ENSMUSG00000078816', u'ENSMUSG00000002688', u'ENSMUSG00000015478', u'ENSMUSG00000079487', u'ENSMUSG00000036158', u'ENSMUSG00000024188', u'ENSMUSG00000031458', u'ENSMUSG00000019831', u'ENSMUSG00000021814', u'ENSMUSG00000024186', u'ENSMUSG00000031592', u'ENSMUSG00000024182', u'ENSMUSG00000021973', u'ENSMUSG00000021972', u'ENSMUSG00000024451', u'ENSMUSG00000079657', u'ENSMUSG00000024456', u'ENSMUSG00000024454', u'ENSMUSG00000004849', u'ENSMUSG00000028224', u'ENSMUSG00000036790', u'ENSMUSG00000032060', u'ENSMUSG00000058773', u'ENSMUSG00000041846', u'ENSMUSG00000032872', u'ENSMUSG00000032870', u'ENSMUSG00000038462', u'ENSMUSG00000064128', u'ENSMUSG00000038467', u'ENSMUSG00000055067', u'ENSMUSG00000030654', u'ENSMUSG00000022914', u'ENSMUSG00000037685', u'ENSMUSG00000034755', u'ENSMUSG00000033276', u'ENSMUSG00000021597', u'ENSMUSG00000037174', u'ENSMUSG00000001313', u'ENSMUSG00000045349', u'ENSMUSG00000054115', u'ENSMUSG00000024985', u'ENSMUSG00000079036', u'ENSMUSG00000042726', u'ENSMUSG00000026837', u'ENSMUSG00000000223', u'ENSMUSG00000024231', u'ENSMUSG00000024982', u'ENSMUSG00000020224', u'ENSMUSG00000027506', u'ENSMUSG00000056763', u'ENSMUSG00000024989', u'ENSMUSG00000076432', u'ENSMUSG00000026278', u'ENSMUSG00000026587', u'ENSMUSG00000026585', u'ENSMUSG00000016921', u'ENSMUSG00000031527', u'ENSMUSG00000033454', u'ENSMUSG00000043384', u'ENSMUSG00000040669', u'ENSMUSG00000037196', u'ENSMUSG00000027291', u'ENSMUSG00000027293', u'ENSMUSG00000024529', u'ENSMUSG00000024528', u'ENSMUSG00000005102', u'ENSMUSG00000037519', u'ENSMUSG00000024521', u'ENSMUSG00000024527', u'ENSMUSG00000024526', u'ENSMUSG00000056962', u'ENSMUSG00000041731', u'ENSMUSG00000040359', u'ENSMUSG00000027342', u'ENSMUSG00000041734', u'ENSMUSG00000026740', u'ENSMUSG00000026743', u'ENSMUSG00000074622', u'ENSMUSG00000027995', u'ENSMUSG00000014402', u'ENSMUSG00000023191', u'ENSMUSG00000027770', u'ENSMUSG00000027993', u'ENSMUSG00000038084', u'ENSMUSG00000054934', u'ENSMUSG00000040990', u'ENSMUSG00000030505', u'ENSMUSG00000030850', u'ENSMUSG00000041912', u'ENSMUSG00000041911', u'ENSMUSG00000061689', u'ENSMUSG00000058715', u'ENSMUSG00000057058', u'ENSMUSG00000041351', u'ENSMUSG00000031928', u'ENSMUSG00000030435', u'ENSMUSG00000031921', u'ENSMUSG00000071637', u'ENSMUSG00000031922', u'ENSMUSG00000027985', u'ENSMUSG00000031431', u'ENSMUSG00000055302', u'ENSMUSG00000026103', u'ENSMUSG00000062300', u'ENSMUSG00000058594', u'ENSMUSG00000026104', u'ENSMUSG00000003814', u'ENSMUSG00000003810', u'ENSMUSG00000004328', u'ENSMUSG00000048756', u'ENSMUSG00000000915', u'ENSMUSG00000025860', u'ENSMUSG00000027479', u'ENSMUSG00000027965', u'ENSMUSG00000034157', u'ENSMUSG00000022108', u'ENSMUSG00000030342', u'ENSMUSG00000019828', u'ENSMUSG00000030341', u'ENSMUSG00000021375', u'ENSMUSG00000021374', u'ENSMUSG00000031214', u'ENSMUSG00000073702', u'ENSMUSG00000004455', u'ENSMUSG00000031748', u'ENSMUSG00000029404', u'ENSMUSG00000021379', u'ENSMUSG00000040462', u'ENSMUSG00000023043', u'ENSMUSG00000040463', u'ENSMUSG00000026565', u'ENSMUSG00000031328', u'ENSMUSG00000039952', u'ENSMUSG00000026365', u'ENSMUSG00000029563', u'ENSMUSG00000031696', u'ENSMUSG00000026361', u'ENSMUSG00000024197', u'ENSMUSG00000026179', u'ENSMUSG00000032589', u'ENSMUSG00000068923', u'ENSMUSG00000026960', u'ENSMUSG00000061136', u'ENSMUSG00000020516', u'ENSMUSG00000009630', u'ENSMUSG00000029613', u'ENSMUSG00000029610', u'ENSMUSG00000003070', u'ENSMUSG00000029104', u'ENSMUSG00000045671', u'ENSMUSG00000026171', u'ENSMUSG00000042406', u'ENSMUSG00000029108', u'ENSMUSG00000034557', u'ENSMUSG00000029291', u'ENSMUSG00000025265', u'ENSMUSG00000072647', u'ENSMUSG00000025917', u'ENSMUSG00000026810', u'ENSMUSG00000026812', u'ENSMUSG00000039231', u'ENSMUSG00000026814', u'ENSMUSG00000020423', u'ENSMUSG00000039239', u'ENSMUSG00000029723', u'ENSMUSG00000025287', u'ENSMUSG00000025289', u'ENSMUSG00000051747', u'ENSMUSG00000025609', u'ENSMUSG00000070733', u'ENSMUSG00000028745', u'ENSMUSG00000000861', u'ENSMUSG00000034336', u'ENSMUSG00000034330', u'ENSMUSG00000005897', u'ENSMUSG00000021116', u'ENSMUSG00000036977', u'ENSMUSG00000005893', u'ENSMUSG00000021112', u'ENSMUSG00000029430', u'ENSMUSG00000009569', u'ENSMUSG00000032487', u'ENSMUSG00000065037', u'ENSMUSG00000032485', u'ENSMUSG00000029439', u'ENSMUSG00000009563', u'ENSMUSG00000032481', u'ENSMUSG00000009293', u'ENSMUSG00000049939', u'ENSMUSG00000025139', u'ENSMUSG00000028413', u'ENSMUSG00000025132', u'ENSMUSG00000025130', u'ENSMUSG00000008348', u'ENSMUSG00000048402', u'ENSMUSG00000035681', u'ENSMUSG00000028525', u'ENSMUSG00000025732', u'ENSMUSG00000049800', u'ENSMUSG00000035686', u'ENSMUSG00000025040', u'ENSMUSG00000031671', u'ENSMUSG00000069255', u'ENSMUSG00000042105', u'ENSMUSG00000045730', u'ENSMUSG00000074001', u'ENSMUSG00000052504', u'ENSMUSG00000007827', u'ENSMUSG00000035441', u'ENSMUSG00000020734', u'ENSMUSG00000032314', u'ENSMUSG00000020733', u'ENSMUSG00000061232', u'ENSMUSG00000016028', u'ENSMUSG00000001416', u'ENSMUSG00000091337', u'ENSMUSG00000028960', u'ENSMUSG00000064325', u'ENSMUSG00000001419', u'ENSMUSG00000042167', u'ENSMUSG00000042323', u'ENSMUSG00000044469', u'ENSMUSG00000044519', u'ENSMUSG00000028583', u'ENSMUSG00000020640', u'ENSMUSG00000020641', u'ENSMUSG00000020647', u'ENSMUSG00000002679', u'ENSMUSG00000053477', u'ENSMUSG00000023992', u'ENSMUSG00000032009', u'ENSMUSG00000020649', u'ENSMUSG00000023994', u'ENSMUSG00000039105', u'ENSMUSG00000020349', u'ENSMUSG00000064145', u'ENSMUSG00000027425', u'ENSMUSG00000027422', u'ENSMUSG00000004263', u'ENSMUSG00000070520', u'ENSMUSG00000002699', u'ENSMUSG00000028041', u'ENSMUSG00000018537', u'ENSMUSG00000017376', u'ENSMUSG00000032462', u'ENSMUSG00000028042', u'ENSMUSG00000033998', u'ENSMUSG00000061013', u'ENSMUSG00000019804', u'ENSMUSG00000033933', u'ENSMUSG00000019803', u'ENSMUSG00000024427', u'ENSMUSG00000024425', u'ENSMUSG00000024423', u'ENSMUSG00000032261', u'ENSMUSG00000021901', u'ENSMUSG00000001520', u'ENSMUSG00000038679', u'ENSMUSG00000006205', u'ENSMUSG00000020232', u'ENSMUSG00000005087', u'ENSMUSG00000020230', u'ENSMUSG00000040761', u'ENSMUSG00000020235', u'ENSMUSG00000027514', u'ENSMUSG00000027519', u'ENSMUSG00000050288', u'ENSMUSG00000009394', u'ENSMUSG00000038416', u'ENSMUSG00000038023', u'ENSMUSG00000017405', u'ENSMUSG00000006998', u'ENSMUSG00000019487', u'ENSMUSG00000044641', u'ENSMUSG00000074818', u'ENSMUSG00000002504', u'ENSMUSG00000024083', u'ENSMUSG00000074811', u'ENSMUSG00000001323', u'ENSMUSG00000061374', u'ENSMUSG00000037169', u'ENSMUSG00000059921', u'ENSMUSG00000000787', u'ENSMUSG00000064373', u'ENSMUSG00000032911', u'ENSMUSG00000032913', u'ENSMUSG00000050071', u'ENSMUSG00000019794', u'ENSMUSG00000016933', u'ENSMUSG00000019790', u'ENSMUSG00000033423', u'ENSMUSG00000024952', u'ENSMUSG00000041695', u'ENSMUSG00000005534', u'ENSMUSG00000024959', u'ENSMUSG00000027287', u'ENSMUSG00000005533', u'ENSMUSG00000050732', u'ENSMUSG00000022864', u'ENSMUSG00000001741', u'ENSMUSG00000040896', u'ENSMUSG00000032479', u'ENSMUSG00000010067', u'ENSMUSG00000005371', u'ENSMUSG00000000127', u'ENSMUSG00000024883', u'ENSMUSG00000018820', u'ENSMUSG00000037148', u'ENSMUSG00000026778', u'ENSMUSG00000027350', u'ENSMUSG00000040613', u'ENSMUSG00000027358', u'ENSMUSG00000068206', u'ENSMUSG00000026484', u'ENSMUSG00000063273', u'ENSMUSG00000026480', u'ENSMUSG00000049580', u'ENSMUSG00000026917', u'ENSMUSG00000027248', u'ENSMUSG00000058638', u'ENSMUSG00000005621', u'ENSMUSG00000027247', u'ENSMUSG00000030519', u'ENSMUSG00000052534', u'ENSMUSG00000035877', u'ENSMUSG00000030516', u'ENSMUSG00000037235', u'ENSMUSG00000037234', u'ENSMUSG00000027244', u'ENSMUSG00000046785', u'ENSMUSG00000041362', u'ENSMUSG00000075704', u'ENSMUSG00000027997', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000000346', u'ENSMUSG00000027777', u'ENSMUSG00000004044', u'ENSMUSG00000031913', u'ENSMUSG00000026176', u'ENSMUSG00000026174', u'ENSMUSG00000024998', u'ENSMUSG00000022109', u'ENSMUSG00000015133', u'ENSMUSG00000075701', u'ENSMUSG00000022105', u'ENSMUSG00000022100', u'ENSMUSG00000015053', u'ENSMUSG00000000902', u'ENSMUSG00000030357', u'ENSMUSG00000036432', u'ENSMUSG00000031776', u'ENSMUSG00000031770', u'ENSMUSG00000031772', u'ENSMUSG00000021340', u'ENSMUSG00000032737', u'ENSMUSG00000032058', u'ENSMUSG00000026556', u'ENSMUSG00000031352', u'ENSMUSG00000031353', u'ENSMUSG00000023072', u'ENSMUSG00000050965', u'ENSMUSG00000004266', u'ENSMUSG00000036036', u'ENSMUSG00000004264', u'ENSMUSG00000026558', u'ENSMUSG00000004591', u'ENSMUSG00000066232', u'ENSMUSG00000022075', u'ENSMUSG00000040760', u'ENSMUSG00000063870', u'ENSMUSG00000011751', u'ENSMUSG00000031078', u'ENSMUSG00000026395', u'ENSMUSG00000031176', u'ENSMUSG00000031174', u'ENSMUSG00000026950', u'ENSMUSG00000029608', u'ENSMUSG00000009621', u'ENSMUSG00000003068', u'ENSMUSG00000063895', u'ENSMUSG00000026959', u'ENSMUSG00000029603', u'ENSMUSG00000022656', u'ENSMUSG00000004460', u'ENSMUSG00000029110', u'ENSMUSG00000057367', u'ENSMUSG00000025451', u'ENSMUSG00000029836', u'ENSMUSG00000022255', u'ENSMUSG00000022565', u'ENSMUSG00000025925', u'ENSMUSG00000017978', u'ENSMUSG00000017009', u'ENSMUSG00000066150', u'ENSMUSG00000066152', u'ENSMUSG00000050697', u'ENSMUSG00000024066', u'ENSMUSG00000026826', u'ENSMUSG00000013662', u'ENSMUSG00000013663', u'ENSMUSG00000021127', u'ENSMUSG00000020430', u'ENSMUSG00000029730', u'ENSMUSG00000020436', u'ENSMUSG00000028649', u'ENSMUSG00000015839', u'ENSMUSG00000039656', u'ENSMUSG00000054717', u'ENSMUSG00000015837', u'ENSMUSG00000057409', u'ENSMUSG00000028645', u'ENSMUSG00000028882', u'ENSMUSG00000034187', u'ENSMUSG00000028884', u'ENSMUSG00000021540', u'ENSMUSG00000028886', u'ENSMUSG00000022490', u'ENSMUSG00000045095', u'ENSMUSG00000029287', u'ENSMUSG00000039652', u'ENSMUSG00000061322', u'ENSMUSG00000031565', u'ENSMUSG00000061665', u'ENSMUSG00000033335', u'ENSMUSG00000036908', u'ENSMUSG00000036907', u'ENSMUSG00000036904', u'ENSMUSG00000005886', u'ENSMUSG00000042626', u'ENSMUSG00000034520', u'ENSMUSG00000009575', u'ENSMUSG00000029428', u'ENSMUSG00000036555', u'ENSMUSG00000059883', u'ENSMUSG00000007564', u'ENSMUSG00000030704', u'ENSMUSG00000060012', u'ENSMUSG00000009281', u'ENSMUSG00000079197', u'ENSMUSG00000028399', u'ENSMUSG00000048799', u'ENSMUSG00000028394', u'ENSMUSG00000028464', u'ENSMUSG00000028465', u'ENSMUSG00000025142', u'ENSMUSG00000021294', u'ENSMUSG00000035585', u'ENSMUSG00000041638', u'ENSMUSG00000030816', u'ENSMUSG00000034459', u'ENSMUSG00000028081', u'ENSMUSG00000028082', u'ENSMUSG00000030701', u'ENSMUSG00000016346', u'ENSMUSG00000028086', u'ENSMUSG00000041236', u'ENSMUSG00000035456', u'ENSMUSG00000075528', u'ENSMUSG00000039116', u'ENSMUSG00000039117', u'ENSMUSG00000021638', u'ENSMUSG00000007815', u'ENSMUSG00000007817', u'ENSMUSG00000028062', u'ENSMUSG00000009376', u'ENSMUSG00000028060', u'ENSMUSG00000030064', u'ENSMUSG00000028066', u'ENSMUSG00000021756', u'ENSMUSG00000006362', u'ENSMUSG00000050212', u'ENSMUSG00000028068', u'ENSMUSG00000036594', u'ENSMUSG00000006369', u'ENSMUSG00000038331', u'ENSMUSG00000027620', u'ENSMUSG00000020914', u'ENSMUSG00000028266', u'ENSMUSG00000021124', u'ENSMUSG00000026821', u'ENSMUSG00000018326', u'ENSMUSG00000026208', u'ENSMUSG00000035078', u'ENSMUSG00000018322', u'ENSMUSG00000042557', u'ENSMUSG00000053646', u'ENSMUSG00000002190', u'ENSMUSG00000032076', u'ENSMUSG00000020654', u'ENSMUSG00000020657', u'ENSMUSG00000020659', u'ENSMUSG00000036006', u'ENSMUSG00000019923', u'ENSMUSG00000032078', u'ENSMUSG00000019920', u'ENSMUSG00000008153', u'ENSMUSG00000018923', u'ENSMUSG00000045273', u'ENSMUSG00000052430', u'ENSMUSG00000032475', u'ENSMUSG00000070780', u'ENSMUSG00000032109', u'ENSMUSG00000059866', u'ENSMUSG00000007589', u'ENSMUSG00000033981', u'ENSMUSG00000033983', u'ENSMUSG00000002996', u'ENSMUSG00000002997', u'ENSMUSG00000060279', u'ENSMUSG00000010505', u'ENSMUSG00000024431', u'ENSMUSG00000049252', u'ENSMUSG00000031068', u'ENSMUSG00000002227', u'ENSMUSG00000001247', u'ENSMUSG00000032290', u'ENSMUSG00000019818', u'ENSMUSG00000006215', u'ENSMUSG00000032294', u'ENSMUSG00000002221', u'ENSMUSG00000041112', u'ENSMUSG00000002731', u'ENSMUSG00000027560', u'ENSMUSG00000019970', u'ENSMUSG00000019256', u'ENSMUSG00000044098', u'ENSMUSG00000017412', u'ENSMUSG00000043991', u'ENSMUSG00000032855', u'ENSMUSG00000017417', u'ENSMUSG00000060126', u'ENSMUSG00000050132', u'ENSMUSG00000019494', u'ENSMUSG00000024098', u'ENSMUSG00000001440', u'ENSMUSG00000024091', u'ENSMUSG00000024097', u'ENSMUSG00000024096', u'ENSMUSG00000054423', u'ENSMUSG00000055435', u'ENSMUSG00000020083', u'ENSMUSG00000075284', u'ENSMUSG00000001334', u'ENSMUSG00000051379', u'ENSMUSG00000022817', u'ENSMUSG00000022816', u'ENSMUSG00000022812', u'ENSMUSG00000038539', u'ENSMUSG00000054640', u'ENSMUSG00000061859', u'ENSMUSG00000026764', u'ENSMUSG00000038533', u'ENSMUSG00000036112', u'ENSMUSG00000033430', u'ENSMUSG00000063358', u'ENSMUSG00000024941', u'ENSMUSG00000030748', u'ENSMUSG00000024942', u'ENSMUSG00000024944', u'ENSMUSG00000024947', u'ENSMUSG00000024140', u'ENSMUSG00000047230', u'ENSMUSG00000019789', u'ENSMUSG00000050335', u'ENSMUSG00000021423', u'ENSMUSG00000030744', u'ENSMUSG00000028885', u'ENSMUSG00000027168', u'ENSMUSG00000020390', u'ENSMUSG00000030987', u'ENSMUSG00000027162', u'ENSMUSG00000041343', u'ENSMUSG00000020399', u'ENSMUSG00000027164', u'ENSMUSG00000032127', u'ENSMUSG00000020888', u'ENSMUSG00000020889', u'ENSMUSG00000024897', u'ENSMUSG00000028889', u'ENSMUSG00000020882', u'ENSMUSG00000020883', u'ENSMUSG00000027365', u'ENSMUSG00000020886', u'ENSMUSG00000033721', u'ENSMUSG00000026494', u'ENSMUSG00000040084', u'ENSMUSG00000026496', u'ENSMUSG00000003872', u'ENSMUSG00000003873', u'ENSMUSG00000058624', u'ENSMUSG00000005615', u'ENSMUSG00000031585', u'ENSMUSG00000027381', u'ENSMUSG00000005610', u'ENSMUSG00000005611', u'ENSMUSG00000041977', u'ENSMUSG00000037242', u'ENSMUSG00000030291', u'ENSMUSG00000030189', u'ENSMUSG00000041378', u'ENSMUSG00000005057', u'ENSMUSG00000030180', u'ENSMUSG00000026187', u'ENSMUSG00000051391', u'ENSMUSG00000004054', u'ENSMUSG00000004056', u'ENSMUSG00000019471', u'ENSMUSG00000031902', u'ENSMUSG00000031907', u'ENSMUSG00000031906', u'ENSMUSG00000004698', u'ENSMUSG00000000378', u'ENSMUSG00000019478', u'ENSMUSG00000015120', u'ENSMUSG00000038622', u'ENSMUSG00000027944', u'ENSMUSG00000022394', u'ENSMUSG00000030161', u'ENSMUSG00000027940', u'ENSMUSG00000042745', u'ENSMUSG00000040528', u'ENSMUSG00000044231', u'ENSMUSG00000055775', u'ENSMUSG00000059669', u'ENSMUSG00000074643', u'ENSMUSG00000031540', u'ENSMUSG00000021357', u'ENSMUSG00000026019', u'ENSMUSG00000026018', u'ENSMUSG00000027011', u'ENSMUSG00000040152', u'ENSMUSG00000035356', u'ENSMUSG00000023067', u'ENSMUSG00000026014', u'ENSMUSG00000014867', u'ENSMUSG00000026389', u'ENSMUSG00000060843', u'ENSMUSG00000026380', u'ENSMUSG00000026383', u'ENSMUSG00000038235', u'ENSMUSG00000026384', u'ENSMUSG00000022009', u'ENSMUSG00000025932', u'ENSMUSG00000015149', u'ENSMUSG00000031169', u'ENSMUSG00000036169', u'ENSMUSG00000000805', u'ENSMUSG00000031165', u'ENSMUSG00000025939', u'ENSMUSG00000031161', u'ENSMUSG00000049489', u'ENSMUSG00000040296', u'ENSMUSG00000020538', u'ENSMUSG00000026946', u'ENSMUSG00000029638', u'ENSMUSG00000026942', u'ENSMUSG00000063887', u'ENSMUSG00000020530', u'ENSMUSG00000029635', u'ENSMUSG00000020532', u'ENSMUSG00000006699', u'ENSMUSG00000022623', u'ENSMUSG00000022621', u'ENSMUSG00000062312', u'ENSMUSG00000056553', u'ENSMUSG00000049577', u'ENSMUSG00000031832', u'ENSMUSG00000022710', u'ENSMUSG00000043051', u'ENSMUSG00000029126', u'ENSMUSG00000049775', u'ENSMUSG00000047534', u'ENSMUSG00000021288', u'ENSMUSG00000039579', u'ENSMUSG00000038718', u'ENSMUSG00000031010', u'ENSMUSG00000038344', u'ENSMUSG00000021134', u'ENSMUSG00000031015', u'ENSMUSG00000039219', u'ENSMUSG00000031016', u'ENSMUSG00000026833', u'ENSMUSG00000070047', u'ENSMUSG00000020400', u'ENSMUSG00000026836', u'ENSMUSG00000020402', u'ENSMUSG00000057604', u'ENSMUSG00000029253', u'ENSMUSG00000032228', u'ENSMUSG00000003123', u'ENSMUSG00000033083', u'ENSMUSG00000046240', u'ENSMUSG00000063260', u'ENSMUSG00000028654', u'ENSMUSG00000028657', u'ENSMUSG00000028656', u'ENSMUSG00000003721', u'ENSMUSG00000028893', u'ENSMUSG00000075376', u'ENSMUSG00000011256', u'ENSMUSG00000034621', u'ENSMUSG00000029386', u'ENSMUSG00000040506', u'ENSMUSG00000031865', u'ENSMUSG00000028899', u'ENSMUSG00000028898', u'ENSMUSG00000007613', u'ENSMUSG00000007617', u'ENSMUSG00000038187', u'ENSMUSG00000036915', u'ENSMUSG00000006740', u'ENSMUSG00000036913', u'ENSMUSG00000042284', u'ENSMUSG00000052384', u'ENSMUSG00000020715', u'ENSMUSG00000002059', u'ENSMUSG00000020717', u'ENSMUSG00000020719', u'ENSMUSG00000023845', u'ENSMUSG00000002052', u'ENSMUSG00000049904', u'ENSMUSG00000060063', u'ENSMUSG00000069895', u'ENSMUSG00000035864', u'ENSMUSG00000025157', u'ENSMUSG00000025156', u'ENSMUSG00000025151', u'ENSMUSG00000046791', u'ENSMUSG00000055371', u'ENSMUSG00000036580', u'ENSMUSG00000035919', u'ENSMUSG00000043439', u'ENSMUSG00000015804', u'ENSMUSG00000028098', u'ENSMUSG00000070348', u'ENSMUSG00000043535', u'ENSMUSG00000054252', u'ENSMUSG00000034994', u'ENSMUSG00000013076', u'ENSMUSG00000038982', u'ENSMUSG00000060397', u'ENSMUSG00000021624', u'ENSMUSG00000021720', u'ENSMUSG00000006356', u'ENSMUSG00000064302', u'ENSMUSG00000028273', u'ENSMUSG00000038967', u'ENSMUSG00000028271', u'ENSMUSG00000038965', u'ENSMUSG00000042303', u'ENSMUSG00000028949', u'ENSMUSG00000035692', u'ENSMUSG00000042541', u'ENSMUSG00000018334', u'ENSMUSG00000042548', u'ENSMUSG00000048416', u'ENSMUSG00000041120', u'ENSMUSG00000032064', u'ENSMUSG00000032067', u'ENSMUSG00000031751', u'ENSMUSG00000020661', u'ENSMUSG00000037896', u'ENSMUSG00000092417', u'ENSMUSG00000002458', u'ENSMUSG00000020668', u'ENSMUSG00000020669', u'ENSMUSG00000017776', u'ENSMUSG00000038900', u'ENSMUSG00000052566', u'ENSMUSG00000024392', u'ENSMUSG00000024397', u'ENSMUSG00000052920', u'ENSMUSG00000037490', u'ENSMUSG00000040312', u'ENSMUSG00000052565', u'ENSMUSG00000032118', u'ENSMUSG00000035711', u'ENSMUSG00000061079', u'ENSMUSG00000040652', u'ENSMUSG00000017314', u'ENSMUSG00000021771', u'ENSMUSG00000053819', u'ENSMUSG00000002985', u'ENSMUSG00000010517', u'ENSMUSG00000002233', u'ENSMUSG00000008384', u'ENSMUSG00000002983', u'ENSMUSG00000019861', u'ENSMUSG00000032280', u'ENSMUSG00000001506', u'ENSMUSG00000001507', u'ENSMUSG00000019868', u'ENSMUSG00000028496', u'ENSMUSG00000027575', u'ENSMUSG00000027577', u'ENSMUSG00000041161', u'ENSMUSG00000042590', u'ENSMUSG00000028494', u'ENSMUSG00000000581', u'ENSMUSG00000026478', u'ENSMUSG00000049539', u'ENSMUSG00000017428', u'ENSMUSG00000017221', u'ENSMUSG00000033880', u'ENSMUSG00000054387', u'ENSMUSG00000020721', u'ENSMUSG00000036617', u'ENSMUSG00000024712', u'ENSMUSG00000059456', u'ENSMUSG00000020096', u'ENSMUSG00000020091', u'ENSMUSG00000005338', u'ENSMUSG00000000743', u'ENSMUSG00000060519', u'ENSMUSG00000008036', u'ENSMUSG00000008035', u'ENSMUSG00000020098', u'ENSMUSG00000040363', u'ENSMUSG00000032344', u'ENSMUSG00000023110', u'ENSMUSG00000040365', u'ENSMUSG00000028063', u'ENSMUSG00000005198', u'ENSMUSG00000026718', u'ENSMUSG00000038503', u'ENSMUSG00000024974', u'ENSMUSG00000024975', u'ENSMUSG00000031729', u'ENSMUSG00000030751', u'ENSMUSG00000037992', u'ENSMUSG00000020388', u'ENSMUSG00000001761', u'ENSMUSG00000030990', u'ENSMUSG00000041560', u'ENSMUSG00000021754', u'ENSMUSG00000020387', u'ENSMUSG00000020386', u'ENSMUSG00000001986', u'ENSMUSG00000030761', u'ENSMUSG00000037526', u'ENSMUSG00000037523', u'ENSMUSG00000033419', u'ENSMUSG00000020898', u'ENSMUSG00000020897', u'ENSMUSG00000020894', u'ENSMUSG00000020893', u'ENSMUSG00000060477', u'ENSMUSG00000003865', u'ENSMUSG00000038612', u'ENSMUSG00000028300', u'ENSMUSG00000038615', u'ENSMUSG00000001964', u'ENSMUSG00000074916', u'ENSMUSG00000039539', u'ENSMUSG00000003868', u'ENSMUSG00000039536', u'ENSMUSG00000005609', u'ENSMUSG00000027395', u'ENSMUSG00000030577', u'ENSMUSG00000021457', u'ENSMUSG00000031575', u'ENSMUSG00000000561', u'ENSMUSG00000005043', u'ENSMUSG00000005045', u'ENSMUSG00000004069', u'ENSMUSG00000000567', u'ENSMUSG00000027715', u'ENSMUSG00000000568', u'ENSMUSG00000037411', u'ENSMUSG00000027712', u'ENSMUSG00000027496', u'ENSMUSG00000031974', u'ENSMUSG00000031972', u'ENSMUSG00000041570', u'ENSMUSG00000026150', u'ENSMUSG00000034839', u'ENSMUSG00000026626', u'ENSMUSG00000026155', u'ENSMUSG00000026126', u'ENSMUSG00000030172', u'ENSMUSG00000022383', u'ENSMUSG00000022382', u'ENSMUSG00000027951', u'ENSMUSG00000027950', u'ENSMUSG00000022389', u'ENSMUSG00000031483', u'ENSMUSG00000027954', u'ENSMUSG00000029204', u'ENSMUSG00000030616', u'ENSMUSG00000031714', u'ENSMUSG00000030965', u'ENSMUSG00000031583', u'ENSMUSG00000006519', u'ENSMUSG00000003469', u'ENSMUSG00000030281', u'ENSMUSG00000027002', u'ENSMUSG00000030287', u'ENSMUSG00000014859', u'ENSMUSG00000023018', u'ENSMUSG00000027006', u'ENSMUSG00000026024', u'ENSMUSG00000023017', u'ENSMUSG00000037487', u'ENSMUSG00000003464', u'ENSMUSG00000023011', u'ENSMUSG00000029207', u'ENSMUSG00000022010', u'ENSMUSG00000003269', u'ENSMUSG00000057948', u'ENSMUSG00000048163', u'ENSMUSG00000040782', u'ENSMUSG00000040785', u'ENSMUSG00000022018', u'ENSMUSG00000000811', u'ENSMUSG00000031393', u'ENSMUSG00000031391', u'ENSMUSG00000041779', u'ENSMUSG00000034292', u'ENSMUSG00000025949', u'ENSMUSG00000031622', u'ENSMUSG00000003283', u'ENSMUSG00000031153', u'ENSMUSG00000031154', u'ENSMUSG00000031155', u'ENSMUSG00000022634', u'ENSMUSG00000022637', u'ENSMUSG00000020524', u'ENSMUSG00000026442', u'ENSMUSG00000070697', u'ENSMUSG00000026447', u'ENSMUSG00000056832', u'ENSMUSG00000036606', u'ENSMUSG00000022702', u'ENSMUSG00000022704', u'ENSMUSG00000029131', u'ENSMUSG00000025437', u'ENSMUSG00000022672', u'ENSMUSG00000057835', u'ENSMUSG00000028758', u'ENSMUSG00000033813', u'ENSMUSG00000035275', u'ENSMUSG00000052062', u'ENSMUSG00000031026', u'ENSMUSG00000026848', u'ENSMUSG00000026849', u'ENSMUSG00000036928', u'ENSMUSG00000026842', u'ENSMUSG00000031029', u'ENSMUSG00000066687', u'ENSMUSG00000022521', u'ENSMUSG00000025586', u'ENSMUSG00000022523', u'ENSMUSG00000029714', u'ENSMUSG00000029245', u'ENSMUSG00000029712', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000022528', u'ENSMUSG00000003131', u'ENSMUSG00000028661', u'ENSMUSG00000057614', u'ENSMUSG00000003731', u'ENSMUSG00000028868', u'ENSMUSG00000057722', u'ENSMUSG00000025892', u'ENSMUSG00000047259', u'ENSMUSG00000028862', u'ENSMUSG00000069763', u'ENSMUSG00000028860', u'ENSMUSG00000034610', u'ENSMUSG00000028864', u'ENSMUSG00000027508', u'ENSMUSG00000026878', u'ENSMUSG00000017740', u'ENSMUSG00000020707', u'ENSMUSG00000052397', u'ENSMUSG00000020704', u'ENSMUSG00000032612', u'ENSMUSG00000032179', u'ENSMUSG00000020700', u'ENSMUSG00000029407', u'ENSMUSG00000029406', u'ENSMUSG00000020708', u'ENSMUSG00000019927', u'ENSMUSG00000009555', u'ENSMUSG00000025366', u'ENSMUSG00000060073', u'ENSMUSG00000025369', u'ENSMUSG00000061751', u'ENSMUSG00000079298', u'ENSMUSG00000037062', u'ENSMUSG00000034271', u'ENSMUSG00000034274', u'ENSMUSG00000054976', u'ENSMUSG00000067629', u'ENSMUSG00000071646', u'ENSMUSG00000035673', u'ENSMUSG00000038280', u'ENSMUSG00000092274', u'ENSMUSG00000035901', u'ENSMUSG00000042156', u'ENSMUSG00000034544', u'ENSMUSG00000035478', u'ENSMUSG00000072872', u'ENSMUSG00000038990', u'ENSMUSG00000021730', u'ENSMUSG00000021733', u'ENSMUSG00000021732', u'ENSMUSG00000029674', u'ENSMUSG00000001424', u'ENSMUSG00000050310', u'ENSMUSG00000021738', u'ENSMUSG00000008730', u'ENSMUSG00000028289', u'ENSMUSG00000038975', u'ENSMUSG00000016541', u'ENSMUSG00000038976', u'ENSMUSG00000028282', u'ENSMUSG00000053436', u'ENSMUSG00000018012', u'ENSMUSG00000035873', u'ENSMUSG00000025162', u'ENSMUSG00000061808', u'ENSMUSG00000028444', u'ENSMUSG00000028445', u'ENSMUSG00000028914', u'ENSMUSG00000071415', u'ENSMUSG00000005672', u'ENSMUSG00000075232', u'ENSMUSG00000035011', u'ENSMUSG00000018654', u'ENSMUSG00000020099', u'ENSMUSG00000052488', u'ENSMUSG00000032050', u'ENSMUSG00000020671', u'ENSMUSG00000039004', u'ENSMUSG00000017760', u'ENSMUSG00000014329', u'ENSMUSG00000001517', u'ENSMUSG00000037016', u'ENSMUSG00000024387', u'ENSMUSG00000024383', u'ENSMUSG00000024381', u'ENSMUSG00000044308', u'ENSMUSG00000018470', u'ENSMUSG00000037014', u'ENSMUSG00000018476', u'ENSMUSG00000042207', u'ENSMUSG00000018474', u'ENSMUSG00000019302', u'ENSMUSG00000038146', u'ENSMUSG00000025578', u'ENSMUSG00000032128', u'ENSMUSG00000049907', u'ENSMUSG00000002083', u'ENSMUSG00000032125', u'ENSMUSG00000024515', u'ENSMUSG00000053825', u'ENSMUSG00000044786', u'ENSMUSG00000036111', u'ENSMUSG00000021938', u'ENSMUSG00000074221', u'ENSMUSG00000021936', u'ENSMUSG00000024143', u'ENSMUSG00000060216', u'ENSMUSG00000024413', u'ENSMUSG00000071379', u'ENSMUSG00000024411', u'ENSMUSG00000022837', u'ENSMUSG00000022836', u'ENSMUSG00000037465', u'ENSMUSG00000022831', u'ENSMUSG00000027544', u'ENSMUSG00000027646', u'ENSMUSG00000044716', u'ENSMUSG00000001288', u'ENSMUSG00000002957', u'ENSMUSG00000038429', u'ENSMUSG00000036737', u'ENSMUSG00000001280', u'ENSMUSG00000040146', u'ENSMUSG00000032540', u'ENSMUSG00000039953', u'ENSMUSG00000032547', u'ENSMUSG00000026227', u'ENSMUSG00000039959', u'ENSMUSG00000053754', u'ENSMUSG00000032549', u'ENSMUSG00000017548', u'ENSMUSG00000051910', u'ENSMUSG00000054150', u'ENSMUSG00000037731', u'ENSMUSG00000020063', u'ENSMUSG00000059409', u'ENSMUSG00000036181', u'ENSMUSG00000048234', u'ENSMUSG00000047866', u'ENSMUSG00000026701', u'ENSMUSG00000051675', u'ENSMUSG00000040310', u'ENSMUSG00000058392', u'ENSMUSG00000061360', u'ENSMUSG00000019055', u'ENSMUSG00000024968', u'ENSMUSG00000038517', u'ENSMUSG00000036427', u'ENSMUSG00000027080', u'ENSMUSG00000038518', u'ENSMUSG00000024966', u'ENSMUSG00000024965', u'ENSMUSG00000030619', u'ENSMUSG00000037649', u'ENSMUSG00000001998', u'ENSMUSG00000024369', u'ENSMUSG00000037643', u'ENSMUSG00000030966', u'ENSMUSG00000027490', u'ENSMUSG00000001774', u'ENSMUSG00000024563', u'ENSMUSG00000024561', u'ENSMUSG00000041777', u'ENSMUSG00000042699', u'ENSMUSG00000051177', u'ENSMUSG00000029455', u'ENSMUSG00000019699', u'ENSMUSG00000014444', u'ENSMUSG00000039771', u'ENSMUSG00000020844', u'ENSMUSG00000029458', u'ENSMUSG00000037060', u'ENSMUSG00000041794', u'ENSMUSG00000020843', u'ENSMUSG00000055116', u'ENSMUSG00000040957', u'ENSMUSG00000020848', u'ENSMUSG00000020849', u'ENSMUSG00000000555', u'ENSMUSG00000029592', u'ENSMUSG00000041319', u'ENSMUSG00000050272', u'ENSMUSG00000008393', u'ENSMUSG00000034801', u'ENSMUSG00000054889', u'ENSMUSG00000000001', u'ENSMUSG00000031967', u'ENSMUSG00000018906', u'ENSMUSG00000031960', u'ENSMUSG00000031963', u'ENSMUSG00000019817', u'ENSMUSG00000018909', u'ENSMUSG00000026142', u'ENSMUSG00000015143', u'ENSMUSG00000062209', u'ENSMUSG00000026825', u'ENSMUSG00000046207', u'ENSMUSG00000031490', u'ENSMUSG00000055022', u'ENSMUSG00000023484', u'ENSMUSG00000055024', u'ENSMUSG00000040524', u'ENSMUSG00000036062', u'ENSMUSG00000031703', u'ENSMUSG00000041957', u'ENSMUSG00000030811', u'ENSMUSG00000003458', u'ENSMUSG00000023008', u'ENSMUSG00000031367', u'ENSMUSG00000023004', u'ENSMUSG00000026527', u'ENSMUSG00000031812', u'ENSMUSG00000041959', u'ENSMUSG00000040423', u'ENSMUSG00000056486', u'ENSMUSG00000026036', u'ENSMUSG00000051451', u'ENSMUSG00000026034', u'ENSMUSG00000048154', u'ENSMUSG00000022021', u'ENSMUSG00000026039', u'ENSMUSG00000022023', u'ENSMUSG00000031227', u'ENSMUSG00000006498', u'ENSMUSG00000022026', u'ENSMUSG00000031380', u'ENSMUSG00000000826', u'ENSMUSG00000031385', u'ENSMUSG00000078923', u'ENSMUSG00000031386', u'ENSMUSG00000042817', u'ENSMUSG00000031388', u'ENSMUSG00000034285', u'ENSMUSG00000006435', u'ENSMUSG00000025958', u'ENSMUSG00000039395', u'ENSMUSG00000037395', u'ENSMUSG00000031633', u'ENSMUSG00000029093', u'ENSMUSG00000031143', u'ENSMUSG00000029096', u'ENSMUSG00000031639', u'ENSMUSG00000068615', u'ENSMUSG00000027500', u'ENSMUSG00000031310', u'ENSMUSG00000040040', u'ENSMUSG00000026452', u'ENSMUSG00000050357', u'ENSMUSG00000041115', u'ENSMUSG00000026457', u'ENSMUSG00000048895', u'ENSMUSG00000049553', u'ENSMUSG00000026458', u'ENSMUSG00000049550', u'ENSMUSG00000049556', u'ENSMUSG00000091971', u'ENSMUSG00000025427', u'ENSMUSG00000013236', u'ENSMUSG00000069678', u'ENSMUSG00000025423', u'ENSMUSG00000025422', u'ENSMUSG00000049791', u'ENSMUSG00000022285', u'ENSMUSG00000068854', u'ENSMUSG00000049792', u'ENSMUSG00000022280', u'ENSMUSG00000025428', u'ENSMUSG00000015312', u'ENSMUSG00000022283', u'ENSMUSG00000038369', u'ENSMUSG00000021067', u'ENSMUSG00000035242', u'ENSMUSG00000021066', u'ENSMUSG00000038365', u'ENSMUSG00000038366', u'ENSMUSG00000035247', u'ENSMUSG00000022514', u'ENSMUSG00000022515', u'ENSMUSG00000029276', u'ENSMUSG00000020462', u'ENSMUSG00000020463', u'ENSMUSG00000022512', u'ENSMUSG00000052105', u'ENSMUSG00000057666', u'ENSMUSG00000027030', u'ENSMUSG00000011877', u'ENSMUSG00000042608', u'ENSMUSG00000044167', u'ENSMUSG00000029279', u'ENSMUSG00000040429', u'ENSMUSG00000028879', u'ENSMUSG00000022353', u'ENSMUSG00000022602', u'ENSMUSG00000025888', u'ENSMUSG00000047248', u'ENSMUSG00000022607', u'ENSMUSG00000028871', u'ENSMUSG00000034485', u'ENSMUSG00000022358', u'ENSMUSG00000025880', u'ENSMUSG00000028703', u'ENSMUSG00000028874', u'ENSMUSG00000006676', u'ENSMUSG00000034601', u'ENSMUSG00000006728', u'ENSMUSG00000015950', u'ENSMUSG00000002835', u'ENSMUSG00000025395', u'ENSMUSG00000035236', u'ENSMUSG00000025393', u'ENSMUSG00000038400', u'ENSMUSG00000039166', u'ENSMUSG00000032601', u'ENSMUSG00000029478', u'ENSMUSG00000009013', u'ENSMUSG00000029475', u'ENSMUSG00000029471', u'ENSMUSG00000025373', u'ENSMUSG00000025372', u'ENSMUSG00000025375', u'ENSMUSG00000092341', u'ENSMUSG00000034867', u'ENSMUSG00000039809', u'ENSMUSG00000028677', u'ENSMUSG00000034269', u'ENSMUSG00000034462', u'ENSMUSG00000013787', u'ENSMUSG00000035392', u'ENSMUSG00000035390', u'ENSMUSG00000006651', u'ENSMUSG00000027198', u'ENSMUSG00000025085', u'ENSMUSG00000034460', u'ENSMUSG00000021645', u'ENSMUSG00000058325', u'ENSMUSG00000035798', u'ENSMUSG00000029502', u'ENSMUSG00000021709', u'ENSMUSG00000028059', u'ENSMUSG00000069631', u'ENSMUSG00000029507', u'ENSMUSG00000029505', u'ENSMUSG00000021700', u'ENSMUSG00000021702', u'ENSMUSG00000028057', u'ENSMUSG00000046688', u'ENSMUSG00000033216', u'ENSMUSG00000028291', u'ENSMUSG00000042364', u'ENSMUSG00000032497', u'ENSMUSG00000038949', u'ENSMUSG00000054428', u'ENSMUSG00000028901', u'ENSMUSG00000028454', u'ENSMUSG00000047824', u'ENSMUSG00000028452', u'ENSMUSG00000062825', u'ENSMUSG00000038388', u'ENSMUSG00000052727', u'ENSMUSG00000035021', u'ENSMUSG00000035027', u'ENSMUSG00000072770', u'ENSMUSG00000046743', u'ENSMUSG00000020605', u'ENSMUSG00000018481', u'ENSMUSG00000079553', u'ENSMUSG00000063531', u'ENSMUSG00000045532', u'ENSMUSG00000019998', u'ENSMUSG00000016534', u'ENSMUSG00000019996', u'ENSMUSG00000045248', u'ENSMUSG00000018001', u'ENSMUSG00000034160', u'ENSMUSG00000052837', u'ENSMUSG00000061298', u'ENSMUSG00000059857', u'ENSMUSG00000053510', u'ENSMUSG00000071369', u'ENSMUSG00000020111', u'ENSMUSG00000020114', u'ENSMUSG00000020115', u'ENSMUSG00000024174', u'ENSMUSG00000033953', u'ENSMUSG00000024176', u'ENSMUSG00000019843', u'ENSMUSG00000024170', u'ENSMUSG00000049044', u'ENSMUSG00000024286', u'ENSMUSG00000024287', u'ENSMUSG00000000766', u'ENSMUSG00000045333', u'ENSMUSG00000066129', u'ENSMUSG00000020275', u'ENSMUSG00000027552', u'ENSMUSG00000020271', u'ENSMUSG00000041147', u'ENSMUSG00000033392', u'ENSMUSG00000042354', u'ENSMUSG00000002948', u'ENSMUSG00000039831', u'ENSMUSG00000031221', u'ENSMUSG00000039834', u'ENSMUSG00000039943', u'ENSMUSG00000032554', u'ENSMUSG00000006392', u'ENSMUSG00000032556', u'ENSMUSG00000036634', u'ENSMUSG00000036636', u'ENSMUSG00000002546', u'ENSMUSG00000006398', u'ENSMUSG00000054364', u'ENSMUSG00000060534', u'ENSMUSG00000020078', u'ENSMUSG00000031144', u'ENSMUSG00000024772', u'ENSMUSG00000037720', u'ENSMUSG00000091512', u'ENSMUSG00000063626', u'ENSMUSG00000020075', u'ENSMUSG00000020074', u'ENSMUSG00000024778', u'ENSMUSG00000056501', u'ENSMUSG00000026739', u'ENSMUSG00000019518', u'ENSMUSG00000044117', u'ENSMUSG00000025195', u'ENSMUSG00000026737', u'ENSMUSG00000038564', u'ENSMUSG00000033170', u'ENSMUSG00000066900', u'ENSMUSG00000024914', u'ENSMUSG00000024913', u'ENSMUSG00000030978', u'ENSMUSG00000019194', u'ENSMUSG00000027489', u'ENSMUSG00000027488', u'ENSMUSG00000066551', u'ENSMUSG00000030607', u'ENSMUSG00000001707', u'ENSMUSG00000071359', u'ENSMUSG00000041540', u'ENSMUSG00000024359', u'ENSMUSG00000030600', u'ENSMUSG00000024598', u'ENSMUSG00000005442', u'ENSMUSG00000014158', u'ENSMUSG00000024597', u'ENSMUSG00000062372', u'ENSMUSG00000060708', u'ENSMUSG00000015176', u'ENSMUSG00000033777', u'ENSMUSG00000037070', u'ENSMUSG00000020859', u'ENSMUSG00000029026', u'ENSMUSG00000031558', u'ENSMUSG00000024824', u'ENSMUSG00000031555', u'ENSMUSG00000027803', u'ENSMUSG00000031557', u'ENSMUSG00000020857', u'ENSMUSG00000051355', u'ENSMUSG00000020290', u'ENSMUSG00000030770', u'ENSMUSG00000023259', u'ENSMUSG00000030774', u'ENSMUSG00000037475', u'ENSMUSG00000001018', u'ENSMUSG00000057531', u'ENSMUSG00000037470', u'ENSMUSG00000031958', u'ENSMUSG00000041688', u'ENSMUSG00000026608', u'ENSMUSG00000037386', u'ENSMUSG00000041890', u'ENSMUSG00000031950', u'ENSMUSG00000031951', u'ENSMUSG00000048490', u'ENSMUSG00000031955', u'ENSMUSG00000027739', u'ENSMUSG00000000386', u'ENSMUSG00000014547', u'ENSMUSG00000056820', u'ENSMUSG00000042961', u'ENSMUSG00000003934', u'ENSMUSG00000067336', u'ENSMUSG00000027936', u'ENSMUSG00000030157', u'ENSMUSG00000050511', u'ENSMUSG00000026197', u'ENSMUSG00000026193', u'ENSMUSG00000004626', u'ENSMUSG00000074272', u'ENSMUSG00000040724', u'ENSMUSG00000026199', u'ENSMUSG00000026280', u'ENSMUSG00000030554', u'ENSMUSG00000030805', u'ENSMUSG00000026285', u'ENSMUSG00000030806', u'ENSMUSG00000026288', u'ENSMUSG00000026289', u'ENSMUSG00000028249', u'ENSMUSG00000024220', u'ENSMUSG00000023033', u'ENSMUSG00000023034', u'ENSMUSG00000041685', u'ENSMUSG00000024056', u'ENSMUSG00000022037', u'ENSMUSG00000039419', u'ENSMUSG00000037032', u'ENSMUSG00000025969', u'ENSMUSG00000055639', u'ENSMUSG00000000838', u'ENSMUSG00000022297', u'ENSMUSG00000040537', u'ENSMUSG00000021250', u'ENSMUSG00000025964', u'ENSMUSG00000073489', u'ENSMUSG00000021255', u'ENSMUSG00000074698', u'ENSMUSG00000051331', u'ENSMUSG00000036057', u'ENSMUSG00000031601', u'ENSMUSG00000004535', u'ENSMUSG00000054555', u'ENSMUSG00000057455', u'ENSMUSG00000031609', u'ENSMUSG00000071424', u'ENSMUSG00000031731', u'ENSMUSG00000026466', u'ENSMUSG00000040055', u'ENSMUSG00000040054', u'ENSMUSG00000057522', u'ENSMUSG00000025429', u'ENSMUSG00000049521', u'ENSMUSG00000059291', u'ENSMUSG00000022722', u'ENSMUSG00000025812', u'ENSMUSG00000025410', u'ENSMUSG00000034075', u'ENSMUSG00000058135', u'ENSMUSG00000026914', u'ENSMUSG00000056216', u'ENSMUSG00000025352', u'ENSMUSG00000006715', u'ENSMUSG00000073643', u'ENSMUSG00000030733', u'ENSMUSG00000005846', u'ENSMUSG00000020475', u'ENSMUSG00000020476', u'ENSMUSG00000026864', u'ENSMUSG00000030638', u'ENSMUSG00000020472', u'ENSMUSG00000022503', u'ENSMUSG00000024309', u'ENSMUSG00000022500', u'ENSMUSG00000029267', u'ENSMUSG00000029265', u'ENSMUSG00000036932', u'ENSMUSG00000029860', u'ENSMUSG00000029647', u'ENSMUSG00000029641', u'ENSMUSG00000029864', u'ENSMUSG00000022346', u'ENSMUSG00000028847', u'ENSMUSG00000029649', u'ENSMUSG00000022619', u'ENSMUSG00000022995', u'ENSMUSG00000041936', u'ENSMUSG00000017843', u'ENSMUSG00000034674', u'ENSMUSG00000034675', u'ENSMUSG00000034673', u'ENSMUSG00000015942', u'ENSMUSG00000038170', u'ENSMUSG00000027206', u'ENSMUSG00000021671', u'ENSMUSG00000031139', u'ENSMUSG00000029469', u'ENSMUSG00000029468', u'ENSMUSG00000047879', u'ENSMUSG00000029467', u'ENSMUSG00000032633', u'ENSMUSG00000046312', u'ENSMUSG00000039156', u'ENSMUSG00000029462', u'ENSMUSG00000061650', u'ENSMUSG00000030793', u'ENSMUSG00000025340', u'ENSMUSG00000042688', u'ENSMUSG00000025348', u'ENSMUSG00000034813', u'ENSMUSG00000028114', u'ENSMUSG00000025982', u'ENSMUSG00000027363', u'ENSMUSG00000026393', u'ENSMUSG00000035385', u'ENSMUSG00000034701', u'ENSMUSG00000034706', u'ENSMUSG00000034259', u'ENSMUSG00000021071', u'ENSMUSG00000021076', u'ENSMUSG00000050382', u'ENSMUSG00000029270', u'ENSMUSG00000035629', u'ENSMUSG00000016308', u'ENSMUSG00000028599', u'ENSMUSG00000029513', u'ENSMUSG00000029512', u'ENSMUSG00000033039', u'ENSMUSG00000047907', u'ENSMUSG00000021719', u'ENSMUSG00000029516', u'ENSMUSG00000029518', u'ENSMUSG00000002393', u'ENSMUSG00000049892', u'ENSMUSG00000008999', u'ENSMUSG00000028020', u'ENSMUSG00000046699', u'ENSMUSG00000063439', u'ENSMUSG00000042349', u'ENSMUSG00000016528', u'ENSMUSG00000057667', u'ENSMUSG00000016526', u'ENSMUSG00000045322', u'ENSMUSG00000063434', u'ENSMUSG00000016520', u'ENSMUSG00000026490', u'ENSMUSG00000078676', u'ENSMUSG00000038393', u'ENSMUSG00000052229', u'ENSMUSG00000028931', u'ENSMUSG00000028932', u'ENSMUSG00000028933', u'ENSMUSG00000049940', u'ENSMUSG00000031934', u'ENSMUSG00000032405', u'ENSMUSG00000017144', u'ENSMUSG00000075415', u'ENSMUSG00000052997', u'ENSMUSG00000057193', u'ENSMUSG00000020611', u'ENSMUSG00000040511', u'ENSMUSG00000020612', u'ENSMUSG00000024163', u'ENSMUSG00000028330', u'ENSMUSG00000021400', u'ENSMUSG00000020132', u'ENSMUSG00000008668', u'ENSMUSG00000024164', u'ENSMUSG00000021408', u'ENSMUSG00000025889', u'ENSMUSG00000014303', u'ENSMUSG00000002660', u'ENSMUSG00000029655', u'ENSMUSG00000016637', u'ENSMUSG00000029163', u'ENSMUSG00000019986', u'ENSMUSG00000042228', u'ENSMUSG00000031511', u'ENSMUSG00000032382', u'ENSMUSG00000032383', u'ENSMUSG00000002718', u'ENSMUSG00000052821', u'ENSMUSG00000021775', u'ENSMUSG00000080268', u'ENSMUSG00000042429', u'ENSMUSG00000044433', u'ENSMUSG00000044927', u'ENSMUSG00000020101', u'ENSMUSG00000032411', u'ENSMUSG00000006095', u'ENSMUSG00000018583', u'ENSMUSG00000025499', u'ENSMUSG00000032418', u'ENSMUSG00000020866', u'ENSMUSG00000019854', u'ENSMUSG00000028873', u'ENSMUSG00000036131', u'ENSMUSG00000019850', u'ENSMUSG00000024294', u'ENSMUSG00000036390', u'ENSMUSG00000024290', u'ENSMUSG00000045348', u'ENSMUSG00000000711', u'ENSMUSG00000030970', u'ENSMUSG00000067995', u'ENSMUSG00000019210', u'ENSMUSG00000039844', u'ENSMUSG00000078789', u'ENSMUSG00000032564', u'ENSMUSG00000050556', u'ENSMUSG00000032562', u'ENSMUSG00000053175', u'ENSMUSG00000055917', u'ENSMUSG00000018293', u'ENSMUSG00000006386', u'ENSMUSG00000037868', u'ENSMUSG00000020048', u'ENSMUSG00000002578', u'ENSMUSG00000037860', u'ENSMUSG00000027994', u'ENSMUSG00000027845', u'ENSMUSG00000026728', u'ENSMUSG00000026726', u'ENSMUSG00000060429', u'ENSMUSG00000032965', u'ENSMUSG00000032966', u'ENSMUSG00000054199', u'ENSMUSG00000030849', u'ENSMUSG00000033161', u'ENSMUSG00000024901', u'ENSMUSG00000038160', u'ENSMUSG00000055553', u'ENSMUSG00000033545', u'ENSMUSG00000024349', u'ENSMUSG00000039176', u'ENSMUSG00000036712', u'ENSMUSG00000033542', u'ENSMUSG00000037664', u'ENSMUSG00000024610', u'ENSMUSG00000019467', u'ENSMUSG00000024617', u'ENSMUSG00000036718', u'ENSMUSG00000024589', u'ENSMUSG00000024588', u'ENSMUSG00000000628', u'ENSMUSG00000059182', u'ENSMUSG00000041556', u'ENSMUSG00000027668', u'ENSMUSG00000000627', u'ENSMUSG00000078794', u'ENSMUSG00000032086', u'ENSMUSG00000015165', u'ENSMUSG00000026610', u'ENSMUSG00000033768', u'ENSMUSG00000004383', u'ENSMUSG00000026614', u'ENSMUSG00000055493', u'ENSMUSG00000059040', u'ENSMUSG00000039716', u'ENSMUSG00000024833', u'ENSMUSG00000039715', u'ENSMUSG00000024835', u'ENSMUSG00000039713', u'ENSMUSG00000027835', u'ENSMUSG00000030707', u'ENSMUSG00000020918', u'ENSMUSG00000020919', u'ENSMUSG00000027581', u'ENSMUSG00000061132', u'ENSMUSG00000027583', u'ENSMUSG00000000532', u'ENSMUSG00000020917', u'ENSMUSG00000000530', u'ENSMUSG00000000531', u'ENSMUSG00000051615', u'ENSMUSG00000062563', u'ENSMUSG00000030495', u'ENSMUSG00000018921', u'ENSMUSG00000015766', u'ENSMUSG00000070372', u'ENSMUSG00000004018', u'ENSMUSG00000019433', u'ENSMUSG00000053333', u'ENSMUSG00000040479', u'ENSMUSG00000061911', u'ENSMUSG00000030123', u'ENSMUSG00000030120', u'ENSMUSG00000027905', u'ENSMUSG00000049299', u'ENSMUSG00000004637', u'ENSMUSG00000004631', u'ENSMUSG00000061024', u'ENSMUSG00000040681', u'ENSMUSG00000000441', u'ENSMUSG00000031546', u'ENSMUSG00000062960', u'ENSMUSG00000031548', u'ENSMUSG00000019773', u'ENSMUSG00000047649', u'ENSMUSG00000003437', u'ENSMUSG00000026504', u'ENSMUSG00000023022', u'ENSMUSG00000014791', u'ENSMUSG00000031834', u'ENSMUSG00000040118', u'ENSMUSG00000026058', u'ENSMUSG00000060882', u'ENSMUSG00000019832', u'ENSMUSG00000034064', u'ENSMUSG00000062963', u'ENSMUSG00000054693', u'ENSMUSG00000031618', u'ENSMUSG00000074637', u'ENSMUSG00000029071', u'ENSMUSG00000031616', u'ENSMUSG00000049686', u'ENSMUSG00000022191', u'ENSMUSG00000026479', u'ENSMUSG00000003549', u'ENSMUSG00000022194', u'ENSMUSG00000048481', u'ENSMUSG00000026473', u'ENSMUSG00000022199', u'ENSMUSG00000003541', u'ENSMUSG00000026475', u'ENSMUSG00000014956', u'ENSMUSG00000022757', u'ENSMUSG00000022752', u'ENSMUSG00000056596', u'ENSMUSG00000025408', u'ENSMUSG00000003380', u'ENSMUSG00000003382', u'ENSMUSG00000029578', u'ENSMUSG00000061601', u'ENSMUSG00000048047', u'ENSMUSG00000061603', u'ENSMUSG00000006705', u'ENSMUSG00000059146', u'ENSMUSG00000027078', u'ENSMUSG00000056201', u'ENSMUSG00000005871', u'ENSMUSG00000005873', u'ENSMUSG00000082229', u'ENSMUSG00000063972', u'ENSMUSG00000037706', u'ENSMUSG00000020440', u'ENSMUSG00000029217', u'ENSMUSG00000026879', u'ENSMUSG00000022571', u'ENSMUSG00000022377', u'ENSMUSG00000003099', u'ENSMUSG00000022372', u'ENSMUSG00000040490', u'ENSMUSG00000046997', u'ENSMUSG00000042694', u'ENSMUSG00000029673', u'ENSMUSG00000022378', u'ENSMUSG00000029675', u'ENSMUSG00000029676', u'ENSMUSG00000028851', u'ENSMUSG00000069729', u'ENSMUSG00000025577', u'ENSMUSG00000025576', u'ENSMUSG00000007659', u'ENSMUSG00000017858', u'ENSMUSG00000028859', u'ENSMUSG00000007655', u'ENSMUSG00000007653', u'ENSMUSG00000060475', u'ENSMUSG00000031887', u'ENSMUSG00000074064', u'ENSMUSG00000021662', u'ENSMUSG00000021661', u'ENSMUSG00000031885', u'ENSMUSG00000007739', u'ENSMUSG00000021668', u'ENSMUSG00000022400', u'ENSMUSG00000025358', u'ENSMUSG00000029454', u'ENSMUSG00000023800', u'ENSMUSG00000028101', u'ENSMUSG00000009585', u'ENSMUSG00000025351', u'ENSMUSG00000023809', u'ENSMUSG00000053024', u'ENSMUSG00000003161', u'ENSMUSG00000025993', u'ENSMUSG00000051375', u'ENSMUSG00000028613', u'ENSMUSG00000063077', u'ENSMUSG00000034247', u'ENSMUSG00000034245', u'ENSMUSG00000025757', u'ENSMUSG00000006678', u'ENSMUSG00000046192', u'ENSMUSG00000020598', u'ENSMUSG00000020599', u'ENSMUSG00000021069', u'ENSMUSG00000021068', u'ENSMUSG00000020594', u'ENSMUSG00000020592', u'ENSMUSG00000020593', u'ENSMUSG00000025758', u'ENSMUSG00000029524', u'ENSMUSG00000027012', u'ENSMUSG00000020623', u'ENSMUSG00000032714', u'ENSMUSG00000028034', u'ENSMUSG00000029528', u'ENSMUSG00000037369', u'ENSMUSG00000056209', u'ENSMUSG00000034930', u'ENSMUSG00000014226', u'ENSMUSG00000025199', u'ENSMUSG00000013698', u'ENSMUSG00000035283', u'ENSMUSG00000008859', u'ENSMUSG00000017132', u'ENSMUSG00000018666', u'ENSMUSG00000053617', u'ENSMUSG00000074896', u'ENSMUSG00000018669', u'ENSMUSG00000002413', u'ENSMUSG00000002147', u'ENSMUSG00000004865', u'ENSMUSG00000010803', u'ENSMUSG00000021477', u'ENSMUSG00000056073', u'ENSMUSG00000024112', u'ENSMUSG00000021478', u'ENSMUSG00000040407', u'ENSMUSG00000049086', u'ENSMUSG00000026017', u'ENSMUSG00000057236', u'ENSMUSG00000079316', u'ENSMUSG00000018446', u'ENSMUSG00000029334', u'ENSMUSG00000035898', u'ENSMUSG00000032397', u'ENSMUSG00000078578', u'ENSMUSG00000032399', u'ENSMUSG00000020134', u'ENSMUSG00000076617', u'ENSMUSG00000020340', u'ENSMUSG00000037916', u'ENSMUSG00000032402', u'ENSMUSG00000018593', u'ENSMUSG00000079317', u'ENSMUSG00000028051', u'ENSMUSG00000032409', u'ENSMUSG00000020053', u'ENSMUSG00000020052', u'ENSMUSG00000056153', u'ENSMUSG00000075254', u'ENSMUSG00000000708', u'ENSMUSG00000035890', u'ENSMUSG00000002968', u'ENSMUSG00000048915', u'ENSMUSG00000021986', u'ENSMUSG00000033377', u'ENSMUSG00000039852', u'ENSMUSG00000032578', u'ENSMUSG00000002365', u'ENSMUSG00000036099', u'ENSMUSG00000021870', u'ENSMUSG00000036273', u'ENSMUSG00000021877', u'ENSMUSG00000040797', u'ENSMUSG00000024758', u'ENSMUSG00000090841', u'ENSMUSG00000028426', u'ENSMUSG00000021501', u'ENSMUSG00000053768', u'ENSMUSG00000005262', u'ENSMUSG00000018841', u'ENSMUSG00000042834', u'ENSMUSG00000044177', u'ENSMUSG00000033282', u'ENSMUSG00000050199', u'ENSMUSG00000036478', u'ENSMUSG00000005397', u'ENSMUSG00000057738', u'ENSMUSG00000038545', u'ENSMUSG00000038546', u'ENSMUSG00000005268', u'ENSMUSG00000036270', u'ENSMUSG00000024339', u'ENSMUSG00000010660', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000090935', u'ENSMUSG00000033577', u'ENSMUSG00000054520', u'ENSMUSG00000022973', u'ENSMUSG00000049107', u'ENSMUSG00000027130', u'ENSMUSG00000022974', u'ENSMUSG00000001729', u'ENSMUSG00000022978', u'ENSMUSG00000000142', u'ENSMUSG00000091405', u'ENSMUSG00000026667', u'ENSMUSG00000026664', u'ENSMUSG00000005469', u'ENSMUSG00000033595', u'ENSMUSG00000001924', u'ENSMUSG00000049323', u'ENSMUSG00000044252', u'ENSMUSG00000024805', u'ENSMUSG00000024807', u'ENSMUSG00000039701', u'ENSMUSG00000039089', u'ENSMUSG00000028530', u'ENSMUSG00000041133', u'ENSMUSG00000030007', u'ENSMUSG00000001034', u'ENSMUSG00000036986', u'ENSMUSG00000030717', u'ENSMUSG00000024241', u'ENSMUSG00000024935', u'ENSMUSG00000024245', u'ENSMUSG00000020900', u'ENSMUSG00000027223', u'ENSMUSG00000020902', u'ENSMUSG00000027597', u'ENSMUSG00000001039', u'ENSMUSG00000015755', u'ENSMUSG00000015750', u'ENSMUSG00000043909', u'ENSMUSG00000018932', u'ENSMUSG00000018930', u'ENSMUSG00000051627', u'ENSMUSG00000033623', u'ENSMUSG00000039630', u'ENSMUSG00000033628', u'ENSMUSG00000033629', u'ENSMUSG00000041852', u'ENSMUSG00000029634', u'ENSMUSG00000031996', u'ENSMUSG00000031997', u'ENSMUSG00000031990', u'ENSMUSG00000031442', u'ENSMUSG00000040852', u'ENSMUSG00000031446', u'ENSMUSG00000031447', u'ENSMUSG00000026663', u'ENSMUSG00000031537', u'ENSMUSG00000023348', u'ENSMUSG00000027827', u'ENSMUSG00000032327', u'ENSMUSG00000027829', u'ENSMUSG00000032905', u'ENSMUSG00000037295', u'ENSMUSG00000041453', u'ENSMUSG00000037296', u'ENSMUSG00000040455', u'ENSMUSG00000026069', u'ENSMUSG00000003423', u'ENSMUSG00000031841', u'ENSMUSG00000014763', u'ENSMUSG00000014767', u'ENSMUSG00000042302', u'ENSMUSG00000030223', u'ENSMUSG00000069601', u'ENSMUSG00000021279', u'ENSMUSG00000029993', u'ENSMUSG00000021277', u'ENSMUSG00000021270', u'ENSMUSG00000055653', u'ENSMUSG00000040195', u'ENSMUSG00000029068', u'ENSMUSG00000006464', u'ENSMUSG00000031668', u'ENSMUSG00000079641', u'ENSMUSG00000031666', u'ENSMUSG00000031665', u'ENSMUSG00000054675', u'ENSMUSG00000031660', u'ENSMUSG00000031661', u'ENSMUSG00000022184', u'ENSMUSG00000033751', u'ENSMUSG00000057506', u'ENSMUSG00000031284', u'ENSMUSG00000031285', u'ENSMUSG00000038034', u'ENSMUSG00000039706', u'ENSMUSG00000050587', u'ENSMUSG00000032041', u'ENSMUSG00000054843', u'ENSMUSG00000029122', u'ENSMUSG00000039523', u'ENSMUSG00000037197', u'ENSMUSG00000048583', u'ENSMUSG00000021555', u'ENSMUSG00000090877', u'ENSMUSG00000029196', u'ENSMUSG00000042644', u'ENSMUSG00000026888', u'ENSMUSG00000059811', u'ENSMUSG00000021182', u'ENSMUSG00000022568', u'ENSMUSG00000021180', u'ENSMUSG00000020458', u'ENSMUSG00000020457', u'ENSMUSG00000003378', u'ENSMUSG00000020455', u'ENSMUSG00000020454', u'ENSMUSG00000020453', u'ENSMUSG00000021188', u'ENSMUSG00000047454', u'ENSMUSG00000026313', u'ENSMUSG00000022369', u'ENSMUSG00000026317', u'ENSMUSG00000022360', u'ENSMUSG00000047459', u'ENSMUSG00000022365', u'ENSMUSG00000046982', u'ENSMUSG00000025507', u'ENSMUSG00000028820', u'ENSMUSG00000015968', u'ENSMUSG00000034120', u'ENSMUSG00000007646', u'ENSMUSG00000061578', u'ENSMUSG00000034656', u'ENSMUSG00000025509', u'ENSMUSG00000024242', u'ENSMUSG00000021699', u'ENSMUSG00000029684', u'ENSMUSG00000029687', u'ENSMUSG00000029686', u'ENSMUSG00000021559', u'ENSMUSG00000021690', u'ENSMUSG00000033055', u'ENSMUSG00000055723', u'ENSMUSG00000029447', u'ENSMUSG00000057098', u'ENSMUSG00000027598', u'ENSMUSG00000022414', u'ENSMUSG00000023830', u'ENSMUSG00000028136', u'ENSMUSG00000032534', u'ENSMUSG00000034724', u'ENSMUSG00000042757', u'ENSMUSG00000042750', u'ENSMUSG00000025217', u'ENSMUSG00000074656', u'ENSMUSG00000021057', u'ENSMUSG00000068036', u'ENSMUSG00000035632', u'ENSMUSG00000020580', u'ENSMUSG00000020635', u'ENSMUSG00000047921', u'ENSMUSG00000039041', u'ENSMUSG00000023905', u'ENSMUSG00000042216', u'ENSMUSG00000028552', u'ENSMUSG00000068391', u'ENSMUSG00000031012', u'ENSMUSG00000028556', u'ENSMUSG00000025037', u'ENSMUSG00000025034', u'ENSMUSG00000025035', u'ENSMUSG00000038342', u'ENSMUSG00000052681', u'ENSMUSG00000032532', u'ENSMUSG00000034908', u'ENSMUSG00000059714', u'ENSMUSG00000052684', u'ENSMUSG00000034342', u'ENSMUSG00000034832', u'ENSMUSG00000034341', u'ENSMUSG00000028488', u'ENSMUSG00000028957', u'ENSMUSG00000035835', u'ENSMUSG00000028955', u'ENSMUSG00000035297', u'ENSMUSG00000002799', u'ENSMUSG00000039285', u'ENSMUSG00000052752', u'ENSMUSG00000000037', u'ENSMUSG00000072941', u'ENSMUSG00000007411', u'ENSMUSG00000064080', u'ENSMUSG00000035212', u'ENSMUSG00000021466', u'ENSMUSG00000040183', u'ENSMUSG00000028312', u'ENSMUSG00000071337', u'ENSMUSG00000006276', u'ENSMUSG00000001555', u'ENSMUSG00000024109', u'ENSMUSG00000021468', u'ENSMUSG00000054206', u'ENSMUSG00000044583', u'ENSMUSG00000075602', u'ENSMUSG00000045294', u'ENSMUSG00000022982', u'ENSMUSG00000032368', u'ENSMUSG00000038495', u'ENSMUSG00000039191', u'ENSMUSG00000068551', u'ENSMUSG00000045180', u'ENSMUSG00000052372', u'ENSMUSG00000032360', u'ENSMUSG00000052374', u'ENSMUSG00000037902', u'ENSMUSG00000020122', u'ENSMUSG00000020121', u'ENSMUSG00000075324', u'ENSMUSG00000000738', u'ENSMUSG00000035112', u'ENSMUSG00000079363', u'ENSMUSG00000000732', u'ENSMUSG00000040003', u'ENSMUSG00000013973', u'ENSMUSG00000028798', u'ENSMUSG00000018547', u'ENSMUSG00000032185', u'ENSMUSG00000021994', u'ENSMUSG00000015568', u'ENSMUSG00000046160', u'ENSMUSG00000019230', u'ENSMUSG00000021868', u'ENSMUSG00000032508', u'ENSMUSG00000053153', u'ENSMUSG00000039994', u'ENSMUSG00000002603', u'ENSMUSG00000032504', u'ENSMUSG00000053158', u'ENSMUSG00000001482', u'ENSMUSG00000001151', u'ENSMUSG00000019960', u'ENSMUSG00000001157', u'ENSMUSG00000001156', u'ENSMUSG00000071203', u'ENSMUSG00000046167', u'ENSMUSG00000024743', u'ENSMUSG00000021514', u'ENSMUSG00000024740', u'ENSMUSG00000027699', u'ENSMUSG00000048878', u'ENSMUSG00000027692', u'ENSMUSG00000027695', u'ENSMUSG00000036120', u'ENSMUSG00000015697', u'ENSMUSG00000002825', u'ENSMUSG00000029388', u'ENSMUSG00000001802', u'ENSMUSG00000025239', u'ENSMUSG00000032216', u'ENSMUSG00000032217', u'ENSMUSG00000033569', u'ENSMUSG00000055401', u'ENSMUSG00000024325', u'ENSMUSG00000024327', u'ENSMUSG00000022961', u'ENSMUSG00000027109', u'ENSMUSG00000037605', u'ENSMUSG00000041530', u'ENSMUSG00000025235', u'ENSMUSG00000022969', u'ENSMUSG00000020333', u'ENSMUSG00000024639', u'ENSMUSG00000020331', u'ENSMUSG00000000600', u'ENSMUSG00000027454', u'ENSMUSG00000027455', u'ENSMUSG00000015189', u'ENSMUSG00000013921', u'ENSMUSG00000040265', u'ENSMUSG00000033585', u'ENSMUSG00000019146', u'ENSMUSG00000062380', u'ENSMUSG00000052921', u'ENSMUSG00000001930', u'ENSMUSG00000000194', u'ENSMUSG00000021062', u'ENSMUSG00000000197', u'ENSMUSG00000066392', u'ENSMUSG00000030034', u'ENSMUSG00000024812', u'ENSMUSG00000039737', u'ENSMUSG00000024927', u'ENSMUSG00000024926', u'ENSMUSG00000000282', u'ENSMUSG00000024924', u'ENSMUSG00000024921', u'ENSMUSG00000030720', u'ENSMUSG00000030722', u'ENSMUSG00000037111', u'ENSMUSG00000030725', u'ENSMUSG00000020932', u'ENSMUSG00000056919', u'ENSMUSG00000038485', u'ENSMUSG00000062542', u'ENSMUSG00000048277', u'ENSMUSG00000040856', u'ENSMUSG00000015747', u'ENSMUSG00000004032', u'ENSMUSG00000015745', u'ENSMUSG00000038482', u'ENSMUSG00000030452', u'ENSMUSG00000030101', u'ENSMUSG00000030102', u'ENSMUSG00000030103', u'ENSMUSG00000030104', u'ENSMUSG00000048930', u'ENSMUSG00000030107', u'ENSMUSG00000035828', u'ENSMUSG00000055065', u'ENSMUSG00000040860', u'ENSMUSG00000031805', u'ENSMUSG00000031985', u'ENSMUSG00000007097', u'ENSMUSG00000020801', u'ENSMUSG00000020802', u'ENSMUSG00000027671', u'ENSMUSG00000027677', u'ENSMUSG00000020806', u'ENSMUSG00000027678', u'ENSMUSG00000040661', u'ENSMUSG00000026277', u'ENSMUSG00000027070', u'ENSMUSG00000041995', u'ENSMUSG00000026077', u'ENSMUSG00000003411', u'ENSMUSG00000014773', u'ENSMUSG00000026074', u'ENSMUSG00000026072', u'ENSMUSG00000014776', u'ENSMUSG00000030216', u'ENSMUSG00000071636', u'ENSMUSG00000040929', u'ENSMUSG00000015355', u'ENSMUSG00000015357', u'ENSMUSG00000021262', u'ENSMUSG00000004508', u'ENSMUSG00000021264', u'ENSMUSG00000036887', u'ENSMUSG00000029050', u'ENSMUSG00000036882', u'ENSMUSG00000029053', u'ENSMUSG00000022178', u'ENSMUSG00000039830', u'ENSMUSG00000032187', u'ENSMUSG00000020716', u'ENSMUSG00000071454', u'ENSMUSG00000002058', u'ENSMUSG00000023170', u'ENSMUSG00000022770', u'ENSMUSG00000067276', u'ENSMUSG00000038122', u'ENSMUSG00000031840', u'ENSMUSG00000061393', u'ENSMUSG00000091896', u'ENSMUSG00000038128', u'ENSMUSG00000032745', u'ENSMUSG00000003344', u'ENSMUSG00000021194', u'ENSMUSG00000022791', u'ENSMUSG00000022797', u'ENSMUSG00000021192', u'ENSMUSG00000026890', u'ENSMUSG00000022799', u'ENSMUSG00000021198', u'ENSMUSG00000026896', u'ENSMUSG00000057406', u'ENSMUSG00000026303', u'ENSMUSG00000026305', u'ENSMUSG00000040714', u'ENSMUSG00000014599', u'ENSMUSG00000022114', u'ENSMUSG00000022314', u'ENSMUSG00000029833', u'ENSMUSG00000009907', u'ENSMUSG00000076431', u'ENSMUSG00000028577', u'ENSMUSG00000025511', u'ENSMUSG00000028833', u'ENSMUSG00000028832', u'ENSMUSG00000034135', u'ENSMUSG00000015222', u'ENSMUSG00000035198', u'ENSMUSG00000035199', u'ENSMUSG00000052160', u'ENSMUSG00000079658', u'ENSMUSG00000072214', u'ENSMUSG00000021687', u'ENSMUSG00000012296', u'ENSMUSG00000022427', u'ENSMUSG00000068744', u'ENSMUSG00000023826', u'ENSMUSG00000049536', u'ENSMUSG00000046532', u'ENSMUSG00000030224', u'ENSMUSG00000022551', u'ENSMUSG00000022552', u'ENSMUSG00000028639', u'ENSMUSG00000022557', u'ENSMUSG00000029238', u'ENSMUSG00000025207', u'ENSMUSG00000034730', u'ENSMUSG00000036867', u'ENSMUSG00000048482', u'ENSMUSG00000034738', u'ENSMUSG00000021047', u'ENSMUSG00000035357', u'ENSMUSG00000035354', u'ENSMUSG00000037892', u'ENSMUSG00000059923', u'ENSMUSG00000039057', u'ENSMUSG00000046854', u'ENSMUSG00000009470', u'ENSMUSG00000057134', u'ENSMUSG00000029544', u'ENSMUSG00000079478', u'ENSMUSG00000028540', u'ENSMUSG00000035992', u'ENSMUSG00000025025', u'ENSMUSG00000032244', u'ENSMUSG00000034910', u'ENSMUSG00000031392', u'ENSMUSG00000028018', u'ENSMUSG00000031217', u'ENSMUSG00000028127', u'ENSMUSG00000028126', u'ENSMUSG00000035517', u'ENSMUSG00000045629', u'ENSMUSG00000051316', u'ENSMUSG00000035513', u'ENSMUSG00000017119', u'ENSMUSG00000042524', u'ENSMUSG00000020077', u'ENSMUSG00000028495', u'ENSMUSG00000020483', u'ENSMUSG00000068220', u'ENSMUSG00000039298', u'ENSMUSG00000033916', u'ENSMUSG00000028309', u'ENSMUSG00000043811', u'ENSMUSG00000021451', u'ENSMUSG00000021453', u'ENSMUSG00000024137', u'ENSMUSG00000018428', u'ENSMUSG00000045515', u'ENSMUSG00000071076', u'ENSMUSG00000037188', u'ENSMUSG00000051234', u'ENSMUSG00000036893', u'ENSMUSG00000007880', u'ENSMUSG00000039183', u'ENSMUSG00000032372', u'ENSMUSG00000018042', u'ENSMUSG00000018736', u'ENSMUSG00000035770', u'ENSMUSG00000037935', u'ENSMUSG00000035773', u'ENSMUSG00000041459', u'ENSMUSG00000002763', u'ENSMUSG00000037933', u'ENSMUSG00000020154', u'ENSMUSG00000032174', u'ENSMUSG00000032172', u'ENSMUSG00000032171', u'ENSMUSG00000020151', u'ENSMUSG00000035683', u'ENSMUSG00000020037', u'ENSMUSG00000045176', u'ENSMUSG00000048450', u'ENSMUSG00000070319', u'ENSMUSG00000020038', u'ENSMUSG00000038000', u'ENSMUSG00000032193', u'ENSMUSG00000032192', u'ENSMUSG00000022883', u'ENSMUSG00000018559', u'ENSMUSG00000033355', u'ENSMUSG00000078566', u'ENSMUSG00000002900', u'ENSMUSG00000033352', u'ENSMUSG00000010592', u'ENSMUSG00000036078', u'ENSMUSG00000032511', u'ENSMUSG00000001127', u'ENSMUSG00000001123', u'ENSMUSG00000039985', u'ENSMUSG00000073791', u'ENSMUSG00000002580', u'ENSMUSG00000024006', u'ENSMUSG00000024002', u'ENSMUSG00000047419', u'ENSMUSG00000055817', u'ENSMUSG00000027684', u'ENSMUSG00000071866', u'ENSMUSG00000027680', u'ENSMUSG00000024795', u'ENSMUSG00000002833', u'ENSMUSG00000024790', u'ENSMUSG00000044627', u'ENSMUSG00000024792', u'ENSMUSG00000036698', u'ENSMUSG00000036699', u'ENSMUSG00000032997', u'ENSMUSG00000001833', u'ENSMUSG00000032202', u'ENSMUSG00000010609', u'ENSMUSG00000024222', u'ENSMUSG00000033902', u'ENSMUSG00000078427', u'ENSMUSG00000031691', u'ENSMUSG00000017485', u'ENSMUSG00000079110', u'ENSMUSG00000024647', u'ENSMUSG00000041058', u'ENSMUSG00000022957', u'ENSMUSG00000024642', u'ENSMUSG00000022951', u'ENSMUSG00000022952', u'ENSMUSG00000027111', u'ENSMUSG00000040274', u'ENSMUSG00000040276', u'ENSMUSG00000038696', u'ENSMUSG00000040270', u'ENSMUSG00000019173', u'ENSMUSG00000026640', u'ENSMUSG00000026641', u'ENSMUSG00000026360', u'ENSMUSG00000058818', u'ENSMUSG00000026646', u'ENSMUSG00000028373', u'ENSMUSG00000033004', u'ENSMUSG00000033006', u'ENSMUSG00000024867', u'ENSMUSG00000092558', u'ENSMUSG00000024862', u'ENSMUSG00000055254', u'ENSMUSG00000066839', u'ENSMUSG00000000184', u'ENSMUSG00000036450', u'ENSMUSG00000036452', u'ENSMUSG00000024260', u'ENSMUSG00000055320', u'ENSMUSG00000000290', u'ENSMUSG00000001056', u'ENSMUSG00000036459', u'ENSMUSG00000001052', u'ENSMUSG00000001053', u'ENSMUSG00000030731', u'ENSMUSG00000038039', u'ENSMUSG00000020923', u'ENSMUSG00000027200', u'ENSMUSG00000020926', u'ENSMUSG00000027204', u'ENSMUSG00000020929', u'ENSMUSG00000015733', u'ENSMUSG00000000247', u'ENSMUSG00000048109', u'ENSMUSG00000078942', u'ENSMUSG00000059325', u'ENSMUSG00000059495', u'ENSMUSG00000003970', u'ENSMUSG00000055078', u'ENSMUSG00000030111', u'ENSMUSG00000030110', u'ENSMUSG00000006818', u'ENSMUSG00000020817', u'ENSMUSG00000027660', u'ENSMUSG00000030020', u'ENSMUSG00000027665', u'ENSMUSG00000026797', u'ENSMUSG00000030847', u'ENSMUSG00000023367', u'ENSMUSG00000027849', u'ENSMUSG00000005447', u'ENSMUSG00000050315', u'ENSMUSG00000030842', u'ENSMUSG00000030592', u'ENSMUSG00000057113', u'ENSMUSG00000015647', u'ENSMUSG00000030595', u'ENSMUSG00000019777', u'ENSMUSG00000063146', u'ENSMUSG00000003402', u'ENSMUSG00000063142', u'ENSMUSG00000055471', u'ENSMUSG00000045045', u'ENSMUSG00000030209', u'ENSMUSG00000048076', u'ENSMUSG00000030203', u'ENSMUSG00000030201', u'ENSMUSG00000037098', u'ENSMUSG00000041308', u'ENSMUSG00000015340', u'ENSMUSG00000021217', u'ENSMUSG00000021215', u'ENSMUSG00000022098', u'ENSMUSG00000027523', u'ENSMUSG00000030447', u'ENSMUSG00000022096', u'ENSMUSG00000022091', u'ENSMUSG00000006445', u'ENSMUSG00000021218', u'ENSMUSG00000021219', u'ENSMUSG00000000982', u'ENSMUSG00000027253', u'ENSMUSG00000022160', u'ENSMUSG00000060961', u'ENSMUSG00000040016', u'ENSMUSG00000056076', u'ENSMUSG00000003573', u'ENSMUSG00000026421', u'ENSMUSG00000014905', u'ENSMUSG00000026424', u'ENSMUSG00000026425', u'ENSMUSG00000038058', u'ENSMUSG00000058488', u'ENSMUSG00000038056', u'ENSMUSG00000027257', u'ENSMUSG00000031065', u'ENSMUSG00000036585', u'ENSMUSG00000057897', u'ENSMUSG00000042390', u'ENSMUSG00000074781', u'ENSMUSG00000021326', u'ENSMUSG00000022781', u'ENSMUSG00000005804', u'ENSMUSG00000022783', u'ENSMUSG00000062373', u'ENSMUSG00000036980', u'ENSMUSG00000026883', u'ENSMUSG00000022789', u'ENSMUSG00000003352', u'ENSMUSG00000026880', u'ENSMUSG00000036989', u'ENSMUSG00000040701', u'ENSMUSG00000031642', u'ENSMUSG00000003992', u'ENSMUSG00000047126', u'ENSMUSG00000022306', u'ENSMUSG00000050953', u'ENSMUSG00000049670', u'ENSMUSG00000047123', u'ENSMUSG00000003752', u'ENSMUSG00000028800', u'ENSMUSG00000057789', u'ENSMUSG00000034101', u'ENSMUSG00000017801', u'ENSMUSG00000063382', u'ENSMUSG00000026930', u'ENSMUSG00000009681', u'ENSMUSG00000027674', u'ENSMUSG00000005936', u'ENSMUSG00000028790', u'ENSMUSG00000069089', u'ENSMUSG00000022438', u'ENSMUSG00000028796', u'ENSMUSG00000022433', u'ENSMUSG00000022437', u'ENSMUSG00000043733', u'ENSMUSG00000029227', u'ENSMUSG00000022545', u'ENSMUSG00000034584', u'ENSMUSG00000022234', u'ENSMUSG00000017774', u'ENSMUSG00000029101', u'ENSMUSG00000025231', u'ENSMUSG00000029228', u'ENSMUSG00000036856', u'ENSMUSG00000037072', u'ENSMUSG00000034216', u'ENSMUSG00000021039', u'ENSMUSG00000034218', u'ENSMUSG00000021037', u'ENSMUSG00000025782', u'ENSMUSG00000037447', u'ENSMUSG00000044912', u'ENSMUSG00000039765', u'ENSMUSG00000002111', u'ENSMUSG00000032740', u'ENSMUSG00000070871', u'ENSMUSG00000032744', u'ENSMUSG00000029550', u'ENSMUSG00000060147', u'ENSMUSG00000025017', u'ENSMUSG00000029661', u'ENSMUSG00000028572', u'ENSMUSG00000033565', u'ENSMUSG00000045763', u'ENSMUSG00000028156', u'ENSMUSG00000025651', u'ENSMUSG00000057672', u'ENSMUSG00000028150', u'ENSMUSG00000034659', u'ENSMUSG00000045962', u'ENSMUSG00000027805', u'ENSMUSG00000052572', u'ENSMUSG00000045967', u'ENSMUSG00000028158', u'ENSMUSG00000037373', u'ENSMUSG00000006134', u'ENSMUSG00000057914', u'ENSMUSG00000028974', u'ENSMUSG00000021144', u'ENSMUSG00000035504', u'ENSMUSG00000052776', u'ENSMUSG00000035509', u'ENSMUSG00000033904', u'ENSMUSG00000046709', u'ENSMUSG00000039457', u'ENSMUSG00000021448', u'ENSMUSG00000046707', u'ENSMUSG00000024122', u'ENSMUSG00000024121', u'ENSMUSG00000024120', u'ENSMUSG00000042064', u'ENSMUSG00000007989', u'ENSMUSG00000044562', u'ENSMUSG00000034652', u'ENSMUSG00000001017', u'ENSMUSG00000034121', u'ENSMUSG00000037572', u'ENSMUSG00000032698', u'ENSMUSG00000007872', u'ENSMUSG00000018707', u'ENSMUSG00000032340', u'ENSMUSG00000018566', u'ENSMUSG00000032691', u'ENSMUSG00000055567', u'ENSMUSG00000002028', u'ENSMUSG00000035764', u'ENSMUSG00000020149', u'ENSMUSG00000037921', u'ENSMUSG00000053226', u'ENSMUSG00000044708', u'ENSMUSG00000028207', u'ENSMUSG00000022897', u'ENSMUSG00000018567', u'ENSMUSG00000027630', u'ENSMUSG00000022893', u'ENSMUSG00000022892', u'ENSMUSG00000045382', u'ENSMUSG00000027323', u'ENSMUSG00000050708', u'ENSMUSG00000044700', u'ENSMUSG00000036192', u'ENSMUSG00000052957', u'ENSMUSG00000018411', u'ENSMUSG00000038119', u'ENSMUSG00000067860', u'ENSMUSG00000018143', u'ENSMUSG00000041488', u'ENSMUSG00000044811', u'ENSMUSG00000053137', u'ENSMUSG00000019943', u'ENSMUSG00000019942', u'ENSMUSG00000019944', u'ENSMUSG00000032523', u'ENSMUSG00000021846', u'ENSMUSG00000021848', u'ENSMUSG00000055866', u'ENSMUSG00000029007', u'ENSMUSG00000018899', u'ENSMUSG00000064115', u'ENSMUSG00000078765', u'ENSMUSG00000061524', u'ENSMUSG00000044147', u'ENSMUSG00000024789', u'ENSMUSG00000089832', u'ENSMUSG00000058444', u'ENSMUSG00000041483', u'ENSMUSG00000058440', u'ENSMUSG00000001228', u'ENSMUSG00000073982', u'ENSMUSG00000053046', u'ENSMUSG00000032231', u'ENSMUSG00000054021', u'ENSMUSG00000017493', u'ENSMUSG00000032238', u'ENSMUSG00000032239', u'ENSMUSG00000036202', u'ENSMUSG00000049076', u'ENSMUSG00000024304', u'ENSMUSG00000008136', u'ENSMUSG00000020319', u'ENSMUSG00000027474', u'ENSMUSG00000020315', u'ENSMUSG00000041515', u'ENSMUSG00000026603', u'ENSMUSG00000037624', u'ENSMUSG00000032113', u'ENSMUSG00000022945', u'ENSMUSG00000024308', u'ENSMUSG00000040249', u'ENSMUSG00000027784', u'ENSMUSG00000032112', u'ENSMUSG00000027782', u'ENSMUSG00000018965', u'ENSMUSG00000048251', u'ENSMUSG00000060771', u'ENSMUSG00000044033', u'ENSMUSG00000026656', u'ENSMUSG00000032839', u'ENSMUSG00000044037', u'ENSMUSG00000025326', u'ENSMUSG00000001911', u'ENSMUSG00000001910', u'ENSMUSG00000036533', u'ENSMUSG00000041235', u'ENSMUSG00000063889', u'ENSMUSG00000059003', u'ENSMUSG00000033016', u'ENSMUSG00000033014', u'ENSMUSG00000032289', u'ENSMUSG00000050148', u'ENSMUSG00000043279', u'ENSMUSG00000024271', u'ENSMUSG00000024277', u'ENSMUSG00000033128', u'ENSMUSG00000027276', u'ENSMUSG00000027272', u'ENSMUSG00000020953', u'ENSMUSG00000020950', u'ENSMUSG00000054708', u'ENSMUSG00000041609', u'ENSMUSG00000005583', u'ENSMUSG00000071054', u'ENSMUSG00000054808', u'ENSMUSG00000040124', u'ENSMUSG00000037316', u'ENSMUSG00000005566', u'ENSMUSG00000030471', u'ENSMUSG00000000085', u'ENSMUSG00000027878', u'ENSMUSG00000027879', u'ENSMUSG00000024403', u'ENSMUSG00000005698', u'ENSMUSG00000005699', u'ENSMUSG00000027303', u'ENSMUSG00000026786', u'ENSMUSG00000040640', u'ENSMUSG00000040390', u'ENSMUSG00000005161', u'ENSMUSG00000030872', u'ENSMUSG00000019768', u'ENSMUSG00000015656', u'ENSMUSG00000038593', u'ENSMUSG00000026259', u'ENSMUSG00000060601', u'ENSMUSG00000031872', u'ENSMUSG00000031871', u'ENSMUSG00000031870', u'ENSMUSG00000027893', u'ENSMUSG00000055447', u'ENSMUSG00000048000', u'ENSMUSG00000048001', u'ENSMUSG00000030525', u'ENSMUSG00000030272', u'ENSMUSG00000058756', u'ENSMUSG00000004567', u'ENSMUSG00000000881', u'ENSMUSG00000021209', u'ENSMUSG00000073433', u'ENSMUSG00000073411', u'ENSMUSG00000055044', u'ENSMUSG00000050565', u'ENSMUSG00000026029', u'ENSMUSG00000022150', u'ENSMUSG00000004364', u'ENSMUSG00000074657', u'ENSMUSG00000026433', u'ENSMUSG00000037104', u'ENSMUSG00000023150', u'ENSMUSG00000040028', u'ENSMUSG00000047730', u'ENSMUSG00000047735', u'ENSMUSG00000026439', u'ENSMUSG00000030079', u'ENSMUSG00000030557', u'ENSMUSG00000058835', u'ENSMUSG00000015243', u'ENSMUSG00000049932', u'ENSMUSG00000066036', u'ENSMUSG00000036875', u'ENSMUSG00000029148', u'ENSMUSG00000040940', u'ENSMUSG00000004415', u'ENSMUSG00000056537', u'ENSMUSG00000036992', u'ENSMUSG00000029141', u'ENSMUSG00000029146', u'ENSMUSG00000029147', u'ENSMUSG00000041431', u'ENSMUSG00000040734', u'ENSMUSG00000031652', u'ENSMUSG00000029030', u'ENSMUSG00000026322', u'ENSMUSG00000026321', u'ENSMUSG00000059436', u'ENSMUSG00000029810', u'ENSMUSG00000007050', u'ENSMUSG00000015085', u'ENSMUSG00000025538', u'ENSMUSG00000006585', u'ENSMUSG00000047139', u'ENSMUSG00000006586', u'ENSMUSG00000089682', u'ENSMUSG00000025793', u'ENSMUSG00000026923', u'ENSMUSG00000031827', u'ENSMUSG00000026928', u'ENSMUSG00000052144', u'ENSMUSG00000035805', u'ENSMUSG00000003032', u'ENSMUSG00000009079', u'ENSMUSG00000028785', u'ENSMUSG00000003031', u'ENSMUSG00000003037', u'ENSMUSG00000020792', u'ENSMUSG00000009073', u'ENSMUSG00000022442', u'ENSMUSG00000022443', u'ENSMUSG00000028789', u'ENSMUSG00000029361', u'ENSMUSG00000063229', u'ENSMUSG00000034593', u'ENSMUSG00000049717', u'ENSMUSG00000025223', u'ENSMUSG00000015889', u'ENSMUSG00000025220', u'ENSMUSG00000034203', u'ENSMUSG00000021028', u'ENSMUSG00000025225', u'ENSMUSG00000025224', u'ENSMUSG00000021025', u'ENSMUSG00000031781', u'ENSMUSG00000021027', u'ENSMUSG00000036840', u'ENSMUSG00000021022', u'ENSMUSG00000035086', u'ENSMUSG00000029763', u'ENSMUSG00000077450', u'ENSMUSG00000029765', u'ENSMUSG00000060176', u'ENSMUSG00000002108', u'ENSMUSG00000073421', u'ENSMUSG00000023977', u'ENSMUSG00000025008', u'ENSMUSG00000034974', u'ENSMUSG00000025001', u'ENSMUSG00000025006', u'ENSMUSG00000068329', u'ENSMUSG00000043252', u'ENSMUSG00000025316', u'ENSMUSG00000039450', u'ENSMUSG00000025646', u'ENSMUSG00000062995', u'ENSMUSG00000034371', u'ENSMUSG00000033306', u'ENSMUSG00000062991', u'ENSMUSG00000028967', u'ENSMUSG00000028964', u'ENSMUSG00000066613', u'ENSMUSG00000021156', u'ENSMUSG00000068394', u'ENSMUSG00000006127', u'ENSMUSG00000028969', u'ENSMUSG00000028557', u'ENSMUSG00000020170', u'ENSMUSG00000020171', u'ENSMUSG00000006024', u'ENSMUSG00000020173', u'ENSMUSG00000034902', u'ENSMUSG00000020176', u'ENSMUSG00000028367', u'ENSMUSG00000028007', u'ENSMUSG00000008305', u'ENSMUSG00000068290', u'ENSMUSG00000034653', u'ENSMUSG00000018395', u'ENSMUSG00000046876', u'ENSMUSG00000016664', u'ENSMUSG00000014355', u'ENSMUSG00000034509', u'ENSMUSG00000026470', u'ENSMUSG00000028410', u'ENSMUSG00000032688', u'ENSMUSG00000035152', u'ENSMUSG00000037742', u'ENSMUSG00000035403', u'ENSMUSG00000035401', u'ENSMUSG00000038255', u'ENSMUSG00000028416', u'ENSMUSG00000027004', u'ENSMUSG00000009090', u'ENSMUSG00000020776', u'ENSMUSG00000032356', u'ENSMUSG00000020774', u'ENSMUSG00000002748', u'ENSMUSG00000002031', u'ENSMUSG00000024302', u'ENSMUSG00000021546', u'ENSMUSG00000024065', u'ENSMUSG00000028214', u'ENSMUSG00000020019', u'ENSMUSG00000070337', u'ENSMUSG00000028218', u'ENSMUSG00000035299', u'ENSMUSG00000021549', u'ENSMUSG00000068747', u'ENSMUSG00000028524', u'ENSMUSG00000068742', u'ENSMUSG00000027475', u'ENSMUSG00000068039', u'ENSMUSG00000052593', u'ENSMUSG00000006403', u'ENSMUSG00000070436', u'ENSMUSG00000068748', u'ENSMUSG00000042275', u'ENSMUSG00000064289', u'ENSMUSG00000019978', u'ENSMUSG00000042271', u'ENSMUSG00000002325', u'ENSMUSG00000019977', u'ENSMUSG00000017716', u'ENSMUSG00000019971', u'ENSMUSG00000036052', u'ENSMUSG00000037625', u'ENSMUSG00000032537', u'ENSMUSG00000021782', u'ENSMUSG00000021835', u'ENSMUSG00000021785', u'ENSMUSG00000032531', u'ENSMUSG00000034422', u'ENSMUSG00000001105', u'ENSMUSG00000020303', u'ENSMUSG00000034349', u'ENSMUSG00000027466', u'ENSMUSG00000047414', u'ENSMUSG00000062604', u'ENSMUSG00000019373', u'ENSMUSG00000027469', u'ENSMUSG00000020308', u'ENSMUSG00000048826', u'ENSMUSG00000048827', u'ENSMUSG00000002812', u'ENSMUSG00000052613', u'ENSMUSG00000058301', u'ENSMUSG00000021494', u'ENSMUSG00000058239', u'ENSMUSG00000021948', u'ENSMUSG00000029167', u'ENSMUSG00000002257', u'ENSMUSG00000021493', u'ENSMUSG00000024462', u'ENSMUSG00000006930', u'ENSMUSG00000006931', u'ENSMUSG00000006932', u'ENSMUSG00000021945', u'ENSMUSG00000041078', u'ENSMUSG00000041075', u'ENSMUSG00000022935', u'ENSMUSG00000055839', u'ENSMUSG00000027796', u'ENSMUSG00000032827', u'ENSMUSG00000032826', u'ENSMUSG00000038453', u'ENSMUSG00000038451', u'ENSMUSG00000044042', u'ENSMUSG00000058546', u'ENSMUSG00000058013', u'ENSMUSG00000060671', u'ENSMUSG00000030680', u'ENSMUSG00000033065', u'ENSMUSG00000059013', u'ENSMUSG00000033792', u'ENSMUSG00000058558', u'ENSMUSG00000033400', u'ENSMUSG00000039005', u'ENSMUSG00000054477', u'ENSMUSG00000046159', u'ENSMUSG00000036309', u'ENSMUSG00000032312', u'ENSMUSG00000047798', u'ENSMUSG00000022840', u'ENSMUSG00000022841', u'ENSMUSG00000020941', u'ENSMUSG00000037126', u'ENSMUSG00000041670', u'ENSMUSG00000026344', u'ENSMUSG00000020949', u'ENSMUSG00000049470', u'ENSMUSG00000029014', u'ENSMUSG00000030697', u'ENSMUSG00000054871', u'ENSMUSG00000035847', u'ENSMUSG00000059552', u'ENSMUSG00000030844', u'ENSMUSG00000039672', u'ENSMUSG00000056851', u'ENSMUSG00000027438', u'ENSMUSG00000039678', u'ENSMUSG00000024513', u'ENSMUSG00000027649', u'ENSMUSG00000024511', u'ENSMUSG00000050379', u'ENSMUSG00000037012', u'ENSMUSG00000061887', u'ENSMUSG00000024847', u'ENSMUSG00000040385', u'ENSMUSG00000027641', u'ENSMUSG00000027312', u'ENSMUSG00000027314', u'ENSMUSG00000027860', u'ENSMUSG00000030867', u'ENSMUSG00000005682', u'ENSMUSG00000026222', u'ENSMUSG00000004771', u'ENSMUSG00000040659', u'ENSMUSG00000026229', u'ENSMUSG00000067242', u'ENSMUSG00000027883', u'ENSMUSG00000027882', u'ENSMUSG00000045983', u'ENSMUSG00000030265', u'ENSMUSG00000028318', u'ENSMUSG00000030263', u'ENSMUSG00000001552', u'ENSMUSG00000030846', u'ENSMUSG00000039542', u'ENSMUSG00000004798', u'ENSMUSG00000031311', u'ENSMUSG00000073427', u'ENSMUSG00000031314', u'ENSMUSG00000000303', u'ENSMUSG00000031402', u'ENSMUSG00000031403', u'ENSMUSG00000051518', u'ENSMUSG00000000308', u'ENSMUSG00000056121', u'ENSMUSG00000026131', u'ENSMUSG00000049382', u'ENSMUSG00000048731', u'ENSMUSG00000053113', u'ENSMUSG00000022141', u'ENSMUSG00000040033', u'ENSMUSG00000028134', u'ENSMUSG00000022148', u'ENSMUSG00000046768', u'ENSMUSG00000034164', u'ENSMUSG00000034165', u'ENSMUSG00000030315', u'ENSMUSG00000030314', u'ENSMUSG00000031629', u'ENSMUSG00000031229', u'ENSMUSG00000030319', u'ENSMUSG00000030629', u'ENSMUSG00000038115', u'ENSMUSG00000001985', u'ENSMUSG00000068876', u'ENSMUSG00000027177', u'ENSMUSG00000049047', u'ENSMUSG00000029152', u'ENSMUSG00000047098', u'ENSMUSG00000028718', u'ENSMUSG00000049493', u'ENSMUSG00000029027', u'ENSMUSG00000004221', u'ENSMUSG00000029020', u'ENSMUSG00000003200', u'ENSMUSG00000026355', u'ENSMUSG00000029029', u'ENSMUSG00000016619', u'ENSMUSG00000047146', u'ENSMUSG00000015095', u'ENSMUSG00000026867', u'ENSMUSG00000022322', u'ENSMUSG00000090083', u'ENSMUSG00000039414', u'ENSMUSG00000025810', u'ENSMUSG00000039410', u'ENSMUSG00000022329', u'ENSMUSG00000025813', u'ENSMUSG00000021010', u'ENSMUSG00000031133', u'ENSMUSG00000021013', u'ENSMUSG00000020541', u'ENSMUSG00000052155', u'ENSMUSG00000027378', u'ENSMUSG00000020544', u'ENSMUSG00000020546', u'ENSMUSG00000020788', u'ENSMUSG00000028771', u'ENSMUSG00000022451', u'ENSMUSG00000042401', u'ENSMUSG00000004113', u'ENSMUSG00000025498', u'ENSMUSG00000022212', u'ENSMUSG00000057329', u'ENSMUSG00000022216', u'ENSMUSG00000029657', u'ENSMUSG00000047434', u'ENSMUSG00000022508', u'ENSMUSG00000068740', u'ENSMUSG00000036835', u'ENSMUSG00000069170', u'ENSMUSG00000029771', u'ENSMUSG00000061576', u'ENSMUSG00000029777', u'ENSMUSG00000051790', u'ENSMUSG00000059970', u'ENSMUSG00000029778', u'ENSMUSG00000009406', u'ENSMUSG00000028680', u'ENSMUSG00000029576', u'ENSMUSG00000033717', u'ENSMUSG00000060166', u'ENSMUSG00000028518', u'ENSMUSG00000028519', u'ENSMUSG00000025076', u'ENSMUSG00000034789', u'ENSMUSG00000023944', u'ENSMUSG00000023947', u'ENSMUSG00000028179', u'ENSMUSG00000055148', u'ENSMUSG00000033712', u'ENSMUSG00000052085', u'ENSMUSG00000052087', u'ENSMUSG00000028173', u'ENSMUSG00000038845', u'ENSMUSG00000036943', u'ENSMUSG00000036940', u'ENSMUSG00000032000', u'ENSMUSG00000040236', u'ENSMUSG00000028991', u'ENSMUSG00000016477', u'ENSMUSG00000020167', u'ENSMUSG00000028191', u'ENSMUSG00000020644', u'ENSMUSG00000020160', u'ENSMUSG00000029863', u'ENSMUSG00000062647', u'ENSMUSG00000008333', u'ENSMUSG00000028423', u'ENSMUSG00000016496', u'ENSMUSG00000025104', u'ENSMUSG00000016495', u'ENSMUSG00000018362', u'ENSMUSG00000018363', u'ENSMUSG00000034413', u'ENSMUSG00000029642', u'ENSMUSG00000007850', u'ENSMUSG00000052337', u'ENSMUSG00000003308', u'ENSMUSG00000018765', u'ENSMUSG00000032322', u'ENSMUSG00000032320', u'ENSMUSG00000020766', u'ENSMUSG00000030579', u'ENSMUSG00000035783', u'ENSMUSG00000053470', u'ENSMUSG00000052889', u'ENSMUSG00000032328', u'ENSMUSG00000008200', u'ENSMUSG00000021557', u'ENSMUSG00000027434', u'ENSMUSG00000024073', u'ENSMUSG00000021552', u'ENSMUSG00000037313', u'ENSMUSG00000024079', u'ENSMUSG00000060586', u'ENSMUSG00000015522', u'ENSMUSG00000018501', u'ENSMUSG00000018169', u'ENSMUSG00000040187', u'ENSMUSG00000027429', u'ENSMUSG00000057691', u'ENSMUSG00000053931', u'ENSMUSG00000018160', u'ENSMUSG00000002489', u'ENSMUSG00000032030', u'ENSMUSG00000044548', u'ENSMUSG00000032036', u'ENSMUSG00000018166', u'ENSMUSG00000032035', u'ENSMUSG00000053110', u'ENSMUSG00000021796', u'ENSMUSG00000019961', u'ENSMUSG00000021794', u'ENSMUSG00000019966', u'ENSMUSG00000021823', u'ENSMUSG00000021822', u'ENSMUSG00000002319', u'ENSMUSG00000019969', u'ENSMUSG00000021798', u'ENSMUSG00000041261', u'ENSMUSG00000020375', u'ENSMUSG00000020372', u'ENSMUSG00000027411', u'ENSMUSG00000048385', u'ENSMUSG00000039936', u'ENSMUSG00000019564', u'ENSMUSG00000032440', u'ENSMUSG00000033257', u'ENSMUSG00000021488', u'ENSMUSG00000030199', u'ENSMUSG00000033323', u'ENSMUSG00000021483', u'ENSMUSG00000021481', u'ENSMUSG00000032253', u'ENSMUSG00000021485', u'ENSMUSG00000032251', u'ENSMUSG00000006920', u'ENSMUSG00000050248', u'ENSMUSG00000079477', u'ENSMUSG00000054008', u'ENSMUSG00000021998', u'ENSMUSG00000041390', u'ENSMUSG00000018983', u'ENSMUSG00000078945', u'ENSMUSG00000058799', u'ENSMUSG00000030678', u'ENSMUSG00000059796', u'ENSMUSG00000024696', u'ENSMUSG00000033075', u'ENSMUSG00000038685', u'ENSMUSG00000030059', u'ENSMUSG00000038683', u'ENSMUSG00000036550', u'ENSMUSG00000001847', u'ENSMUSG00000037795', u'ENSMUSG00000010095', u'ENSMUSG00000010097', u'ENSMUSG00000005360', u'ENSMUSG00000024212', u'ENSMUSG00000020978', u'ENSMUSG00000054263', u'ENSMUSG00000027522', u'ENSMUSG00000022858', u'ENSMUSG00000075000', u'ENSMUSG00000020973', u'ENSMUSG00000027254', u'ENSMUSG00000020205', u'ENSMUSG00000023087', u'ENSMUSG00000039153', u'ENSMUSG00000072294', u'ENSMUSG00000030782', u'ENSMUSG00000026622', u'ENSMUSG00000004099', u'ENSMUSG00000033671', u'ENSMUSG00000051695', u'ENSMUSG00000008855', u'ENSMUSG00000031875', u'ENSMUSG00000039646', u'ENSMUSG00000030411', u'ENSMUSG00000024501', u'ENSMUSG00000024856', u'ENSMUSG00000024853', u'ENSMUSG00000028284', u'ENSMUSG00000037573', u'ENSMUSG00000041710', u'ENSMUSG00000033788', u'ENSMUSG00000015846', u'ENSMUSG00000027322', u'ENSMUSG00000024858', u'ENSMUSG00000026235', u'ENSMUSG00000026234', u'ENSMUSG00000030898', u'ENSMUSG00000034563', u'ENSMUSG00000032507', u'ENSMUSG00000005148', u'ENSMUSG00000045658', u'ENSMUSG00000030890', u'ENSMUSG00000041482', u'ENSMUSG00000026239', u'ENSMUSG00000030894', u'ENSMUSG00000030077', u'ENSMUSG00000030092', u'ENSMUSG00000030093', u'ENSMUSG00000062234', u'ENSMUSG00000055421', u'ENSMUSG00000031309', u'ENSMUSG00000030254', u'ENSMUSG00000030256', u'ENSMUSG00000030257', u'ENSMUSG00000030528', u'ENSMUSG00000021224', u'ENSMUSG00000071659', u'ENSMUSG00000029581', u'ENSMUSG00000027746', u'ENSMUSG00000050213', u'ENSMUSG00000060098', u'ENSMUSG00000026121', u'ENSMUSG00000027748', u'ENSMUSG00000071650', u'ENSMUSG00000026697', u'ENSMUSG00000040289', u'ENSMUSG00000023952', u'ENSMUSG00000022136', u'ENSMUSG00000011148', u'ENSMUSG00000031787', u'ENSMUSG00000053799', u'ENSMUSG00000022132', u'ENSMUSG00000034810', u'ENSMUSG00000031783', u'ENSMUSG00000060938', u'ENSMUSG00000038668', u'ENSMUSG00000014932', u'ENSMUSG00000014426', u'ENSMUSG00000034175', u'ENSMUSG00000030327', u'ENSMUSG00000055737', u'ENSMUSG00000017831', u'ENSMUSG00000034023', u'ENSMUSG00000025809', u'ENSMUSG00000055760', u'ENSMUSG00000021313', u'ENSMUSG00000029168', u'ENSMUSG00000029169', u'ENSMUSG00000021314', u'ENSMUSG00000029166', u'ENSMUSG00000021318', u'ENSMUSG00000029716', u'ENSMUSG00000047085', u'ENSMUSG00000028603', u'ENSMUSG00000022048', u'ENSMUSG00000026349', u'ENSMUSG00000060261', u'ENSMUSG00000060802', u'ENSMUSG00000060803', u'ENSMUSG00000003234', u'ENSMUSG00000022043', u'ENSMUSG00000026347', u'ENSMUSG00000026341', u'ENSMUSG00000003233', u'ENSMUSG00000047407', u'ENSMUSG00000007038', u'ENSMUSG00000072663', u'ENSMUSG00000022685', u'ENSMUSG00000022687', u'ENSMUSG00000039577', u'ENSMUSG00000013707', u'ENSMUSG00000020577', u'ENSMUSG00000063065', u'ENSMUSG00000020573', u'ENSMUSG00000022663', u'ENSMUSG00000022661', u'ENSMUSG00000028760', u'ENSMUSG00000028763', u'ENSMUSG00000011960', u'ENSMUSG00000005968', u'ENSMUSG00000028766', u'ENSMUSG00000025486', u'ENSMUSG00000025485', u'ENSMUSG00000031715', u'ENSMUSG00000058298', u'ENSMUSG00000022594', u'ENSMUSG00000043099', u'ENSMUSG00000034573', u'ENSMUSG00000034574', u'ENSMUSG00000022261', u'ENSMUSG00000025245', u'ENSMUSG00000025246', u'ENSMUSG00000025243', u'ENSMUSG00000042708', u'ENSMUSG00000036825', u'ENSMUSG00000042870', u'ENSMUSG00000032867', u'ENSMUSG00000066189', u'ENSMUSG00000036822', u'ENSMUSG00000027001', u'ENSMUSG00000028698', u'ENSMUSG00000057177', u'ENSMUSG00000028691', u'ENSMUSG00000028693', u'ENSMUSG00000020684', u'ENSMUSG00000012819', u'ENSMUSG00000020681', u'ENSMUSG00000034799', u'ENSMUSG00000029580', u'ENSMUSG00000014668', u'ENSMUSG00000050321', u'ENSMUSG00000025060', u'ENSMUSG00000023951', u'ENSMUSG00000020689', u'ENSMUSG00000062352', u'ENSMUSG00000022463', u'ENSMUSG00000029345', u'ENSMUSG00000043987', u'ENSMUSG00000022469', u'ENSMUSG00000034317', u'ENSMUSG00000041415', u'ENSMUSG00000028163', u'ENSMUSG00000025666', u'ENSMUSG00000028161', u'ENSMUSG00000061462', u'ENSMUSG00000028988', u'ENSMUSG00000027133', u'ENSMUSG00000045954']), study_n=624, level=2, is_obsolete=False, namespace='molecular_function', alt_ids=set(['GO:0001948', 'GO:0045308'])),
    NtGoeaResults(GO='GO:0005516', NS='MF', enrichment='p', name='calmodulin binding', ratio_in_study=(2, 624), ratio_in_pop=(149, 13836), p_uncorrected=0.07016222097218422, depth=3, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000033952', u'ENSMUSG00000047945']), pop_n=13836, pop_count=149, pop_items=set([u'ENSMUSG00000022837', u'ENSMUSG00000002012', u'ENSMUSG00000024077', u'ENSMUSG00000022836', u'ENSMUSG00000062151', u'ENSMUSG00000020190', u'ENSMUSG00000021559', u'ENSMUSG00000032936', u'ENSMUSG00000005615', u'ENSMUSG00000028344', u'ENSMUSG00000029454', u'ENSMUSG00000016528', u'ENSMUSG00000004665', u'ENSMUSG00000058248', u'ENSMUSG00000029106', u'ENSMUSG00000034402', u'ENSMUSG00000053310', u'ENSMUSG00000004347', u'ENSMUSG00000053931', u'ENSMUSG00000031295', u'ENSMUSG00000032220', u'ENSMUSG00000030592', u'ENSMUSG00000020954', u'ENSMUSG00000041607', u'ENSMUSG00000021820', u'ENSMUSG00000033952', u'ENSMUSG00000054640', u'ENSMUSG00000020894', u'ENSMUSG00000039145', u'ENSMUSG00000034656', u'ENSMUSG00000049686', u'ENSMUSG00000090223', u'ENSMUSG00000038128', u'ENSMUSG00000004677', u'ENSMUSG00000026959', u'ENSMUSG00000024960', u'ENSMUSG00000030761', u'ENSMUSG00000022092', u'ENSMUSG00000022489', u'ENSMUSG00000054477', u'ENSMUSG00000041308', u'ENSMUSG00000028261', u'ENSMUSG00000041570', u'ENSMUSG00000026463', u'ENSMUSG00000044433', u'ENSMUSG00000021057', u'ENSMUSG00000036879', u'ENSMUSG00000015222', u'ENSMUSG00000024778', u'ENSMUSG00000074272', u'ENSMUSG00000057897', u'ENSMUSG00000020431', u'ENSMUSG00000030272', u'ENSMUSG00000020437', u'ENSMUSG00000030376', u'ENSMUSG00000030374', u'ENSMUSG00000056258', u'ENSMUSG00000027488', u'ENSMUSG00000000794', u'ENSMUSG00000003752', u'ENSMUSG00000035441', u'ENSMUSG00000014158', u'ENSMUSG00000039474', u'ENSMUSG00000030302', u'ENSMUSG00000026933', u'ENSMUSG00000031012', u'ENSMUSG00000066036', u'ENSMUSG00000060429', u'ENSMUSG00000025026', u'ENSMUSG00000061878', u'ENSMUSG00000035064', u'ENSMUSG00000057378', u'ENSMUSG00000030815', u'ENSMUSG00000057738', u'ENSMUSG00000016346', u'ENSMUSG00000024617', u'ENSMUSG00000063239', u'ENSMUSG00000021816', u'ENSMUSG00000025537', u'ENSMUSG00000020122', u'ENSMUSG00000042632', u'ENSMUSG00000034055', u'ENSMUSG00000026610', u'ENSMUSG00000053093', u'ENSMUSG00000020719', u'ENSMUSG00000047945', u'ENSMUSG00000009079', u'ENSMUSG00000035864', u'ENSMUSG00000022443', u'ENSMUSG00000029361', u'ENSMUSG00000034593', u'ENSMUSG00000032507', u'ENSMUSG00000032503', u'ENSMUSG00000033577', u'ENSMUSG00000001151', u'ENSMUSG00000015092', u'ENSMUSG00000028978', u'ENSMUSG00000024743', u'ENSMUSG00000020654', u'ENSMUSG00000069662', u'ENSMUSG00000057182', u'ENSMUSG00000051177', u'ENSMUSG00000021313', u'ENSMUSG00000027296', u'ENSMUSG00000002908', u'ENSMUSG00000030536', u'ENSMUSG00000030000', u'ENSMUSG00000020785', u'ENSMUSG00000057455', u'ENSMUSG00000020908', u'ENSMUSG00000016179', u'ENSMUSG00000028708', u'ENSMUSG00000020900', u'ENSMUSG00000032511', u'ENSMUSG00000025885', u'ENSMUSG00000018830', u'ENSMUSG00000059173', u'ENSMUSG00000051747', u'ENSMUSG00000017774', u'ENSMUSG00000035578', u'ENSMUSG00000032577', u'ENSMUSG00000029471', u'ENSMUSG00000020473', u'ENSMUSG00000055407', u'ENSMUSG00000056755', u'ENSMUSG00000028179', u'ENSMUSG00000079055', u'ENSMUSG00000018417', u'ENSMUSG00000019943', u'ENSMUSG00000053819', u'ENSMUSG00000021708', u'ENSMUSG00000038260', u'ENSMUSG00000021676', u'ENSMUSG00000024300', u'ENSMUSG00000034799', u'ENSMUSG00000030516', u'ENSMUSG00000041417', u'ENSMUSG00000028456', u'ENSMUSG00000022376', u'ENSMUSG00000061462', u'ENSMUSG00000030739', u'ENSMUSG00000028906', u'ENSMUSG00000028161', u'ENSMUSG00000022272', u'ENSMUSG00000041205', u'ENSMUSG00000047261', u'ENSMUSG00000028854', u'ENSMUSG00000020315', u'ENSMUSG00000039298']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005524', NS='MF', enrichment='e', name='ATP binding', ratio_in_study=(105, 624), ratio_in_pop=(1180, 13836), p_uncorrected=2.4035926810360355e-10, depth=8, study_count=105, p_sm_bonferroni=3.7750826648351972e-06, p_fdr_bh=1.1103184308338814e-07, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000034349', u'ENSMUSG00000045328', u'ENSMUSG00000074151', u'ENSMUSG00000037321', u'ENSMUSG00000025358', u'ENSMUSG00000042699', u'ENSMUSG00000059552', u'ENSMUSG00000003779', u'ENSMUSG00000020380', u'ENSMUSG00000028587', u'ENSMUSG00000027379', u'ENSMUSG00000042167', u'ENSMUSG00000034329', u'ENSMUSG00000025758', u'ENSMUSG00000021569', u'ENSMUSG00000029521', u'ENSMUSG00000024079', u'ENSMUSG00000051378', u'ENSMUSG00000006445', u'ENSMUSG00000033257', u'ENSMUSG00000026896', u'ENSMUSG00000030677', u'ENSMUSG00000024974', u'ENSMUSG00000027496', u'ENSMUSG00000032254', u'ENSMUSG00000029283', u'ENSMUSG00000036875', u'ENSMUSG00000021115', u'ENSMUSG00000023908', u'ENSMUSG00000031004', u'ENSMUSG00000029730', u'ENSMUSG00000040296', u'ENSMUSG00000019214', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000002870', u'ENSMUSG00000030978', u'ENSMUSG00000035683', u'ENSMUSG00000031478', u'ENSMUSG00000028633', u'ENSMUSG00000030867', u'ENSMUSG00000041498', u'ENSMUSG00000032409', u'ENSMUSG00000035266', u'ENSMUSG00000028312', u'ENSMUSG00000026281', u'ENSMUSG00000026622', u'ENSMUSG00000036768', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000005370', u'ENSMUSG00000034218', u'ENSMUSG00000012443', u'ENSMUSG00000038774', u'ENSMUSG00000032661', u'ENSMUSG00000022360', u'ENSMUSG00000001403', u'ENSMUSG00000033762', u'ENSMUSG00000051220', u'ENSMUSG00000030528', u'ENSMUSG00000029363', u'ENSMUSG00000036086', u'ENSMUSG00000027580', u'ENSMUSG00000026355', u'ENSMUSG00000020914', u'ENSMUSG00000034206', u'ENSMUSG00000041133', u'ENSMUSG00000022033', u'ENSMUSG00000017550', u'ENSMUSG00000017830', u'ENSMUSG00000005481', u'ENSMUSG00000020897', u'ENSMUSG00000022881', u'ENSMUSG00000025001', u'ENSMUSG00000032344', u'ENSMUSG00000005410', u'ENSMUSG00000028702', u'ENSMUSG00000002227', u'ENSMUSG00000028678', u'ENSMUSG00000038379', u'ENSMUSG00000024795', u'ENSMUSG00000041859', u'ENSMUSG00000041827', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000056394', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000002748', u'ENSMUSG00000027115', u'ENSMUSG00000024404', u'ENSMUSG00000022673', u'ENSMUSG00000029580', u'ENSMUSG00000017499', u'ENSMUSG00000019979', u'ENSMUSG00000029561', u'ENSMUSG00000033222', u'ENSMUSG00000034311', u'ENSMUSG00000026274', u'ENSMUSG00000005237', u'ENSMUSG00000020608', u'ENSMUSG00000025574', u'ENSMUSG00000027078', u'ENSMUSG00000060519']), pop_n=13836, pop_count=1180, pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000040084', u'ENSMUSG00000002010', u'ENSMUSG00000026490', u'ENSMUSG00000028028', u'ENSMUSG00000026494', u'ENSMUSG00000030603', u'ENSMUSG00000020190', u'ENSMUSG00000017405', u'ENSMUSG00000061878', u'ENSMUSG00000024359', u'ENSMUSG00000028431', u'ENSMUSG00000029512', u'ENSMUSG00000031583', u'ENSMUSG00000016528', u'ENSMUSG00000020865', u'ENSMUSG00000016526', u'ENSMUSG00000028438', u'ENSMUSG00000031805', u'ENSMUSG00000089872', u'ENSMUSG00000023286', u'ENSMUSG00000027665', u'ENSMUSG00000043572', u'ENSMUSG00000028932', u'ENSMUSG00000015133', u'ENSMUSG00000040907', u'ENSMUSG00000026245', u'ENSMUSG00000029516', u'ENSMUSG00000040675', u'ENSMUSG00000004054', u'ENSMUSG00000004056', u'ENSMUSG00000002409', u'ENSMUSG00000057113', u'ENSMUSG00000035032', u'ENSMUSG00000020752', u'ENSMUSG00000052997', u'ENSMUSG00000031862', u'ENSMUSG00000015120', u'ENSMUSG00000056608', u'ENSMUSG00000040661', u'ENSMUSG00000043535', u'ENSMUSG00000021569', u'ENSMUSG00000021400', u'ENSMUSG00000033862', u'ENSMUSG00000015023', u'ENSMUSG00000045095', u'ENSMUSG00000024042', u'ENSMUSG00000021408', u'ENSMUSG00000074364', u'ENSMUSG00000030204', u'ENSMUSG00000073563', u'ENSMUSG00000032312', u'ENSMUSG00000032097', u'ENSMUSG00000006567', u'ENSMUSG00000004677', u'ENSMUSG00000049091', u'ENSMUSG00000031450', u'ENSMUSG00000033703', u'ENSMUSG00000042228', u'ENSMUSG00000006445', u'ENSMUSG00000046101', u'ENSMUSG00000028926', u'ENSMUSG00000059981', u'ENSMUSG00000037321', u'ENSMUSG00000027011', u'ENSMUSG00000032384', u'ENSMUSG00000035112', u'ENSMUSG00000052459', u'ENSMUSG00000052456', u'ENSMUSG00000035722', u'ENSMUSG00000028708', u'ENSMUSG00000052981', u'ENSMUSG00000035725', u'ENSMUSG00000021774', u'ENSMUSG00000018583', u'ENSMUSG00000038058', u'ENSMUSG00000026429', u'ENSMUSG00000060176', u'ENSMUSG00000045962', u'ENSMUSG00000031392', u'ENSMUSG00000020366', u'ENSMUSG00000020361', u'ENSMUSG00000001783', u'ENSMUSG00000057133', u'ENSMUSG00000025939', u'ENSMUSG00000030110', u'ENSMUSG00000053046', u'ENSMUSG00000067995', u'ENSMUSG00000028874', u'ENSMUSG00000022781', u'ENSMUSG00000019214', u'ENSMUSG00000078578', u'ENSMUSG00000026944', u'ENSMUSG00000025885', u'ENSMUSG00000061288', u'ENSMUSG00000022629', u'ENSMUSG00000018209', u'ENSMUSG00000029635', u'ENSMUSG00000020532', u'ENSMUSG00000028876', u'ENSMUSG00000002870', u'ENSMUSG00000062312', u'ENSMUSG00000037601', u'ENSMUSG00000031644', u'ENSMUSG00000027379', u'ENSMUSG00000006386', u'ENSMUSG00000058301', u'ENSMUSG00000036622', u'ENSMUSG00000020048', u'ENSMUSG00000003752', u'ENSMUSG00000001270', u'ENSMUSG00000021287', u'ENSMUSG00000022562', u'ENSMUSG00000024769', u'ENSMUSG00000050002', u'ENSMUSG00000035266', u'ENSMUSG00000047454', u'ENSMUSG00000031012', u'ENSMUSG00000031015', u'ENSMUSG00000009681', u'ENSMUSG00000031016', u'ENSMUSG00000059456', u'ENSMUSG00000032802', u'ENSMUSG00000033191', u'ENSMUSG00000018995', u'ENSMUSG00000026836', u'ENSMUSG00000045328', u'ENSMUSG00000026834', u'ENSMUSG00000022533', u'ENSMUSG00000028792', u'ENSMUSG00000020333', u'ENSMUSG00000022433', u'ENSMUSG00000030660', u'ENSMUSG00000028653', u'ENSMUSG00000025949', u'ENSMUSG00000078945', u'ENSMUSG00000054051', u'ENSMUSG00000036241', u'ENSMUSG00000078941', u'ENSMUSG00000078942', u'ENSMUSG00000022234', u'ENSMUSG00000017774', u'ENSMUSG00000000787', u'ENSMUSG00000021589', u'ENSMUSG00000024617', u'ENSMUSG00000007613', u'ENSMUSG00000000628', u'ENSMUSG00000005370', u'ENSMUSG00000022861', u'ENSMUSG00000034218', u'ENSMUSG00000006740', u'ENSMUSG00000037149', u'ENSMUSG00000012609', u'ENSMUSG00000037351', u'ENSMUSG00000032661', u'ENSMUSG00000032220', u'ENSMUSG00000020715', u'ENSMUSG00000026615', u'ENSMUSG00000032604', u'ENSMUSG00000020719', u'ENSMUSG00000026618', u'ENSMUSG00000061393', u'ENSMUSG00000026596', u'ENSMUSG00000033762', u'ENSMUSG00000024831', u'ENSMUSG00000005493', u'ENSMUSG00000028479', u'ENSMUSG00000050697', u'ENSMUSG00000033161', u'ENSMUSG00000020827', u'ENSMUSG00000030400', u'ENSMUSG00000020821', u'ENSMUSG00000070544', u'ENSMUSG00000027580', u'ENSMUSG00000030592', u'ENSMUSG00000042642', u'ENSMUSG00000041235', u'ENSMUSG00000000532', u'ENSMUSG00000020917', u'ENSMUSG00000020914', u'ENSMUSG00000028970', u'ENSMUSG00000059970', u'ENSMUSG00000066800', u'ENSMUSG00000028973', u'ENSMUSG00000005981', u'ENSMUSG00000054252', u'ENSMUSG00000024981', u'ENSMUSG00000026201', u'ENSMUSG00000048310', u'ENSMUSG00000019432', u'ENSMUSG00000014554', u'ENSMUSG00000046709', u'ENSMUSG00000040479', u'ENSMUSG00000030079', u'ENSMUSG00000026885', u'ENSMUSG00000028078', u'ENSMUSG00000032599', u'ENSMUSG00000024122', u'ENSMUSG00000038094', u'ENSMUSG00000028277', u'ENSMUSG00000014349', u'ENSMUSG00000030243', u'ENSMUSG00000027905', u'ENSMUSG00000041720', u'ENSMUSG00000038965', u'ENSMUSG00000028127', u'ENSMUSG00000033885', u'ENSMUSG00000069539', u'ENSMUSG00000026187', u'ENSMUSG00000018796', u'ENSMUSG00000030249', u'ENSMUSG00000028948', u'ENSMUSG00000040936', u'ENSMUSG00000018334', u'ENSMUSG00000000441', u'ENSMUSG00000016179', u'ENSMUSG00000042010', u'ENSMUSG00000032344', u'ENSMUSG00000062960', u'ENSMUSG00000018707', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000032691', u'ENSMUSG00000031833', u'ENSMUSG00000038838', u'ENSMUSG00000003534', u'ENSMUSG00000020668', u'ENSMUSG00000032571', u'ENSMUSG00000035769', u'ENSMUSG00000025877', u'ENSMUSG00000032570', u'ENSMUSG00000021536', u'ENSMUSG00000025574', u'ENSMUSG00000021240', u'ENSMUSG00000062070', u'ENSMUSG00000064090', u'ENSMUSG00000022897', u'ENSMUSG00000036199', u'ENSMUSG00000044708', u'ENSMUSG00000027323', u'ENSMUSG00000033557', u'ENSMUSG00000035455', u'ENSMUSG00000023050', u'ENSMUSG00000026576', u'ENSMUSG00000018417', u'ENSMUSG00000026473', u'ENSMUSG00000053137', u'ENSMUSG00000019943', u'ENSMUSG00000019942', u'ENSMUSG00000032115', u'ENSMUSG00000075590', u'ENSMUSG00000007029', u'ENSMUSG00000019863', u'ENSMUSG00000032527', u'ENSMUSG00000032281', u'ENSMUSG00000003228', u'ENSMUSG00000024404', u'ENSMUSG00000022758', u'ENSMUSG00000035305', u'ENSMUSG00000022822', u'ENSMUSG00000055775', u'ENSMUSG00000034329', u'ENSMUSG00000031112', u'ENSMUSG00000029186', u'ENSMUSG00000020258', u'ENSMUSG00000013736', u'ENSMUSG00000022673', u'ENSMUSG00000022672', u'ENSMUSG00000028758', u'ENSMUSG00000032842', u'ENSMUSG00000056367', u'ENSMUSG00000024782', u'ENSMUSG00000028756', u'ENSMUSG00000058444', u'ENSMUSG00000020444', u'ENSMUSG00000021500', u'ENSMUSG00000025580', u'ENSMUSG00000017550', u'ENSMUSG00000029447', u'ENSMUSG00000022376', u'ENSMUSG00000024493', u'ENSMUSG00000003099', u'ENSMUSG00000057342', u'ENSMUSG00000033222', u'ENSMUSG00000026575', u'ENSMUSG00000003762', u'ENSMUSG00000024712', u'ENSMUSG00000022272', u'ENSMUSG00000045038', u'ENSMUSG00000005237', u'ENSMUSG00000034663', u'ENSMUSG00000024300', u'ENSMUSG00000015971', u'ENSMUSG00000060519', u'ENSMUSG00000032113', u'ENSMUSG00000079109', u'ENSMUSG00000032440', u'ENSMUSG00000026806', u'ENSMUSG00000051378', u'ENSMUSG00000029752', u'ENSMUSG00000039145', u'ENSMUSG00000047866', u'ENSMUSG00000007739', u'ENSMUSG00000032936', u'ENSMUSG00000060671', u'ENSMUSG00000010021', u'ENSMUSG00000020694', u'ENSMUSG00000020697', u'ENSMUSG00000025358', u'ENSMUSG00000042699', u'ENSMUSG00000024878', u'ENSMUSG00000059552', u'ENSMUSG00000028933', u'ENSMUSG00000023809', u'ENSMUSG00000028107', u'ENSMUSG00000034761', u'ENSMUSG00000020389', u'ENSMUSG00000034024', u'ENSMUSG00000026848', u'ENSMUSG00000022471', u'ENSMUSG00000001829', u'ENSMUSG00000020380', u'ENSMUSG00000025613', u'ENSMUSG00000020385', u'ENSMUSG00000025757', u'ENSMUSG00000027274', u'ENSMUSG00000070644', u'ENSMUSG00000033792', u'ENSMUSG00000020899', u'ENSMUSG00000031913', u'ENSMUSG00000021069', u'ENSMUSG00000026778', u'ENSMUSG00000004113', u'ENSMUSG00000052539', u'ENSMUSG00000038861', u'ENSMUSG00000020890', u'ENSMUSG00000020620', u'ENSMUSG00000023938', u'ENSMUSG00000020623', u'ENSMUSG00000040584', u'ENSMUSG00000029521', u'ENSMUSG00000006019', u'ENSMUSG00000055782', u'ENSMUSG00000020181', u'ENSMUSG00000031853', u'ENSMUSG00000003868', u'ENSMUSG00000028032', u'ENSMUSG00000034931', u'ENSMUSG00000062825', u'ENSMUSG00000038145', u'ENSMUSG00000027394', u'ENSMUSG00000074781', u'ENSMUSG00000042426', u'ENSMUSG00000039585', u'ENSMUSG00000037251', u'ENSMUSG00000004187', u'ENSMUSG00000027177', u'ENSMUSG00000024151', u'ENSMUSG00000005045', u'ENSMUSG00000004069', u'ENSMUSG00000025059', u'ENSMUSG00000031505', u'ENSMUSG00000035948', u'ENSMUSG00000035824', u'ENSMUSG00000023277', u'ENSMUSG00000040390', u'ENSMUSG00000032308', u'ENSMUSG00000030871', u'ENSMUSG00000031974', u'ENSMUSG00000031972', u'ENSMUSG00000015656', u'ENSMUSG00000026622', u'ENSMUSG00000026620', u'ENSMUSG00000002413', u'ENSMUSG00000061207', u'ENSMUSG00000032307', u'ENSMUSG00000062234', u'ENSMUSG00000017291', u'ENSMUSG00000022386', u'ENSMUSG00000021470', u'ENSMUSG00000030276', u'ENSMUSG00000027952', u'ENSMUSG00000024054', u'ENSMUSG00000030272', u'ENSMUSG00000006517', u'ENSMUSG00000000276', u'ENSMUSG00000022994', u'ENSMUSG00000031303', u'ENSMUSG00000025854', u'ENSMUSG00000038260', u'ENSMUSG00000031378', u'ENSMUSG00000057177', u'ENSMUSG00000037685', u'ENSMUSG00000035759', u'ENSMUSG00000064105', u'ENSMUSG00000020794', u'ENSMUSG00000026027', u'ENSMUSG00000014850', u'ENSMUSG00000042349', u'ENSMUSG00000028661', u'ENSMUSG00000026437', u'ENSMUSG00000040021', u'ENSMUSG00000035828', u'ENSMUSG00000051444', u'ENSMUSG00000038762', u'ENSMUSG00000078671', u'ENSMUSG00000004936', u'ENSMUSG00000060477', u'ENSMUSG00000004933', u'ENSMUSG00000032409', u'ENSMUSG00000057788', u'ENSMUSG00000030302', u'ENSMUSG00000062044', u'ENSMUSG00000015243', u'ENSMUSG00000034290', u'ENSMUSG00000036875', u'ENSMUSG00000020357', u'ENSMUSG00000031099', u'ENSMUSG00000003283', u'ENSMUSG00000031155', u'ENSMUSG00000039913', u'ENSMUSG00000002963', u'ENSMUSG00000031090', u'ENSMUSG00000002688', u'ENSMUSG00000021983', u'ENSMUSG00000029036', u'ENSMUSG00000021879', u'ENSMUSG00000036095', u'ENSMUSG00000075324', u'ENSMUSG00000052504', u'ENSMUSG00000032478', u'ENSMUSG00000002205', u'ENSMUSG00000032577', u'ENSMUSG00000024789', u'ENSMUSG00000031659', u'ENSMUSG00000040820', u'ENSMUSG00000015085', u'ENSMUSG00000025537', u'ENSMUSG00000012443', u'ENSMUSG00000028811', u'ENSMUSG00000074305', u'ENSMUSG00000018846', u'ENSMUSG00000018841', u'ENSMUSG00000026849', u'ENSMUSG00000040327', u'ENSMUSG00000040325', u'ENSMUSG00000005907', u'ENSMUSG00000026842', u'ENSMUSG00000018848', u'ENSMUSG00000009772', u'ENSMUSG00000029245', u'ENSMUSG00000029247', u'ENSMUSG00000029217', u'ENSMUSG00000028664', u'ENSMUSG00000030655', u'ENSMUSG00000019087', u'ENSMUSG00000022442', u'ENSMUSG00000022443', u'ENSMUSG00000024290', u'ENSMUSG00000032883', u'ENSMUSG00000028719', u'ENSMUSG00000006281', u'ENSMUSG00000034593', u'ENSMUSG00000033276', u'ENSMUSG00000049717', u'ENSMUSG00000024339', u'ENSMUSG00000028862', u'ENSMUSG00000029203', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000033610', u'ENSMUSG00000025648', u'ENSMUSG00000021385', u'ENSMUSG00000024235', u'ENSMUSG00000024234', u'ENSMUSG00000020228', u'ENSMUSG00000005469', u'ENSMUSG00000000631', u'ENSMUSG00000001729', u'ENSMUSG00000041133', u'ENSMUSG00000025228', u'ENSMUSG00000041135', u'ENSMUSG00000041642', u'ENSMUSG00000017499', u'ENSMUSG00000020705', u'ENSMUSG00000029408', u'ENSMUSG00000026662', u'ENSMUSG00000026516', u'ENSMUSG00000066952', u'ENSMUSG00000020700', u'ENSMUSG00000029403', u'ENSMUSG00000001924', u'ENSMUSG00000026584', u'ENSMUSG00000039515', u'ENSMUSG00000020708', u'ENSMUSG00000005481', u'ENSMUSG00000029561', u'ENSMUSG00000009555', u'ENSMUSG00000027297', u'ENSMUSG00000043410', u'ENSMUSG00000027293', u'ENSMUSG00000028530', u'ENSMUSG00000025001', u'ENSMUSG00000009293', u'ENSMUSG00000025007', u'ENSMUSG00000041645', u'ENSMUSG00000030007', u'ENSMUSG00000003644', u'ENSMUSG00000001034', u'ENSMUSG00000020908', u'ENSMUSG00000040274', u'ENSMUSG00000041187', u'ENSMUSG00000005102', u'ENSMUSG00000020152', u'ENSMUSG00000005410', u'ENSMUSG00000024527', u'ENSMUSG00000025092', u'ENSMUSG00000031788', u'ENSMUSG00000026749', u'ENSMUSG00000018830', u'ENSMUSG00000051747', u'ENSMUSG00000028960', u'ENSMUSG00000018932', u'ENSMUSG00000046994', u'ENSMUSG00000028969', u'ENSMUSG00000051627', u'ENSMUSG00000029916', u'ENSMUSG00000041797', u'ENSMUSG00000026667', u'ENSMUSG00000029674', u'ENSMUSG00000033628', u'ENSMUSG00000009394', u'ENSMUSG00000041440', u'ENSMUSG00000008730', u'ENSMUSG00000034653', u'ENSMUSG00000018395', u'ENSMUSG00000028289', u'ENSMUSG00000063410', u'ENSMUSG00000028458', u'ENSMUSG00000028284', u'ENSMUSG00000039954', u'ENSMUSG00000027823', u'ENSMUSG00000027765', u'ENSMUSG00000025162', u'ENSMUSG00000028410', u'ENSMUSG00000043962', u'ENSMUSG00000042572', u'ENSMUSG00000031565', u'ENSMUSG00000056458', u'ENSMUSG00000002102', u'ENSMUSG00000031432', u'ENSMUSG00000029366', u'ENSMUSG00000041828', u'ENSMUSG00000053693', u'ENSMUSG00000050965', u'ENSMUSG00000032350', u'ENSMUSG00000019659', u'ENSMUSG00000058594', u'ENSMUSG00000002748', u'ENSMUSG00000022110', u'ENSMUSG00000031851', u'ENSMUSG00000038481', u'ENSMUSG00000020677', u'ENSMUSG00000059796', u'ENSMUSG00000002428', u'ENSMUSG00000024065', u'ENSMUSG00000021279', u'ENSMUSG00000034343', u'ENSMUSG00000020015', u'ENSMUSG00000020766', u'ENSMUSG00000021270', u'ENSMUSG00000024382', u'ENSMUSG00000024068', u'ENSMUSG00000021375', u'ENSMUSG00000032498', u'ENSMUSG00000035683', u'ENSMUSG00000031668', u'ENSMUSG00000027475', u'ENSMUSG00000068039', u'ENSMUSG00000029063', u'ENSMUSG00000029062', u'ENSMUSG00000050271', u'ENSMUSG00000035232', u'ENSMUSG00000026074', u'ENSMUSG00000042064', u'ENSMUSG00000019979', u'ENSMUSG00000052430', u'ENSMUSG00000026404', u'ENSMUSG00000028959', u'ENSMUSG00000019970', u'ENSMUSG00000027296', u'ENSMUSG00000060860', u'ENSMUSG00000017715', u'ENSMUSG00000032537', u'ENSMUSG00000021428', u'ENSMUSG00000021832', u'ENSMUSG00000053436', u'ENSMUSG00000034751', u'ENSMUSG00000021936', u'ENSMUSG00000030849', u'ENSMUSG00000022836', u'ENSMUSG00000063077', u'ENSMUSG00000020307', u'ENSMUSG00000073775', u'ENSMUSG00000062604', u'ENSMUSG00000068739', u'ENSMUSG00000029191', u'ENSMUSG00000029190', u'ENSMUSG00000027546', u'ENSMUSG00000028953', u'ENSMUSG00000020516', u'ENSMUSG00000047193', u'ENSMUSG00000031065', u'ENSMUSG00000021180', u'ENSMUSG00000034974', u'ENSMUSG00000042608', u'ENSMUSG00000029613', u'ENSMUSG00000036737', u'ENSMUSG00000042567', u'ENSMUSG00000020451', u'ENSMUSG00000019577', u'ENSMUSG00000021494', u'ENSMUSG00000033577', u'ENSMUSG00000021948', u'ENSMUSG00000003779', u'ENSMUSG00000032547', u'ENSMUSG00000042167', u'ENSMUSG00000027298', u'ENSMUSG00000053754', u'ENSMUSG00000022360', u'ENSMUSG00000048899', u'ENSMUSG00000027722', u'ENSMUSG00000002550', u'ENSMUSG00000029920', u'ENSMUSG00000022241', u'ENSMUSG00000054404', u'ENSMUSG00000033352', u'ENSMUSG00000032932', u'ENSMUSG00000039354', u'ENSMUSG00000007646', u'ENSMUSG00000025915', u'ENSMUSG00000037738', u'ENSMUSG00000031960', u'ENSMUSG00000024242', u'ENSMUSG00000027797', u'ENSMUSG00000029363', u'ENSMUSG00000026817', u'ENSMUSG00000021693', u'ENSMUSG00000026709', u'ENSMUSG00000015981', u'ENSMUSG00000024969', u'ENSMUSG00000029334', u'ENSMUSG00000025324', u'ENSMUSG00000033065', u'ENSMUSG00000030761', u'ENSMUSG00000024079', u'ENSMUSG00000024247', u'ENSMUSG00000038970', u'ENSMUSG00000024974', u'ENSMUSG00000033526', u'ENSMUSG00000001674', u'ENSMUSG00000035027', u'ENSMUSG00000027496', u'ENSMUSG00000037643', u'ENSMUSG00000058997', u'ENSMUSG00000040648', u'ENSMUSG00000042751', u'ENSMUSG00000001774', u'ENSMUSG00000024566', u'ENSMUSG00000022840', u'ENSMUSG00000030061', u'ENSMUSG00000020941', u'ENSMUSG00000070699', u'ENSMUSG00000074652', u'ENSMUSG00000020900', u'ENSMUSG00000021115', u'ENSMUSG00000021111', u'ENSMUSG00000020580', u'ENSMUSG00000035202', u'ENSMUSG00000026094', u'ENSMUSG00000019699', u'ENSMUSG00000076435', u'ENSMUSG00000023908', u'ENSMUSG00000032489', u'ENSMUSG00000009566', u'ENSMUSG00000067336', u'ENSMUSG00000009563', u'ENSMUSG00000033705', u'ENSMUSG00000020638', u'ENSMUSG00000091896', u'ENSMUSG00000005575', u'ENSMUSG00000034902', u'ENSMUSG00000035842', u'ENSMUSG00000004085', u'ENSMUSG00000005672', u'ENSMUSG00000073676', u'ENSMUSG00000028527', u'ENSMUSG00000027610', u'ENSMUSG00000067713', u'ENSMUSG00000024843', u'ENSMUSG00000037012', u'ENSMUSG00000001127', u'ENSMUSG00000025357', u'ENSMUSG00000034349', u'ENSMUSG00000027646', u'ENSMUSG00000062949', u'ENSMUSG00000030867', u'ENSMUSG00000059146', u'ENSMUSG00000018900', u'ENSMUSG00000026223', u'ENSMUSG00000035441', u'ENSMUSG00000032316', u'ENSMUSG00000059555', u'ENSMUSG00000007411', u'ENSMUSG00000001416', u'ENSMUSG00000062209', u'ENSMUSG00000033966', u'ENSMUSG00000028312', u'ENSMUSG00000042978', u'ENSMUSG00000029648', u'ENSMUSG00000006273', u'ENSMUSG00000053093', u'ENSMUSG00000014361', u'ENSMUSG00000016757', u'ENSMUSG00000031701', u'ENSMUSG00000091971', u'ENSMUSG00000031314', u'ENSMUSG00000035064', u'ENSMUSG00000052273', u'ENSMUSG00000039197', u'ENSMUSG00000027030', u'ENSMUSG00000004319', u'ENSMUSG00000040136', u'ENSMUSG00000004317', u'ENSMUSG00000069089', u'ENSMUSG00000031360', u'ENSMUSG00000040354', u'ENSMUSG00000026034', u'ENSMUSG00000020122', u'ENSMUSG00000070390', u'ENSMUSG00000038774', u'ENSMUSG00000000738', u'ENSMUSG00000040649', u'ENSMUSG00000035390', u'ENSMUSG00000031387', u'ENSMUSG00000031229', u'ENSMUSG00000042817', u'ENSMUSG00000032788', u'ENSMUSG00000042249', u'ENSMUSG00000031292', u'ENSMUSG00000051220', u'ENSMUSG00000018547', u'ENSMUSG00000029470', u'ENSMUSG00000019235', u'ENSMUSG00000037593', u'ENSMUSG00000004798', u'ENSMUSG00000048120', u'ENSMUSG00000036086', u'ENSMUSG00000017376', u'ENSMUSG00000032462', u'ENSMUSG00000002602', u'ENSMUSG00000026355', u'ENSMUSG00000053158', u'ENSMUSG00000028587', u'ENSMUSG00000032500', u'ENSMUSG00000055540', u'ENSMUSG00000025420', u'ENSMUSG00000025422', u'ENSMUSG00000024030', u'ENSMUSG00000037847', u'ENSMUSG00000025428', u'ENSMUSG00000022329', u'ENSMUSG00000034135', u'ENSMUSG00000063065', u'ENSMUSG00000021108', u'ENSMUSG00000058298', u'ENSMUSG00000071645', u'ENSMUSG00000055471', u'ENSMUSG00000056228', u'ENSMUSG00000027692', u'ENSMUSG00000005580', u'ENSMUSG00000017830', u'ENSMUSG00000020788', u'ENSMUSG00000050890', u'ENSMUSG00000020785', u'ENSMUSG00000041297', u'ENSMUSG00000022451', u'ENSMUSG00000074923', u'ENSMUSG00000055065', u'ENSMUSG00000011254', u'ENSMUSG00000029657', u'ENSMUSG00000053819', u'ENSMUSG00000018800', u'ENSMUSG00000022607', u'ENSMUSG00000039058', u'ENSMUSG00000030815', u'ENSMUSG00000078816', u'ENSMUSG00000028702', u'ENSMUSG00000001630', u'ENSMUSG00000001323', u'ENSMUSG00000027108', u'ENSMUSG00000053907', u'ENSMUSG00000010755', u'ENSMUSG00000022962', u'ENSMUSG00000006728', u'ENSMUSG00000015599', u'ENSMUSG00000027452', u'ENSMUSG00000000605', u'ENSMUSG00000025758', u'ENSMUSG00000025393', u'ENSMUSG00000020334', u'ENSMUSG00000026674', u'ENSMUSG00000019143', u'ENSMUSG00000029777', u'ENSMUSG00000019794', u'ENSMUSG00000061578', u'ENSMUSG00000053334', u'ENSMUSG00000028680', u'ENSMUSG00000029471', u'ENSMUSG00000024952', u'ENSMUSG00000029575', u'ENSMUSG00000025375', u'ENSMUSG00000028518', u'ENSMUSG00000036768', u'ENSMUSG00000005534', u'ENSMUSG00000023944', u'ENSMUSG00000037885', u'ENSMUSG00000005533', u'ENSMUSG00000029482', u'ENSMUSG00000031441', u'ENSMUSG00000024558', u'ENSMUSG00000037112', u'ENSMUSG00000020935', u'ENSMUSG00000028678', u'ENSMUSG00000020527', u'ENSMUSG00000034744', u'ENSMUSG00000000127', u'ENSMUSG00000039630', u'ENSMUSG00000038844', u'ENSMUSG00000027605', u'ENSMUSG00000013629', u'ENSMUSG00000005034', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000075289', u'ENSMUSG00000026775', u'ENSMUSG00000021646', u'ENSMUSG00000027359', u'ENSMUSG00000041827', u'ENSMUSG00000061838', u'ENSMUSG00000046854', u'ENSMUSG00000069631', u'ENSMUSG00000035898', u'ENSMUSG00000029504', u'ENSMUSG00000029505', u'ENSMUSG00000021701', u'ENSMUSG00000003808', u'ENSMUSG00000035891', u'ENSMUSG00000060733', u'ENSMUSG00000026489', u'ENSMUSG00000017999', u'ENSMUSG00000042046', u'ENSMUSG00000057672', u'ENSMUSG00000027709', u'ENSMUSG00000028292', u'ENSMUSG00000028991', u'ENSMUSG00000030515', u'ENSMUSG00000007097', u'ENSMUSG00000020802', u'ENSMUSG00000028452', u'ENSMUSG00000016018', u'ENSMUSG00000035142', u'ENSMUSG00000027770', u'ENSMUSG00000032480', u'ENSMUSG00000026274', u'ENSMUSG00000026277', u'ENSMUSG00000025178', u'ENSMUSG00000063179', u'ENSMUSG00000022791', u'ENSMUSG00000026172', u'ENSMUSG00000024587', u'ENSMUSG00000020608', u'ENSMUSG00000022108', u'ENSMUSG00000027078', u'ENSMUSG00000027079', u'ENSMUSG00000035783', u'ENSMUSG00000002007', u'ENSMUSG00000052889', u'ENSMUSG00000031333', u'ENSMUSG00000020601', u'ENSMUSG00000045983', u'ENSMUSG00000042476', u'ENSMUSG00000024070', u'ENSMUSG00000034575', u'ENSMUSG00000030357', u'ENSMUSG00000021559', u'ENSMUSG00000076441', u'ENSMUSG00000015357', u'ENSMUSG00000024772', u'ENSMUSG00000021266', u'ENSMUSG00000045538', u'ENSMUSG00000029056', u'ENSMUSG00000029053', u'ENSMUSG00000029389', u'ENSMUSG00000032187', u'ENSMUSG00000024921', u'ENSMUSG00000026558', u'ENSMUSG00000004591', u'ENSMUSG00000018166', u'ENSMUSG00000029536', u'ENSMUSG00000021796', u'ENSMUSG00000071369', u'ENSMUSG00000021794', u'ENSMUSG00000021820', u'ENSMUSG00000057963', u'ENSMUSG00000020115', u'ENSMUSG00000004815', u'ENSMUSG00000026393', u'ENSMUSG00000019843', u'ENSMUSG00000063870', u'ENSMUSG00000021413', u'ENSMUSG00000025199', u'ENSMUSG00000048939', u'ENSMUSG00000020277', u'ENSMUSG00000031278', u'ENSMUSG00000041168', u'ENSMUSG00000020273', u'ENSMUSG00000020272', u'ENSMUSG00000038128', u'ENSMUSG00000022792', u'ENSMUSG00000003345', u'ENSMUSG00000021196', u'ENSMUSG00000039936', u'ENSMUSG00000003068', u'ENSMUSG00000074793', u'ENSMUSG00000005958', u'ENSMUSG00000002949', u'ENSMUSG00000002948', u'ENSMUSG00000005951', u'ENSMUSG00000026896', u'ENSMUSG00000021959', u'ENSMUSG00000032557', u'ENSMUSG00000024830', u'ENSMUSG00000021483', u'ENSMUSG00000003810', u'ENSMUSG00000032254', u'ENSMUSG00000003660', u'ENSMUSG00000009907', u'ENSMUSG00000020079', u'ENSMUSG00000033985', u'ENSMUSG00000090112', u'ENSMUSG00000022253', u'ENSMUSG00000029283', u'ENSMUSG00000030409', u'ENSMUSG00000021294', u'ENSMUSG00000022812', u'ENSMUSG00000020075', u'ENSMUSG00000036636', u'ENSMUSG00000020076', u'ENSMUSG00000061436', u'ENSMUSG00000013662', u'ENSMUSG00000031004', u'ENSMUSG00000039159', u'ENSMUSG00000020431', u'ENSMUSG00000029730', u'ENSMUSG00000020437', u'ENSMUSG00000026737', u'ENSMUSG00000057147', u'ENSMUSG00000001380', u'ENSMUSG00000056999', u'ENSMUSG00000003119', u'ENSMUSG00000038685', u'ENSMUSG00000029710', u'ENSMUSG00000030677', u'ENSMUSG00000025209', u'ENSMUSG00000029231', u'ENSMUSG00000022220', u'ENSMUSG00000034187', u'ENSMUSG00000058317', u'ENSMUSG00000037795', u'ENSMUSG00000024576', u'ENSMUSG00000028633', u'ENSMUSG00000024210', u'ENSMUSG00000028630', u'ENSMUSG00000021048', u'ENSMUSG00000031967', u'ENSMUSG00000014158', u'ENSMUSG00000024597', u'ENSMUSG00000021044', u'ENSMUSG00000037989', u'ENSMUSG00000030602', u'ENSMUSG00000039057', u'ENSMUSG00000034154', u'ENSMUSG00000004393', u'ENSMUSG00000051590', u'ENSMUSG00000041498', u'ENSMUSG00000019039', u'ENSMUSG00000024383', u'ENSMUSG00000059883', u'ENSMUSG00000023088', u'ENSMUSG00000041859', u'ENSMUSG00000020990', u'ENSMUSG00000028469', u'ENSMUSG00000052920', u'ENSMUSG00000020857', u'ENSMUSG00000037370', u'ENSMUSG00000028089', u'ENSMUSG00000047986', u'ENSMUSG00000001016', u'ENSMUSG00000028126', u'ENSMUSG00000028125', u'ENSMUSG00000030774', u'ENSMUSG00000042724', u'ENSMUSG00000028944', u'ENSMUSG00000028085', u'ENSMUSG00000041245', u'ENSMUSG00000024858', u'ENSMUSG00000026235', u'ENSMUSG00000021635', u'ENSMUSG00000032959', u'ENSMUSG00000041323', u'ENSMUSG00000075528', u'ENSMUSG00000040620', u'ENSMUSG00000027185', u'ENSMUSG00000030890', u'ENSMUSG00000020721', u'ENSMUSG00000068917', u'ENSMUSG00000041997', u'ENSMUSG00000074576', u'ENSMUSG00000009376', u'ENSMUSG00000074151', u'ENSMUSG00000001403', u'ENSMUSG00000021754', u'ENSMUSG00000024130', u'ENSMUSG00000015016', u'ENSMUSG00000048148', u'ENSMUSG00000027931', u'ENSMUSG00000021457', u'ENSMUSG00000031309', u'ENSMUSG00000052783', u'ENSMUSG00000000530', u'ENSMUSG00000024948', u'ENSMUSG00000018425', u'ENSMUSG00000004788', u'ENSMUSG00000030528', u'ENSMUSG00000026198', u'ENSMUSG00000041650', u'ENSMUSG00000030397', u'ENSMUSG00000026281', u'ENSMUSG00000030802', u'ENSMUSG00000029802', u'ENSMUSG00000039183', u'ENSMUSG00000071203', u'ENSMUSG00000053289', u'ENSMUSG00000066442', u'ENSMUSG00000000339', u'ENSMUSG00000055254', u'ENSMUSG00000035770', u'ENSMUSG00000036273', u'ENSMUSG00000023033', u'ENSMUSG00000020654', u'ENSMUSG00000002763', u'ENSMUSG00000019927', u'ENSMUSG00000032175', u'ENSMUSG00000000308', u'ENSMUSG00000022033', u'ENSMUSG00000014932', u'ENSMUSG00000014426', u'ENSMUSG00000037851', u'ENSMUSG00000030275', u'ENSMUSG00000061751', u'ENSMUSG00000020032', u'ENSMUSG00000031948', u'ENSMUSG00000055923', u'ENSMUSG00000034371', u'ENSMUSG00000022884', u'ENSMUSG00000059602', u'ENSMUSG00000029169', u'ENSMUSG00000022881', u'ENSMUSG00000074886', u'ENSMUSG00000001755', u'ENSMUSG00000044749', u'ENSMUSG00000032285', u'ENSMUSG00000029162', u'ENSMUSG00000023104', u'ENSMUSG00000004233', u'ENSMUSG00000032109', u'ENSMUSG00000030986', u'ENSMUSG00000026463', u'ENSMUSG00000003234', u'ENSMUSG00000029012', u'ENSMUSG00000032101', u'ENSMUSG00000026341', u'ENSMUSG00000053414', u'ENSMUSG00000029016', u'ENSMUSG00000057897', u'ENSMUSG00000004865', u'ENSMUSG00000046947', u'ENSMUSG00000002227', u'ENSMUSG00000024006', u'ENSMUSG00000026207', u'ENSMUSG00000033826', u'ENSMUSG00000021918', u'ENSMUSG00000032294', u'ENSMUSG00000025417', u'ENSMUSG00000041298', u'ENSMUSG00000031537', u'ENSMUSG00000032435', u'ENSMUSG00000038379', u'ENSMUSG00000032594', u'ENSMUSG00000055884', u'ENSMUSG00000031284', u'ENSMUSG00000056394', u'ENSMUSG00000020573', u'ENSMUSG00000024795', u'ENSMUSG00000026864', u'ENSMUSG00000020897', u'ENSMUSG00000022503', u'ENSMUSG00000026117', u'ENSMUSG00000034206', u'ENSMUSG00000026356', u'ENSMUSG00000022617', u'ENSMUSG00000029647', u'ENSMUSG00000031715', u'ENSMUSG00000029869', u'ENSMUSG00000058355', u'ENSMUSG00000022262', u'ENSMUSG00000022263', u'ENSMUSG00000017485', u'ENSMUSG00000020080', u'ENSMUSG00000034674', u'ENSMUSG00000014602', u'ENSMUSG00000025241', u'ENSMUSG00000022952', u'ENSMUSG00000033618', u'ENSMUSG00000039529', u'ENSMUSG00000027115', u'ENSMUSG00000052155', u'ENSMUSG00000006494', u'ENSMUSG00000035051', u'ENSMUSG00000026761', u'ENSMUSG00000029468', u'ENSMUSG00000030978', u'ENSMUSG00000031478', u'ENSMUSG00000046707', u'ENSMUSG00000029467', u'ENSMUSG00000039153', u'ENSMUSG00000089917', u'ENSMUSG00000041939', u'ENSMUSG00000063358', u'ENSMUSG00000024941', u'ENSMUSG00000024943', u'ENSMUSG00000009828', u'ENSMUSG00000042688', u'ENSMUSG00000021420', u'ENSMUSG00000024867', u'ENSMUSG00000029580', u'ENSMUSG00000025060', u'ENSMUSG00000030247', u'ENSMUSG00000025980', u'ENSMUSG00000020390', u'ENSMUSG00000030739', u'ENSMUSG00000036745', u'ENSMUSG00000041415', u'ENSMUSG00000034311', u'ENSMUSG00000025665', u'ENSMUSG00000024892', u'ENSMUSG00000025742', u'ENSMUSG00000021178', u'ENSMUSG00000027207', u'ENSMUSG00000050382', u'ENSMUSG00000029599', u'ENSMUSG00000038302', u'ENSMUSG00000035486', u'ENSMUSG00000024899', u'ENSMUSG00000061462', u'ENSMUSG00000033257', u'ENSMUSG00000027365', u'ENSMUSG00000016308', u'ENSMUSG00000038967']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005525', NS='MF', enrichment='p', name='GTP binding', ratio_in_study=(6, 624), ratio_in_pop=(290, 13836), p_uncorrected=0.043752708573215005, depth=8, study_count=6, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000032344', u'ENSMUSG00000045136', u'ENSMUSG00000046879', u'ENSMUSG00000054072', u'ENSMUSG00000019845', u'ENSMUSG00000000386']), pop_n=13836, pop_count=290, pop_items=set([u'ENSMUSG00000057614', u'ENSMUSG00000021666', u'ENSMUSG00000034226', u'ENSMUSG00000029518', u'ENSMUSG00000030357', u'ENSMUSG00000027293', u'ENSMUSG00000021559', u'ENSMUSG00000021712', u'ENSMUSG00000031104', u'ENSMUSG00000059811', u'ENSMUSG00000020513', u'ENSMUSG00000020459', u'ENSMUSG00000020457', u'ENSMUSG00000029204', u'ENSMUSG00000029208', u'ENSMUSG00000024870', u'ENSMUSG00000043463', u'ENSMUSG00000037820', u'ENSMUSG00000033335', u'ENSMUSG00000033910', u'ENSMUSG00000040009', u'ENSMUSG00000058230', u'ENSMUSG00000027668', u'ENSMUSG00000053291', u'ENSMUSG00000032549', u'ENSMUSG00000022176', u'ENSMUSG00000020386', u'ENSMUSG00000036752', u'ENSMUSG00000021062', u'ENSMUSG00000022075', u'ENSMUSG00000021066', u'ENSMUSG00000043670', u'ENSMUSG00000019478', u'ENSMUSG00000028278', u'ENSMUSG00000020611', u'ENSMUSG00000019845', u'ENSMUSG00000015961', u'ENSMUSG00000020890', u'ENSMUSG00000073079', u'ENSMUSG00000049680', u'ENSMUSG00000048076', u'ENSMUSG00000049892', u'ENSMUSG00000045136', u'ENSMUSG00000074364', u'ENSMUSG00000055723', u'ENSMUSG00000073016', u'ENSMUSG00000034930', u'ENSMUSG00000058013', u'ENSMUSG00000016637', u'ENSMUSG00000045502', u'ENSMUSG00000027523', u'ENSMUSG00000062591', u'ENSMUSG00000041037', u'ENSMUSG00000018340', u'ENSMUSG00000033216', u'ENSMUSG00000029449', u'ENSMUSG00000032553', u'ENSMUSG00000030055', u'ENSMUSG00000042354', u'ENSMUSG00000032565', u'ENSMUSG00000008859', u'ENSMUSG00000047446', u'ENSMUSG00000054364', u'ENSMUSG00000019917', u'ENSMUSG00000024772', u'ENSMUSG00000026426', u'ENSMUSG00000079477', u'ENSMUSG00000023460', u'ENSMUSG00000001473', u'ENSMUSG00000035198', u'ENSMUSG00000022911', u'ENSMUSG00000028270', u'ENSMUSG00000038335', u'ENSMUSG00000000711', u'ENSMUSG00000064120', u'ENSMUSG00000038352', u'ENSMUSG00000064037', u'ENSMUSG00000030222', u'ENSMUSG00000068798', u'ENSMUSG00000028005', u'ENSMUSG00000025035', u'ENSMUSG00000022789', u'ENSMUSG00000052681', u'ENSMUSG00000006699', u'ENSMUSG00000020537', u'ENSMUSG00000028527', u'ENSMUSG00000025730', u'ENSMUSG00000001847', u'ENSMUSG00000024511', u'ENSMUSG00000050379', u'ENSMUSG00000022159', u'ENSMUSG00000032562', u'ENSMUSG00000030105', u'ENSMUSG00000000001', u'ENSMUSG00000042348', u'ENSMUSG00000024143', u'ENSMUSG00000070284', u'ENSMUSG00000026433', u'ENSMUSG00000042535', u'ENSMUSG00000020132', u'ENSMUSG00000033434', u'ENSMUSG00000004771', u'ENSMUSG00000021772', u'ENSMUSG00000073838', u'ENSMUSG00000017686', u'ENSMUSG00000021282', u'ENSMUSG00000051853', u'ENSMUSG00000034994', u'ENSMUSG00000047867', u'ENSMUSG00000045007', u'ENSMUSG00000071723', u'ENSMUSG00000030265', u'ENSMUSG00000028057', u'ENSMUSG00000062203', u'ENSMUSG00000072214', u'ENSMUSG00000058672', u'ENSMUSG00000053870', u'ENSMUSG00000025266', u'ENSMUSG00000028469', u'ENSMUSG00000022538', u'ENSMUSG00000029641', u'ENSMUSG00000070934', u'ENSMUSG00000049866', u'ENSMUSG00000032470', u'ENSMUSG00000016349', u'ENSMUSG00000029388', u'ENSMUSG00000011254', u'ENSMUSG00000028945', u'ENSMUSG00000023004', u'ENSMUSG00000021589', u'ENSMUSG00000022621', u'ENSMUSG00000021877', u'ENSMUSG00000050029', u'ENSMUSG00000041658', u'ENSMUSG00000024759', u'ENSMUSG00000020486', u'ENSMUSG00000034792', u'ENSMUSG00000079657', u'ENSMUSG00000010086', u'ENSMUSG00000015087', u'ENSMUSG00000072235', u'ENSMUSG00000037022', u'ENSMUSG00000051627', u'ENSMUSG00000007815', u'ENSMUSG00000027739', u'ENSMUSG00000000386', u'ENSMUSG00000060904', u'ENSMUSG00000002059', u'ENSMUSG00000026825', u'ENSMUSG00000046768', u'ENSMUSG00000027931', u'ENSMUSG00000029430', u'ENSMUSG00000035133', u'ENSMUSG00000078922', u'ENSMUSG00000040265', u'ENSMUSG00000003037', u'ENSMUSG00000031748', u'ENSMUSG00000028268', u'ENSMUSG00000004788', u'ENSMUSG00000035150', u'ENSMUSG00000073639', u'ENSMUSG00000030138', u'ENSMUSG00000051615', u'ENSMUSG00000030704', u'ENSMUSG00000028869', u'ENSMUSG00000029020', u'ENSMUSG00000036273', u'ENSMUSG00000036894', u'ENSMUSG00000001313', u'ENSMUSG00000047842', u'ENSMUSG00000011148', u'ENSMUSG00000073982', u'ENSMUSG00000021794', u'ENSMUSG00000020657', u'ENSMUSG00000025422', u'ENSMUSG00000026202', u'ENSMUSG00000021149', u'ENSMUSG00000079316', u'ENSMUSG00000034209', u'ENSMUSG00000001525', u'ENSMUSG00000017837', u'ENSMUSG00000077450', u'ENSMUSG00000000149', u'ENSMUSG00000017831', u'ENSMUSG00000027519', u'ENSMUSG00000017144', u'ENSMUSG00000046879', u'ENSMUSG00000028274', u'ENSMUSG00000021068', u'ENSMUSG00000007987', u'ENSMUSG00000022456', u'ENSMUSG00000057455', u'ENSMUSG00000022519', u'ENSMUSG00000056515', u'ENSMUSG00000020832', u'ENSMUSG00000059248', u'ENSMUSG00000032344', u'ENSMUSG00000025499', u'ENSMUSG00000041696', u'ENSMUSG00000024524', u'ENSMUSG00000027108', u'ENSMUSG00000022722', u'ENSMUSG00000034472', u'ENSMUSG00000052688', u'ENSMUSG00000020149', u'ENSMUSG00000037601', u'ENSMUSG00000024639', u'ENSMUSG00000024429', u'ENSMUSG00000038563', u'ENSMUSG00000062421', u'ENSMUSG00000028646', u'ENSMUSG00000019832', u'ENSMUSG00000054855', u'ENSMUSG00000020175', u'ENSMUSG00000025870', u'ENSMUSG00000019066', u'ENSMUSG00000062380', u'ENSMUSG00000030137', u'ENSMUSG00000038084', u'ENSMUSG00000055013', u'ENSMUSG00000031202', u'ENSMUSG00000034781', u'ENSMUSG00000017418', u'ENSMUSG00000023755', u'ENSMUSG00000005534', u'ENSMUSG00000022668', u'ENSMUSG00000034789', u'ENSMUSG00000023944', u'ENSMUSG00000039960', u'ENSMUSG00000018012', u'ENSMUSG00000001833', u'ENSMUSG00000030643', u'ENSMUSG00000043091', u'ENSMUSG00000028443', u'ENSMUSG00000028848', u'ENSMUSG00000022827', u'ENSMUSG00000037742', u'ENSMUSG00000007610', u'ENSMUSG00000019944', u'ENSMUSG00000036943', u'ENSMUSG00000037617', u'ENSMUSG00000038671', u'ENSMUSG00000002233', u'ENSMUSG00000031840', u'ENSMUSG00000040618', u'ENSMUSG00000020088', u'ENSMUSG00000020671', u'ENSMUSG00000018398', u'ENSMUSG00000047187', u'ENSMUSG00000036285', u'ENSMUSG00000029128', u'ENSMUSG00000061838', u'ENSMUSG00000024065', u'ENSMUSG00000028214', u'ENSMUSG00000019173', u'ENSMUSG00000021700', u'ENSMUSG00000029464', u'ENSMUSG00000034936', u'ENSMUSG00000004768', u'ENSMUSG00000021270', u'ENSMUSG00000025733', u'ENSMUSG00000044147', u'ENSMUSG00000026083', u'ENSMUSG00000020684', u'ENSMUSG00000032202', u'ENSMUSG00000024944', u'ENSMUSG00000054072', u'ENSMUSG00000020440', u'ENSMUSG00000024782', u'ENSMUSG00000039018', u'ENSMUSG00000004451', u'ENSMUSG00000023952', u'ENSMUSG00000026878', u'ENSMUSG00000060090', u'ENSMUSG00000027852', u'ENSMUSG00000049907', u'ENSMUSG00000025170', u'ENSMUSG00000033220', u'ENSMUSG00000023353', u'ENSMUSG00000019977', u'ENSMUSG00000040264', u'ENSMUSG00000027774', u'ENSMUSG00000037375', u'ENSMUSG00000015133', u'ENSMUSG00000036093', u'ENSMUSG00000003411', u'ENSMUSG00000020929', u'ENSMUSG00000040464', u'ENSMUSG00000032042', u'ENSMUSG00000079108']), study_n=624, level=5, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005540', NS='MF', enrichment='e', name='hyaluronic acid binding', ratio_in_study=(1, 624), ratio_in_pop=(16, 13836), p_uncorrected=0.5223055970896804, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000020330']), pop_n=13836, pop_count=16, pop_items=set([u'ENSMUSG00000010047', u'ENSMUSG00000021476', u'ENSMUSG00000005087', u'ENSMUSG00000007594', u'ENSMUSG00000021613', u'ENSMUSG00000030607', u'ENSMUSG00000002341', u'ENSMUSG00000042286', u'ENSMUSG00000052353', u'ENSMUSG00000060594', u'ENSMUSG00000004894', u'ENSMUSG00000021614', u'ENSMUSG00000004892', u'ENSMUSG00000053475', u'ENSMUSG00000020330', u'ENSMUSG00000018446']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005542', NS='MF', enrichment='e', name='folic acid binding', ratio_in_study=(2, 624), ratio_in_pop=(9, 13836), p_uncorrected=0.059231393060625616, depth=5, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=0.98547485107011223, study_items=set([u'ENSMUSG00000025747', u'ENSMUSG00000021707']), pop_n=13836, pop_count=9, pop_items=set([u'ENSMUSG00000001827', u'ENSMUSG00000025747', u'ENSMUSG00000066442', u'ENSMUSG00000001436', u'ENSMUSG00000021707', u'ENSMUSG00000021311', u'ENSMUSG00000020829', u'ENSMUSG00000009614', u'ENSMUSG00000032725']), study_n=624, level=3, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005544', NS='MF', enrichment='p', name='calcium-dependent phospholipid binding', ratio_in_study=(1, 624), ratio_in_pop=(33, 13836), p_uncorrected=1.0, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000028860']), pop_n=13836, pop_count=33, pop_items=set([u'ENSMUSG00000063260', u'ENSMUSG00000030279', u'ENSMUSG00000028228', u'ENSMUSG00000056220', u'ENSMUSG00000030731', u'ENSMUSG00000035864', u'ENSMUSG00000052301', u'ENSMUSG00000020848', u'ENSMUSG00000026452', u'ENSMUSG00000029484', u'ENSMUSG00000028860', u'ENSMUSG00000010660', u'ENSMUSG00000027849', u'ENSMUSG00000021866', u'ENSMUSG00000062542', u'ENSMUSG00000024743', u'ENSMUSG00000029994', u'ENSMUSG00000049303', u'ENSMUSG00000058420', u'ENSMUSG00000029608', u'ENSMUSG00000018340', u'ENSMUSG00000032231', u'ENSMUSG00000024261', u'ENSMUSG00000054453', u'ENSMUSG00000027220', u'ENSMUSG00000033788', u'ENSMUSG00000030616', u'ENSMUSG00000027712', u'ENSMUSG00000004961', u'ENSMUSG00000061601', u'ENSMUSG00000021171', u'ENSMUSG00000021814', u'ENSMUSG00000045912']), study_n=624, level=4, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005546', NS='MF', enrichment='p', name='phosphatidylinositol-4,5-bisphosphate binding', ratio_in_study=(1, 624), ratio_in_pop=(53, 13836), p_uncorrected=0.7332505532590337, depth=8, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000041801']), pop_n=13836, pop_count=53, pop_items=set([u'ENSMUSG00000021730', u'ENSMUSG00000028249', u'ENSMUSG00000029518', u'ENSMUSG00000020437', u'ENSMUSG00000041695', u'ENSMUSG00000030731', u'ENSMUSG00000036435', u'ENSMUSG00000035864', u'ENSMUSG00000054423', u'ENSMUSG00000063260', u'ENSMUSG00000050332', u'ENSMUSG00000051355', u'ENSMUSG00000018417', u'ENSMUSG00000027805', u'ENSMUSG00000010660', u'ENSMUSG00000022150', u'ENSMUSG00000050373', u'ENSMUSG00000041685', u'ENSMUSG00000041075', u'ENSMUSG00000024743', u'ENSMUSG00000025812', u'ENSMUSG00000051177', u'ENSMUSG00000000915', u'ENSMUSG00000041801', u'ENSMUSG00000045174', u'ENSMUSG00000039361', u'ENSMUSG00000024104', u'ENSMUSG00000037295', u'ENSMUSG00000020709', u'ENSMUSG00000029608', u'ENSMUSG00000033763', u'ENSMUSG00000053119', u'ENSMUSG00000021986', u'ENSMUSG00000042364', u'ENSMUSG00000022575', u'ENSMUSG00000022451', u'ENSMUSG00000038696', u'ENSMUSG00000042272', u'ENSMUSG00000062542', u'ENSMUSG00000022377', u'ENSMUSG00000032231', u'ENSMUSG00000073988', u'ENSMUSG00000046314', u'ENSMUSG00000023277', u'ENSMUSG00000030616', u'ENSMUSG00000052374', u'ENSMUSG00000004961', u'ENSMUSG00000024897', u'ENSMUSG00000018293', u'ENSMUSG00000026620', u'ENSMUSG00000049176', u'ENSMUSG00000000600', u'ENSMUSG00000032041']), study_n=624, level=7, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005547', NS='MF', enrichment='e', name='phosphatidylinositol-3,4,5-trisphosphate binding', ratio_in_study=(2, 624), ratio_in_pop=(33, 13836), p_uncorrected=0.6598946242390206, depth=7, study_count=2, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000023015', u'ENSMUSG00000041801']), pop_n=13836, pop_count=33, pop_items=set([u'ENSMUSG00000053310', u'ENSMUSG00000037999', u'ENSMUSG00000021730', u'ENSMUSG00000034160', u'ENSMUSG00000024104', u'ENSMUSG00000020437', u'ENSMUSG00000004508', u'ENSMUSG00000018001', u'ENSMUSG00000032812', u'ENSMUSG00000018417', u'ENSMUSG00000026123', u'ENSMUSG00000023015', u'ENSMUSG00000028159', u'ENSMUSG00000042628', u'ENSMUSG00000038844', u'ENSMUSG00000025224', u'ENSMUSG00000001729', u'ENSMUSG00000037712', u'ENSMUSG00000040345', u'ENSMUSG00000025812', u'ENSMUSG00000000915', u'ENSMUSG00000021676', u'ENSMUSG00000057113', u'ENSMUSG00000020709', u'ENSMUSG00000021706', u'ENSMUSG00000030536', u'ENSMUSG00000041801', u'ENSMUSG00000056413', u'ENSMUSG00000038696', u'ENSMUSG00000051355', u'ENSMUSG00000022377', u'ENSMUSG00000024451', u'ENSMUSG00000032737']), study_n=624, level=6, is_obsolete=False, namespace='molecular_function', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005576', NS='CC', enrichment='p', name='extracellular region', ratio_in_study=(22, 624), ratio_in_pop=(746, 13836), p_uncorrected=0.03633924515660338, depth=1, study_count=22, p_sm_bonferroni=1.0, p_fdr_bh=0.79409923032044649, study_items=set([u'ENSMUSG00000070427', u'ENSMUSG00000024486', u'ENSMUSG00000056888', u'ENSMUSG00000027171', u'ENSMUSG00000050063', u'ENSMUSG00000027315', u'ENSMUSG00000026069', u'ENSMUSG00000001131', u'ENSMUSG00000035352', u'ENSMUSG00000020592', u'ENSMUSG00000001123', u'ENSMUSG00000034394', u'ENSMUSG00000054717', u'ENSMUSG00000034855', u'ENSMUSG00000027399', u'ENSMUSG00000034708', u'ENSMUSG00000035692', u'ENSMUSG00000026110', u'ENSMUSG00000031502', u'ENSMUSG00000044906', u'ENSMUSG00000018930', u'ENSMUSG00000022026']), pop_n=13836, pop_count=746, pop_items=set([u'ENSMUSG00000066842', u'ENSMUSG00000048583', u'ENSMUSG00000028029', u'ENSMUSG00000028189', u'ENSMUSG00000008999', u'ENSMUSG00000059327', u'ENSMUSG00000031375', u'ENSMUSG00000004894', u'ENSMUSG00000004897', u'ENSMUSG00000027386', u'ENSMUSG00000030111', u'ENSMUSG00000004892', u'ENSMUSG00000040972', u'ENSMUSG00000070427', u'ENSMUSG00000056174', u'ENSMUSG00000034401', u'ENSMUSG00000008845', u'ENSMUSG00000030849', u'ENSMUSG00000026249', u'ENSMUSG00000068220', u'ENSMUSG00000029371', u'ENSMUSG00000035131', u'ENSMUSG00000031903', u'ENSMUSG00000032334', u'ENSMUSG00000026167', u'ENSMUSG00000042453', u'ENSMUSG00000015647', u'ENSMUSG00000032332', u'ENSMUSG00000023885', u'ENSMUSG00000020614', u'ENSMUSG00000023886', u'ENSMUSG00000019772', u'ENSMUSG00000016995', u'ENSMUSG00000073888', u'ENSMUSG00000046318', u'ENSMUSG00000027947', u'ENSMUSG00000024164', u'ENSMUSG00000028339', u'ENSMUSG00000048482', u'ENSMUSG00000022098', u'ENSMUSG00000036907', u'ENSMUSG00000052911', u'ENSMUSG00000000982', u'ENSMUSG00000052353', u'ENSMUSG00000040152', u'ENSMUSG00000032796', u'ENSMUSG00000068129', u'ENSMUSG00000028871', u'ENSMUSG00000022766', u'ENSMUSG00000003273', u'ENSMUSG00000040794', u'ENSMUSG00000022912', u'ENSMUSG00000036585', u'ENSMUSG00000027400', u'ENSMUSG00000024299', u'ENSMUSG00000027408', u'ENSMUSG00000033207', u'ENSMUSG00000004473', u'ENSMUSG00000029417', u'ENSMUSG00000003617', u'ENSMUSG00000006386', u'ENSMUSG00000002274', u'ENSMUSG00000020044', u'ENSMUSG00000049001', u'ENSMUSG00000006958', u'ENSMUSG00000021136', u'ENSMUSG00000026833', u'ENSMUSG00000026837', u'ENSMUSG00000024909', u'ENSMUSG00000032968', u'ENSMUSG00000029311', u'ENSMUSG00000028657', u'ENSMUSG00000042501', u'ENSMUSG00000021583', u'ENSMUSG00000050079', u'ENSMUSG00000001870', u'ENSMUSG00000025236', u'ENSMUSG00000050074', u'ENSMUSG00000022548', u'ENSMUSG00000036854', u'ENSMUSG00000022865', u'ENSMUSG00000036856', u'ENSMUSG00000024990', u'ENSMUSG00000027248', u'ENSMUSG00000019880', u'ENSMUSG00000041120', u'ENSMUSG00000069170', u'ENSMUSG00000025780', u'ENSMUSG00000038224', u'ENSMUSG00000020713', u'ENSMUSG00000032667', u'ENSMUSG00000059049', u'ENSMUSG00000049313', u'ENSMUSG00000059898', u'ENSMUSG00000068686', u'ENSMUSG00000039109', u'ENSMUSG00000030793', u'ENSMUSG00000023960', u'ENSMUSG00000027834', u'ENSMUSG00000049107', u'ENSMUSG00000037049', u'ENSMUSG00000033684', u'ENSMUSG00000037362', u'ENSMUSG00000036560', u'ENSMUSG00000025650', u'ENSMUSG00000027239', u'ENSMUSG00000034449', u'ENSMUSG00000016356', u'ENSMUSG00000023328', u'ENSMUSG00000026209', u'ENSMUSG00000018927', u'ENSMUSG00000037370', u'ENSMUSG00000031948', u'ENSMUSG00000026200', u'ENSMUSG00000050821', u'ENSMUSG00000028070', u'ENSMUSG00000071866', u'ENSMUSG00000001435', u'ENSMUSG00000028370', u'ENSMUSG00000030530', u'ENSMUSG00000068114', u'ENSMUSG00000006522', u'ENSMUSG00000026185', u'ENSMUSG00000027750', u'ENSMUSG00000079508', u'ENSMUSG00000056737', u'ENSMUSG00000031548', u'ENSMUSG00000026110', u'ENSMUSG00000035000', u'ENSMUSG00000032691', u'ENSMUSG00000026051', u'ENSMUSG00000031838', u'ENSMUSG00000053226', u'ENSMUSG00000008140', u'ENSMUSG00000024392', u'ENSMUSG00000021242', u'ENSMUSG00000022894', u'ENSMUSG00000031750', u'ENSMUSG00000072941', u'ENSMUSG00000022893', u'ENSMUSG00000031610', u'ENSMUSG00000026479', u'ENSMUSG00000026478', u'ENSMUSG00000007594', u'ENSMUSG00000022197', u'ENSMUSG00000046167', u'ENSMUSG00000026579', u'ENSMUSG00000002985', u'ENSMUSG00000001131', u'ENSMUSG00000002980', u'ENSMUSG00000001506', u'ENSMUSG00000032679', u'ENSMUSG00000034394', u'ENSMUSG00000055862', u'ENSMUSG00000031111', u'ENSMUSG00000044229', u'ENSMUSG00000073987', u'ENSMUSG00000063765', u'ENSMUSG00000031119', u'ENSMUSG00000004207', u'ENSMUSG00000033538', u'ENSMUSG00000032840', u'ENSMUSG00000022575', u'ENSMUSG00000002808', u'ENSMUSG00000026879', u'ENSMUSG00000028753', u'ENSMUSG00000051920', u'ENSMUSG00000033880', u'ENSMUSG00000022371', u'ENSMUSG00000034098', u'ENSMUSG00000039883', u'ENSMUSG00000017493', u'ENSMUSG00000029675', u'ENSMUSG00000024713', u'ENSMUSG00000041193', u'ENSMUSG00000039323', u'ENSMUSG00000029759', u'ENSMUSG00000069516', u'ENSMUSG00000036427', u'ENSMUSG00000026656', u'ENSMUSG00000032625', u'ENSMUSG00000051379', u'ENSMUSG00000047368', u'ENSMUSG00000028108', u'ENSMUSG00000043719', u'ENSMUSG00000025352', u'ENSMUSG00000025351', u'ENSMUSG00000015850', u'ENSMUSG00000032289', u'ENSMUSG00000024371', u'ENSMUSG00000001827', u'ENSMUSG00000036334', u'ENSMUSG00000028613', u'ENSMUSG00000027171', u'ENSMUSG00000067578', u'ENSMUSG00000046561', u'ENSMUSG00000034488', u'ENSMUSG00000020953', u'ENSMUSG00000020598', u'ENSMUSG00000024579', u'ENSMUSG00000020592', u'ENSMUSG00000035237', u'ENSMUSG00000002064', u'ENSMUSG00000035279', u'ENSMUSG00000006014', u'ENSMUSG00000041782', u'ENSMUSG00000064023', u'ENSMUSG00000027399', u'ENSMUSG00000037254', u'ENSMUSG00000037818', u'ENSMUSG00000056665', u'ENSMUSG00000024150', u'ENSMUSG00000089661', u'ENSMUSG00000037419', u'ENSMUSG00000050711', u'ENSMUSG00000023272', u'ENSMUSG00000037411', u'ENSMUSG00000045648', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000021613', u'ENSMUSG00000021614', u'ENSMUSG00000038593', u'ENSMUSG00000030659', u'ENSMUSG00000022382', u'ENSMUSG00000028780', u'ENSMUSG00000024053', u'ENSMUSG00000027954', u'ENSMUSG00000041577', u'ENSMUSG00000018446', u'ENSMUSG00000027004', u'ENSMUSG00000042251', u'ENSMUSG00000004366', u'ENSMUSG00000056888', u'ENSMUSG00000046186', u'ENSMUSG00000020130', u'ENSMUSG00000018593', u'ENSMUSG00000022012', u'ENSMUSG00000021806', u'ENSMUSG00000034684', u'ENSMUSG00000020053', u'ENSMUSG00000031399', u'ENSMUSG00000053399', u'ENSMUSG00000061762', u'ENSMUSG00000004415', u'ENSMUSG00000047787', u'ENSMUSG00000017344', u'ENSMUSG00000033307', u'ENSMUSG00000032572', u'ENSMUSG00000021871', u'ENSMUSG00000021876', u'ENSMUSG00000032575', u'ENSMUSG00000021508', u'ENSMUSG00000021974', u'ENSMUSG00000029819', u'ENSMUSG00000039405', u'ENSMUSG00000026921', u'ENSMUSG00000016494', u'ENSMUSG00000035273', u'ENSMUSG00000044177', u'ENSMUSG00000031028', u'ENSMUSG00000041014', u'ENSMUSG00000026840', u'ENSMUSG00000038463', u'ENSMUSG00000057751', u'ENSMUSG00000019122', u'ENSMUSG00000022449', u'ENSMUSG00000005397', u'ENSMUSG00000038543', u'ENSMUSG00000058571', u'ENSMUSG00000029718', u'ENSMUSG00000050069', u'ENSMUSG00000031785', u'ENSMUSG00000021592', u'ENSMUSG00000057722', u'ENSMUSG00000017466', u'ENSMUSG00000050063', u'ENSMUSG00000043631', u'ENSMUSG00000024330', u'ENSMUSG00000034205', u'ENSMUSG00000022971', u'ENSMUSG00000059991', u'ENSMUSG00000050666', u'ENSMUSG00000000632', u'ENSMUSG00000029767', u'ENSMUSG00000033595', u'ENSMUSG00000033453', u'ENSMUSG00000043822', u'ENSMUSG00000091455', u'ENSMUSG00000048920', u'ENSMUSG00000038793', u'ENSMUSG00000045672', u'ENSMUSG00000020834', u'ENSMUSG00000046178', u'ENSMUSG00000004980', u'ENSMUSG00000000686', u'ENSMUSG00000024247', u'ENSMUSG00000027188', u'ENSMUSG00000020902', u'ENSMUSG00000062991', u'ENSMUSG00000040528', u'ENSMUSG00000023236', u'ENSMUSG00000039278', u'ENSMUSG00000027612', u'ENSMUSG00000023336', u'ENSMUSG00000018930', u'ENSMUSG00000029672', u'ENSMUSG00000038233', u'ENSMUSG00000028047', u'ENSMUSG00000028369', u'ENSMUSG00000021732', u'ENSMUSG00000028364', u'ENSMUSG00000028367', u'ENSMUSG00000031994', u'ENSMUSG00000031995', u'ENSMUSG00000035493', u'ENSMUSG00000031990', u'ENSMUSG00000064373', u'ENSMUSG00000040998', u'ENSMUSG00000055409', u'ENSMUSG00000045414', u'ENSMUSG00000024529', u'ENSMUSG00000050447', u'ENSMUSG00000050335', u'ENSMUSG00000028445', u'ENSMUSG00000040690', u'ENSMUSG00000037428', u'ENSMUSG00000031538', u'ENSMUSG00000030824', u'ENSMUSG00000053626', u'ENSMUSG00000026069', u'ENSMUSG00000050967', u'ENSMUSG00000031841', u'ENSMUSG00000022112', u'ENSMUSG00000014813', u'ENSMUSG00000039007', u'ENSMUSG00000039004', u'ENSMUSG00000017009', u'ENSMUSG00000024066', u'ENSMUSG00000042116', u'ENSMUSG00000066113', u'ENSMUSG00000027966', u'ENSMUSG00000020019', u'ENSMUSG00000027965', u'ENSMUSG00000025964', u'ENSMUSG00000016150', u'ENSMUSG00000029999', u'ENSMUSG00000055653', u'ENSMUSG00000031740', u'ENSMUSG00000075478', u'ENSMUSG00000031749', u'ENSMUSG00000022309', u'ENSMUSG00000031196', u'ENSMUSG00000036896', u'ENSMUSG00000068748', u'ENSMUSG00000023046', u'ENSMUSG00000031283', u'ENSMUSG00000032431', u'ENSMUSG00000026365', u'ENSMUSG00000021835', u'ENSMUSG00000032532', u'ENSMUSG00000021939', u'ENSMUSG00000019872', u'ENSMUSG00000021423', u'ENSMUSG00000024413', u'ENSMUSG00000020303', u'ENSMUSG00000031109', u'ENSMUSG00000031266', u'ENSMUSG00000038156', u'ENSMUSG00000028480', u'ENSMUSG00000021186', u'ENSMUSG00000019579', u'ENSMUSG00000059187', u'ENSMUSG00000052613', u'ENSMUSG00000039899', u'ENSMUSG00000039952', u'ENSMUSG00000039953', u'ENSMUSG00000044734', u'ENSMUSG00000021943', u'ENSMUSG00000029661', u'ENSMUSG00000029161', u'ENSMUSG00000064293', u'ENSMUSG00000046618', u'ENSMUSG00000076617', u'ENSMUSG00000047084', u'ENSMUSG00000079465', u'ENSMUSG00000027792', u'ENSMUSG00000025854', u'ENSMUSG00000037499', u'ENSMUSG00000040254', u'ENSMUSG00000039239', u'ENSMUSG00000020427', u'ENSMUSG00000000489', u'ENSMUSG00000063297', u'ENSMUSG00000029335', u'ENSMUSG00000029337', u'ENSMUSG00000015829', u'ENSMUSG00000024962', u'ENSMUSG00000036545', u'ENSMUSG00000033061', u'ENSMUSG00000000278', u'ENSMUSG00000044906', u'ENSMUSG00000022483', u'ENSMUSG00000028749', u'ENSMUSG00000079003', u'ENSMUSG00000028626', u'ENSMUSG00000045532', u'ENSMUSG00000022847', u'ENSMUSG00000004105', u'ENSMUSG00000052504', u'ENSMUSG00000038323', u'ENSMUSG00000029436', u'ENSMUSG00000033467', u'ENSMUSG00000074264', u'ENSMUSG00000072770', u'ENSMUSG00000047632', u'ENSMUSG00000036887', u'ENSMUSG00000028550', u'ENSMUSG00000028413', u'ENSMUSG00000061808', u'ENSMUSG00000040488', u'ENSMUSG00000068196', u'ENSMUSG00000052593', u'ENSMUSG00000024517', u'ENSMUSG00000070564', u'ENSMUSG00000037010', u'ENSMUSG00000035521', u'ENSMUSG00000053846', u'ENSMUSG00000027315', u'ENSMUSG00000030048', u'ENSMUSG00000045731', u'ENSMUSG00000027316', u'ENSMUSG00000039217', u'ENSMUSG00000016024', u'ENSMUSG00000030862', u'ENSMUSG00000031963', u'ENSMUSG00000000392', u'ENSMUSG00000032640', u'ENSMUSG00000027082', u'ENSMUSG00000026141', u'ENSMUSG00000064080', u'ENSMUSG00000067242', u'ENSMUSG00000021466', u'ENSMUSG00000036446', u'ENSMUSG00000072115', u'ENSMUSG00000064325', u'ENSMUSG00000002289', u'ENSMUSG00000064246', u'ENSMUSG00000004791', u'ENSMUSG00000041926', u'ENSMUSG00000022982', u'ENSMUSG00000021236', u'ENSMUSG00000007891', u'ENSMUSG00000042401', u'ENSMUSG00000040138', u'ENSMUSG00000041959', u'ENSMUSG00000017754', u'ENSMUSG00000032006', u'ENSMUSG00000023992', u'ENSMUSG00000048126', u'ENSMUSG00000022025', u'ENSMUSG00000022026', u'ENSMUSG00000060373', u'ENSMUSG00000031380', u'ENSMUSG00000034164', u'ENSMUSG00000030317', u'ENSMUSG00000032036', u'ENSMUSG00000037843', u'ENSMUSG00000019899', u'ENSMUSG00000032179', u'ENSMUSG00000029096', u'ENSMUSG00000033361', u'ENSMUSG00000021994', u'ENSMUSG00000015568', u'ENSMUSG00000036169', u'ENSMUSG00000047793', u'ENSMUSG00000002603', u'ENSMUSG00000032504', u'ENSMUSG00000021904', u'ENSMUSG00000024425', u'ENSMUSG00000047414', u'ENSMUSG00000031703', u'ENSMUSG00000021900', u'ENSMUSG00000015090', u'ENSMUSG00000001521', u'ENSMUSG00000021792', u'ENSMUSG00000056222', u'ENSMUSG00000031137', u'ENSMUSG00000058297', u'ENSMUSG00000022514', u'ENSMUSG00000020467', u'ENSMUSG00000048616', u'ENSMUSG00000023206', u'ENSMUSG00000022454', u'ENSMUSG00000028776', u'ENSMUSG00000038552', u'ENSMUSG00000024084', u'ENSMUSG00000029657', u'ENSMUSG00000025889', u'ENSMUSG00000025888', u'ENSMUSG00000025551', u'ENSMUSG00000036968', u'ENSMUSG00000033208', u'ENSMUSG00000036264', u'ENSMUSG00000060147', u'ENSMUSG00000050786', u'ENSMUSG00000058897', u'ENSMUSG00000021390', u'ENSMUSG00000022801', u'ENSMUSG00000040264', u'ENSMUSG00000026676', u'ENSMUSG00000029777', u'ENSMUSG00000038521', u'ENSMUSG00000001930', u'ENSMUSG00000006205', u'ENSMUSG00000024810', u'ENSMUSG00000023944', u'ENSMUSG00000010051', u'ENSMUSG00000001741', u'ENSMUSG00000024256', u'ENSMUSG00000000693', u'ENSMUSG00000025776', u'ENSMUSG00000001025', u'ENSMUSG00000000126', u'ENSMUSG00000023224', u'ENSMUSG00000074766', u'ENSMUSG00000027350', u'ENSMUSG00000013150', u'ENSMUSG00000027358', u'ENSMUSG00000004031', u'ENSMUSG00000038677', u'ENSMUSG00000028197', u'ENSMUSG00000028195', u'ENSMUSG00000049580', u'ENSMUSG00000021702', u'ENSMUSG00000033739', u'ENSMUSG00000016493', u'ENSMUSG00000025104', u'ENSMUSG00000031451', u'ENSMUSG00000031980', u'ENSMUSG00000041559', u'ENSMUSG00000075012', u'ENSMUSG00000049971', u'ENSMUSG00000027999', u'ENSMUSG00000041445', u'ENSMUSG00000049538', u'ENSMUSG00000055485', u'ENSMUSG00000027859', u'ENSMUSG00000022108', u'ENSMUSG00000026072', u'ENSMUSG00000024074', u'ENSMUSG00000024076', u'ENSMUSG00000063531', u'ENSMUSG00000027978', u'ENSMUSG00000015354', u'ENSMUSG00000025856', u'ENSMUSG00000023571', u'ENSMUSG00000026958', u'ENSMUSG00000021260', u'ENSMUSG00000056999', u'ENSMUSG00000021340', u'ENSMUSG00000019997', u'ENSMUSG00000021342', u'ENSMUSG00000031778', u'ENSMUSG00000030218', u'ENSMUSG00000029797', u'ENSMUSG00000022179', u'ENSMUSG00000026553', u'ENSMUSG00000061353', u'ENSMUSG00000023078', u'ENSMUSG00000038742', u'ENSMUSG00000036040', u'ENSMUSG00000019966', u'ENSMUSG00000001119', u'ENSMUSG00000021822', u'ENSMUSG00000057969', u'ENSMUSG00000019846', u'ENSMUSG00000042826', u'ENSMUSG00000010797', u'ENSMUSG00000013846', u'ENSMUSG00000062753', u'ENSMUSG00000064138', u'ENSMUSG00000021194', u'ENSMUSG00000003346', u'ENSMUSG00000048834', u'ENSMUSG00000022797', u'ENSMUSG00000017446', u'ENSMUSG00000038173', u'ENSMUSG00000040713', u'ENSMUSG00000033327', u'ENSMUSG00000002032', u'ENSMUSG00000032554', u'ENSMUSG00000029838', u'ENSMUSG00000014599', u'ENSMUSG00000029119', u'ENSMUSG00000029287', u'ENSMUSG00000032181', u'ENSMUSG00000025512', u'ENSMUSG00000054162', u'ENSMUSG00000020674', u'ENSMUSG00000020077', u'ENSMUSG00000039208', u'ENSMUSG00000039252', u'ENSMUSG00000021681', u'ENSMUSG00000021680', u'ENSMUSG00000020432', u'ENSMUSG00000029304', u'ENSMUSG00000022425', u'ENSMUSG00000029307', u'ENSMUSG00000036412', u'ENSMUSG00000028643', u'ENSMUSG00000028641', u'ENSMUSG00000073418', u'ENSMUSG00000029309', u'ENSMUSG00000019890', u'ENSMUSG00000036256', u'ENSMUSG00000028885', u'ENSMUSG00000028639', u'ENSMUSG00000066551', u'ENSMUSG00000022491', u'ENSMUSG00000030605', u'ENSMUSG00000034220', u'ENSMUSG00000033491', u'ENSMUSG00000050088', u'ENSMUSG00000024598', u'ENSMUSG00000034730', u'ENSMUSG00000054263', u'ENSMUSG00000035352', u'ENSMUSG00000027523', u'ENSMUSG00000036905', u'ENSMUSG00000027524', u'ENSMUSG00000021044', u'ENSMUSG00000030342', u'ENSMUSG00000032135', u'ENSMUSG00000054863', u'ENSMUSG00000023913', u'ENSMUSG00000025020', u'ENSMUSG00000009281', u'ENSMUSG00000037568', u'ENSMUSG00000031558', u'ENSMUSG00000034855', u'ENSMUSG00000028019', u'ENSMUSG00000030772', u'ENSMUSG00000045994', u'ENSMUSG00000001016', u'ENSMUSG00000035692', u'ENSMUSG00000058135', u'ENSMUSG00000027322', u'ENSMUSG00000030077', u'ENSMUSG00000000420', u'ENSMUSG00000058488', u'ENSMUSG00000024778', u'ENSMUSG00000050830', u'ENSMUSG00000030093', u'ENSMUSG00000042961', u'ENSMUSG00000028300', u'ENSMUSG00000006369', u'ENSMUSG00000046719', u'ENSMUSG00000024136', u'ENSMUSG00000037206', u'ENSMUSG00000042312', u'ENSMUSG00000026193', u'ENSMUSG00000021223', u'ENSMUSG00000045573', u'ENSMUSG00000028971', u'ENSMUSG00000031825', u'ENSMUSG00000028249', u'ENSMUSG00000026697', u'ENSMUSG00000007888', u'ENSMUSG00000013367', u'ENSMUSG00000023031', u'ENSMUSG00000022324', u'ENSMUSG00000026042', u'ENSMUSG00000026043', u'ENSMUSG00000019929', u'ENSMUSG00000032178', u'ENSMUSG00000022037', u'ENSMUSG00000032172', u'ENSMUSG00000060548', u'ENSMUSG00000037852', u'ENSMUSG00000055737', u'ENSMUSG00000021253', u'ENSMUSG00000024421', u'ENSMUSG00000021256', u'ENSMUSG00000006403', u'ENSMUSG00000022887', u'ENSMUSG00000070858', u'ENSMUSG00000022885', u'ENSMUSG00000051335', u'ENSMUSG00000021091', u'ENSMUSG00000021319', u'ENSMUSG00000054717', u'ENSMUSG00000002900', u'ENSMUSG00000015451', u'ENSMUSG00000029163', u'ENSMUSG00000056427', u'ENSMUSG00000074971', u'ENSMUSG00000016763', u'ENSMUSG00000060802', u'ENSMUSG00000051439', u'ENSMUSG00000026344', u'ENSMUSG00000002341', u'ENSMUSG00000051007', u'ENSMUSG00000035385', u'ENSMUSG00000019810', u'ENSMUSG00000001123', u'ENSMUSG00000010277', u'ENSMUSG00000001128', u'ENSMUSG00000044258', u'ENSMUSG00000020241', u'ENSMUSG00000020572', u'ENSMUSG00000044626', u'ENSMUSG00000020473', u'ENSMUSG00000022665', u'ENSMUSG00000028763', u'ENSMUSG00000057778', u'ENSMUSG00000005968', u'ENSMUSG00000049630', u'ENSMUSG00000024098', u'ENSMUSG00000024486', u'ENSMUSG00000029869', u'ENSMUSG00000024725', u'ENSMUSG00000024647', u'ENSMUSG00000001334', u'ENSMUSG00000000753', u'ENSMUSG00000000202', u'ENSMUSG00000022816', u'ENSMUSG00000027447', u'ENSMUSG00000032925', u'ENSMUSG00000021830', u'ENSMUSG00000067158', u'ENSMUSG00000024940', u'ENSMUSG00000030748', u'ENSMUSG00000028883', u'ENSMUSG00000020681', u'ENSMUSG00000037035', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000034708', u'ENSMUSG00000028600', u'ENSMUSG00000022468', u'ENSMUSG00000020399', u'ENSMUSG00000030607', u'ENSMUSG00000027204', u'ENSMUSG00000061462', u'ENSMUSG00000032231']), study_n=624, level=1, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005578', NS='CC', enrichment='p', name='proteinaceous extracellular matrix', ratio_in_study=(4, 624), ratio_in_pop=(207, 13836), p_uncorrected=0.08818567409829031, depth=3, study_count=4, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000047730', u'ENSMUSG00000001131', u'ENSMUSG00000031502', u'ENSMUSG00000026069']), pop_n=13836, pop_count=207, pop_items=set([u'ENSMUSG00000066842', u'ENSMUSG00000045083', u'ENSMUSG00000024076', u'ENSMUSG00000038156', u'ENSMUSG00000045322', u'ENSMUSG00000046618', u'ENSMUSG00000075224', u'ENSMUSG00000034220', u'ENSMUSG00000021186', u'ENSMUSG00000004894', u'ENSMUSG00000027386', u'ENSMUSG00000051067', u'ENSMUSG00000004892', u'ENSMUSG00000021340', u'ENSMUSG00000019997', u'ENSMUSG00000040488', u'ENSMUSG00000015850', u'ENSMUSG00000042401', u'ENSMUSG00000056174', u'ENSMUSG00000030022', u'ENSMUSG00000035273', u'ENSMUSG00000049612', u'ENSMUSG00000068220', u'ENSMUSG00000029661', u'ENSMUSG00000032334', u'ENSMUSG00000026167', u'ENSMUSG00000036040', u'ENSMUSG00000042453', u'ENSMUSG00000020953', u'ENSMUSG00000001119', u'ENSMUSG00000032332', u'ENSMUSG00000023885', u'ENSMUSG00000023886', u'ENSMUSG00000079465', u'ENSMUSG00000019846', u'ENSMUSG00000046318', u'ENSMUSG00000010797', u'ENSMUSG00000033207', u'ENSMUSG00000028339', u'ENSMUSG00000041782', u'ENSMUSG00000040490', u'ENSMUSG00000022098', u'ENSMUSG00000015829', u'ENSMUSG00000052911', u'ENSMUSG00000036545', u'ENSMUSG00000022112', u'ENSMUSG00000033327', u'ENSMUSG00000029838', u'ENSMUSG00000028108', u'ENSMUSG00000022483', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000028626', u'ENSMUSG00000021613', u'ENSMUSG00000029287', u'ENSMUSG00000021614', u'ENSMUSG00000034648', u'ENSMUSG00000015659', u'ENSMUSG00000054162', u'ENSMUSG00000043822', u'ENSMUSG00000031548', u'ENSMUSG00000029436', u'ENSMUSG00000022382', u'ENSMUSG00000042116', u'ENSMUSG00000026193', u'ENSMUSG00000024053', u'ENSMUSG00000032796', u'ENSMUSG00000029307', u'ENSMUSG00000041577', u'ENSMUSG00000028641', u'ENSMUSG00000029309', u'ENSMUSG00000030607', u'ENSMUSG00000031375', u'ENSMUSG00000030600', u'ENSMUSG00000024598', u'ENSMUSG00000018593', u'ENSMUSG00000020044', u'ENSMUSG00000021806', u'ENSMUSG00000049001', u'ENSMUSG00000052512', u'ENSMUSG00000026141', u'ENSMUSG00000064080', u'ENSMUSG00000021136', u'ENSMUSG00000036446', u'ENSMUSG00000026837', u'ENSMUSG00000002289', u'ENSMUSG00000004415', u'ENSMUSG00000026443', u'ENSMUSG00000017344', u'ENSMUSG00000031740', u'ENSMUSG00000001870', u'ENSMUSG00000032572', u'ENSMUSG00000030077', u'ENSMUSG00000063765', u'ENSMUSG00000036856', u'ENSMUSG00000031825', u'ENSMUSG00000024909', u'ENSMUSG00000041559', u'ENSMUSG00000022025', u'ENSMUSG00000050830', u'ENSMUSG00000030093', u'ENSMUSG00000034164', u'ENSMUSG00000068196', u'ENSMUSG00000059049', u'ENSMUSG00000030317', u'ENSMUSG00000006369', u'ENSMUSG00000026840', u'ENSMUSG00000049556', u'ENSMUSG00000038463', u'ENSMUSG00000019899', u'ENSMUSG00000048126', u'ENSMUSG00000022449', u'ENSMUSG00000021994', u'ENSMUSG00000005397', u'ENSMUSG00000058571', u'ENSMUSG00000037362', u'ENSMUSG00000025650', u'ENSMUSG00000053399', u'ENSMUSG00000002603', u'ENSMUSG00000042961', u'ENSMUSG00000035258', u'ENSMUSG00000026697', u'ENSMUSG00000043631', u'ENSMUSG00000024330', u'ENSMUSG00000034205', u'ENSMUSG00000022324', u'ENSMUSG00000026042', u'ENSMUSG00000026043', u'ENSMUSG00000019929', u'ENSMUSG00000024421', u'ENSMUSG00000047414', u'ENSMUSG00000068748', u'ENSMUSG00000015647', u'ENSMUSG00000042501', u'ENSMUSG00000056222', u'ENSMUSG00000033453', u'ENSMUSG00000021253', u'ENSMUSG00000066113', u'ENSMUSG00000001435', u'ENSMUSG00000006403', u'ENSMUSG00000020467', u'ENSMUSG00000047730', u'ENSMUSG00000045672', u'ENSMUSG00000031119', u'ENSMUSG00000002900', u'ENSMUSG00000029163', u'ENSMUSG00000045045', u'ENSMUSG00000027750', u'ENSMUSG00000024529', u'ENSMUSG00000002341', u'ENSMUSG00000020902', u'ENSMUSG00000027612', u'ENSMUSG00000021390', u'ENSMUSG00000036295', u'ENSMUSG00000037820', u'ENSMUSG00000020241', u'ENSMUSG00000028364', u'ENSMUSG00000001930', u'ENSMUSG00000031994', u'ENSMUSG00000022894', u'ENSMUSG00000035493', u'ENSMUSG00000022893', u'ENSMUSG00000022665', u'ENSMUSG00000040998', u'ENSMUSG00000028763', u'ENSMUSG00000046167', u'ENSMUSG00000028766', u'ENSMUSG00000027195', u'ENSMUSG00000026478', u'ENSMUSG00000050335', u'ENSMUSG00000007594', u'ENSMUSG00000040690', u'ENSMUSG00000032231', u'ENSMUSG00000043719', u'ENSMUSG00000000126', u'ENSMUSG00000032289', u'ENSMUSG00000026069', u'ENSMUSG00000001131', u'ENSMUSG00000036585', u'ENSMUSG00000058297', u'ENSMUSG00000013150', u'ENSMUSG00000001506', u'ENSMUSG00000020674', u'ENSMUSG00000044024', u'ENSMUSG00000027966', u'ENSMUSG00000028197', u'ENSMUSG00000020019', u'ENSMUSG00000028195', u'ENSMUSG00000021702', u'ENSMUSG00000026479', u'ENSMUSG00000055653', u'ENSMUSG00000067158', u'ENSMUSG00000024940', u'ENSMUSG00000029345', u'ENSMUSG00000049538', u'ENSMUSG00000003316', u'ENSMUSG00000033880', u'ENSMUSG00000022371', u'ENSMUSG00000028600', u'ENSMUSG00000041445', u'ENSMUSG00000029675', u'ENSMUSG00000032431', u'ENSMUSG00000035653', u'ENSMUSG00000024299', u'ENSMUSG00000021835', u'ENSMUSG00000036957', u'ENSMUSG00000027204']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005581', NS='CC', enrichment='p', name='collagen trimer', ratio_in_study=(1, 624), ratio_in_pop=(50, 13836), p_uncorrected=0.7276382812681743, depth=3, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000031502']), pop_n=13836, pop_count=50, pop_items=set([u'ENSMUSG00000034164', u'ENSMUSG00000048126', u'ENSMUSG00000056174', u'ENSMUSG00000020241', u'ENSMUSG00000024053', u'ENSMUSG00000059327', u'ENSMUSG00000045672', u'ENSMUSG00000045532', u'ENSMUSG00000029661', u'ENSMUSG00000036887', u'ENSMUSG00000046167', u'ENSMUSG00000025650', u'ENSMUSG00000040690', u'ENSMUSG00000024330', u'ENSMUSG00000016356', u'ENSMUSG00000068196', u'ENSMUSG00000026042', u'ENSMUSG00000026043', u'ENSMUSG00000001119', u'ENSMUSG00000032332', u'ENSMUSG00000024400', u'ENSMUSG00000034463', u'ENSMUSG00000001506', u'ENSMUSG00000036905', u'ENSMUSG00000079465', u'ENSMUSG00000026141', u'ENSMUSG00000036103', u'ENSMUSG00000027966', u'ENSMUSG00000028197', u'ENSMUSG00000028339', u'ENSMUSG00000026837', u'ENSMUSG00000001435', u'ENSMUSG00000067158', u'ENSMUSG00000063564', u'ENSMUSG00000004415', u'ENSMUSG00000036907', u'ENSMUSG00000017446', u'ENSMUSG00000036896', u'ENSMUSG00000029163', u'ENSMUSG00000046318', u'ENSMUSG00000024529', u'ENSMUSG00000058897', u'ENSMUSG00000022371', u'ENSMUSG00000022483', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000028626', u'ENSMUSG00000043719', u'ENSMUSG00000032572', u'ENSMUSG00000049630']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005587', NS='CC', enrichment='e', name='collagen type IV trimer', ratio_in_study=(1, 624), ratio_in_pop=(6, 13836), p_uncorrected=0.24190116929841396, depth=5, study_count=1, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000031502']), pop_n=13836, pop_count=6, pop_items=set([u'ENSMUSG00000031273', u'ENSMUSG00000031274', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000067158', u'ENSMUSG00000079465']), study_n=624, level=4, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005604', NS='CC', enrichment='p', name='basement membrane', ratio_in_study=(3, 624), ratio_in_pop=(85, 13836), p_uncorrected=1.0, depth=3, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000024974', u'ENSMUSG00000001131', u'ENSMUSG00000031502']), pop_n=13836, pop_count=85, pop_items=set([u'ENSMUSG00000066842', u'ENSMUSG00000050830', u'ENSMUSG00000068196', u'ENSMUSG00000056174', u'ENSMUSG00000042961', u'ENSMUSG00000027111', u'ENSMUSG00000028364', u'ENSMUSG00000026193', u'ENSMUSG00000006369', u'ENSMUSG00000026840', u'ENSMUSG00000026479', u'ENSMUSG00000024974', u'ENSMUSG00000019899', u'ENSMUSG00000031012', u'ENSMUSG00000022893', u'ENSMUSG00000022665', u'ENSMUSG00000040998', u'ENSMUSG00000005397', u'ENSMUSG00000028641', u'ENSMUSG00000021223', u'ENSMUSG00000028763', u'ENSMUSG00000042116', u'ENSMUSG00000031274', u'ENSMUSG00000032796', u'ENSMUSG00000025650', u'ENSMUSG00000026478', u'ENSMUSG00000032518', u'ENSMUSG00000017466', u'ENSMUSG00000030607', u'ENSMUSG00000034687', u'ENSMUSG00000041936', u'ENSMUSG00000032334', u'ENSMUSG00000034205', u'ENSMUSG00000022324', u'ENSMUSG00000001131', u'ENSMUSG00000015647', u'ENSMUSG00000018593', u'ENSMUSG00000024421', u'ENSMUSG00000020044', u'ENSMUSG00000021806', u'ENSMUSG00000023886', u'ENSMUSG00000020758', u'ENSMUSG00000025809', u'ENSMUSG00000019846', u'ENSMUSG00000044024', u'ENSMUSG00000021136', u'ENSMUSG00000031273', u'ENSMUSG00000028339', u'ENSMUSG00000022952', u'ENSMUSG00000020019', u'ENSMUSG00000037016', u'ENSMUSG00000039239', u'ENSMUSG00000021702', u'ENSMUSG00000027204', u'ENSMUSG00000026837', u'ENSMUSG00000001435', u'ENSMUSG00000032554', u'ENSMUSG00000041782', u'ENSMUSG00000020467', u'ENSMUSG00000025068', u'ENSMUSG00000000753', u'ENSMUSG00000052911', u'ENSMUSG00000067158', u'ENSMUSG00000002900', u'ENSMUSG00000023951', u'ENSMUSG00000032231', u'ENSMUSG00000027447', u'ENSMUSG00000039952', u'ENSMUSG00000023885', u'ENSMUSG00000017344', u'ENSMUSG00000029838', u'ENSMUSG00000041445', u'ENSMUSG00000022483', u'ENSMUSG00000020902', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000079465', u'ENSMUSG00000059049', u'ENSMUSG00000038168', u'ENSMUSG00000025510', u'ENSMUSG00000021974', u'ENSMUSG00000039270', u'ENSMUSG00000031954', u'ENSMUSG00000035493', u'ENSMUSG00000048915']), study_n=624, level=3, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005615', NS='CC', enrichment='p', name='extracellular space', ratio_in_study=(32, 624), ratio_in_pop=(729, 13836), p_uncorrected=0.9999999999981817, depth=2, study_count=32, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000032661', u'ENSMUSG00000070427', u'ENSMUSG00000036928', u'ENSMUSG00000020841', u'ENSMUSG00000062727', u'ENSMUSG00000037405', u'ENSMUSG00000024486', u'ENSMUSG00000026069', u'ENSMUSG00000032113', u'ENSMUSG00000027315', u'ENSMUSG00000030786', u'ENSMUSG00000001131', u'ENSMUSG00000035352', u'ENSMUSG00000025089', u'ENSMUSG00000034394', u'ENSMUSG00000054717', u'ENSMUSG00000028233', u'ENSMUSG00000034855', u'ENSMUSG00000027399', u'ENSMUSG00000029580', u'ENSMUSG00000034708', u'ENSMUSG00000025534', u'ENSMUSG00000036097', u'ENSMUSG00000047246', u'ENSMUSG00000031502', u'ENSMUSG00000002227', u'ENSMUSG00000021811', u'ENSMUSG00000018930', u'ENSMUSG00000050063', u'ENSMUSG00000022026', u'ENSMUSG00000069268']), pop_n=13836, pop_count=729, pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000028029', u'ENSMUSG00000028189', u'ENSMUSG00000030342', u'ENSMUSG00000008999', u'ENSMUSG00000031375', u'ENSMUSG00000024740', u'ENSMUSG00000004897', u'ENSMUSG00000030111', u'ENSMUSG00000004892', u'ENSMUSG00000070427', u'ENSMUSG00000042050', u'ENSMUSG00000030560', u'ENSMUSG00000030022', u'ENSMUSG00000026249', u'ENSMUSG00000005054', u'ENSMUSG00000060126', u'ENSMUSG00000029371', u'ENSMUSG00000031903', u'ENSMUSG00000032334', u'ENSMUSG00000026167', u'ENSMUSG00000042453', u'ENSMUSG00000015647', u'ENSMUSG00000032332', u'ENSMUSG00000023885', u'ENSMUSG00000020614', u'ENSMUSG00000027947', u'ENSMUSG00000040888', u'ENSMUSG00000024164', u'ENSMUSG00000028233', u'ENSMUSG00000028339', u'ENSMUSG00000074818', u'ENSMUSG00000040490', u'ENSMUSG00000022098', u'ENSMUSG00000051379', u'ENSMUSG00000018102', u'ENSMUSG00000052911', u'ENSMUSG00000000982', u'ENSMUSG00000042354', u'ENSMUSG00000040152', u'ENSMUSG00000045827', u'ENSMUSG00000032796', u'ENSMUSG00000068129', u'ENSMUSG00000033948', u'ENSMUSG00000020105', u'ENSMUSG00000036030', u'ENSMUSG00000021811', u'ENSMUSG00000026385', u'ENSMUSG00000036131', u'ENSMUSG00000022912', u'ENSMUSG00000055172', u'ENSMUSG00000050069', u'ENSMUSG00000027408', u'ENSMUSG00000015461', u'ENSMUSG00000022620', u'ENSMUSG00000026335', u'ENSMUSG00000004473', u'ENSMUSG00000003617', u'ENSMUSG00000079641', u'ENSMUSG00000002274', u'ENSMUSG00000049775', u'ENSMUSG00000020044', u'ENSMUSG00000061762', u'ENSMUSG00000006958', u'ENSMUSG00000068874', u'ENSMUSG00000059883', u'ENSMUSG00000037405', u'ENSMUSG00000026833', u'ENSMUSG00000026837', u'ENSMUSG00000057604', u'ENSMUSG00000024909', u'ENSMUSG00000003123', u'ENSMUSG00000032968', u'ENSMUSG00000028657', u'ENSMUSG00000028656', u'ENSMUSG00000022231', u'ENSMUSG00000022546', u'ENSMUSG00000021587', u'ENSMUSG00000001870', u'ENSMUSG00000028015', u'ENSMUSG00000050074', u'ENSMUSG00000022548', u'ENSMUSG00000022865', u'ENSMUSG00000036856', u'ENSMUSG00000032050', u'ENSMUSG00000024990', u'ENSMUSG00000027248', u'ENSMUSG00000041120', u'ENSMUSG00000075012', u'ENSMUSG00000000627', u'ENSMUSG00000032661', u'ENSMUSG00000020713', u'ENSMUSG00000049313', u'ENSMUSG00000020717', u'ENSMUSG00000068686', u'ENSMUSG00000039062', u'ENSMUSG00000032743', u'ENSMUSG00000059040', u'ENSMUSG00000060147', u'ENSMUSG00000027834', u'ENSMUSG00000037049', u'ENSMUSG00000033684', u'ENSMUSG00000037362', u'ENSMUSG00000036560', u'ENSMUSG00000025650', u'ENSMUSG00000030064', u'ENSMUSG00000023328', u'ENSMUSG00000074743', u'ENSMUSG00000018927', u'ENSMUSG00000018920', u'ENSMUSG00000037370', u'ENSMUSG00000031948', u'ENSMUSG00000026200', u'ENSMUSG00000028070', u'ENSMUSG00000071866', u'ENSMUSG00000045624', u'ENSMUSG00000048482', u'ENSMUSG00000001435', u'ENSMUSG00000028370', u'ENSMUSG00000030539', u'ENSMUSG00000045045', u'ENSMUSG00000027750', u'ENSMUSG00000056737', u'ENSMUSG00000031548', u'ENSMUSG00000026051', u'ENSMUSG00000003534', u'ENSMUSG00000053226', u'ENSMUSG00000037926', u'ENSMUSG00000036295', u'ENSMUSG00000020000', u'ENSMUSG00000090100', u'ENSMUSG00000021242', u'ENSMUSG00000062070', u'ENSMUSG00000022894', u'ENSMUSG00000031750', u'ENSMUSG00000022892', u'ENSMUSG00000031613', u'ENSMUSG00000026479', u'ENSMUSG00000026478', u'ENSMUSG00000032113', u'ENSMUSG00000026579', u'ENSMUSG00000002985', u'ENSMUSG00000001131', u'ENSMUSG00000036585', u'ENSMUSG00000001506', u'ENSMUSG00000034394', u'ENSMUSG00000031207', u'ENSMUSG00000056201', u'ENSMUSG00000031119', u'ENSMUSG00000024924', u'ENSMUSG00000022575', u'ENSMUSG00000002808', u'ENSMUSG00000026879', u'ENSMUSG00000039405', u'ENSMUSG00000033880', u'ENSMUSG00000022371', u'ENSMUSG00000073987', u'ENSMUSG00000039883', u'ENSMUSG00000017493', u'ENSMUSG00000047502', u'ENSMUSG00000024713', u'ENSMUSG00000037742', u'ENSMUSG00000039323', u'ENSMUSG00000070436', u'ENSMUSG00000022947', u'ENSMUSG00000058385', u'ENSMUSG00000021665', u'ENSMUSG00000036427', u'ENSMUSG00000030093', u'ENSMUSG00000028108', u'ENSMUSG00000030695', u'ENSMUSG00000025352', u'ENSMUSG00000025351', u'ENSMUSG00000016918', u'ENSMUSG00000043460', u'ENSMUSG00000036446', u'ENSMUSG00000024371', u'ENSMUSG00000028613', u'ENSMUSG00000067578', u'ENSMUSG00000016256', u'ENSMUSG00000067336', u'ENSMUSG00000052105', u'ENSMUSG00000035237', u'ENSMUSG00000054808', u'ENSMUSG00000042423', u'ENSMUSG00000020183', u'ENSMUSG00000006014', u'ENSMUSG00000062825', u'ENSMUSG00000064023', u'ENSMUSG00000027399', u'ENSMUSG00000016534', u'ENSMUSG00000019715', u'ENSMUSG00000041264', u'ENSMUSG00000050711', u'ENSMUSG00000023272', u'ENSMUSG00000041268', u'ENSMUSG00000037411', u'ENSMUSG00000045648', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000027712', u'ENSMUSG00000066551', u'ENSMUSG00000031972', u'ENSMUSG00000021614', u'ENSMUSG00000015656', u'ENSMUSG00000038593', u'ENSMUSG00000029713', u'ENSMUSG00000031875', u'ENSMUSG00000030659', u'ENSMUSG00000021477', u'ENSMUSG00000074272', u'ENSMUSG00000022382', u'ENSMUSG00000028780', u'ENSMUSG00000024053', u'ENSMUSG00000030270', u'ENSMUSG00000000881', u'ENSMUSG00000032087', u'ENSMUSG00000018446', u'ENSMUSG00000027004', u'ENSMUSG00000004366', u'ENSMUSG00000018593', u'ENSMUSG00000021806', u'ENSMUSG00000034684', u'ENSMUSG00000020053', u'ENSMUSG00000031393', u'ENSMUSG00000090247', u'ENSMUSG00000019856', u'ENSMUSG00000026443', u'ENSMUSG00000047787', u'ENSMUSG00000017344', u'ENSMUSG00000036097', u'ENSMUSG00000033307', u'ENSMUSG00000021870', u'ENSMUSG00000021876', u'ENSMUSG00000054693', u'ENSMUSG00000032575', u'ENSMUSG00000021508', u'ENSMUSG00000040794', u'ENSMUSG00000021974', u'ENSMUSG00000029819', u'ENSMUSG00000025823', u'ENSMUSG00000025534', u'ENSMUSG00000029086', u'ENSMUSG00000026921', u'ENSMUSG00000052305', u'ENSMUSG00000026926', u'ENSMUSG00000036928', u'ENSMUSG00000044177', u'ENSMUSG00000035279', u'ENSMUSG00000031246', u'ENSMUSG00000050587', u'ENSMUSG00000038463', u'ENSMUSG00000031451', u'ENSMUSG00000028668', u'ENSMUSG00000019122', u'ENSMUSG00000022449', u'ENSMUSG00000005397', u'ENSMUSG00000029718', u'ENSMUSG00000029623', u'ENSMUSG00000057722', u'ENSMUSG00000017466', u'ENSMUSG00000036273', u'ENSMUSG00000001642', u'ENSMUSG00000050063', u'ENSMUSG00000034610', u'ENSMUSG00000043631', u'ENSMUSG00000028864', u'ENSMUSG00000034205', u'ENSMUSG00000022971', u'ENSMUSG00000000632', u'ENSMUSG00000052397', u'ENSMUSG00000032179', u'ENSMUSG00000033453', u'ENSMUSG00000048920', u'ENSMUSG00000038793', u'ENSMUSG00000043557', u'ENSMUSG00000032231', u'ENSMUSG00000024529', u'ENSMUSG00000027187', u'ENSMUSG00000027188', u'ENSMUSG00000062991', u'ENSMUSG00000039278', u'ENSMUSG00000018293', u'ENSMUSG00000023336', u'ENSMUSG00000018930', u'ENSMUSG00000029672', u'ENSMUSG00000069268', u'ENSMUSG00000048126', u'ENSMUSG00000028369', u'ENSMUSG00000028041', u'ENSMUSG00000021732', u'ENSMUSG00000028364', u'ENSMUSG00000028048', u'ENSMUSG00000028362', u'ENSMUSG00000031995', u'ENSMUSG00000035493', u'ENSMUSG00000008734', u'ENSMUSG00000016541', u'ENSMUSG00000031442', u'ENSMUSG00000055409', u'ENSMUSG00000045414', u'ENSMUSG00000030583', u'ENSMUSG00000040856', u'ENSMUSG00000023456', u'ENSMUSG00000050335', u'ENSMUSG00000048616', u'ENSMUSG00000037428', u'ENSMUSG00000043635', u'ENSMUSG00000031538', u'ENSMUSG00000030824', u'ENSMUSG00000068196', u'ENSMUSG00000026069', u'ENSMUSG00000031842', u'ENSMUSG00000031841', u'ENSMUSG00000003814', u'ENSMUSG00000038642', u'ENSMUSG00000032359', u'ENSMUSG00000014813', u'ENSMUSG00000039007', u'ENSMUSG00000039004', u'ENSMUSG00000020674', u'ENSMUSG00000027962', u'ENSMUSG00000042116', u'ENSMUSG00000027966', u'ENSMUSG00000069917', u'ENSMUSG00000027965', u'ENSMUSG00000069919', u'ENSMUSG00000029999', u'ENSMUSG00000063524', u'ENSMUSG00000030341', u'ENSMUSG00000031740', u'ENSMUSG00000022309', u'ENSMUSG00000031196', u'ENSMUSG00000006782', u'ENSMUSG00000036896', u'ENSMUSG00000068748', u'ENSMUSG00000018401', u'ENSMUSG00000023046', u'ENSMUSG00000022064', u'ENSMUSG00000032434', u'ENSMUSG00000073418', u'ENSMUSG00000032431', u'ENSMUSG00000026365', u'ENSMUSG00000021835', u'ENSMUSG00000032532', u'ENSMUSG00000021939', u'ENSMUSG00000022766', u'ENSMUSG00000042501', u'ENSMUSG00000020303', u'ENSMUSG00000048581', u'ENSMUSG00000031266', u'ENSMUSG00000038156', u'ENSMUSG00000045322', u'ENSMUSG00000029759', u'ENSMUSG00000021186', u'ENSMUSG00000019579', u'ENSMUSG00000026880', u'ENSMUSG00000052613', u'ENSMUSG00000039952', u'ENSMUSG00000039953', u'ENSMUSG00000044734', u'ENSMUSG00000049612', u'ENSMUSG00000026315', u'ENSMUSG00000024462', u'ENSMUSG00000021943', u'ENSMUSG00000004207', u'ENSMUSG00000029661', u'ENSMUSG00000076617', u'ENSMUSG00000035783', u'ENSMUSG00000026701', u'ENSMUSG00000026814', u'ENSMUSG00000041014', u'ENSMUSG00000027792', u'ENSMUSG00000030218', u'ENSMUSG00000037499', u'ENSMUSG00000040254', u'ENSMUSG00000039239', u'ENSMUSG00000020427', u'ENSMUSG00000000489', u'ENSMUSG00000029335', u'ENSMUSG00000033068', u'ENSMUSG00000023830', u'ENSMUSG00000024962', u'ENSMUSG00000036545', u'ENSMUSG00000028773', u'ENSMUSG00000006800', u'ENSMUSG00000072941', u'ENSMUSG00000022483', u'ENSMUSG00000060803', u'ENSMUSG00000041577', u'ENSMUSG00000034336', u'ENSMUSG00000006763', u'ENSMUSG00000046186', u'ENSMUSG00000022847', u'ENSMUSG00000004105', u'ENSMUSG00000074264', u'ENSMUSG00000036887', u'ENSMUSG00000020841', u'ENSMUSG00000028413', u'ENSMUSG00000025132', u'ENSMUSG00000027810', u'ENSMUSG00000061808', u'ENSMUSG00000005672', u'ENSMUSG00000008348', u'ENSMUSG00000045636', u'ENSMUSG00000015850', u'ENSMUSG00000052593', u'ENSMUSG00000024517', u'ENSMUSG00000037010', u'ENSMUSG00000053846', u'ENSMUSG00000027312', u'ENSMUSG00000027315', u'ENSMUSG00000030048', u'ENSMUSG00000027316', u'ENSMUSG00000039217', u'ENSMUSG00000016024', u'ENSMUSG00000031963', u'ENSMUSG00000000392', u'ENSMUSG00000027082', u'ENSMUSG00000015143', u'ENSMUSG00000064080', u'ENSMUSG00000067242', u'ENSMUSG00000033961', u'ENSMUSG00000073940', u'ENSMUSG00000072115', u'ENSMUSG00000002289', u'ENSMUSG00000064246', u'ENSMUSG00000063564', u'ENSMUSG00000004791', u'ENSMUSG00000041926', u'ENSMUSG00000014361', u'ENSMUSG00000022982', u'ENSMUSG00000007891', u'ENSMUSG00000040138', u'ENSMUSG00000017754', u'ENSMUSG00000032006', u'ENSMUSG00000045594', u'ENSMUSG00000021745', u'ENSMUSG00000053475', u'ENSMUSG00000022026', u'ENSMUSG00000031380', u'ENSMUSG00000075224', u'ENSMUSG00000034163', u'ENSMUSG00000030317', u'ENSMUSG00000056999', u'ENSMUSG00000000957', u'ENSMUSG00000034168', u'ENSMUSG00000019899', u'ENSMUSG00000021998', u'ENSMUSG00000021994', u'ENSMUSG00000015568', u'ENSMUSG00000048120', u'ENSMUSG00000036169', u'ENSMUSG00000002602', u'ENSMUSG00000002603', u'ENSMUSG00000049556', u'ENSMUSG00000022325', u'ENSMUSG00000022324', u'ENSMUSG00000047414', u'ENSMUSG00000021900', u'ENSMUSG00000015090', u'ENSMUSG00000022285', u'ENSMUSG00000007041', u'ENSMUSG00000025810', u'ENSMUSG00000004951', u'ENSMUSG00000056222', u'ENSMUSG00000032135', u'ENSMUSG00000031134', u'ENSMUSG00000021583', u'ENSMUSG00000068854', u'ENSMUSG00000022514', u'ENSMUSG00000020467', u'ENSMUSG00000020460', u'ENSMUSG00000022454', u'ENSMUSG00000028776', u'ENSMUSG00000038552', u'ENSMUSG00000038916', u'ENSMUSG00000046318', u'ENSMUSG00000024085', u'ENSMUSG00000025889', u'ENSMUSG00000024082', u'ENSMUSG00000028871', u'ENSMUSG00000047246', u'ENSMUSG00000033208', u'ENSMUSG00000038224', u'ENSMUSG00000039304', u'ENSMUSG00000058897', u'ENSMUSG00000025289', u'ENSMUSG00000031990', u'ENSMUSG00000021390', u'ENSMUSG00000000600', u'ENSMUSG00000064373', u'ENSMUSG00000044986', u'ENSMUSG00000039804', u'ENSMUSG00000019795', u'ENSMUSG00000038521', u'ENSMUSG00000059974', u'ENSMUSG00000001930', u'ENSMUSG00000024953', u'ENSMUSG00000024810', u'ENSMUSG00000046167', u'ENSMUSG00000010051', u'ENSMUSG00000039252', u'ENSMUSG00000001741', u'ENSMUSG00000024256', u'ENSMUSG00000000693', u'ENSMUSG00000037110', u'ENSMUSG00000069516', u'ENSMUSG00000000126', u'ENSMUSG00000023224', u'ENSMUSG00000038843', u'ENSMUSG00000025089', u'ENSMUSG00000027358', u'ENSMUSG00000038677', u'ENSMUSG00000062727', u'ENSMUSG00000028195', u'ENSMUSG00000049580', u'ENSMUSG00000021702', u'ENSMUSG00000031591', u'ENSMUSG00000030513', u'ENSMUSG00000031980', u'ENSMUSG00000041559', u'ENSMUSG00000031521', u'ENSMUSG00000028907', u'ENSMUSG00000041445', u'ENSMUSG00000055485', u'ENSMUSG00000027859', u'ENSMUSG00000027070', u'ENSMUSG00000040998', u'ENSMUSG00000042632', u'ENSMUSG00000022108', u'ENSMUSG00000020604', u'ENSMUSG00000026072', u'ENSMUSG00000039016', u'ENSMUSG00000045083', u'ENSMUSG00000021556', u'ENSMUSG00000063531', u'ENSMUSG00000025854', u'ENSMUSG00000025856', u'ENSMUSG00000023571', u'ENSMUSG00000029417', u'ENSMUSG00000017639', u'ENSMUSG00000051067', u'ENSMUSG00000037254', u'ENSMUSG00000021340', u'ENSMUSG00000019997', u'ENSMUSG00000040488', u'ENSMUSG00000031778', u'ENSMUSG00000026553', u'ENSMUSG00000061353', u'ENSMUSG00000004267', u'ENSMUSG00000023078', u'ENSMUSG00000018166', u'ENSMUSG00000019966', u'ENSMUSG00000001119', u'ENSMUSG00000021822', u'ENSMUSG00000057969', u'ENSMUSG00000019846', u'ENSMUSG00000010797', u'ENSMUSG00000027419', u'ENSMUSG00000021194', u'ENSMUSG00000022797', u'ENSMUSG00000017446', u'ENSMUSG00000067889', u'ENSMUSG00000040713', u'ENSMUSG00000033327', u'ENSMUSG00000032554', u'ENSMUSG00000029838', u'ENSMUSG00000014599', u'ENSMUSG00000029119', u'ENSMUSG00000021484', u'ENSMUSG00000029287', u'ENSMUSG00000034771', u'ENSMUSG00000025512', u'ENSMUSG00000054162', u'ENSMUSG00000024778', u'ENSMUSG00000032187', u'ENSMUSG00000039208', u'ENSMUSG00000024066', u'ENSMUSG00000032959', u'ENSMUSG00000074457', u'ENSMUSG00000038538', u'ENSMUSG00000021680', u'ENSMUSG00000020432', u'ENSMUSG00000029304', u'ENSMUSG00000022425', u'ENSMUSG00000022421', u'ENSMUSG00000021278', u'ENSMUSG00000029309', u'ENSMUSG00000033557', u'ENSMUSG00000024357', u'ENSMUSG00000036256', u'ENSMUSG00000028885', u'ENSMUSG00000001666', u'ENSMUSG00000030607', u'ENSMUSG00000022490', u'ENSMUSG00000030605', u'ENSMUSG00000025207', u'ENSMUSG00000030600', u'ENSMUSG00000034730', u'ENSMUSG00000054263', u'ENSMUSG00000035352', u'ENSMUSG00000036905', u'ENSMUSG00000006611', u'ENSMUSG00000027524', u'ENSMUSG00000039646', u'ENSMUSG00000001942', u'ENSMUSG00000030786', u'ENSMUSG00000029428', u'ENSMUSG00000034648', u'ENSMUSG00000020918', u'ENSMUSG00000023913', u'ENSMUSG00000025020', u'ENSMUSG00000009281', u'ENSMUSG00000031558', u'ENSMUSG00000034855', u'ENSMUSG00000062929', u'ENSMUSG00000031555', u'ENSMUSG00000005667', u'ENSMUSG00000060600', u'ENSMUSG00000028019', u'ENSMUSG00000028393', u'ENSMUSG00000024501', u'ENSMUSG00000030772', u'ENSMUSG00000034353', u'ENSMUSG00000028944', u'ENSMUSG00000028128', u'ENSMUSG00000005142', u'ENSMUSG00000058488', u'ENSMUSG00000039114', u'ENSMUSG00000049265', u'ENSMUSG00000050830', u'ENSMUSG00000009376', u'ENSMUSG00000021756', u'ENSMUSG00000028064', u'ENSMUSG00000024130', u'ENSMUSG00000021451', u'ENSMUSG00000028300', u'ENSMUSG00000006369', u'ENSMUSG00000037206', u'ENSMUSG00000042312', u'ENSMUSG00000026193', u'ENSMUSG00000083282', u'ENSMUSG00000042251', u'ENSMUSG00000035172', u'ENSMUSG00000030805', u'ENSMUSG00000026121', u'ENSMUSG00000028249', u'ENSMUSG00000026697', u'ENSMUSG00000021904', u'ENSMUSG00000007888', u'ENSMUSG00000068220', u'ENSMUSG00000023031', u'ENSMUSG00000026042', u'ENSMUSG00000026043', u'ENSMUSG00000019929', u'ENSMUSG00000057388', u'ENSMUSG00000022037', u'ENSMUSG00000020151', u'ENSMUSG00000037852', u'ENSMUSG00000055737', u'ENSMUSG00000021253', u'ENSMUSG00000021256', u'ENSMUSG00000034708', u'ENSMUSG00000006403', u'ENSMUSG00000022887', u'ENSMUSG00000032193', u'ENSMUSG00000021091', u'ENSMUSG00000021319', u'ENSMUSG00000054717', u'ENSMUSG00000002900', u'ENSMUSG00000015451', u'ENSMUSG00000029163', u'ENSMUSG00000056427', u'ENSMUSG00000016763', u'ENSMUSG00000060802', u'ENSMUSG00000040759', u'ENSMUSG00000051439', u'ENSMUSG00000032436', u'ENSMUSG00000019810', u'ENSMUSG00000002227', u'ENSMUSG00000006205', u'ENSMUSG00000060275', u'ENSMUSG00000027562', u'ENSMUSG00000020241', u'ENSMUSG00000020571', u'ENSMUSG00000020572', u'ENSMUSG00000041297', u'ENSMUSG00000044626', u'ENSMUSG00000020473', u'ENSMUSG00000022665', u'ENSMUSG00000028763', u'ENSMUSG00000028766', u'ENSMUSG00000024098', u'ENSMUSG00000024486', u'ENSMUSG00000029648', u'ENSMUSG00000036550', u'ENSMUSG00000041936', u'ENSMUSG00000024647', u'ENSMUSG00000020085', u'ENSMUSG00000020321', u'ENSMUSG00000000753', u'ENSMUSG00000022816', u'ENSMUSG00000027447', u'ENSMUSG00000032925', u'ENSMUSG00000019872', u'ENSMUSG00000028691', u'ENSMUSG00000028692', u'ENSMUSG00000030748', u'ENSMUSG00000028883', u'ENSMUSG00000020681', u'ENSMUSG00000037035', u'ENSMUSG00000029580', u'ENSMUSG00000036528', u'ENSMUSG00000023951', u'ENSMUSG00000041684', u'ENSMUSG00000025980', u'ENSMUSG00000054555', u'ENSMUSG00000036327', u'ENSMUSG00000028600', u'ENSMUSG00000043987', u'ENSMUSG00000035385', u'ENSMUSG00000028164', u'ENSMUSG00000035653', u'ENSMUSG00000050222', u'ENSMUSG00000036957', u'ENSMUSG00000027204', u'ENSMUSG00000052133', u'ENSMUSG00000061462']), study_n=624, level=2, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005622', NS='CC', enrichment='p', name='intracellular', ratio_in_study=(25, 624), ratio_in_pop=(672, 13836), p_uncorrected=0.3415648241985913, depth=2, study_count=25, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000046718', u'ENSMUSG00000024974', u'ENSMUSG00000059552', u'ENSMUSG00000030528', u'ENSMUSG00000006418', u'ENSMUSG00000030609', u'ENSMUSG00000069793', u'ENSMUSG00000020773', u'ENSMUSG00000057789', u'ENSMUSG00000039813', u'ENSMUSG00000005566', u'ENSMUSG00000036992', u'ENSMUSG00000036986', u'ENSMUSG00000032477', u'ENSMUSG00000025647', u'ENSMUSG00000034457', u'ENSMUSG00000026274', u'ENSMUSG00000005370', u'ENSMUSG00000027342', u'ENSMUSG00000001123', u'ENSMUSG00000020608', u'ENSMUSG00000020108', u'ENSMUSG00000040350', u'ENSMUSG00000038774']), pop_n=13836, pop_count=672, pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000020198', u'ENSMUSG00000034226', u'ENSMUSG00000003873', u'ENSMUSG00000023923', u'ENSMUSG00000053192', u'ENSMUSG00000021712', u'ENSMUSG00000003970', u'ENSMUSG00000030443', u'ENSMUSG00000030298', u'ENSMUSG00000037326', u'ENSMUSG00000042348', u'ENSMUSG00000037242', u'ENSMUSG00000028936', u'ENSMUSG00000034402', u'ENSMUSG00000049866', u'ENSMUSG00000005054', u'ENSMUSG00000068220', u'ENSMUSG00000031907', u'ENSMUSG00000062444', u'ENSMUSG00000017144', u'ENSMUSG00000063145', u'ENSMUSG00000030161', u'ENSMUSG00000033862', u'ENSMUSG00000048076', u'ENSMUSG00000008668', u'ENSMUSG00000012422', u'ENSMUSG00000015340', u'ENSMUSG00000090137', u'ENSMUSG00000003585', u'ENSMUSG00000052917', u'ENSMUSG00000059981', u'ENSMUSG00000031347', u'ENSMUSG00000027016', u'ENSMUSG00000035722', u'ENSMUSG00000045827', u'ENSMUSG00000033949', u'ENSMUSG00000018583', u'ENSMUSG00000026426', u'ENSMUSG00000020108', u'ENSMUSG00000061898', u'ENSMUSG00000022911', u'ENSMUSG00000025880', u'ENSMUSG00000000711', u'ENSMUSG00000021326', u'ENSMUSG00000021327', u'ENSMUSG00000036986', u'ENSMUSG00000058835', u'ENSMUSG00000015461', u'ENSMUSG00000006699', u'ENSMUSG00000038425', u'ENSMUSG00000036989', u'ENSMUSG00000062040', u'ENSMUSG00000032563', u'ENSMUSG00000079641', u'ENSMUSG00000029126', u'ENSMUSG00000036781', u'ENSMUSG00000034867', u'ENSMUSG00000057789', u'ENSMUSG00000051864', u'ENSMUSG00000051853', u'ENSMUSG00000035189', u'ENSMUSG00000027663', u'ENSMUSG00000026721', u'ENSMUSG00000019132', u'ENSMUSG00000022538', u'ENSMUSG00000073838', u'ENSMUSG00000037787', u'ENSMUSG00000029223', u'ENSMUSG00000046330', u'ENSMUSG00000022540', u'ENSMUSG00000039781', u'ENSMUSG00000054517', u'ENSMUSG00000015932', u'ENSMUSG00000022548', u'ENSMUSG00000034211', u'ENSMUSG00000007610', u'ENSMUSG00000005370', u'ENSMUSG00000073295', u'ENSMUSG00000041559', u'ENSMUSG00000027534', u'ENSMUSG00000020961', u'ENSMUSG00000063108', u'ENSMUSG00000042492', u'ENSMUSG00000060636', u'ENSMUSG00000039105', u'ENSMUSG00000002058', u'ENSMUSG00000023845', u'ENSMUSG00000060147', u'ENSMUSG00000023967', u'ENSMUSG00000020982', u'ENSMUSG00000050697', u'ENSMUSG00000030401', u'ENSMUSG00000020821', u'ENSMUSG00000000538', u'ENSMUSG00000041236', u'ENSMUSG00000048429', u'ENSMUSG00000046093', u'ENSMUSG00000030888', u'ENSMUSG00000027330', u'ENSMUSG00000028974', u'ENSMUSG00000028975', u'ENSMUSG00000027335', u'ENSMUSG00000039263', u'ENSMUSG00000000439', u'ENSMUSG00000007338', u'ENSMUSG00000021725', u'ENSMUSG00000073968', u'ENSMUSG00000018381', u'ENSMUSG00000040596', u'ENSMUSG00000038967', u'ENSMUSG00000042303', u'ENSMUSG00000026181', u'ENSMUSG00000040528', u'ENSMUSG00000040521', u'ENSMUSG00000035007', u'ENSMUSG00000028389', u'ENSMUSG00000031548', u'ENSMUSG00000031833', u'ENSMUSG00000032066', u'ENSMUSG00000034457', u'ENSMUSG00000020668', u'ENSMUSG00000026509', u'ENSMUSG00000055723', u'ENSMUSG00000021536', u'ENSMUSG00000025870', u'ENSMUSG00000039234', u'ENSMUSG00000034863', u'ENSMUSG00000031202', u'ENSMUSG00000035960', u'ENSMUSG00000031209', u'ENSMUSG00000006418', u'ENSMUSG00000039960', u'ENSMUSG00000031375', u'ENSMUSG00000023944', u'ENSMUSG00000032826', u'ENSMUSG00000019944', u'ENSMUSG00000036106', u'ENSMUSG00000032288', u'ENSMUSG00000002233', u'ENSMUSG00000057863', u'ENSMUSG00000058546', u'ENSMUSG00000048814', u'ENSMUSG00000056201', u'ENSMUSG00000013736', u'ENSMUSG00000044147', u'ENSMUSG00000039813', u'ENSMUSG00000020440', u'ENSMUSG00000028234', u'ENSMUSG00000046364', u'ENSMUSG00000026878', u'ENSMUSG00000015981', u'ENSMUSG00000073982', u'ENSMUSG00000053046', u'ENSMUSG00000029174', u'ENSMUSG00000033220', u'ENSMUSG00000073988', u'ENSMUSG00000034667', u'ENSMUSG00000025576', u'ENSMUSG00000007659', u'ENSMUSG00000000740', u'ENSMUSG00000007655', u'ENSMUSG00000040365', u'ENSMUSG00000039221', u'ENSMUSG00000032936', u'ENSMUSG00000031681', u'ENSMUSG00000024974', u'ENSMUSG00000025290', u'ENSMUSG00000001911', u'ENSMUSG00000059552', u'ENSMUSG00000073702', u'ENSMUSG00000034800', u'ENSMUSG00000033014', u'ENSMUSG00000003161', u'ENSMUSG00000024370', u'ENSMUSG00000047215', u'ENSMUSG00000025794', u'ENSMUSG00000000266', u'ENSMUSG00000020386', u'ENSMUSG00000033083', u'ENSMUSG00000036964', u'ENSMUSG00000027274', u'ENSMUSG00000034892', u'ENSMUSG00000005580', u'ENSMUSG00000041609', u'ENSMUSG00000035235', u'ENSMUSG00000020891', u'ENSMUSG00000054808', u'ENSMUSG00000046718', u'ENSMUSG00000032492', u'ENSMUSG00000003868', u'ENSMUSG00000060036', u'ENSMUSG00000005566', u'ENSMUSG00000034936', u'ENSMUSG00000053693', u'ENSMUSG00000018347', u'ENSMUSG00000041261', u'ENSMUSG00000037001', u'ENSMUSG00000068335', u'ENSMUSG00000028923', u'ENSMUSG00000037410', u'ENSMUSG00000023277', u'ENSMUSG00000030058', u'ENSMUSG00000027712', u'ENSMUSG00000030872', u'ENSMUSG00000035437', u'ENSMUSG00000015656', u'ENSMUSG00000030879', u'ENSMUSG00000020740', u'ENSMUSG00000055305', u'ENSMUSG00000079259', u'ENSMUSG00000048251', u'ENSMUSG00000031485', u'ENSMUSG00000030272', u'ENSMUSG00000053985', u'ENSMUSG00000052962', u'ENSMUSG00000030393', u'ENSMUSG00000031583', u'ENSMUSG00000036036', u'ENSMUSG00000026028', u'ENSMUSG00000027006', u'ENSMUSG00000031374', u'ENSMUSG00000018068', u'ENSMUSG00000031805', u'ENSMUSG00000032402', u'ENSMUSG00000018593', u'ENSMUSG00000017724', u'ENSMUSG00000024563', u'ENSMUSG00000057614', u'ENSMUSG00000021339', u'ENSMUSG00000030301', u'ENSMUSG00000041000', u'ENSMUSG00000039361', u'ENSMUSG00000058638', u'ENSMUSG00000027434', u'ENSMUSG00000068663', u'ENSMUSG00000036992', u'ENSMUSG00000002844', u'ENSMUSG00000029146', u'ENSMUSG00000039853', u'ENSMUSG00000026442', u'ENSMUSG00000036093', u'ENSMUSG00000032477', u'ENSMUSG00000063801', u'ENSMUSG00000003604', u'ENSMUSG00000017264', u'ENSMUSG00000021871', u'ENSMUSG00000047036', u'ENSMUSG00000021877', u'ENSMUSG00000004843', u'ENSMUSG00000024457', u'ENSMUSG00000054893', u'ENSMUSG00000031026', u'ENSMUSG00000053647', u'ENSMUSG00000026927', u'ENSMUSG00000020364', u'ENSMUSG00000035279', u'ENSMUSG00000003037', u'ENSMUSG00000022528', u'ENSMUSG00000038545', u'ENSMUSG00000003134', u'ENSMUSG00000028868', u'ENSMUSG00000029627', u'ENSMUSG00000021385', u'ENSMUSG00000001313', u'ENSMUSG00000028861', u'ENSMUSG00000035772', u'ENSMUSG00000005267', u'ENSMUSG00000029392', u'ENSMUSG00000034751', u'ENSMUSG00000021025', u'ENSMUSG00000066043', u'ENSMUSG00000055835', u'ENSMUSG00000005102', u'ENSMUSG00000029763', u'ENSMUSG00000052397', u'ENSMUSG00000048921', u'ENSMUSG00000029401', u'ENSMUSG00000029406', u'ENSMUSG00000029405', u'ENSMUSG00000070880', u'ENSMUSG00000025362', u'ENSMUSG00000027291', u'ENSMUSG00000028565', u'ENSMUSG00000020832', u'ENSMUSG00000028140', u'ENSMUSG00000025647', u'ENSMUSG00000027189', u'ENSMUSG00000024526', u'ENSMUSG00000009894', u'ENSMUSG00000027342', u'ENSMUSG00000040350', u'ENSMUSG00000023192', u'ENSMUSG00000039633', u'ENSMUSG00000025035', u'ENSMUSG00000066258', u'ENSMUSG00000014353', u'ENSMUSG00000018012', u'ENSMUSG00000062861', u'ENSMUSG00000030432', u'ENSMUSG00000049960', u'ENSMUSG00000027828', u'ENSMUSG00000041453', u'ENSMUSG00000042473', u'ENSMUSG00000031539', u'ENSMUSG00000020773', u'ENSMUSG00000019710', u'ENSMUSG00000022111', u'ENSMUSG00000039001', u'ENSMUSG00000003429', u'ENSMUSG00000039005', u'ENSMUSG00000012405', u'ENSMUSG00000021540', u'ENSMUSG00000021270', u'ENSMUSG00000034151', u'ENSMUSG00000021375', u'ENSMUSG00000042203', u'ENSMUSG00000020709', u'ENSMUSG00000068037', u'ENSMUSG00000029066', u'ENSMUSG00000031320', u'ENSMUSG00000031327', u'ENSMUSG00000042271', u'ENSMUSG00000026404', u'ENSMUSG00000019977', u'ENSMUSG00000053536', u'ENSMUSG00000032536', u'ENSMUSG00000033808', u'ENSMUSG00000039682', u'ENSMUSG00000021831', u'ENSMUSG00000074221', u'ENSMUSG00000006333', u'ENSMUSG00000024143', u'ENSMUSG00000024414', u'ENSMUSG00000067288', u'ENSMUSG00000068732', u'ENSMUSG00000020267', u'ENSMUSG00000020515', u'ENSMUSG00000022568', u'ENSMUSG00000020459', u'ENSMUSG00000020458', u'ENSMUSG00000029204', u'ENSMUSG00000020455', u'ENSMUSG00000071291', u'ENSMUSG00000029614', u'ENSMUSG00000047454', u'ENSMUSG00000039954', u'ENSMUSG00000042590', u'ENSMUSG00000090877', u'ENSMUSG00000032549', u'ENSMUSG00000033233', u'ENSMUSG00000006932', u'ENSMUSG00000011589', u'ENSMUSG00000070348', u'ENSMUSG00000025269', u'ENSMUSG00000062012', u'ENSMUSG00000062014', u'ENSMUSG00000025508', u'ENSMUSG00000037492', u'ENSMUSG00000027797', u'ENSMUSG00000027796', u'ENSMUSG00000051675', u'ENSMUSG00000029729', u'ENSMUSG00000021690', u'ENSMUSG00000038456', u'ENSMUSG00000058396', u'ENSMUSG00000011831', u'ENSMUSG00000025283', u'ENSMUSG00000011832', u'ENSMUSG00000038515', u'ENSMUSG00000022419', u'ENSMUSG00000024962', u'ENSMUSG00000028136', u'ENSMUSG00000029449', u'ENSMUSG00000028741', u'ENSMUSG00000037649', u'ENSMUSG00000037640', u'ENSMUSG00000030966', u'ENSMUSG00000021054', u'ENSMUSG00000074657', u'ENSMUSG00000020589', u'ENSMUSG00000034880', u'ENSMUSG00000027220', u'ENSMUSG00000019699', u'ENSMUSG00000029433', u'ENSMUSG00000047632', u'ENSMUSG00000032481', u'ENSMUSG00000053414', u'ENSMUSG00000025034', u'ENSMUSG00000020843', u'ENSMUSG00000052681', u'ENSMUSG00000040952', u'ENSMUSG00000030045', u'ENSMUSG00000035299', u'ENSMUSG00000041319', u'ENSMUSG00000024515', u'ENSMUSG00000027313', u'ENSMUSG00000028955', u'ENSMUSG00000021607', u'ENSMUSG00000066613', u'ENSMUSG00000018909', u'ENSMUSG00000058498', u'ENSMUSG00000015143', u'ENSMUSG00000067276', u'ENSMUSG00000035208', u'ENSMUSG00000048012', u'ENSMUSG00000015002', u'ENSMUSG00000025993', u'ENSMUSG00000054752', u'ENSMUSG00000031709', u'ENSMUSG00000075602', u'ENSMUSG00000022987', u'ENSMUSG00000073421', u'ENSMUSG00000039194', u'ENSMUSG00000007892', u'ENSMUSG00000031402', u'ENSMUSG00000030815', u'ENSMUSG00000060904', u'ENSMUSG00000031812', u'ENSMUSG00000038671', u'ENSMUSG00000020122', u'ENSMUSG00000044864', u'ENSMUSG00000038774', u'ENSMUSG00000034160', u'ENSMUSG00000058600', u'ENSMUSG00000030319', u'ENSMUSG00000031388', u'ENSMUSG00000046562', u'ENSMUSG00000017677', u'ENSMUSG00000017679', u'ENSMUSG00000018548', u'ENSMUSG00000033128', u'ENSMUSG00000073639', u'ENSMUSG00000051351', u'ENSMUSG00000029027', u'ENSMUSG00000004221', u'ENSMUSG00000051359', u'ENSMUSG00000002210', u'ENSMUSG00000053012', u'ENSMUSG00000036644', u'ENSMUSG00000038028', u'ENSMUSG00000021901', u'ENSMUSG00000041607', u'ENSMUSG00000021514', u'ENSMUSG00000026917', u'ENSMUSG00000057963', u'ENSMUSG00000020541', u'ENSMUSG00000035547', u'ENSMUSG00000017404', u'ENSMUSG00000055053', u'ENSMUSG00000022451', u'ENSMUSG00000057322', u'ENSMUSG00000058267', u'ENSMUSG00000025495', u'ENSMUSG00000032215', u'ENSMUSG00000039697', u'ENSMUSG00000057329', u'ENSMUSG00000004319', u'ENSMUSG00000024735', u'ENSMUSG00000057691', u'ENSMUSG00000048310', u'ENSMUSG00000030921', u'ENSMUSG00000062797', u'ENSMUSG00000006720', u'ENSMUSG00000020335', u'ENSMUSG00000062421', u'ENSMUSG00000062380', u'ENSMUSG00000038520', u'ENSMUSG00000059975', u'ENSMUSG00000028680', u'ENSMUSG00000029471', u'ENSMUSG00000028519', u'ENSMUSG00000033039', u'ENSMUSG00000005534', u'ENSMUSG00000027287', u'ENSMUSG00000001741', u'ENSMUSG00000045948', u'ENSMUSG00000073293', u'ENSMUSG00000020932', u'ENSMUSG00000063239', u'ENSMUSG00000028284', u'ENSMUSG00000041216', u'ENSMUSG00000061477', u'ENSMUSG00000046447', u'ENSMUSG00000046768', u'ENSMUSG00000014470', u'ENSMUSG00000047473', u'ENSMUSG00000021701', u'ENSMUSG00000051499', u'ENSMUSG00000058626', u'ENSMUSG00000028030', u'ENSMUSG00000046688', u'ENSMUSG00000031988', u'ENSMUSG00000045409', u'ENSMUSG00000030105', u'ENSMUSG00000031451', u'ENSMUSG00000037339', u'ENSMUSG00000039367', u'ENSMUSG00000079110', u'ENSMUSG00000042363', u'ENSMUSG00000050541', u'ENSMUSG00000034412', u'ENSMUSG00000055489', u'ENSMUSG00000027999', u'ENSMUSG00000055480', u'ENSMUSG00000026270', u'ENSMUSG00000027993', u'ENSMUSG00000026274', u'ENSMUSG00000027774', u'ENSMUSG00000037949', u'ENSMUSG00000026173', u'ENSMUSG00000020608', u'ENSMUSG00000018481', u'ENSMUSG00000060224', u'ENSMUSG00000024070', u'ENSMUSG00000028222', u'ENSMUSG00000001687', u'ENSMUSG00000064210', u'ENSMUSG00000054967', u'ENSMUSG00000036913', u'ENSMUSG00000004508', u'ENSMUSG00000021340', u'ENSMUSG00000018507', u'ENSMUSG00000002728', u'ENSMUSG00000068134', u'ENSMUSG00000004267', u'ENSMUSG00000049517', u'ENSMUSG00000021824', u'ENSMUSG00000034675', u'ENSMUSG00000004951', u'ENSMUSG00000022075', u'ENSMUSG00000053119', u'ENSMUSG00000019969', u'ENSMUSG00000024170', u'ENSMUSG00000067274', u'ENSMUSG00000056144', u'ENSMUSG00000035325', u'ENSMUSG00000018189', u'ENSMUSG00000033327', u'ENSMUSG00000048930', u'ENSMUSG00000047675', u'ENSMUSG00000029600', u'ENSMUSG00000003348', u'ENSMUSG00000032553', u'ENSMUSG00000021893', u'ENSMUSG00000021895', u'ENSMUSG00000021481', u'ENSMUSG00000029833', u'ENSMUSG00000054364', u'ENSMUSG00000032251', u'ENSMUSG00000035984', u'ENSMUSG00000039461', u'ENSMUSG00000028832', u'ENSMUSG00000038352', u'ENSMUSG00000015222', u'ENSMUSG00000050017', u'ENSMUSG00000061787', u'ENSMUSG00000019518', u'ENSMUSG00000021123', u'ENSMUSG00000021680', u'ENSMUSG00000047446', u'ENSMUSG00000031639', u'ENSMUSG00000022427', u'ENSMUSG00000023826', u'ENSMUSG00000062929', u'ENSMUSG00000058558', u'ENSMUSG00000060121', u'ENSMUSG00000028645', u'ENSMUSG00000001847', u'ENSMUSG00000022553', u'ENSMUSG00000041548', u'ENSMUSG00000027488', u'ENSMUSG00000030609', u'ENSMUSG00000069793', u'ENSMUSG00000022490', u'ENSMUSG00000000247', u'ENSMUSG00000055991', u'ENSMUSG00000036867', u'ENSMUSG00000016239', u'ENSMUSG00000059070', u'ENSMUSG00000030782', u'ENSMUSG00000008575', u'ENSMUSG00000039640', u'ENSMUSG00000024829', u'ENSMUSG00000060397', u'ENSMUSG00000059475', u'ENSMUSG00000017781', u'ENSMUSG00000021619', u'ENSMUSG00000024851', u'ENSMUSG00000028081', u'ENSMUSG00000001018', u'ENSMUSG00000078779', u'ENSMUSG00000031950', u'ENSMUSG00000007815', u'ENSMUSG00000041997', u'ENSMUSG00000046658', u'ENSMUSG00000006362', u'ENSMUSG00000015013', u'ENSMUSG00000056313', u'ENSMUSG00000042766', u'ENSMUSG00000030528', u'ENSMUSG00000052676', u'ENSMUSG00000030805', u'ENSMUSG00000031827', u'ENSMUSG00000052302', u'ENSMUSG00000036273', u'ENSMUSG00000002767', u'ENSMUSG00000040430', u'ENSMUSG00000057388', u'ENSMUSG00000079065', u'ENSMUSG00000052675', u'ENSMUSG00000057841', u'ENSMUSG00000032193', u'ENSMUSG00000021314', u'ENSMUSG00000039976', u'ENSMUSG00000057982', u'ENSMUSG00000010592', u'ENSMUSG00000031731', u'ENSMUSG00000063296', u'ENSMUSG00000032518', u'ENSMUSG00000060803', u'ENSMUSG00000022043', u'ENSMUSG00000032511', u'ENSMUSG00000044807', u'ENSMUSG00000059291', u'ENSMUSG00000022722', u'ENSMUSG00000021917', u'ENSMUSG00000024436', u'ENSMUSG00000024431', u'ENSMUSG00000001123', u'ENSMUSG00000024006', u'ENSMUSG00000034071', u'ENSMUSG00000054737', u'ENSMUSG00000002731', u'ENSMUSG00000054855', u'ENSMUSG00000020476', u'ENSMUSG00000020472', u'ENSMUSG00000017418', u'ENSMUSG00000016833', u'ENSMUSG00000024480', u'ENSMUSG00000022340', u'ENSMUSG00000032202', u'ENSMUSG00000029864', u'ENSMUSG00000036357', u'ENSMUSG00000020328', u'ENSMUSG00000014602', u'ENSMUSG00000020088', u'ENSMUSG00000042870', u'ENSMUSG00000038175', u'ENSMUSG00000038174', u'ENSMUSG00000040270', u'ENSMUSG00000026764', u'ENSMUSG00000029467', u'ENSMUSG00000022220', u'ENSMUSG00000024942', u'ENSMUSG00000024944', u'ENSMUSG00000019785', u'ENSMUSG00000074220', u'ENSMUSG00000029587', u'ENSMUSG00000036257', u'ENSMUSG00000034255', u'ENSMUSG00000027168', u'ENSMUSG00000060216', u'ENSMUSG00000029345', u'ENSMUSG00000036591', u'ENSMUSG00000034317', u'ENSMUSG00000034701', u'ENSMUSG00000043279', u'ENSMUSG00000035227', u'ENSMUSG00000021071', u'ENSMUSG00000027363', u'ENSMUSG00000000058']), study_n=624, level=2, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005623', NS='CC', enrichment='p', name='cell', ratio_in_study=(3, 624), ratio_in_pop=(116, 13836), p_uncorrected=0.49538722661735174, depth=1, study_count=3, p_sm_bonferroni=1.0, p_fdr_bh=1.0, study_items=set([u'ENSMUSG00000036875', u'ENSMUSG00000054717', u'ENSMUSG00000039456']), pop_n=13836, pop_count=116, pop_items=set([u'ENSMUSG00000068732', u'ENSMUSG00000020198', u'ENSMUSG00000042590', u'ENSMUSG00000006576', u'ENSMUSG00000031776', u'ENSMUSG00000030298', u'ENSMUSG00000036437', u'ENSMUSG00000052229', u'ENSMUSG00000032549', u'ENSMUSG00000021824', u'ENSMUSG00000054150', u'ENSMUSG00000062444', u'ENSMUSG00000039456', u'ENSMUSG00000020614', u'ENSMUSG00000041609', u'ENSMUSG00000039234', u'ENSMUSG00000040528', u'ENSMUSG00000035325', u'ENSMUSG00000038456', u'ENSMUSG00000012422', u'ENSMUSG00000027394', u'ENSMUSG00000029600', u'ENSMUSG00000028136', u'ENSMUSG00000035941', u'ENSMUSG00000005299', u'ENSMUSG00000030058', u'ENSMUSG00000074657', u'ENSMUSG00000036875', u'ENSMUSG00000027287', u'ENSMUSG00000022568', u'ENSMUSG00000039367', u'ENSMUSG00000019518', u'ENSMUSG00000057388', u'ENSMUSG00000039205', u'ENSMUSG00000020639', u'ENSMUSG00000022427', u'ENSMUSG00000020843', u'ENSMUSG00000079157', u'ENSMUSG00000026028', u'ENSMUSG00000036817', u'ENSMUSG00000029126', u'ENSMUSG00000023980', u'ENSMUSG00000020734', u'ENSMUSG00000048486', u'ENSMUSG00000021339', u'ENSMUSG00000030301', u'ENSMUSG00000028542', u'ENSMUSG00000022538', u'ENSMUSG00000029146', u'ENSMUSG00000054676', u'ENSMUSG00000070570', u'ENSMUSG00000063801', u'ENSMUSG00000039781', u'ENSMUSG00000001018', u'ENSMUSG00000038180', u'ENSMUSG00000002771', u'ENSMUSG00000044864', u'ENSMUSG00000027534', u'ENSMUSG00000025782', u'ENSMUSG00000026927', u'ENSMUSG00000020982', u'ENSMUSG00000003037', u'ENSMUSG00000028573', u'ENSMUSG00000030401', u'ENSMUSG00000020821', u'ENSMUSG00000041236', u'ENSMUSG00000028096', u'ENSMUSG00000037771', u'ENSMUSG00000048429', u'ENSMUSG00000029392', u'ENSMUSG00000023032', u'ENSMUSG00000071719', u'ENSMUSG00000060261', u'ENSMUSG00000019923', u'ENSMUSG00000060735', u'ENSMUSG00000029763', u'ENSMUSG00000029401', u'ENSMUSG00000027291', u'ENSMUSG00000021314', u'ENSMUSG00000031731', u'ENSMUSG00000024245', u'ENSMUSG00000027220', u'ENSMUSG00000009894', u'ENSMUSG00000021917', u'ENSMUSG00000028962', u'ENSMUSG00000020668', u'ENSMUSG00000040265', u'ENSMUSG00000033039', u'ENSMUSG00000014353', u'ENSMUSG00000024480', u'ENSMUSG00000022340', u'ENSMUSG00000003657', u'ENSMUSG00000035152', u'ENSMUSG00000014778', u'ENSMUSG00000034867', u'ENSMUSG00000053134', u'ENSMUSG00000031539', u'ENSMUSG00000053436', u'ENSMUSG00000054717', u'ENSMUSG00000040270', u'ENSMUSG00000026764', u'ENSMUSG00000029467', u'ENSMUSG00000021375', u'ENSMUSG00000029482', u'ENSMUSG00000031988', u'ENSMUSG00000037339', u'ENSMUSG00000079065', u'ENSMUSG00000036591', u'ENSMUSG00000032536', u'ENSMUSG00000034667', u'ENSMUSG00000014602', u'ENSMUSG00000033808', u'ENSMUSG00000020961', u'ENSMUSG00000037622', u'ENSMUSG00000035227', u'ENSMUSG00000018481']), study_n=624, level=1, is_obsolete=False, namespace='cellular_component', alt_ids=set([])),
    NtGoeaResults(GO='GO:0005634', NS='CC', enrichment='e', name='nucleus', ratio_in_study=(382, 624), ratio_in_pop=(4685, 13836), p_uncorrected=2.804141871612016e-10, depth=5, study_count=382, p_sm_bonferroni=4.4041852235538329e-06, p_fdr_bh=1.2233847843205092e-07, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000046591', u'ENSMUSG00000003873', u'ENSMUSG00000021714', u'ENSMUSG00000050410', u'ENSMUSG00000041879', u'ENSMUSG00000007080', u'ENSMUSG00000027067', u'ENSMUSG00000017146', u'ENSMUSG00000027469', u'ENSMUSG00000039501', u'ENSMUSG00000028233', u'ENSMUSG00000045136', u'ENSMUSG00000051378', u'ENSMUSG00000031885', u'ENSMUSG00000078773', u'ENSMUSG00000027018', u'ENSMUSG00000023067', u'ENSMUSG00000002307', u'ENSMUSG00000021811', u'ENSMUSG00000032218', u'ENSMUSG00000056895', u'ENSMUSG00000048922', u'ENSMUSG00000036986', u'ENSMUSG00000019214', u'ENSMUSG00000020534', u'ENSMUSG00000002870', u'ENSMUSG00000022960', u'ENSMUSG00000069308', u'ENSMUSG00000028809', u'ENSMUSG00000037868', u'ENSMUSG00000047534', u'ENSMUSG00000054072', u'ENSMUSG00000069300', u'ENSMUSG00000069301', u'ENSMUSG00000069302', u'ENSMUSG00000028896', u'ENSMUSG00000028893', u'ENSMUSG00000041846', u'ENSMUSG00000005370', u'ENSMUSG00000024991', u'ENSMUSG00000034218', u'ENSMUSG00000020212', u'ENSMUSG00000027242', u'ENSMUSG00000029414', u'ENSMUSG00000032661', u'ENSMUSG00000070034', u'ENSMUSG00000033762', u'ENSMUSG00000024833', u'ENSMUSG00000000028', u'ENSMUSG00000041238', u'ENSMUSG00000020914', u'ENSMUSG00000027331', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000020493', u'ENSMUSG00000020290', u'ENSMUSG00000024660', u'ENSMUSG00000037214', u'ENSMUSG00000052798', u'ENSMUSG00000040599', u'ENSMUSG00000028382', u'ENSMUSG00000031938', u'ENSMUSG00000027752', u'ENSMUSG00000019773', u'ENSMUSG00000049401', u'ENSMUSG00000003824', u'ENSMUSG00000067455', u'ENSMUSG00000031756', u'ENSMUSG00000006418', u'ENSMUSG00000044702', u'ENSMUSG00000049539', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000061607', u'ENSMUSG00000018899', u'ENSMUSG00000039813', u'ENSMUSG00000026873', u'ENSMUSG00000058729', u'ENSMUSG00000017499', u'ENSMUSG00000001228', u'ENSMUSG00000029177', u'ENSMUSG00000033222', u'ENSMUSG00000029910', u'ENSMUSG00000036202', u'ENSMUSG00000005233', u'ENSMUSG00000064288', u'ENSMUSG00000022945', u'ENSMUSG00000058385', u'ENSMUSG00000046295', u'ENSMUSG00000038507', u'ENSMUSG00000002297', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000042699', u'ENSMUSG00000059552', u'ENSMUSG00000020380', u'ENSMUSG00000042606', u'ENSMUSG00000028587', u'ENSMUSG00000027379', u'ENSMUSG00000020599', u'ENSMUSG00000042167', u'ENSMUSG00000034329', u'ENSMUSG00000025758', u'ENSMUSG00000039748', u'ENSMUSG00000029521', u'ENSMUSG00000020185', u'ENSMUSG00000020184', u'ENSMUSG00000002068', u'ENSMUSG00000005566', u'ENSMUSG00000042029', u'ENSMUSG00000068245', u'ENSMUSG00000027715', u'ENSMUSG00000027306', u'ENSMUSG00000072082', u'ENSMUSG00000026622', u'ENSMUSG00000016477', u'ENSMUSG00000024056', u'ENSMUSG00000034023', u'ENSMUSG00000055760', u'ENSMUSG00000045102', u'ENSMUSG00000004642', u'ENSMUSG00000032397', u'ENSMUSG00000026536', u'ENSMUSG00000023015', u'ENSMUSG00000033970', u'ENSMUSG00000032409', u'ENSMUSG00000022906', u'ENSMUSG00000055612', u'ENSMUSG00000027433', u'ENSMUSG00000036992', u'ENSMUSG00000020525', u'ENSMUSG00000031629', u'ENSMUSG00000041431', u'ENSMUSG00000040734', u'ENSMUSG00000032477', u'ENSMUSG00000036097', u'ENSMUSG00000022673', u'ENSMUSG00000006585', u'ENSMUSG00000079553', u'ENSMUSG00000069310', u'ENSMUSG00000036928', u'ENSMUSG00000058773', u'ENSMUSG00000038943', u'ENSMUSG00000031821', u'ENSMUSG00000029363', u'ENSMUSG00000054115', u'ENSMUSG00000034206', u'ENSMUSG00000041133', u'ENSMUSG00000017550', u'ENSMUSG00000040195', u'ENSMUSG00000026669', u'ENSMUSG00000005481', u'ENSMUSG00000025001', u'ENSMUSG00000028560', u'ENSMUSG00000046179', u'ENSMUSG00000025647', u'ENSMUSG00000005413', u'ENSMUSG00000005410', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000000037', u'ENSMUSG00000061482', u'ENSMUSG00000040350', u'ENSMUSG00000069268', u'ENSMUSG00000028282', u'ENSMUSG00000041859', u'ENSMUSG00000068101', u'ENSMUSG00000041827', u'ENSMUSG00000028911', u'ENSMUSG00000056394', u'ENSMUSG00000020773', u'ENSMUSG00000002748', u'ENSMUSG00000025134', u'ENSMUSG00000038644', u'ENSMUSG00000028211', u'ENSMUSG00000069910', u'ENSMUSG00000028212', u'ENSMUSG00000054717', u'ENSMUSG00000030346', u'ENSMUSG00000074476', u'ENSMUSG00000073705', u'ENSMUSG00000031669', u'ENSMUSG00000019303', u'ENSMUSG00000004356', u'ENSMUSG00000019979', u'ENSMUSG00000002325', u'ENSMUSG00000017716', u'ENSMUSG00000019874', u'ENSMUSG00000049502', u'ENSMUSG00000031697', u'ENSMUSG00000044783', u'ENSMUSG00000001103', u'ENSMUSG00000027323', u'ENSMUSG00000031262', u'ENSMUSG00000038252', u'ENSMUSG00000045328', u'ENSMUSG00000029201', u'ENSMUSG00000022360', u'ENSMUSG00000006930', u'ENSMUSG00000017548', u'ENSMUSG00000025507', u'ENSMUSG00000017861', u'ENSMUSG00000039456', u'ENSMUSG00000039356', u'ENSMUSG00000025912', u'ENSMUSG00000062510', u'ENSMUSG00000039236', u'ENSMUSG00000039238', u'ENSMUSG00000001855', u'ENSMUSG00000027496', u'ENSMUSG00000027490', u'ENSMUSG00000036875', u'ENSMUSG00000021115', u'ENSMUSG00000063021', u'ENSMUSG00000023908', u'ENSMUSG00000034906', u'ENSMUSG00000028551', u'ENSMUSG00000020841', u'ENSMUSG00000035842', u'ENSMUSG00000049932', u'ENSMUSG00000052684', u'ENSMUSG00000036678', u'ENSMUSG00000035683', u'ENSMUSG00000037544', u'ENSMUSG00000030042', u'ENSMUSG00000035293', u'ENSMUSG00000034422', u'ENSMUSG00000027641', u'ENSMUSG00000034349', u'ENSMUSG00000030867', u'ENSMUSG00000041498', u'ENSMUSG00000027342', u'ENSMUSG00000028312', u'ENSMUSG00000031311', u'ENSMUSG00000071646', u'ENSMUSG00000026683', u'ENSMUSG00000022142', u'ENSMUSG00000040034', u'ENSMUSG00000040033', u'ENSMUSG00000060093', u'ENSMUSG00000022021', u'ENSMUSG00000026039', u'ENSMUSG00000038774', u'ENSMUSG00000090272', u'ENSMUSG00000033364', u'ENSMUSG00000006715', u'ENSMUSG00000036086', u'ENSMUSG00000032508', u'ENSMUSG00000039994', u'ENSMUSG00000026355', u'ENSMUSG00000024742', u'ENSMUSG00000078486', u'ENSMUSG00000027699', u'ENSMUSG00000075031', u'ENSMUSG00000035365', u'ENSMUSG00000027514', u'ENSMUSG00000068855', u'ENSMUSG00000020898', u'ENSMUSG00000058290', u'ENSMUSG00000020897', u'ENSMUSG00000010358', u'ENSMUSG00000025498', u'ENSMUSG00000028873', u'ENSMUSG00000047246', u'ENSMUSG00000028702', u'ENSMUSG00000027109', u'ENSMUSG00000020471', u'ENSMUSG00000027454', u'ENSMUSG00000029472', u'ENSMUSG00000023940', u'ENSMUSG00000037188', u'ENSMUSG00000030641', u'ENSMUSG00000028678', u'ENSMUSG00000030726', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000038482', u'ENSMUSG00000033732', u'ENSMUSG00000005470', u'ENSMUSG00000030107', u'ENSMUSG00000031527', u'ENSMUSG00000020808', u'ENSMUSG00000026274', u'ENSMUSG00000016984', u'ENSMUSG00000035024', u'ENSMUSG00000020608', u'ENSMUSG00000023994', u'ENSMUSG00000028224', u'ENSMUSG00000024097', u'ENSMUSG00000024079', u'ENSMUSG00000040483', u'ENSMUSG00000062727', u'ENSMUSG00000071516', u'ENSMUSG00000052833', u'ENSMUSG00000031353', u'ENSMUSG00000044934', u'ENSMUSG00000019961', u'ENSMUSG00000033952', u'ENSMUSG00000026104', u'ENSMUSG00000041147', u'ENSMUSG00000026955', u'ENSMUSG00000009628', u'ENSMUSG00000026896', u'ENSMUSG00000032555', u'ENSMUSG00000032254', u'ENSMUSG00000024472', u'ENSMUSG00000021485', u'ENSMUSG00000029283', u'ENSMUSG00000020326', u'ENSMUSG00000032815', u'ENSMUSG00000031004', u'ENSMUSG00000018983', u'ENSMUSG00000029730', u'ENSMUSG00000024691', u'ENSMUSG00000001517', u'ENSMUSG00000038685', u'ENSMUSG00000024912', u'ENSMUSG00000030677', u'ENSMUSG00000028884', u'ENSMUSG00000030609', u'ENSMUSG00000069793', u'ENSMUSG00000024590', u'ENSMUSG00000027968', u'ENSMUSG00000030786', u'ENSMUSG00000004099', u'ENSMUSG00000045751', u'ENSMUSG00000027580', u'ENSMUSG00000008976', u'ENSMUSG00000051768', u'ENSMUSG00000037572', u'ENSMUSG00000037474', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000021377', u'ENSMUSG00000052565', u'ENSMUSG00000035455', u'ENSMUSG00000042489', u'ENSMUSG00000026605', u'ENSMUSG00000000386', u'ENSMUSG00000032586', u'ENSMUSG00000074151', u'ENSMUSG00000039997', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000026196', u'ENSMUSG00000030254', u'ENSMUSG00000030528', u'ENSMUSG00000042557', u'ENSMUSG00000039187', u'ENSMUSG00000069272', u'ENSMUSG00000022034', u'ENSMUSG00000022033', u'ENSMUSG00000045273', u'ENSMUSG00000040204', u'ENSMUSG00000022881', u'ENSMUSG00000051235', u'ENSMUSG00000007589', u'ENSMUSG00000061991', u'ENSMUSG00000002221', u'ENSMUSG00000001123', u'ENSMUSG00000061615', u'ENSMUSG00000074403', u'ENSMUSG00000035310', u'ENSMUSG00000024795', u'ENSMUSG00000002835', u'ENSMUSG00000020889', u'ENSMUSG00000023852', u'ENSMUSG00000022814', u'ENSMUSG00000027115', u'ENSMUSG00000036822', u'ENSMUSG00000028693', u'ENSMUSG00000035958', u'ENSMUSG00000029580', u'ENSMUSG00000023953', u'ENSMUSG00000034311', u'ENSMUSG00000042439', u'ENSMUSG00000025747', u'ENSMUSG00000027361', u'ENSMUSG00000021175']), pop_n=13836, pop_count=4685, pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000026027', u'ENSMUSG00000028187', u'ENSMUSG00000028180', u'ENSMUSG00000031374', u'ENSMUSG00000020190', u'ENSMUSG00000020196', u'ENSMUSG00000006005', u'ENSMUSG00000026021', u'ENSMUSG00000004895', u'ENSMUSG00000028430', u'ENSMUSG00000004897', u'ENSMUSG00000028344', u'ENSMUSG00000028341', u'ENSMUSG00000038895', u'ENSMUSG00000061315', u'ENSMUSG00000033510', u'ENSMUSG00000018377', u'ENSMUSG00000047907', u'ENSMUSG00000034957', u'ENSMUSG00000033106', u'ENSMUSG00000062929', u'ENSMUSG00000047246', u'ENSMUSG00000020755', u'ENSMUSG00000020752', u'ENSMUSG00000045482', u'ENSMUSG00000038550', u'ENSMUSG00000020758', u'ENSMUSG00000053192', u'ENSMUSG00000023883', u'ENSMUSG00000056493', u'ENSMUSG00000073888', u'ENSMUSG00000069833', u'ENSMUSG00000021714', u'ENSMUSG00000033862', u'ENSMUSG00000033863', u'ENSMUSG00000062101', u'ENSMUSG00000028233', u'ENSMUSG00000049892', u'ENSMUSG00000024042', u'ENSMUSG00000026430', u'ENSMUSG00000051985', u'ENSMUSG00000024045', u'ENSMUSG00000023927', u'ENSMUSG00000026484', u'ENSMUSG00000042487', u'ENSMUSG00000061882', u'ENSMUSG00000038332', u'ENSMUSG00000053581', u'ENSMUSG00000002504', u'ENSMUSG00000059981', u'ENSMUSG00000002496', u'ENSMUSG00000008690', u'ENSMUSG00000044533', u'ENSMUSG00000046269', u'ENSMUSG00000025384', u'ENSMUSG00000052456', u'ENSMUSG00000032020', u'ENSMUSG00000035048', u'ENSMUSG00000035049', u'ENSMUSG00000045827', u'ENSMUSG00000028345', u'ENSMUSG00000032026', u'ENSMUSG00000002307', u'ENSMUSG00000037761', u'ENSMUSG00000054679', u'ENSMUSG00000053453', u'ENSMUSG00000021810', u'ENSMUSG00000021811', u'ENSMUSG00000004947', u'ENSMUSG00000002658', u'ENSMUSG00000001472', u'ENSMUSG00000001473', u'ENSMUSG00000001786', u'ENSMUSG00000020364', u'ENSMUSG00000001785', u'ENSMUSG00000020361', u'ENSMUSG00000001783', u'ENSMUSG00000018196', u'ENSMUSG00000018199', u'ENSMUSG00000039717', u'ENSMUSG00000091405', u'ENSMUSG00000046691', u'ENSMUSG00000055612', u'ENSMUSG00000015461', u'ENSMUSG00000018209', u'ENSMUSG00000030610', u'ENSMUSG00000002870', u'ENSMUSG00000015468', u'ENSMUSG00000033318', u'ENSMUSG00000026563', u'ENSMUSG00000019828', u'ENSMUSG00000032249', u'ENSMUSG00000062040', u'ENSMUSG00000027109', u'ENSMUSG00000032244', u'ENSMUSG00000024446', u'ENSMUSG00000019826', u'ENSMUSG00000010554', u'ENSMUSG00000021962', u'ENSMUSG00000041264', u'ENSMUSG00000041417', u'ENSMUSG00000027274', u'ENSMUSG00000054072', u'ENSMUSG00000042055', u'ENSMUSG00000001270', u'ENSMUSG00000036781', u'ENSMUSG00000005204', u'ENSMUSG00000053134', u'ENSMUSG00000005312', u'ENSMUSG00000060743', u'ENSMUSG00000038393', u'ENSMUSG00000038473', u'ENSMUSG00000040613', u'ENSMUSG00000044066', u'ENSMUSG00000010376', u'ENSMUSG00000044068', u'ENSMUSG00000030660', u'ENSMUSG00000030662', u'ENSMUSG00000028821', u'ENSMUSG00000068882', u'ENSMUSG00000054452', u'ENSMUSG00000021585', u'ENSMUSG00000000787', u'ENSMUSG00000036941', u'ENSMUSG00000005373', u'ENSMUSG00000001098', u'ENSMUSG00000010080', u'ENSMUSG00000047844', u'ENSMUSG00000010086', u'ENSMUSG00000033365', u'ENSMUSG00000024991', u'ENSMUSG00000020211', u'ENSMUSG00000027245', u'ENSMUSG00000005378', u'ENSMUSG00000027243', u'ENSMUSG00000020962', u'ENSMUSG00000041124', u'ENSMUSG00000024999', u'ENSMUSG00000063108', u'ENSMUSG00000076441', u'ENSMUSG00000001891', u'ENSMUSG00000036120', u'ENSMUSG00000030795', u'ENSMUSG00000060639', u'ENSMUSG00000030796', u'ENSMUSG00000030793', u'ENSMUSG00000038784', u'ENSMUSG00000020982', u'ENSMUSG00000030409', u'ENSMUSG00000022634', u'ENSMUSG00000037364', u'ENSMUSG00000050751', u'ENSMUSG00000037361', u'ENSMUSG00000020525', u'ENSMUSG00000010175', u'ENSMUSG00000024537', u'ENSMUSG00000041238', u'ENSMUSG00000030067', u'ENSMUSG00000037958', u'ENSMUSG00000041235', u'ENSMUSG00000004151', u'ENSMUSG00000030061', u'ENSMUSG00000041231', u'ENSMUSG00000026208', u'ENSMUSG00000026209', u'ENSMUSG00000027331', u'ENSMUSG00000027330', u'ENSMUSG00000005150', u'ENSMUSG00000030880', u'ENSMUSG00000026750', u'ENSMUSG00000015605', u'ENSMUSG00000026204', u'ENSMUSG00000026207', u'ENSMUSG00000034686', u'ENSMUSG00000030087', u'ENSMUSG00000055435', u'ENSMUSG00000037110', u'ENSMUSG00000059213', u'ENSMUSG00000055430', u'ENSMUSG00000003235', u'ENSMUSG00000055839', u'ENSMUSG00000030533', u'ENSMUSG00000056749', u'ENSMUSG00000030243', u'ENSMUSG00000037214', u'ENSMUSG00000030536', u'ENSMUSG00000030538', u'ENSMUSG00000042354', u'ENSMUSG00000044636', u'ENSMUSG00000031429', u'ENSMUSG00000031938', u'ENSMUSG00000027752', u'ENSMUSG00000041346', u'ENSMUSG00000041836', u'ENSMUSG00000041837', u'ENSMUSG00000037674', u'ENSMUSG00000031422', u'ENSMUSG00000031931', u'ENSMUSG00000026111', u'ENSMUSG00000000325', u'ENSMUSG00000031935', u'ENSMUSG00000062312', u'ENSMUSG00000022124', u'ENSMUSG00000058729', u'ENSMUSG00000057421', u'ENSMUSG00000058589', u'ENSMUSG00000037236', u'ENSMUSG00000003824', u'ENSMUSG00000039782', u'ENSMUSG00000046962', u'ENSMUSG00000025872', u'ENSMUSG00000062078', u'ENSMUSG00000062075', u'ENSMUSG00000030330', u'ENSMUSG00000025878', u'ENSMUSG00000063804', u'ENSMUSG00000021366', u'ENSMUSG00000031201', u'ENSMUSG00000021365', u'ENSMUSG00000031756', u'ENSMUSG00000031754', u'ENSMUSG00000027282', u'ENSMUSG00000031758', u'ENSMUSG00000071533', u'ENSMUSG00000023051', u'ENSMUSG00000024165', u'ENSMUSG00000023055', u'ENSMUSG00000022051', u'ENSMUSG00000029004', u'ENSMUSG00000029003', u'ENSMUSG00000031681', u'ENSMUSG00000031683', u'ENSMUSG00000063856', u'ENSMUSG00000033991', u'ENSMUSG00000042903', u'ENSMUSG00000034059', u'ENSMUSG00000026374', u'ENSMUSG00000003226', u'ENSMUSG00000022698', u'ENSMUSG00000062270', u'ENSMUSG00000003228', u'ENSMUSG00000063506', u'ENSMUSG00000036810', u'ENSMUSG00000045136', u'ENSMUSG00000056167', u'ENSMUSG00000040785', u'ENSMUSG00000036817', u'ENSMUSG00000015087', u'ENSMUSG00000024925', u'ENSMUSG00000026970', u'ENSMUSG00000006585', u'ENSMUSG00000022673', u'ENSMUSG00000009640', u'ENSMUSG00000022674', u'ENSMUSG00000022677', u'ENSMUSG00000025586', u'ENSMUSG00000028756', u'ENSMUSG00000025580', u'ENSMUSG00000029173', u'ENSMUSG00000039405', u'ENSMUSG00000029177', u'ENSMUSG00000003644', u'ENSMUSG00000029174', u'ENSMUSG00000034544', u'ENSMUSG00000025470', u'ENSMUSG00000029178', u'ENSMUSG00000029911', u'ENSMUSG00000029910', u'ENSMUSG00000012483', u'ENSMUSG00000034543', u'ENSMUSG00000025278', u'ENSMUSG00000037112', u'ENSMUSG00000025909', u'ENSMUSG00000048612', u'ENSMUSG00000025902', u'ENSMUSG00000025272', u'ENSMUSG00000069310', u'ENSMUSG00000025907', u'ENSMUSG00000026803', u'ENSMUSG00000061517', u'ENSMUSG00000037111', u'ENSMUSG00000026806', u'ENSMUSG00000039220', u'ENSMUSG00000046295', u'ENSMUSG00000048351', u'ENSMUSG00000029757', u'ENSMUSG00000035277', u'ENSMUSG00000045039', u'ENSMUSG00000029754', u'ENSMUSG00000029599', u'ENSMUSG00000020694', u'ENSMUSG00000020697', u'ENSMUSG00000047989', u'ENSMUSG00000030726', u'ENSMUSG00000020692', u'ENSMUSG00000029591', u'ENSMUSG00000029594', u'ENSMUSG00000015290', u'ENSMUSG00000022475', u'ENSMUSG00000070283', u'ENSMUSG00000022472', u'ENSMUSG00000022471', u'ENSMUSG00000041747', u'ENSMUSG00000025616', u'ENSMUSG00000052917', u'ENSMUSG00000025612', u'ENSMUSG00000029359', u'ENSMUSG00000016253', u'ENSMUSG00000042606', u'ENSMUSG00000034321', u'ENSMUSG00000052533', u'ENSMUSG00000021109', u'ENSMUSG00000027351', u'ENSMUSG00000021102', u'ENSMUSG00000021103', u'ENSMUSG00000042608', u'ENSMUSG00000035236', u'ENSMUSG00000020189', u'ENSMUSG00000041740', u'ENSMUSG00000020181', u'ENSMUSG00000020180', u'ENSMUSG00000032492', u'ENSMUSG00000060032', u'ENSMUSG00000020185', u'ENSMUSG00000020184', u'ENSMUSG00000002068', u'ENSMUSG00000020186', u'ENSMUSG00000073016', u'ENSMUSG00000043510', u'ENSMUSG00000045038', u'ENSMUSG00000038884', u'ENSMUSG00000042029', u'ENSMUSG00000045034', u'ENSMUSG00000018697', u'ENSMUSG00000018347', u'ENSMUSG00000018340', u'ENSMUSG00000028409', u'ENSMUSG00000068245', u'ENSMUSG00000025050', u'ENSMUSG00000022521', u'ENSMUSG00000068335', u'ENSMUSG00000034430', u'ENSMUSG00000034432', u'ENSMUSG00000020799', u'ENSMUSG00000035125', u'ENSMUSG00000025059', u'ENSMUSG00000066798', u'ENSMUSG00000061286', u'ENSMUSG00000029715', u'ENSMUSG00000007836', u'ENSMUSG00000032309', u'ENSMUSG00000032316', u'ENSMUSG00000050919', u'ENSMUSG00000021615', u'ENSMUSG00000020743', u'ENSMUSG00000032301', u'ENSMUSG00000039130', u'ENSMUSG00000050945', u'ENSMUSG00000059824', u'ENSMUSG00000020745', u'ENSMUSG00000020744', u'ENSMUSG00000048118', u'ENSMUSG00000042292', u'ENSMUSG00000006307', u'ENSMUSG00000028248', u'ENSMUSG00000028249', u'ENSMUSG00000021576', u'ENSMUSG00000017299', u'ENSMUSG00000021573', u'ENSMUSG00000024052', u'ENSMUSG00000024050', u'ENSMUSG00000029249', u'ENSMUSG00000045102', u'ENSMUSG00000042331', u'ENSMUSG00000044927', u'ENSMUSG00000013997', u'ENSMUSG00000063694', u'ENSMUSG00000034681', u'ENSMUSG00000013465', u'ENSMUSG00000065990', u'ENSMUSG00000003039', u'ENSMUSG00000032411', u'ENSMUSG00000032017', u'ENSMUSG00000032010', u'ENSMUSG00000029363', u'ENSMUSG00000021779', u'ENSMUSG00000044857', u'ENSMUSG00000023980', u'ENSMUSG00000028789', u'ENSMUSG00000032582', u'ENSMUSG00000017724', u'ENSMUSG00000021807', u'ENSMUSG00000004937', u'ENSMUSG00000004934', u'ENSMUSG00000028788', u'ENSMUSG00000021775', u'ENSMUSG00000021774', u'ENSMUSG00000044365', u'ENSMUSG00000020358', u'ENSMUSG00000022906', u'ENSMUSG00000022905', u'ENSMUSG00000073616', u'ENSMUSG00000027430', u'ENSMUSG00000027433', u'ENSMUSG00000027434', u'ENSMUSG00000020357', u'ENSMUSG00000029201', u'ENSMUSG00000020109', u'ENSMUSG00000039917', u'ENSMUSG00000039910', u'ENSMUSG00000078486', u'ENSMUSG00000032419', u'ENSMUSG00000078816', u'ENSMUSG00000002688', u'ENSMUSG00000078812', u'ENSMUSG00000079487', u'ENSMUSG00000043639', u'ENSMUSG00000031590', u'ENSMUSG00000017615', u'ENSMUSG00000024188', u'ENSMUSG00000032475', u'ENSMUSG00000033307', u'ENSMUSG00000021814', u'ENSMUSG00000002205', u'ENSMUSG00000019837', u'ENSMUSG00000024182', u'ENSMUSG00000021973', u'ENSMUSG00000021972', u'ENSMUSG00000032580', u'ENSMUSG00000030451', u'ENSMUSG00000024457', u'ENSMUSG00000021975', u'ENSMUSG00000024454', u'ENSMUSG00000032279', u'ENSMUSG00000074637', u'ENSMUSG00000029629', u'ENSMUSG00000027405', u'ENSMUSG00000050295', u'ENSMUSG00000027404', u'ENSMUSG00000058773', u'ENSMUSG00000041846', u'ENSMUSG00000086503', u'ENSMUSG00000025899', u'ENSMUSG00000041164', u'ENSMUSG00000054648', u'ENSMUSG00000092558', u'ENSMUSG00000019124', u'ENSMUSG00000038467', u'ENSMUSG00000030659', u'ENSMUSG00000036777', u'ENSMUSG00000055067', u'ENSMUSG00000036779', u'ENSMUSG00000022914', u'ENSMUSG00000030652', u'ENSMUSG00000021591', u'ENSMUSG00000055065', u'ENSMUSG00000021595', u'ENSMUSG00000033276', u'ENSMUSG00000021597', u'ENSMUSG00000034206', u'ENSMUSG00000021598', u'ENSMUSG00000020362', u'ENSMUSG00000036371', u'ENSMUSG00000026571', u'ENSMUSG00000067995', u'ENSMUSG00000034422', u'ENSMUSG00000001089', u'ENSMUSG00000024236', u'ENSMUSG00000020228', u'ENSMUSG00000014077', u'ENSMUSG00000014074', u'ENSMUSG00000020224', u'ENSMUSG00000041133', u'ENSMUSG00000037174', u'ENSMUSG00000022876', u'ENSMUSG00000027502', u'ENSMUSG00000033458', u'ENSMUSG00000026278', u'ENSMUSG00000026586', u'ENSMUSG00000016921', u'ENSMUSG00000031527', u'ENSMUSG00000033454', u'ENSMUSG00000038214', u'ENSMUSG00000038797', u'ENSMUSG00000040669', u'ENSMUSG00000037196', u'ENSMUSG00000037197', u'ENSMUSG00000031918', u'ENSMUSG00000047242', u'ENSMUSG00000027298', u'ENSMUSG00000021027', u'ENSMUSG00000033697', u'ENSMUSG00000027180', u'ENSMUSG00000029860', u'ENSMUSG00000024529', u'ENSMUSG00000024528', u'ENSMUSG00000041229', u'ENSMUSG00000027185', u'ENSMUSG00000058248', u'ENSMUSG00000005413', u'ENSMUSG00000005410', u'ENSMUSG00000000131', u'ENSMUSG00000024526', u'ENSMUSG00000000134', u'ENSMUSG00000075266', u'ENSMUSG00000026749', u'ENSMUSG00000030584', u'ENSMUSG00000027613', u'ENSMUSG00000027342', u'ENSMUSG00000034209', u'ENSMUSG00000026219', u'ENSMUSG00000043866', u'ENSMUSG00000027618', u'ENSMUSG00000026740', u'ENSMUSG00000026743', u'ENSMUSG00000074622', u'ENSMUSG00000027678', u'ENSMUSG00000040606', u'ENSMUSG00000027349', u'ENSMUSG00000014402', u'ENSMUSG00000032384', u'ENSMUSG00000027770', u'ENSMUSG00000030852', u'ENSMUSG00000050812', u'ENSMUSG00000040667', u'ENSMUSG00000039929', u'ENSMUSG00000055150', u'ENSMUSG00000074406', u'ENSMUSG00000055409', u'ENSMUSG00000041911', u'ENSMUSG00000031913', u'ENSMUSG00000041827', u'ENSMUSG00000026176', u'ENSMUSG00000039179', u'ENSMUSG00000078789', u'ENSMUSG00000030435', u'ENSMUSG00000059518', u'ENSMUSG00000027763', u'ENSMUSG00000031921', u'ENSMUSG00000027981', u'ENSMUSG00000071637', u'ENSMUSG00000031434', u'ENSMUSG00000031925', u'ENSMUSG00000027985', u'ENSMUSG00000031431', u'ENSMUSG00000055302', u'ENSMUSG00000038648', u'ENSMUSG00000026107', u'ENSMUSG00000058594', u'ENSMUSG00000026104', u'ENSMUSG00000003814', u'ENSMUSG00000022111', u'ENSMUSG00000022114', u'ENSMUSG00000038646', u'ENSMUSG00000073491', u'ENSMUSG00000004328', u'ENSMUSG00000048756', u'ENSMUSG00000046591', u'ENSMUSG00000000916', u'ENSMUSG00000025860', u'ENSMUSG00000025862', u'ENSMUSG00000030346', u'ENSMUSG00000027968', u'ENSMUSG00000034154', u'ENSMUSG00000025869', u'ENSMUSG00000035623', u'ENSMUSG00000030341', u'ENSMUSG00000031217', u'ENSMUSG00000026077', u'ENSMUSG00000021377', u'ENSMUSG00000054939', u'ENSMUSG00000046785', u'ENSMUSG00000040270', u'ENSMUSG00000029404', u'ENSMUSG00000021379', u'ENSMUSG00000023043', u'ENSMUSG00000031320', u'ENSMUSG00000026565', u'ENSMUSG00000040174', u'ENSMUSG00000022064', u'ENSMUSG00000023048', u'ENSMUSG00000031328', u'ENSMUSG00000060862', u'ENSMUSG00000060860', u'ENSMUSG00000031858', u'ENSMUSG00000026365', u'ENSMUSG00000029563', u'ENSMUSG00000031697', u'ENSMUSG00000026361', u'ENSMUSG00000026360', u'ENSMUSG00000026179', u'ENSMUSG00000034800', u'ENSMUSG00000071337', u'ENSMUSG00000057895', u'ENSMUSG00000060073', u'ENSMUSG00000055531', u'ENSMUSG00000042854', u'ENSMUSG00000026965', u'ENSMUSG00000035621', u'ENSMUSG00000031101', u'ENSMUSG00000026966', u'ENSMUSG00000034007', u'ENSMUSG00000038256', u'ENSMUSG00000024193', u'ENSMUSG00000020516', u'ENSMUSG00000020515', u'ENSMUSG00000024190', u'ENSMUSG00000009630', u'ENSMUSG00000061482', u'ENSMUSG00000029610', u'ENSMUSG00000052776', u'ENSMUSG00000025591', u'ENSMUSG00000046351', u'ENSMUSG00000029614', u'ENSMUSG00000020519', u'ENSMUSG00000029106', u'ENSMUSG00000029104', u'ENSMUSG00000043079', u'ENSMUSG00000034088', u'ENSMUSG00000029101', u'ENSMUSG00000047514', u'ENSMUSG00000049751', u'ENSMUSG00000037868', u'ENSMUSG00000034083', u'ENSMUSG00000046179', u'ENSMUSG00000022240', u'ENSMUSG00000034551', u'ENSMUSG00000022246', u'ENSMUSG00000022247', u'ENSMUSG00000022248', u'ENSMUSG00000025266', u'ENSMUSG00000039354', u'ENSMUSG00000025264', u'ENSMUSG00000025262', u'ENSMUSG00000025261', u'ENSMUSG00000030970', u'ENSMUSG00000026812', u'ENSMUSG00000039231', u'ENSMUSG00000031732', u'ENSMUSG00000064037', u'ENSMUSG00000026816', u'ENSMUSG00000009741', u'ENSMUSG00000042589', u'ENSMUSG00000020427', u'ENSMUSG00000011831', u'ENSMUSG00000020044', u'ENSMUSG00000049422', u'ENSMUSG00000011837', u'ENSMUSG00000025289', u'ENSMUSG00000037860', u'ENSMUSG00000062797', u'ENSMUSG00000051062', u'ENSMUSG00000028741', u'ENSMUSG00000022489', u'ENSMUSG00000047205', u'ENSMUSG00000046550', u'ENSMUSG00000040483', u'ENSMUSG00000033847', u'ENSMUSG00000025602', u'ENSMUSG00000045763', u'ENSMUSG00000006763', u'ENSMUSG00000023572', u'ENSMUSG00000034333', u'ENSMUSG00000042613', u'ENSMUSG00000048481', u'ENSMUSG00000021115', u'ENSMUSG00000005897', u'ENSMUSG00000021116', u'ENSMUSG00000021111', u'ENSMUSG00000005893', u'ENSMUSG00000021113', u'ENSMUSG00000026094', u'ENSMUSG00000029430', u'ENSMUSG00000063439', u'ENSMUSG00000009569', u'ENSMUSG00000037992', u'ENSMUSG00000029439', u'ENSMUSG00000053279', u'ENSMUSG00000009291', u'ENSMUSG00000032481', u'ENSMUSG00000028419', u'ENSMUSG00000025138', u'ENSMUSG00000062937', u'ENSMUSG00000025133', u'ENSMUSG00000025132', u'ENSMUSG00000028411', u'ENSMUSG00000028410', u'ENSMUSG00000008348', u'ENSMUSG00000025135', u'ENSMUSG00000025134', u'ENSMUSG00000025047', u'ENSMUSG00000035576', u'ENSMUSG00000028525', u'ENSMUSG00000025732', u'ENSMUSG00000028522', u'ENSMUSG00000035686', u'ENSMUSG00000067713', u'ENSMUSG00000031671', u'ENSMUSG00000069255', u'ENSMUSG00000045733', u'ENSMUSG00000025049', u'ENSMUSG00000045730', u'ENSMUSG00000035575', u'ENSMUSG00000035443', u'ENSMUSG00000020738', u'ENSMUSG00000020739', u'ENSMUSG00000020736', u'ENSMUSG00000020737', u'ENSMUSG00000029053', u'ENSMUSG00000018750', u'ENSMUSG00000026554', u'ENSMUSG00000001415', u'ENSMUSG00000031357', u'ENSMUSG00000026723', u'ENSMUSG00000014243', u'ENSMUSG00000028960', u'ENSMUSG00000063445', u'ENSMUSG00000001418', u'ENSMUSG00000001419', u'ENSMUSG00000042323', u'ENSMUSG00000063689', u'ENSMUSG00000078765', u'ENSMUSG00000054237', u'ENSMUSG00000044519', u'ENSMUSG00000040167', u'ENSMUSG00000035062', u'ENSMUSG00000039275', u'ENSMUSG00000051469', u'ENSMUSG00000002477', u'ENSMUSG00000032000', u'ENSMUSG00000021748', u'ENSMUSG00000020647', u'ENSMUSG00000002679', u'ENSMUSG00000091931', u'ENSMUSG00000053477', u'ENSMUSG00000023991', u'ENSMUSG00000023990', u'ENSMUSG00000023994', u'ENSMUSG00000026222', u'ENSMUSG00000029538', u'ENSMUSG00000020349', u'ENSMUSG00000027428', u'ENSMUSG00000027427', u'ENSMUSG00000027425', u'ENSMUSG00000020340', u'ENSMUSG00000070520', u'ENSMUSG00000019338', u'ENSMUSG00000062647', u'ENSMUSG00000018537', u'ENSMUSG00000017376', u'ENSMUSG00000032462', u'ENSMUSG00000053877', u'ENSMUSG00000036282', u'ENSMUSG00000049516', u'ENSMUSG00000032469', u'ENSMUSG00000036167', u'ENSMUSG00000036160', u'ENSMUSG00000071636', u'ENSMUSG00000019803', u'ENSMUSG00000032267', u'ENSMUSG00000051413', u'ENSMUSG00000021905', u'ENSMUSG00000060261', u'ENSMUSG00000024420', u'ENSMUSG00000021901', u'ENSMUSG00000054051', u'ENSMUSG00000001520', u'ENSMUSG00000001521', u'ENSMUSG00000059923', u'ENSMUSG00000001524', u'ENSMUSG00000001525', u'ENSMUSG00000020232', u'ENSMUSG00000005087', u'ENSMUSG00000020230', u'ENSMUSG00000063063', u'ENSMUSG00000058298', u'ENSMUSG00000027514', u'ENSMUSG00000037029', u'ENSMUSG00000058290', u'ENSMUSG00000014668', u'ENSMUSG00000038416', u'ENSMUSG00000043987', u'ENSMUSG00000010358', u'ENSMUSG00000038412', u'ENSMUSG00000006998', u'ENSMUSG00000036748', u'ENSMUSG00000074923', u'ENSMUSG00000038418', u'ENSMUSG00000078945', u'ENSMUSG00000044641', u'ENSMUSG00000074818', u'ENSMUSG00000024087', u'ENSMUSG00000024081', u'ENSMUSG00000044647', u'ENSMUSG00000024732', u'ENSMUSG00000054434', u'ENSMUSG00000001632', u'ENSMUSG00000070390', u'ENSMUSG00000033208', u'ENSMUSG00000024735', u'ENSMUSG00000026914', u'ENSMUSG00000063663', u'ENSMUSG00000031818', u'ENSMUSG00000067274', u'ENSMUSG00000037169', u'ENSMUSG00000015599', u'ENSMUSG00000015597', u'ENSMUSG00000029729', u'ENSMUSG00000063511', u'ENSMUSG00000030946', u'ENSMUSG00000022800', u'ENSMUSG00000049232', u'ENSMUSG00000019794', u'ENSMUSG00000090272', u'ENSMUSG00000040183', u'ENSMUSG00000019791', u'ENSMUSG00000062931', u'ENSMUSG00000055980', u'ENSMUSG00000024952', u'ENSMUSG00000024953', u'ENSMUSG00000027288', u'ENSMUSG00000037149', u'ENSMUSG00000024955', u'ENSMUSG00000005534', u'ENSMUSG00000038305', u'ENSMUSG00000005533', u'ENSMUSG00000027284', u'ENSMUSG00000024220', u'ENSMUSG00000030641', u'ENSMUSG00000001741', u'ENSMUSG00000027193', u'ENSMUSG00000024558', u'ENSMUSG00000000693', u'ENSMUSG00000050600', u'ENSMUSG00000005371', u'ENSMUSG00000000127', u'ENSMUSG00000036585', u'ENSMUSG00000026029', u'ENSMUSG00000005370', u'ENSMUSG00000026778', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000063049', u'ENSMUSG00000063550', u'ENSMUSG00000027133', u'ENSMUSG00000026771', u'ENSMUSG00000033732', u'ENSMUSG00000045078', u'ENSMUSG00000011114', u'ENSMUSG00000063273', u'ENSMUSG00000027248', u'ENSMUSG00000058638', u'ENSMUSG00000028910', u'ENSMUSG00000005621', u'ENSMUSG00000017999', u'ENSMUSG00000068205', u'ENSMUSG00000005625', u'ENSMUSG00000041966', u'ENSMUSG00000030512', u'ENSMUSG00000030516', u'ENSMUSG00000037235', u'ENSMUSG00000032688', u'ENSMUSG00000020212', u'ENSMUSG00000030423', u'ENSMUSG00000042572', u'ENSMUSG00000030421', u'ENSMUSG00000027998', u'ENSMUSG00000027997', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000000346', u'ENSMUSG00000004044', u'ENSMUSG00000027242', u'ENSMUSG00000023456', u'ENSMUSG00000026174', u'ENSMUSG00000021196', u'ENSMUSG00000023452', u'ENSMUSG00000026173', u'ENSMUSG00000022109', u'ENSMUSG00000026171', u'ENSMUSG00000022105', u'ENSMUSG00000059689', u'ENSMUSG00000022100', u'ENSMUSG00000015053', u'ENSMUSG00000073062', u'ENSMUSG00000000902', u'ENSMUSG00000030357', u'ENSMUSG00000045751', u'ENSMUSG00000036432', u'ENSMUSG00000031774', u'ENSMUSG00000031776', u'ENSMUSG00000004661', u'ENSMUSG00000004667', u'ENSMUSG00000036390', u'ENSMUSG00000042472', u'ENSMUSG00000014980', u'ENSMUSG00000023074', u'ENSMUSG00000023075', u'ENSMUSG00000071516', u'ENSMUSG00000072235', u'ENSMUSG00000035365', u'ENSMUSG00000031353', u'ENSMUSG00000004268', u'ENSMUSG00000050965', u'ENSMUSG00000004266', u'ENSMUSG00000014873', u'ENSMUSG00000004264', u'ENSMUSG00000041605', u'ENSMUSG00000051390', u'ENSMUSG00000023079', u'ENSMUSG00000031358', u'ENSMUSG00000040767', u'ENSMUSG00000066232', u'ENSMUSG00000038740', u'ENSMUSG00000052997', u'ENSMUSG00000041974', u'ENSMUSG00000040761', u'ENSMUSG00000040760', u'ENSMUSG00000063870', u'ENSMUSG00000026393', u'ENSMUSG00000011752', u'ENSMUSG00000039697', u'ENSMUSG00000042826', u'ENSMUSG00000040712', u'ENSMUSG00000032355', u'ENSMUSG00000038248', u'ENSMUSG00000031176', u'ENSMUSG00000038244', u'ENSMUSG00000075705', u'ENSMUSG00000009995', u'ENSMUSG00000022658', u'ENSMUSG00000003068', u'ENSMUSG00000063895', u'ENSMUSG00000029600', u'ENSMUSG00000029603', u'ENSMUSG00000057706', u'ENSMUSG00000009628', u'ENSMUSG00000047777', u'ENSMUSG00000070866', u'ENSMUSG00000004460', u'ENSMUSG00000029111', u'ENSMUSG00000029110', u'ENSMUSG00000024830', u'ENSMUSG00000043061', u'ENSMUSG00000003660', u'ENSMUSG00000072082', u'ENSMUSG00000037608', u'ENSMUSG00000057367', u'ENSMUSG00000022255', u'ENSMUSG00000034525', u'ENSMUSG00000034522', u'ENSMUSG00000029283', u'ENSMUSG00000043668', u'ENSMUSG00000039345', u'ENSMUSG00000025925', u'ENSMUSG00000025920', u'ENSMUSG00000031189', u'ENSMUSG00000050697', u'ENSMUSG00000028211', u'ENSMUSG00000026826', u'ENSMUSG00000013662', u'ENSMUSG00000013663', u'ENSMUSG00000031004', u'ENSMUSG00000021127', u'ENSMUSG00000020431', u'ENSMUSG00000020430', u'ENSMUSG00000029730', u'ENSMUSG00000039206', u'ENSMUSG00000029833', u'ENSMUSG00000057147', u'ENSMUSG00000045215', u'ENSMUSG00000015839', u'ENSMUSG00000057637', u'ENSMUSG00000039656', u'ENSMUSG00000003119', u'ENSMUSG00000036281', u'ENSMUSG00000015837', u'ENSMUSG00000028641', u'ENSMUSG00000028646', u'ENSMUSG00000028647', u'ENSMUSG00000060121', u'ENSMUSG00000028214', u'ENSMUSG00000028243', u'ENSMUSG00000028882', u'ENSMUSG00000034639', u'ENSMUSG00000028884', u'ENSMUSG00000028886', u'ENSMUSG00000069793', u'ENSMUSG00000073293', u'ENSMUSG00000043207', u'ENSMUSG00000020018', u'ENSMUSG00000061650', u'ENSMUSG00000030400', u'ENSMUSG00000062309', u'ENSMUSG00000033335', u'ENSMUSG00000043015', u'ENSMUSG00000005886', u'ENSMUSG00000044080', u'ENSMUSG00000042625', u'ENSMUSG00000042626', u'ENSMUSG00000047832', u'ENSMUSG00000079184', u'ENSMUSG00000029427', u'ENSMUSG00000009575', u'ENSMUSG00000059883', u'ENSMUSG00000037984', u'ENSMUSG00000036208', u'ENSMUSG00000008575', u'ENSMUSG00000024068', u'ENSMUSG00000028394', u'ENSMUSG00000025147', u'ENSMUSG00000025144', u'ENSMUSG00000008373', u'ENSMUSG00000025142', u'ENSMUSG00000035585', u'ENSMUSG00000028393', u'ENSMUSG00000008976', u'ENSMUSG00000028089', u'ENSMUSG00000016349', u'ENSMUSG00000043336', u'ENSMUSG00000045903', u'ENSMUSG00000028081', u'ENSMUSG00000034453', u'ENSMUSG00000028086', u'ENSMUSG00000042133', u'ENSMUSG00000035455', u'ENSMUSG00000021635', u'ENSMUSG00000035105', u'ENSMUSG00000035456', u'ENSMUSG00000068696', u'ENSMUSG00000042489', u'ENSMUSG00000052605', u'ENSMUSG00000007812', u'ENSMUSG00000039117', u'ENSMUSG00000020721', u'ENSMUSG00000021639', u'ENSMUSG00000070003', u'ENSMUSG00000007817', u'ENSMUSG00000032586', u'ENSMUSG00000028063', u'ENSMUSG00000028060', u'ENSMUSG00000021750', u'ENSMUSG00000028066', u'ENSMUSG00000035273', u'ENSMUSG00000001403', u'ENSMUSG00000006362', u'ENSMUSG00000034616', u'ENSMUSG00000045257', u'ENSMUSG00000038331', u'ENSMUSG00000024539', u'ENSMUSG00000042312', u'ENSMUSG00000028268', u'ENSMUSG00000026820', u'ENSMUSG00000013089', u'ENSMUSG00000026821', u'ENSMUSG00000018326', u'ENSMUSG00000027333', u'ENSMUSG00000018322', u'ENSMUSG00000038335', u'ENSMUSG00000030888', u'ENSMUSG00000053644', u'ENSMUSG00000042558', u'ENSMUSG00000053647', u'ENSMUSG00000032077', u'ENSMUSG00000020653', u'ENSMUSG00000020652', u'ENSMUSG00000020654', u'ENSMUSG00000020657', u'ENSMUSG00000020656', u'ENSMUSG00000020659', u'ENSMUSG00000044876', u'ENSMUSG00000031066', u'ENSMUSG00000053411', u'ENSMUSG00000019923', u'ENSMUSG00000036002', u'ENSMUSG00000032078', u'ENSMUSG00000030493', u'ENSMUSG00000031948', u'ENSMUSG00000045273', u'ENSMUSG00000054499', u'ENSMUSG00000039205', u'ENSMUSG00000063787', u'ENSMUSG00000063785', u'ENSMUSG00000042599', u'ENSMUSG00000027339', u'ENSMUSG00000048012', u'ENSMUSG00000036550', u'ENSMUSG00000026203', u'ENSMUSG00000059866', u'ENSMUSG00000044475', u'ENSMUSG00000053801', u'ENSMUSG00000033985', u'ENSMUSG00000032103', u'ENSMUSG00000007589', u'ENSMUSG00000033983', u'ENSMUSG00000070934', u'ENSMUSG00000002996', u'ENSMUSG00000002221', u'ENSMUSG00000002222', u'ENSMUSG00000010505', u'ENSMUSG00000021911', u'ENSMUSG00000019814', u'ENSMUSG00000008398', u'ENSMUSG00000071359', u'ENSMUSG00000006215', u'ENSMUSG00000032297', u'ENSMUSG00000032294', u'ENSMUSG00000020246', u'ENSMUSG00000036057', u'ENSMUSG00000041117', u'ENSMUSG00000075040', u'ENSMUSG00000033610', u'ENSMUSG00000071037', u'ENSMUSG00000019970', u'ENSMUSG00000068329', u'ENSMUSG00000020248', u'ENSMUSG00000019256', u'ENSMUSG00000044098', u'ENSMUSG00000029817', u'ENSMUSG00000038406', u'ENSMUSG00000043991', u'ENSMUSG00000032855', u'ENSMUSG00000039804', u'ENSMUSG00000060126', u'ENSMUSG00000016831', u'ENSMUSG00000019494', u'ENSMUSG00000033216', u'ENSMUSG00000001440', u'ENSMUSG00000036114', u'ENSMUSG00000037754', u'ENSMUSG00000092035', u'ENSMUSG00000024091', u'ENSMUSG00000051234', u'ENSMUSG00000024097', u'ENSMUSG00000024095', u'ENSMUSG00000024726', u'ENSMUSG00000044786', u'ENSMUSG00000020086', u'ENSMUSG00000039623', u'ENSMUSG00000022814', u'ENSMUSG00000049164', u'ENSMUSG00000000751', u'ENSMUSG00000022811', u'ENSMUSG00000063659', u'ENSMUSG00000022812', u'ENSMUSG00000038539', u'ENSMUSG00000038538', u'ENSMUSG00000026761', u'ENSMUSG00000026767', u'ENSMUSG00000022223', u'ENSMUSG00000038530', u'ENSMUSG00000038533', u'ENSMUSG00000038535', u'ENSMUSG00000033430', u'ENSMUSG00000052981', u'ENSMUSG00000024943', u'ENSMUSG00000024944', u'ENSMUSG00000024947', u'ENSMUSG00000021936', u'ENSMUSG00000024949', u'ENSMUSG00000019789', u'ENSMUSG00000059401', u'ENSMUSG00000030744', u'ENSMUSG00000041684', u'ENSMUSG00000030980', u'ENSMUSG00000020396', u'ENSMUSG00000020397', u'ENSMUSG00000020390', u'ENSMUSG00000024548', u'ENSMUSG00000030986', u'ENSMUSG00000027163', u'ENSMUSG00000041343', u'ENSMUSG00000027167', u'ENSMUSG00000027164', u'ENSMUSG00000021932', u'ENSMUSG00000020888', u'ENSMUSG00000020889', u'ENSMUSG00000004127', u'ENSMUSG00000024897', u'ENSMUSG00000044700', u'ENSMUSG00000027361', u'ENSMUSG00000027363', u'ENSMUSG00000034227', u'ENSMUSG00000040372', u'ENSMUSG00000040084', u'ENSMUSG00000026496', u'ENSMUSG00000026491', u'ENSMUSG00000003873', u'ENSMUSG00000033726', u'ENSMUSG00000047757', u'ENSMUSG00000073968', u'ENSMUSG00000039756', u'ENSMUSG00000063268', u'ENSMUSG00000039754', u'ENSMUSG00000021743', u'ENSMUSG00000020863', u'ENSMUSG00000031585', u'ENSMUSG00000030298', u'ENSMUSG00000027387', u'ENSMUSG00000041975', u'ENSMUSG00000035293', u'ENSMUSG00000020869', u'ENSMUSG00000037242', u'ENSMUSG00000030291', u'ENSMUSG00000030189', u'ENSMUSG00000063334', u'ENSMUSG00000005505', u'ENSMUSG00000005506', u'ENSMUSG00000056608', u'ENSMUSG00000030180', u'ENSMUSG00000004056', u'ENSMUSG00000019470', u'ENSMUSG00000031907', u'ENSMUSG00000038628', u'ENSMUSG00000004698', u'ENSMUSG00000015120', u'ENSMUSG00000015127', u'ENSMUSG00000027469', u'ENSMUSG00000038622', u'ENSMUSG00000027944', u'ENSMUSG00000022394', u'ENSMUSG00000049680', u'ENSMUSG00000030166', u'ENSMUSG00000015023', u'ENSMUSG00000046441', u'ENSMUSG00000022391', u'ENSMUSG00000044231', u'ENSMUSG00000059669', u'ENSMUSG00000031540', u'ENSMUSG00000052040', u'ENSMUSG00000003585', u'ENSMUSG00000057551', u'ENSMUSG00000026019', u'ENSMUSG00000047473', u'ENSMUSG00000031347', u'ENSMUSG00000027011', u'ENSMUSG00000027016', u'ENSMUSG00000027014', u'ENSMUSG00000035356', u'ENSMUSG00000027018', u'ENSMUSG00000040687', u'ENSMUSG00000023067', u'ENSMUSG00000026017', u'ENSMUSG00000040521', u'ENSMUSG00000022000', u'ENSMUSG00000026380', u'ENSMUSG00000048170', u'ENSMUSG00000048485', u'ENSMUSG00000026385', u'ENSMUSG00000031930', u'ENSMUSG00000063317', u'ENSMUSG00000022009', u'ENSMUSG00000025932', u'ENSMUSG00000064288', u'ENSMUSG00000042831', u'ENSMUSG00000031168', u'ENSMUSG00000090258', u'ENSMUSG00000061589', u'ENSMUSG00000025939', u'ENSMUSG00000031166', u'ENSMUSG00000031161', u'ENSMUSG00000057130', u'ENSMUSG00000040524', u'ENSMUSG00000020538', u'ENSMUSG00000055660', u'ENSMUSG00000020530', u'ENSMUSG00000029635', u'ENSMUSG00000020534', u'ENSMUSG00000056394', u'ENSMUSG00000047649', u'ENSMUSG00000022718', u'ENSMUSG00000037601', u'ENSMUSG00000043059', u'ENSMUSG00000049577', u'ENSMUSG00000023026', u'ENSMUSG00000022710', u'ENSMUSG00000022711', u'ENSMUSG00000043051', u'ENSMUSG00000029127', u'ENSMUSG00000069308', u'ENSMUSG00000023852', u'ENSMUSG00000049775', u'ENSMUSG00000047534', u'ENSMUSG00000021285', u'ENSMUSG00000069301', u'ENSMUSG00000021287', u'ENSMUSG00000038507', u'ENSMUSG00000015337', u'ENSMUSG00000069306', u'ENSMUSG00000038346', u'ENSMUSG00000042109', u'ENSMUSG00000038344', u'ENSMUSG00000021134', u'ENSMUSG00000031015', u'ENSMUSG00000020409', u'ENSMUSG00000039219', u'ENSMUSG00000002250', u'ENSMUSG00000020400', u'ENSMUSG00000048897', u'ENSMUSG00000020402', u'ENSMUSG00000039210', u'ENSMUSG00000057604', u'ENSMUSG00000029253', u'ENSMUSG00000029250', u'ENSMUSG00000029703', u'ENSMUSG00000022536', u'ENSMUSG00000029705', u'ENSMUSG00000058761', u'ENSMUSG00000003123', u'ENSMUSG00000028651', u'ENSMUSG00000022538', u'ENSMUSG00000028654', u'ENSMUSG00000028657', u'ENSMUSG00000028896', u'ENSMUSG00000028893', u'ENSMUSG00000029389', u'ENSMUSG00000011257', u'ENSMUSG00000028890', u'ENSMUSG00000029385', u'ENSMUSG00000015937', u'ENSMUSG00000028729', u'ENSMUSG00000028899', u'ENSMUSG00000028898', u'ENSMUSG00000038180', u'ENSMUSG00000025626', u'ENSMUSG00000007610', u'ENSMUSG00000073295', u'ENSMUSG00000054309', u'ENSMUSG00000038187', u'ENSMUSG00000046404', u'ENSMUSG00000036916', u'ENSMUSG00000029414', u'ENSMUSG00000029415', u'ENSMUSG00000032661', u'ENSMUSG00000020713', u'ENSMUSG00000032667', u'ENSMUSG00000042496', u'ENSMUSG00000020716', u'ENSMUSG00000020719', u'ENSMUSG00000059895', u'ENSMUSG00000085795', u'ENSMUSG00000002052', u'ENSMUSG00000059890', u'ENSMUSG00000028466', u'ENSMUSG00000025159', u'ENSMUSG00000060063', u'ENSMUSG00000069895', u'ENSMUSG00000009549', u'ENSMUSG00000025156', u'ENSMUSG00000025151', u'ENSMUSG00000046791', u'ENSMUSG00000046792', u'ENSMUSG00000035863', u'ENSMUSG00000048424', u'ENSMUSG00000046380', u'ENSMUSG00000028397', u'ENSMUSG00000015804', u'ENSMUSG00000028099', u'ENSMUSG00000035910', u'ENSMUSG00000035666', u'ENSMUSG00000054405', u'ENSMUSG00000042032', u'ENSMUSG00000034442', u'ENSMUSG00000052676', u'ENSMUSG00000035469', u'ENSMUSG00000021629', u'ENSMUSG00000052675', u'ENSMUSG00000069274', u'ENSMUSG00000043535', u'ENSMUSG00000012076', u'ENSMUSG00000038255', u'ENSMUSG00000021621', u'ENSMUSG00000034998', u'ENSMUSG00000038984', u'ENSMUSG00000042712', u'ENSMUSG00000072889', u'ENSMUSG00000037885', u'ENSMUSG00000028070', u'ENSMUSG00000069266', u'ENSMUSG00000044452', u'ENSMUSG00000021720', u'ENSMUSG00000035696', u'ENSMUSG00000037731', u'ENSMUSG00000032599', u'ENSMUSG00000032598', u'ENSMUSG00000044149', u'ENSMUSG00000071291', u'ENSMUSG00000028274', u'ENSMUSG00000035486', u'ENSMUSG00000028271', u'ENSMUSG00000038965', u'ENSMUSG00000046668', u'ENSMUSG00000052812', u'ENSMUSG00000079509', u'ENSMUSG00000028278', u'ENSMUSG00000028382', u'ENSMUSG00000042010', u'ENSMUSG00000042548', u'ENSMUSG00000028389', u'ENSMUSG00000034820', u'ENSMUSG00000045867', u'ENSMUSG00000031751', u'ENSMUSG00000020661', u'ENSMUSG00000002455', u'ENSMUSG00000029361', u'ENSMUSG00000056820', u'ENSMUSG00000002459', u'ENSMUSG00000008496', u'ENSMUSG00000017774', u'ENSMUSG00000055991', u'ENSMUSG00000038900', u'ENSMUSG00000071172', u'ENSMUSG00000045268', u'ENSMUSG00000037492', u'ENSMUSG00000024392', u'ENSMUSG00000024393', u'ENSMUSG00000024397', u'ENSMUSG00000014195', u'ENSMUSG00000051329', u'ENSMUSG00000027796', u'ENSMUSG00000052926', u'ENSMUSG00000040312', u'ENSMUSG00000039967', u'ENSMUSG00000054150', u'ENSMUSG00000034485', u'ENSMUSG00000032119', u'ENSMUSG00000018604', u'ENSMUSG00000059878', u'ENSMUSG00000032113', u'ENSMUSG00000021771', u'ENSMUSG00000053819', u'ENSMUSG00000055334', u'ENSMUSG00000002985', u'ENSMUSG00000021929', u'ENSMUSG00000010517', u'ENSMUSG00000002233', u'ENSMUSG00000008384', u'ENSMUSG00000002983', u'ENSMUSG00000044791', u'ENSMUSG00000024400', u'ENSMUSG00000032280', u'ENSMUSG00000021431', u'ENSMUSG00000075528', u'ENSMUSG00000027168', u'ENSMUSG00000020257', u'ENSMUSG00000031207', u'ENSMUSG00000020250', u'ENSMUSG00000020253', u'ENSMUSG00000022828', u'ENSMUSG00000073987', u'ENSMUSG00000042590', u'ENSMUSG00000028494', u'ENSMUSG00000019261', u'ENSMUSG00000000581', u'ENSMUSG00000039810', u'ENSMUSG00000039813', u'ENSMUSG00000022193', u'ENSMUSG00000017421', u'ENSMUSG00000031723', u'ENSMUSG00000067567', u'ENSMUSG00000017428', u'ENSMUSG00000026577', u'ENSMUSG00000017550', u'ENSMUSG00000033885', u'ENSMUSG00000017221', u'ENSMUSG00000043940', u'ENSMUSG00000054387', u'ENSMUSG00000033222', u'ENSMUSG00000010205', u'ENSMUSG00000002524', u'ENSMUSG00000020096', u'ENSMUSG00000038510', u'ENSMUSG00000020092', u'ENSMUSG00000000740', u'ENSMUSG00000000743', u'ENSMUSG00000070002', u'ENSMUSG00000063281', u'ENSMUSG00000008035', u'ENSMUSG00000020098', u'ENSMUSG00000040363', u'ENSMUSG00000058385', u'ENSMUSG00000032939', u'ENSMUSG00000023110', u'ENSMUSG00000040365', u'ENSMUSG00000054604', u'ENSMUSG00000057469', u'ENSMUSG00000005198', u'ENSMUSG00000058388', u'ENSMUSG00000028309', u'ENSMUSG00000038502', u'ENSMUSG00000037138', u'ENSMUSG00000024974', u'ENSMUSG00000024975', u'ENSMUSG00000024976', u'ENSMUSG00000010025', u'ENSMUSG00000036054', u'ENSMUSG00000059540', u'ENSMUSG00000030751', u'ENSMUSG00000030750', u'ENSMUSG00000030753', u'ENSMUSG00000003545', u'ENSMUSG00000030757', u'ENSMUSG00000046658', u'ENSMUSG00000001988', u'ENSMUSG00000020389', u'ENSMUSG00000001767', u'ENSMUSG00000033088', u'ENSMUSG00000001761', u'ENSMUSG00000030990', u'ENSMUSG00000031529', u'ENSMUSG00000020381', u'ENSMUSG00000001983', u'ENSMUSG00000045639', u'ENSMUSG00000020385', u'ENSMUSG00000027176', u'ENSMUSG00000037525', u'ENSMUSG00000033792', u'ENSMUSG00000024576', u'ENSMUSG00000020898', u'ENSMUSG00000020897', u'ENSMUSG00000038697', u'ENSMUSG00000020893', u'ENSMUSG00000065954', u'ENSMUSG00000048310', u'ENSMUSG00000001962', u'ENSMUSG00000038611', u'ENSMUSG00000038612', u'ENSMUSG00000028300', u'ENSMUSG00000075595', u'ENSMUSG00000038615', u'ENSMUSG00000001964', u'ENSMUSG00000033713', u'ENSMUSG00000039740', u'ENSMUSG00000026377', u'ENSMUSG00000039745', u'ENSMUSG00000003868', u'ENSMUSG00000005609', u'ENSMUSG00000041781', u'ENSMUSG00000027395', u'ENSMUSG00000033918', u'ENSMUSG00000054967', u'ENSMUSG00000021457', u'ENSMUSG00000061607', u'ENSMUSG00000037253', u'ENSMUSG00000031575', u'ENSMUSG00000000561', u'ENSMUSG00000050240', u'ENSMUSG00000000563', u'ENSMUSG00000005045', u'ENSMUSG00000004069', u'ENSMUSG00000000567', u'ENSMUSG00000041309', u'ENSMUSG00000027715', u'ENSMUSG00000000568', u'ENSMUSG00000056947', u'ENSMUSG00000027710', u'ENSMUSG00000037415', u'ENSMUSG00000027712', u'ENSMUSG00000026159', u'ENSMUSG00000026628', u'ENSMUSG00000026622', u'ENSMUSG00000034839', u'ENSMUSG00000026626', u'ENSMUSG00000037640', u'ENSMUSG00000022387', u'ENSMUSG00000022383', u'ENSMUSG00000027953', u'ENSMUSG00000031487', u'ENSMUSG00000027951', u'ENSMUSG00000022389', u'ENSMUSG00000038909', u'ENSMUSG00000030967', u'ENSMUSG00000004642', u'ENSMUSG00000042359', u'ENSMUSG00000024201', u'ENSMUSG00000056014', u'ENSMUSG00000006519', u'ENSMUSG00000030282', u'ENSMUSG00000040481', u'ENSMUSG00000026028', u'ENSMUSG00000014859', u'ENSMUSG00000023018', u'ENSMUSG00000041415', u'ENSMUSG00000026024', u'ENSMUSG00000040410', u'ENSMUSG00000028222', u'ENSMUSG00000023015', u'ENSMUSG00000026020', u'ENSMUSG00000003464', u'ENSMUSG00000056708', u'ENSMUSG00000038766', u'ENSMUSG00000022010', u'ENSMUSG00000038762', u'ENSMUSG00000031813', u'ENSMUSG00000040782', u'ENSMUSG00000022019', u'ENSMUSG00000022018', u'ENSMUSG00000000811', u'ENSMUSG00000031393', u'ENSMUSG00000052033', u'ENSMUSG00000039361', u'ENSMUSG00000034290', u'ENSMUSG00000031398', u'ENSMUSG00000041671', u'ENSMUSG00000042419', u'ENSMUSG00000031119', u'ENSMUSG00000031622', u'ENSMUSG00000003283', u'ENSMUSG00000003282', u'ENSMUSG00000022639', u'ENSMUSG00000031627', u'ENSMUSG00000031157', u'ENSMUSG00000022635', u'ENSMUSG00000020526', u'ENSMUSG00000022637', u'ENSMUSG00000031629', u'ENSMUSG00000051705', u'ENSMUSG00000042557', u'ENSMUSG00000022708', u'ENSMUSG00000057541', u'ENSMUSG00000070697', u'ENSMUSG00000036036', u'ENSMUSG00000051586', u'ENSMUSG00000029135', u'ENSMUSG00000022702', u'ENSMUSG00000047036', u'ENSMUSG00000020561', u'ENSMUSG00000029131', u'ENSMUSG00000039238', u'ENSMUSG00000034509', u'ENSMUSG00000022672', u'ENSMUSG00000073643', u'ENSMUSG00000057835', u'ENSMUSG00000036572', u'ENSMUSG00000012114', u'ENSMUSG00000025439', u'ENSMUSG00000035275', u'ENSMUSG00000090115', u'ENSMUSG00000031026', u'ENSMUSG00000036923', u'ENSMUSG00000026848', u'ENSMUSG00000026849', u'ENSMUSG00000036928', u'ENSMUSG00000045193', u'ENSMUSG00000078652', u'ENSMUSG00000026842', u'ENSMUSG00000026843', u'ENSMUSG00000066687', u'ENSMUSG00000020413', u'ENSMUSG00000009772', u'ENSMUSG00000022523', u'ENSMUSG00000028668', u'ENSMUSG00000028669', u'ENSMUSG00000020415', u'ENSMUSG00000028664', u'ENSMUSG00000022528', u'ENSMUSG00000024790', u'ENSMUSG00000052301', u'ENSMUSG00000003135', u'ENSMUSG00000057614', u'ENSMUSG00000003731', u'ENSMUSG00000028719', u'ENSMUSG00000028869', u'ENSMUSG00000029627', u'ENSMUSG00000029625', u'ENSMUSG00000047259', u'ENSMUSG00000028863', u'ENSMUSG00000029203', u'ENSMUSG00000028861', u'ENSMUSG00000034610', u'ENSMUSG00000017747', u'ENSMUSG00000034613', u'ENSMUSG00000021385', u'ENSMUSG00000029397', u'ENSMUSG00000064043', u'ENSMUSG00000029394', u'ENSMUSG00000066042', u'ENSMUSG00000006732', u'ENSMUSG00000045875', u'ENSMUSG00000020706', u'ENSMUSG00000020705', u'ENSMUSG00000032612', u'ENSMUSG00000057058', u'ENSMUSG00000029403', u'ENSMUSG00000029402', u'ENSMUSG00000037933', u'ENSMUSG00000020708', u'ENSMUSG00000032177', u'ENSMUSG00000009555', u'ENSMUSG00000062908', u'ENSMUSG00000025364', u'ENSMUSG00000025369', u'ENSMUSG00000062906', u'ENSMUSG00000028228', u'ENSMUSG00000029176', u'ENSMUSG00000008958', u'ENSMUSG00000048439', u'ENSMUSG00000034271', u'ENSMUSG00000034274', u'ENSMUSG00000025764', u'ENSMUSG00000074403', u'ENSMUSG00000042156', u'ENSMUSG00000029670', u'ENSMUSG00000069265', u'ENSMUSG00000032171', u'ENSMUSG00000035478', u'ENSMUSG00000072872', u'ENSMUSG00000069268', u'ENSMUSG00000061991', u'ENSMUSG00000028042', u'ENSMUSG00000021732', u'ENSMUSG00000001424', u'ENSMUSG00000021738', u'ENSMUSG00000008730', u'ENSMUSG00000008734', u'ENSMUSG00000029913', u'ENSMUSG00000063410', u'ENSMUSG00000038976', u'ENSMUSG00000028282', u'ENSMUSG00000053436', u'ENSMUSG00000046679', u'ENSMUSG00000035873', u'ENSMUSG00000025162', u'ENSMUSG00000028911', u'ENSMUSG00000035877', u'ENSMUSG00000048251', u'ENSMUSG00000028914', u'ENSMUSG00000090223', u'ENSMUSG00000018651', u'ENSMUSG00000035011', u'ENSMUSG00000028851', u'ENSMUSG00000018654', u'ENSMUSG00000042389', u'ENSMUSG00000069729', u'ENSMUSG00000039000', u'ENSMUSG00000017764', u'ENSMUSG00000020677', u'ENSMUSG00000032727', u'ENSMUSG00000002428', u'ENSMUSG00000068551', u'ENSMUSG00000008604', u'ENSMUSG00000037017', u'ENSMUSG00000025076', u'ENSMUSG00000001517', u'ENSMUSG00000054716', u'ENSMUSG00000068428', u'ENSMUSG00000024841', u'ENSMUSG00000024387', u'ENSMUSG00000045098', u'ENSMUSG00000024384', u'ENSMUSG00000024383', u'ENSMUSG00000024382', u'ENSMUSG00000024381', u'ENSMUSG00000069495', u'ENSMUSG00000045252', u'ENSMUSG00000018476', u'ENSMUSG00000042207', u'ENSMUSG00000018474', u'ENSMUSG00000038145', u'ENSMUSG00000037013', u'ENSMUSG00000072964', u'ENSMUSG00000019303', u'ENSMUSG00000039449', u'ENSMUSG00000062098', u'ENSMUSG00000059842', u'ENSMUSG00000032126', u'ENSMUSG00000030042', u'ENSMUSG00000053536', u'ENSMUSG00000019874', u'ENSMUSG00000019876', u'ENSMUSG00000036111', u'ENSMUSG00000044783', u'ENSMUSG00000021938', u'ENSMUSG00000074221', u'ENSMUSG00000024140', u'ENSMUSG00000074457', u'ENSMUSG00000060216', u'ENSMUSG00000019878', u'ENSMUSG00000024146', u'ENSMUSG00000037465', u'ENSMUSG00000022831', u'ENSMUSG00000020262', u'ENSMUSG00000020263', u'ENSMUSG00000027544', u'ENSMUSG00000020265', u'ENSMUSG00000020267', u'ENSMUSG00000032199', u'ENSMUSG00000001289', u'ENSMUSG00000001288', u'ENSMUSG00000038425', u'ENSMUSG00000001280', u'ENSMUSG00000055762', u'ENSMUSG00000001285', u'ENSMUSG00000040943', u'ENSMUSG00000048895', u'ENSMUSG00000030867', u'ENSMUSG00000039952', u'ENSMUSG00000039953', u'ENSMUSG00000032547', u'ENSMUSG00000040652', u'ENSMUSG00000039959', u'ENSMUSG00000053754', u'ENSMUSG00000039148', u'ENSMUSG00000033233', u'ENSMUSG00000002881', u'ENSMUSG00000017548', u'ENSMUSG00000051910', u'ENSMUSG00000020069', u'ENSMUSG00000036180', u'ENSMUSG00000037730', u'ENSMUSG00000014039', u'ENSMUSG00000020063', u'ENSMUSG00000000776', u'ENSMUSG00000063632', u'ENSMUSG00000061013', u'ENSMUSG00000026705', u'ENSMUSG00000047866', u'ENSMUSG00000026701', u'ENSMUSG00000040310', u'ENSMUSG00000058392', u'ENSMUSG00000026709', u'ENSMUSG00000052942', u'ENSMUSG00000032940', u'ENSMUSG00000024969', u'ENSMUSG00000024968', u'ENSMUSG00000033411', u'ENSMUSG00000030766', u'ENSMUSG00000024960', u'ENSMUSG00000024966', u'ENSMUSG00000030619', u'ENSMUSG00000026632', u'ENSMUSG00000022913', u'ENSMUSG00000027498', u'ENSMUSG00000027499', u'ENSMUSG00000024369', u'ENSMUSG00000037643', u'ENSMUSG00000030960', u'ENSMUSG00000061028', u'ENSMUSG00000030966', u'ENSMUSG00000025290', u'ENSMUSG00000027490', u'ENSMUSG00000030965', u'ENSMUSG00000032515', u'ENSMUSG00000024565', u'ENSMUSG00000078919', u'ENSMUSG00000024563', u'ENSMUSG00000024561', u'ENSMUSG00000024560', u'ENSMUSG00000041777', u'ENSMUSG00000029454', u'ENSMUSG00000033099', u'ENSMUSG00000051177', u'ENSMUSG00000041773', u'ENSMUSG00000004100', u'ENSMUSG00000019699', u'ENSMUSG00000032101', u'ENSMUSG00000066861', u'ENSMUSG00000039771', u'ENSMUSG00000033705', u'ENSMUSG00000038608', u'ENSMUSG00000020844', u'ENSMUSG00000020840', u'ENSMUSG00000020841', u'ENSMUSG00000042694', u'ENSMUSG00000055116', u'ENSMUSG00000040957', u'ENSMUSG00000031565', u'ENSMUSG00000020849', u'ENSMUSG00000027884', u'ENSMUSG00000073489', u'ENSMUSG00000071226', u'ENSMUSG00000041319', u'ENSMUSG00000020287', u'ENSMUSG00000000552', u'ENSMUSG00000004865', u'ENSMUSG00000037395', u'ENSMUSG00000054889', u'ENSMUSG00000000001', u'ENSMUSG00000032298', u'ENSMUSG00000021767', u'ENSMUSG00000004071', u'ENSMUSG00000000399', u'ENSMUSG00000015149', u'ENSMUSG00000051675', u'ENSMUSG00000051674', u'ENSMUSG00000046707', u'ENSMUSG00000019817', u'ENSMUSG00000018909', u'ENSMUSG00000015143', u'ENSMUSG00000062209', u'ENSMUSG00000072501', u'ENSMUSG00000039985', u'ENSMUSG00000022476', u'ENSMUSG00000054321', u'ENSMUSG00000031490', u'ENSMUSG00000079614', u'ENSMUSG00000039485', u'ENSMUSG00000031708', u'ENSMUSG00000055024', u'ENSMUSG00000000957', u'ENSMUSG00000030380', u'ENSMUSG00000031706', u'ENSMUSG00000030386', u'ENSMUSG00000036672', u'ENSMUSG00000004655', u'ENSMUSG00000026527', u'ENSMUSG00000037262', u'ENSMUSG00000027030', u'ENSMUSG00000037032', u'ENSMUSG00000041923', u'ENSMUSG00000068749', u'ENSMUSG00000041408', u'ENSMUSG00000023007', u'ENSMUSG00000047215', u'ENSMUSG00000045636', u'ENSMUSG00000043263', u'ENSMUSG00000026037', u'ENSMUSG00000026036', u'ENSMUSG00000051451', u'ENSMUSG00000026034', u'ENSMUSG00000038773', u'ENSMUSG00000022021', u'ENSMUSG00000026039', u'ENSMUSG00000022023', u'ENSMUSG00000022024', u'ENSMUSG00000003923', u'ENSMUSG00000027566', u'ENSMUSG00000072966', u'ENSMUSG00000031386', u'ENSMUSG00000042817', u'ENSMUSG00000031388', u'ENSMUSG00000059119', u'ENSMUSG00000025959', u'ENSMUSG00000025958', u'ENSMUSG00000031633', u'ENSMUSG00000031634', u'ENSMUSG00000073423', u'ENSMUSG00000050619', u'ENSMUSG00000068855', u'ENSMUSG00000069565', u'ENSMUSG00000031148', u'ENSMUSG00000040043', u'ENSMUSG00000031311', u'ENSMUSG00000040044', u'ENSMUSG00000052534', u'ENSMUSG00000049553', u'ENSMUSG00000031701', u'ENSMUSG00000047022', u'ENSMUSG00000046573', u'ENSMUSG00000011306', u'ENSMUSG00000025427', u'ENSMUSG00000069678', u'ENSMUSG00000025420', u'ENSMUSG00000025423', u'ENSMUSG00000025422', u'ENSMUSG00000034041', u'ENSMUSG00000022285', u'ENSMUSG00000059288', u'ENSMUSG00000034042', u'ENSMUSG00000015312', u'ENSMUSG00000022283', u'ENSMUSG00000038369', u'ENSMUSG00000041560', u'ENSMUSG00000036932', u'ENSMUSG00000080268', u'ENSMUSG00000027035', u'ENSMUSG00000068856', u'ENSMUSG00000026857', u'ENSMUSG00000028582', u'ENSMUSG00000038365', u'ENSMUSG00000022516', u'ENSMUSG00000022517', u'ENSMUSG00000020462', u'ENSMUSG00000020463', u'ENSMUSG00000020460', u'ENSMUSG00000034329', u'ENSMUSG00000050890', u'ENSMUSG00000030816', u'ENSMUSG00000027569', u'ENSMUSG00000044167', u'ENSMUSG00000029279', u'ENSMUSG00000029657', u'ENSMUSG00000025889', u'ENSMUSG00000025888', u'ENSMUSG00000031400', u'ENSMUSG00000022607', u'ENSMUSG00000025551', u'ENSMUSG00000028706', u'ENSMUSG00000022358', u'ENSMUSG00000022359', u'ENSMUSG00000028703', u'ENSMUSG00000028702', u'ENSMUSG00000006676', u'ENSMUSG00000006728', u'ENSMUSG00000021392', u'ENSMUSG00000025393', u'ENSMUSG00000006720', u'ENSMUSG00000021395', u'ENSMUSG00000044627', u'ENSMUSG00000032498', u'ENSMUSG00000032606', u'ENSMUSG00000029478', u'ENSMUSG00000009013', u'ENSMUSG00000029474', u'ENSMUSG00000029475', u'ENSMUSG00000029472', u'ENSMUSG00000029471', u'ENSMUSG00000008540', u'ENSMUSG00000025374', u'ENSMUSG00000036752', u'ENSMUSG00000071350', u'ENSMUSG00000034263', u'ENSMUSG00000033502', u'ENSMUSG00000028676', u'ENSMUSG00000028675', u'ENSMUSG00000034269', u'ENSMUSG00000035397', u'ENSMUSG00000013787', u'ENSMUSG00000028678', u'ENSMUSG00000011158', u'ENSMUSG00000035390', u'ENSMUSG00000068101', u'ENSMUSG00000061479', u'ENSMUSG00000028034', u'ENSMUSG00000021645', u'ENSMUSG00000040033', u'ENSMUSG00000061477', u'ENSMUSG00000029502', u'ENSMUSG00000021709', u'ENSMUSG00000069631', u'ENSMUSG00000029507', u'ENSMUSG00000029504', u'ENSMUSG00000029505', u'ENSMUSG00000028053', u'ENSMUSG00000074102', u'ENSMUSG00000061032', u'ENSMUSG00000046449', u'ENSMUSG00000048154', u'ENSMUSG00000016559', u'ENSMUSG00000042369', u'ENSMUSG00000038943', u'ENSMUSG00000028291', u'ENSMUSG00000071341', u'ENSMUSG00000059474', u'ENSMUSG00000028901', u'ENSMUSG00000018648', u'ENSMUSG00000028902', u'ENSMUSG00000028453', u'ENSMUSG00000028452', u'ENSMUSG00000028907', u'ENSMUSG00000028906', u'ENSMUSG00000035021', u'ENSMUSG00000075706', u'ENSMUSG00000035024', u'ENSMUSG00000020608', u'ENSMUSG00000016150', u'ENSMUSG00000057406', u'ENSMUSG00000038774', u'ENSMUSG00000001627', u'ENSMUSG00000018481', u'ENSMUSG00000020601', u'ENSMUSG00000054766', u'ENSMUSG00000079470', u'ENSMUSG00000035203', u'ENSMUSG00000001569', u'ENSMUSG00000042211', u'ENSMUSG00000059439', u'ENSMUSG00000034165', u'ENSMUSG00000054034', u'ENSMUSG00000069302', u'ENSMUSG00000064181', u'ENSMUSG00000045538', u'ENSMUSG00000041360', u'ENSMUSG00000044337', u'ENSMUSG00000045248', u'ENSMUSG00000002728', u'ENSMUSG00000052833', u'ENSMUSG00000037971', u'ENSMUSG00000052837', u'ENSMUSG00000053293', u'ENSMUSG00000025128', u'ENSMUSG00000059851', u'ENSMUSG00000061374', u'ENSMUSG00000022956', u'ENSMUSG00000032423', u'ENSMUSG00000078348', u'ENSMUSG00000019849', u'ENSMUSG00000021418', u'ENSMUSG00000020114', u'ENSMUSG00000038116', u'ENSMUSG00000004815', u'ENSMUSG00000019841', u'ENSMUSG00000024176', u'ENSMUSG00000019843', u'ENSMUSG00000024170', u'ENSMUSG00000041702', u'ENSMUSG00000021413', u'ENSMUSG00000024286', u'ENSMUSG00000024287', u'ENSMUSG00000024283', u'ENSMUSG00000045333', u'ENSMUSG00000020275', u'ENSMUSG00000020273', u'ENSMUSG00000027552', u'ENSMUSG00000020271', u'ENSMUSG00000041147', u'ENSMUSG00000058709', u'ENSMUSG00000033396', u'ENSMUSG00000017446', u'ENSMUSG00000002948', u'ENSMUSG00000039830', u'ENSMUSG00000058704', u'ENSMUSG00000039834', u'ENSMUSG00000021890', u'ENSMUSG00000021893', u'ENSMUSG00000032555', u'ENSMUSG00000006392', u'ENSMUSG00000002546', u'ENSMUSG00000054079', u'ENSMUSG00000054364', u'ENSMUSG00000020079', u'ENSMUSG00000037896', u'ENSMUSG00000037894', u'ENSMUSG00000024773', u'ENSMUSG00000020070', u'ENSMUSG00000020075', u'ENSMUSG00000020076', u'ENSMUSG00000035529', u'ENSMUSG00000026739', u'ENSMUSG00000042506', u'ENSMUSG00000032959', u'ENSMUSG00000026737', u'ENSMUSG00000001383', u'ENSMUSG00000038564', u'ENSMUSG00000066900', u'ENSMUSG00000024914', u'ENSMUSG00000049950', u'ENSMUSG00000024912', u'ENSMUSG00000033055', u'ENSMUSG00000024911', u'ENSMUSG00000051154', u'ENSMUSG00000041548', u'ENSMUSG00000030609', u'ENSMUSG00000054509', u'ENSMUSG00000041096', u'ENSMUSG00000001707', u'ENSMUSG00000037652', u'ENSMUSG00000030603', u'ENSMUSG00000024359', u'ENSMUSG00000024604', u'ENSMUSG00000005442', u'ENSMUSG00000048249', u'ENSMUSG00000024590', u'ENSMUSG00000078676', u'ENSMUSG00000060981', u'ENSMUSG00000004393', u'ENSMUSG00000015176', u'ENSMUSG00000003848', u'ENSMUSG00000003847', u'ENSMUSG00000059070', u'ENSMUSG00000033773', u'ENSMUSG00000031832', u'ENSMUSG00000032652', u'ENSMUSG00000058672', u'ENSMUSG00000029026', u'ENSMUSG00000024826', u'ENSMUSG00000024827', u'ENSMUSG00000024824', u'ENSMUSG00000059278', u'ENSMUSG00000027803', u'ENSMUSG00000020850', u'ENSMUSG00000020857', u'ENSMUSG00000027804', u'ENSMUSG00000061878', u'ENSMUSG00000027806', u'ENSMUSG00000059475', u'ENSMUSG00000020290', u'ENSMUSG00000030770', u'ENSMUSG00000001016', u'ENSMUSG00000001017', u'ENSMUSG00000030774', u'ENSMUSG00000037475', u'ENSMUSG00000037474', u'ENSMUSG00000030779', u'ENSMUSG00000057531', u'ENSMUSG00000063065', u'ENSMUSG00000037343', u'ENSMUSG00000033730', u'ENSMUSG00000047388', u'ENSMUSG00000015776', u'ENSMUSG00000052748', u'ENSMUSG00000043962', u'ENSMUSG00000026604', u'ENSMUSG00000026605', u'ENSMUSG00000048490', u'ENSMUSG00000043969', u'ENSMUSG00000051747', u'ENSMUSG00000000386', u'ENSMUSG00000037278', u'ENSMUSG00000034981', u'ENSMUSG00000040720', u'ENSMUSG00000079317', u'ENSMUSG00000027936', u'ENSMUSG00000027933', u'ENSMUSG00000026196', u'ENSMUSG00000005716', u'ENSMUSG00000033871', u'ENSMUSG00000030393', u'ENSMUSG00000062867', u'ENSMUSG00000030557', u'ENSMUSG00000037275', u'ENSMUSG00000026283', u'ENSMUSG00000040128', u'ENSMUSG00000030551', u'ENSMUSG00000030806', u'ENSMUSG00000040124', u'ENSMUSG00000031826', u'ENSMUSG00000031827', u'ENSMUSG00000031820', u'ENSMUSG00000031821', u'ENSMUSG00000040123', u'ENSMUSG00000036529', u'ENSMUSG00000023030', u'ENSMUSG00000040430', u'ENSMUSG00000023034', u'ENSMUSG00000026516', u'ENSMUSG00000024056', u'ENSMUSG00000022037', u'ENSMUSG00000019738', u'ENSMUSG00000022034', u'ENSMUSG00000022033', u'ENSMUSG00000006262', u'ENSMUSG00000022031', u'ENSMUSG00000029802', u'ENSMUSG00000022292', u'ENSMUSG00000021258', u'ENSMUSG00000000838', u'ENSMUSG00000022296', u'ENSMUSG00000055633', u'ENSMUSG00000021253', u'ENSMUSG00000021250', u'ENSMUSG00000047141', u'ENSMUSG00000021257', u'ENSMUSG00000021255', u'ENSMUSG00000074698', u'ENSMUSG00000090083', u'ENSMUSG00000029084', u'ENSMUSG00000031600', u'ENSMUSG00000031601', u'ENSMUSG00000062115', u'ENSMUSG00000057982', u'ENSMUSG00000056458', u'ENSMUSG00000054717', u'ENSMUSG00000031609', u'ENSMUSG00000021096', u'ENSMUSG00000023104', u'ENSMUSG00000014496', u'ENSMUSG00000049792', u'ENSMUSG00000035597', u'ENSMUSG00000040054', u'ENSMUSG00000045983', u'ENSMUSG00000024222', u'ENSMUSG00000053985', u'ENSMUSG00000056851', u'ENSMUSG00000059291', u'ENSMUSG00000054256', u'ENSMUSG00000045103', u'ENSMUSG00000043131', u'ENSMUSG00000038014', u'ENSMUSG00000022724', u'ENSMUSG00000038252', u'ENSMUSG00000061615', u'ENSMUSG00000034071', u'ENSMUSG00000021010', u'ENSMUSG00000056216', u'ENSMUSG00000006715', u'ENSMUSG00000047446', u'ENSMUSG00000006717', u'ENSMUSG00000030733', u'ENSMUSG00000038375', u'ENSMUSG00000038374', u'ENSMUSG00000005846', u'ENSMUSG00000020475', u'ENSMUSG00000020474', u'ENSMUSG00000022508', u'ENSMUSG00000020471', u'ENSMUSG00000020473', u'ENSMUSG00000020472', u'ENSMUSG00000022503', u'ENSMUSG00000024309', u'ENSMUSG00000022500', u'ENSMUSG00000029267', u'ENSMUSG00000022505', u'ENSMUSG00000031137', u'ENSMUSG00000014601', u'ENSMUSG00000029863', u'ENSMUSG00000040945', u'ENSMUSG00000029641', u'ENSMUSG00000029640', u'ENSMUSG00000022346', u'ENSMUSG00000028840', u'ENSMUSG00000024891', u'ENSMUSG00000028843', u'ENSMUSG00000017843', u'ENSMUSG00000034674', u'ENSMUSG00000034673', u'ENSMUSG00000058881', u'ENSMUSG00000015942', u'ENSMUSG00000038170', u'ENSMUSG00000035242', u'ENSMUSG00000039158', u'ENSMUSG00000045427', u'ENSMUSG00000068854', u'ENSMUSG00000031028', u'ENSMUSG00000047879', u'ENSMUSG00000029466', u'ENSMUSG00000032637', u'ENSMUSG00000009828', u'ENSMUSG00000059436', u'ENSMUSG00000045659', u'ENSMUSG00000042688', u'ENSMUSG00000067150', u'ENSMUSG00000056220', u'ENSMUSG00000062960', u'ENSMUSG00000028114', u'ENSMUSG00000025982', u'ENSMUSG00000034255', u'ENSMUSG00000028603', u'ENSMUSG00000034252', u'ENSMUSG00000042772', u'ENSMUSG00000034701', u'ENSMUSG00000020464', u'ENSMUSG00000028609', u'ENSMUSG00000052139', u'ENSMUSG00000032501', u'ENSMUSG00000057219', u'ENSMUSG00000055491', u'ENSMUSG00000025747', u'ENSMUSG00000061462', u'ENSMUSG00000052135', u'ENSMUSG00000028599', u'ENSMUSG00000029513', u'ENSMUSG00000031902', u'ENSMUSG00000021719', u'ENSMUSG00000028029', u'ENSMUSG00000053914', u'ENSMUSG00000021715', u'ENSMUSG00000002393', u'ENSMUSG00000021713', u'ENSMUSG00000021712', u'ENSMUSG00000042745', u'ENSMUSG00000057666', u'ENSMUSG00000034926', u'ENSMUSG00000042197', u'ENSMUSG00000016528', u'ENSMUSG00000050891', u'ENSMUSG00000016526', u'ENSMUSG00000014232', u'ENSMUSG00000024228', u'ENSMUSG00000038954', u'ENSMUSG00000032407', u'ENSMUSG00000028936', u'ENSMUSG00000018678', u'ENSMUSG00000028932', u'ENSMUSG00000028933', u'ENSMUSG00000068220', u'ENSMUSG00000038398', u'ENSMUSG00000063800', u'ENSMUSG00000046058', u'ENSMUSG00000002409', u'ENSMUSG00000035033', u'ENSMUSG00000017146', u'ENSMUSG00000032705', u'ENSMUSG00000025199', u'ENSMUSG00000022452', u'ENSMUSG00000020611', u'ENSMUSG00000035234', u'ENSMUSG00000032702', u'ENSMUSG00000028333', u'ENSMUSG00000028330', u'ENSMUSG00000021400', u'ENSMUSG00000036023', u'ENSMUSG00000008668', u'ENSMUSG00000044847', u'ENSMUSG00000042570', u'ENSMUSG00000078671', u'ENSMUSG00000014303', u'ENSMUSG00000004936', u'ENSMUSG00000029655', u'ENSMUSG00000068154', u'ENSMUSG00000074170', u'ENSMUSG00000018102', u'ENSMUSG00000019984', u'ENSMUSG00000042228', u'ENSMUSG00000052915', u'ENSMUSG00000018076', u'ENSMUSG00000032381', u'ENSMUSG00000052353', u'ENSMUSG00000032383', u'ENSMUSG00000002718', u'ENSMUSG00000032386', u'ENSMUSG00000031586', u'ENSMUSG00000023988', u'ENSMUSG00000049323', u'ENSMUSG00000028708', u'ENSMUSG00000078566', u'ENSMUSG00000035726', u'ENSMUSG00000035725', u'ENSMUSG00000043384', u'ENSMUSG00000028871', u'ENSMUSG00000018583', u'ENSMUSG00000020107', u'ENSMUSG00000046311', u'ENSMUSG00000019857', u'ENSMUSG00000031583', u'ENSMUSG00000033943', u'ENSMUSG00000004263', u'ENSMUSG00000019850', u'ENSMUSG00000025880', u'ENSMUSG00000024293', u'ENSMUSG00000027439', u'ENSMUSG00000036398', u'ENSMUSG00000048921', u'ENSMUSG00000048920', u'ENSMUSG00000049532', u'ENSMUSG00000048922', u'ENSMUSG00000019214', u'ENSMUSG00000048458', u'ENSMUSG00000039849', u'ENSMUSG00000029231', u'ENSMUSG00000032897', u'ENSMUSG00000032892', u'ENSMUSG00000039841', u'ENSMUSG00000002372', u'ENSMUSG00000032565', u'ENSMUSG00000061024', u'ENSMUSG00000035297', u'ENSMUSG00000032562', u'ENSMUSG00000053175', u'ENSMUSG00000018293', u'ENSMUSG00000001173', u'ENSMUSG00000017210', u'ENSMUSG00000001175', u'ENSMUSG00000061136', u'ENSMUSG00000037243', u'ENSMUSG00000024764', u'ENSMUSG00000024767', u'ENSMUSG00000020048', u'ENSMUSG00000079562', u'ENSMUSG00000002578', u'ENSMUSG00000037712', u'ENSMUSG00000032299', u'ENSMUSG00000041272', u'ENSMUSG00000040209', u'ENSMUSG00000059456', u'ENSMUSG00000019505', u'ENSMUSG00000026721', u'ENSMUSG00000058407', u'ENSMUSG00000024908', u'ENSMUSG00000050188', u'ENSMUSG00000054199', u'ENSMUSG00000030849', u'ENSMUSG00000024906', u'ENSMUSG00000078773', u'ENSMUSG00000028873', u'ENSMUSG00000078941', u'ENSMUSG00000078942', u'ENSMUSG00000007815', u'ENSMUSG00000005054', u'ENSMUSG00000033543', u'ENSMUSG00000033542', u'ENSMUSG00000037664', u'ENSMUSG00000024613', u'ENSMUSG00000050071', u'ENSMUSG00000024617', u'ENSMUSG00000079109', u'ENSMUSG00000027122', u'ENSMUSG00000030844', u'ENSMUSG00000005470', u'ENSMUSG00000073705', u'ENSMUSG00000024583', u'ENSMUSG00000015165', u'ENSMUSG00000026610', u'ENSMUSG00000058318', u'ENSMUSG00000039164', u'ENSMUSG00000055493', u'ENSMUSG00000039913', u'ENSMUSG00000059040', u'ENSMUSG00000033760', u'ENSMUSG00000033762', u'ENSMUSG00000024831', u'ENSMUSG00000005493', u'ENSMUSG00000024833', u'ENSMUSG00000039166', u'ENSMUSG00000050315', u'ENSMUSG00000020828', u'ENSMUSG00000030016', u'ENSMUSG00000070544', u'ENSMUSG00000020918', u'ENSMUSG00000020919', u'ENSMUSG00000000028', u'ENSMUSG00000027582', u'ENSMUSG00000027583', u'ENSMUSG00000027230', u'ENSMUSG00000050213', u'ENSMUSG00000020914', u'ENSMUSG00000040433', u'ENSMUSG00000062563', u'ENSMUSG00000037443', u'ENSMUSG00000018921', u'ENSMUSG00000018923', u'ENSMUSG00000040204', u'ENSMUSG00000060733', u'ENSMUSG00000062591', u'ENSMUSG00000004018', u'ENSMUSG00000019432', u'ENSMUSG00000014554', u'ENSMUSG00000040479', u'ENSMUSG00000036158', u'ENSMUSG00000061911', u'ENSMUSG00000030127', u'ENSMUSG00000039620', u'ENSMUSG00000063358', u'ENSMUSG00000030120', u'ENSMUSG00000003949', u'ENSMUSG00000040594', u'ENSMUSG00000040596', u'ENSMUSG00000027905', u'ENSMUSG00000020412', u'ENSMUSG00000006527', u'ENSMUSG00000051034', u'ENSMUSG00000004637', u'ENSMUSG00000026187', u'ENSMUSG00000040599', u'ENSMUSG00000032477', u'ENSMUSG00000031543', u'ENSMUSG00000040681', u'ENSMUSG00000000441', u'ENSMUSG00000031546', u'ENSMUSG00000005656', u'ENSMUSG00000005125', u'ENSMUSG00000040688', u'ENSMUSG00000041420', u'ENSMUSG00000037286', u'ENSMUSG00000030839', u'ENSMUSG00000031865', u'ENSMUSG00000023027', u'ENSMUSG00000003437', u'ENSMUSG00000033166', u'ENSMUSG00000003435', u'ENSMUSG00000038718', u'ENSMUSG00000023021', u'ENSMUSG00000031834', u'ENSMUSG00000049401', u'ENSMUSG00000031839', u'ENSMUSG00000026058', u'ENSMUSG00000026509', u'ENSMUSG00000030232', u'ENSMUSG00000073079', u'ENSMUSG00000067455', u'ENSMUSG00000063524', u'ENSMUSG00000021243', u'ENSMUSG00000073490', u'ENSMUSG00000021245', u'ENSMUSG00000021244', u'ENSMUSG00000061143', u'ENSMUSG00000028416', u'ENSMUSG00000006412', u'ENSMUSG00000031618', u'ENSMUSG00000032575', u'ENSMUSG00000035960', u'ENSMUSG00000033596', u'ENSMUSG00000029073', u'ENSMUSG00000006418', u'ENSMUSG00000022191', u'ENSMUSG00000060950', u'ENSMUSG00000003549', u'ENSMUSG00000022194', u'ENSMUSG00000039501', u'ENSMUSG00000022197', u'ENSMUSG00000026473', u'ENSMUSG00000051510', u'ENSMUSG00000003541', u'ENSMUSG00000090112', u'ENSMUSG00000031729', u'ENSMUSG00000014956', u'ENSMUSG00000047003', u'ENSMUSG00000038000', u'ENSMUSG00000038002', u'ENSMUSG00000038005', u'ENSMUSG00000056596', u'ENSMUSG00000025409', u'ENSMUSG00000025408', u'ENSMUSG00000003382', u'ENSMUSG00000025404', u'ENSMUSG00000025403', u'ENSMUSG00000025402', u'ENSMUSG00000061603', u'ENSMUSG00000031917', u'ENSMUSG00000042520', u'ENSMUSG00000006705', u'ENSMUSG00000034390', u'ENSMUSG00000047030', u'ENSMUSG00000056201', u'ENSMUSG00000029185', u'ENSMUSG00000005871', u'ENSMUSG00000037808', u'ENSMUSG00000003360', u'ENSMUSG00000063972', u'ENSMUSG00000026873', u'ENSMUSG00000026872', u'ENSMUSG00000029212', u'ENSMUSG00000029213', u'ENSMUSG00000026879', u'ENSMUSG00000035649', u'ENSMUSG00000009927', u'ENSMUSG00000090150', u'ENSMUSG00000079553', u'ENSMUSG00000003099', u'ENSMUSG00000026955', u'ENSMUSG00000029673', u'ENSMUSG00000029674', u'ENSMUSG00000036875', u'ENSMUSG00000029676', u'ENSMUSG00000036792', u'ENSMUSG00000028064', u'ENSMUSG00000028850', u'ENSMUSG00000025577', u'ENSMUSG00000025576', u'ENSMUSG00000034663', u'ENSMUSG00000007659', u'ENSMUSG00000015971', u'ENSMUSG00000038146', u'ENSMUSG00000025578', u'ENSMUSG00000025777', u'ENSMUSG00000016087', u'ENSMUSG00000021661', u'ENSMUSG00000021660', u'ENSMUSG00000039145', u'ENSMUSG00000031885', u'ENSMUSG00000032621', u'ENSMUSG00000021668', u'ENSMUSG00000022400', u'ENSMUSG00000025358', u'ENSMUSG00000029326', u'ENSMUSG00000028101', u'ENSMUSG00000009585', u'ENSMUSG00000029328', u'ENSMUSG00000023809', u'ENSMUSG00000028104', u'ENSMUSG00000036503', u'ENSMUSG00000028614', u'ENSMUSG00000046204', u'ENSMUSG00000048661', u'ENSMUSG00000025995', u'ENSMUSG00000049657', u'ENSMUSG00000025997', u'ENSMUSG00000046201', u'ENSMUSG00000048668', u'ENSMUSG00000090100', u'ENSMUSG00000028619', u'ENSMUSG00000052551', u'ENSMUSG00000034245', u'ENSMUSG00000056413', u'ENSMUSG00000025757', u'ENSMUSG00000028587', u'ENSMUSG00000006678', u'ENSMUSG00000061458', u'ENSMUSG00000028580', u'ENSMUSG00000021067', u'ENSMUSG00000020599', u'ENSMUSG00000042167', u'ENSMUSG00000021068', u'ENSMUSG00000016319', u'ENSMUSG00000020593', u'ENSMUSG00000025758', u'ENSMUSG00000020621', u'ENSMUSG00000032097', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000063450', u'ENSMUSG00000054115', u'ENSMUSG00000020628', u'ENSMUSG00000020629', u'ENSMUSG00000023932', u'ENSMUSG00000037369', u'ENSMUSG00000034931', u'ENSMUSG00000028992', u'ENSMUSG00000042182', u'ENSMUSG00000042185', u'ENSMUSG00000040321', u'ENSMUSG00000034936', u'ENSMUSG00000014226', u'ENSMUSG00000016409', u'ENSMUSG00000035829', u'ENSMUSG00000013698', u'ENSMUSG00000039989', u'ENSMUSG00000042508', u'ENSMUSG00000035283', u'ENSMUSG00000038812', u'ENSMUSG00000025190', u'ENSMUSG00000025193', u'ENSMUSG00000025192', u'ENSMUSG00000028927', u'ENSMUSG00000028926', u'ENSMUSG00000042502', u'ENSMUSG00000089917', u'ENSMUSG00000058301', u'ENSMUSG00000018666', u'ENSMUSG00000066149', u'ENSMUSG00000018669', u'ENSMUSG00000002413', u'ENSMUSG00000002147', u'ENSMUSG00000021476', u'ENSMUSG00000021477', u'ENSMUSG00000028322', u'ENSMUSG00000024112', u'ENSMUSG00000062480', u'ENSMUSG00000021470', u'ENSMUSG00000028329', u'ENSMUSG00000028328', u'ENSMUSG00000001542', u'ENSMUSG00000021478', u'ENSMUSG00000018449', u'ENSMUSG00000027455', u'ENSMUSG00000016624', u'ENSMUSG00000030655', u'ENSMUSG00000022992', u'ENSMUSG00000067851', u'ENSMUSG00000018446', u'ENSMUSG00000045515', u'ENSMUSG00000043456', u'ENSMUSG00000032397', u'ENSMUSG00000046442', u'ENSMUSG00000026421', u'ENSMUSG00000042439', u'ENSMUSG00000035754', u'ENSMUSG00000018068', u'ENSMUSG00000032399', u'ENSMUSG00000032398', u'ENSMUSG00000020134', u'ENSMUSG00000032405', u'ENSMUSG00000032402', u'ENSMUSG00000018593', u'ENSMUSG00000033970', u'ENSMUSG00000032409', u'ENSMUSG00000020052', u'ENSMUSG00000075256', u'ENSMUSG00000038489', u'ENSMUSG00000000708', u'ENSMUSG00000028191', u'ENSMUSG00000002968', u'ENSMUSG00000044770', u'ENSMUSG00000039457', u'ENSMUSG00000002963', u'ENSMUSG00000021987', u'ENSMUSG00000048402', u'ENSMUSG00000039850', u'ENSMUSG00000039852', u'ENSMUSG00000047721', u'ENSMUSG00000002846', u'ENSMUSG00000036097', u'ENSMUSG00000036098', u'ENSMUSG00000036099', u'ENSMUSG00000017264', u'ENSMUSG00000021871', u'ENSMUSG00000032577', u'ENSMUSG00000054693', u'ENSMUSG00000018287', u'ENSMUSG00000018286', u'ENSMUSG00000028426', u'ENSMUSG00000021500', u'ENSMUSG00000022760', u'ENSMUSG00000024026', u'ENSMUSG00000038855', u'ENSMUSG00000037876', u'ENSMUSG00000005262', u'ENSMUSG00000025104', u'ENSMUSG00000018841', u'ENSMUSG00000042834', u'ENSMUSG00000036278', u'ENSMUSG00000040325', u'ENSMUSG00000033285', u'ENSMUSG00000050471', u'ENSMUSG00000018849', u'ENSMUSG00000018848', u'ENSMUSG00000048416', u'ENSMUSG00000036478', u'ENSMUSG00000010067', u'ENSMUSG00000038544', u'ENSMUSG00000038546', u'ENSMUSG00000050192', u'ENSMUSG00000024985', u'ENSMUSG00000006281', u'ENSMUSG00000036270', u'ENSMUSG00000024338', u'ENSMUSG00000036273', u'ENSMUSG00000010663', u'ENSMUSG00000006288', u'ENSMUSG00000010660', u'ENSMUSG00000024620', u'ENSMUSG00000050064', u'ENSMUSG00000005267', u'ENSMUSG00000033577', u'ENSMUSG00000022972', u'ENSMUSG00000075600', u'ENSMUSG00000030956', u'ENSMUSG00000005469', u'ENSMUSG00000000148', u'ENSMUSG00000001729', u'ENSMUSG00000022978', u'ENSMUSG00000055835', u'ENSMUSG00000000142', u'ENSMUSG00000027509', u'ENSMUSG00000026667', u'ENSMUSG00000058056', u'ENSMUSG00000066148', u'ENSMUSG00000026662', u'ENSMUSG00000022974', u'ENSMUSG00000049321', u'ENSMUSG00000001924', u'ENSMUSG00000027132', u'ENSMUSG00000062397', u'ENSMUSG00000031665', u'ENSMUSG00000026669', u'ENSMUSG00000005481', u'ENSMUSG00000024805', u'ENSMUSG00000005483', u'ENSMUSG00000039706', u'ENSMUSG00000024800', u'ENSMUSG00000039703', u'ENSMUSG00000068267', u'ENSMUSG00000028530', u'ENSMUSG00000030002', u'ENSMUSG00000001034', u'ENSMUSG00000030714', u'ENSMUSG00000024240', u'ENSMUSG00000027598', u'ENSMUSG00000038384', u'ENSMUSG00000034460', u'ENSMUSG00000020901', u'ENSMUSG00000020900', u'ENSMUSG00000027223', u'ENSMUSG00000039456', u'ENSMUSG00000027597', u'ENSMUSG00000023236', u'ENSMUSG00000015755', u'ENSMUSG00000015757', u'ENSMUSG00000000037', u'ENSMUSG00000067071', u'ENSMUSG00000043909', u'ENSMUSG00000050323', u'ENSMUSG00000038495', u'ENSMUSG00000037458', u'ENSMUSG00000038722', u'ENSMUSG00000030138', u'ENSMUSG00000033623', u'ENSMUSG00000039630', u'ENSMUSG00000001847', u'ENSMUSG00000041852', u'ENSMUSG00000029634', u'ENSMUSG00000031996', u'ENSMUSG00000041126', u'ENSMUSG00000005732', u'ENSMUSG00000041859', u'ENSMUSG00000056209', u'ENSMUSG00000040586', u'ENSMUSG00000040857', u'ENSMUSG00000026663', u'ENSMUSG00000031536', u'ENSMUSG00000031537', u'ENSMUSG00000023348', u'ENSMUSG00000050332', u'ENSMUSG00000050335', u'ENSMUSG00000035351', u'ENSMUSG00000031530', u'ENSMUSG00000041459', u'ENSMUSG00000030822', u'ENSMUSG00000027829', u'ENSMUSG00000076431', u'ENSMUSG00000034738', u'ENSMUSG00000030826', u'ENSMUSG00000040699', u'ENSMUSG00000030824', u'ENSMUSG00000040455', u'ENSMUSG00000019715', u'ENSMUSG00000014769', u'ENSMUSG00000003421', u'ENSMUSG00000031843', u'ENSMUSG00000003423', u'ENSMUSG00000039356', u'ENSMUSG00000014763', u'ENSMUSG00000014813', u'ENSMUSG00000026064', u'ENSMUSG00000014767', u'ENSMUSG00000031848', u'ENSMUSG00000051483', u'ENSMUSG00000012405', u'ENSMUSG00000029994', u'ENSMUSG00000030222', u'ENSMUSG00000030225', u'ENSMUSG00000030224', u'ENSMUSG00000029993', u'ENSMUSG00000048696', u'ENSMUSG00000021276', u'ENSMUSG00000035027', u'ENSMUSG00000021270', u'ENSMUSG00000070814', u'ENSMUSG00000040195', u'ENSMUSG00000026082', u'ENSMUSG00000029068', u'ENSMUSG00000051316', u'ENSMUSG00000031198', u'ENSMUSG00000031669', u'ENSMUSG00000031666', u'ENSMUSG00000029062', u'ENSMUSG00000031660', u'ENSMUSG00000022185', u'ENSMUSG00000004356', u'ENSMUSG00000037849', u'ENSMUSG00000046010', u'ENSMUSG00000033751', u'ENSMUSG00000057506', u'ENSMUSG00000026404', u'ENSMUSG00000004359', u'ENSMUSG00000033020', u'ENSMUSG00000049502', u'ENSMUSG00000050410', u'ENSMUSG00000043008', u'ENSMUSG00000032040', u'ENSMUSG00000022748', u'ENSMUSG00000042349', u'ENSMUSG00000031262', u'ENSMUSG00000033813', u'ENSMUSG00000069910', u'ENSMUSG00000029826', u'ENSMUSG00000027306', u'ENSMUSG00000029198', u'ENSMUSG00000042225', u'ENSMUSG00000029191', u'ENSMUSG00000031060', u'ENSMUSG00000021187', u'ENSMUSG00000029209', u'ENSMUSG00000057894', u'ENSMUSG00000009739', u'ENSMUSG00000074781', u'ENSMUSG00000031068', u'ENSMUSG00000020455', u'ENSMUSG00000020454', u'ENSMUSG00000009733', u'ENSMUSG00000048546', u'ENSMUSG00000020451', u'ENSMUSG00000029202', u'ENSMUSG00000063382', u'ENSMUSG00000026313', u'ENSMUSG00000003778', u'ENSMUSG00000028809', u'ENSMUSG00000022361', u'ENSMUSG00000022360', u'ENSMUSG00000046982', u'ENSMUSG00000028826', u'ENSMUSG00000025507', u'ENSMUSG00000017861', u'ENSMUSG00000028820', u'ENSMUSG00000015968', u'ENSMUSG00000034120', u'ENSMUSG00000007646', u'ENSMUSG00000012535', u'ENSMUSG00000015217', u'ENSMUSG00000055884', u'ENSMUSG00000045302', u'ENSMUSG00000087141', u'ENSMUSG00000029684', u'ENSMUSG00000029687', u'ENSMUSG00000056305', u'ENSMUSG00000021692', u'ENSMUSG00000021693', u'ENSMUSG00000021690', u'ENSMUSG00000027599', u'ENSMUSG00000021694', u'ENSMUSG00000039473', u'ENSMUSG00000033054', u'ENSMUSG00000028138', u'ENSMUSG00000029440', u'ENSMUSG00000023830', u'ENSMUSG00000023832', u'ENSMUSG00000028137', u'ENSMUSG00000025323', u'ENSMUSG00000028133', u'ENSMUSG00000028629', u'ENSMUSG00000025218', u'ENSMUSG00000047417', u'ENSMUSG00000034724', u'ENSMUSG00000042750', u'ENSMUSG00000025217', u'ENSMUSG00000069305', u'ENSMUSG00000027593', u'ENSMUSG00000041498', u'ENSMUSG00000069267', u'ENSMUSG00000069135', u'ENSMUSG00000035632', u'ENSMUSG00000028807', u'ENSMUSG00000020580', u'ENSMUSG00000020634', u'ENSMUSG00000023908', u'ENSMUSG00000020630', u'ENSMUSG00000023904', u'ENSMUSG00000041654', u'ENSMUSG00000068917', u'ENSMUSG00000046432', u'ENSMUSG00000071076', u'ENSMUSG00000068391', u'ENSMUSG00000034906', u'ENSMUSG00000028551', u'ENSMUSG00000028557', u'ENSMUSG00000025034', u'ENSMUSG00000025035', u'ENSMUSG00000029290', u'ENSMUSG00000038936', u'ENSMUSG00000052684', u'ENSMUSG00000034342', u'ENSMUSG00000034832', u'ENSMUSG00000034341', u'ENSMUSG00000028958', u'ENSMUSG00000034345', u'ENSMUS