/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Geometry;
import com.supermap.realspace.AnalysisMode;
import com.supermap.realspace.DisplayMode;
import com.supermap.realspace.FilteringMode;
import com.supermap.realspace.HypsometricSettingNative;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HypsometricSetting
extends InternalHandleDisposable {
    private Color m_lineColor = new Color(0, 255, 255, 255);
    private Geometry m_coverageRegion = null;

    public HypsometricSetting() {
        long l = HypsometricSettingNative.jni_New();
        this.setHandle(l, true);
    }

    protected HypsometricSetting(long handle) {
        long l = HypsometricSettingNative.jni_New2(handle);
        this.setHandle(l, true);
    }

    protected void ResetHypsometric(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("HypsometricSetting handle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() != handle) {
            HypsometricSettingNative.jni_ClearHandle(this.getHandle());
            long l = HypsometricSettingNative.jni_New2(handle);
            this.setHandle(l, true);
        }
    }

    public double getInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInterval()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return HypsometricSettingNative.jni_GetInterval(this.getHandle());
    }

    public void setInterval(double interval) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInterval()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetInterval(this.getHandle(), interval);
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_lineColor;
    }

    public void setLineColor(Color lineColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetLineColor(this.getHandle(), lineColor.getRGB());
        this.m_lineColor = lineColor;
    }

    public Geometry getCoverageRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoverageRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_coverageRegion;
    }

    public void setCoverageRegion(Geometry coverageRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoverageRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (coverageRegion == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)coverageRegion);
        if (l != 0L) {
            Geometry geometry = coverageRegion.clone();
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
            HypsometricSettingNative.jni_SetCoverRegion(this.getHandle(), l2);
            this.m_coverageRegion = geometry.clone();
        }
    }

    public double getOpacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOpacity()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return HypsometricSettingNative.jni_GetOpacity(this.getHandle());
    }

    public void setOpacity(double opacity) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpacity()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetOpacity(this.getHandle(), opacity);
    }

    public double getMinVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return HypsometricSettingNative.jni_GetMinVisibleValue(this.getHandle());
    }

    public void setMinVisibleAltitude(double minVisibleAltitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetMinVisibleValue(this.getHandle(), minVisibleAltitude);
    }

    public double getMaxVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return HypsometricSettingNative.jni_GetMaxVisibleValue(this.getHandle());
    }

    public void setMaxVisibleAltitude(double maxVisibleAltitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetMaxVisibleValue(this.getHandle(), maxVisibleAltitude);
    }

    public void setColorDictTable(HashMap<Double, Color> colorTable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorDictTable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = colorTable.size();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        Set<Map.Entry<Double, Color>> set = colorTable.entrySet();
        Iterator<Map.Entry<Double, Color>> iterator = set.iterator();
        Map.Entry<Double, Color> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            nArray[i] = entry.getValue().getRGB();
        }
        HypsometricSettingNative.jni_SetColorDictTable(this.getHandle(), dArray, nArray);
    }

    public HashMap<Double, Color> getColorDictTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorDictTable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Double, Color> hashMap = new HashMap<Double, Color>();
        double[] dArray = HypsometricSettingNative.jni_GetColorTable_Keys(this.getHandle());
        int[] nArray = HypsometricSettingNative.jni_GetColotTable_Colors(this.getHandle());
        for (int i = 0; i < dArray.length; ++i) {
            hashMap.put(dArray[i], new Color(nArray[i], true));
        }
        return hashMap;
    }

    public DisplayMode getDisplayMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = HypsometricSettingNative.jni_GetDisplayMode(this.getHandle());
        return (DisplayMode)InternalEnum.parseUGCValue(DisplayMode.class, n);
    }

    public void setDisplayMode(DisplayMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetDisplayMode(this.getHandle(), mode.value());
    }

    public AnalysisMode getAnalysisMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalysisMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = HypsometricSettingNative.jni_GetAnalstMode(this.getHandle());
        return (AnalysisMode)InternalEnum.parseUGCValue(AnalysisMode.class, n);
    }

    public void setAnalysisMode(AnalysisMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalysisMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetAnalstMode(this.getHandle(), mode.value());
    }

    public FilteringMode getFilteringMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFilteringMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = HypsometricSettingNative.jni_GetFilteringMode(this.getHandle());
        return (FilteringMode)InternalEnum.parseUGCValue(FilteringMode.class, n);
    }

    public void setFilteringMode(FilteringMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFilteringMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HypsometricSettingNative.jni_SetFilteringMode(this.getHandle(), mode.value());
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            HypsometricSettingNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }
}

