/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.DatasetGrid;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point3D;
import com.supermap.realspace.AnalysisMode;
import com.supermap.realspace.DisplayMode;
import com.supermap.realspace.HypsometricSetting;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.ModifyTerrainSetting;
import com.supermap.realspace.Scene;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.SlopeDisplayMode;
import com.supermap.realspace.SlopeSetting;
import com.supermap.realspace.TerrainLayer;
import com.supermap.realspace.TerrainLayerAddedEvent;
import com.supermap.realspace.TerrainLayerAddedListener;
import com.supermap.realspace.TerrainLayerCaptionChangedEvent;
import com.supermap.realspace.TerrainLayerCaptionChangedListener;
import com.supermap.realspace.TerrainLayerRemovedEvent;
import com.supermap.realspace.TerrainLayerRemovedListener;
import com.supermap.realspace.TerrainLayerVisibleChangedEvent;
import com.supermap.realspace.TerrainLayerVisibleChangedListener;
import com.supermap.realspace.TerrainLayersNative;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;

public class TerrainLayers
extends InternalHandle {
    private ArrayList<TerrainLayer> m_terrainLayers;
    private Scene m_scene;
    private ModifyTerrainSetting m_modifyTerrainSetting;
    private SlopeSetting slopeSetting;
    private HypsometricSetting setting;
    transient Vector m_terrainLayerAddedListeners;
    transient Vector m_terrainLayerRemovedListeners;
    transient Vector m_terrainLayerCaptionChangedListener;
    transient Vector m_terrainLayerVisibleChangedListener;

    TerrainLayers(Scene scene, long handle) {
        this.setHandle(handle);
        this.m_scene = scene;
        this.m_terrainLayers = new ArrayList();
        this.slopeSetting = new SlopeSetting();
        this.slopeSetting.setDisplayStyle(SlopeDisplayMode.NONE);
        this.setting = new HypsometricSetting();
        this.setting.setAnalysisMode(AnalysisMode.CONTOUR_MAP);
        this.setting.setDisplayMode(DisplayMode.NONE);
        long[] lArray = TerrainLayersNative.jni_refleshFromUGC(handle);
        for (int i = 0; i < lArray.length; ++i) {
            TerrainLayer terrainLayer = TerrainLayer.createInstance(this.m_scene, lArray[i]);
            this.m_terrainLayers.add(terrainLayer);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_terrainLayers.size();
    }

    public TerrainLayer get(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayer terrainLayer = null;
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = this.indexOf(name);
        }
        if (n != -1) {
            terrainLayer = this.m_terrainLayers.get(n);
        }
        return terrainLayer;
    }

    public TerrainLayer get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_terrainLayers.get(index);
    }

    public TerrainLayer add(String file, boolean addToHead) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        File file2 = new File(file);
        if (!file2.exists() || !file.toUpperCase().endsWith(".SCT") && !file.toUpperCase().endsWith(".SCI")) {
            String string = InternalResource.loadString("add(String file, boolean addToHead)", "TerrainLayers_ThePathOfFileIsInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayer terrainLayer = null;
        if (file != null && file.trim().length() != 0 && (l = TerrainLayersNative.jni_add(InternalHandle.getHandle((InternalHandle)this.m_scene), file, addToHead)) != 0L) {
            terrainLayer = TerrainLayer.createInstance(this.m_scene, l);
            this.m_terrainLayers.add(terrainLayer);
            if (addToHead) {
                this.moveToTop(this.m_terrainLayers.size() - 1);
            }
            if (this.m_scene != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(String file, boolean addToHead, String name) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        File file2 = new File(file);
        if (!file2.exists() || !file.toUpperCase().endsWith(".SCT") && !file.toUpperCase().endsWith(".SCI")) {
            String string = InternalResource.loadString("add(String file, boolean addToHead)", "TerrainLayers_ThePathOfFileIsInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(name) != -1) {
            String string = InternalResource.loadString("name", "TerrainLayers_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        TerrainLayer terrainLayer = null;
        if (file != null && file.trim().length() != 0 && (l = TerrainLayersNative.jni_AddWithName(InternalHandle.getHandle((InternalHandle)this.m_scene), file, addToHead, name)) != 0L) {
            terrainLayer = TerrainLayer.createInstance(this.m_scene, l);
            this.m_terrainLayers.add(terrainLayer);
            if (addToHead) {
                this.moveToTop(this.m_terrainLayers.size() - 1);
            }
            if (this.m_scene != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(DatasetGrid dataset, boolean addToHead) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(DatasetGrid  dataset, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        TerrainLayer terrainLayer = null;
        long l2 = TerrainLayersNative.jni_addDataset(InternalHandle.getHandle((InternalHandle)this.m_scene), string, addToHead);
        if (l2 != 0L) {
            terrainLayer = TerrainLayer.createInstance(this.m_scene, l2);
            this.m_terrainLayers.add(terrainLayer);
            if (addToHead) {
                this.moveToTop(this.m_terrainLayers.size() - 1);
            }
            if (this.m_scene != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(DatasetGrid dataset, boolean addToHead, String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(DatasetGrid dataset, boolean addToHead, String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        TerrainLayer terrainLayer = this.add(dataset, addToHead);
        if (terrainLayer != null) {
            terrainLayer.setName(name);
        }
        return terrainLayer;
    }

    public TerrainLayer add(String file, boolean addToHead, String name, String password) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        File file2 = new File(file);
        if (!file2.exists() || !file.toUpperCase().endsWith(".SCT") && !file.toUpperCase().endsWith(".SCI")) {
            String string = InternalResource.loadString("add(String file, boolean addToHead)", "TerrainLayers_ThePathOfFileIsInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(name) != -1) {
            String string = InternalResource.loadString("name", "TerrainLayers_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        TerrainLayer terrainLayer = null;
        if (file != null && file.trim().length() != 0 && (l = TerrainLayersNative.jni_AddWithPassword(InternalHandle.getHandle((InternalHandle)this.m_scene), file, addToHead, name, password)) != 0L) {
            terrainLayer = TerrainLayer.createInstance(this.m_scene, l);
            this.m_terrainLayers.add(terrainLayer);
            if (addToHead) {
                this.moveToTop(this.m_terrainLayers.size() - 1);
            }
            if (this.m_scene != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(String iserverURL, String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (iserverURL == null || iserverURL.trim().length() == 0) {
            String string = InternalResource.loadString("iserverURL", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(name) != -1) {
            String string = InternalResource.loadString("name", "TerrainLayers_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        TerrainLayer terrainLayer = null;
        long l = TerrainLayersNative.jni_AddIserver(InternalHandle.getHandle((InternalHandle)this.m_scene), iserverURL, name);
        if (l != 0L) {
            terrainLayer = TerrainLayer.createInstance(this.m_scene, l);
            this.m_terrainLayers.add(terrainLayer);
            this.moveToTop(this.m_terrainLayers.size() - 1);
            if (this.m_scene != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(index).getName();
        boolean bl = false;
        bl = TerrainLayersNative.jni_remove(this.getHandle(), InternalHandle.getHandle((InternalHandle)this.m_scene), index);
        if (bl) {
            TerrainLayer terrainLayer = this.m_terrainLayers.get(index);
            terrainLayer.clearHandle();
            this.m_terrainLayers.remove(index);
        }
        return bl;
    }

    public boolean remove(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = this.indexOf(name);
        }
        boolean bl = false;
        if (n != -1 && (bl = TerrainLayersNative.jni_remove(this.getHandle(), InternalHandle.getHandle((InternalHandle)this.m_scene), n))) {
            TerrainLayer terrainLayer = this.m_terrainLayers.get(n);
            terrainLayer.clearHandle();
            this.m_terrainLayers.remove(n);
            if (this.m_scene != null) {
                SceneNative.jni_RemoveTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
                TerrainLayerRemovedEvent terrainLayerRemovedEvent = new TerrainLayerRemovedEvent((Object)this, terrainLayer, n, name);
                this.fireTerrainLayerRemoved(terrainLayerRemovedEvent);
            }
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayersNative.jni_clear(this.getHandle());
        if (this.m_terrainLayers != null) {
            int n = this.m_terrainLayers.size();
            for (int i = 0; i < n; ++i) {
                TerrainLayer terrainLayer = this.m_terrainLayers.get(i);
                terrainLayer.clearHandle();
            }
            this.m_terrainLayers.clear();
        }
    }

    public int indexOf(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = TerrainLayersNative.jni_indexOf(this.getHandle(), name);
        }
        return n;
    }

    public boolean contains(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = this.indexOf(name);
        }
        boolean bl = false;
        if (n != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean moveToTop(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToTop(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (index != 0) {
            bl = this.moveTo(index, 0);
        }
        return bl;
    }

    public boolean moveToBottom(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToBottom(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (index != this.getCount() - 1) {
            bl = this.moveTo(index, this.getCount() - 1);
        }
        return bl;
    }

    public boolean moveUp(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveUp(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (index != 0) {
            bl = this.moveTo(index, index - 1);
        }
        return bl;
    }

    public boolean moveDown(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveDown(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (index != this.getCount() - 1) {
            bl = this.moveTo(index, index + 1);
        }
        return bl;
    }

    public boolean moveTo(int sourceIndex, int targetIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int sourceIndex, int targetIndex)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (sourceIndex < 0 || sourceIndex >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (targetIndex < 0 || targetIndex >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = targetIndex - sourceIndex;
        boolean bl = false;
        bl = n == 0 ? true : TerrainLayersNative.jni_moveTo(InternalHandle.getHandle((InternalHandle)this.m_scene), sourceIndex, n);
        if (bl) {
            TerrainLayer terrainLayer = this.m_terrainLayers.get(sourceIndex);
            this.m_terrainLayers.remove(sourceIndex);
            this.m_terrainLayers.add(targetIndex, terrainLayer);
            if (this.m_scene != null) {
                SceneNative.jni_RemoveTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
            }
        }
        return bl;
    }

    public ModifyTerrainSetting getModifyTerrainSetting() {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_modifyTerrainSetting == null) {
            this.m_modifyTerrainSetting = new ModifyTerrainSetting(l);
        }
        return this.m_modifyTerrainSetting;
    }

    public Calendar getHistory() {
        String[] stringArray;
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        GregorianCalendar gregorianCalendar = null;
        String string = SceneNative.jni_GetTINTerrainHistory(l);
        if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
            String[] stringArray2 = stringArray[0].trim().split("-");
            String[] stringArray3 = stringArray[1].trim().split(":");
            int n = Integer.parseInt(stringArray2[0]);
            int n2 = Integer.parseInt(stringArray2[1]);
            int n3 = Integer.parseInt(stringArray2[2]);
            int n4 = Integer.parseInt(stringArray3[0]);
            int n5 = Integer.parseInt(stringArray3[1]);
            int n6 = Integer.parseInt(stringArray3[2]);
            gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
        }
        return gregorianCalendar;
    }

    public void setHistory(Calendar value) {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", value);
        SceneNative.jni_SetTINTerrainHistory(l, string);
    }

    public TerrainLayer addSTK(String stkURL, String customLayerName) {
        if (this.m_terrainLayers == null) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (customLayerName == null || customLayerName.trim().length() == 0) {
            String string = InternalResource.loadString("customLayerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.contains(customLayerName)) {
            String string = InternalResource.loadString("customLayerName", "TerrainLayers_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (stkURL == null) {
            String string = InternalResource.loadString("stkURL", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        TerrainLayer terrainLayer = null;
        long l = TerrainLayersNative.jni_AddSTK(InternalHandle.getHandle((InternalHandle)this.m_scene), stkURL, customLayerName);
        if (l != 0L) {
            terrainLayer = TerrainLayer.createInstance(this.m_scene, l);
            this.m_terrainLayers.add(terrainLayer);
            if (this.m_scene != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public synchronized void addTerrainLayerAddedListener(TerrainLayerAddedListener l) {
        if (this.m_terrainLayerAddedListeners == null) {
            this.m_terrainLayerAddedListeners = new Vector();
        }
        if (!this.m_terrainLayerAddedListeners.contains(l)) {
            this.m_terrainLayerAddedListeners.add(l);
        }
    }

    public synchronized void removeTerrainLayerAddedListener(TerrainLayerAddedListener l) {
        if (this.m_terrainLayerAddedListeners != null && this.m_terrainLayerAddedListeners.contains(l)) {
            this.m_terrainLayerAddedListeners.remove(l);
        }
    }

    protected void fireTerrainLayerAdded(TerrainLayerAddedEvent event) {
        if (this.m_terrainLayerAddedListeners != null) {
            Vector vector = this.m_terrainLayerAddedListeners;
            int n = this.m_terrainLayerAddedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerAddedListener)vector.elementAt(i)).terrainLayerAdded(event);
            }
        }
    }

    public synchronized void addTerrainLayerRemovedListener(TerrainLayerRemovedListener l) {
        if (this.m_terrainLayerRemovedListeners == null) {
            this.m_terrainLayerRemovedListeners = new Vector();
        }
        if (!this.m_terrainLayerRemovedListeners.contains(l)) {
            this.m_terrainLayerRemovedListeners.add(l);
        }
    }

    public synchronized void removeTerrainLayerRemovedListener(TerrainLayerRemovedListener l) {
        if (this.m_terrainLayerRemovedListeners != null && this.m_terrainLayerRemovedListeners.contains(l)) {
            this.m_terrainLayerRemovedListeners.remove(l);
        }
    }

    protected void fireTerrainLayerRemoved(TerrainLayerRemovedEvent event) {
        if (this.m_terrainLayerRemovedListeners != null) {
            Vector vector = this.m_terrainLayerRemovedListeners;
            int n = this.m_terrainLayerRemovedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerRemovedListener)vector.elementAt(i)).terrainLayerRemoved(event);
            }
        }
    }

    public synchronized void addTerrainLayerCaptionChangedListener(TerrainLayerCaptionChangedListener l) {
        if (this.m_terrainLayerCaptionChangedListener == null) {
            this.m_terrainLayerCaptionChangedListener = new Vector();
        }
        if (!this.m_terrainLayerCaptionChangedListener.contains(l)) {
            this.m_terrainLayerCaptionChangedListener.add(l);
        }
    }

    public synchronized void removeTerrainLayerCaptionChangedListener(TerrainLayerCaptionChangedListener l) {
        if (this.m_terrainLayerCaptionChangedListener != null && this.m_terrainLayerCaptionChangedListener.contains(l)) {
            this.m_terrainLayerCaptionChangedListener.remove(l);
        }
    }

    protected void fireCaptionChanged(TerrainLayerCaptionChangedEvent event) {
        if (this.m_terrainLayerCaptionChangedListener != null) {
            Vector vector = this.m_terrainLayerCaptionChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerCaptionChangedListener)vector.elementAt(i)).captionChanged(event);
            }
        }
    }

    public synchronized void addTerrainLayerVisibleChangedListener(TerrainLayerVisibleChangedListener l) {
        if (this.m_terrainLayerVisibleChangedListener == null) {
            this.m_terrainLayerVisibleChangedListener = new Vector();
        }
        if (!this.m_terrainLayerVisibleChangedListener.contains(l)) {
            this.m_terrainLayerVisibleChangedListener.add(l);
        }
    }

    public synchronized void removeTerrainLayerVisibleChangedListener(TerrainLayerVisibleChangedListener l) {
        if (this.m_terrainLayerVisibleChangedListener != null && this.m_terrainLayerVisibleChangedListener.contains(l)) {
            this.m_terrainLayerVisibleChangedListener.remove(l);
        }
    }

    protected void fireVisibleChanged(TerrainLayerVisibleChangedEvent event) {
        if (this.m_terrainLayerVisibleChangedListener != null) {
            Vector vector = this.m_terrainLayerVisibleChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(event);
            }
        }
    }

    public SlopeSetting getSlopeSetting() {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l2 = TerrainLayersNative.jni_GetSlopeSetting(InternalHandle.getHandle((InternalHandle)this.m_scene));
        if (l2 == 0L) {
            return null;
        }
        return this.slopeSetting;
    }

    public void setSlopeSetting(SlopeSetting slopeSetting) {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (slopeSetting == null) {
            return;
        }
        long l2 = InternalHandle.getHandle((InternalHandle)slopeSetting);
        TerrainLayersNative.jni_SetSlopeSetting(InternalHandle.getHandle((InternalHandle)this.m_scene), l2);
        this.slopeSetting = slopeSetting;
    }

    public HypsometricSetting getHypsometricSetting() {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l2 = TerrainLayersNative.jni_GetHypsometricSetting(InternalHandle.getHandle((InternalHandle)this.m_scene));
        if (l2 == 0L) {
            return null;
        }
        return this.setting;
    }

    public void setHypsometricSetting(HypsometricSetting hypsometricSetting) {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("TerrainLayers", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (hypsometricSetting == null) {
            return;
        }
        long l2 = InternalHandle.getHandle((InternalHandle)hypsometricSetting);
        TerrainLayersNative.jni_SetHypsometricSetting(InternalHandle.getHandle((InternalHandle)this.m_scene), l2);
        this.setting = hypsometricSetting;
    }

    public double getSlopeValue(Point3D point3d) {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("getSlopeValue", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayersNative.jni_GetSlopeValue(InternalHandle.getHandle((InternalHandle)this.m_scene), point3d.getX(), point3d.getY(), point3d.getZ());
    }

    protected static TerrainLayers createInstance(Scene scene, long handle) {
        return new TerrainLayers(scene, handle);
    }

    protected void clearHandle() {
        for (int i = 0; i < this.m_terrainLayers.size(); ++i) {
            this.m_terrainLayers.get(i).clearHandle();
        }
        this.m_terrainLayers = null;
        this.setHandle(0L);
    }

    public boolean isNormalEnable() {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("isNormalEnable", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayersNative.jni_IsNormalEnable(InternalHandle.getHandle((InternalHandle)this.m_scene));
    }

    public void setNormalEnable(boolean isNormalEnable) {
        boolean bl = this.m_scene == null || InternalHandle.getHandle((InternalHandle)this.m_scene) == 0L;
        long l = 0L;
        if (!bl) {
            l = SceneNative.jni_GetGlobalTINTerrain(InternalHandle.getHandle((InternalHandle)this.m_scene));
            boolean bl2 = bl = l == 0L;
        }
        if (bl) {
            String string = InternalResource.loadString("setNormalEnable", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayersNative.jni_SetNormalEnable(InternalHandle.getHandle((InternalHandle)this.m_scene), isNormalEnable);
    }
}

